/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.ctl.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.headfootdesigner.HeadFootModel;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.util.CtrlFormatUtilities;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMFilterBaseUI;
import com.kingdee.eas.fm.ctl.client.AbstractAssureBillDetailReportUI;
import com.kingdee.eas.fm.ctl.client.AssureBillDetailFilterParam;
import com.kingdee.eas.fm.ctl.client.AssureBillDetailFilterUI;
import com.kingdee.eas.fm.ctl.client.AssureBillDetailReportBaseHandler;
import com.kingdee.eas.fm.ctl.client.AssureBillDetailReportByAssureTypeHandler;
import com.kingdee.eas.fm.ctl.client.AssureBillDetailReportByBankHandler;
import com.kingdee.eas.fm.ctl.client.AssureBillDetailReportByCompanyHandler;
import com.kingdee.eas.fm.nt.client.RptPayableBillDetailMainUI;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.sql.SQLException;
import java.text.DateFormat;
import java.util.Map;

public class AssureBillDetailReportUI
extends AbstractAssureBillDetailReportUI {
    private AssureBillDetailFilterUI filterUI;

    protected KDTable getMainTable() {
        return this.tblMain;
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnViewDetail.setIcon(EASResource.getIcon((String)"imgTbtn_sequencecheck"));
    }

    protected void execQuery() throws BOSException {
        AssureBillDetailReportBaseHandler handler = null;
        this.tblMain.checkParsed();
        AssureBillDetailFilterParam filterParam = (AssureBillDetailFilterParam)this.getFilterParam();
        this.showHead(filterParam);
        int groupType = filterParam.getGroupType();
        switch (groupType) {
            case 1: {
                handler = new AssureBillDetailReportByBankHandler(this.tblMain, filterParam);
                break;
            }
            case 0: {
                handler = new AssureBillDetailReportByCompanyHandler(this.tblMain, filterParam);
                break;
            }
            case 2: {
                handler = new AssureBillDetailReportByAssureTypeHandler(this.tblMain, filterParam);
                break;
            }
            default: {
                return;
            }
        }
        handler.initHeader();
        handler.setTableStateRow();
        IRowSet rs = handler.getRowSet();
        try {
            handler.filldata(rs);
        }
        catch (EASBizException e) {
            this.handUIExceptionAndAbort((Exception)((Object)e));
        }
        catch (BOSException e) {
            this.handUIExceptionAndAbort((Exception)((Object)e));
        }
        catch (SQLException e) {
            this.handUIExceptionAndAbort(e);
        }
        handler.endDataFill();
        String dformat = FMHelper.getDateFormatString();
        this.tblMain.getColumn("beginDate").getStyleAttributes().setNumberFormat(dformat);
        this.tblMain.getColumn("endDate").getStyleAttributes().setNumberFormat(dformat);
        this.tblMain.getColumn("assureBeginDate").getStyleAttributes().setNumberFormat(dformat);
        this.tblMain.getColumn("assureEndDate").getStyleAttributes().setNumberFormat(dformat);
        this.tblMain.getColumn("recordDate").getStyleAttributes().setNumberFormat(dformat);
    }

    private void showHead(AssureBillDetailFilterParam filterParam) {
        DateFormat dtformat = CtrlFormatUtilities.getDateFormat();
        if (filterParam.getBeginDate() != null) {
            this.txtBeginDate.setText(dtformat.format(filterParam.getBeginDate()));
        } else {
            this.txtBeginDate.setText(null);
        }
        if (filterParam.getEndDate() != null) {
            this.txtEndDate.setText(dtformat.format(filterParam.getEndDate()));
        }
        this.lablelDesc.setText(filterParam.getDescription());
        this.txtUnit.setText(filterParam.getAmountUnit().getAlias());
    }

    public FMFilterBaseUI getFilterUI() throws Exception {
        if (this.filterUI == null) {
            this.filterUI = new AssureBillDetailFilterUI();
        }
        return this.filterUI;
    }

    @Override
    public void actionViewDetail_actionPerformed(ActionEvent e) throws Exception {
        FMClientHelper.checkSelected((Component)((Object)this), (KDTable)this.tblMain);
        int rowIndex = FMClientHelper.getSelectedRow((KDTable)this.tblMain);
        IRow row = this.tblMain.getRow(rowIndex);
        String id = (String)row.getUserObject();
        if (id == null) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
            return;
        }
        FMClientHelper.viewDetailBill((CoreUIObject)this, (String)id, (CompanyOrgUnitInfo)ContextHelperFactory.getRemoteInstance().getCurrentCompany());
    }

    protected void preparePrintPageHeader(HeadFootModel headerModel) {
        super.preparePrintPageHeader(headerModel);
        StringBuffer headSB = new StringBuffer();
        headSB.append(this.kDLabelContainer1.getBoundLabelText()).append(this.txtBeginDate.getText()).append("&|");
        headSB.append(this.kDLabelContainer2.getBoundLabelText()).append(this.txtEndDate.getText()).append("&|");
        headSB.append(this.kDLabelContainer3.getBoundLabelText()).append(this.txtUnit.getText());
        headerModel.addRow(headSB.toString());
    }

    public static void showDialogWindows(IUIObject owner, AssureBillDetailFilterParam dParam) throws UIException {
        UIContext uiContext = new UIContext((Object)owner);
        uiContext.put((Object)"isDirectShow", (Object)Boolean.TRUE);
        uiContext.put((Object)"filterParam", (Object)dParam);
        uiContext.put((Object)"Owner", (Object)owner);
        IUIWindow uiWindow = null;
        uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewTabFactory").create(RptPayableBillDetailMainUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
        uiWindow.show();
    }
}

