/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.ctl.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.fm.IContextHelper;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.bond.BondReleaseReportInfo;
import com.kingdee.eas.fm.common.client.AliasTextValueProvider;
import com.kingdee.eas.fm.common.client.ColumnUserCellDisplayParser;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMFilterBaseUI;
import com.kingdee.eas.fm.common.client.IValueProvider;
import com.kingdee.eas.fm.ctl.AssureBillUsedFactory;
import com.kingdee.eas.fm.ctl.LetterOfGuaranteeInfo;
import com.kingdee.eas.fm.ctl.client.AbstractAssureBillUsedListUI;
import com.kingdee.eas.fm.ctl.client.AssureBillUsedFilterUI;
import com.kingdee.eas.fm.fin.LetterOfCreditInfo;
import com.kingdee.eas.fm.fin.LoanInfo;
import com.kingdee.eas.fm.nt.PayableBillInfo;
import com.kingdee.eas.fm.sl.LoanFetchInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.client.EASResource;
import java.awt.Color;
import java.awt.Component;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;

public class AssureBillUsedListUI
extends AbstractAssureBillUsedListUI {
    public static final String ASSUREBILLIDMAP = "ASSUREBILLIDMAP";
    private final String FINRESOURCE = "com.kingdee.eas.fm.fin.client.FinClientResource";
    private final CurrencyInfo curencyInfo;
    private CommonQueryDialog queryDlg = null;
    private AssureBillUsedFilterUI filterUI = null;

    public AssureBillUsedListUI() throws Exception {
        IContextHelper ctxHelper = ContextHelperFactory.getRemoteInstance();
        this.curencyInfo = ctxHelper.getCompanyBaseCurrency(ctxHelper.getCurrentCompany());
        ColumnUserCellDisplayParser displayParser = new ColumnUserCellDisplayParser(this.tblMain);
        AliasTextValueProvider provider = new AliasTextValueProvider();
        provider.add((Object)LoanInfo.BOSTYPE.toString(), this.getResString("Loan"));
        provider.add((Object)new PayableBillInfo().getBOSType().toString(), this.getResString("CommercialDraft"));
        provider.add((Object)LetterOfCreditInfo.BOSTYPE.toString(), this.getResString("LetterOfCredit"));
        provider.add((Object)new LetterOfGuaranteeInfo().getBOSType().toString(), this.getResString("LetterOfGuarantee"));
        provider.add((Object)new BondReleaseReportInfo().getBOSType().toString(), this.getResString("bondReleaseReport"));
        provider.add((Object)new LoanFetchInfo().getBOSType().toString(), this.getResString("SLLoanFetch"));
        displayParser.addValueProvider("billType", (IValueProvider)provider);
    }

    protected CommonQueryDialog initCommonQueryDialog() {
        if (this.queryDlg != null) {
            return this.queryDlg;
        }
        if (this.filterUI != null) {
            this.filterUI.setListUI((IUIObject)this);
        }
        try {
            this.queryDlg = new CommonQueryDialog();
            this.queryDlg.setOwner((Component)this.getUIContext().get("Owner"));
            this.queryDlg.setParentUIClassName(this.getMetaDataPK().getFullName());
            this.queryDlg.setQueryObjectPK(this.mainQueryPK);
            this.queryDlg.setHeight(300);
            this.queryDlg.setWidth(500);
            this.queryDlg.addUserPanel((KDPanel)this.getFilterUI());
            this.queryDlg.setTitle(EASResource.getString((String)"com.kingdee.eas.fm.ctl.CTLAutoGenerateResource", (String)"73_AssureBillUsedListUI"));
            this.queryDlg.setShowSorter(false);
            this.queryDlg.setUiObject((IUIObject)this);
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        return this.queryDlg;
    }

    public FMFilterBaseUI getFilterUI() throws Exception {
        if (this.filterUI == null) {
            this.filterUI = new AssureBillUsedFilterUI();
        }
        return this.filterUI;
    }

    protected boolean initDefaultFilter() {
        return true;
    }

    private String getResString(String key) {
        return EASResource.getString((String)"com.kingdee.eas.fm.fin.client.FinClientResource", (String)key);
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
    }

    public void onLoad() throws Exception {
        String numFormat = FMClientHelper.getKDTNumFormat((int)this.curencyInfo.getPrecision());
        this.tblMain.getColumn("usedAssAmount").getStyleAttributes().setNumberFormat(numFormat);
        this.tblMain.getColumn("returnedAmount").getStyleAttributes().setNumberFormat(numFormat);
        this.tblMain.getColumn("assBalance").getStyleAttributes().setNumberFormat(numFormat);
        super.onLoad();
        this.actionTraceUp.setVisible(false);
        this.actionTraceDown.setVisible(false);
        this.tblMain.setEditable(false);
        this.tblMain.getColumn("assureBeginDate").getStyleAttributes().setNumberFormat(this.dformat);
        this.tblMain.getColumn("assureEndDate").getStyleAttributes().setNumberFormat(this.dformat);
        this.refresh(null);
    }

    private Set getIdSet(ArrayList idList) {
        HashSet idSet = new HashSet();
        if (idList != null) {
            int n = idList.size();
            for (int i = 0; i < n; ++i) {
                idSet.add(idList.get(i));
            }
        }
        return idSet;
    }

    protected void execQuery() {
        try {
            this.sumIt();
        }
        catch (EASBizException e) {
            this.handUIExceptionAndAbort((Exception)((Object)e));
        }
        catch (BOSException e) {
            this.handUIExceptionAndAbort((Exception)((Object)e));
        }
        ArrayList assureBillIdList = (ArrayList)this.getUIContext().get(ASSUREBILLIDMAP);
        Set assureBillIdSet = this.getIdSet(assureBillIdList);
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("assureBillId", (Object)assureBillIdSet, CompareType.INCLUDE));
        try {
            FilterInfo filter = this.getFilterUI().getFilterInfo();
            filterInfo.mergeFilter(filter, "AND");
            this.mainQuery.getFilter().mergeFilter(filterInfo, "AND");
            SorterItemInfo order = new SorterItemInfo("billType");
            this.mainQuery.getSorter().add(order);
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        super.execQuery();
    }

    private void sumIt() throws EASBizException, BOSException {
        this.tblMain.getDataRequestManager().setDataRequestMode(0);
        this.tblMain.getGroupManager().setGroup(true);
        this.tblMain.getGroupManager().setOrientation(1);
        this.tblMain.getColumn("billType").setGroup(true);
        this.tblMain.getColumn("billType").setStat(true);
        String numFormat = FMClientHelper.getKDTNumFormat((int)this.curencyInfo.getPrecision());
        this.tblMain.getColumn("usedAssAmount").getStyleAttributes().setNumberFormat(numFormat);
        this.tblMain.getColumn("returnedAmount").getStyleAttributes().setNumberFormat(numFormat);
        this.tblMain.getColumn("assBalance").getStyleAttributes().setNumberFormat(numFormat);
        IRow rowSumTotal = this.tblMain.getGroupManager().getStatRowTemplate(0);
        rowSumTotal.getStyleAttributes().setBackground(new Color(16119270));
        rowSumTotal.getCell("usedAssAmount").setExpressions("SUM");
        rowSumTotal.getCell("returnedAmount").setExpressions("SUM");
        rowSumTotal.getCell("assBalance").setExpressions("SUM");
        rowSumTotal.getCell("usedAssAmount").getStyleAttributes().setNumberFormat(numFormat);
        rowSumTotal.getCell("usedAssAmount").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        rowSumTotal.getCell("returnedAmount").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        rowSumTotal.getCell("assBalance").getStyleAttributes().setNumberFormat(numFormat);
        rowSumTotal.getCell("assBalance").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        rowSumTotal.getCell("finbillNumber").setValue((Object)EASResource.getString((String)"com.kingdee.eas.fm.fin.client.FinClientResource", (String)"SubTotal"));
    }

    protected void initListener() {
        super.initListener();
        this.tblMain.getDataRequestManager().addDataFillListener((KDTDataFillListener)new FillListener());
    }

    private void setListUITable(KDTable tblMain, KDTDataRequestEvent e) {
        if (e == null || e.getLastRow() == -1) {
            return;
        }
        tblMain.checkParsed();
        IRow row = null;
        String numberFormat = FMClientHelper.getNumberFtm((int)2);
        for (int i = e.getFirstRow(); i <= tblMain.getRowCount() - 1; ++i) {
            ICell assBalance;
            row = tblMain.getRow(i);
            StyleAttributes styleAttributes = row.getCell("returnedAmount").getStyleAttributes();
            styleAttributes.setNumberFormat(numberFormat);
            styleAttributes.setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
            styleAttributes = row.getCell("usedAssAmount").getStyleAttributes();
            styleAttributes.setNumberFormat(numberFormat);
            styleAttributes.setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
            styleAttributes = row.getCell("assBalance").getStyleAttributes();
            styleAttributes.setNumberFormat(numberFormat);
            styleAttributes.setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
            ICell returnedAmount = row.getCell("returnedAmount");
            if (returnedAmount.getValue() == null) {
                returnedAmount.setValue((Object)Constants.ZERO);
            }
            if ((assBalance = row.getCell("assBalance")).getValue() != null) continue;
            assBalance.setValue((Object)Constants.ZERO);
        }
    }

    protected String getEditUIName() {
        return null;
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return AssureBillUsedFactory.getRemoteInstance();
    }

    private final class FillListener
    implements KDTDataFillListener {
        private FillListener() {
        }

        public void afterDataFill(KDTDataRequestEvent e) {
            AssureBillUsedListUI.this.setListUITable(AssureBillUsedListUI.this.tblMain, e);
        }
    }
}

