/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.ctl.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.appframework.databinding.DataBinder;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTPropertyChangeEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTPropertyChangeListener;
import com.kingdee.bos.ctrl.kdf.table.foot.KDTFootManager;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.BasicFormattedTextField;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.event.CommitEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.ctrl.swing.util.CtrlFormatUtilities;
import com.kingdee.bos.dao.AbstractObjectValue;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.basedata.assistant.BankInfo;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ExchangeRateInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.client.F7SelectorFactory;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMClientVerifyHelper;
import com.kingdee.eas.fm.common.client.FMKDTableHelper;
import com.kingdee.eas.fm.ctl.BankFactorCollection;
import com.kingdee.eas.fm.ctl.BankFactorContractEntryInfo;
import com.kingdee.eas.fm.ctl.BankFactorEntryInfo;
import com.kingdee.eas.fm.ctl.BankFactorFactory;
import com.kingdee.eas.fm.ctl.BankFactorFeeEntryInfo;
import com.kingdee.eas.fm.ctl.BankFactorHelper;
import com.kingdee.eas.fm.ctl.BankFactorInfo;
import com.kingdee.eas.fm.ctl.FactorStateEnum;
import com.kingdee.eas.fm.ctl.FactorTypeEnum;
import com.kingdee.eas.fm.ctl.client.AbstractBankFactorEditUI;
import com.kingdee.eas.fm.ctl.client.util.CtlClientHelper;
import com.kingdee.eas.fm.fin.FinUtils;
import com.kingdee.eas.fm.fin.util.FinHelper;
import com.kingdee.eas.fm.nt.NTException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.client.multiDetail.DetailPanel;
import com.kingdee.eas.framework.client.multiDetail.HMDUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.DateTimeUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.math.BigDecimal;
import java.sql.Date;
import java.text.MessageFormat;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;

public class BankFactorEditUI
extends AbstractBankFactorEditUI {
    private BankFactorContractEntryInfo contractEntryInfo;
    private BankFactorEntryInfo entryInfo;
    private int feeClickedCount = 0;

    @Override
    public void loadFields() {
        super.loadFields();
        FMClientHelper.initNumber((CoreBaseInfo)((CoreBaseInfo)this.getDataObject()), (KDTextField)this.txtNumber, (String)this.currentCompany.getId().toString());
        FMClientHelper.setSelectObject((KDComboBox)this.type, (Object)((Object)this.editData.getType()));
        FMClientHelper.setSelectObject((KDComboBox)this.combocurrency, (Object)this.editData.getCurrency());
        this.txtamount.setValue((Object)this.editData.getAmount());
        this.storeFields();
        this.initOldData((IObjectValue)this.editData);
        BankFactorInfo bankFactorInfo = (BankFactorInfo)this.getDataObject();
        if (bankFactorInfo != null && bankFactorInfo.getState() != null && !bankFactorInfo.getState().equals((Object)FactorStateEnum.SAVE)) {
            this.actionSave.setEnabled(false);
        }
    }

    @Override
    public void storeFields() {
        try {
            this.pkissueDate.commitEdit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            this.pkissueDate.commitEdit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.editData.setMortgageRate(this.txtMortgageRate.getBigDecimalValue());
        super.storeFields();
    }

    protected void checkBizUnit() throws EASBizException, BOSException {
        if (ContextHelperFactory.getRemoteInstance().isOnlyUnion(this.currentCompany)) {
            this.actionAddNew.setVisible(false);
            this.actionEdit.setVisible(false);
            this.actionCopy.setVisible(false);
            this.actionRemove.setVisible(false);
        }
        if (OprtState.ADDNEW.equals(this.getOprtState())) {
            this.actionCopy.setEnabled(false);
        }
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("creator.*"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("description"));
        sic.add(new SelectorItemInfo("contactNumber"));
        sic.add(new SelectorItemInfo("bank.*"));
        sic.add(new SelectorItemInfo("type"));
        sic.add(new SelectorItemInfo("bankAcct.*"));
        sic.add(new SelectorItemInfo("oppAcct.*"));
        sic.add(new SelectorItemInfo("amount"));
        sic.add(new SelectorItemInfo("rate"));
        sic.add(new SelectorItemInfo("amountLocal"));
        sic.add(new SelectorItemInfo("issueDate"));
        sic.add(new SelectorItemInfo("expireDate"));
        sic.add(new SelectorItemInfo("loanAmount"));
        sic.add(new SelectorItemInfo("loanBalance"));
        sic.add(new SelectorItemInfo("applicant.*"));
        sic.add(new SelectorItemInfo("currency"));
        sic.add(new SelectorItemInfo("FeeEntry.rate"));
        sic.add(new SelectorItemInfo("FeeEntry.*"));
        sic.add(new SelectorItemInfo("FeeEntry.amount"));
        sic.add(new SelectorItemInfo("FeeEntry.currency.*"));
        sic.add(new SelectorItemInfo("FeeEntry.exRate"));
        sic.add(new SelectorItemInfo("FeeEntry.amountLocal"));
        sic.add(new SelectorItemInfo("FeeEntry.remark"));
        sic.add(new SelectorItemInfo("FeeEntry.id"));
        sic.add(new SelectorItemInfo("FeeEntry.fee.*"));
        sic.add(new SelectorItemInfo("FeeEntry.billNumber"));
        sic.add(new SelectorItemInfo("entrys.id"));
        sic.add(new SelectorItemInfo("entrys.*"));
        sic.add(new SelectorItemInfo("entrys.date"));
        sic.add(new SelectorItemInfo("entrys.amount"));
        sic.add(new SelectorItemInfo("ContractEntry.client.*"));
        sic.add(new SelectorItemInfo("ContractEntry.*"));
        sic.add(new SelectorItemInfo("ContractEntry.number"));
        sic.add(new SelectorItemInfo("ContractEntry.amount"));
        sic.add(new SelectorItemInfo("ContractEntry.remark"));
        sic.add(new SelectorItemInfo("ContractEntry.id"));
        sic.add(new SelectorItemInfo("ContractEntry.payAmt"));
        sic.add(new SelectorItemInfo("ContractEntry.billNumber"));
        sic.add(new SelectorItemInfo("ContractEntry.factorAmt"));
        sic.add(new SelectorItemInfo("mortgageRate"));
        sic.add(new SelectorItemInfo("state"));
        return sic;
    }

    public void onLoad() throws Exception {
        BankFactorInfo info;
        if (!this.currentCompany.isIsBizUnit() && (OprtState.ADDNEW.equals(this.getOprtState()) || OprtState.EDIT.equals(this.getOprtState()))) {
            throw new NTException(NTException.CHANGE_TO_BIZUNIT);
        }
        this.checkBizUnit();
        FMClientHelper.initComboCurrency((KDComboBox)this.combocurrency, (boolean)true);
        this.baseCurrency = FMClientHelper.getCurrencyInfo((BOSUuid)this.baseCurrency.getId());
        int pre = this.baseCurrency.getPrecision();
        this.txtamount.setPrecision(pre);
        this.txtamount.setNegatived(false);
        this.txtamountLocal.setPrecision(pre);
        this.txtamountLocal.setNegatived(false);
        this.txtloanAmount.setPrecision(pre);
        this.txtloanBalance.setPrecision(pre);
        this.txtrate.setNegatived(false);
        this.txtMortgageRate.setNegatived(false);
        this.txtMortgageRate.setPrecision(2);
        this.txtMortgageRate.setRemoveingZeroInDispaly(false);
        FMClientHelper.initCurrencyField((BasicFormattedTextField)this.txtamount);
        FMClientHelper.initCurrencyField((BasicFormattedTextField)this.txtamountLocal);
        FMClientHelper.initCurrencyField((BasicFormattedTextField)this.txtloanAmount);
        FMClientHelper.initCurrencyField((BasicFormattedTextField)this.txtloanBalance);
        FMClientHelper.initDecimalField((BasicFormattedTextField)this.txtrate);
        this.resetUI();
        super.onLoad();
        this.initEntrysTable();
        F7SelectorFactory.initBankTree((IUIObject)this, (KDBizPromptBox)this.prmtbank, (boolean)true);
        CtlClientHelper.initPrmtBankAcct((IUIObject)this, this.prmtbankAcct, this.currentCompany, null, null);
        CtlClientHelper.initPrmtAcctView((IUIObject)this, this.prmtoppAcct, this.currentCompany, null);
        this.txtMortgageRate.setPrecision(2);
        this.txtMortgageRate.setMinimumValue((Comparable)new BigDecimal("0.00"));
        this.txtMortgageRate.setMaximumValue((Comparable)new BigDecimal("100.00"));
        if (BankFactorHelper.isCanEditFromParam() && null != this.editData.getId() && BankFactorHelper.isCanEditFromAudit(info = BankFactorFactory.getRemoteInstance().getBankFactorInfo((IObjectPK)new ObjectUuidPK(this.editData.getId()))) && !OprtState.VIEW.equals(this.getOprtState())) {
            this.editData();
        }
        this.setFactorAmtPrecision();
    }

    public void editData() {
        this.contNumber.setEnabled(false);
        this.prmtbank.setEnabled(false);
        this.prmtbankAcct.setEnabled(false);
        this.txtamount.setEnabled(false);
        this.txtrate.setEnabled(false);
        this.txtloanAmount.setEnabled(false);
        this.txtDescription.setEnabled(false);
        this.txtcontactNumber.setEnabled(false);
        this.type.setEnabled(false);
        this.prmtoppAcct.setEnabled(false);
        this.combocurrency.setEnabled(false);
        this.txtamountLocal.setEnabled(false);
        this.txtloanBalance.setEnabled(false);
        this.txtMortgageRate.setEnabled(false);
        this.tabPane.setSelectedComponent((Component)this.panlContract);
        this.tabPane.setEnabledAt(0, true);
        this.tabPane.setEnabledAt(1, false);
        this.tabPane.setEnabledAt(2, false);
        this.panlContract.setEnabled(false);
        this.btnInsertLine.setEnabled(false);
        this.btnAddLine.setEnabled(false);
        this.btnRemoveLine.setEnabled(false);
        this.kdtContractEntry.setEditable(false);
        this.kdtContractEntry.setEnabled(false);
        this.kdtContractEntry.getStyleAttributes().setLocked(true);
        if (this.panlContract.getComponents() != null && this.panlContract.getComponents().length == 1) {
            DetailPanel detailPanel = (DetailPanel)this.panlContract.getComponents()[0];
            detailPanel.getAddNewLineButton().setEnabled(false);
            detailPanel.getInsertLineButton().setEnabled(false);
            detailPanel.getRemoveLinesButton().setEnabled(false);
        }
    }

    @Override
    public void initUIContentLayout() {
        super.initUIContentLayout();
        KDBizPromptBox prmtClient = new KDBizPromptBox();
        prmtClient.setQueryInfo("com.kingdee.eas.basedata.master.cssp.app.CustomerInfoQuery");
        prmtClient.setDisplayFormat("$number$");
        prmtClient.setEditFormat("$number$");
        prmtClient.setCommitFormat("$number$");
        FMClientHelper.setCustomerF7((CoreUI)this, (KDBizPromptBox)prmtClient, (boolean)false, null);
        KDTDefaultCellEditor editor = new KDTDefaultCellEditor((IKDEditor)prmtClient);
        this.kdtContractEntry.getColumn("client").setEditor((ICellEditor)editor);
    }

    public void onShow() throws Exception {
        super.onShow();
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        if (this.editData.getId() != null) {
            boolean hasWf = FMHelper.hasWFInstance(null, (String)this.editData.getId().toString());
            if (hasWf) {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.ctl.CTLAutoGenerateResource", (String)"97_GuaranteeApplyListUI"));
                this.abort();
            }
            super.actionRemove_actionPerformed(e);
        }
    }

    protected void initDataStatus() {
        super.initDataStatus();
        this.actionCreateFrom.setVisible(false);
        this.actionCreateTo.setVisible(false);
        this.actionPrint.setVisible(false);
        this.actionPrintPreview.setVisible(false);
        this.actionCopyFrom.setVisible(false);
        if (OprtState.ADDNEW.equals(this.getOprtState())) {
            this.txtNumber.setRequired(this.txtNumber.isEnabled());
            this.txtloanAmount.setEnabled(false);
            this.txtloanBalance.setEnabled(false);
        } else if (OprtState.EDIT.equals(this.getOprtState())) {
            this.txtloanAmount.setEnabled(false);
            this.txtloanBalance.setEnabled(false);
            try {
                BankFactorInfo bankFactorInfo;
                if (!EmptyUtil.isEmpty((CoreBaseInfo)this.editData) && null != this.editData.getId() && BankFactorHelper.isCanEditFromAudit(bankFactorInfo = BankFactorFactory.getRemoteInstance().getBankFactorInfo((IObjectPK)new ObjectUuidPK(this.editData.getId())))) {
                    this.editData();
                }
            }
            catch (EASBizException e) {
                this.handUIException(e);
            }
            catch (BOSException e) {
                this.handUIException(e);
            }
        } else if (OprtState.VIEW.equals(this.getOprtState())) {
            // empty if block
        }
    }

    protected void initWorkButton() {
        super.initWorkButton();
        try {
            FMClientHelper.initComboCurrency((KDComboBox)this.combocurrency, (boolean)true, (String)this.getOprtState());
        }
        catch (EASBizException e) {
            this.handUIException(e);
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return BankFactorFactory.getRemoteInstance();
    }

    @Override
    protected KDTable getDetailTable() {
        return this.kdtContractEntry;
    }

    protected IObjectValue createNewDetailData(KDTable table) {
        BankFactorContractEntryInfo info = new BankFactorContractEntryInfo();
        return info;
    }

    @Override
    protected void applyDefaultValue(IObjectValue vo) {
        vo.put("FICompany", (Object)this.currentCompany);
        vo.setBigDecimal("loanAmount", Constants.ZERO);
        vo.setBigDecimal("loanBalance", Constants.ZERO);
    }

    @Override
    protected void setFieldsNull(AbstractObjectValue newData) {
        newData.setNull("number");
        newData.put("FICompany", (Object)this.currentCompany);
    }

    @Override
    protected IObjectValue createNewData() {
        BankFactorInfo objectValue = new BankFactorInfo();
        objectValue.setFICompany(this.currentCompany);
        objectValue.setCreator(this.userinfo);
        java.util.Date date = new java.util.Date();
        objectValue.setIssueDate(date);
        objectValue.setExpireDate(date);
        objectValue.setType(FactorTypeEnum.APPLICANT_RECOURSE);
        objectValue.setApplicant(this.currentCompany);
        objectValue.setCurrency(this.baseCurrency);
        objectValue.setAmount(Constants.ZERO);
        objectValue.setLoanAmount(Constants.ZERO);
        objectValue.setLoanBalance(Constants.ZERO);
        objectValue.setRate(Constants.ONE);
        FMClientHelper.initNumber((CoreBaseInfo)objectValue, (KDTextField)this.txtNumber, (String)this.currentCompany.getId().toString());
        return objectValue;
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        BankFactorCollection bd;
        super.verifyInput(e);
        FMClientVerifyHelper.verifyRequire((CoreUIObject)this);
        if ("ADDNEW".equals(this.getOprtState()) && null != (bd = BankFactorFactory.getRemoteInstance().getBankFactorCollection("select * where number = '" + this.editData.getNumber() + "'")) && bd.size() > 0) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"170_BankDraftEditUI"));
            this.txtNumber.requestFocus();
            SysUtil.abort();
        }
        FMClientVerifyHelper.verifyEmptyAndNoZero((CoreUIObject)this, (KDFormattedTextField)this.txtamount);
        FMClientVerifyHelper.verifyComboCurrency((CoreUIObject)this, (KDComboBox)this.combocurrency);
        java.util.Date issueDate = DateTimeUtils.truncateDate((java.util.Date)((java.util.Date)this.pkissueDate.getValue()));
        java.util.Date expireDate = DateTimeUtils.truncateDate((java.util.Date)((java.util.Date)this.pkexpireDate.getValue()));
        if (issueDate != null && expireDate != null && issueDate.compareTo(expireDate) >= 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.common.FMResource", (String)"endDateGreaterBeginDate"));
            SysUtil.abort();
        }
        this.verifyKDTableRequired(this.panlFeeEntry, this.kdtFeeEntry);
        this.verifyKDTableRequired(this.panlEntry, this.kdtEntrys);
        this.verifyKDTableRequired(this.panlContract, this.kdtContractEntry);
        this.verifyContractEntryFactorAmt(this.panlContract);
    }

    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        if (null != this.editData.getId()) {
            BankFactorInfo bankFactorInfo = BankFactorFactory.getRemoteInstance().getBankFactorInfo((IObjectPK)new ObjectUuidPK(this.editData.getId()));
            if (!BankFactorHelper.saveOrSubmit(bankFactorInfo) && OprtState.ADDNEW.equals(this.getOprtState())) {
                this.editData.setState(FactorStateEnum.SAVE);
            }
        } else {
            this.editData.setState(FactorStateEnum.SAVE);
        }
        super.actionSave_actionPerformed(e);
    }

    @Override
    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        if (null != this.editData.getId()) {
            BankFactorInfo bankFactorInfo = BankFactorFactory.getRemoteInstance().getBankFactorInfo((IObjectPK)new ObjectUuidPK(this.editData.getId()));
            if (!BankFactorHelper.saveOrSubmit(bankFactorInfo)) {
                this.editData.setState(FactorStateEnum.SUBMIT);
            }
        } else {
            this.editData.setState(FactorStateEnum.SUBMIT);
        }
        super.actionSubmit_actionPerformed(e);
    }

    protected void initAddNewStatus() {
        super.initAddNewStatus();
        this.contNumber.setEnabled(true);
        this.prmtbank.setEnabled(true);
        this.prmtbankAcct.setEnabled(true);
        this.txtamount.setEnabled(true);
        this.txtrate.setEnabled(true);
        this.txtrate.setEditable(false);
        this.txtloanAmount.setEnabled(false);
        this.txtDescription.setEnabled(true);
        this.txtcontactNumber.setEnabled(true);
        this.type.setEnabled(true);
        this.prmtoppAcct.setEnabled(true);
        this.combocurrency.setEnabled(true);
        this.txtamountLocal.setEnabled(true);
        this.txtamountLocal.setEditable(true);
        if (OprtState.EDIT.equals(this.getOprtState())) {
            this.txtamountLocal.setEnabled(false);
        }
        this.txtloanBalance.setEnabled(false);
        this.txtMortgageRate.setEnabled(true);
        this.tabPane.setSelectedComponent((Component)this.panlContract);
        this.tabPane.setEnabledAt(0, true);
        this.tabPane.setEnabledAt(1, true);
        this.tabPane.setEnabledAt(2, true);
        this.panlContract.setEnabled(true);
        this.btnInsertLine.setEnabled(true);
        this.btnAddLine.setEnabled(true);
        this.btnRemoveLine.setEnabled(true);
        this.kdtContractEntry.setEditable(true);
        this.kdtContractEntry.setEnabled(true);
        this.kdtContractEntry.getStyleAttributes().setLocked(false);
        if (this.panlContract.getComponents() != null && this.panlContract.getComponents().length == 1) {
            DetailPanel detailPanel = (DetailPanel)this.panlContract.getComponents()[0];
            detailPanel.getAddNewLineButton().setEnabled(true);
            detailPanel.getInsertLineButton().setEnabled(true);
            detailPanel.getRemoveLinesButton().setEnabled(true);
        }
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddNew_actionPerformed(e);
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        BankFactorInfo info = BankFactorFactory.getRemoteInstance().getBankFactorInfo((IObjectPK)new ObjectUuidPK(this.editData.getId()));
        if (BankFactorHelper.isCanEditFromParam()) {
            if (BankFactorHelper.isCanNotEditFromAudit(info)) {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.ctl.CTLAutoGenerateResource", (String)"74_BankFactorEditUI"));
            } else if (BankFactorHelper.isCanEditFromAudit(info)) {
                super.actionEdit_actionPerformed(e);
                this.editData();
            } else {
                super.actionEdit_actionPerformed(e);
            }
        } else if (BankFactorHelper.isCanEdit(info)) {
            super.actionEdit_actionPerformed(e);
        } else {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.ctl.CTLAutoGenerateResource", (String)"75_BankFactorEditUI"));
        }
        this.txtamountLocal.setEnabled(false);
    }

    @Override
    protected void prmtbankAcct_dataChanged(DataChangeEvent e) throws Exception {
        super.prmtbankAcct_dataChanged(e);
    }

    @Override
    protected void prmtbankAcct_willCommit(CommitEvent e) throws Exception {
        super.prmtbankAcct_willCommit(e);
        BankInfo bank = (BankInfo)this.prmtbank.getValue();
        CurrencyInfo currency = (CurrencyInfo)this.combocurrency.getSelectedItem();
        CtlClientHelper.initPrmtBankAcct((IUIObject)this, this.prmtbankAcct, this.currentCompany, bank, currency);
    }

    @Override
    protected void prmtbankAcct_willShow(SelectorEvent e) throws Exception {
        super.prmtbankAcct_willShow(e);
        BankInfo bank = (BankInfo)this.prmtbank.getValue();
        if (bank != null) {
            int option = MsgBox.showConfirm2New(null, (String)EASResource.getString((String)"com.kingdee.eas.fm.ctl.CTLAutoGenerateResource", (String)"76_BankFactorEditUI"));
            if (0 == option) {
                CurrencyInfo currency = (CurrencyInfo)this.combocurrency.getSelectedItem();
                CtlClientHelper.initPrmtBankAcct((IUIObject)this, this.prmtbankAcct, this.currentCompany, bank, currency);
            } else {
                CurrencyInfo currency = (CurrencyInfo)this.combocurrency.getSelectedItem();
                CtlClientHelper.initPrmtBankAcct((IUIObject)this, this.prmtbankAcct, this.currentCompany, null, currency);
            }
        } else {
            CurrencyInfo currency = (CurrencyInfo)this.combocurrency.getSelectedItem();
            CtlClientHelper.initPrmtBankAcct((IUIObject)this, this.prmtbankAcct, this.currentCompany, null, currency);
        }
    }

    @Override
    protected void combocurrency_itemStateChanged(ItemEvent e) throws Exception {
        super.combocurrency_itemStateChanged(e);
        CurrencyInfo currency = (CurrencyInfo)this.combocurrency.getSelectedItem();
        if (currency != null && !OprtState.VIEW.equals(this.getOprtState())) {
            CtlClientHelper.initExchangeRateField((BasicFormattedTextField)this.txtrate, this.currentCompany, currency, this.baseCurrency, null);
            this.txtamount.setPrecision(currency.getPrecision());
            this.txtamountLocal.setEditable(this.txtrate.isEditable());
        }
        this.setFactorAmtPrecision();
    }

    private void setFactorAmtPrecision() {
        CurrencyInfo currency = (CurrencyInfo)this.combocurrency.getSelectedItem();
        if (currency != null) {
            IColumn factorAmt = this.kdtContractEntry.getColumn("factorAmt");
            FMKDTableHelper.initDecimalColumn((IColumn)factorAmt, (int)currency.getPrecision());
            this.appendFootRow(this.kdtContractEntry);
            KDTFootManager footManager = this.kdtContractEntry.getFootManager();
            if (footManager != null && footManager.getFootRow(0) != null) {
                FMKDTableHelper.initDecimalCell((ICell)footManager.getFootRow(0).getCell("factorAmt"), (int)currency.getPrecision());
            }
        }
    }

    @Override
    protected void pkissueDate_dataChanged(DataChangeEvent e) throws Exception {
        super.pkissueDate_dataChanged(e);
        if (!OprtState.EDIT.equals(this.getOprtState()) && e.getNewValue() != null) {
            java.util.Date date = (java.util.Date)e.getNewValue();
            this.pkexpireDate.setValue((Object)DateTimeUtils.addDay((java.util.Date)date, (long)10L));
        }
    }

    @Override
    protected void txtamount_dataChanged(DataChangeEvent e) throws Exception {
        super.txtamount_dataChanged(e);
        this.reCalAmountLocal();
    }

    @Override
    protected void txtrate_dataChanged(DataChangeEvent e) throws Exception {
        super.txtrate_dataChanged(e);
        this.reCalAmountLocal();
    }

    @Override
    protected void pkexpireDate_dataChanged(DataChangeEvent e) throws Exception {
        super.pkexpireDate_dataChanged(e);
        this.entryInfo.setDate((java.util.Date)e.getNewValue());
    }

    private void initEntrysTable() {
        this.initFeeEntryTable();
        this.initPlanEntryTable();
        this.initContractEntryTable();
    }

    private void initFeeEntryTable() {
        this.setTableToSumField(this.kdtFeeEntry, new String[]{"rate@##,###,###,###,###,##0.00", "amountLocal@##,###,###,###,###,##0.00"});
        FMKDTableHelper.initDecimalColumn((IColumn)this.kdtFeeEntry.getColumn("rate"), (int)2);
        FMKDTableHelper.initDecimalColumn((IColumn)this.kdtFeeEntry.getColumn("amountLocal"), (int)2);
        this.kdtFeeEntry.getColumn("amountLocal").getStyleAttributes().setLocked(true);
        this.kdtFeeEntry.addKDTPropertyChangeListener(new KDTPropertyChangeListener(){

            public void propertyChange(KDTPropertyChangeEvent evt) {
                if (evt.getType() == 1 && evt.getPropertyName().equals("cellValue")) {
                    int rowIndex;
                    CurrencyInfo currency;
                    IRow row = BankFactorEditUI.this.kdtFeeEntry.getRow(evt.getRowIndex());
                    if (BankFactorEditUI.this.kdtFeeEntry.getColumnKey(evt.getColIndex()).equals("amount")) {
                        BankFactorEditUI.this.reCalFeeAmountLocal(row);
                    } else if (BankFactorEditUI.this.kdtFeeEntry.getColumnKey(evt.getColIndex()).equals("exRate")) {
                        BankFactorEditUI.this.reCalFeeAmountLocal(row);
                    } else if (BankFactorEditUI.this.kdtFeeEntry.getColumnKey(evt.getColIndex()).equals("currency")) {
                        BankFactorEditUI.this.getExRate(row);
                    }
                    if (BankFactorEditUI.this.kdtFeeEntry.getColumnKey(evt.getColIndex()).equals("currency") && (currency = (CurrencyInfo)BankFactorEditUI.this.kdtFeeEntry.getRow(rowIndex = evt.getRowIndex()).getCell("currency").getValue()) != null) {
                        FMKDTableHelper.initDecimalCell((ICell)BankFactorEditUI.this.kdtFeeEntry.getRow(rowIndex).getCell("amount"), (int)currency.getPrecision());
                        FMKDTableHelper.initDecimalCell((ICell)BankFactorEditUI.this.kdtFeeEntry.getRow(rowIndex).getCell("amountLocal"), (int)currency.getPrecision());
                    }
                }
            }
        });
        this.kdtFeeEntry.addKDTEditListener((KDTEditListener)new KDTEditAdapter(){

            public void editStopping(KDTEditEvent e) {
                KDFormattedTextField txtRate;
                BigDecimal rate;
                if (e.getColIndex() == BankFactorEditUI.this.kdtFeeEntry.getColumnIndex("rate") && (Constants.ZERO.compareTo(rate = (txtRate = (KDFormattedTextField)BankFactorEditUI.this.kdtFeeEntry.getEditManager().getEditorComponent()).getBigDecimalValue()) >= 0 || Constants.ONE_HUNDRED.compareTo(rate) < 0)) {
                    MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.ctl.CTLAutoGenerateResource", (String)"77_BankFactorEditUI"));
                    e.setCancel(true);
                }
            }
        });
        this.initFeeEntryCurrency(this.getOprtState());
    }

    private void initPlanEntryTable() {
        this.setTableToSumField(this.kdtEntrys, new String[]{"amount@##,###,###,###,###,##0.00"});
        FMKDTableHelper.initDecimalColumn((IColumn)this.kdtEntrys.getColumn("amount"), (int)2);
        this.kdtEntrys.getColumn("date").getStyleAttributes().setNumberFormat(CtrlFormatUtilities.getDateFormatString());
        this.kdtEntrys.addKDTEditListener((KDTEditListener)new KDTEditAdapter(){

            public void editStopping(KDTEditEvent e) {
                if (e.getColIndex() == BankFactorEditUI.this.kdtEntrys.getColumnIndex("date")) {
                    IRow nextRow;
                    java.util.Date nextDate;
                    KDDatePicker dp = (KDDatePicker)BankFactorEditUI.this.kdtEntrys.getEditManager().getEditorComponent();
                    Date date = dp.getSqlDate();
                    int rowCount = BankFactorEditUI.this.kdtEntrys.getRowCount();
                    if (date != null && e.getRowIndex() > 0) {
                        IRow preRow = BankFactorEditUI.this.kdtEntrys.getRow(e.getRowIndex() - 1);
                        java.util.Date preDate = (java.util.Date)preRow.getCell("date").getValue();
                        if (preDate == null) {
                            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.ctl.CTLAutoGenerateResource", (String)"78_BankFactorEditUI"));
                            e.setCancel(true);
                            return;
                        }
                        if (preDate.after(date)) {
                            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.ctl.CTLAutoGenerateResource", (String)"79_BankFactorEditUI"));
                            e.setCancel(true);
                            return;
                        }
                    }
                    if (date != null && e.getRowIndex() + 1 < rowCount && (nextDate = (java.util.Date)(nextRow = BankFactorEditUI.this.kdtEntrys.getRow(e.getRowIndex() + 1)).getCell("date").getValue()) != null && nextDate.before(date)) {
                        MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.ctl.CTLAutoGenerateResource", (String)"80_BankFactorEditUI"));
                        e.setCancel(true);
                        return;
                    }
                }
            }
        });
    }

    private void initContractEntryTable() {
        this.setTableToSumField(this.kdtContractEntry, new String[]{"amount@##,###,###,###,###,##0.00", "payAmt@##,###,###,###,###,##0.00", "factorAmt@##,###,###,###,###,##0.00"});
        FMKDTableHelper.initDecimalColumn((IColumn)this.kdtContractEntry.getColumn("amount"), (int)2);
        FMKDTableHelper.initDecimalColumn((IColumn)this.kdtContractEntry.getColumn("payAmt"), (int)2);
        this.kdtContractEntry.addKDTEditListener((KDTEditListener)new KDTEditAdapter(){

            public void editStopped(KDTEditEvent e) {
                try {
                    BankFactorEditUI.this.contractEntryEdit(e);
                }
                catch (Exception e1) {
                    BankFactorEditUI.this.handUIExceptionAndAbort(e1);
                }
            }
        });
    }

    @Override
    protected void txtMortgageRate_dataChanged(DataChangeEvent e) throws Exception {
        if (this.kdtContractEntry.getRowCount() < 1) {
            return;
        }
        BigDecimal margageRate = this.txtMortgageRate.getBigDecimalValue();
        if (null != margageRate) {
            if (Constants.ONE_HUNDRED.compareTo(margageRate) < 0) {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.ctl.CTLAutoGenerateResource", (String)"81_BankFactorEditUI"));
                this.txtMortgageRate.requestFocus();
                SysUtil.abort();
            } else {
                int rows = this.kdtContractEntry.getRowCount();
                BigDecimal total = Constants.ZERO;
                int colIndex = this.kdtContractEntry.getColumnIndex("payAmt");
                int colIdxFactorAmt = this.kdtContractEntry.getColumnIndex("factorAmt");
                for (int i = 0; i < rows; ++i) {
                    Object value = this.kdtContractEntry.getCell(i, colIndex).getValue();
                    if (null == value) continue;
                    BigDecimal payAmt = new BigDecimal(value.toString());
                    total = total.add(payAmt);
                    BigDecimal factorAmt = FinHelper.calcBigDecimalExprs((String)"{0}*{1}/{2}", (BigDecimal[])new BigDecimal[]{payAmt, this.txtMortgageRate.getBigDecimalValue(), Constants.ONE_HUNDRED});
                    this.kdtContractEntry.getCell(i, colIdxFactorAmt).setValue((Object)factorAmt);
                }
                if (null != this.txtMortgageRate.getBigDecimalValue()) {
                    BigDecimal sum = FinHelper.calcBigDecimalExprs((String)"{0}*{1}/{2}", (BigDecimal[])new BigDecimal[]{total, this.txtMortgageRate.getBigDecimalValue(), Constants.ONE_HUNDRED});
                    this.txtamount.setValue((Object)sum);
                }
            }
        }
    }

    private void contractEntryEdit(KDTEditEvent e) throws Exception {
        int rows = this.kdtContractEntry.getRowCount();
        BigDecimal total = Constants.ZERO;
        int colIndex = e.getColIndex();
        if (colIndex == this.kdtContractEntry.getColumnIndex("payAmt")) {
            for (int i = 0; i < rows; ++i) {
                Object value = this.kdtContractEntry.getCell(i, colIndex).getValue();
                if (null == value) continue;
                total = total.add(new BigDecimal(value.toString()));
            }
            if (null != this.txtMortgageRate.getBigDecimalValue()) {
                BigDecimal sum = FinHelper.calcBigDecimalExprs((String)"{0}*{1}/{2}", (BigDecimal[])new BigDecimal[]{total, this.txtMortgageRate.getBigDecimalValue(), Constants.ONE_HUNDRED});
                this.txtamount.setValue((Object)sum);
            }
            this.reCalFactorAmtContractEntry(e);
        }
    }

    private void reCalFactorAmtContractEntry(KDTEditEvent e) throws Exception {
        Object value;
        if (null == this.txtMortgageRate.getBigDecimalValue()) {
            return;
        }
        int rowIndex = e.getRowIndex();
        int colIndex = e.getColIndex();
        int colIdxFactorAmt = this.kdtContractEntry.getColumnIndex("factorAmt");
        if (colIndex == this.kdtContractEntry.getColumnIndex("payAmt") && null != (value = this.kdtContractEntry.getCell(rowIndex, colIndex).getValue())) {
            BigDecimal payAmt = new BigDecimal(value.toString());
            BigDecimal factorAmt = FinHelper.calcBigDecimalExprs((String)"{0}*{1}/{2}", (BigDecimal[])new BigDecimal[]{payAmt, this.txtMortgageRate.getBigDecimalValue(), Constants.ONE_HUNDRED});
            this.kdtContractEntry.getCell(rowIndex, colIdxFactorAmt).setValue((Object)factorAmt);
        }
    }

    @Override
    protected void tabPane_stateChanged(ChangeEvent e) throws Exception {
        super.tabPane_stateChanged(e);
        if (null != this.tabPane.getSelectedComponent() && this.tabPane.getSelectedComponent().getName().equals("panlFeeEntry")) {
            ++this.feeClickedCount;
            if (this.getOprtState() == OprtState.ADDNEW && this.feeClickedCount == 1) {
                this.addLineFeeEntry();
            }
        }
    }

    private void addLineFeeEntry() {
        for (int row = 0; row < this.kdtContractEntry.getRowCount(); ++row) {
            IRow rowData = this.kdtFeeEntry.addRow();
            rowData.getCell("billNumber").setValue(this.kdtContractEntry.getRow(row).getCell("billNumber").getValue());
            rowData.getCell("rate").setValue((Object)Constants.ONE_HUNDRED);
            rowData.getCell("amount").setValue((Object)Constants.ZERO);
            rowData.getCell("currency").setValue((Object)this.baseCurrency);
            rowData.getCell("exRate").setValue((Object)Constants.ONE);
            rowData.getCell("amountLocal").setValue((Object)Constants.ZERO);
        }
    }

    private void reCalAmountLocal() {
        BigDecimal amount = this.txtamount.getBigDecimalValue();
        BigDecimal rate = this.txtrate.getBigDecimalValue();
        if (amount != null && rate != null) {
            BigDecimal local = amount.multiply(rate);
            this.txtamountLocal.setValue((Object)local);
        }
    }

    private void reCalFeeAmountLocal(IRow row) {
        BigDecimal amount = (BigDecimal)row.getCell("amount").getValue();
        BigDecimal rate = (BigDecimal)row.getCell("exRate").getValue();
        if (amount != null && rate != null) {
            BigDecimal local = amount.multiply(rate);
            row.getCell("amountLocal").setValue((Object)local);
        }
    }

    private void verifyContractEntryFactorAmt(KDPanel panl) {
        IRow footRow;
        Object footValue;
        BigDecimal footFactorAmt;
        int colIdxFactorAmt = this.kdtContractEntry.getColumnIndex("factorAmt");
        int colIdxPayAmt = this.kdtContractEntry.getColumnIndex("payAmt");
        for (int row = 0; row < this.kdtContractEntry.getRowCount(); ++row) {
            BigDecimal payAmt;
            BigDecimal factorAmt;
            Object factorValue = this.kdtContractEntry.getCell(row, colIdxFactorAmt).getValue();
            Object payValue = this.kdtContractEntry.getCell(row, colIdxPayAmt).getValue();
            if (null == factorValue || (factorAmt = new BigDecimal(factorValue.toString())).compareTo(payAmt = new BigDecimal(payValue == null ? "0" : payValue.toString())) <= 0) continue;
            this.tabPane.setSelectedComponent((Component)panl);
            String msg = EASResource.getString((String)"com.kingdee.eas.fm.ctl.CTLAutoGenerateResource", (String)"137_BankFactorEditUI");
            MsgBox.showInfo((String)msg);
            SysUtil.abort();
        }
        if (this.kdtContractEntry.getRowCount() > 0 && (footFactorAmt = new BigDecimal((footValue = (footRow = this.kdtContractEntry.getFootRow(0)).getCell(colIdxFactorAmt).getValue()).toString())).compareTo(this.txtamount.getBigDecimalValue()) != 0) {
            this.tabPane.setSelectedComponent((Component)panl);
            String msg = EASResource.getString((String)"com.kingdee.eas.fm.ctl.CTLAutoGenerateResource", (String)"138_BankFactorEditUI");
            MsgBox.showInfo((String)msg);
            SysUtil.abort();
        }
    }

    private void verifyKDTableRequired(KDPanel panl, KDTable kdt) {
        IRow headRow = kdt.getHeadRow(0);
        int count = kdt.getRowCount();
        for (int i = 0; i < count; ++i) {
            int size = kdt.getColumnCount();
            for (int j = 0; j < size; ++j) {
                if (!kdt.getColumn(j).isRequired() || kdt.getCell(i, j).getValue() != null) continue;
                this.tabPane.setSelectedComponent((Component)panl);
                String msgStr = MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fm.ctl.CTLAutoGenerateResource", (String)"151_BankFactorEditUI"), i + 1, headRow.getCell(j).getValue().toString());
                MsgBox.showInfo((String)msgStr);
                SysUtil.abort();
            }
        }
    }

    private void getExRate(IRow row) {
        CurrencyInfo currency = (CurrencyInfo)row.getCell("currency").getValue();
        if (currency != null) {
            try {
                ExchangeRateInfo exRate = FinUtils.getCurrencyExRateInfo(null, (CompanyOrgUnitInfo)this.currentCompany, (CurrencyInfo)currency, (CurrencyInfo)this.baseCurrency, null);
                if (exRate != null) {
                    row.getCell("exRate").setValue((Object)exRate.getConvertRate());
                } else {
                    row.getCell("exRate").setValue((Object)Constants.ONE);
                }
                boolean isSameCurrency = this.baseCurrency.getId().equals((Object)currency.getId());
                row.getCell("exRate").getStyleAttributes().setLocked(isSameCurrency);
            }
            catch (Exception e) {
                this.handUIException(e);
            }
        }
    }

    private void resetUI() {
        this.entryInfo = new BankFactorEntryInfo();
        this.entryInfo.setAmount(Constants.ZERO);
        BankFactorFeeEntryInfo feeEntryInfo = new BankFactorFeeEntryInfo();
        feeEntryInfo.setAmount(Constants.ZERO);
        feeEntryInfo.setCurrency(this.baseCurrency);
        feeEntryInfo.setRate(Constants.ONE_HUNDRED);
        feeEntryInfo.setExRate(Constants.ONE);
        feeEntryInfo.setAmountLocal(Constants.ZERO);
        this.contractEntryInfo = new BankFactorContractEntryInfo();
        this.contractEntryInfo.setAmount(Constants.ZERO);
        this.kdtFeeEntry.checkParsed();
        this.kdtFeeEntry.getColumn("fee").setRequired(true);
        this.kdtFeeEntry.getColumn("amount").setRequired(true);
        this.kdtFeeEntry.getColumn("currency").setRequired(true);
        this.kdtFeeEntry.getColumn("exRate").setRequired(true);
        this.kdtFeeEntry.getColumn("amountLocal").setRequired(true);
        this.initCurrencyColumn(this.kdtFeeEntry, "amount");
        this.initCurrencyColumn(this.kdtFeeEntry, "exRate");
        this.initCurrencyColumn(this.kdtFeeEntry, "amountLocal");
        this.kdtEntrys.checkParsed();
        this.kdtEntrys.getColumn("date").setRequired(true);
        this.kdtEntrys.getColumn("amount").setRequired(true);
        this.initCurrencyColumn(this.kdtEntrys, "amount");
        this.initCurrencyColumn(this.kdtContractEntry, "amount");
        this.initCurrencyColumn(this.kdtContractEntry, "payAmt");
        this.initCurrencyColumn(this.kdtContractEntry, "factorAmt");
        this.panlEntry.removeAll();
        DetailPanel dpEntry = (DetailPanel)HMDUtils.buildDetail((CoreUI)this, (DataBinder)this.dataBinder, (KDTable)this.kdtEntrys, (AbstractObjectValue)this.entryInfo, null, (boolean)false);
        this.panlEntry.add((Component)dpEntry, (Object)"Center");
        this.panlContract.removeAll();
        DetailPanel dpEntryContract = (DetailPanel)HMDUtils.buildDetail((CoreUI)this, (DataBinder)this.dataBinder, (KDTable)this.kdtContractEntry, (AbstractObjectValue)this.contractEntryInfo, null, (boolean)false);
        this.panlContract.add((Component)dpEntryContract, (Object)"Center");
        this.panlFeeEntry.removeAll();
        DetailPanel dpEntryFee = (DetailPanel)HMDUtils.buildDetail((CoreUI)this, (DataBinder)this.dataBinder, (KDTable)this.kdtFeeEntry, (AbstractObjectValue)feeEntryInfo, null, (boolean)false);
        this.panlFeeEntry.add((Component)dpEntryFee, (Object)"Center");
        this.tabPane.removeAll();
        this.tabPane.add((Component)this.panlContract, (Object)this.resHelper.getString("panlContract.constraints"));
        this.tabPane.add((Component)this.panlEntry, (Object)this.resHelper.getString("panlEntry.constraints"));
        this.tabPane.add((Component)this.panlFeeEntry, (Object)this.resHelper.getString("panlFeeEntry.constraints"));
        this.tabPane.setSelectedComponent((Component)this.panlContract);
    }

    private void initCurrencyColumn(KDTable tblMain, String name) {
        KDFormattedTextField formatField = new KDFormattedTextField(1);
        formatField.setNegatived(false);
        KDTDefaultCellEditor editor = new KDTDefaultCellEditor((JTextField)formatField);
        tblMain.getColumn(name).setEditor((ICellEditor)editor);
        tblMain.getColumn(name).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
    }

    private void initFeeEntryCurrency(String operate) {
        KDBizPromptBox kdtFeeEntry_currency_PromptBox = new KDBizPromptBox();
        kdtFeeEntry_currency_PromptBox.setQueryInfo("com.kingdee.eas.basedata.assistant.app.CurrencyQuery");
        kdtFeeEntry_currency_PromptBox.setVisible(true);
        kdtFeeEntry_currency_PromptBox.setEditable(true);
        kdtFeeEntry_currency_PromptBox.setDisplayFormat("$number$");
        kdtFeeEntry_currency_PromptBox.setEditFormat("$number$");
        kdtFeeEntry_currency_PromptBox.setCommitFormat("$number$");
        if (!operate.equals(OprtState.VIEW)) {
            EntityViewInfo view = new EntityViewInfo();
            view.setFilter(new FilterInfo());
            view.getFilter().getFilterItems().add(new FilterItemInfo("deletedStatus", (Object)new Integer(2), CompareType.NOTEQUALS));
            kdtFeeEntry_currency_PromptBox.setEntityViewInfo(view);
        }
        KDTDefaultCellEditor kdtFeeEntry_currency_CellEditor = new KDTDefaultCellEditor((IKDEditor)kdtFeeEntry_currency_PromptBox);
        this.kdtFeeEntry.getColumn("currency").setEditor((ICellEditor)kdtFeeEntry_currency_CellEditor);
    }

    protected boolean isNeedAddToolMenus() {
        return false;
    }

    protected SystemEnum getSystemEnum() {
        return SystemEnum.CTL_MANAGE;
    }

    protected String getDateField() {
        return "issueDate";
    }

    protected String[] getControlActions() {
        return new String[]{"actionSave", "actionSubmit", "actionEdit", "actionRemove", "actionAntiAudit"};
    }

    protected boolean isModifySave() {
        return this.editData.getState() == null || this.editData.getState().equals((Object)FactorStateEnum.SAVE);
    }
}

