/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.ctl.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.BasicFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.fm.IContextHelper;
import com.kingdee.eas.base.core.util.UIUtil;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.BankFactory;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ExchangeRateInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.cas.client.ArApRecPayHelper;
import com.kingdee.eas.fi.cas.client.BankJournalHandler;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMClientVerifyHelper;
import com.kingdee.eas.fm.ctl.FeeForGuaranteeFactory;
import com.kingdee.eas.fm.ctl.FeeForGuaranteeInfo;
import com.kingdee.eas.fm.ctl.IFeeForGuarantee;
import com.kingdee.eas.fm.ctl.LetterOfGuaranteeInfo;
import com.kingdee.eas.fm.ctl.client.AbstractFeeForGuaranteeEditUI;
import com.kingdee.eas.fm.ctl.client.util.CtlClientHelper;
import com.kingdee.eas.fm.fin.FinUtils;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import javax.swing.JComponent;

public class FeeForGuaranteeEditUI
extends AbstractFeeForGuaranteeEditUI {
    private static final String strResource = "com.kingdee.eas.fm.ctl.client.FeeForGuaranteeResource";
    private static final String resourcePath = "com.kingdee.eas.fm.ctl.client.CtlResource";
    private BankJournalHandler bankJournalHandler = new BankJournalHandler();
    private final CompanyOrgUnitInfo company = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
    private LetterOfGuaranteeInfo letterOfGuaranteeInfo;
    private boolean isBillBook;

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return FeeForGuaranteeFactory.getRemoteInstance();
    }

    @Override
    protected IObjectValue createNewData() {
        FeeForGuaranteeInfo objectValue = new FeeForGuaranteeInfo();
        objectValue.setCreator((UserInfo)SysContext.getSysContext().getCurrentUser());
        this.letterOfGuaranteeInfo = (LetterOfGuaranteeInfo)this.getUIContext().get("Guaranteeinfo");
        objectValue.setFBusinessNumber(this.letterOfGuaranteeInfo.getNumber());
        objectValue.setGuaranteeId(this.letterOfGuaranteeInfo.getId().toString());
        objectValue.setGuaranteeAmount(this.letterOfGuaranteeInfo.getAmount());
        return objectValue;
    }

    public void onLoad() throws Exception {
        this.isBillBook = this.isBillBook();
        Map listenerMap = FMClientHelper.removeCompListeners((CoreUI)this);
        this.txtFBusinessNumber.setEditable(false);
        this.txtSxfzbwb.setEditable(false);
        this.txtAbtract.setMaxLength(80);
        this.txtFeeTim.setMaxLength(80);
        this.txtLocalExRate.setMinimumValue((Comparable)new BigDecimal(0));
        this.txtMoneyAmount.setMinimumValue((Comparable)new BigDecimal(0));
        this.txtYearFee.setMinimumValue((Comparable)new BigDecimal(0));
        FMClientHelper.initCurrencyField((BasicFormattedTextField)this.txtLocalExRate);
        FMClientHelper.initCurrencyField((BasicFormattedTextField)this.txtMoneyAmount);
        FMClientHelper.initCurrencyField((BasicFormattedTextField)this.txtSxfzbwb);
        FMClientHelper.initCurrencyField((BasicFormattedTextField)this.txtYearFee);
        this.prmtsxfType.setQueryInfo("com.kingdee.eas.fm.fin.app.FeeTypeMaintenanceQuery");
        this.prmtsxfType.setEditable(true);
        this.promptInnerAccount.setQueryInfo("com.kingdee.eas.fm.fs.F7InnerAccountQuery");
        this.promptInnerAccount.setDisplayFormat("$name$");
        this.promptInnerAccount.setEditFormat("$number$");
        this.promptInnerAccount.setCommitFormat("$number$");
        this.promptInnerAccount.setEditable(true);
        EntityViewInfo evi1 = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("closed", (Object)"0"));
        filterInfo.getFilterItems().add(new FilterItemInfo("isUsed", (Object)"1"));
        filterInfo.getFilterItems().add(new FilterItemInfo("company.id", (Object)this.company.getId().toString()));
        evi1.setFilter(filterInfo);
        this.promptInnerAccount.setEntityViewInfo(evi1);
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("AssociateType", (Object)"4"));
        filter.getFilterItems().add(new FilterItemInfo("enabled", (Object)"1"));
        entityViewInfo.setFilter(filter);
        this.prmtsxfType.setEntityViewInfo(entityViewInfo);
        UIUtil.setAdminAllCU((IUIObject)this, (KDBizPromptBox)this.prmtBearDept);
        CtlClientHelper.initPrmtBankAcct((IUIObject)this, this.prmtAccountBank, this.company, null, null);
        this.prmtAccountview.setQueryInfo("com.kingdee.eas.basedata.master.account.app.AccountViewQuery");
        this.prmtAccountview.setEditable(true);
        this.bankJournalHandler.initF7Acct((IUIObject)this, this.prmtAccountview, this.company, this.company.getBaseCurrency());
        this.prmtCurrency.setQueryInfo("com.kingdee.eas.basedata.assistant.app.CurrencyQuery");
        this.prmtCurrency.setEditable(true);
        this.prmtCdItem.setQueryInfo("com.kingdee.eas.basedata.assistant.app.ProjectQuery");
        this.prmtCdItem.setEditable(true);
        EntityViewInfo entityViewInfoItem = new EntityViewInfo();
        FilterInfo filterItem = new FilterInfo();
        filterItem.getFilterItems().add(new FilterItemInfo("isListItem", (Object)"1"));
        entityViewInfoItem.setFilter(filterItem);
        this.prmtCdItem.setEntityViewInfo(entityViewInfoItem);
        super.onLoad();
        if (this.isBillBook) {
            if (this.editData.getCashier() == null) {
                this.btnBookBuilder.setEnabled(true);
                this.btnBookReverse.setEnabled(false);
            } else {
                this.btnBookBuilder.setEnabled(false);
                this.btnBookReverse.setEnabled(true);
            }
        } else {
            this.btnBookBuilder.setEnabled(false);
            this.btnBookReverse.setEnabled(false);
        }
        if (!this.isisClearinghouse(this.company)) {
            this.promptInnerAccount.setVisible(false);
            this.kDLabelContainer2.setVisible(false);
        }
        this.checkIsCreatorBear();
        FMClientHelper.addCompListeners((CoreUI)this, (Map)listenerMap);
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add("*");
        return sic;
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.actionBookBuilder.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_post"));
        this.actionBookReverse.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_versapost"));
    }

    protected void initDataStatus() {
        CurrencyInfo currency;
        super.initDataStatus();
        FeeForGuaranteeInfo info = (FeeForGuaranteeInfo)this.getDataObject();
        if (OprtState.VIEW.equals(this.getOprtState())) {
            if (info.getCashier() != null) {
                this.actionEdit.setEnabled(false);
            } else {
                this.actionEdit.setEnabled(true);
            }
        }
        if ((OprtState.EDIT.equals(this.getOprtState()) || OprtState.VIEW.equals(this.getOprtState())) && (currency = info.getCurrency()) != null) {
            this.txtMoneyAmount.setPrecision(currency.getPrecision());
            this.txtLocalExRate.setPrecision(currency.getPrecision());
            this.txtSxfzbwb.setPrecision(currency.getPrecision());
        }
        this.checkIsCreatorBear();
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (String)resourcePath, (KDBizPromptBox)this.prmtCurrency, (String)"CurrencyIsNull");
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (String)resourcePath, (Object)this.pkBizDate.getText(), (String)"BizDateIsNull");
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (String)resourcePath, (KDBizPromptBox)this.prmtsxfType, (String)"FeeNameIsNull");
        if (this.chkIsCreatorBear.isSelected()) {
            FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (String)resourcePath, (KDBizPromptBox)this.prmtBearDept, (String)"BearDeptIsNull");
            FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (String)resourcePath, (KDFormattedTextField)this.txtMoneyAmount, (String)"AmountIsNull");
            FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (String)resourcePath, (KDFormattedTextField)this.txtLocalExRate, (String)"ExchangeRateIsNull");
        }
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        this.verifyInput(e);
        this.checkFinalCheckout();
        super.actionSubmit_actionPerformed(e);
    }

    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        this.checkFinalCheckout();
        super.actionSave_actionPerformed(e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionBookBuilder_actionPerformed(ActionEvent e) throws Exception {
        if (!this.isBillBook) {
            return;
        }
        boolean isCancleHit = false;
        if (this.isModify()) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.ctl.client.FeeForGuaranteeResource.SaveAndBuilder"));
            return;
        }
        if (this.editData.getId() == null) {
            return;
        }
        if (this.editData.getCashier() != null) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.ctl.client.FeeForGuaranteeResource.FeeIsBuilderIsNotRepeat"));
            return;
        }
        HashSet<String> idSet = new HashSet<String>();
        String billId = this.editData.getId().toString();
        if (this.isCanBook(billId)) {
            if (this.editData.getAccountBank() == null) {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.ctl.client.FeeForGuaranteeResource.AccountBankIsNull"));
                return;
            }
            if (!this.isCurrencyAccord(billId)) {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.ctl.client.FeeForGuaranteeResource.CurrencyNotEqualsBankCurrency"));
                return;
            }
            idSet.add(billId);
        } else {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.ctl.CTLAutoGenerateResource", (String)"91_FeeForGuaranteeEditUI"));
        }
        if (idSet.size() > 0) {
            ArApRecPayHelper.requestMutex((CoreUI)this, idSet);
            try {
                ((IFeeForGuarantee)this.getBizInterface()).book(idSet);
                isCancleHit = true;
                UserInfo userInfo = ContextHelperFactory.getRemoteInstance().getCurrentUser();
                this.prmtCashier.setValue((Object)userInfo.getName());
                this.editData.setCashier(userInfo);
            }
            finally {
                ArApRecPayHelper.releaseMutex(idSet);
            }
            if (isCancleHit) {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.ctl.client.FeeForGuaranteeResource.BuilderIsSucceed"));
            } else {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.ctl.client.FeeForGuaranteeResource.BuilderIsLost"));
            }
        }
        this.setOprtState(OprtState.VIEW);
        this.actionEdit.setEnabled(false);
        this.btnBookBuilder.setEnabled(!isCancleHit);
        this.btnBookReverse.setEnabled(isCancleHit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionBookReverse_actionPerformed(ActionEvent e) throws Exception {
        super.actionBookReverse_actionPerformed(e);
        if (!this.isBillBook) {
            return;
        }
        if (this.editData.getId() == null) {
            return;
        }
        if (this.editData.getCashier() == null) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.ctl.client.FeeForGuaranteeResource.FeeIsNotBuilderIsNotReverse"));
            return;
        }
        if (this.editData.isFiVouchered()) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.ctl.client.FeeForGuaranteeResource.isFiVoucherIsNotReverse"));
            return;
        }
        HashSet<String> idSet = new HashSet<String>();
        String billId = this.editData.getId().toString();
        if (this.isCanBook(billId)) {
            idSet.add(billId);
        }
        boolean isCancleHit = false;
        if (idSet.size() > 0) {
            ArApRecPayHelper.requestMutex((CoreUI)this, idSet);
            try {
                ((IFeeForGuarantee)this.getBizInterface()).bookReverse(idSet);
                isCancleHit = true;
                this.prmtCashier.setValue(null);
                this.editData.setCashier(null);
            }
            finally {
                ArApRecPayHelper.releaseMutex(idSet);
            }
        }
        if (isCancleHit) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.ctl.client.FeeForGuaranteeResource.ReverseIsSucceed"));
        } else {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.ctl.client.FeeForGuaranteeResource.ReverseIsLost"));
        }
        this.setOprtState(OprtState.VIEW);
        this.btnBookBuilder.setEnabled(isCancleHit);
        this.btnBookReverse.setEnabled(!isCancleHit);
    }

    @Override
    protected void txtMoneyAmount_dataChanged(DataChangeEvent e) throws Exception {
        this.calAmount();
        super.txtMoneyAmount_dataChanged(e);
    }

    @Override
    protected void txtLocalExRate_dataChanged(DataChangeEvent e) throws Exception {
        this.calAmount();
        super.txtLocalExRate_dataChanged(e);
    }

    @Override
    protected void prmtCurrency_dataChanged(DataChangeEvent e) throws Exception {
        CurrencyInfo currencyinfo = (CurrencyInfo)this.prmtCurrency.getValue();
        if (currencyinfo != null) {
            if (this.company.getBaseCurrency() != null) {
                if (this.company.getBaseCurrency().getId().toString().equals(currencyinfo.getId().toString())) {
                    this.txtLocalExRate.setValue((Object)Constants.ONE);
                    this.txtLocalExRate.setPrecision(currencyinfo.getPrecision());
                    this.txtLocalExRate.setEditable(false);
                } else {
                    try {
                        FeeForGuaranteeInfo info = (FeeForGuaranteeInfo)this.getDataObject();
                        if (info != null) {
                            ExchangeRateInfo exchangeRateInfo = FinUtils.getCurrencyExRateInfo(null, (CompanyOrgUnitInfo)this.company, (CurrencyInfo)currencyinfo, (CurrencyInfo)this.company.getBaseCurrency(), (Date)info.getBizDate());
                            if (exchangeRateInfo == null) {
                                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.ctl.client.FeeForGuaranteeResource.notRate"));
                                SysUtil.abort();
                            }
                            this.txtLocalExRate.setValue((Object)exchangeRateInfo.getConvertRate());
                            this.txtLocalExRate.setPrecision(exchangeRateInfo.getPrecision());
                        }
                        this.txtLocalExRate.setEditable(true);
                    }
                    catch (EASBizException e1) {
                        this.prmtCurrency.setValue(null);
                        throw e1;
                    }
                }
            }
            this.calAmount();
        }
        super.prmtCurrency_dataChanged(e);
    }

    @Override
    protected void chkIsCreatorBear_actionPerformed(ActionEvent e) throws Exception {
        this.checkIsCreatorBear();
    }

    private void calAmount() throws EASBizException, BOSException {
        if (!this.txtMoneyAmount.getText().equals("") && !this.txtLocalExRate.getText().equals("")) {
            BigDecimal moneyAmount = new BigDecimal(this.txtMoneyAmount.getBigDecimalValue().toString());
            if (moneyAmount != null && moneyAmount.doubleValue() == 0.0) {
                this.txtMoneyAmount.setValue((Object)this.editData.getMoneyAmount());
                return;
            }
            this.editData.setMoneyAmount(moneyAmount);
            BigDecimal exchangeRate = new BigDecimal(this.txtLocalExRate.getBigDecimalValue().toString());
            BigDecimal sxfzbwb = moneyAmount.multiply(exchangeRate);
            this.txtSxfzbwb.setValue((Object)sxfzbwb);
            CurrencyInfo curinfo = null;
            curinfo = (CurrencyInfo)CurrencyFactory.getRemoteInstance().getValue((IObjectPK)new ObjectUuidPK(this.editData.getCurrency().getId()));
            this.txtSxfzbwb.setPrecision(curinfo.getPrecision());
        }
    }

    private void checkIsCreatorBear() {
        if (this.chkIsCreatorBear.isSelected()) {
            FMClientHelper.setEditable((JComponent)this.prmtBearDept, (boolean)true);
            FMClientHelper.setEditable((JComponent)this.prmtAccountBank, (boolean)true);
            FMClientHelper.setEditable((JComponent)this.prmtAccountview, (boolean)true);
            this.txtMoneyAmount.setRequired(true);
        } else {
            FMClientHelper.setEditable((JComponent)this.prmtBearDept, (boolean)false);
            FMClientHelper.setEditable((JComponent)this.prmtAccountBank, (boolean)false);
            FMClientHelper.setEditable((JComponent)this.prmtAccountview, (boolean)false);
            this.prmtBearDept.setValue(null);
            this.prmtAccountBank.setValue(null);
            this.prmtAccountview.setValue(null);
            this.txtMoneyAmount.setRequired(false);
        }
    }

    private boolean isCanBook(String id) {
        boolean flag = false;
        FeeForGuaranteeInfo info = null;
        try {
            info = FeeForGuaranteeFactory.getRemoteInstance().getFeeForGuaranteeInfo((IObjectPK)new ObjectStringPK(id));
        }
        catch (EASBizException e) {
            this.handUIException(e);
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        if (info != null && info.isIsCreatorBear()) {
            flag = true;
        }
        return flag;
    }

    private boolean isBillBook() {
        IContextHelper localInstance = ContextHelperFactory.getRemoteInstance();
        int val = localInstance.getIntParam("CS001", (IObjectPK)new ObjectUuidPK(this.company.getId()));
        return val == 0;
    }

    private boolean isisClearinghouse(CompanyOrgUnitInfo currentCompany) throws EASBizException, BOSException {
        boolean flag = BankFactory.getRemoteInstance().isClearinghouseCompany(currentCompany.getId().toString());
        return flag;
    }

    private boolean isCurrencyAccord(String id) throws EASBizException, BOSException {
        boolean isAccord = true;
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("accountBank.*"));
        sic.add(new SelectorItemInfo("accountBank.currency.*"));
        sic.add(new SelectorItemInfo("currency.*"));
        FeeForGuaranteeInfo feeForGuaranteeInfo = FeeForGuaranteeFactory.getRemoteInstance().getFeeForGuaranteeInfo((IObjectPK)new ObjectStringPK(id), sic);
        if (feeForGuaranteeInfo.getCurrency() != null && feeForGuaranteeInfo.getAccountBank() != null && feeForGuaranteeInfo.getAccountBank().isIsByCurrency() && !feeForGuaranteeInfo.getCurrency().equals((Object)feeForGuaranteeInfo.getAccountBank().getCurrency())) {
            isAccord = false;
        }
        return isAccord;
    }

    private void checkFinalCheckout() throws EASBizException, BOSException {
        CompanyOrgUnitInfo companyInfo = (CompanyOrgUnitInfo)SysContext.getSysContext().getCurrentCompany();
        boolean canOp = FMClientHelper.checkFinalCheckout((SystemEnum)SystemEnum.CTL_MANAGE, (String)companyInfo.getId().toString(), (Date)((Date)this.pkBizDate.getValue()));
        if (!canOp) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.recon.FmSettleResource", (String)"36_SETTLED"));
            SysUtil.abort();
        }
    }
}

