/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.ctl.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.BasicFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.dao.AbstractObjectValue;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMClientVerifyHelper;
import com.kingdee.eas.fm.common.util.FMBillUtil;
import com.kingdee.eas.fm.ctl.GuaranteeApplyCollection;
import com.kingdee.eas.fm.ctl.GuaranteeApplyFactory;
import com.kingdee.eas.fm.ctl.GuaranteeApplyInfo;
import com.kingdee.eas.fm.ctl.GuaranteeStateEnum;
import com.kingdee.eas.fm.ctl.LetterOfGuaranteeStateEnum;
import com.kingdee.eas.fm.ctl.OnlineApplyEnum;
import com.kingdee.eas.fm.ctl.client.AbstractGuaranteeApplyEditUI;
import com.kingdee.eas.fm.fin.FinUtils;
import com.kingdee.eas.fm.fin.FinancingBillTypeEnum;
import com.kingdee.eas.fm.fin.FinancingProductsCollection;
import com.kingdee.eas.fm.fin.FinancingProductsFactory;
import com.kingdee.eas.fm.fin.FinancingProductsInfo;
import com.kingdee.eas.fm.fin.util.FinHorizon;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.DateTimeUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.math.BigDecimal;
import java.util.Date;
import java.util.Map;
import org.apache.log4j.Logger;

public class GuaranteeApplyEditUI
extends AbstractGuaranteeApplyEditUI {
    private static final Logger logger = CoreUIObject.getLogger(GuaranteeApplyEditUI.class);
    private static final String RESOURCE = "com.kingdee.eas.fm.ctl.client.CTLClientResource";
    private static final BigDecimal BIGZERO = new BigDecimal("0.00");
    private static final int RIGHT = 4;

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return GuaranteeApplyFactory.getRemoteInstance();
    }

    public void onLoad() throws Exception {
        FMClientHelper.checkOnlyUnion((String)this.oprtState);
        this.txtGuanRate.setPrecision(10);
        super.onLoad();
        FinUtils.initBankTree((IUIObject)this, (KDBizPromptBox)this.prmtBankAcct, null, (boolean)true);
        this.checkBizUnit();
        this.btnAttachment.setVisible(false);
        this.txtNumber.setMaxLength(80);
        if (GuaranteeStateEnum.APPROVE.equals((Object)this.editData.getState()) && this.getOprtState().equals(OprtState.VIEW)) {
            this.menuItemEdit.setEnabled(false);
            this.menuItemRemove.setEnabled(false);
        }
        this.menuTable1.setVisible(false);
    }

    protected void checkBizUnit() throws EASBizException, BOSException {
        CompanyOrgUnitInfo company = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        if (ContextHelperFactory.getRemoteInstance().isOnlyUnion(company)) {
            this.btnVoucher.setVisible(false);
            this.btnDelVoucher.setVisible(false);
            this.btnAddNew.setVisible(false);
            this.menuItemAddNew.setVisible(false);
            this.btnEdit.setVisible(false);
            this.menuItemEdit.setVisible(false);
            this.btnRemove.setVisible(false);
            this.menuItemRemove.setVisible(false);
            this.actionSubmit.setEnabled(false);
        }
    }

    protected IObjectValue createNewData() {
        GuaranteeApplyInfo info = new GuaranteeApplyInfo();
        Date date = new Date();
        info.setApplyDate(date);
        info.setIssueDate(date);
        info.setExpiredDate(date);
        info.setBizDate(date);
        info.setCurrency(this.baseCurrency);
        info.setCompany(this.currentCompany);
        info.setCreator(this.userinfo);
        info.setLoculCurExRate(Constants.ONE);
        info.setAmount(BIGZERO);
        info.setHorizon(BIGZERO);
        info.setAmountLoculCur(BIGZERO);
        info.setState(GuaranteeStateEnum.SAVE);
        info.setIsOnlineApply(OnlineApplyEnum.NOTSUB);
        info.setAlreadyAmount(new BigDecimal(0));
        info.setOpJawsAmount(Constants.ZERO);
        info.setGuanRate(Constants.ZERO);
        info.setGuanAmount(Constants.ZERO);
        info.setGuanCurGuan(Constants.ZERO);
        info.setGuanCurExRate(Constants.ONE);
        try {
            info.setType(this.getFirstFinProduct(FinancingBillTypeEnum.LetterOfGuarantee));
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        return info;
    }

    @Override
    public void loadFields() {
        try {
            Map listen = FMClientHelper.removeCompListeners((CoreUI)this);
            super.loadFields();
            FMClientHelper.addCompListeners((CoreUI)this, (Map)listen);
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        FMClientHelper.initNumber((CoreBaseInfo)this.editData, (KDTextField)this.txtNumber, (String)this.editData.getCompany().getId().toString());
        CurrencyInfo currInfo = this.editData.getCurrency();
        if (this.comboGuaranCurrency.getValue() == null) {
            this.comboGuaranCurrency.setData(this.comboCurrency.getSelectedItem());
        }
        CurrencyInfo guaranCurrInfo = (CurrencyInfo)this.comboGuaranCurrency.getValue();
        if (currInfo != null && guaranCurrInfo != null && guaranCurrInfo.getName() != null && guaranCurrInfo.getId().equals((Object)currInfo.getId())) {
            this.txtGuanCurExRate.setEnabled(false);
        } else {
            this.txtGuanCurExRate.setEnabled(true);
            this.txtGuanCurExRate.setPrecision(guaranCurrInfo.getPrecision());
        }
        FMClientHelper.setSelectObject((KDComboBox)this.comboType, (Object)this.editData.getType());
        FMClientHelper.setSelectObject((KDComboBox)this.comboCurrency, (Object)this.editData.getCurrency());
        this.storeFields();
        this.initOldData((IObjectValue)this.editData);
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnAttachment.setVisible(false);
        this.txtAmount.setPrecision(2);
        this.txtAmountLoculCur.setPrecision(2);
        this.txtHorizon.setPrecision(2);
        this.txtGuanCurGuan.setPrecision(2);
        this.txtOpJawsAmount.setPrecision(2);
        FMClientHelper.initCurrencyField((BasicFormattedTextField)this.txtAmount);
        FMClientHelper.initCurrencyField((BasicFormattedTextField)this.txtAmountLoculCur);
        FMClientHelper.initCurrencyField((BasicFormattedTextField)this.txtGuanCurGuan);
        FMClientHelper.initCurrencyField((BasicFormattedTextField)this.txtGuanAmount);
        FMClientHelper.initCurrencyField((BasicFormattedTextField)this.txtOpJawsAmount);
        try {
            FMClientHelper.initComboCurrency((KDComboBox)this.comboCurrency, (boolean)true, (String)this.getOprtState());
            FinUtils.initFinProductComboBox((KDComboBox)this.comboType, (FinancingBillTypeEnum)FinancingBillTypeEnum.LetterOfGuarantee);
        }
        catch (EASBizException e) {
            this.handUIException(e);
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        Object[] boxList = new KDFormattedTextField[]{this.txtAmount, this.txtLoculCurExRate, this.txtGuanCurExRate, this.txtGuanAmount, this.txtGuanCurGuan, this.txtOpJawsAmount, this.txtGuanRate};
        FMClientHelper.txtBoxShow((Object[])boxList, (int)4);
    }

    public FinancingProductsInfo getFirstFinProduct(FinancingBillTypeEnum billType) throws BOSException {
        EntityViewInfo evi = new EntityViewInfo();
        evi.getSelector().add(new SelectorItemInfo("*"));
        evi.getSelector().add(new SelectorItemInfo("FinancingSource.id"));
        evi.getSelector().add(new SelectorItemInfo("FinancingSource.number"));
        evi.getSelector().add(new SelectorItemInfo("FinancingSource.name"));
        evi.getSelector().add(new SelectorItemInfo("NoteType.id"));
        evi.getSelector().add(new SelectorItemInfo("NoteType.number"));
        evi.getSelector().add(new SelectorItemInfo("NoteType.name"));
        evi.setFilter(new FilterInfo());
        evi.getFilter().getFilterItems().add(new FilterItemInfo("BillType", (Object)billType));
        FinancingProductsCollection finProCollection = FinancingProductsFactory.getRemoteInstance().getFinancingProductsCollection(evi);
        return finProCollection.size() > 0 ? finProCollection.get(0) : null;
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        if (!LetterOfGuaranteeStateEnum.APPROVE.equals((Object)this.editData.getState())) {
            this.editData.setState(GuaranteeStateEnum.SUBMIT);
        }
        super.actionSubmit_actionPerformed(e);
        this.txtNumber.setEnabled(false);
    }

    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        if (OprtState.ADDNEW.equals(this.getOprtState())) {
            this.editData.setState(GuaranteeStateEnum.SAVE);
        }
        super.actionSave_actionPerformed(e);
        this.txtNumber.setEnabled(false);
    }

    public void actionCopy_actionPerformed(ActionEvent e) throws Exception {
        super.actionCopy_actionPerformed(e);
    }

    protected void setFieldsNull(AbstractObjectValue newData) {
        newData.setNull("number");
        newData.setNull("Approval");
        newData.setNull("ApprovalDate");
        newData.setInt("AlreadyAmount", 0);
        super.setFieldsNull(newData);
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        GuaranteeApplyCollection bd;
        if (this.txtNumber.isEnabled()) {
            FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDTextField)this.txtNumber);
        }
        super.verifyInput(e);
        if ("ADDNEW".equals(this.getOprtState()) && null != (bd = GuaranteeApplyFactory.getRemoteInstance().getGuaranteeApplyCollection("select * where number = '" + this.editData.getNumber() + "'")) && bd.size() > 0) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.fm.nt.NTAutoGenerateResource", (String)"170_BankDraftEditUI"));
            this.txtNumber.requestFocus();
            SysUtil.abort();
        }
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDDatePicker)this.pkApplyDate);
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDFormattedTextField)this.txtAmount);
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDBizPromptBox)this.prmtBankAcct);
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDFormattedTextField)this.txtHorizon);
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDBizPromptBox)this.prmtLGType);
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDTextField)this.txtReceiver);
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDDatePicker)this.pkIssueDate);
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDDatePicker)this.pkExpiredDate);
        FMClientHelper.verifyMoreThanZero((CoreUIObject)this, (KDFormattedTextField)this.txtAmount);
        if (this.txtHorizon.getBigDecimalValue() != null) {
            FMClientHelper.verifyMoreThanZero((CoreUIObject)this, (KDFormattedTextField)this.txtHorizon);
        }
        if (this.txtOpJawsAmount.getBigDecimalValue() != null) {
            FMClientHelper.verifyNotNegtive((CoreUIObject)this, (KDFormattedTextField)this.txtOpJawsAmount);
        }
        Date dateBegin = DateTimeUtils.truncateDate((Date)this.pkIssueDate.getSqlDate());
        Date dateEnd = DateTimeUtils.truncateDate((Date)this.pkExpiredDate.getSqlDate());
        if (dateEnd != null && !dateEnd.after(dateBegin)) {
            this.pkExpiredDate.requestFocus();
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"LGBeginDateMustBeforeEndDate"));
            this.abort();
        }
    }

    @Override
    protected void comboCurrency_itemStateChanged(ItemEvent e) throws Exception {
        if (e.getStateChange() == 2) {
            return;
        }
        CurrencyInfo currency = (CurrencyInfo)this.comboCurrency.getSelectedItem();
        if (currency != null) {
            this.setGuanCurExRatePrec();
            this.txtAmount.setPrecision(currency.getPrecision());
            this.txtGuanAmount.setPrecision(currency.getPrecision());
            this.txtAmountLoculCur.setPrecision(currency.getPrecision());
            this.txtOpJawsAmount.setPrecision(currency.getPrecision());
            if (this.currentCompany.getBaseCurrency() != null) {
                if (this.currentCompany.getBaseCurrency().getId().toString().equals(currency.getId().toString())) {
                    this.txtLoculCurExRate.setEnabled(false);
                    this.txtLoculCurExRate.setEditable(false);
                } else {
                    this.txtLoculCurExRate.setEnabled(true);
                    this.txtLoculCurExRate.setEditable(true);
                    if (this.getOprtState().equals(OprtState.VIEW)) {
                        this.txtLoculCurExRate.setRequired(false);
                    }
                }
            }
            if (OprtState.VIEW.equals(this.getOprtState()) || OprtState.EDIT.equals(this.getOprtState()) && this.isFirstOnload()) {
                return;
            }
            CompanyOrgUnitInfo currentFIUnit = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
            try {
                GuaranteeApplyInfo info = (GuaranteeApplyInfo)this.getDataObject();
                if (info != null) {
                    FinUtils.initExchangeRate(null, (BasicFormattedTextField)this.txtLoculCurExRate, (CompanyOrgUnitInfo)currentFIUnit, (CurrencyInfo)currency, (CurrencyInfo)currentFIUnit.getBaseCurrency(), (Date)info.getBizDate(), null);
                }
                CurrencyInfo guarabcurrency = (CurrencyInfo)this.comboGuaranCurrency.getValue();
                if (currency != null && guarabcurrency != null) {
                    if (guarabcurrency.getId().toString().equals(currency.getId().toString())) {
                        this.txtGuanCurExRate.setEnabled(false);
                        this.txtGuanCurExRate.setEditable(false);
                        this.txtGuanCurExRate.setValue((Object)new BigDecimal(1));
                    } else {
                        this.txtGuanCurExRate.setEnabled(true);
                        this.txtGuanCurExRate.setEditable(true);
                        if (this.getOprtState().equals(OprtState.VIEW)) {
                            this.txtGuanCurExRate.setRequired(false);
                        }
                    }
                }
            }
            catch (EASBizException e1) {
                this.comboCurrency.setSelectedItem(null);
                throw e1;
            }
            this.txtAmountLoculCur.setValue((Object)this.calcLocalAmount());
        }
    }

    @Override
    protected void txtLoculCurExRate_dataChanged(DataChangeEvent e) throws Exception {
        super.txtLoculCurExRate_dataChanged(e);
        this.txtAmountLoculCur.setValue((Object)this.calcLocalAmount());
    }

    @Override
    protected void txtAmount_dataChanged(DataChangeEvent e) throws Exception {
        this.txtAmountLoculCur.setValue((Object)this.calcLocalAmount());
        BigDecimal amount = this.txtAmount.getBigDecimalValue();
        BigDecimal guanRate = this.txtGuanRate.getBigDecimalValue();
        if (amount != null && guanRate != null) {
            BigDecimal guanAmount = amount.multiply(guanRate).multiply(new BigDecimal(String.valueOf(0.01)));
            this.txtGuanAmount.setValue((Object)guanAmount);
        }
    }

    @Override
    protected void comboGuaranCurrency_dataChanged(DataChangeEvent e) throws Exception {
        super.comboGuaranCurrency_dataChanged(e);
        CurrencyInfo currency = (CurrencyInfo)this.comboGuaranCurrency.getValue();
        if (currency != null) {
            this.setGuanCurExRatePrec();
            this.txtGuanCurGuan.setPrecision(currency.getPrecision());
            CurrencyInfo comcurrency = (CurrencyInfo)this.comboCurrency.getSelectedItem();
            if (OprtState.VIEW.equals(this.getOprtState()) || OprtState.EDIT.equals(this.getOprtState()) && this.isFirstOnload()) {
                return;
            }
            CompanyOrgUnitInfo currentFIUnit = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
            GuaranteeApplyInfo info = (GuaranteeApplyInfo)this.getDataObject();
            if (info != null && info.getGuanCurExRate() != null && info.getGuaranCurrency() != null && info.getGuaranCurrency().equals((Object)((CurrencyInfo)e.getNewValue()))) {
                CurrencyInfo srcCurrency = (CurrencyInfo)this.comboCurrency.getSelectedItem();
                CurrencyInfo descCurrency = (CurrencyInfo)this.comboGuaranCurrency.getValue();
                FinUtils.initExchangeRate((BasicFormattedTextField)this.txtGuanCurExRate, (CompanyOrgUnitInfo)this.currentCompany, (CurrencyInfo)srcCurrency, (CurrencyInfo)descCurrency, (Date)((Date)this.pkIssueDate.getValue()));
            }
            if (comcurrency != null && currency != null) {
                if (comcurrency.getId().toString().equals(currency.getId().toString())) {
                    this.txtGuanCurExRate.setEnabled(false);
                    this.txtGuanCurExRate.setEditable(false);
                    this.txtGuanCurExRate.setValue((Object)new BigDecimal(1));
                } else {
                    this.txtGuanCurExRate.setEnabled(true);
                    this.txtGuanCurExRate.setEditable(true);
                    if (this.getOprtState().equals(OprtState.VIEW)) {
                        this.txtGuanCurExRate.setRequired(false);
                    }
                }
            }
        }
    }

    private void setGuanCurExRatePrec() {
        CurrencyInfo srcCurrency = (CurrencyInfo)this.comboCurrency.getSelectedItem();
        CurrencyInfo descCurrency = (CurrencyInfo)this.comboGuaranCurrency.getValue();
        if (srcCurrency != null && descCurrency != null) {
            int prec = FMBillUtil.getPrecOfExRate((CurrencyInfo)srcCurrency, (CurrencyInfo)descCurrency);
            this.txtGuanCurExRate.setPrecision(prec);
        }
        try {
            if (!this.getOprtState().equals(OprtState.VIEW)) {
                FinUtils.initExchangeRate((BasicFormattedTextField)this.txtGuanCurExRate, (CompanyOrgUnitInfo)this.currentCompany, (CurrencyInfo)srcCurrency, (CurrencyInfo)descCurrency, (Date)((Date)this.pkIssueDate.getValue()));
            }
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    @Override
    protected void txtGuanRate_dataChanged(DataChangeEvent e) throws Exception {
        super.txtGuanRate_dataChanged(e);
        BigDecimal amount = this.txtAmount.getBigDecimalValue();
        BigDecimal guanRate = this.txtGuanRate.getBigDecimalValue();
        if (guanRate != null && guanRate.compareTo(new BigDecimal(String.valueOf(100))) > 0) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.ctl.CTLAutoGenerateResource", (String)"93_GuaranteeApplyEditUI"));
            this.txtGuanRate.setValue((Object)Constants.ZERO);
            return;
        }
        if (amount != null && guanRate != null) {
            BigDecimal guanAmount = amount.multiply(guanRate).multiply(new BigDecimal(String.valueOf(0.01)));
            this.txtGuanAmount.setValue((Object)guanAmount);
        }
    }

    @Override
    protected void txtGuanAmount_dataChanged(DataChangeEvent e) throws Exception {
        super.txtGuanAmount_dataChanged(e);
        BigDecimal amount = this.txtGuanAmount.getBigDecimalValue();
        BigDecimal guanRate = this.txtGuanCurExRate.getBigDecimalValue();
        if (amount != null && guanRate != null) {
            this.txtGuanCurGuan.setValue((Object)amount.multiply(guanRate));
        }
    }

    @Override
    protected void pkExpiredDate_dataChanged(DataChangeEvent e) throws Exception {
        super.pkExpiredDate_dataChanged(e);
        this.txtHorizon.setValue((Object)FinHorizon.getHorizon((KDDatePicker)this.pkIssueDate, (KDDatePicker)this.pkExpiredDate));
    }

    @Override
    protected void pkIssueDate_dataChanged(DataChangeEvent e) throws Exception {
        super.pkIssueDate_dataChanged(e);
        this.txtHorizon.setValue((Object)FinHorizon.getHorizon((KDDatePicker)this.pkIssueDate, (KDDatePicker)this.pkExpiredDate));
    }

    private BigDecimal calcLocalAmount() {
        BigDecimal bdAmount = this.txtAmount.getBigDecimalValue();
        BigDecimal bdLocalExRate = this.txtLoculCurExRate.getBigDecimalValue();
        if (bdAmount != null && bdLocalExRate != null) {
            return bdAmount.multiply(bdLocalExRate);
        }
        return Constants.ZERO;
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("creator.name"));
        sic.add(new SelectorItemInfo("Type.*"));
        sic.add(new SelectorItemInfo("LGType.name"));
        sic.add(new SelectorItemInfo("LGType.id"));
        sic.add(new SelectorItemInfo("Currency.name"));
        sic.add(new SelectorItemInfo("Currency.id"));
        sic.add(new SelectorItemInfo("GuaranCurrency.name"));
        sic.add(new SelectorItemInfo("GuaranCurrency.id"));
        sic.add(new SelectorItemInfo("GuaranCurrency.precision"));
        sic.add(new SelectorItemInfo("company.*"));
        sic.add(new SelectorItemInfo("BankAcct.number"));
        sic.add(new SelectorItemInfo("BankAcct.name"));
        sic.add(new SelectorItemInfo("Country.number"));
        sic.add(new SelectorItemInfo("Country.name"));
        sic.add(new SelectorItemInfo("Approval.name"));
        sic.add(new SelectorItemInfo("Approval.number"));
        sic.add(new SelectorItemInfo("project.number"));
        sic.add(new SelectorItemInfo("project.name"));
        sic.add(new SelectorItemInfo("Department.name"));
        sic.add(new SelectorItemInfo("Department.number"));
        return sic;
    }

    @Override
    protected void txtGuanCurExRate_dataChanged(DataChangeEvent e) throws Exception {
        BigDecimal amount = this.txtGuanAmount.getBigDecimalValue();
        BigDecimal guanRate = this.txtGuanCurExRate.getBigDecimalValue();
        if (amount != null && guanRate != null) {
            this.txtGuanCurGuan.setValue((Object)amount.multiply(guanRate));
        }
        CurrencyInfo guarabcurrency = (CurrencyInfo)this.comboGuaranCurrency.getValue();
        CurrencyInfo currency = (CurrencyInfo)this.comboCurrency.getSelectedItem();
        if (currency != null && guarabcurrency != null) {
            if (guarabcurrency.getId().toString().equals(currency.getId().toString())) {
                this.txtGuanCurExRate.setEnabled(false);
                this.txtGuanCurExRate.setEditable(false);
                this.txtGuanCurExRate.setValue((Object)new BigDecimal(1));
            } else {
                this.txtGuanCurExRate.setEnabled(true);
                this.txtGuanCurExRate.setEditable(true);
                if (this.getOprtState().equals(OprtState.VIEW)) {
                    this.txtGuanCurExRate.setRequired(false);
                }
            }
        }
    }

    protected boolean isIgnoreBizUnit() {
        return false;
    }

    protected boolean isNeedAddToolMenus() {
        return false;
    }

    protected void initDataStatus() {
        super.initDataStatus();
        GuaranteeApplyInfo guaranteeApplyInfo = (GuaranteeApplyInfo)this.getDataObject();
        if (guaranteeApplyInfo != null && guaranteeApplyInfo.getState() != null && !guaranteeApplyInfo.getState().equals((Object)GuaranteeStateEnum.SAVE)) {
            this.actionSave.setEnabled(false);
        }
    }

    protected boolean isModifySave() {
        return this.editData.getState() == null || this.editData.getState().equals((Object)GuaranteeStateEnum.SAVE);
    }
}

