/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.ctl.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.fm.common.FMSysDefinedEnum;
import com.kingdee.eas.fm.common.client.FMClientVerifyHelper;
import com.kingdee.eas.fm.ctl.GuaranteeColEnum;
import com.kingdee.eas.fm.ctl.client.AbstractLetOfGuaranteeFilterUI;
import com.kingdee.eas.fm.ctl.client.LetOfGuaranteeFilterParm;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.util.Date;
import java.util.Set;

public class LetOfGuaranteeFilterUI
extends AbstractLetOfGuaranteeFilterUI {
    private static final String RESOURCE = "com.kingdee.eas.fm.ctl.client.CTLClientResource";

    protected void init() throws Exception {
        super.init();
        this.customInit();
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)this.currentCompany.getId()));
        evi.setFilter(filter);
        this.kDByhbh.setEntityViewInfo(evi);
    }

    private void customInit() throws Exception {
        Date date = new Date();
        this.kDDStartDate.setValue((Object)DateUtil.getFirstDayOfCurMonth());
        this.kDDEndDate.setValue((Object)date);
        this.initBillStatus(this.kDCItems);
        this.kDCItems.setSelectedItem((Object)FMSysDefinedEnum.ALL_ITEMS);
    }

    private void initBillStatus(KDComboBox combo) {
        combo.removeAllItems();
        combo.addItem((Object)GuaranteeColEnum.Amount);
        combo.addItem((Object)GuaranteeColEnum.applyUnit);
        combo.addItem((Object)GuaranteeColEnum.department);
        combo.addItem((Object)GuaranteeColEnum.ExpiredDate);
        combo.addItem((Object)GuaranteeColEnum.GuaranteeTypeInputMode);
        combo.addItem((Object)GuaranteeColEnum.IssueDate);
        combo.addItem((Object)GuaranteeColEnum.dealer);
        combo.addItem((Object)GuaranteeColEnum.kcType);
        combo.addItem((Object)GuaranteeColEnum.LGType);
        combo.addItem((Object)GuaranteeColEnum.license);
        combo.addItem((Object)GuaranteeColEnum.reAssureDate);
        combo.addItem((Object)GuaranteeColEnum.Receiver);
        combo.addItem((Object)GuaranteeColEnum.transBank);
        combo.addItem((Object)FMSysDefinedEnum.ALL_ITEMS);
        combo.setSelectedItem((Object)FMSysDefinedEnum.ALL_ITEMS);
    }

    protected Class getParamClass() {
        return LetOfGuaranteeFilterParm.class;
    }

    public Object getParam() {
        Set gtSet;
        LetOfGuaranteeFilterParm param = new LetOfGuaranteeFilterParm();
        param.setCompanyIdSet(this.getCompanyIdSet());
        param.setBillDateFrom((Date)this.kDDStartDate.getValue());
        param.setBillDateTo((Date)this.kDDEndDate.getValue());
        if (this.kDCItems.getSelectedItem() instanceof GuaranteeColEnum && this.kDCItems.getSelectedItem() != null) {
            param.setBillStatus(((GuaranteeColEnum)((Object)this.kDCItems.getSelectedItem())).getValue());
        }
        if ((gtSet = this.getIdSetFromF7(this.kDByhbh)).size() > 0) {
            param.setGuaranteeSet(gtSet);
        }
        return param;
    }

    public void setParam(Object param) {
        if (param == null) {
            return;
        }
        if (!(param instanceof LetOfGuaranteeFilterParm)) {
            return;
        }
        LetOfGuaranteeFilterParm filterParam = (LetOfGuaranteeFilterParm)param;
        this.setCompanyIdSet(filterParam.getCompanyIdSet());
        this.kDDStartDate.setValue((Object)filterParam.getBillDateFrom());
        this.kDDEndDate.setValue((Object)filterParam.getBillDateTo());
        try {
            this.kDByhbh.setData((Object)this.getBaseInfoFromIdSet(filterParam.getGuaranteeSet()));
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        if (!StringUtils.isEmpty((String)filterParam.getBillStatus())) {
            this.kDCItems.setSelectedItem((Object)FMSysDefinedEnum.ALL_ITEMS);
        } else {
            this.kDCItems.setSelectedItem((Object)GuaranteeColEnum.getEnum(filterParam.getBillStatus()));
        }
    }

    public void clear() {
        super.clear();
        this.kDByhbh.setData(null);
        try {
            this.customInit();
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    public boolean verify() {
        if (this.kDDStartDate.getValue() == null || this.kDDEndDate.getValue() == null) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"NoBizDate"));
            SysUtil.abort();
        }
        Date dateFrom = DateTimeUtils.truncateDate((Date)((Date)this.kDDStartDate.getValue()));
        Date dateTo = DateTimeUtils.truncateDate((Date)((Date)this.kDDEndDate.getValue()));
        FMClientVerifyHelper.verifyBeginEndDateRel((CoreUIObject)this, (Date)dateFrom, (Date)dateTo);
        return true;
    }
}

