/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.ctl.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.KDNoteHelper;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fm.common.FMException;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.SumBillEnum;
import com.kingdee.eas.fm.common.SumFiledsInfo;
import com.kingdee.eas.fm.common.client.BoolTextValueProvider;
import com.kingdee.eas.fm.common.client.ColumnUserCellDisplayParser;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMFilterBaseUI;
import com.kingdee.eas.fm.common.client.IValueProvider;
import com.kingdee.eas.fm.ctl.ILetterOfGuarantee;
import com.kingdee.eas.fm.ctl.LetterOfGuaranteeCollection;
import com.kingdee.eas.fm.ctl.LetterOfGuaranteeFactory;
import com.kingdee.eas.fm.ctl.LetterOfGuaranteeHelper;
import com.kingdee.eas.fm.ctl.LetterOfGuaranteeInfo;
import com.kingdee.eas.fm.ctl.LetterOfGuaranteeStateEnum;
import com.kingdee.eas.fm.ctl.client.AbstractLetterOfGuaranteeListUI;
import com.kingdee.eas.fm.ctl.client.FeeForGuaranteeFMUI;
import com.kingdee.eas.fm.ctl.client.FeeForGuaranteeListUI;
import com.kingdee.eas.fm.ctl.client.LetOfGuaranteeEditUI;
import com.kingdee.eas.fm.ctl.client.LetterOfGuaranteeEditUI;
import com.kingdee.eas.fm.ctl.client.LetterOfGuaranteeFilterParam;
import com.kingdee.eas.fm.ctl.client.LetterOfGuaranteeFilterUI;
import com.kingdee.eas.fm.fin.FinBizException;
import com.kingdee.eas.fm.fin.RepaymentInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.client.CoreBillListUI;
import com.kingdee.eas.framework.client.context.IDelegationSupport;
import com.kingdee.eas.framework.util.CommonDataProvider;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class LetterOfGuaranteeListUI
extends AbstractLetterOfGuaranteeListUI
implements IDelegationSupport {
    private LetterOfGuaranteeFilterUI filterUI = null;
    private static final String RESOURCE = "com.kingdee.eas.fm.ctl.client.CTLClientResource";
    private static final String CTLRESOURCE = "com.kingdee.eas.fm.ctl.CTLAutoGenerateResource";
    private static final Logger logger = CoreUIObject.getLogger(LetterOfGuaranteeListUI.class);
    private static final String tdTemplateFile = "/FM/CTL/LETTEROFGUARANTEE";

    public LetterOfGuaranteeListUI() throws Exception {
        ColumnUserCellDisplayParser displayParser = new ColumnUserCellDisplayParser(this.tblMain);
        BoolTextValueProvider provider = new BoolTextValueProvider(this.getResString("Yes"), this.getResString("No"));
        displayParser.addValueProvider("IsInCredit", (IValueProvider)provider);
    }

    public void onLoad() throws Exception {
        super.onLoad();
        if (!this.currentCompanyCommon.isIsBizUnit()) {
            this.actionFee.setVisible(false);
            this.actionModifyLetter.setVisible(false);
            this.actionSuoPei.setVisible(false);
            this.actionCancelNoPay.setVisible(false);
            this.actionAntiCancelNoPay.setVisible(false);
            this.actionSubmit.setVisible(false);
            this.actionAudit.setVisible(false);
            this.actionAntiAudit.setVisible(false);
        }
        this.tblMain.getColumn("LocalCurExRate").getStyleAttributes().setNumberFormat("###,##0.00000");
        this.actionAttachment.setVisible(true);
        this.actionAttachment.setEnabled(true);
        this.actionCreateTo.setVisible(false);
        this.actionWorkFlowG.setVisible(true);
        this.actionTDPrint.setEnabled(true);
        this.actionTDPrintPreview.setEnabled(true);
        this.btnSuoPei.setEnabled(true);
        this.actionSuoPei.setEnabled(true);
        this.tblMain.getColumn("IssueDate").getStyleAttributes().setNumberFormat(this.dformat);
        this.tblMain.getColumn("ExpiredDate").getStyleAttributes().setNumberFormat(this.dformat);
        this.tblMain.getColumn("guaranteeDate").getStyleAttributes().setNumberFormat(this.dformat);
        this.tblMain.getColumn("reAssureDate").getStyleAttributes().setNumberFormat(this.dformat);
        this.tblMain.getColumn("cancelDate").getStyleAttributes().setNumberFormat(this.dformat);
        this.setAutoCancel();
    }

    private void setAutoCancel() throws BOSException, EASBizException {
        Date currentDate = new Date(DateTimeUtils.truncateDate((java.util.Date)new java.util.Date()).getTime());
        CompanyOrgUnitInfo company = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        ArrayList idList = new ArrayList();
        HashSet<String> set = new HashSet<String>();
        String osql = "select id where ExpiredDate < '" + currentDate + "' and state = 2 and isDis = 0 and Company = '" + company.getId() + "'";
        LetterOfGuaranteeCollection collection = LetterOfGuaranteeFactory.getRemoteInstance().getLetterOfGuaranteeCollection(osql);
        for (int i = 0; i < collection.size(); ++i) {
            set.add(collection.get(i).getId().toString());
        }
        LetterOfGuaranteeFactory.getRemoteInstance().autoCancel(set, false);
        this.tblMain.refresh();
    }

    public FMFilterBaseUI getFilterUI() throws Exception {
        if (this.filterUI == null) {
            this.filterUI = new LetterOfGuaranteeFilterUI();
        }
        return this.filterUI;
    }

    @Override
    protected OrgType getMainBizOrgType() {
        return OrgType.Company;
    }

    @Override
    public SelectorItemCollection getBOTPSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("voucherType.*"));
        sic.add(new SelectorItemInfo("Type.*"));
        sic.add(new SelectorItemInfo("Currency.*"));
        sic.add(new SelectorItemInfo("GaranteeType.*"));
        sic.add(new SelectorItemInfo("CreditLimit.*"));
        sic.add(new SelectorItemInfo("Institution.*"));
        sic.add(new SelectorItemInfo("CreditCurrency.*"));
        sic.add(new SelectorItemInfo("assureBill.*"));
        sic.add(new SelectorItemInfo("assCurrency.*"));
        sic.add(new SelectorItemInfo("guaranteeEntrys.*"));
        sic.add(new SelectorItemInfo("guaranteeEntrys.guaranteeType.*"));
        sic.add(new SelectorItemInfo("guaranteeEntrys.currency.*"));
        sic.add(new SelectorItemInfo("guaranteeEntrys.guaranteeComp.*"));
        sic.add(new SelectorItemInfo("LGType.*"));
        sic.add(new SelectorItemInfo("BlockFlowType.*"));
        return sic;
    }

    protected void getRowSetBeforeFillTable(IRowSet rowSet) {
        super.getRowSetBeforeFillTable(rowSet);
        if (rowSet != null) {
            try {
                while (rowSet.next()) {
                    BigDecimal contractAmount = rowSet.getBigDecimal("contractAmount");
                    if (contractAmount != null) continue;
                    rowSet.updateBigDecimal("contractAmount", Constants.ZERO);
                }
            }
            catch (SQLException e) {
                this.handUIException(e);
            }
        }
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.actionSubmit.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_submit"));
        this.actionCancelNoPay.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_nocollate"));
        this.actionSuoPei.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_nocollate"));
        this.actionAntiCancelNoPay.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_scvoucher"));
        this.actionAudit.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_audit"));
        this.actionAntiAudit.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_unaudit"));
        this.actionFee.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_readin"));
        this.actionFeeView.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_view"));
        this.actionModifyLetter.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_edit"));
        this.actionTDPrint.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_credenceprint"));
        this.actionTDPrintPreview.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_preview"));
    }

    @Override
    protected String getEditUIName() {
        return LetterOfGuaranteeEditUI.class.getName();
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return LetterOfGuaranteeFactory.getRemoteInstance();
    }

    protected void checkBizUnit() throws EASBizException, BOSException {
        super.checkBizUnit();
        CompanyOrgUnitInfo company = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        if (ContextHelperFactory.getRemoteInstance().isOnlyUnion(company)) {
            this.btnCreateTo.setVisible(false);
            this.actionFee.setVisible(false);
            this.actionModifyLetter.setVisible(false);
            this.actionSuoPei.setVisible(false);
            this.actionCancelNoPay.setVisible(false);
            this.actionAntiCancelNoPay.setVisible(false);
            this.actionSubmit.setVisible(false);
            this.actionAudit.setVisible(false);
            this.actionAntiAudit.setVisible(false);
        } else {
            this.btnCreateTo.setVisible(true);
        }
    }

    protected String getCurrencyIdColName() {
        return "CurrencyId";
    }

    protected String[] getPrecColName() {
        return new String[]{"UsedQuota", "Amount", "Balance", "LocalCurExRate", "guanAmount", "guanRate", "fee", "contractAmount", "openAmount"};
    }

    protected FilterInfo getDefaultFilterForQuery() {
        FilterInfo filterInfo = super.getDefaultFilterForQuery();
        int botpState = this.getBOTPViewStatus();
        Object botpParam = this.getUIContext().get("BTPEDITPARAMETER");
        if (botpState == 1 && botpParam != null) {
            if (filterInfo == null) {
                filterInfo = new FilterInfo();
            }
            filterInfo.getFilterItems().add(new FilterItemInfo("Balance", (Object)Constants.ZERO, CompareType.GREATER));
        }
        return filterInfo;
    }

    @Override
    protected boolean isFootVisible() {
        return true;
    }

    protected void initListener() {
        super.initListener();
        this.tblMain.getDataRequestManager().addDataFillListener((KDTDataFillListener)new FillListener());
    }

    @Override
    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        if (!this.currentCompanyCommon.isIsBizUnit()) {
            throw new FMException(FMException.UNIONCANNOTOPRT);
        }
        LetterOfGuaranteeInfo info = this.getSelectedInfo();
        if (info.isIsDis() || info.isIsSuoPei()) {
            MsgBox.showInfo((String)EASResource.getString((String)CTLRESOURCE, (String)"111_LetterOfGuaranteeListUI"));
            this.abort();
        }
        if (LetterOfGuaranteeHelper.isCanEdit(info)) {
            super.actionEdit_actionPerformed(e);
        } else {
            boolean isAllowUpdate = ContextHelperFactory.getRemoteInstance().getBooleanParam("CTL002", (IObjectPK)new ObjectUuidPK(this.currentCompanyCommon.getId()));
            if (isAllowUpdate) {
                if (info.getBalance().compareTo(info.getAmount()) == 0) {
                    super.actionEdit_actionPerformed(e);
                } else {
                    MsgBox.showInfo((String)EASResource.getString((String)CTLRESOURCE, (String)"111_LetterOfGuaranteeListUI"));
                }
            } else if (LetterOfGuaranteeStateEnum.APPROVE.equals((Object)info.getState())) {
                MsgBox.showInfo((String)EASResource.getString((String)CTLRESOURCE, (String)"94_GuaranteeApplyListUI"));
            } else if (info.isFiVouchered()) {
                MsgBox.showInfo((String)EASResource.getString((String)CTLRESOURCE, (String)"112_LetterOfGuaranteeListUI"));
            } else {
                throw new FinBizException(FinBizException.BALANCEISZERO);
            }
        }
    }

    @Override
    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        LetterOfGuaranteeInfo info = this.getSelectedInfo();
        if (LetterOfGuaranteeHelper.isCanRemove(info)) {
            super.actionRemove_actionPerformed(e);
        } else if (LetterOfGuaranteeStateEnum.APPROVE.equals((Object)info.getState())) {
            MsgBox.showInfo((String)EASResource.getString((String)CTLRESOURCE, (String)"96_GuaranteeApplyListUI"));
        } else if (info.isFiVouchered()) {
            MsgBox.showInfo((String)EASResource.getString((String)CTLRESOURCE, (String)"112_LetterOfGuaranteeListUI"));
        } else {
            throw new FinBizException(FinBizException.BALANCEISZERO);
        }
    }

    @Override
    public void actionCancelNoPay_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList idList = this.getSelectedIdValues();
        HashSet idSet = new HashSet(idList);
        ArrayList<String> resultList = this.checkCanCancelNoPay(idSet);
        if (resultList.size() != 0) {
            StringBuffer errorDetail = new StringBuffer("");
            for (int i = 0; i < resultList.size(); ++i) {
                errorDetail.append(resultList.get(i));
                errorDetail.append("\r\n");
            }
            String errorTitle = EASResource.getString((String)CTLRESOURCE, (String)"122_ReceiveLetterListUI");
            MsgBox.showDetailAndOK((Component)((Object)this), (String)errorTitle, (String)errorDetail.toString(), (int)0);
        } else {
            LetterOfGuaranteeFactory.getRemoteInstance().autoCancel(idSet, true);
            MsgBox.showInfo((String)EASResource.getString((String)CTLRESOURCE, (String)"113_LetterOfGuaranteeListUI"));
            this.refresh(e);
        }
    }

    private ArrayList<String> checkCanCancelNoPay(Set idSet) throws BOSException {
        ArrayList<String> resultList = new ArrayList<String>();
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sel = new SelectorItemCollection();
        sel.add(new SelectorItemInfo("number"));
        sel.add(new SelectorItemInfo("state"));
        sel.add(new SelectorItemInfo("isDis"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        view.setSelector(sel);
        view.setFilter(filter);
        LetterOfGuaranteeCollection colls = LetterOfGuaranteeFactory.getRemoteInstance().getLetterOfGuaranteeCollection(view);
        for (int i = 0; i < colls.size(); ++i) {
            LetterOfGuaranteeInfo info = colls.get(i);
            if (info.isIsDis()) {
                resultList.add(EASResource.getString((String)CTLRESOURCE, (String)"157_Letter_HasDis", (Object[])new Object[]{info.getNumber()}));
                continue;
            }
            if (LetterOfGuaranteeStateEnum.APPROVE.equals((Object)info.getState())) continue;
            resultList.add(EASResource.getString((String)CTLRESOURCE, (String)"158_STATUS_NOT_AUDIT", (Object[])new Object[]{info.getNumber()}));
        }
        return resultList;
    }

    @Override
    public void actionAntiCancelNoPay_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList idList = this.getSelectedIdValues();
        HashSet idSet = new HashSet(idList);
        ArrayList<String> resultList = this.checkCanAntiCancelNoPay(idSet);
        if (resultList.size() != 0) {
            StringBuffer errorDetail = new StringBuffer("");
            for (int i = 0; i < resultList.size(); ++i) {
                errorDetail.append(resultList.get(i));
                errorDetail.append("\r\n");
            }
            String errorTitle = EASResource.getString((String)CTLRESOURCE, (String)"64_AssureBillListUI");
            MsgBox.showDetailAndOK((Component)((Object)this), (String)errorTitle, (String)errorDetail.toString(), (int)0);
        } else {
            LetterOfGuaranteeFactory.getRemoteInstance().batchAntiCancelNoPay(idSet);
            MsgBox.showInfo((String)EASResource.getString((String)CTLRESOURCE, (String)"115_LetterOfGuaranteeListUI"));
            this.refresh(e);
        }
    }

    private ArrayList<String> checkCanAntiCancelNoPay(Set idSet) throws BOSException {
        ArrayList<String> resultList = new ArrayList<String>();
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sel = new SelectorItemCollection();
        sel.add(new SelectorItemInfo("number"));
        sel.add(new SelectorItemInfo("state"));
        sel.add(new SelectorItemInfo("isDis"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        view.setSelector(sel);
        view.setFilter(filter);
        LetterOfGuaranteeCollection colls = LetterOfGuaranteeFactory.getRemoteInstance().getLetterOfGuaranteeCollection(view);
        for (int i = 0; i < colls.size(); ++i) {
            LetterOfGuaranteeInfo info = colls.get(i);
            if (info.isIsDis()) continue;
            resultList.add(EASResource.getString((String)CTLRESOURCE, (String)"164_NoRepeal", (Object[])new Object[]{info.getNumber()}));
        }
        return resultList;
    }

    @Override
    public void actionAudit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList idList = this.getSelectedIdValues();
        HashSet idSet = new HashSet(idList);
        ArrayList<String> resultList = this.checkCanAudit(idSet, e);
        if (resultList.size() != 0) {
            StringBuffer errorDetail = new StringBuffer("");
            for (int i = 0; i < resultList.size(); ++i) {
                errorDetail.append(resultList.get(i));
                errorDetail.append("\r\n");
            }
            String errorTitle = EASResource.getString((String)CTLRESOURCE, (String)"160_LetterOfGuaranteeListUI");
            MsgBox.showDetailAndOK((Component)((Object)this), (String)errorTitle, (String)errorDetail.toString(), (int)0);
        } else if (!EmptyUtil.isEmpty(idSet)) {
            LetterOfGuaranteeFactory.getRemoteInstance().batchAudit(idSet);
            MsgBox.showInfo((String)EASResource.getString((String)CTLRESOURCE, (String)"65_AssureBillListUI"));
            this.refresh(e);
        }
    }

    private ArrayList<String> checkCanAudit(Set idSet, ActionEvent e) throws Exception {
        ArrayList<String> resultList = new ArrayList<String>();
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sel = new SelectorItemCollection();
        sel.add(new SelectorItemInfo("number"));
        sel.add(new SelectorItemInfo("state"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        view.setSelector(sel);
        view.setFilter(filter);
        LetterOfGuaranteeCollection colls = LetterOfGuaranteeFactory.getRemoteInstance().getLetterOfGuaranteeCollection(view);
        for (int i = 0; i < colls.size(); ++i) {
            LetterOfGuaranteeInfo info = colls.get(i);
            boolean hasWf = FMHelper.hasWFInstance(null, (String)info.getId().toString());
            if (hasWf) {
                Iterator iterator = idSet.iterator();
                while (iterator.hasNext()) {
                    String id = (String)iterator.next();
                    if (!id.equals(info.getId().toString())) continue;
                    iterator.remove();
                }
                this.actionMultiapprove_actionPerformed(e);
                continue;
            }
            if (LetterOfGuaranteeHelper.isCanAudit(info)) continue;
            resultList.add(EASResource.getString((String)CTLRESOURCE, (String)"159_No_Submit", (Object[])new Object[]{info.getNumber()}));
        }
        return resultList;
    }

    @Override
    public void actionAntiAudit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList idList = this.getSelectedIdValues();
        HashSet idSet = new HashSet(idList);
        ArrayList<String> resultList = this.checkCanAntiAudit(idSet, e);
        if (resultList.size() != 0) {
            StringBuffer errorDetail = new StringBuffer("");
            for (int i = 0; i < resultList.size(); ++i) {
                errorDetail.append(resultList.get(i));
                errorDetail.append("\r\n");
            }
            String errorTitle = EASResource.getString((String)CTLRESOURCE, (String)"117_LetterOfGuaranteeListUI");
            MsgBox.showDetailAndOK((Component)((Object)this), (String)errorTitle, (String)errorDetail.toString(), (int)0);
        } else {
            LetterOfGuaranteeFactory.getRemoteInstance().batchAntiAudit(idSet);
            MsgBox.showInfo((String)EASResource.getString((String)CTLRESOURCE, (String)"100_GuaranteeApplyListUI"));
            this.refresh(e);
        }
    }

    private ArrayList<String> checkCanAntiAudit(Set idSet, ActionEvent e) throws Exception {
        ArrayList<String> resultList = new ArrayList<String>();
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sel = new SelectorItemCollection();
        sel.add(new SelectorItemInfo("number"));
        sel.add(new SelectorItemInfo("isDis"));
        sel.add(new SelectorItemInfo("isSuoPei"));
        sel.add(new SelectorItemInfo("state"));
        sel.add(new SelectorItemInfo("fiVouchered"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        view.setSelector(sel);
        view.setFilter(filter);
        LetterOfGuaranteeCollection colls = LetterOfGuaranteeFactory.getRemoteInstance().getLetterOfGuaranteeCollection(view);
        for (int i = 0; i < colls.size(); ++i) {
            LetterOfGuaranteeInfo info = colls.get(i);
            boolean hasWf = FMHelper.hasWFInstance(null, (String)info.getId().toString());
            if (hasWf) {
                this.actionMultiapprove_actionPerformed(e);
                continue;
            }
            if (info.isIsDis()) {
                resultList.add(EASResource.getString((String)CTLRESOURCE, (String)"161_hasDis", (Object[])new Object[]{info.getNumber()}));
                continue;
            }
            if (info.isIsSuoPei()) {
                resultList.add(EASResource.getString((String)CTLRESOURCE, (String)"162_hasClaim", (Object[])new Object[]{info.getNumber()}));
                continue;
            }
            if (!info.getState().equals((Object)LetterOfGuaranteeStateEnum.APPROVE)) {
                resultList.add(EASResource.getString((String)CTLRESOURCE, (String)"163_NoApprove", (Object[])new Object[]{info.getNumber()}));
                continue;
            }
            if (!info.isFiVouchered()) continue;
            resultList.add(EASResource.getString((String)CTLRESOURCE, (String)"165_hasVouchered", (Object[])new Object[]{info.getNumber()}));
        }
        return resultList;
    }

    @Override
    public void actionVoucher_actionPerformed(ActionEvent e) throws Exception {
        LetterOfGuaranteeInfo info = this.getSelectedInfo();
        if (LetterOfGuaranteeHelper.isCanVoucher(info)) {
            super.actionVoucher_actionPerformed(e);
        } else {
            MsgBox.showInfo((String)EASResource.getString((String)CTLRESOURCE, (String)"118_LetterOfGuaranteeListUI"));
        }
    }

    @Override
    public void actionDelVoucher_actionPerformed(ActionEvent e) throws Exception {
        super.actionDelVoucher_actionPerformed(e);
    }

    @Override
    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        super.actionSubmit_actionPerformed(e);
        this.checkSelected();
        ArrayList idList = this.getSelectedIdValues();
        HashSet idSet = new HashSet(idList);
        ILetterOfGuarantee LG = (ILetterOfGuarantee)this.getBizInterface();
        LG.batchSubmit(idSet);
        this.refreshList();
        MsgBox.showInfo((String)EASResource.getString((String)CTLRESOURCE, (String)"62_AssureBillListUI"));
    }

    @Override
    public void actionFee_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("isDis");
        sic.add("number");
        sic.add("amount");
        LetterOfGuaranteeInfo info = LetterOfGuaranteeFactory.getRemoteInstance().getLetterOfGuaranteeInfo((IObjectPK)new ObjectUuidPK(this.getSelectedKeyValue()), sic);
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"Guaranteeinfo", (Object)info);
        uiContext.put((Object)"ID", null);
        this.prepareUIContext(uiContext, e);
        IUIWindow uiWindow = null;
        uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewTabFactory").create(FeeForGuaranteeFMUI.class.getName(), (Map)uiContext, null, OprtState.ADDNEW);
        uiWindow.show();
    }

    @Override
    public void actionFeeView_actionPerformed(ActionEvent e) throws Exception {
        super.actionFeeView_actionPerformed(e);
        this.checkSelected();
        SelectorItemCollection sic = new SelectorItemCollection();
        LetterOfGuaranteeInfo info = LetterOfGuaranteeFactory.getRemoteInstance().getLetterOfGuaranteeInfo((IObjectPK)new ObjectUuidPK(this.getSelectedKeyValue()), sic);
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"BOTPViewStatus", (Object)new Integer(1));
        uiContext.put((Object)"Guaranteeinfo", (Object)info);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("GuaranteeId", (Object)this.getSelectedKeyValue()));
        HashMap<String, FilterInfo> aa = new HashMap<String, FilterInfo>();
        aa.put("DefaultQueryFilter", filter);
        uiContext.put((Object)"BTPEDITPARAMETER", aa);
        IUIWindow uiWindow = null;
        uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewTabFactory").create(FeeForGuaranteeListUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
        uiWindow.show();
    }

    @Override
    public void actionModifyLetter_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        int rowNumber = FMClientHelper.getSelectedRow((KDTable)this.tblMain);
        IRow row = this.tblMain.getRow(rowNumber);
        BigDecimal amount = (BigDecimal)row.getCell("Amount").getValue();
        BigDecimal Balance = (BigDecimal)row.getCell("Balance").getValue();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("Currency.id"));
        sic.add(new SelectorItemInfo("Currency.number"));
        sic.add(new SelectorItemInfo("Currency.name"));
        sic.add(new SelectorItemInfo("dealer.id"));
        sic.add(new SelectorItemInfo("dealer.number"));
        sic.add(new SelectorItemInfo("dealer.name"));
        sic.add(new SelectorItemInfo("LGType.id"));
        sic.add(new SelectorItemInfo("LGType.number"));
        sic.add(new SelectorItemInfo("LGType.name"));
        sic.add(new SelectorItemInfo("applyUnit.id"));
        sic.add(new SelectorItemInfo("applyUnit.number"));
        sic.add(new SelectorItemInfo("applyUnit.name"));
        sic.add(new SelectorItemInfo("department.number"));
        sic.add(new SelectorItemInfo("department.name"));
        sic.add(new SelectorItemInfo("transBank.number"));
        sic.add(new SelectorItemInfo("transBank.name"));
        sic.add(new SelectorItemInfo("state"));
        LetterOfGuaranteeInfo info = LetterOfGuaranteeFactory.getRemoteInstance().getLetterOfGuaranteeInfo((IObjectPK)new ObjectUuidPK(this.getSelectedKeyValue()), sic);
        if (!info.getState().equals((Object)LetterOfGuaranteeStateEnum.APPROVE)) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"NOT_APPROVE"));
            return;
        }
        if (!LetterOfGuaranteeFactory.getRemoteInstance().HasNoAudit(this.getSelectedKeyValue())) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"HasNoAudit"));
            return;
        }
        java.util.Date datereAssureDate = DateTimeUtils.truncateDate((java.util.Date)info.getReAssureDate());
        java.util.Date dqDate = DateTimeUtils.truncateDate((java.util.Date)new java.util.Date());
        if (datereAssureDate != null && dqDate.after(datereAssureDate)) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"LGdatereAssureDateMustAfterToday"));
            return;
        }
        if (info.getState() == LetterOfGuaranteeStateEnum.SAVE) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"isSave"));
            return;
        }
        if (info.isIsDis()) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"HasRevoked_31"));
            return;
        }
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"Guaranteeinfo", (Object)info);
        uiContext.put((Object)"ID", null);
        this.prepareUIContext(uiContext, e);
        IUIWindow uiWindow = null;
        uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewTabFactory").create(LetOfGuaranteeEditUI.class.getName(), (Map)uiContext, null, OprtState.ADDNEW);
        uiWindow.show();
    }

    private void checkRepayment(String id) throws BOSException, EASBizException {
        String sql = "select fid from T_FIN_Repayment where fsourcebillid ='" + id + "' ";
        IRowSet rs1 = SQLExecutorFactory.getRemoteInstance((String)sql).executeSQL();
        try {
            if (rs1.next()) {
                throw new FinBizException(FinBizException.ANTICANCLEREPAYMENT);
            }
        }
        catch (SQLException e) {
            throw new FinBizException(FinBizException.ANTICANCLEREPAYMENT);
        }
    }

    private LetterOfGuaranteeInfo getSelectedInfo() throws EASBizException, BOSException {
        this.checkSelected();
        String id = this.getSelectedKeyValue();
        LetterOfGuaranteeInfo info = LetterOfGuaranteeFactory.getRemoteInstance().getLetterOfGuaranteeInfo((IObjectPK)new ObjectUuidPK(id));
        return info;
    }

    private String getResString(String key) {
        return EASResource.getString((String)RESOURCE, (String)key);
    }

    protected void execQuery() {
        String from;
        Map botpCtx = (Map)this.getUIContext().get("BTPEDITPARAMETER");
        if (botpCtx != null && "fromRepayment".equals(from = (String)botpCtx.get("fromRepayment"))) {
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("state", (Object)new Integer(2)));
            try {
                this.mainQuery.getFilter().mergeFilter(filter, "AND");
            }
            catch (BOSException e) {
                this.handUIException(e);
            }
        }
        super.execQuery();
        this.formatFootRow();
    }

    protected IRow appendFootRow() {
        IRow sumRow = super.appendFootRow();
        this.formatFootRow();
        return sumRow;
    }

    public FilterInfo getFilterInfo() {
        String from;
        FilterInfo filter = super.getFilterInfo();
        Map botpCtx = (Map)this.getUIContext().get("BTPEDITPARAMETER");
        if (botpCtx != null && "fromRepayment".equals(from = (String)botpCtx.get("fromRepayment"))) {
            filter.getFilterItems().add(new FilterItemInfo("state", (Object)new Integer(2)));
            filter.getFilterItems().add(new FilterItemInfo("isDis", (Object)Boolean.FALSE));
        }
        return filter;
    }

    protected void refresh(ActionEvent e) throws Exception {
        super.refresh(e);
        this.formatFootRow();
    }

    private void formatFootRow() {
        CompanyOrgUnitInfo company = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        try {
            LetterOfGuaranteeFilterParam param = (LetterOfGuaranteeFilterParam)this.getFilterUI().getParam();
            IRow row = this.tblMain.getFootManager().getFootRow(0);
            String curID = null;
            curID = param.getCurrency() == null ? company.getBaseCurrency().getId().toString() : param.getCurrency();
            String[] columns = new SumFiledsInfo(SumBillEnum.YinHangBaoHan).getSumFileds();
            for (int i = 0; i < columns.length; ++i) {
                FMClientHelper.setNumberFormat((IRow)row, (String)columns[i], (String)curID);
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void actionTDPrint_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList idList = super.getSelectedIdValues();
        if (idList == null || idList.size() == 0 || this.getTDQueryPK() == null || this.getTDFileName() == null) {
            return;
        }
        CommonDataProvider data = new CommonDataProvider((List)idList, this.getTDQueryPK());
        KDNoteHelper appHlp = new KDNoteHelper();
        appHlp.print(this.getTDFileName(), (Object)data, (Component)SwingUtilities.getWindowAncestor((Component)((Object)this)));
    }

    @Override
    public void actionTDPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList idList = super.getSelectedIdValues();
        if (idList == null || idList.size() == 0 || this.getTDQueryPK() == null || this.getTDFileName() == null) {
            return;
        }
        CommonDataProvider data = new CommonDataProvider((List)idList, this.getTDQueryPK());
        KDNoteHelper appHlp = new KDNoteHelper();
        appHlp.printPreview(this.getTDFileName(), (Object)data, (Component)SwingUtilities.getWindowAncestor((Component)((Object)this)));
    }

    protected String getTDFileName() {
        return tdTemplateFile;
    }

    protected IMetaDataPK getTDQueryPK() {
        return new MetaDataPK("com.kingdee.eas.fm.ctl.app.LetterOfGuaranteeTDQuery");
    }

    @Override
    public void actionSuoPei_actionPerformed(ActionEvent e) throws Exception {
        LetterOfGuaranteeInfo info = this.getSelectedInfo();
        if (LetterOfGuaranteeHelper.isCanCancel(info)) {
            if (!info.isIsDis() && info.getBalance().doubleValue() != 0.0) {
                BigDecimal Balance;
                BigDecimal amount = info.getAmount();
                if (amount.compareTo(Balance = info.getBalance()) != 0) {
                    FMClientHelper.generateDestBill((CoreBillListUI)this, (String)new LetterOfGuaranteeInfo().getBOSType().toString(), (String)RepaymentInfo.BOSTYPE.toString(), (String)info.getId().toString(), (String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
                } else {
                    FMClientHelper.generateDestBill((CoreBillListUI)this, (String)new LetterOfGuaranteeInfo().getBOSType().toString(), (String)RepaymentInfo.BOSTYPE.toString(), (String)info.getId().toString(), (String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
                }
                this.refresh(e);
            } else {
                MsgBox.showInfo((String)EASResource.getString((String)CTLRESOURCE, (String)"119_LetterOfGuaranteeListUI"));
            }
        } else {
            MsgBox.showInfo((String)EASResource.getString((String)CTLRESOURCE, (String)"120_LetterOfGuaranteeListUI"));
        }
    }

    protected boolean isIgnoreBizUnit() {
        return false;
    }

    protected SystemEnum getSystemEnum() {
        return SystemEnum.CTL_MANAGE;
    }

    protected String getDateField() {
        return "IssueDate";
    }

    protected String[] getControlActions() {
        return new String[]{"actionEdit", "actionRemove", "actionSubmit", "actionAntiAudit"};
    }

    public String getPropertyOfBizOrg(OrgType orgType) {
        return "company.id";
    }

    public String[] getPropertyOfCopOrg() {
        return null;
    }

    private final class FillListener
    implements KDTDataFillListener {
        private FillListener() {
        }

        public void afterDataFill(KDTDataRequestEvent e) {
            this.fillTable(LetterOfGuaranteeListUI.this.tblMain, e);
        }

        private void fillTable(KDTable tblMain, KDTDataRequestEvent e) {
            IRow row = null;
            String currencyId = null;
            for (int i = e.getFirstRow(); i <= e.getLastRow(); ++i) {
                row = tblMain.getRow(i);
                row.getCell("guanRate").getStyleAttributes().setNumberFormat("###,##0.0000000000");
                if (row.getCell("creditCurrencyId").getValue() != null) {
                    currencyId = row.getCell("creditCurrencyId").getValue().toString();
                    FMClientHelper.setNumberFormat((IRow)row, (String)"creditLocalAmt", (String)currencyId);
                    continue;
                }
                if (row.getCell("CurrencyId").getValue() == null) continue;
                currencyId = row.getCell("CurrencyId").getValue().toString();
                FMClientHelper.setNumberFormat((IRow)row, (String)"creditLocalAmt", (String)currencyId);
            }
        }
    }
}

