/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.ctl.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.common.client.DefaultKDTCurrencyProvider;
import com.kingdee.eas.fm.common.client.DefaultKDTablePrecisionFormater;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMFilterBaseUI;
import com.kingdee.eas.fm.common.client.IKDTPrecisionProvider;
import com.kingdee.eas.fm.common.client.IKDTablePrecisionFormater;
import com.kingdee.eas.fm.ctl.IReceiveLetter;
import com.kingdee.eas.fm.ctl.ReceiveLetterFactory;
import com.kingdee.eas.fm.ctl.ReceiveLetterInfo;
import com.kingdee.eas.fm.ctl.ReceiveRepayInfo;
import com.kingdee.eas.fm.ctl.ReceiveStateEnum;
import com.kingdee.eas.fm.ctl.client.AbstractReceiveLetterListUI;
import com.kingdee.eas.fm.ctl.client.ReceiveLetterEditUI;
import com.kingdee.eas.fm.ctl.client.ReceiveLetterFilterParam;
import com.kingdee.eas.fm.ctl.client.ReceiveLetterFilterUI;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.client.CoreBillListUI;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.event.ActionEvent;
import org.apache.log4j.Logger;

public class ReceiveLetterListUI
extends AbstractReceiveLetterListUI {
    private static final Logger logger = CoreUIObject.getLogger(ReceiveLetterListUI.class);
    private ReceiveLetterFilterUI filterUI = null;
    private IKDTablePrecisionFormater precFormater = new DefaultKDTablePrecisionFormater();

    public ReceiveLetterListUI() throws Exception {
        this.precFormater.setPrecProvider((IKDTPrecisionProvider)new DefaultKDTCurrencyProvider(this.getCurrencyIdColName()));
    }

    public void onLoad() throws Exception {
        this.precFormater.init(this.getMainTable(), this.getPrecColName());
        super.onLoad();
        this.checkBizUnit();
        this.actionAuditResult.setVisible(false);
        this.btnAttachment.setVisible(false);
        this.actionCreateTo.setVisible(false);
        this.actionCopyTo.setVisible(false);
        this.tblMain.getColumn("applyDate").getStyleAttributes().setNumberFormat(this.dformat);
        this.tblMain.getColumn("IssueDate").getStyleAttributes().setNumberFormat(this.dformat);
        this.tblMain.getColumn("ExpiredDate").getStyleAttributes().setNumberFormat(this.dformat);
        this.tblMain.getColumn("ApprovalDate").getStyleAttributes().setNumberFormat(this.dformat);
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public FMFilterBaseUI getFilterUI() throws Exception {
        if (this.filterUI == null) {
            this.filterUI = new ReceiveLetterFilterUI();
        }
        return this.filterUI;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return ReceiveLetterFactory.getRemoteInstance();
    }

    protected String getEditUIName() {
        return ReceiveLetterEditUI.class.getName();
    }

    @Override
    public void actionAudit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String id = this.getSelectedKeyValue();
        ObjectUuidPK pk = new ObjectUuidPK(id);
        IReceiveLetter receive = ReceiveLetterFactory.getRemoteInstance();
        ReceiveLetterInfo info = receive.getReceiveLetterInfo((IObjectPK)pk);
        if (ReceiveStateEnum.SUBMIT.equals((Object)info.getState())) {
            receive.audit((IObjectPK)pk);
            this.refreshList();
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.ctl.CTLAutoGenerateResource", (String)"65_AssureBillListUI"));
        } else {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.ctl.CTLAutoGenerateResource", (String)"33_ReceiveLetterControllerBean"));
        }
    }

    @Override
    public void actionAntiAudit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String id = this.getSelectedKeyValue();
        ObjectUuidPK pk = new ObjectUuidPK(id);
        IReceiveLetter receive = ReceiveLetterFactory.getRemoteInstance();
        ReceiveLetterInfo info = receive.getReceiveLetterInfo((IObjectPK)pk);
        if (ReceiveStateEnum.APPROVE.equals((Object)info.getState()) && !info.isIsDis()) {
            receive.antiAudit((IObjectPK)pk);
            this.refreshList();
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.ctl.CTLAutoGenerateResource", (String)"67_AssureBillListUI"));
        } else {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.ctl.CTLAutoGenerateResource", (String)"121_ReceiveLetterListUI"));
        }
    }

    @Override
    public void actionCanDis_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String id = this.getSelectedKeyValue();
        ObjectUuidPK pk = new ObjectUuidPK(id);
        IReceiveLetter receive = ReceiveLetterFactory.getRemoteInstance();
        ReceiveLetterInfo info = receive.getReceiveLetterInfo((IObjectPK)pk);
        if (ReceiveStateEnum.APPROVE.equals((Object)info.getState()) && !info.isIsDis()) {
            receive.Cancel((IObjectPK)pk);
            this.refreshList();
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.ctl.CTLAutoGenerateResource", (String)"84_BankFactorListUI"));
        } else {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.ctl.CTLAutoGenerateResource", (String)"122_ReceiveLetterListUI"));
        }
    }

    @Override
    public void actionAntiCanDis_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String id = this.getSelectedKeyValue();
        ObjectUuidPK pk = new ObjectUuidPK(id);
        IReceiveLetter receive = ReceiveLetterFactory.getRemoteInstance();
        ReceiveLetterInfo info = receive.getReceiveLetterInfo((IObjectPK)pk);
        if (ReceiveStateEnum.APPROVE.equals((Object)info.getState()) && info.isIsDis()) {
            receive.AntiCancel((IObjectPK)pk);
            this.refreshList();
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.ctl.CTLAutoGenerateResource", (String)"86_BankFactorListUI"));
        } else {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.ctl.CTLAutoGenerateResource", (String)"123_ReceiveLetterListUI"));
        }
    }

    @Override
    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String id = this.getSelectedKeyValue();
        ObjectUuidPK pk = new ObjectUuidPK(id);
        IReceiveLetter receive = ReceiveLetterFactory.getRemoteInstance();
        ReceiveLetterInfo info = receive.getReceiveLetterInfo((IObjectPK)pk);
        if (ReceiveStateEnum.SAVE.equals((Object)info.getState())) {
            info.setState(ReceiveStateEnum.SUBMIT);
            receive.submit((CoreBaseInfo)info);
            this.refreshList();
        } else {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.ctl.CTLAutoGenerateResource", (String)"17_GuaranteeApplyControllerBean"));
        }
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.actionSubmit.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_submit"));
        this.actionCanDis.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_nocollate"));
        this.actionSuoPei.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_nocollate"));
        this.actionAntiCanDis.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_scvoucher"));
        this.actionAudit.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_audit"));
        this.actionAntiAudit.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_unaudit"));
        this.btnAuditResult.setVisible(false);
    }

    protected String getCurrencyIdColName() {
        return "Currency.ID";
    }

    protected String[] getPrecColName() {
        return new String[]{"Amount", "AmountLoculCur", "Balance", "bargainAmount"};
    }

    protected void checkBizUnit() throws EASBizException, BOSException {
        CompanyOrgUnitInfo company = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        if (ContextHelperFactory.getRemoteInstance().isOnlyUnion(company)) {
            this.btnVoucher.setVisible(false);
            this.btnDelVoucher.setVisible(false);
            this.btnAddNew.setVisible(false);
            this.menuItemAddNew.setVisible(false);
            this.btnEdit.setVisible(false);
            this.menuItemEdit.setVisible(false);
            this.btnRemove.setVisible(false);
            this.menuItemRemove.setVisible(false);
            this.actionAudit.setEnabled(false);
            this.actionAntiAudit.setEnabled(false);
            this.actionSubmit.setEnabled(false);
            this.actionCanDis.setEnabled(false);
            this.actionAntiCanDis.setEnabled(false);
            this.actionSuoPei.setEnabled(false);
        }
    }

    public ReceiveLetterInfo getSelectedInfo() throws EASBizException, BOSException {
        this.checkSelected();
        String id = this.getSelectedKeyValue();
        ReceiveLetterInfo info = ReceiveLetterFactory.getRemoteInstance().getReceiveLetterInfo((IObjectPK)new ObjectUuidPK(id));
        return info;
    }

    protected boolean isFootVisible() {
        return true;
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        ReceiveLetterInfo info = this.getSelectedInfo();
        if (!ReceiveStateEnum.APPROVE.equals((Object)info.getState())) {
            super.actionEdit_actionPerformed(e);
        } else {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.ctl.CTLAutoGenerateResource", (String)"124_ReceiveLetterListUI"));
        }
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        ReceiveLetterInfo info = this.getSelectedInfo();
        if (!ReceiveStateEnum.APPROVE.equals((Object)info.getState())) {
            super.actionRemove_actionPerformed(e);
        } else {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.ctl.CTLAutoGenerateResource", (String)"125_ReceiveLetterListUI"));
        }
    }

    @Override
    public void actionSuoPei_actionPerformed(ActionEvent e) throws Exception {
        ReceiveLetterInfo info = this.getSelectedInfo();
        if (ReceiveStateEnum.APPROVE.equals((Object)info.getState()) && !info.isIsDis() && info.getBalance().doubleValue() != 0.0) {
            FMClientHelper.generateDestBill((CoreBillListUI)this, (String)new ReceiveLetterInfo().getBOSType().toString(), (String)new ReceiveRepayInfo().getBOSType().toString(), (String)info.getId().toString());
        } else {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.ctl.CTLAutoGenerateResource", (String)"126_ReceiveLetterListUI"));
        }
    }

    protected IRow appendFootRow() {
        IRow sumRow = super.appendFootRow();
        this.formatFootRow();
        return sumRow;
    }

    protected void execQuery() {
        super.execQuery();
        this.formatFootRow();
    }

    private void formatFootRow() {
        CompanyOrgUnitInfo company = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        try {
            ReceiveLetterFilterParam param = (ReceiveLetterFilterParam)this.getFilterUI().getParam();
            IRow row = this.tblMain.getFootManager().getFootRow(0);
            String curID = null;
            curID = param.getCurrency() == null ? company.getBaseCurrency().getId().toString() : param.getCurrency();
            String[] columns = new String[]{"Amount", "Balance", "bargainAmount"};
            for (int i = 0; i < columns.length; ++i) {
                FMClientHelper.setNumberFormat((IRow)row, (String)columns[i], (String)curID);
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    protected SystemEnum getSystemEnum() {
        return SystemEnum.CTL_MANAGE;
    }

    protected String getDateField() {
        return "IssueDate";
    }

    protected String[] getControlActions() {
        return new String[]{"actionSubmit", "actionEdit", "actionRemove", "actionAntiAudit"};
    }
}

