/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.ctl.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.common.FMSysDefinedEnum;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.ctl.ReceiveStateEnum;
import com.kingdee.eas.fm.ctl.client.AbstractReceiveRepayFilterUI;
import com.kingdee.eas.fm.ctl.client.ReceiveRepayFilterParam;
import com.kingdee.eas.fm.fs.client.CurrencyUtil;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.DateTimeUtils;
import java.sql.Date;
import org.apache.log4j.Logger;

public class ReceiveRepayFilterUI
extends AbstractReceiveRepayFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(ReceiveRepayFilterUI.class);
    public static final String RESOURCE = "com.kingdee.eas.fm.fin.client.FinClientResource";
    CompanyOrgUnitInfo companyInfo = ContextHelperFactory.getRemoteInstance().getCurrentCompany();

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected Class getParamClass() {
        return ReceiveRepayFilterParam.class;
    }

    public Object getParam() {
        ReceiveRepayFilterParam filterParam = new ReceiveRepayFilterParam();
        if (!(this.kDComboBoxCurrency.getSelectedItem() instanceof FMSysDefinedEnum)) {
            filterParam.setCurrency(((CurrencyInfo)this.kDComboBoxCurrency.getSelectedItem()).getId().toString());
        } else {
            filterParam.setCurrency(null);
        }
        filterParam.setCompanyIdSet(this.getCompanyIdSet());
        filterParam.setBeginDate(DateTimeUtils.truncateDate((java.util.Date)this.dpBeginDate.getSqlDate()));
        filterParam.setEndDate(DateTimeUtils.truncateDate((java.util.Date)this.dpEndDate.getSqlDate()));
        if (!FMSysDefinedEnum.SELECT_ALL.equals(this.comboState.getSelectedItem())) {
            filterParam.setStateValue((ReceiveStateEnum)((Object)this.comboState.getSelectedItem()));
        } else {
            filterParam.setStateValue(null);
        }
        return filterParam;
    }

    public void setParam(Object param) {
        ReceiveRepayFilterParam filterParam;
        block9: {
            if (param == null) {
                return;
            }
            filterParam = (ReceiveRepayFilterParam)param;
            this.setCompanyIdSet(filterParam.getCompanyIdSet());
            if (filterParam.getCurrency() != null) {
                try {
                    if (filterParam.getCurrency() != null) {
                        CurrencyInfo cur = CurrencyFactory.getRemoteInstance().getCurrencyInfo((IObjectPK)new ObjectUuidPK(filterParam.getCurrency()));
                        FMClientHelper.setSelectObject((KDComboBox)this.kDComboBoxCurrency, (Object)cur);
                        break block9;
                    }
                    FMClientHelper.setSelectObject((KDComboBox)this.kDComboBoxCurrency, (Object)FMSysDefinedEnum.SELECT_ALL);
                }
                catch (EASBizException e) {
                    this.handUIException(e);
                }
                catch (BOSException e) {
                    this.handUIException(e);
                }
            } else {
                this.kDComboBoxCurrency.setSelectedIndex(this.kDComboBoxCurrency.getItemCount() - 1);
            }
        }
        this.dpBeginDate.setValue((Object)filterParam.getBeginDate());
        this.dpEndDate.setValue((Object)filterParam.getEndDate());
        if (filterParam.getStateValue() == null) {
            FMClientHelper.setSelectObject((KDComboBox)this.comboState, (Object)FMSysDefinedEnum.SELECT_ALL);
        } else {
            FMClientHelper.setSelectObject((KDComboBox)this.comboState, (Object)((Object)filterParam.getStateValue()));
        }
    }

    public boolean verify() {
        Date startDate = this.dpBeginDate.getSqlDate();
        Date endDate = this.dpEndDate.getSqlDate();
        if (startDate == null) {
            MsgBox.showInfo((String)EASResource.getString((String)RESOURCE, (String)"StartDateIsNull"));
            SysUtil.abort();
        }
        if (endDate == null) {
            MsgBox.showInfo((String)EASResource.getString((String)RESOURCE, (String)"EndDateIsNull"));
            SysUtil.abort();
        }
        if (startDate.compareTo(endDate) > 0) {
            MsgBox.showInfo((String)EASResource.getString((String)RESOURCE, (String)"CreditLimitFilterDateCompare"));
            SysUtil.abort();
        }
        return super.verify();
    }

    protected void init() throws Exception {
        super.init();
        CurrencyUtil.fillCombCurrency((KDComboBox)this.kDComboBoxCurrency);
        this.kDComboBoxCurrency.addItem((Object)FMSysDefinedEnum.SELECT_ALL);
        try {
            CurrencyInfo currency = CurrencyUtil.getLocalCurrency();
            FMClientHelper.setSelectObject((KDComboBox)this.kDComboBoxCurrency, (Object)currency);
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        this.companyInfo = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        this.dpBeginDate.setValue((Object)DateUtil.getFirstDayOfCurYear());
        this.dpEndDate.setValue((Object)DateUtil.getDayBegin());
        this.comboState.addItem((Object)FMSysDefinedEnum.SELECT_ALL);
        FMClientHelper.setSelectObject((KDComboBox)this.comboState, (Object)FMSysDefinedEnum.SELECT_ALL);
        this.comboState.removeItemAt(0);
    }
}

