/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.ctl.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.common.AmountUnitEnum;
import com.kingdee.eas.fm.ctl.client.AbstractRptAssureBillUseAnalyseFilterUI;
import com.kingdee.eas.fm.ctl.client.RptAssureBillUseAnalyseFilterParam;
import com.kingdee.eas.fm.ft.RptFundTransferConstants;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import java.util.Calendar;
import java.util.Date;
import org.apache.log4j.Logger;

public class RptAssureBillUseAnalyseFilterUI
extends AbstractRptAssureBillUseAnalyseFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(RptAssureBillUseAnalyseFilterUI.class);

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected void init() throws Exception {
        super.init();
        this.customInit();
    }

    public void clear() {
        super.clear();
        this.customInit();
    }

    private void customInit() {
        this.initDate();
        this.ckboxcancel.setSelected(false);
        this.prmtAssureType.setEnabledMultiSelection(true);
        this.comboUnit.setSelectedItem((Object)AmountUnitEnum.wan_yuan);
        this.filterByGroup.setValue(0);
        this.prmtAssureType.setValue(null);
        try {
            if (ContextHelperFactory.getRemoteInstance().isOnlyUnion(this.currentCompany)) {
                this.byPanel.setVisible(false);
                this.companyIds = null;
            }
        }
        catch (EASBizException e) {
            this.handUIException(e);
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
    }

    private void initDate() {
        this.dpBegin.setValue(null);
        this.dpEnd.setValue((Object)DateUtil.getDayBegin());
        this.dpEnd.setSupportedEmpty(false);
    }

    public boolean verify() {
        super.verify();
        if (this.dpBegin.getValue() != null && this.dpBegin.getSqlDate().after(this.dpEnd.getSqlDate())) {
            MsgBox.showWarning((String)RptFundTransferConstants.REOURCE_READER.getKeyValue("enddate_error"));
            Date d = new Date();
            this.dpBegin.setValue((Object)this.getStartDate(d));
            this.dpBegin.setFocusable(true);
            return false;
        }
        return true;
    }

    private Date getStartDate(Date now) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(now);
        calendar.set(5, 1);
        return calendar.getTime();
    }

    public Object getParam() {
        RptAssureBillUseAnalyseFilterParam filterParam = new RptAssureBillUseAnalyseFilterParam();
        try {
            if (!ContextHelperFactory.getRemoteInstance().isOnlyUnion(this.currentCompany)) {
                filterParam.setQueryType(this.filterByGroup.getValue());
            } else {
                if (this.getCompanyIdSet() != null && this.getCompanyIdSet().size() > 0) {
                    filterParam.setCompanyIdSet(this.getCompanyIdSet());
                }
                filterParam.setQueryType(-1);
            }
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Throwable)e);
            SysUtil.abort();
        }
        catch (EASBizException e) {
            ExceptionHandler.handle((Throwable)e);
            SysUtil.abort();
        }
        filterParam.setStartDate(this.dpBegin.getSqlDate());
        filterParam.setEndDate(this.dpEnd.getSqlDate());
        filterParam.setAssureTypeIdSet(this.getIdSetFromF7(this.prmtAssureType));
        filterParam.setSUnit((AmountUnitEnum)this.comboUnit.getSelectedItem());
        filterParam.setCancel(this.ckboxcancel.isSelected());
        return filterParam;
    }

    public void setParam(Object param) {
        RptAssureBillUseAnalyseFilterParam filterParam = (RptAssureBillUseAnalyseFilterParam)((Object)param);
        if (filterParam != null) {
            this.setCompanyIdSet(filterParam.getCompanyIdSet());
            this.dpBegin.setValue((Object)filterParam.getStartDate());
            this.dpEnd.setValue((Object)filterParam.getEndDate());
            this.comboUnit.setSelectedItem((Object)filterParam.getSUnit());
            this.ckboxcancel.setSelected(filterParam.isCancel());
            try {
                this.prmtAssureType.setValue((Object)this.getBaseInfoFromIdSet(filterParam.getAssureTypeIdSet()));
                if (!ContextHelperFactory.getRemoteInstance().isOnlyUnion(this.currentCompany)) {
                    this.filterByGroup.setValue(filterParam.getQueryType());
                }
            }
            catch (BOSException e) {
                ExceptionHandler.handle((Throwable)e);
                SysUtil.abort();
            }
            catch (EASBizException e) {
                ExceptionHandler.handle((Throwable)e);
                SysUtil.abort();
            }
        }
    }

    protected Class getParamClass() {
        return RptAssureBillUseAnalyseFilterParam.class;
    }
}

