/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.ctl.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.data.logging.Logger;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.fm.IContextHelper;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fm.bond.BondReleaseReportFactory;
import com.kingdee.eas.fm.bond.BondReleaseReportInfo;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.FMIsqlFacadeFactory;
import com.kingdee.eas.fm.common.client.AliasTextValueProvider;
import com.kingdee.eas.fm.common.client.ColumnUserCellDisplayParser;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.IFMDetailRptHandler;
import com.kingdee.eas.fm.common.client.IValueProvider;
import com.kingdee.eas.fm.ctl.LetterOfGuaranteeFactory;
import com.kingdee.eas.fm.ctl.LetterOfGuaranteeInfo;
import com.kingdee.eas.fm.ctl.RelationWithAssuredUnitEnum;
import com.kingdee.eas.fm.ctl.client.RptAssureBillUseAnalyseFilterParam;
import com.kingdee.eas.fm.fin.LetterOfCreditFactory;
import com.kingdee.eas.fm.fin.LetterOfCreditInfo;
import com.kingdee.eas.fm.fin.LoanFactory;
import com.kingdee.eas.fm.fin.LoanInfo;
import com.kingdee.eas.fm.ibt.BillRediscountOutFactory;
import com.kingdee.eas.fm.ibt.BillRediscountOutInfo;
import com.kingdee.eas.fm.ibt.CreditAssetsTransferOutFactory;
import com.kingdee.eas.fm.ibt.CreditAssetsTransferOutInfo;
import com.kingdee.eas.fm.ibt.InnerFinancingBorrowingInFactory;
import com.kingdee.eas.fm.ibt.InnerFinancingBorrowingInInfo;
import com.kingdee.eas.fm.ibt.InnerFinancingBorrowingInfo;
import com.kingdee.eas.fm.im.IntRateTypeExpressionEnum;
import com.kingdee.eas.fm.nt.PayableBillFactory;
import com.kingdee.eas.fm.nt.PayableBillInfo;
import com.kingdee.eas.fm.sl.LoanFetchFactory;
import com.kingdee.eas.fm.sl.LoanFetchInfo;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Set;

public class RptAssureBillUseAnalyseHandler
implements IFMDetailRptHandler {
    protected KDTable kdt;
    protected int queryType;
    private String amtUnit;
    private CompanyOrgUnitInfo currentCompany;
    private int precisionLocalCurrency = 2;
    protected RptAssureBillUseAnalyseFilterParam filterParam;
    String assureBillid = null;
    boolean flagEmptyUsed = false;
    BigDecimal loc = Constants.ZERO;
    BigDecimal returned = Constants.ZERO;
    BigDecimal balance = Constants.ZERO;
    BigDecimal allcontactLocAmt = Constants.ZERO;
    BigDecimal allloc = Constants.ZERO;
    BigDecimal allreturned = Constants.ZERO;
    BigDecimal allbalance = Constants.ZERO;
    IContextHelper iContextHelper = ContextHelperFactory.getRemoteInstance();
    CompanyOrgUnitInfo companyInfo = this.iContextHelper.getCurrentCompany();
    boolean canShow = this.iContextHelper.getBooleanParam("CTL001", (IObjectPK)new ObjectUuidPK(this.companyInfo.getId()));

    protected RptAssureBillUseAnalyseHandler(KDTable kdt, RptAssureBillUseAnalyseFilterParam filterParam) {
        this.kdt = kdt;
        this.queryType = filterParam.getQueryType();
        this.filterParam = filterParam;
    }

    public void filldata(IRowSet rs) throws SQLException, EASBizException, BOSException {
        this.kdt.setRefresh(false);
        while (rs.next()) {
            IRow row;
            String clUID = rs.getString("FID");
            if (!this.flagEmptyUsed && this.assureBillid != null && !this.assureBillid.equals(clUID)) {
                this.allcontactLocAmt = this.allcontactLocAmt.add(rs.getBigDecimal("FCONTACTLOCALAMT"));
                row = this.addSubTotalRow(this.loc, this.returned, this.balance);
                this.loc = Constants.ZERO;
                this.returned = Constants.ZERO;
                this.balance = Constants.ZERO;
            }
            this.assureBillid = clUID;
            row = this.kdt.addRow();
            this.beforeFillRow(rs, row);
            row.setUserObject((Object)rs.getString("FId"));
            row.getCell("companyName").setValue((Object)rs.getString("COMPANYNAME"));
            row.getCell("assureBillNumber").setValue((Object)rs.getString("ASSUREBILLNUMBER"));
            int relation = rs.getInt("FUnionType");
            String relationName = RelationWithAssuredUnitEnum.getEnum(relation).getAlias();
            row.getCell("relationWithAssured").setValue((Object)relationName);
            row.getCell("AssuredCompanyName").setValue((Object)rs.getString("COMPANYASSURED"));
            row.getCell("bankName").setValue((Object)rs.getString("BANKNAME"));
            row.getCell("assureType").setValue((Object)rs.getString("AssureTypeName"));
            row.getCell("contactAmount").setValue((Object)rs.getBigDecimal("CONTACTAMOUNT"));
            row.getCell("contactLocalAmount").setValue((Object)rs.getBigDecimal("FCONTACTLOCALAMT"));
            row.getCell("billType").setValue((Object)rs.getString("FBILLTYPE"));
            row.getCell("finbillid").setValue((Object)rs.getString("FFINBILLID"));
            row.getCell("finbillNumber").setValue((Object)rs.getString("FFINBILLNUMBER"));
            row.getCell("returnedAmount").setValue((Object)rs.getBigDecimal("FRETURNEDAMOUNT"));
            if (relation == 1) {
                row.getCell("assBalance").setValue((Object)rs.getBigDecimal("FASSBALANCE"));
                row.getCell("assureBeginDate").setValue((Object)rs.getDate("FASSUREBEGINDATE"));
                row.getCell("assureEndDate").setValue((Object)rs.getDate("FASSUREENDDATE"));
            } else {
                row.getCell("assBalance").setValue((Object)rs.getBigDecimal("FBizLocalBalance"));
                row.getCell("assureBeginDate").setValue((Object)rs.getDate("FAssureBDate"));
                row.getCell("assureEndDate").setValue((Object)rs.getDate("FAssureEDate"));
            }
            this.setBillValue(row, rs.getString("FBILLTYPE"), rs.getString("FFINBILLID"), rs.getString("FID"), rs.getBigDecimal("FRETURNEDAMOUNT"), rs.getBigDecimal("FASSBALANCE"), rs.getBigDecimal("FCONTACTLOCALAMT"), rs.getBigDecimal("FEXRATE"));
            this.afterFillRow(rs, row);
            if (!rs.isFirst()) continue;
            this.allcontactLocAmt = this.allcontactLocAmt.add(rs.getBigDecimal("FCONTACTLOCALAMT"));
        }
        if (!this.flagEmptyUsed && rs.size() > 0) {
            this.addSubTotalRow(this.loc, this.returned, this.balance);
        }
        this.AssStatTotalRow();
    }

    private void setBillValue(IRow row, String billType, String billid, String id, BigDecimal returnedAmount, BigDecimal assBalance, BigDecimal contactLocAmt, BigDecimal exRate) throws EASBizException, BOSException {
        if (EmptyUtil.isEmpty((String)billType)) {
            return;
        }
        LoanInfo loaninfo = null;
        BigDecimal assRate = Constants.ONE;
        SelectorItemCollection cel = new SelectorItemCollection();
        cel.add("*");
        cel.add("Currency.name");
        BigDecimal sUnit = BigDecimal.valueOf(this.filterParam.getSUnit().getValue());
        if (new LoanInfo().getBOSType().toString().equals(billType)) {
            loaninfo = LoanFactory.getRemoteInstance().getLoanInfo((IObjectPK)new ObjectUuidPK(billid), cel);
            row.getCell("bargain").setValue((Object)loaninfo.getContractNum());
            row.getCell("loanRate").setValue((Object)loaninfo.getYieldRate());
            if (IntRateTypeExpressionEnum.YEAR == loaninfo.getIntRateTypeExpression()) {
                row.getCell("loanRate").getStyleAttributes().setNumberFormat("###,##0.0000####\\%");
            } else {
                row.getCell("loanRate").getStyleAttributes().setNumberFormat("###,##0.0000####\\\u2030");
            }
            row.getCell("amount").setValue((Object)loaninfo.getAmount().divide(sUnit, 4));
            row.getCell("baseCurrency").setValue((Object)loaninfo.getAmountLocalCur().divide(sUnit, 4));
            row.getCell("currency").setValue((Object)loaninfo.getCurrency().getDisplayName());
            this.loc = this.loc.add(loaninfo.getAmountLocalCur());
            this.allloc = this.allloc.add(loaninfo.getAmountLocalCur());
        } else if (new LetterOfCreditInfo().getBOSType().toString().equals(billType)) {
            LetterOfCreditInfo info = LetterOfCreditFactory.getRemoteInstance().getLetterOfCreditInfo((IObjectPK)new ObjectUuidPK(billid), cel);
            row.getCell("amount").setValue((Object)info.getAmount().divide(sUnit, 4));
            row.getCell("baseCurrency").setValue((Object)info.getAmountLocalCur().divide(sUnit, 4));
            row.getCell("currency").setValue((Object)info.getCurrency().getDisplayName());
            this.loc = this.loc.add(info.getAmountLocalCur());
            this.allloc = this.allloc.add(info.getAmountLocalCur());
        } else if (new LetterOfGuaranteeInfo().getBOSType().toString().equals(billType)) {
            LetterOfGuaranteeInfo info = LetterOfGuaranteeFactory.getRemoteInstance().getLetterOfGuaranteeInfo((IObjectPK)new ObjectUuidPK(billid), cel);
            row.getCell("amount").setValue((Object)info.getAmount().divide(sUnit, 4));
            row.getCell("baseCurrency").setValue((Object)info.getAmountLocalCur().divide(sUnit, 4));
            row.getCell("currency").setValue((Object)info.getCurrency().getDisplayName());
            this.loc = this.loc.add(info.getAmountLocalCur());
            this.allloc = this.allloc.add(info.getAmountLocalCur());
        } else if (new InnerFinancingBorrowingInfo().getBOSType().toString().equals(billType)) {
            InnerFinancingBorrowingInfo info = InnerFinancingBorrowingInFactory.getRemoteInstance().getInnerFinancingBorrowingInfo((IObjectPK)new ObjectUuidPK(billid), cel);
            row.getCell("amount").setValue((Object)info.getAmount().divide(sUnit, 4));
            row.getCell("baseCurrency").setValue((Object)info.getAmountLocalCur().divide(sUnit, 4));
            row.getCell("currency").setValue((Object)info.getCurrency().getDisplayName());
            this.loc = this.loc.add(info.getAmountLocalCur());
            this.allloc = this.allloc.add(info.getAmountLocalCur());
        } else if (new BillRediscountOutInfo().getBOSType().toString().equals(billType)) {
            BillRediscountOutInfo info = BillRediscountOutFactory.getRemoteInstance().getBillRediscountOutInfo((IObjectPK)new ObjectUuidPK(billid), cel);
            row.getCell("amount").setValue((Object)info.getAmount().divide(sUnit, 4));
            row.getCell("baseCurrency").setValue((Object)info.getAmountLocalCur().divide(sUnit, 4));
            row.getCell("currency").setValue((Object)info.getCurrency().getDisplayName());
            this.loc = this.loc.add(info.getAmountLocalCur());
            this.allloc = this.allloc.add(info.getAmountLocalCur());
        } else if (new CreditAssetsTransferOutInfo().getBOSType().toString().equals(billType)) {
            CreditAssetsTransferOutInfo info = CreditAssetsTransferOutFactory.getRemoteInstance().getCreditAssetsTransferOutInfo((IObjectPK)new ObjectUuidPK(billid), cel);
            row.getCell("amount").setValue((Object)info.getAmount().divide(sUnit, 4));
            row.getCell("baseCurrency").setValue((Object)info.getAmountLocalCur().divide(sUnit, 4));
            row.getCell("currency").setValue((Object)info.getCurrency().getDisplayName());
            this.loc = this.loc.add(info.getAmountLocalCur());
            this.allloc = this.allloc.add(info.getAmountLocalCur());
        } else if (new PayableBillInfo().getBOSType().toString().equals(billType)) {
            PayableBillInfo info = PayableBillFactory.getRemoteInstance().getPayableBillInfo((IObjectPK)new ObjectUuidPK(billid), cel);
            row.getCell("amount").setValue((Object)info.getAmount().divide(sUnit, 4));
            row.getCell("baseCurrency").setValue((Object)info.getAmountLocalCur().divide(sUnit, 4));
            row.getCell("currency").setValue((Object)info.getCurrency().getDisplayName());
            this.loc = this.loc.add(info.getAmountLocalCur());
            this.allloc = this.allloc.add(info.getAmountLocalCur());
        } else if (new BondReleaseReportInfo().getBOSType().toString().equals(billType)) {
            BondReleaseReportInfo info = BondReleaseReportFactory.getRemoteInstance().getBondReleaseReportInfo((IObjectPK)new ObjectUuidPK(billid), cel);
            row.getCell("currency").setValue((Object)info.getCurrency().getDisplayName());
            BigDecimal amount = info.getAmount().divide(sUnit, 4);
            row.getCell("amount").setValue((Object)amount);
            BigDecimal amountLocalCur = info.getAmountLocalCur().divide(sUnit, 4);
            row.getCell("baseCurrency").setValue((Object)amountLocalCur);
            assBalance = info.getBalance().divide(sUnit, 4);
            returnedAmount = amountLocalCur.subtract(assBalance);
            row.getCell("loanRate").setValue((Object)info.getYieldRate());
            this.loc = this.loc.add(info.getAmountLocalCur());
            this.allloc = this.allloc.add(info.getAmountLocalCur());
        } else if (new LoanFetchInfo().getBOSType().toString().equals(billType)) {
            LoanFetchInfo info = LoanFetchFactory.getRemoteInstance().getLoanFetchInfo((IObjectPK)new ObjectUuidPK(billid), cel);
            row.getCell("bargain").setValue((Object)info.getLoanContractNo());
            row.getCell("currency").setValue((Object)info.getCurrency().getDisplayName());
            BigDecimal amount = info.getAmount().divide(sUnit, 4);
            row.getCell("amount").setValue((Object)amount);
            BigDecimal amountLocalCur = info.getAmountLocalCur().divide(sUnit, 4);
            row.getCell("baseCurrency").setValue((Object)amountLocalCur);
            assBalance = info.getBalance().divide(sUnit, 4);
            returnedAmount = amount.subtract(assBalance);
            row.getCell("loanRate").setValue((Object)info.getYieldRate());
            row.getCell("assureBeginDate").setValue((Object)info.getIssueDate());
            row.getCell("assureEndDate").setValue((Object)info.getExpiredDate());
            this.loc = this.loc.add(info.getAmountLocalCur());
            this.allloc = this.allloc.add(info.getAmountLocalCur());
        }
        assRate = exRate;
        if (EmptyUtil.isEmpty((Object)assRate) || assRate.compareTo(Constants.ZERO) == 0) {
            assRate = Constants.ONE;
        }
        row.getCell("returnedAmount").setValue((Object)returnedAmount.multiply(assRate));
        row.getCell("assBalance").setValue((Object)assBalance);
        if (id != null) {
            this.flagEmptyUsed = false;
            if (returnedAmount != null) {
                this.returned = this.returned.add(returnedAmount);
                this.allreturned = this.allreturned.add(returnedAmount);
            }
            if (assBalance != null) {
                this.balance = this.balance.add(assBalance);
                this.allbalance = this.allbalance.add(assBalance);
            }
        } else {
            this.flagEmptyUsed = true;
        }
    }

    protected void afterFillRow(IRowSet rs, IRow row) throws SQLException {
    }

    protected void beforeFillRow(IRowSet rs, IRow row) {
    }

    private String[] getMergeColumn() {
        return new String[]{"assureBillNumber", "companyName", "relationWithAssured", "AssuredCompanyName", "bankName", "assureType", "contactAmount", "contactLocalAmount"};
    }

    public void endDataFill() {
        String[] mergeCol = this.getMergeColumn();
        for (int i = 0; i < mergeCol.length; ++i) {
            this.kdt.getColumn(mergeCol[i]).setMergeable(true);
            this.kdt.getColumn(mergeCol[i]).setGroup(true);
        }
        this.kdt.setRefresh(true);
        this.kdt.repaint();
        this.kdt.getGroupManager().group();
        this.kdt.getGroupManager().setGroup(false);
        ColumnUserCellDisplayParser displayParser = new ColumnUserCellDisplayParser(this.kdt);
        AliasTextValueProvider provider = new AliasTextValueProvider();
        provider.add((Object)new LoanInfo().getBOSType().toString(), this.getResString("Loan"));
        provider.add((Object)new PayableBillInfo().getBOSType().toString(), this.getResString("CommercialDraft"));
        provider.add((Object)new LetterOfCreditInfo().getBOSType().toString(), this.getResString("LetterOfCredit"));
        provider.add((Object)new LetterOfGuaranteeInfo().getBOSType().toString(), this.getResString("LetterOfGuarantee"));
        provider.add((Object)new InnerFinancingBorrowingInInfo().getBOSType().toString(), this.getResString("InnerFinancingBorrowingIn"));
        provider.add((Object)new BillRediscountOutInfo().getBOSType().toString(), this.getResString("BillRediscountOut"));
        provider.add((Object)new CreditAssetsTransferOutInfo().getBOSType().toString(), this.getResString("CreditAssetsTransferOut"));
        provider.add((Object)new BondReleaseReportInfo().getBOSType().toString(), this.getResString("bondReleaseReport"));
        provider.add((Object)new LoanFetchInfo().getBOSType().toString(), this.getResString("SLLoanFetch"));
        displayParser.addValueProvider("billType", (IValueProvider)provider);
    }

    private String getResString(String key) {
        return EASResource.getString((String)"com.kingdee.eas.fm.fin.client.FinClientResource", (String)key);
    }

    public IRowSet getRowSet() throws BOSException {
        ArrayList<Date> paramList = new ArrayList<Date>();
        String loc = LocaleUtils.getLocaleString((Locale)SysContext.getSysContext().getLocale());
        Set companyIdSet = this.filterParam.getCompanyIdSet();
        Date dateBegin = this.filterParam.getStartDate();
        Date endBegin = this.filterParam.getEndDate();
        Set assureTypeIdSet = this.filterParam.getAssureTypeIdSet();
        boolean cancelDisplay = this.filterParam.isCancel();
        StringBuffer sbWhere = new StringBuffer();
        sbWhere.append("where 1=1  ");
        if (dateBegin != null) {
            if (this.canShow) {
                sbWhere.append(" and ( assurebill.fbegindate>=? ");
                paramList.add(dateBegin);
                sbWhere.append(" or assurebill.fbegindate is null )");
            } else {
                sbWhere.append(" and assurebill.fbegindate>=? ");
                paramList.add(dateBegin);
            }
        }
        if (endBegin != null) {
            if (this.canShow) {
                sbWhere.append(" and ( assurebill.fbegindate<=?  ");
                paramList.add(endBegin);
                sbWhere.append(" or assurebill.fbegindate is null )");
            } else {
                sbWhere.append(" and assurebill.fbegindate<=?  ");
                paramList.add(endBegin);
            }
        }
        if (assureTypeIdSet != null && assureTypeIdSet.size() > 0) {
            sbWhere.append(" and ").append(FMHelper.buildIn((String)"assuretype.FId", (Object[])assureTypeIdSet.toArray()));
        }
        if (!cancelDisplay) {
            sbWhere.append(" and assurebill.FIsCanceled=0 ");
        }
        this.currentCompany = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        switch (this.queryType) {
            case 0: {
                sbWhere.append(" and ASSURECOMPANY.FID= '" + this.currentCompany.getId().toString() + "'");
                break;
            }
            case 1: {
                sbWhere.append(" and ASSUREBILL.FCompanyID= '" + this.currentCompany.getId().toString() + "'");
                break;
            }
            case 2: {
                sbWhere.append(" and FAssuredCompany= '" + this.currentCompany.getName() + "'");
                break;
            }
            default: {
                if (companyIdSet == null) break;
                sbWhere.append(" and  ").append(FMHelper.buildIn((String)"ASSURECOMPANY.FID", (Object[])companyIdSet.toArray()));
            }
        }
        this.amtUnit = new Integer(this.filterParam.getSUnit().getValue()).toString() + ".00";
        StringBuffer sb = new StringBuffer();
        sb.append("SELECT ASSUREBILL.FID, ");
        sb.append("ASSUREBILL.FNUMBER AS ASSUREBILLNUMBER, ");
        sb.append("ISNULL(ASSURECOMPANY.FName_").append(loc).append(" , ASSURECUSTOMER.FName_").append(loc).append(" ) AS COMPANYNAME, ");
        sb.append("ASSUREBILL.FUNIONTYPE, ");
        sb.append("ASSUREBILL.FexRate, ");
        sb.append("ASSUREBILL.FASSUREDCOMPANY COMPANYASSURED, ");
        sb.append("BANK.FNAME_").append(loc).append("  BANKNAME, ");
        sb.append("ASSURETYPE.FNAME_").append(loc).append("  AssureTypeName, ");
        sb.append("ASSUREBILL.FCONTACTAMOUNT/" + this.amtUnit + " AS CONTACTAMOUNT, ");
        sb.append("ASSUREBILL.FCONTACTLOCALAMT/" + this.amtUnit + " FCONTACTLOCALAMT, ");
        sb.append("ASSUREBILLUSED.FBILLTYPE, ");
        sb.append("ASSUREBILLUSED.FFINBILLID, ");
        sb.append("ASSUREBILLUSED.FFINBILLNUMBER, ");
        sb.append("CURRENCY.FNAME_").append(loc).append("  CURRENCYNAME, ");
        sb.append("ASSUREBILLUSED.FRETURNEDAMOUNT/" + this.amtUnit + " FRETURNEDAMOUNT, ");
        sb.append("ASSUREBILLUSED.FASSBALANCE/" + this.amtUnit + " FASSBALANCE,");
        sb.append("ASSUREBILLUSED.FASSUREBEGINDATE, ");
        sb.append("ASSUREBILLUSED.FASSUREENDDATE, ");
        sb.append("ASSUREBILL.FBizLocalBalance/" + this.amtUnit + " FBizLocalBalance, ");
        sb.append("ASSUREBILL.FAssureBeginDate FAssureBDate, ");
        sb.append("ASSUREBILL.FAssureEndDate  FAssureEDate ");
        sb.append("FROM T_CTL_AssureBill AS ASSUREBILL ");
        sb.append("LEFT OUTER JOIN T_CTL_AssureBillUsed AS ASSUREBILLUSED ");
        sb.append("ON ASSUREBILL.FID = ASSUREBILLUSED.FASSUREBILLID ");
        sb.append("LEFT OUTER JOIN T_ORG_Company AS ASSURECOMPANY ");
        sb.append("ON ASSUREBILL.FAssureCompanyID = ASSURECOMPANY.FID ");
        sb.append("LEFT OUTER JOIN T_BD_Customer AS ASSURECUSTOMER ");
        sb.append("ON ASSUREBILL.FAssureCustomerID = ASSURECUSTOMER.FID ");
        sb.append("LEFT OUTER JOIN T_BD_BANK BANK ");
        sb.append("ON ASSUREBILL.FBANKID =BANK.FID ");
        sb.append("LEFT OUTER JOIN T_CTL_ASSURETYPE ASSURETYPE ");
        sb.append("ON ASSUREBILL.FASSURETYPEID = ASSURETYPE.FID ");
        sb.append("LEFT OUTER JOIN T_BD_CURRENCY CURRENCY ");
        sb.append("ON ASSUREBILL.FCURRENCYID = CURRENCY.FID ");
        sb.append("\n").append(sbWhere);
        String orderBy = this.getOrderByClause();
        if (!StringUtils.isEmpty((String)orderBy)) {
            sb.append("\n").append(orderBy);
        }
        Logger.info((String)"=====================================");
        Logger.info((String)sb.toString());
        Logger.info((String)"=====================================");
        try {
            return FMIsqlFacadeFactory.getRemoteInstance().executeQuery(sb.toString(), paramList.toArray());
        }
        catch (EASBizException e) {
            ExceptionHandler.handle((Throwable)e);
            SysUtil.abort();
            return null;
        }
    }

    private void initDecimalCol(ICell cell, int precision) {
        cell.getStyleAttributes().setNumberFormat(FMClientHelper.getNumberFtm((int)precision));
    }

    protected static void initDecimalCell(ICell cell) {
        cell.getStyleAttributes().setNumberFormat("%r{#,##0.00}f");
    }

    public void initHeader() {
        this.kdt.removeRows();
        this.kdt.getGroupManager().removeGroup();
        this.kdt.getGroupManager().removeTreeColumn();
        this.kdt.getGroupManager().reInitialize();
        this.kdt.checkParsed(true);
        this.kdt.getSelectManager().setSelectMode(2);
        this.kdt.setEditable(false);
        this.kdt.getGroupManager().setGroup(true);
        this.kdt.getGroupManager().setOrientation(1);
        this.kdt.getColumn("baseCurrency").getStyleAttributes().setNumberFormat(FMClientHelper.getNumberFtm((int)this.precisionLocalCurrency));
        this.kdt.getColumn("baseCurrency").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.kdt.getColumn("returnedAmount").getStyleAttributes().setNumberFormat(FMClientHelper.getNumberFtm((int)this.precisionLocalCurrency));
        this.kdt.getColumn("returnedAmount").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.kdt.getColumn("assBalance").getStyleAttributes().setNumberFormat(FMClientHelper.getNumberFtm((int)this.precisionLocalCurrency));
        this.kdt.getColumn("assBalance").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.kdt.getColumn("contactLocalAmount").getStyleAttributes().setNumberFormat(FMClientHelper.getNumberFtm((int)this.precisionLocalCurrency));
        this.kdt.getColumn("contactLocalAmount").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.kdt.getColumn("contactAmount").getStyleAttributes().setNumberFormat(FMClientHelper.getNumberFtm((int)this.precisionLocalCurrency));
        this.kdt.getColumn("contactAmount").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.kdt.getColumn("loanRate").getStyleAttributes().setNumberFormat(FMClientHelper.getNumberFtm((int)this.precisionLocalCurrency));
        this.kdt.getColumn("loanRate").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.kdt.getColumn("amount").getStyleAttributes().setNumberFormat(FMClientHelper.getNumberFtm((int)this.precisionLocalCurrency));
        this.kdt.getColumn("amount").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.kdt.getColumn("billType").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.LEFT);
        this.kdt.getColumn("finbillNumber").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.LEFT);
        this.kdt.getColumn("currency").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.LEFT);
        this.kdt.getColumn("bargain").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.LEFT);
        IColumn col = this.kdt.addColumn();
        col.setKey("finbillid");
        col.setExpressions("id");
        col.getStyleAttributes().setHided(true);
    }

    private IRow addSubTotalRow(BigDecimal used, BigDecimal returned, BigDecimal usedFact) throws EASBizException, BOSException {
        IRow rowSubT = this.kdt.addRow();
        IRow rowUp = this.kdt.getRow(rowSubT.getRowIndex() - 1);
        for (int i = 0; i < this.kdt.getColumnIndex("billType"); ++i) {
            rowSubT.getCell(i).setValue(rowUp.getCell(i).getValue());
        }
        rowSubT.getCell("baseCurrency").setValue((Object)used.divide(BigDecimal.valueOf(this.filterParam.getSUnit().getValue()), 4));
        rowSubT.getCell("returnedAmount").setValue((Object)returned);
        rowSubT.getCell("assBalance").setValue((Object)usedFact);
        rowSubT.getCell("billType").setValue((Object)EASResource.getString((String)"com.kingdee.eas.fm.ctl.CTLAutoGenerateResource", (String)"129_RptAssureBillUseAnalyseHandler"));
        rowSubT.getStyleAttributes().setBackground(FMClientHelper.KDTABLE_SUBTOTAL_BG_COLOR);
        return rowSubT;
    }

    private void AssStatTotalRow() {
        IRow rowStat = this.kdt.addRow();
        rowStat.getCell("contactLocalAmount").setValue((Object)this.allcontactLocAmt);
        rowStat.getCell("baseCurrency").setValue((Object)this.allloc.divide(BigDecimal.valueOf(this.filterParam.getSUnit().getValue()), 4));
        rowStat.getCell("returnedAmount").setValue((Object)this.allreturned);
        rowStat.getCell("assBalance").setValue((Object)this.allbalance);
        rowStat.getCell(0).setValue((Object)EASResource.getString((String)"com.kingdee.eas.fm.ctl.CTLAutoGenerateResource", (String)"130_RptAssureBillUseAnalyseHandler"));
        rowStat.getCell(0).getStyleAttributes().setBackground(FMClientHelper.KDTABLE_SUBTOTAL_BG_COLOR);
        rowStat.getStyleAttributes().setBackground(FMClientHelper.KDTABLE_SUBTOTAL_BG_COLOR);
    }

    public void setTableStateRow() {
    }

    protected String getOrderByClause() {
        return "order by companyname desc, assurebill.funiontype , ASSUREBILL.FNUMBER ";
    }
}

