/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.ctl.client;

import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fm.common.AmountUnitEnum;
import com.kingdee.eas.fm.common.FilterParam;
import java.math.BigDecimal;
import java.util.Date;
import java.util.Set;

public class RptLetterOfGuaranteeDetailFilterParam
implements FilterParam {
    private static final long serialVersionUID = -8461065156304707615L;
    Set companyIdSet;
    Set bankIdSet;
    Date dateFrom;
    Date dateTo;
    int unitValue;
    BigDecimal amount;
    int dimType;
    boolean isShowCancel;
    private CompanyOrgUnitInfo companyif = ContextHelperFactory.getRemoteInstance().getCurrentCompany();

    public FilterInfo getFilter() {
        FilterInfo filter = new FilterInfo();
        FilterItemCollection filterCollection = filter.getFilterItems();
        if (this.getBankIdSet() != null && this.getBankIdSet().size() > 0) {
            filterCollection.add(new FilterItemInfo("Institution.id", (Object)this.getBankIdSet(), CompareType.INCLUDE));
        }
        if (this.companyif != null && GlUtils.isCompanyUnion((CompanyOrgUnitInfo)this.companyif)) {
            filterCollection.add(new FilterItemInfo("company.id", (Object)this.getCompanyIdSet(), CompareType.INCLUDE));
        } else if (this.getCompanyIdSet() != null && this.getCompanyIdSet().size() > 0) {
            filterCollection.add(new FilterItemInfo("company.id", (Object)this.companyif.getId().toString(), CompareType.EQUALS));
        }
        if (this.getDateFrom() == null) {
            filterCollection.add(new FilterItemInfo("IssueDate", (Object)this.getDateTo(), CompareType.LESS_EQUALS));
        } else {
            filterCollection.add(new FilterItemInfo("IssueDate", (Object)this.getDateFrom(), CompareType.GREATER_EQUALS));
            filterCollection.add(new FilterItemInfo("IssueDate", (Object)this.getDateTo(), CompareType.LESS_EQUALS));
        }
        if (this.getAmount() != null && this.getUnit() != null) {
            int intUnit = this.getUnit().getValue();
            BigDecimal bdUnit = new BigDecimal(String.valueOf(intUnit));
            filterCollection.add(new FilterItemInfo("Amount", (Object)this.getAmount().multiply(bdUnit), CompareType.GREATER_EQUALS));
        }
        if (!this.isShowCancel) {
            filterCollection.add(new FilterItemInfo("isDis", (Object)new Boolean(false)));
        }
        return filter;
    }

    public SorterItemCollection getSorterItems() {
        SorterItemCollection sorter = new SorterItemCollection();
        switch (this.getDimType()) {
            case 1: {
                sorter.add(new SorterItemInfo("company.name"));
                break;
            }
            case 2: {
                sorter.add(new SorterItemInfo("Institution.name"));
                break;
            }
            case 3: {
                sorter.add(new SorterItemInfo("Currency.name"));
                break;
            }
            case 4: {
                sorter.add(new SorterItemInfo("GaranteeType.name"));
                break;
            }
            case 5: {
                sorter.add(new SorterItemInfo("LGType.name"));
                break;
            }
            default: {
                throw new IllegalArgumentException("invalidate getOrderType");
            }
        }
        return sorter;
    }

    public BigDecimal getAmount() {
        return this.amount;
    }

    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }

    public Set getBankIdSet() {
        return this.bankIdSet;
    }

    public void setBankIdSet(Set bankIdSet) {
        this.bankIdSet = bankIdSet;
    }

    public Set getCompanyIdSet() {
        return this.companyIdSet;
    }

    public void setCompanyIdSet(Set companyIdSet) {
        this.companyIdSet = companyIdSet;
    }

    public Date getDateFrom() {
        return this.dateFrom;
    }

    public void setDateFrom(Date dateFrom) {
        this.dateFrom = dateFrom;
    }

    public Date getDateTo() {
        return this.dateTo;
    }

    public void setDateTo(Date dateTo) {
        this.dateTo = dateTo;
    }

    public int getDimType() {
        return this.dimType;
    }

    public void setDimType(int dimType) {
        this.dimType = dimType;
    }

    public AmountUnitEnum getUnit() {
        return AmountUnitEnum.getEnum((int)this.unitValue);
    }

    public void setUnit(AmountUnitEnum unit) {
        this.unitValue = unit == null ? -1 : unit.getValue();
    }

    public boolean isShowCancel() {
        return this.isShowCancel;
    }

    public void setShowCancel(boolean isShowCancel) {
        this.isShowCancel = isShowCancel;
    }
}

