/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.ctl.client.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.BasicFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.basedata.assistant.BankInfo;
import com.kingdee.eas.basedata.assistant.ConvertModeEnum;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ExchangeRateInfo;
import com.kingdee.eas.basedata.master.account.client.AccountPromptBox;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.client.CasRecPayHandler;
import com.kingdee.eas.fm.fin.FinUtils;
import java.math.BigDecimal;
import java.util.Date;

public class CtlClientHelper {
    public static void initPrmtBankAcct(IUIObject ui, KDBizPromptBox box, CompanyOrgUnitInfo com, BankInfo bank, CurrencyInfo currency) throws BOSException {
        EntityViewInfo entryViewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("isClosed", (Object)Constants.FALSE));
        if (com != null) {
            filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)com.getId()));
        }
        if (bank != null) {
            filter.getFilterItems().add(new FilterItemInfo("bank.id", (Object)bank.getId()));
        }
        if (currency != null) {
            FilterInfo filter2 = new FilterInfo();
            filter2.getFilterItems().add(new FilterItemInfo("currency.id", null, CompareType.EQUALS));
            filter2.getFilterItems().add(new FilterItemInfo("currency.id", (Object)currency.getId()));
            filter2.setMaskString("#0 or #1");
            filter.mergeFilter(filter2, "AND");
        }
        entryViewInfo.setFilter(filter);
        box.getQueryAgent().resetRuntimeEntityView();
        box.setEntityViewInfo(entryViewInfo);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("*");
        sic.add("bank.*");
        sic.add("currency.*");
        sic.add("account.*");
        box.setSelectorCollection(sic);
        box.setQueryInfo("com.kingdee.eas.basedata.assistant.app.F7AccountBankQuery");
        box.setDisplayFormat("$number$ $name$");
        box.setEditFormat("$number$");
        box.setCommitFormat("$number$;$name$");
    }

    public static void initPrmtAcctView(IUIObject ui, KDBizPromptBox box, CompanyOrgUnitInfo companyInfo, String currencyId) throws EASBizException, BOSException {
        String companyId = companyInfo.getId().toString();
        String cuId = companyInfo.getCU().getId().toString();
        EntityViewInfo treeevi = CasRecPayHandler.getAccountViewEvi((String)cuId, (String)companyId, (String)currencyId, (boolean)false);
        EntityViewInfo evi = CasRecPayHandler.getAccountViewEvi((String)cuId, (String)companyId, (String)currencyId, (boolean)true);
        AccountPromptBox opseelect = new AccountPromptBox(ui, companyInfo, treeevi.getFilter(), false, true);
        box.setDisplayFormat("$number$ $name$");
        box.setEditFormat("$number$");
        box.setCommitFormat("$number$");
        box.setQueryInfo("com.kingdee.eas.basedata.master.account.app.F7AccountViewQuery");
        box.setSelector((KDPromptSelector)opseelect);
        box.setEntityViewInfo(evi);
        box.getQueryAgent().resetRuntimeEntityView();
    }

    public static void initExchangeRateField(BasicFormattedTextField txtExchangeRate, CompanyOrgUnitInfo companyOrgUnitInfo, CurrencyInfo sourceCurr, CurrencyInfo destCurr, Date date) throws EASBizException, BOSException {
        if (sourceCurr == null || destCurr == null) {
            return;
        }
        BigDecimal rate = null;
        if (sourceCurr.getId().equals((Object)destCurr.getId())) {
            rate = Constants.ONE;
            txtExchangeRate.setValue((Object)rate);
            txtExchangeRate.setEditable(false);
            return;
        }
        ExchangeRateInfo exchangeRateInfo = FinUtils.getCurrencyExRateInfo(null, (CompanyOrgUnitInfo)companyOrgUnitInfo, (CurrencyInfo)sourceCurr, (CurrencyInfo)destCurr, (Date)date);
        if (exchangeRateInfo != null) {
            rate = exchangeRateInfo.getConvertRate();
            if (exchangeRateInfo.getConvertMode().equals((Object)ConvertModeEnum.INDIRECTEXCHANGERATE)) {
                rate = new BigDecimal(String.valueOf(1)).divide(rate, 4);
            }
            txtExchangeRate.setValue((Object)rate);
            txtExchangeRate.setEditable(true);
        }
    }
}

