/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.ecore.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.KDLabelContainer;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.common.FMException;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.ecore.ElecDraftBillAccptEntryCollection;
import com.kingdee.eas.fm.ecore.ElecDraftBillAccptEntryFactory;
import com.kingdee.eas.fm.ecore.ElecDraftBillAccptEntryInfo;
import com.kingdee.eas.fm.ecore.ElecDraftBillDisctEntryCollection;
import com.kingdee.eas.fm.ecore.ElecDraftBillDisctEntryFactory;
import com.kingdee.eas.fm.ecore.ElecDraftBillDisctEntryInfo;
import com.kingdee.eas.fm.ecore.ElecDraftBillEntryFactory;
import com.kingdee.eas.fm.ecore.ElecDraftBillEntryInfo;
import com.kingdee.eas.fm.ecore.ElecDraftBillPayReqEntryCollection;
import com.kingdee.eas.fm.ecore.ElecDraftBillPayReqEntryFactory;
import com.kingdee.eas.fm.ecore.ElecDraftBillPayReqEntryInfo;
import com.kingdee.eas.fm.ecore.ElecDraftBillRecrsEntryCollection;
import com.kingdee.eas.fm.ecore.ElecDraftBillRecrsEntryFactory;
import com.kingdee.eas.fm.ecore.ElecDraftBillRecrsEntryInfo;
import com.kingdee.eas.fm.ecore.SignUpEnum;
import com.kingdee.eas.fm.ecore.client.AbstractElecDraftBillEntryViewUI;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.enums.StringEnum;
import java.awt.Component;
import java.awt.Rectangle;
import java.math.BigDecimal;
import java.util.Date;
import javax.swing.JComponent;
import org.apache.log4j.Logger;

public class ElecDraftBillEntryViewUI
extends AbstractElecDraftBillEntryViewUI {
    private static final Logger logger = CoreUIObject.getLogger(ElecDraftBillEntryViewUI.class);
    private final int dymLeftComponentXvalue = 20;
    private final int dymRightComponentXvalue = 527;
    private final int dymComponentTopInitYValue = 340;
    private final int dymComponentGap = 30;

    public void onLoad() throws Exception {
        super.onLoad();
        String entryID = (String)this.getUIContext().get("entryID");
        if (entryID == null) {
            return;
        }
        ElecDraftBillEntryInfo entryInfo = ElecDraftBillEntryFactory.getRemoteInstance().getElecDraftBillEntryInfo((IObjectPK)new ObjectStringPK(entryID));
        if (entryInfo == null) {
            return;
        }
        this.draftNumber.setText(entryInfo.getDraftNumber());
        FMClientHelper.setSelectObject((KDComboBox)this.bizType, (Object)((Object)entryInfo.getDraftBizType()));
        this.signUpDate.setValue((Object)entryInfo.getDraftSignInDate());
        FMClientHelper.setSelectObject((KDComboBox)this.proxySignature, (Object)((Object)entryInfo.getProxySignature()));
        FMClientHelper.setSelectObject((KDComboBox)this.formerRole, (Object)((Object)entryInfo.getFormerRole()));
        this.formerName.setText(entryInfo.getFormerName());
        this.formerOrgCode.setText(entryInfo.getFormerOrgCode());
        this.formerAccount.setText(entryInfo.getFormerAccount());
        this.formerBank.setText(entryInfo.getFormerBank());
        this.formerAgcyBank.setText(entryInfo.getFormerAgcyBank());
        this.formerRemark.setText(entryInfo.getFormerRemark());
        FMClientHelper.setSelectObject((KDComboBox)this.laterRole, (Object)((Object)entryInfo.getLaterRole()));
        this.laterName.setText(entryInfo.getLaterName());
        this.laterOrgCode.setText(entryInfo.getLaterOrgCode());
        this.laterAccount.setText(entryInfo.getLaterAccount());
        this.laterBank.setText(entryInfo.getLaterBank());
        this.laterAgcyBank.setText(entryInfo.getLaterAgcyBank());
        this.laterRemark.setText(entryInfo.getLaterRemark());
        switch (entryInfo.getDraftBizType().getValue()) {
            case 0: {
                this.initChengDuiInfo(entryInfo);
                break;
            }
            case 2: {
                this.initBeiShuInfo(entryInfo);
                break;
            }
            case 3: {
                this.initTiexianInfo(entryInfo, true);
                break;
            }
            case 5: 
            case 7: {
                this.initTiexianInfo(entryInfo, false);
                break;
            }
            case 4: 
            case 6: 
            case 8: {
                this.initTieXianShuHuiInfo(entryInfo);
                break;
            }
            case 9: {
                this.initMaiPiaoInfo(entryInfo);
                break;
            }
            case 13: {
                this.initFuKuanInfo(entryInfo, false);
                break;
            }
            case 14: {
                this.initFuKuanInfo(entryInfo, true);
                break;
            }
            case 15: {
                this.iniZhuiSuoInfo(entryInfo);
                break;
            }
            default: {
                this.kDSeparator6.setVisible(false);
            }
        }
        this.toolBar.removeAll();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected IObjectValue createNewData() {
        return null;
    }

    private void setLabelTextComponent(String labelName, Object labelValue, int top, int left) throws FMException {
        KDTextField textField;
        KDLabelContainer label = new KDLabelContainer();
        label.setBoundLabelLength(100);
        label.setBoundLabelUnderline(true);
        label.setBoundLabelAlignment(7);
        label.setName("label" + top + "_" + left);
        label.setBounds(new Rectangle(left, top, 400, 19));
        label.setBoundLabelText(labelName);
        if (labelValue instanceof String) {
            textField = new KDTextField();
            textField.setText(labelValue.toString());
            label.setBoundEditor((JComponent)textField);
        }
        if (labelValue instanceof BigDecimal) {
            textField = new KDTextField();
            textField.setText(labelValue.toString());
            label.setBoundEditor((JComponent)textField);
        } else if (labelValue instanceof Date) {
            KDDatePicker datePicker = new KDDatePicker();
            datePicker.setValue(labelValue);
            label.setBoundEditor((JComponent)datePicker);
        } else if (labelValue instanceof StringEnum) {
            textField = new KDTextField();
            textField.setText(((StringEnum)labelValue).getValue() + ((StringEnum)labelValue).getAlias());
            label.setBoundEditor((JComponent)textField);
        } else if (labelValue == null) {
            textField = new KDTextField();
            label.setBoundEditor((JComponent)textField);
        }
        this.add((Component)label);
    }

    protected ICoreBase getBizInterface() throws Exception {
        return ElecDraftBillEntryFactory.getRemoteInstance();
    }

    private void initChengDuiInfo(ElecDraftBillEntryInfo info) throws BOSException, EASBizException {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.appendFilterItem("parent", (Object)info.getId().toString());
        evi.setFilter(filter);
        ElecDraftBillAccptEntryCollection col = ElecDraftBillAccptEntryFactory.getRemoteInstance().getElecDraftBillAccptEntryCollection(evi);
        if (col.size() > 0) {
            ElecDraftBillAccptEntryInfo accptInfo = col.get(0);
            this.setLabelTextComponent(EASResource.getString((String)"com.kingdee.eas.fm.ecore.ECOREAutoGenerateResource", (String)"364_ElecDraftBillEntryViewUI"), (Object)accptInfo.getUncondlConsignment(), 340, 20);
            this.setLabelTextComponent(EASResource.getString((String)"com.kingdee.eas.fm.ecore.ECOREAutoGenerateResource", (String)"365_ElecDraftBillEntryViewUI"), (Object)accptInfo.getUncondlPromise(), 340, 527);
            this.setLabelTextComponent(EASResource.getString((String)"com.kingdee.eas.fm.ecore.ECOREAutoGenerateResource", (String)"366_ElecDraftBillEntryViewUI"), accptInfo.getContractNumber(), 370, 20);
            this.setLabelTextComponent(EASResource.getString((String)"com.kingdee.eas.fm.ecore.ECOREAutoGenerateResource", (String)"367_ElecDraftBillEntryViewUI"), accptInfo.getInvoiceNumber(), 370, 527);
            this.setLabelTextComponent(EASResource.getString((String)"com.kingdee.eas.fm.ecore.ECOREAutoGenerateResource", (String)"368_ElecDraftBillEntryViewUI"), accptInfo.getAccptAgreementNumber(), 400, 20);
            this.setLabelTextComponent(EASResource.getString((String)"com.kingdee.eas.fm.ecore.ECOREAutoGenerateResource", (String)"369_ElecDraftBillEntryViewUI"), accptInfo.getAccptCredieRate(), 400, 527);
            this.setLabelTextComponent(EASResource.getString((String)"com.kingdee.eas.fm.ecore.ECOREAutoGenerateResource", (String)"370_ElecDraftBillEntryViewUI"), accptInfo.getAccptCdtRater(), 430, 20);
            this.setLabelTextComponent(EASResource.getString((String)"com.kingdee.eas.fm.ecore.ECOREAutoGenerateResource", (String)"371_ElecDraftBillEntryViewUI"), accptInfo.getAccptRtDueDate(), 430, 527);
        }
    }

    private void initBeiShuInfo(ElecDraftBillEntryInfo info) throws EASBizException {
        this.setLabelTextComponent(EASResource.getString((String)"com.kingdee.eas.fm.ecore.ECOREAutoGenerateResource", (String)"332_ElecDraftBillBackSideUI"), (Object)info.getBanEndorsement(), 340, 20);
    }

    private void initTieXianShuHuiInfo(ElecDraftBillEntryInfo info) throws EASBizException {
        this.setLabelTextComponent(EASResource.getString((String)"com.kingdee.eas.fm.ecore.ECOREAutoGenerateResource", (String)"372_ElecDraftBillEntryViewUI"), info.getInterestRate(), 340, 20);
        this.setLabelTextComponent(EASResource.getString((String)"com.kingdee.eas.fm.ecore.ECOREAutoGenerateResource", (String)"373_ElecDraftBillEntryViewUI"), info.getActualAmount(), 340, 527);
        this.setLabelTextComponent(EASResource.getString((String)"com.kingdee.eas.fm.ecore.ECOREAutoGenerateResource", (String)"332_ElecDraftBillBackSideUI"), (Object)info.getBanEndorsement(), 370, 20);
        this.setLabelTextComponent(EASResource.getString((String)"com.kingdee.eas.fm.ecore.ECOREAutoGenerateResource", (String)"374_ElecDraftBillEntryViewUI"), (Object)info.getSettlementMode(), 370, 527);
    }

    private void initMaiPiaoInfo(ElecDraftBillEntryInfo info) throws EASBizException {
        this.setLabelTextComponent(EASResource.getString((String)"com.kingdee.eas.fm.ecore.ECOREAutoGenerateResource", (String)"375_ElecDraftBillEntryViewUI"), info.getInterestRate(), 340, 20);
        this.setLabelTextComponent(EASResource.getString((String)"com.kingdee.eas.fm.ecore.ECOREAutoGenerateResource", (String)"376_ElecDraftBillEntryViewUI"), info.getActualAmount(), 340, 527);
        this.setLabelTextComponent(EASResource.getString((String)"com.kingdee.eas.fm.ecore.ECOREAutoGenerateResource", (String)"332_ElecDraftBillBackSideUI"), (Object)info.getBanEndorsement(), 370, 20);
        this.setLabelTextComponent(EASResource.getString((String)"com.kingdee.eas.fm.ecore.ECOREAutoGenerateResource", (String)"374_ElecDraftBillEntryViewUI"), (Object)info.getSettlementMode(), 400, 527);
    }

    private void initTiexianInfo(ElecDraftBillEntryInfo info, boolean isShowInAccountInfo) throws BOSException, EASBizException {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.appendFilterItem("parent", (Object)info.getId().toString());
        evi.setFilter(filter);
        ElecDraftBillDisctEntryCollection col = ElecDraftBillDisctEntryFactory.getRemoteInstance().getElecDraftBillDisctEntryCollection(evi);
        if (col.size() > 0) {
            ElecDraftBillDisctEntryInfo disctInfo = col.get(0);
            this.setLabelTextComponent(EASResource.getString((String)"com.kingdee.eas.fm.ecore.ECOREAutoGenerateResource", (String)"377_ElecDraftBillEntryViewUI"), (Object)disctInfo.getDiscountType(), 340, 20);
            this.setLabelTextComponent(EASResource.getString((String)"com.kingdee.eas.fm.ecore.ECOREAutoGenerateResource", (String)"378_ElecDraftBillEntryViewUI"), info.getInterestRate(), 340, 527);
            this.setLabelTextComponent(EASResource.getString((String)"com.kingdee.eas.fm.ecore.ECOREAutoGenerateResource", (String)"379_ElecDraftBillEntryViewUI"), info.getActualAmount(), 370, 20);
            this.setLabelTextComponent(EASResource.getString((String)"com.kingdee.eas.fm.ecore.ECOREAutoGenerateResource", (String)"332_ElecDraftBillBackSideUI"), (Object)info.getBanEndorsement(), 370, 527);
            this.setLabelTextComponent(EASResource.getString((String)"com.kingdee.eas.fm.ecore.ECOREAutoGenerateResource", (String)"374_ElecDraftBillEntryViewUI"), (Object)info.getSettlementMode(), 400, 20);
            this.setLabelTextComponent(EASResource.getString((String)"com.kingdee.eas.fm.ecore.ECOREAutoGenerateResource", (String)"380_ElecDraftBillEntryViewUI"), disctInfo.getRepurchasedOpenDate(), 400, 527);
            this.setLabelTextComponent(EASResource.getString((String)"com.kingdee.eas.fm.ecore.ECOREAutoGenerateResource", (String)"381_ElecDraftBillEntryViewUI"), disctInfo.getRepurchasedDueDate(), 430, 20);
            this.setLabelTextComponent(EASResource.getString((String)"com.kingdee.eas.fm.ecore.ECOREAutoGenerateResource", (String)"372_ElecDraftBillEntryViewUI"), disctInfo.getRepurchasedRate(), 430, 527);
            this.setLabelTextComponent(EASResource.getString((String)"com.kingdee.eas.fm.ecore.ECOREAutoGenerateResource", (String)"382_ElecDraftBillEntryViewUI"), disctInfo.getRepurchasedAmount(), 460, 20);
            if (isShowInAccountInfo) {
                this.setLabelTextComponent(EASResource.getString((String)"com.kingdee.eas.fm.ecore.ECOREAutoGenerateResource", (String)"366_ElecDraftBillEntryViewUI"), disctInfo.getContractNumber(), 460, 527);
                this.setLabelTextComponent(EASResource.getString((String)"com.kingdee.eas.fm.ecore.ECOREAutoGenerateResource", (String)"367_ElecDraftBillEntryViewUI"), disctInfo.getInvoiceNumber(), 490, 20);
                this.setLabelTextComponent(EASResource.getString((String)"com.kingdee.eas.fm.ecore.ECOREAutoGenerateResource", (String)"383_ElecDraftBillEntryViewUI"), disctInfo.getDisctAgreementNumber(), 490, 527);
                this.setLabelTextComponent(EASResource.getString((String)"com.kingdee.eas.fm.ecore.ECOREAutoGenerateResource", (String)"384_ElecDraftBillEntryViewUI"), disctInfo.getInAccountNumber(), 520, 20);
                this.setLabelTextComponent(EASResource.getString((String)"com.kingdee.eas.fm.ecore.ECOREAutoGenerateResource", (String)"385_ElecDraftBillEntryViewUI"), disctInfo.getInAccountBank(), 520, 527);
            }
        }
    }

    private void initFuKuanInfo(ElecDraftBillEntryInfo info, boolean isOverDue) throws BOSException, EASBizException {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.appendFilterItem("parent", (Object)info.getId().toString());
        evi.setFilter(filter);
        ElecDraftBillPayReqEntryCollection col = ElecDraftBillPayReqEntryFactory.getRemoteInstance().getElecDraftBillPayReqEntryCollection(evi);
        if (col.size() > 0) {
            ElecDraftBillPayReqEntryInfo payReqInfo = col.get(0);
            this.setLabelTextComponent(EASResource.getString((String)"com.kingdee.eas.fm.ecore.ECOREAutoGenerateResource", (String)"386_ElecDraftBillEntryViewUI"), payReqInfo.getApplyDate(), 340, 20);
            this.setLabelTextComponent(EASResource.getString((String)"com.kingdee.eas.fm.ecore.ECOREAutoGenerateResource", (String)"387_ElecDraftBillEntryViewUI"), payReqInfo.getReplyDate(), 340, 527);
            this.setLabelTextComponent(EASResource.getString((String)"com.kingdee.eas.fm.ecore.ECOREAutoGenerateResource", (String)"388_ElecDraftBillEntryViewUI"), (Object)payReqInfo.getSignUpMark(), 370, 20);
            this.setLabelTextComponent(EASResource.getString((String)"com.kingdee.eas.fm.ecore.ECOREAutoGenerateResource", (String)"389_ElecDraftBillEntryViewUI"), payReqInfo.getPayReqAmount(), 370, 527);
            this.setLabelTextComponent(EASResource.getString((String)"com.kingdee.eas.fm.ecore.ECOREAutoGenerateResource", (String)"374_ElecDraftBillEntryViewUI"), (Object)info.getSettlementMode(), 400, 20);
            this.setLabelTextComponent(EASResource.getString((String)"com.kingdee.eas.fm.ecore.ECOREAutoGenerateResource", (String)"390_ElecDraftBillEntryViewUI"), (Object)payReqInfo.getProxyProposition(), 400, 527);
            if (payReqInfo.getSignUpMark() == SignUpEnum.SU01) {
                this.setLabelTextComponent(EASResource.getString((String)"com.kingdee.eas.fm.ecore.ECOREAutoGenerateResource", (String)"391_ElecDraftBillEntryViewUI"), (Object)payReqInfo.getDishonorCode(), 430, 20);
                this.setLabelTextComponent(EASResource.getString((String)"com.kingdee.eas.fm.ecore.ECOREAutoGenerateResource", (String)"392_ElecDraftBillEntryViewUI"), payReqInfo.getDishonorRemark(), 430, 527);
            }
            if (isOverDue) {
                int gapCount = payReqInfo.getSignUpMark() == SignUpEnum.SU01 ? 4 : 3;
                this.setLabelTextComponent(EASResource.getString((String)"com.kingdee.eas.fm.ecore.ECOREAutoGenerateResource", (String)"393_ElecDraftBillEntryViewUI"), payReqInfo.getOverDueReason(), 340 + 30 * gapCount, 20);
            }
        }
    }

    private void iniZhuiSuoInfo(ElecDraftBillEntryInfo info) throws BOSException, EASBizException {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.appendFilterItem("parent", (Object)info.getId().toString());
        evi.setFilter(filter);
        ElecDraftBillRecrsEntryCollection col = ElecDraftBillRecrsEntryFactory.getRemoteInstance().getElecDraftBillRecrsEntryCollection(evi);
        if (col.size() > 0) {
            ElecDraftBillRecrsEntryInfo recrsInfo = col.get(0);
            this.setLabelTextComponent(EASResource.getString((String)"com.kingdee.eas.fm.ecore.ECOREAutoGenerateResource", (String)"362_ElecDraftBillBackSideUI"), (Object)recrsInfo.getRecourseType(), 340, 20);
            this.setLabelTextComponent(EASResource.getString((String)"com.kingdee.eas.fm.ecore.ECOREAutoGenerateResource", (String)"394_ElecDraftBillEntryViewUI"), recrsInfo.getApplyDate(), 340, 527);
            this.setLabelTextComponent(EASResource.getString((String)"com.kingdee.eas.fm.ecore.ECOREAutoGenerateResource", (String)"395_ElecDraftBillEntryViewUI"), recrsInfo.getDischargeSignUpDate(), 370, 20);
            this.setLabelTextComponent(EASResource.getString((String)"com.kingdee.eas.fm.ecore.ECOREAutoGenerateResource", (String)"396_ElecDraftBillEntryViewUI"), recrsInfo.getReqAmount(), 370, 527);
            this.setLabelTextComponent(EASResource.getString((String)"com.kingdee.eas.fm.ecore.ECOREAutoGenerateResource", (String)"397_ElecDraftBillEntryViewUI"), recrsInfo.getDischargeAmount(), 400, 20);
            this.setLabelTextComponent(EASResource.getString((String)"com.kingdee.eas.fm.ecore.ECOREAutoGenerateResource", (String)"398_ElecDraftBillEntryViewUI"), (Object)recrsInfo.getRecourseReason(), 400, 527);
            this.setLabelTextComponent(EASResource.getString((String)"com.kingdee.eas.fm.ecore.ECOREAutoGenerateResource", (String)"399_ElecDraftBillEntryViewUI"), recrsInfo.getRecourseRemark(), 430, 20);
            this.setLabelTextComponent(EASResource.getString((String)"com.kingdee.eas.fm.ecore.ECOREAutoGenerateResource", (String)"400_ElecDraftBillEntryViewUI"), recrsInfo.getRecourseAgreeRemark(), 430, 527);
            this.setLabelTextComponent(EASResource.getString((String)"com.kingdee.eas.fm.ecore.ECOREAutoGenerateResource", (String)"401_ElecDraftBillEntryViewUI"), recrsInfo.getSignatureRemark(), 460, 20);
        }
    }
}

