/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.edrafent.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTSortManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTPropertyChangeEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTPropertyChangeListener;
import com.kingdee.bos.ctrl.kdf.table.foot.KDTFootManager;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMFilterBaseUI;
import com.kingdee.eas.fm.ecore.DraftReplyTypeEnum;
import com.kingdee.eas.fm.ecore.ECDSBillStatusEnum;
import com.kingdee.eas.fm.edrafent.DrafTypeEnum;
import com.kingdee.eas.fm.edrafent.DraftKindEnum;
import com.kingdee.eas.fm.edrafent.DraftStockBillOperateEnum;
import com.kingdee.eas.fm.edrafent.client.AbstractDrafentStockRptUI;
import com.kingdee.eas.fm.edrafent.client.DrafentStockRptFilterParam;
import com.kingdee.eas.fm.edrafent.client.DrafentStockRptHandlerFactory;
import com.kingdee.eas.fm.edrafent.client.DraftStockRptFilterUI;
import com.kingdee.eas.fm.edrafent.client.IDrafentStockRptHandler;
import com.kingdee.eas.fm.nt.BillStateEnum;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.sql.SQLException;
import org.apache.log4j.Logger;

public class DrafentStockRptUI
extends AbstractDrafentStockRptUI {
    private static final Logger logger = CoreUIObject.getLogger(DrafentStockRptUI.class);
    DraftStockRptFilterUI filterUI = null;

    public DrafentStockRptUI() throws Exception {
        this.setUITitle("\u5e93\u5b58\u7968\u636e\u6c47\u603b\u8868");
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.menuItemExport.setText("\u5bfc\u51fa");
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    protected void execQuery() throws BOSException {
        DrafentStockRptFilterParam filterParam = (DrafentStockRptFilterParam)this.getFilterParam();
        if (filterParam == null) {
            return;
        }
        this.kDTable1.checkParsed();
        IDrafentStockRptHandler handler = null;
        handler = DrafentStockRptHandlerFactory.getBaseHandler(filterParam, this.kDTable1);
        handler.initHeader();
        String[] fields = new String[]{"company.name", "number", "commercialDraft.draftNumber", "commercialDraft.draftAmount", "amount", "commercialDraft.issueDate", "commercialDraft.dueDate", "draftTime", "assurDate", "drawerRateDueDate", "acceptorCdtDate", "createTime"};
        KDTSortManager sortManager = new KDTSortManager(this.kDTable1);
        sortManager.setSortAuto(true);
        sortManager.setClickCount(1);
        for (int i = 0; i < fields.length; ++i) {
            IColumn column = this.kDTable1.getColumn(fields[i]);
            if (column != null) {
                column.setSortable(true);
                continue;
            }
            logger.info((Object)("There's not exist column " + fields[i] + ". Please check the column name."));
        }
        this.kDTable1.getSelectManager().setSelectMode(10);
        IRowSet rs = handler.getRowSet();
        try {
            while (rs.next()) {
                IRow row = this.kDTable1.addRow();
                ObjectUuidPK pk = new ObjectUuidPK(rs.getString("id"));
                row.getCell("company.name").setValue((Object)rs.getString("company"));
                row.getCell("number").setValue((Object)rs.getString("number"));
                row.getCell("draftKind").setValue((Object)DraftKindEnum.getEnum(Integer.parseInt(rs.getString("draftKind"))));
                if (rs.getString("sourceSignType") == null) {
                    row.getCell("commercialDraft.draftType").setValue((Object)"");
                } else if (!rs.getString("draftType").equals("99")) {
                    row.getCell("commercialDraft.draftType").setValue((Object)DrafTypeEnum.getEnum(Integer.parseInt(rs.getString("draftType"))));
                } else {
                    row.getCell("commercialDraft.draftType").setValue((Object)rs.getString("ntType"));
                }
                if (rs.getString("sourceSignType") != null && !rs.getString("sourceSignType").equals("99")) {
                    row.getCell("sourceSignType").setValue((Object)DraftReplyTypeEnum.getEnum((int)Integer.parseInt(rs.getString("sourceSignType"))));
                } else {
                    row.getCell("sourceSignType").setValue((Object)"\u624b\u5de5");
                }
                row.getCell("commercialDraft.draftNumber").setValue((Object)rs.getString("draftNumber"));
                if (!rs.getString("draftType").equals("99")) {
                    row.getCell("draftStockOperate").setValue((Object)DraftStockBillOperateEnum.getEnum(Integer.parseInt(rs.getString("draftStockOperate"))));
                } else {
                    row.getCell("draftStockOperate").setValue((Object)BillStateEnum.getEnum((int)Integer.parseInt(rs.getString("draftStockOperate"))));
                }
                if (rs.getString("draftECDSStatus") != null) {
                    row.getCell("commercialDraft.draftECDSStatus").setValue((Object)ECDSBillStatusEnum.getEnum((String)rs.getString("draftECDSStatus")));
                }
                row.getCell("currency").setValue((Object)rs.getString("currency"));
                row.getCell("commercialDraft.draftAmount").setValue((Object)rs.getBigDecimal("draftAmount"));
                row.getCell("amount").setValue((Object)rs.getBigDecimal("amount"));
                row.getCell("commercialDraft.issueDate").setValue((Object)rs.getString("issueDate"));
                row.getCell("commercialDraft.dueDate").setValue((Object)rs.getString("dueDate"));
                row.getCell("draftTime").setValue((Object)rs.getBigDecimal("draftTime"));
                row.getCell("drawerName.displayName").setValue((Object)rs.getString("drawerName"));
                row.getCell("drawerAccount.bankAccountNumber").setValue((Object)rs.getString("drawerAccountNumber"));
                row.getCell("drawerBank.name").setValue((Object)rs.getString("drawerBank"));
                row.getCell("drawerBankNumber.name").setValue((Object)rs.getString("drawerBankNumber"));
                row.getCell("payeeName.name").setValue((Object)rs.getString("payeeName"));
                row.getCell("payAccount.bankAccountNumber").setValue((Object)rs.getString("payeeAccountNumber"));
                row.getCell("payeeBank.name").setValue((Object)rs.getString("payeeBank"));
                row.getCell("payeeBankNumber.number").setValue((Object)rs.getString("payeeBankNumber"));
                row.getCell("assurersName.name").setValue((Object)rs.getString("assurersName"));
                row.getCell("assurerAccount.bankAccountNumber").setValue((Object)rs.getString("assurerAccount"));
                row.getCell("assurerBankNumber.number").setValue((Object)rs.getString("assurerBankNumber"));
                row.getCell("assurerAddress").setValue((Object)rs.getString("assurerAddress"));
                row.getCell("assurDate").setValue((Object)rs.getString("assurDate"));
                row.getCell("accpetorBank.name").setValue((Object)rs.getString("accpetorBankName"));
                row.getCell("accpetorAccount.bankAccountNumber").setValue((Object)rs.getString("accpetorAccount"));
                row.getCell("accpetorBankName.name").setValue((Object)rs.getString("accpetorBankName"));
                row.getCell("accpetorBankNumber.number").setValue((Object)rs.getString("accpetorBankNumber"));
                row.getCell("batchNumber").setValue((Object)rs.getString("batchNumber"));
                row.getCell("drawerCdtBody").setValue((Object)rs.getString("drawerCdtBody"));
                row.getCell("drawerCreditRate").setValue((Object)rs.getString("drawerCreditRate"));
                row.getCell("drawerRateDueDate").setValue((Object)rs.getString("drawerRateDueDate"));
                row.getCell("acceptorCdtBody").setValue((Object)rs.getString("acceptorCdtBody"));
                row.getCell("acceptorCreditRat").setValue((Object)rs.getString("acceptorCreditRat"));
                row.getCell("acceptorCdtDate").setValue((Object)rs.getString("acceptorCdtDate"));
                row.getCell("isAttorn").setValue((Object)Boolean.valueOf(rs.getString("isAttorn")));
                row.getCell("isAcceptor").setValue((Object)Boolean.valueOf(rs.getString("isAcceptor")));
                row.getCell("remark").setValue((Object)rs.getString("remark"));
                row.getCell("collateral").setValue((Object)Boolean.valueOf(rs.getString("collateral")));
                row.getCell("present").setValue((Object)Boolean.valueOf(rs.getString("present")));
                row.getCell("recourse").setValue((Object)Boolean.valueOf(rs.getString("recourse")));
                row.getCell("buildVoucher").setValue((Object)Boolean.valueOf(rs.getString("fiVouchered")));
                row.getCell("voucherType.name").setValue((Object)rs.getString("voucherType.name"));
                row.getCell("voucherNumber").setValue((Object)rs.getString("voucherNumber"));
                row.getCell("creator.name").setValue((Object)rs.getString("creator.name"));
                row.getCell("createTime").setValue((Object)rs.getString("createTime"));
                row.setUserObject((Object)rs.getString("id"));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        this.addTablePropertyList(this.kDTable1);
        this.apendFootRow(this.kDTable1, new String[]{"commercialDraft.draftAmount", "amount"});
    }

    @Override
    public void actionJoinQueryBill_actionPerformed(ActionEvent e) throws Exception {
        super.actionJoinQueryBill_actionPerformed(e);
        KDTSelectBlock selectBlock = this.kDTable1.getSelectManager().get();
        if (selectBlock != null) {
            IRow row = this.kDTable1.getRow(selectBlock.getTop());
            Object id = row.getUserObject();
            String billId = null;
            if (id != null) {
                billId = id.toString();
            }
            if (id != null) {
                FMClientHelper.viewDetailBill((CoreUIObject)this, (String)billId, (CompanyOrgUnitInfo)SysContext.getSysContext().getCurrentFIUnit());
            }
        }
    }

    public FMFilterBaseUI getFilterUI() throws Exception {
        if (this.filterUI == null) {
            this.filterUI = new DraftStockRptFilterUI();
        }
        return this.filterUI;
    }

    protected KDTable getMainTable() {
        return this.kDTable1;
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnJoinQueryBill.setIcon(EASResource.getIcon((String)"imgTbtn_sequencecheck"));
    }

    private void apendFootRow(KDTable table, String[] field) {
        int size = field.length;
        int count = table.getRowCount();
        BigDecimal invoiceAmount = new BigDecimal("0.00");
        BigDecimal unverifyamount = new BigDecimal("0.00");
        IRow footRow = null;
        KDTFootManager footManager = table.getFootManager();
        if (footManager == null) {
            footManager = new KDTFootManager(table);
            footManager.addFootView();
            table.setFootManager(footManager);
        }
        footRow = footManager.getFootRow(0);
        for (int i = 0; i < count; ++i) {
            IRow row = table.getRow(i);
            ICell cell_invoiceAmount = row.getCell("commercialDraft.draftAmount");
            ICell cell_unverifyamount = row.getCell("amount");
            if (cell_invoiceAmount.getValue() != null) {
                invoiceAmount = invoiceAmount.add(new BigDecimal(cell_invoiceAmount.getValue().toString()));
            }
            if (cell_unverifyamount.getValue() == null) continue;
            unverifyamount = unverifyamount.add(new BigDecimal(cell_unverifyamount.getValue().toString()));
        }
        if (footRow == null) {
            String colFormat = "%{###,##0.00}f";
            footRow = footManager.addFootRow(0);
            String total = EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_Total");
            table.getIndexColumn().setWidthAdjustMode((short)1);
            table.getIndexColumn().setWidth(30);
            footManager.addIndexText(0, total);
            footRow.getStyleAttributes().setBackground(new Color(246, 246, 191));
            for (int i = 0; i < size; ++i) {
                String colName = field[i];
                footRow.getCell(colName).getStyleAttributes().setNumberFormat(colFormat);
                footRow.getCell(colName).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
                footRow.getCell(colName).getStyleAttributes().setFontColor(Color.black);
            }
        }
        footRow.getCell("commercialDraft.draftAmount").setValue((Object)invoiceAmount.toString());
        footRow.getCell("amount").setValue((Object)unverifyamount.toString());
    }

    private void addTablePropertyList(final KDTable table) {
        KDTPropertyChangeListener propertyChangeListener = new KDTPropertyChangeListener(){

            public void propertyChange(KDTPropertyChangeEvent evt) {
                int columnIndex;
                String colKey;
                if (evt.getType() == 1 && evt.getPropertyName().equals("cellValue") && (colKey = table.getColumn(columnIndex = evt.getColIndex()).getKey()) != null && evt.getOldValue() != null) {
                    BigDecimal oldValue = new BigDecimal(evt.getOldValue().toString());
                    BigDecimal newValue = new BigDecimal(evt.getNewValue().toString());
                    KDTFootManager footManager = table.getFootManager();
                    IRow footRow = footManager.getFootRow(0);
                    if (footRow != null) {
                        BigDecimal totalValue = new BigDecimal(footRow.getCell(colKey).getValue().toString());
                        totalValue = totalValue.add(newValue).subtract(oldValue);
                        footRow.getCell(colKey).setValue((Object)totalValue.toString());
                    }
                }
            }
        };
        table.addKDTPropertyChangeListener(propertyChangeListener);
    }
}

