/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.edrafent.client;

import com.kingdee.bos.ctrl.swing.BasicFormattedTextField;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fm.common.FMConstants;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.edrafent.CommercialDraftInfo;
import com.kingdee.eas.fm.edrafent.DraftCashInfoSelectBillFactory;
import com.kingdee.eas.fm.edrafent.DraftCashInfoSelectBillInfo;
import com.kingdee.eas.fm.edrafent.client.AbstractDraftCashInfoSelectBillEditUI;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.util.LocaleUtils;
import java.math.BigDecimal;
import java.util.Locale;
import org.apache.log4j.Logger;

public class DraftCashInfoSelectBillEditUI
extends AbstractDraftCashInfoSelectBillEditUI {
    private static final Logger logger = CoreUIObject.getLogger(DraftCashInfoSelectBillEditUI.class);

    @Override
    public void onLoad() throws Exception {
        super.onLoad();
        this.txtdraftAmount.setHorizontalAlignment(4);
        this.txtdraftTime.setHorizontalAlignment(4);
        this.prmtdrawerBank.setValue((Object)this.editData.getDrawerBank());
        this.prmtpayeeBank.setValue((Object)this.editData.getPayeeBank());
        this.editData.getDescription();
        this.txtdraftTime.setPrecision(1);
        if (GlUtils.isCompanyUnion((CompanyOrgUnitInfo)this.currentCompany)) {
            this.actionTraceDown.setVisible(false);
            this.actionTraceUp.setVisible(false);
            this.actionAuditResult.setVisible(false);
            this.menuSubmitOption.setVisible(false);
        }
        this.actionTraceDown.setVisible(false);
        this.actionTraceUp.setVisible(false);
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("PayeeBank"));
        sic.add(new SelectorItemInfo("DrawerBank"));
        return sic;
    }

    @Override
    public void loadFields() {
        super.loadFields();
        CommercialDraftInfo info = this.editData.getCommercialDraft();
        if (info.getDraftAmount() != null) {
            String txt = GlUtils.getChineseFormat((BigDecimal)info.getDraftAmount(), (boolean)true, (Locale)LocaleUtils.locale_L2);
            this.txtdraftAmountToUpper.setText(txt);
        }
    }

    protected void initUIProp() throws Exception {
        this.txtdraftAmount.setMaximumValue((Comparable)new BigDecimal("10000000000"));
        FMClientHelper.initCurrencyField((BasicFormattedTextField)this.txtdraftAmount);
        FMClientHelper.initCurrencyField((BasicFormattedTextField)this.txtdraftTime);
        this.txtdraftTime.setPrecision(1);
        this.txtdraftTime.setMinimumValue((Comparable)FMConstants.ZERO);
        this.txtdraftTime.setHorizontalAlignment(4);
        this.txtdraftAmount.setHorizontalAlignment(4);
        this.txtdraftAmount.setText("0.00");
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return DraftCashInfoSelectBillFactory.getRemoteInstance();
    }

    @Override
    protected IObjectValue createNewData() {
        DraftCashInfoSelectBillInfo objectValue = new DraftCashInfoSelectBillInfo();
        objectValue.setCompany(SysContext.getSysContext().getCurrentFIUnit());
        objectValue.setCreator((UserInfo)SysContext.getSysContext().getCurrentUser());
        return objectValue;
    }
}

