/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.edrafent.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.AbstractUIFactory;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.client.FMFilterBaseUI;
import com.kingdee.eas.fm.ecore.ECDSBillStatusEnum;
import com.kingdee.eas.fm.edraf.CollateralApplyBillInfo;
import com.kingdee.eas.fm.edraf.client.FCDraftCollateralizationRequestEditUI;
import com.kingdee.eas.fm.edraf.util.EdrafUtil;
import com.kingdee.eas.fm.edrafent.CommercialDraftInfo;
import com.kingdee.eas.fm.edrafent.DraftApplyTypeEnum;
import com.kingdee.eas.fm.edrafent.DraftCollateralizationRequestCollection;
import com.kingdee.eas.fm.edrafent.DraftCollateralizationRequestFactory;
import com.kingdee.eas.fm.edrafent.DraftCollateralizationRequestInfo;
import com.kingdee.eas.fm.edrafent.IDraftCollateralizationRequest;
import com.kingdee.eas.fm.edrafent.OperateStateEnum;
import com.kingdee.eas.fm.edrafent.client.AbstractDraftCollateralizationRequestListUI;
import com.kingdee.eas.fm.edrafent.client.DraftCollateralizationRequestEditUI;
import com.kingdee.eas.fm.edrafent.client.DraftCollateralizationRequestFilterUI;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseCollection;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class DraftCollateralizationRequestListUI
extends AbstractDraftCollateralizationRequestListUI {
    private static final Logger logger = CoreUIObject.getLogger(DraftCollateralizationRequestListUI.class);
    private DraftCollateralizationRequestFilterUI filterUI = null;
    private int rowIndex = -1;
    FillListener fillListener = new FillListener();

    public DraftCollateralizationRequestListUI() throws Exception {
        this.setUITitle("\u8d28\u62bc");
    }

    public IUIObject getInstance(Map uiContext) {
        DraftCollateralizationRequestInfo billInfo = null;
        if (uiContext.get("BOTPViewStatus") != null) {
            billInfo = (DraftCollateralizationRequestInfo)uiContext.get("InitDataObject");
        } else {
            if (uiContext.get("ID") == null) {
                return super.getInstance(uiContext);
            }
            String id = null;
            id = uiContext.get("ID") instanceof BOSUuid ? ((BOSUuid)uiContext.get("ID")).toString() : (uiContext.get("ID") instanceof String ? (String)uiContext.get("ID") : uiContext.get("ID").toString());
            ObjectUuidPK pk = new ObjectUuidPK(id);
            try {
                billInfo = ((IDraftCollateralizationRequest)this.getBizInterface()).getDraftCollateralizationRequestInfo((IObjectPK)pk);
            }
            catch (Exception e) {
                this.handleException(e);
            }
        }
        if (billInfo == null) {
            return super.getInstance(uiContext);
        }
        CompanyOrgUnitInfo orgUnitInfo = billInfo.getCompany();
        if (orgUnitInfo != null) {
            try {
                if (EdrafUtil.checkIsFinanceCompany(null, (String)orgUnitInfo.getId().toString())) {
                    return AbstractUIFactory.createUIObjectNoInit((String)FCDraftCollateralizationRequestEditUI.class.getName());
                }
                if (!EdrafUtil.checkIsFinanceCompany(null, (String)orgUnitInfo.getId().toString())) {
                    return AbstractUIFactory.createUIObjectNoInit((String)DraftCollateralizationRequestEditUI.class.getName());
                }
                return super.getInstance(uiContext);
            }
            catch (UIException e) {
                this.handleException((Exception)((Object)e));
            }
            catch (BOSException e) {
                this.handleException((Exception)((Object)e));
            }
        }
        return super.getInstance(uiContext);
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.actionAddNew.setVisible(false);
        this.ActionSubmit.setEnabled(true);
        this.actionFinanceCompany.setEnabled(true);
        this.actionBankCorporate.setEnabled(true);
        this.actionAudit.setEnabled(true);
        this.ActionUnAudit.setEnabled(true);
        this.btnAudit.setEnabled(true);
        this.actionBatchPrint.setVisible(true);
        this.actionBatchPrint.setEnabled(true);
        this.actionBatchPrintPreview.setVisible(true);
        this.actionBatchPrintPreview.setEnabled(true);
        this.actionBankCorporate.setEnabled(false);
        this.actionCopyTo.setVisible(false);
        this.actionCreateTo.setVisible(false);
    }

    @Override
    public void onLoad() throws Exception {
        super.onLoad();
        if (!this.validateCompany()) {
            this.tblMain.getColumn("company.name").getStyleAttributes().setHided(true);
        }
    }

    @Override
    protected void enableBaseActions() {
        super.enableBaseActions();
        if (!this.validateCompany()) {
            this.actionCreateTo.setVisible(false);
            this.btnAuditResult.setVisible(false);
            this.btnWorkFlowG.setVisible(false);
            this.actionDelVoucher.setVisible(true);
            this.actionVoucher.setVisible(true);
            this.actionDelVoucher.setVisible(true);
            this.actionDelVoucher.setEnabled(true);
            this.actionVoucher.setEnabled(true);
        } else {
            this.ActionRepealReq.setVisible(false);
            this.actionCollateralMark.setVisible(false);
        }
    }

    protected void initDapButtons() throws Exception {
        super.initDapButtons();
        if (this.validateCompany()) {
            this.actionVoucher.setVisible(false);
            this.actionDelVoucher.setVisible(false);
        } else {
            this.actionVoucher.setVisible(true);
            this.actionVoucher.setEnabled(true);
            this.actionDelVoucher.setVisible(true);
            this.actionDelVoucher.setEnabled(true);
        }
    }

    @Override
    public void actionFinanceCompany_actionPerformed(ActionEvent e) throws Exception {
        super.actionFinanceCompany_actionPerformed(e);
        this.checkSelected();
        ArrayList billID = this.getSelectedIdValues();
        if (billID == null) {
            return;
        }
        DraftCollateralizationRequestFactory.getRemoteInstance().batchSubmitFC(FMHelper.list2Set((List)billID), DraftApplyTypeEnum.ZHIYA);
        MsgBox.showInfo((String)"\u63d0\u4ea4\u8d22\u52a1\u516c\u53f8\u6210\u529f\uff01");
        this.refreshList();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    protected void initListener() {
        super.initListener();
        this.tblMain.getDataRequestManager().addDataFillListener((KDTDataFillListener)this.fillListener);
    }

    @Override
    public FMFilterBaseUI getFilterUI() throws Exception {
        if (this.tblMain.getColumn("company.name") != null) {
            if (this.validateCompany()) {
                this.tblMain.getColumn("company.name").getStyleAttributes().setHided(false);
            } else {
                this.tblMain.getColumn("company.name").getStyleAttributes().setHided(true);
            }
        }
        if (this.filterUI == null) {
            this.filterUI = new DraftCollateralizationRequestFilterUI();
        }
        return this.filterUI;
    }

    @Override
    public String[] getMergeColumnKeys() {
        return new String[]{"number", "commercialDraft.draftNumber", "commercialDraft.draftType", "operateState", "commercialDraft.draftECDSStatus", "pkIssueDate", "commercialDraft.dueDate", "commercialDraft.draftAmount", "financeOperateState", "PledgorName.name", "PledgorBank", "PledgorAcctSvcr", "pawneeName.name", "pawneeNumber", "pawneeAcctSvcr", "isAttorn", "remark", "batchNumber", "returnOpinion", "creator.name", "createTime", "auditDate", "submitter.name", "submitDate", "isCollaterals", "id", "Institution.name"};
    }

    protected void tblMain_tableSelectChanged(KDTSelectEvent e) throws Exception {
        super.tblMain_tableSelectChanged(e);
        this.checkSelected();
        ArrayList billID = this.getSelectedIdValues();
        if (billID == null) {
            return;
        }
        EntityViewInfo envi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)FMHelper.list2Set((List)billID), CompareType.INCLUDE));
        SelectorItemCollection selCol = super.getSelectors();
        envi.setSelector(selCol);
        envi.setFilter(filter);
        DraftCollateralizationRequestCollection col = DraftCollateralizationRequestFactory.getRemoteInstance().getDraftCollateralizationRequestCollection(envi);
        if (col.size() == 1) {
            DraftCollateralizationRequestInfo billInfo = col.get(0);
            if (billInfo.getOperateState().equals((Object)OperateStateEnum.SAVE) || billInfo.getOperateState().equals((Object)OperateStateEnum.SUBMIT)) {
                this.actionEdit.setEnabled(true);
                this.actionRemove.setEnabled(true);
            } else {
                this.actionEdit.setEnabled(false);
                this.actionRemove.setEnabled(false);
            }
            this.actionAudit.setEnabled(billInfo.getOperateState().equals((Object)OperateStateEnum.SUBMIT));
            this.ActionUnAudit.setEnabled(billInfo.getOperateState().equals((Object)OperateStateEnum.AUDIT));
            this.actionFinanceCompany.setEnabled(billInfo.getOperateState().equals((Object)OperateStateEnum.AUDIT));
            if (billInfo.getCommercialDraft() != null) {
                if (billInfo.getOperateState().equals((Object)OperateStateEnum.SUBMITGATEWAY) && billInfo.getCommercialDraft().getDraftECDSStatus().equals((Object)ECDSBillStatusEnum.ZYDQS)) {
                    this.ActionRepealReq.setEnabled(true);
                } else {
                    this.ActionRepealReq.setEnabled(false);
                }
                if (ECDSBillStatusEnum.ZYYQS.equals((Object)billInfo.getCommercialDraft().getDraftECDSStatus()) && !billInfo.isIsCollaterals()) {
                    this.actionCollateralMark.setEnabled(true);
                } else {
                    this.actionCollateralMark.setEnabled(false);
                }
                this.actionVoucher.setEnabled(!billInfo.isFiVouchered());
                this.actionDelVoucher.setEnabled(billInfo.isFiVouchered());
            }
        } else {
            this.actionEdit.setEnabled(false);
            this.actionRemove.setEnabled(true);
            this.ActionRepealReq.setEnabled(false);
            this.actionAudit.setEnabled(true);
            this.ActionUnAudit.setEnabled(true);
            this.actionFinanceCompany.setEnabled(true);
            this.actionCollateralMark.setEnabled(false);
        }
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return DraftCollateralizationRequestFactory.getRemoteInstance();
    }

    @Override
    protected boolean isFootVisible() {
        return true;
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String id = this.getSelectedKeyValue();
        DraftCollateralizationRequestInfo billInfo = (DraftCollateralizationRequestInfo)this.getBizInterface().getValue((IObjectPK)new ObjectUuidPK(id));
        if (billInfo.getOperateState().equals((Object)OperateStateEnum.SAVE) || billInfo.getOperateState().equals((Object)OperateStateEnum.SUBMIT)) {
            super.actionEdit_actionPerformed(e);
        } else {
            MsgBox.showInfo((String)"\u4ec5\u4fdd\u5b58\u6216\u63d0\u4ea4\u72b6\u6001\u7684\u8d28\u62bc\u5355\u53ef\u4fee\u6539\uff01");
            SysUtil.abort();
        }
    }

    @Override
    public void actionAudit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList billID = this.getSelectedIdValues();
        if (billID == null) {
            return;
        }
        this.checkBillsHasWF(billID);
        boolean hasWfInstance = FMHelper.hasWFInstance(null, (String)((String)billID.get(0)));
        if (hasWfInstance) {
            this.actionMultiapprove_actionPerformed(e);
        } else {
            DraftCollateralizationRequestFactory.getRemoteInstance().audit(FMHelper.list2Set((List)billID));
            MsgBox.showInfo((String)"\u64cd\u4f5c\u6210\u529f");
        }
        this.refreshList();
    }

    @Override
    public void actionUnAudit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList billID = this.getSelectedIdValues();
        if (billID == null) {
            return;
        }
        DraftCollateralizationRequestFactory.getRemoteInstance().unAudit(FMHelper.list2Set((List)billID));
        MsgBox.showInfo((String)"\u53cd\u5ba1\u6279\u6210\u529f");
        this.refreshList();
    }

    @Override
    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList billID = this.getSelectedIdValues();
        if (billID == null) {
            return;
        }
        DraftCollateralizationRequestFactory.getRemoteInstance().submit(FMHelper.list2Set((List)billID));
        MsgBox.showInfo((String)"\u63d0\u4ea4\u6210\u529f");
        this.refreshList();
    }

    @Override
    public void actionCollateralMark_actionPerformed(ActionEvent e) throws Exception {
        super.actionCreateTo_actionPerformed(e);
    }

    public List getDestBosTypeForBotp(CoreBillBaseCollection srcBillInfos, List srcBosTypeList) {
        BOSObjectType stObjType = new CollateralApplyBillInfo().getBOSType();
        for (int i = srcBosTypeList.size() - 1; i >= 0; --i) {
            if (!srcBosTypeList.get(i).equals(stObjType.toString())) continue;
            srcBosTypeList.remove(i);
        }
        return super.getDestBosTypeForBotp(srcBillInfos, srcBosTypeList);
    }

    @Override
    public void actionRepealReq_actionPerformed(ActionEvent e) throws Exception {
        super.actionRepealReq_actionPerformed(e);
        this.checkSelected();
        ArrayList billID = this.getSelectedIdValues();
        if (billID == null) {
            return;
        }
        if (billID.size() == 1) {
            ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)billID.get(0).toString()));
            SelectorItemCollection sc = new SelectorItemCollection();
            sc.add(new SelectorItemInfo("*"));
            sc.add(new SelectorItemInfo("commercialDraft.*"));
            CoreBaseInfo o = this.getBizInterface().getValue((IObjectPK)pk, sc);
            DraftCollateralizationRequestInfo billInfo = (DraftCollateralizationRequestInfo)o;
            CommercialDraftInfo commercialDraftInfo = billInfo.getCommercialDraft();
            if (commercialDraftInfo.getDraftECDSStatus() == ECDSBillStatusEnum.ZYDQS && billInfo.getOperateState() == OperateStateEnum.SUBMITGATEWAY) {
                DraftCollateralizationRequestFactory.getRemoteInstance().cancelApply(billID.get(0).toString(), DraftApplyTypeEnum.ZHIYA);
                MsgBox.showInfo((String)"\u64a4\u9500\u7533\u8bf7\u6210\u529f\uff01");
                this.refreshList();
            } else {
                MsgBox.showInfo((String)"\u8d28\u62bc\u5f85\u7b7e\u6536\u4e14\u672a\u64a4\u9500\u7684\u8d28\u62bc\u5355\u624d\u5141\u8bb8\u64a4\u9500\uff01");
                SysUtil.abort();
            }
        }
    }

    @Override
    protected IMetaDataPK getTDQueryPK() {
        return new MetaDataPK("com.kingdee.eas.fm.edrafent.app.DraftCollateralizationRequestTDQuery");
    }

    @Override
    protected String getTDFileName() {
        return "/FM/EDRAFENT/DraftCollatera";
    }

    public void actionVoucher_actionPerformed(ActionEvent e) throws Exception {
        super.actionVoucher_actionPerformed(e);
    }

    public void actionDelVoucher_actionPerformed(ActionEvent e) throws Exception {
        super.actionDelVoucher_actionPerformed(e);
    }

    protected String getKeyFieldName() {
        return "id";
    }

    @Override
    protected IObjectValue createNewData() {
        DraftCollateralizationRequestInfo objectValue = new DraftCollateralizationRequestInfo();
        return objectValue;
    }

    private final class FillListener
    implements KDTDataFillListener {
        private FillListener() {
        }

        public void afterDataFill(KDTDataRequestEvent e) {
            IRow row = null;
            Object currencyId = null;
            if (e == null) {
                return;
            }
            for (int i = e.getFirstRow(); i <= e.getLastRow(); ++i) {
                row = DraftCollateralizationRequestListUI.this.tblMain.getRow(i);
                Object obj = row.getCell("pawneeName.name").getValue();
                Object obj1 = row.getCell("Institution.name").getValue();
                if (obj != null) continue;
                row.getCell("pawneeName.name").setValue(obj1);
            }
            StyleAttributes styleAttributes = DraftCollateralizationRequestListUI.this.tblMain.getColumn("commercialDraft.draftAmount").getStyleAttributes();
            styleAttributes.setNumberFormat("###,##0.00");
            styleAttributes.setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
            if (DraftCollateralizationRequestListUI.this.tblMain.getFootManager() != null && DraftCollateralizationRequestListUI.this.tblMain.getFootManager().getFootRow(0) != null) {
                row = DraftCollateralizationRequestListUI.this.tblMain.getFootManager().getFootRow(0);
                StyleAttributes footStyle = row.getCell("commercialDraft.draftAmount").getStyleAttributes();
                footStyle.setNumberFormat("###,##0.00");
                footStyle.setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
            }
        }
    }
}

