/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.edrafent.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.assistant.BankCollection;
import com.kingdee.eas.basedata.assistant.BankFactory;
import com.kingdee.eas.basedata.assistant.BankInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.fm.common.ContextHelperFactory;
import com.kingdee.eas.fm.common.DateHelper;
import com.kingdee.eas.fm.common.FMSysDefinedEnum;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMClientVerifyHelper;
import com.kingdee.eas.fm.ecore.ECDSBillStatusEnum;
import com.kingdee.eas.fm.edrafent.DrafTypeEnum;
import com.kingdee.eas.fm.edrafent.GuaranteeRequestTypeEnum;
import com.kingdee.eas.fm.edrafent.OperateStateEnum;
import com.kingdee.eas.fm.edrafent.client.AbstractDraftGuaranteeRequestBillFilterUI;
import com.kingdee.eas.fm.edrafent.client.DraftGuaranteeRequestBillFilterParam;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.event.ActionEvent;
import java.sql.Date;
import org.apache.log4j.Logger;

public class DraftGuaranteeRequestBillFilterUI
extends AbstractDraftGuaranteeRequestBillFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(DraftGuaranteeRequestBillFilterUI.class);

    protected void init() throws Exception {
        super.init();
        this.pkDraftRegisterFrom.setValue((Object)DateHelper.getFirstDayOfCurMonth());
        this.pkDraftRegisterTo.setValue((Object)new java.util.Date());
        this.cmbDraftType.addItem((Object)FMSysDefinedEnum.SELECT_ALL);
        this.cmbGuaranteeType.addItem((Object)FMSysDefinedEnum.SELECT_ALL);
        this.cmbOperateState.addItem((Object)FMSysDefinedEnum.SELECT_ALL);
        this.cmbOperateState.removeItem((Object)OperateStateEnum.CANCEL1);
        this.cmbOperateState.removeItem((Object)OperateStateEnum.STOCKED);
        if (this.checkFin()) {
            this.cmbDraftState.addItem((Object)ECDSBillStatusEnum.CPYDJ);
            this.cmbDraftState.addItem((Object)ECDSBillStatusEnum.TSCDYQS);
            this.cmbDraftState.addItem((Object)ECDSBillStatusEnum.TSSPYQS);
            this.cmbDraftState.addItem((Object)ECDSBillStatusEnum.BSYQS);
            this.cmbDraftState.addItem((Object)ECDSBillStatusEnum.MDSTXYQS);
            this.cmbDraftState.addItem((Object)ECDSBillStatusEnum.HGSTXYQS);
            this.cmbDraftState.addItem((Object)ECDSBillStatusEnum.HGSTXYYSHJZR);
            this.cmbDraftState.addItem((Object)ECDSBillStatusEnum.MDSZHTXYQS);
            this.cmbDraftState.addItem((Object)ECDSBillStatusEnum.HGSZHTXYQS);
            this.cmbDraftState.addItem((Object)ECDSBillStatusEnum.HGSZHTXYYSHJZR);
            this.cmbDraftState.addItem((Object)ECDSBillStatusEnum.MDSZTXYQS);
            this.cmbDraftState.addItem((Object)ECDSBillStatusEnum.HGSZTXSHYQS);
            this.cmbDraftState.addItem((Object)ECDSBillStatusEnum.HGSZTXYYSHJZR);
            this.cmbDraftState.addItem((Object)ECDSBillStatusEnum.YHMPYQS);
            this.cmbDraftState.addItem((Object)ECDSBillStatusEnum.ZYJCYQS);
            this.cmbDraftState.addItem((Object)ECDSBillStatusEnum.BZDQS);
        } else {
            this.cmbDraftState.addItem((Object)ECDSBillStatusEnum.TSCDYQS);
            this.cmbDraftState.addItem((Object)ECDSBillStatusEnum.BZDQS);
        }
        this.cmbDraftState.addItem((Object)FMSysDefinedEnum.SELECT_ALL);
        this.cmbDraftType.setSelectedItem((Object)FMSysDefinedEnum.SELECT_ALL);
        this.cmbOperateState.setSelectedItem((Object)FMSysDefinedEnum.SELECT_ALL);
        this.cmbDraftState.setSelectedItem((Object)FMSysDefinedEnum.SELECT_ALL);
        this.cmbGuaranteeType.setSelectedItem((Object)FMSysDefinedEnum.SELECT_ALL);
    }

    protected boolean checkFin() throws BOSException {
        boolean flag = false;
        CompanyOrgUnitInfo info = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        if (info != null) {
            EntityViewInfo env = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("relatedCompany.id", (Object)info.getId().toString(), CompareType.EQUALS));
            env.setFilter(filter);
            BankCollection col = BankFactory.getRemoteInstance().getBankCollection(env);
            BankInfo bank = null;
            if (col.size() > 0) {
                bank = col.get(0);
            }
            if (bank == null || bank != null && !bank.isIsFinanceCompany()) {
                flag = true;
            }
        }
        return flag;
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected void chkIA_actionPerformed(ActionEvent e) throws Exception {
        super.chkIA_actionPerformed(e);
    }

    protected void btnCompanySelect_actionPerformed(ActionEvent e) throws Exception {
        super.btnCompanySelect_actionPerformed(e);
    }

    protected Class getParamClass() {
        return DraftGuaranteeRequestBillFilterParam.class;
    }

    public boolean verify() {
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDDatePicker)this.pkDraftRegisterFrom);
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDDatePicker)this.pkDraftRegisterTo);
        Date dateFrom = this.pkDraftRegisterFrom.getSqlDate();
        Date dateTo = this.pkDraftRegisterTo.getSqlDate();
        if (dateTo.compareTo(dateFrom) < 0) {
            MsgBox.showWarning((String)"\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u5927\u4e8e\u7ed3\u675f\u65f6\u95f4");
            SysUtil.abort();
        }
        return super.verify();
    }

    public Object getParam() {
        DraftGuaranteeRequestBillFilterParam param = new DraftGuaranteeRequestBillFilterParam();
        if (this.getCompanyIdSet() != null && this.getCompanyIdSet().size() > 0) {
            param.setCompanyIdSet(this.getCompanyIdSet());
        }
        param.setStarttime((java.util.Date)this.pkDraftRegisterFrom.getValue());
        param.setEndtime((java.util.Date)this.pkDraftRegisterTo.getValue());
        if (this.cmbDraftType.getSelectedItem() != null) {
            if (this.cmbDraftType.getSelectedItem() instanceof DrafTypeEnum) {
                param.setDraftType(((DrafTypeEnum)((Object)this.cmbDraftType.getSelectedItem())).getValue());
            } else {
                param.setDraftType(-1);
            }
        }
        if (this.cmbGuaranteeType.getSelectedItem() != null) {
            if (this.cmbGuaranteeType.getSelectedItem() instanceof GuaranteeRequestTypeEnum) {
                param.setGuaranteeType(((GuaranteeRequestTypeEnum)((Object)this.cmbGuaranteeType.getSelectedItem())).getValue());
            } else {
                param.setGuaranteeType(-1);
            }
        }
        if (this.cmbDraftState.getSelectedItem() != null) {
            if (this.cmbDraftState.getSelectedItem() instanceof ECDSBillStatusEnum) {
                param.setDraftState(((ECDSBillStatusEnum)this.cmbDraftState.getSelectedItem()).getValue());
            } else {
                param.setDraftState(null);
            }
        }
        if (this.cmbOperateState.getSelectedItem() != null) {
            if (this.cmbOperateState.getSelectedItem() instanceof OperateStateEnum) {
                param.setOperateState(((OperateStateEnum)((Object)this.cmbOperateState.getSelectedItem())).getValue());
            } else {
                param.setOperateState(-1);
            }
        }
        return param;
    }

    public void setParam(Object param) {
        if (param == null) {
            return;
        }
        DraftGuaranteeRequestBillFilterParam filterParam = (DraftGuaranteeRequestBillFilterParam)((Object)param);
        this.pkDraftRegisterFrom.setValue((Object)filterParam.getStarttime());
        this.pkDraftRegisterTo.setValue((Object)filterParam.getEndtime());
        DrafTypeEnum draftType = DrafTypeEnum.getEnum(filterParam.getDraftType());
        if (draftType == null) {
            FMClientHelper.setSelectObject((KDComboBox)this.cmbDraftType, (Object)FMSysDefinedEnum.SELECT_ALL);
        } else {
            FMClientHelper.setSelectObject((KDComboBox)this.cmbDraftType, (Object)((Object)draftType));
        }
        GuaranteeRequestTypeEnum guaranteeRequestTypeEnum = GuaranteeRequestTypeEnum.getEnum(filterParam.getGuaranteeType());
        if (guaranteeRequestTypeEnum == null) {
            FMClientHelper.setSelectObject((KDComboBox)this.cmbGuaranteeType, (Object)FMSysDefinedEnum.SELECT_ALL);
        } else {
            FMClientHelper.setSelectObject((KDComboBox)this.cmbGuaranteeType, (Object)((Object)guaranteeRequestTypeEnum));
        }
        OperateStateEnum operateStateEnum = OperateStateEnum.getEnum(filterParam.getOperateState());
        if (operateStateEnum == null) {
            FMClientHelper.setSelectObject((KDComboBox)this.cmbOperateState, (Object)FMSysDefinedEnum.SELECT_ALL);
        } else {
            FMClientHelper.setSelectObject((KDComboBox)this.cmbOperateState, (Object)((Object)operateStateEnum));
        }
        ECDSBillStatusEnum billStatus = ECDSBillStatusEnum.getEnum((String)filterParam.getDraftState());
        if (billStatus == null) {
            FMClientHelper.setSelectObject((KDComboBox)this.cmbDraftState, (Object)FMSysDefinedEnum.SELECT_ALL);
        } else {
            FMClientHelper.setSelectObject((KDComboBox)this.cmbDraftState, (Object)billStatus);
        }
        this.setCompanyIdSet(filterParam.getCompanyIdSet());
    }

    protected void setDefaultValue() {
        super.setDefaultValue();
        this.companyIds = new String[]{""};
    }

    public void clear() {
        super.clear();
        this.pkDraftRegisterFrom.setValue((Object)DateHelper.getFirstDayOfCurMonth());
        this.pkDraftRegisterTo.setValue((Object)new java.util.Date());
        this.cmbGuaranteeType.setSelectedItem((Object)FMSysDefinedEnum.SELECT_ALL);
        this.cmbDraftType.setSelectedItem((Object)FMSysDefinedEnum.SELECT_ALL);
        this.cmbOperateState.setSelectedItem((Object)FMSysDefinedEnum.SELECT_ALL);
        this.cmbDraftState.setSelectedItem((Object)FMSysDefinedEnum.SELECT_ALL);
    }
}

