/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.edrafent.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.AbstractUIFactory;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.client.FMFilterBaseUI;
import com.kingdee.eas.fm.ecore.ECDSBillStatusEnum;
import com.kingdee.eas.fm.edraf.client.FCDraftGuaranteeRequestBillListUI;
import com.kingdee.eas.fm.edraf.util.EdrafUtil;
import com.kingdee.eas.fm.edrafent.CommercialDraftInfo;
import com.kingdee.eas.fm.edrafent.DraftApplyTypeEnum;
import com.kingdee.eas.fm.edrafent.DraftGuaranteeRequestBillFactory;
import com.kingdee.eas.fm.edrafent.DraftGuaranteeRequestBillInfo;
import com.kingdee.eas.fm.edrafent.IDraftGuaranteeRequestBill;
import com.kingdee.eas.fm.edrafent.OperateStateEnum;
import com.kingdee.eas.fm.edrafent.client.AbstractDraftGuaranteeRequestBillListUI;
import com.kingdee.eas.fm.edrafent.client.DraftGuaranteeRequestBillFilterUI;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class DraftGuaranteeRequestBillListUI
extends AbstractDraftGuaranteeRequestBillListUI {
    private static final Logger logger = CoreUIObject.getLogger(DraftGuaranteeRequestBillListUI.class);
    private DraftGuaranteeRequestBillFilterUI filterUI = null;
    private int rowIndex = -1;
    private String type = "%r-[ ]0.2n";
    FillListener fillListener = new FillListener();

    @Override
    public void onLoad() throws Exception {
        super.onLoad();
    }

    protected void initWorkButton() {
        super.initWorkButton();
        if (this.validateCompany()) {
            this.ActionSubmit.setVisible(false);
            this.ActionSubmit.setEnabled(false);
            this.actionRepealReq.setVisible(false);
            this.actionRepealReq.setEnabled(false);
        } else {
            this.actionAudit.setVisible(true);
            this.actionAudit.setEnabled(false);
            this.ActionUnAudit.setVisible(true);
            this.ActionUnAudit.setEnabled(false);
            this.actionFinanceCompany.setEnabled(false);
            this.actionCopyTo.setVisible(false);
            this.actionCreateTo.setVisible(false);
            this.ActionSubmit.setVisible(true);
            this.ActionSubmit.setEnabled(true);
            this.actionRepealReq.setVisible(true);
            this.actionRepealReq.setEnabled(false);
            this.actionBatchPrint.setVisible(false);
            this.actionBatchPrintPreview.setVisible(false);
        }
    }

    @Override
    protected boolean isFootVisible() {
        return true;
    }

    public IUIObject getInstance(Map uiContext) {
        DraftGuaranteeRequestBillInfo billInfo = null;
        if (uiContext.get("BOTPViewStatus") != null) {
            billInfo = (DraftGuaranteeRequestBillInfo)uiContext.get("InitDataObject");
        } else {
            if (uiContext.get("ID") == null) {
                return super.getInstance(uiContext);
            }
            String id = null;
            id = uiContext.get("ID") instanceof BOSUuid ? ((BOSUuid)uiContext.get("ID")).toString() : (uiContext.get("ID") instanceof String ? (String)uiContext.get("ID") : uiContext.get("ID").toString());
            ObjectUuidPK pk = new ObjectUuidPK(id);
            try {
                billInfo = ((IDraftGuaranteeRequestBill)this.getBizInterface()).getDraftGuaranteeRequestBillInfo((IObjectPK)pk);
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        if (billInfo == null) {
            return super.getInstance(uiContext);
        }
        CompanyOrgUnitInfo orgUnitInfo = billInfo.getCompany();
        if (orgUnitInfo != null) {
            try {
                if (EdrafUtil.checkIsFinanceCompany(null, (String)orgUnitInfo.getId().toString())) {
                    return AbstractUIFactory.createUIObjectNoInit((String)FCDraftGuaranteeRequestBillListUI.class.getName());
                }
                if (!EdrafUtil.checkIsFinanceCompany(null, (String)orgUnitInfo.getId().toString())) {
                    return AbstractUIFactory.createUIObjectNoInit((String)DraftGuaranteeRequestBillListUI.class.getName());
                }
                return super.getInstance(uiContext);
            }
            catch (UIException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            catch (BOSException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return super.getInstance(uiContext);
    }

    @Override
    public FMFilterBaseUI getFilterUI() throws Exception {
        if (this.filterUI == null) {
            this.filterUI = new DraftGuaranteeRequestBillFilterUI();
        }
        return this.filterUI;
    }

    protected FilterInfo getDefaultFilterForQuery() {
        FilterInfo filterInfo = super.getDefaultFilterForQuery();
        return filterInfo;
    }

    protected void initListener() {
        super.initListener();
        this.tblMain.getDataRequestManager().addDataFillListener((KDTDataFillListener)this.fillListener);
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return DraftGuaranteeRequestBillFactory.getRemoteInstance();
    }

    protected String getKeyFieldName() {
        return "id";
    }

    @Override
    public void actionAudit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList billID = this.getSelectedIdValues();
        if (billID == null) {
            return;
        }
        this.checkBillsHasWF(billID);
        boolean hasWfInstance = FMHelper.hasWFInstance(null, (String)((String)billID.get(0)));
        if (hasWfInstance) {
            this.actionMultiapprove_actionPerformed(e);
        } else {
            DraftGuaranteeRequestBillFactory.getRemoteInstance().audit(FMHelper.list2Set((List)billID));
            MsgBox.showInfo((String)"\u64cd\u4f5c\u6210\u529f");
        }
        this.refreshList();
    }

    @Override
    public void actionUnAudit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList billID = this.getSelectedIdValues();
        if (billID == null) {
            return;
        }
        DraftGuaranteeRequestBillFactory.getRemoteInstance().unAudit(FMHelper.list2Set((List)billID));
        MsgBox.showInfo((String)"\u53cd\u5ba1\u6279\u6210\u529f");
        this.refreshList();
    }

    @Override
    public void actionBatchPrint_actionPerformed(ActionEvent e) throws Exception {
        super.actionBatchPrintPreview_actionPerformed(e);
    }

    @Override
    public void actionBatchPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        super.actionBatchPrintPreview_actionPerformed(e);
    }

    @Override
    public void actionBankCorporate_actionPerformed(ActionEvent e) throws Exception {
        super.actionBankCorporate_actionPerformed(e);
    }

    @Override
    public void actionFinanceCompany_actionPerformed(ActionEvent e) throws Exception {
        super.actionFinanceCompany_actionPerformed(e);
        this.checkSelected();
        ArrayList billID = this.getSelectedIdValues();
        if (billID == null) {
            return;
        }
        if (billID.size() == 1) {
            ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)billID.get(0).toString()));
            if (!this.getBizInterface().exists((IObjectPK)pk)) {
                this.refreshList();
                throw new EASBizException(EASBizException.CHECKEXIST);
            }
            SelectorItemCollection sc = new SelectorItemCollection();
            sc.add(new SelectorItemInfo("id"));
            sc.add(new SelectorItemInfo("operateState"));
            CoreBaseInfo o = this.getBizInterface().getValue((IObjectPK)pk, sc);
            DraftGuaranteeRequestBillInfo billInfo = (DraftGuaranteeRequestBillInfo)o;
            if (billInfo.getOperateState() != OperateStateEnum.AUDIT) {
                MsgBox.showWarning((Component)((Object)this), (String)"\u5355\u636e\u672a\u5ba1\u6838\uff0c\u4e0d\u80fd\u8fdb\u884c\u6b64\u64cd\u4f5c");
                return;
            }
        }
        DraftGuaranteeRequestBillFactory.getRemoteInstance().batchSubmitFC(FMHelper.list2Set((List)billID), DraftApplyTypeEnum.BAOZHENG);
        MsgBox.showInfo((String)"\u63d0\u4ea4\u8d22\u52a1\u516c\u53f8\u6210\u529f");
        this.refreshList();
    }

    protected void tblMain_tableSelectChanged(KDTSelectEvent e) throws Exception {
        super.tblMain_tableSelectChanged(e);
        this.rowIndex = e.getSelectBlock().getEndRow();
        this.checkSelected();
        ArrayList billID = this.getSelectedIdValues();
        if (billID == null) {
            return;
        }
        if (billID.size() == 1) {
            ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)billID.get(0).toString()));
            SelectorItemCollection sc = new SelectorItemCollection();
            sc.add(new SelectorItemInfo("*"));
            sc.add(new SelectorItemInfo("commercialDraft.*"));
            CoreBaseInfo o = this.getBizInterface().getValue((IObjectPK)pk, sc);
            DraftGuaranteeRequestBillInfo billInfo = (DraftGuaranteeRequestBillInfo)o;
            CommercialDraftInfo commercialDraftInfo = billInfo.getCommercialDraft();
            if (commercialDraftInfo.getDraftECDSStatus() == ECDSBillStatusEnum.BZDQS && !billInfo.isIsCancelDraft() && billInfo.getOperateState() == OperateStateEnum.SUBMITGATEWAY) {
                this.actionRepealReq.setEnabled(true);
                this.menuBankCorporate.setEnabled(false);
            } else {
                this.actionRepealReq.setEnabled(false);
                this.menuBankCorporate.setEnabled(false);
            }
            if (billInfo.getOperateState().equals((Object)OperateStateEnum.SAVE) || billInfo.getOperateState().equals((Object)OperateStateEnum.SUBMIT)) {
                this.actionEdit.setEnabled(true);
                this.actionRemove.setEnabled(true);
            } else {
                this.actionEdit.setEnabled(false);
                this.actionRemove.setEnabled(false);
            }
            if (billInfo.getOperateState().equals((Object)OperateStateEnum.SUBMIT)) {
                this.actionAudit.setEnabled(true);
            } else {
                this.actionAudit.setEnabled(false);
            }
            if (billInfo.getOperateState().equals((Object)OperateStateEnum.AUDIT)) {
                this.ActionUnAudit.setEnabled(true);
                this.actionFinanceCompany.setEnabled(true);
            } else {
                this.ActionUnAudit.setEnabled(false);
                this.actionFinanceCompany.setEnabled(false);
            }
        } else {
            this.btnRepealReq.setEnabled(false);
            this.menuRepealReq.setEnabled(false);
            this.menuBankCorporate.setEnabled(false);
            this.actionEdit.setEnabled(false);
            this.actionRemove.setEnabled(true);
            this.actionAudit.setEnabled(true);
            this.ActionUnAudit.setEnabled(true);
            this.actionFinanceCompany.setEnabled(true);
        }
    }

    @Override
    public void actionRepealReq_actionPerformed(ActionEvent e) throws Exception {
        super.actionRepealReq_actionPerformed(e);
        this.checkSelected();
        ArrayList billID = this.getSelectedIdValues();
        if (billID == null) {
            return;
        }
        DraftGuaranteeRequestBillFactory.getRemoteInstance().cancelApply(billID.get(0).toString(), DraftApplyTypeEnum.BAOZHENG);
        MsgBox.showInfo((String)"\u64a4\u9500\u7533\u8bf7\u6210\u529f\uff01");
        this.refreshList();
    }

    @Override
    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList billID = this.getSelectedIdValues();
        if (billID == null) {
            return;
        }
        DraftGuaranteeRequestBillFactory.getRemoteInstance().submit(FMHelper.list2Set((List)billID));
        MsgBox.showInfo((String)"\u63d0\u4ea4\u6210\u529f");
        this.refreshList();
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        super.actionEdit_actionPerformed(e);
    }

    @Override
    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        super.actionRemove_actionPerformed(e);
        this.refreshList();
    }

    @Override
    protected IObjectValue createNewData() {
        DraftGuaranteeRequestBillInfo objectValue = new DraftGuaranteeRequestBillInfo();
        return objectValue;
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("commercialDraft.*"));
        return sic;
    }

    private final class FillListener
    implements KDTDataFillListener {
        private FillListener() {
        }

        public void afterDataFill(KDTDataRequestEvent e) {
            IRow row = null;
            Object currencyId = null;
            if (e == null) {
                return;
            }
            for (int i = e.getFirstRow(); i <= e.getLastRow(); ++i) {
                row = DraftGuaranteeRequestBillListUI.this.tblMain.getRow(i);
                StyleAttributes horizon = row.getCell("commercialDraft.draftAmount").getStyleAttributes();
                horizon.setNumberFormat("###,##0.00");
                horizon.setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
            }
            if (DraftGuaranteeRequestBillListUI.this.tblMain.getFootManager() != null && DraftGuaranteeRequestBillListUI.this.tblMain.getFootManager().getFootRow(0) != null) {
                row = DraftGuaranteeRequestBillListUI.this.tblMain.getFootManager().getFootRow(0);
                StyleAttributes footStyle = row.getCell("commercialDraft.draftAmount").getStyleAttributes();
                footStyle.setNumberFormat(DraftGuaranteeRequestBillListUI.this.type);
                footStyle.setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
                row.getStyleAttributes().setLocked(true);
            }
        }
    }
}

