/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.edrafent.client;

import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.BasicFormattedTextField;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.UIFocusTraversalPolicy;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.AccountBankCollection;
import com.kingdee.eas.basedata.assistant.AccountBankFactory;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fm.be.BEBankInfo;
import com.kingdee.eas.fm.common.FMBgItemProp;
import com.kingdee.eas.fm.common.FMConstants;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMClientVerifyHelper;
import com.kingdee.eas.fm.edrafent.CommercialDraftInfo;
import com.kingdee.eas.fm.edrafent.DrafTypeEnum;
import com.kingdee.eas.fm.edrafent.DraftKindEnum;
import com.kingdee.eas.fm.edrafent.DraftLienInfoBillFactory;
import com.kingdee.eas.fm.edrafent.DraftLienInfoBillInfo;
import com.kingdee.eas.fm.edrafent.OperateStateEnum;
import com.kingdee.eas.fm.edrafent.client.AbstractDraftLienInfoBillEditUI;
import com.kingdee.eas.fm.edrafent.util.EdrafentUtil;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.ma.budget.FpCashDirectionEnum;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.FocusTraversalPolicy;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import org.apache.log4j.Logger;

public class DraftLienInfoBillEditUI
extends AbstractDraftLienInfoBillEditUI {
    private static final Logger logger = CoreUIObject.getLogger(DraftLienInfoBillEditUI.class);

    public DraftLienInfoBillEditUI() throws Exception {
        this.setFocusTraversalPolicy((FocusTraversalPolicy)new UIFocusTraversalPolicy(new Component[]{this.txtNumber, this.pkapplyDate, this.combDraftType, this.pkIssueDate, this.txtDraftNumber, this.pkDueDate, this.txtDraftAmount, this.txtpledgorName, this.txtpledgorAccount, this.txtpledgorBeBank, this.prmtpawneeName, this.prmtpawneeAccount, this.prmtpawneeBeBank, this.txtacceptorName, this.txtacceptorBankNum, this.txtacceptorBank, this.txtacceptorBankNam, this.prmtbudgetItem, this.txtbatchNumber, this.txtRemark}));
    }

    @Override
    public void loadFields() {
        super.loadFields();
        this.txtDraftAmount.setPrecision(2);
        if (this.draftKind.getSelectedItem() != null) {
            FMClientHelper.loadFieldsBgItem((KDBizPromptBox)this.prmtbudgetItem, (CoreBaseInfo)this.editData, (FMBgItemProp)this.editData.getBgItemProps()[0]);
            if (this.getOprtState().equals(OprtState.ADDNEW)) {
                this.txtDraftNumber.setCharsCount(16);
                String typeMatch = "abcdefghijklmnopqrstuvwxyzABCDEFTGHIJKLMNOPQRSTUVWXYZ0123456789";
                this.txtDraftNumber.setValidCharacters(typeMatch);
                this.txtDraftNumber.setDigit(true);
                this.txtpledgorAccount.setCharsCount(32);
                this.txtpledgorAccount.setValidCharacters(typeMatch);
                this.txtpledgorAccount.setDigit(true);
                this.txtacceptorBank.setValidCharacters(typeMatch);
                this.txtacceptorBank.setDigit(true);
                this.pkDueDate.setEnabled(true);
                this.draftKind.setSelectedItem((Object)DraftKindEnum.PAPERDRAFT);
                this.chkisAttorn.setSelected(true);
                Date today = new Date();
                this.pkapplyDate.setValue((Object)today);
                this.pkIssueDate.setValue((Object)today);
                this.pkDueDate.setValue((Object)today);
                this.prmtpawneeName.setValue((Object)SysContext.getSysContext().getCurrentFIUnit());
                this.txtpawneeOrgCode.setText(SysContext.getSysContext().getCurrentOrgUnit().getCode());
                this.txtacceptorBank.setCharsCount(32);
                this.txtacceptorBankNum.setCharsCount(12);
            } else if (this.getOprtState().equals(OprtState.EDIT)) {
                if ((DraftKindEnum)((Object)this.draftKind.getSelectedItem()) == DraftKindEnum.PAPERDRAFT) {
                    // empty if block
                }
                if ((DraftKindEnum)((Object)this.draftKind.getSelectedItem()) == DraftKindEnum.ELECDRAFT) {
                    this.initEditUIForElecdraft();
                }
            }
        }
        if (GlUtils.isCompanyUnion((CompanyOrgUnitInfo)this.currentCompany)) {
            this.actionAddNew.setVisible(false);
            this.actionSave.setVisible(false);
            this.actionEdit.setVisible(false);
            this.actionRemove.setVisible(false);
            this.actionAudit.setVisible(false);
            this.ActionUnAudit.setVisible(false);
        }
        this.initOldData((IObjectValue)this.editData);
    }

    private void initEditUIForElecdraft() {
        this.actionSubmit.setEnabled(true);
        this.btnSubmit.setEnabled(true);
        this.btnSubmit.setVisible(true);
        this.prmtbudgetItem.setEnabled(true);
        this.txtRemark.setEnabled(true);
        this.txtbatchNumber.setEnabled(true);
        this.txtNumber.setEnabled(false);
        this.pkIssueDate.setEnabled(false);
        this.combDraftType.setEnabled(false);
        this.pkapplyDate.setEnabled(false);
        this.txtDraftNumber.setEnabled(false);
        this.pkDueDate.setEnabled(false);
        this.draftKind.setEnabled(false);
        this.txtDraftAmount.setEnabled(false);
        this.txtpledgorName.setEnabled(false);
        this.txtpledgorAccount.setEnabled(false);
        this.txtpledgorBeBank.setEnabled(false);
        this.prmtpawneeName.setEnabled(false);
        this.prmtpawneeAccount.setEnabled(false);
        this.prmtpawneeBeBank.setEnabled(false);
        this.txtacceptorName.setEnabled(false);
        this.txtacceptorBank.setEnabled(false);
        this.txtacceptorBank.setCharsCount(32);
        this.txtacceptorBankNum.setEnabled(false);
        this.txtacceptorBankNum.setCharsCount(12);
        this.txtacceptorBankNam.setEnabled(false);
        this.chkisAttorn.setEnabled(false);
        this.chklienRegister.setEnabled(false);
        this.prmtSubmitter.setEnabled(false);
        this.pkSubmitDate.setEnabled(false);
    }

    protected void initUIProp() throws Exception {
        FpCashDirectionEnum[] fp = new FpCashDirectionEnum[]{FpCashDirectionEnum.output, FpCashDirectionEnum.other};
        FMClientHelper.initBgItemF7((KDBizPromptBox)this.prmtbudgetItem, (FpCashDirectionEnum[])fp, (boolean)true, (boolean)true);
        FMClientHelper.initCurrencyField((BasicFormattedTextField)this.txtDraftAmount);
        super.initUIProp();
    }

    @Override
    public void storeFields() {
        super.storeFields();
        FMClientHelper.storeFieldsBgItem((KDBizPromptBox)this.prmtbudgetItem, (CoreBaseInfo)this.editData, (FMBgItemProp)this.editData.getBgItemProps()[0]);
    }

    @Override
    public void onLoad() throws Exception {
        CompanyOrgUnitInfo company;
        super.onLoad();
        this.btnAudit.setVisible(false);
        this.btnAudit.setEnabled(false);
        this.prmtpawneeName.setEnabled(false);
        this.actionCopy.setVisible(false);
        this.actionCreateFrom.setVisible(false);
        this.actionCreateTo.setVisible(false);
        this.actionEdit.setVisible(false);
        this.actionRemove.setVisible(false);
        this.actionCopyFrom.setVisible(false);
        this.btnAttachment.setEnabled(true);
        this.actionAddNew.setVisible(false);
        this.menuItemAddNew.setVisible(false);
        this.btnTraceDown.setVisible(false);
        this.btnTraceUp.setVisible(false);
        this.actionTraceDown.setVisible(false);
        this.actionTraceUp.setVisible(false);
        if (this.getOprtState().equals(OprtState.ADDNEW)) {
            this.menuSubmitOption.setVisible(true);
            this.menuSubmitOption.setEnabled(true);
            this.chkMenuItemSubmitAndAddNew.setVisible(true);
            this.prmtpawneeAccount.setValue(null);
            this.prmtpawneeBeBank.setValue(null);
        }
        if (this.getOprtState() == OprtState.ADDNEW) {
            this.combDraftType.setSelectedItem((Object)DrafTypeEnum.AC01);
        }
        if (GlUtils.isCompanyUnion((CompanyOrgUnitInfo)this.currentCompany)) {
            this.menuSubmitOption.setVisible(false);
        }
        if (null != (company = (CompanyOrgUnitInfo)this.prmtpawneeName.getValue())) {
            String companyId = company.getId().toString();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyId));
            EntityViewInfo evi = new EntityViewInfo();
            evi.setFilter(filter);
            this.prmtpawneeAccount.setEntityViewInfo(evi);
            this.prmtpawneeAccount.getQueryAgent().resetRuntimeEntityView();
        }
    }

    @Override
    public void onShow() throws Exception {
        super.onShow();
        this.pkapplyDate.requestFocus();
    }

    protected void initCommonOprtStatus() {
        DraftLienInfoBillInfo billInfo = (DraftLienInfoBillInfo)this.getDataObject();
        if (billInfo.getDraftKind() == DraftKindEnum.ELECDRAFT) {
            this.actionRemove.setEnabled(false);
            this.btnRemove.setEnabled(false);
            this.menuItemRemove.setEnabled(false);
        }
    }

    @Override
    protected void prmtpawneeName_dataChanged(DataChangeEvent e) throws Exception {
        Object value = this.prmtpawneeName.getData();
        if (value != null) {
            CompanyOrgUnitInfo companyInfo = (CompanyOrgUnitInfo)value;
            EntityViewInfo view = new EntityViewInfo();
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("*"));
            sic.add(new SelectorItemInfo("bank.*"));
            sic.add(new SelectorItemInfo("bank.accountBank.*"));
            sic.add(new SelectorItemInfo("company.*"));
            view.setSelector(sic);
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyInfo.getId().toString(), CompareType.EQUALS));
            view.setFilter(filter);
            AccountBankCollection coll = AccountBankFactory.getRemoteInstance().getAccountBankCollection(view);
            if (coll != null) {
                AccountBankInfo bankInfo = coll.get(0);
                this.prmtpawneeAccount.setData((Object)bankInfo);
            }
            EntityViewInfo evi = new EntityViewInfo();
            evi.setFilter(filter);
            this.prmtpawneeAccount.setEntityViewInfo(evi);
            this.prmtpawneeAccount.getQueryAgent().resetRuntimeEntityView();
        }
    }

    @Override
    protected void prmtpawneeAccount_dataChanged(DataChangeEvent e) throws Exception {
        AccountBankInfo accountBank;
        String id;
        BEBankInfo beBank;
        Object data = this.prmtpawneeAccount.getData();
        if (data != null && data instanceof AccountBankInfo && (beBank = EdrafentUtil.getBEBankByBankId(id = (accountBank = (AccountBankInfo)data).getBank().getId().toString())) != null) {
            this.prmtpawneeBeBank.setData((Object)beBank);
        }
    }

    @Override
    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        this.verifyInput(e);
        this.storeFields();
        BOSUuid objBillID = this.editData.getId();
        if (objBillID == null) {
            this.editData.setOperateState(OperateStateEnum.SUBMIT);
            super.actionSubmit_actionPerformed(e);
            return;
        }
        ArrayList<BOSUuid> ids = new ArrayList<BOSUuid>();
        ids.add(objBillID);
        if (this.editData.getOperateState() != null && this.editData.getOperateState().equals((Object)OperateStateEnum.SAVE)) {
            this.editData.setOperateState(OperateStateEnum.SUBMIT);
        }
        DraftLienInfoBillFactory.getRemoteInstance().update((IObjectPK)new ObjectUuidPK(this.editData.getId()), (CoreBaseInfo)this.editData);
        MsgBox.showInfo((String)"\u63d0\u4ea4\u6210\u529f\uff01");
    }

    public boolean isModify() {
        if (this.getUIContext().get("REGISTER_INFO") == null) {
            if (this.editData != null && this.editData.getId() != null) {
                return false;
            }
            return super.isModify();
        }
        return false;
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return DraftLienInfoBillFactory.getRemoteInstance();
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("*"));
        return sic;
    }

    @Override
    protected IObjectValue createNewData() {
        DraftLienInfoBillInfo objectValue = new DraftLienInfoBillInfo();
        objectValue.setCompany(SysContext.getSysContext().getCurrentFIUnit());
        objectValue.setCreator((UserInfo)SysContext.getSysContext().getCurrentUser());
        objectValue.setDraftKind(DraftKindEnum.PAPERDRAFT);
        objectValue.setCommercialDraft((CommercialDraftInfo)this.createNewDetailData(null));
        objectValue.setCreateTime(this.getTime());
        objectValue.setOperateState(OperateStateEnum.SAVE);
        return objectValue;
    }

    protected IObjectValue createNewDetailData(KDTable table) {
        CommercialDraftInfo info = new CommercialDraftInfo();
        info.setIssueDate(new Date());
        info.setDueDate(new Date());
        info.setDraftType(DrafTypeEnum.AC01);
        info.setDraftAmount(new BigDecimal(0.0));
        return info;
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        super.verifyInput(e);
        if ((DraftKindEnum)((Object)this.draftKind.getSelectedItem()) == DraftKindEnum.PAPERDRAFT) {
            String prmtpawneeTxt;
            String acceptTxt;
            String pledgorTxt = this.txtpledgorName.getText().trim();
            if (pledgorTxt == null || pledgorTxt.equals("")) {
                MsgBox.showInfo((String)"\u51fa\u8d28\u4eba\u5168\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                this.txtpledgorName.requestFocus();
                SysUtil.abort();
            }
            if ((acceptTxt = this.txtacceptorName.getText().trim()) == null || acceptTxt.equals("")) {
                MsgBox.showInfo((String)"\u627f\u5151\u4eba\u5168\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                this.txtacceptorName.requestFocus();
                SysUtil.abort();
            }
            if ((prmtpawneeTxt = this.prmtpawneeName.getText().trim()) == null || prmtpawneeTxt.equals("")) {
                MsgBox.showInfo((String)"\u8d28\u6743\u4eba\u5168\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                this.prmtpawneeName.requestFocus();
                SysUtil.abort();
            }
            if (FMHelper.isEmpty((String)this.prmtpawneeAccount.getText())) {
                MsgBox.showInfo((String)"\u8d28\u6743\u4eba\u8d26\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                this.prmtpawneeAccount.requestFocus();
                SysUtil.abort();
            }
            if (FMHelper.isEmpty((String)this.prmtpawneeBeBank.getText())) {
                MsgBox.showInfo((String)"\u8d28\u6743\u4eba\u5f00\u6237\u884c\u884c\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                this.prmtpawneeBeBank.requestFocus();
                SysUtil.abort();
            }
            if (!this.txtDraftNumber.getText().matches("[a-z,A-Z,0-9]{1,16}")) {
                MsgBox.showWarning((String)"\u7968\u636e\u53f7\u7801\u53ea\u80fd\u4e3a\u3010 a-z,A-Z,0-9 \u3011\u4e4b\u4e2d\u76841\u523016\u4f4d\u5b57\u7b26\uff01");
                this.txtDraftNumber.requestFocus();
                SysUtil.abort();
            }
            if (this.txtDraftAmount.getText().toString() == null || this.txtDraftAmount.getBigDecimalValue().compareTo(FMConstants.ZERO) <= 0) {
                MsgBox.showWarning((String)"\u7968\u636e\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a\u6216\u7b49\u4e8e\u5c0f\u4e8e0\uff01");
                this.txtDraftAmount.requestFocus();
                SysUtil.abort();
            }
            if (FMHelper.isEmpty((String)this.txtpledgorAccount.getText())) {
                MsgBox.showInfo((String)"\u51fa\u8d28\u4eba\u7684\u8d26\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                this.txtpledgorAccount.requestFocus();
                SysUtil.abort();
            }
            if (FMHelper.isEmpty((String)this.txtacceptorBank.getText())) {
                MsgBox.showInfo((String)"\u627f\u5151\u4eba\u7684\u8d26\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                this.txtacceptorBank.requestFocus();
                SysUtil.abort();
            }
            if (!FMHelper.isEmpty((String)this.txtacceptorBank.getText()) && this.txtacceptorBank.getText().trim().length() > 32) {
                MsgBox.showInfo((String)"\u627f\u5151\u4eba\u8d26\u53f7\u6700\u5927\u957f\u5ea6\u4e3a32\u4f4d\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165");
                this.txtacceptorBank.requestFocus();
                SysUtil.abort();
            }
            if (!FMHelper.isEmpty((String)this.txtpledgorAccount.getText()) && this.txtpledgorAccount.getText().trim().length() > 32) {
                MsgBox.showInfo((String)"\u51fa\u8d28\u4eba\u7684\u8d26\u53f7\u6700\u5927\u957f\u5ea6\u4e3a32\u4f4d\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165");
                this.txtpledgorAccount.requestFocus();
                SysUtil.abort();
            }
            if (this.txtpledgorBeBank.getText().toString().length() != 12) {
                MsgBox.showInfo((String)"\u51fa\u8d28\u4eba\u5f00\u6237\u884c\u884c\u53f7\u4e3a12\u4f4d\u6570\u5b57\u578b\uff0c\u8bf7\u68c0\u67e5\u8f93\u5165");
                this.txtpledgorBeBank.requestFocus();
                SysUtil.abort();
            }
            if (this.txtacceptorBankNum.getText().toString().length() != 12) {
                MsgBox.showInfo((String)"\u627f\u5151\u4eba\u5f00\u6237\u884c\u884c\u53f7\u4e3a12\u4f4d\u6570\u5b57\u578b\uff0c\u8bf7\u68c0\u67e5\u8f93\u5165");
                this.txtacceptorBankNum.requestFocus();
                SysUtil.abort();
            }
        }
        if (!(this.txtbatchNumber.getText() == null || this.txtbatchNumber.getText().trim().equals("") || this.txtbatchNumber.getText().trim().length() <= 10 && FMClientHelper.verifyIsNumber((String)this.txtbatchNumber.getText().trim()))) {
            MsgBox.showInfo((String)"\u6279\u6b21\u53f7\u4e3a10\u4f4d\u6570\u5b57\u578b\uff0c\u8bf7\u68c0\u67e5\u8f93\u5165");
            this.txtbatchNumber.requestFocus();
            SysUtil.abort();
        }
        FMClientVerifyHelper.verifyUIControlEmpty((CoreUI)this);
        this.verifyDate();
    }

    private void verifyDate() {
        Date issueDate = (Date)this.pkIssueDate.getValue();
        Date dueDate = (Date)this.pkDueDate.getValue();
        Date applyDate = (Date)this.pkapplyDate.getValue();
        int issue_due = FMHelper.dateCompare((Date)issueDate, (Date)dueDate);
        int apply_due = FMHelper.dateCompare((Date)applyDate, (Date)dueDate);
        if (issue_due >= 0 || apply_due >= 0) {
            MsgBox.showInfo((String)"\u51fa\u7968\u65e5\u671f\u5e94\u5c0f\u4e8e\u7968\u636e\u5230\u671f\u65e5\uff0c\u4e14\u8d28\u62bc\u7533\u8bf7\u65e5\u671f\u8981\u5c0f\u4e8e\u7968\u636e\u5230\u671f\u65e5");
            this.pkIssueDate.requestFocus();
            SysUtil.abort();
        }
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        super.actionEdit_actionPerformed(e);
        this.initEditUIForElecdraft();
        this.reFillFileds();
    }

    private void reFillFileds() {
        this.txtDraftNumber.setValue((Object)this.editData.getCommercialDraft().getDraftNumber());
        this.txtpledgorAccount.setValue((Object)this.editData.getPledgorAccount());
        this.txtpledgorBeBank.setValue((Object)this.editData.getPledgorBeBank());
        this.txtacceptorBank.setValue((Object)this.editData.getAcceptorAccount());
        this.txtacceptorBankNum.setValue((Object)this.editData.getAcceptorBankNumber());
        this.txtbatchNumber.setValue((Object)this.editData.getBatchNumber());
    }
}

