/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.edrafent.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.btp.BTPManagerFactory;
import com.kingdee.eas.base.btp.IBTPManager;
import com.kingdee.eas.basedata.assistant.BankCollection;
import com.kingdee.eas.basedata.assistant.BankFactory;
import com.kingdee.eas.basedata.assistant.BankInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.client.FMFilterBaseUI;
import com.kingdee.eas.fm.edrafent.DraftApplyTypeEnum;
import com.kingdee.eas.fm.edrafent.DraftKindEnum;
import com.kingdee.eas.fm.edrafent.DraftLienInfoBillFactory;
import com.kingdee.eas.fm.edrafent.DraftLienInfoBillInfo;
import com.kingdee.eas.fm.edrafent.IDraftLienInfoBill;
import com.kingdee.eas.fm.edrafent.OperateStateEnum;
import com.kingdee.eas.fm.edrafent.client.AbstractDraftLienInfoBill_CW_ListUI;
import com.kingdee.eas.fm.edrafent.client.DraftLienInfoBillFilterUI;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class DraftLienInfoBill_CW_ListUI
extends AbstractDraftLienInfoBill_CW_ListUI {
    private static final long serialVersionUID = -7711690534001333469L;
    private static final Logger logger = CoreUIObject.getLogger(DraftLienInfoBill_CW_ListUI.class);
    private DraftLienInfoBillFilterUI filterUI = null;
    public static final String numberFormat_AMT = "%r-[ ]0.2n";
    FillListener fillListener = new FillListener();

    @Override
    public void onLoad() throws Exception {
        int state = this.getBOTPViewStatus();
        if (state == 0) {
            if (this.checkFin()) {
                MsgBox.showWarning((String)"\u5f53\u524d\u516c\u53f8\u4e0d\u662f\u8d22\u52a1\u516c\u53f8\uff0c\u4e0d\u5141\u8bb8\u8fdb\u5165\uff01\u8bf7\u5207\u6362\u5230\u8d22\u52a1\u516c\u53f8\u540e\u518d\u64cd\u4f5c\uff01");
                SysUtil.abort();
            } else {
                this.menuItemImpawnRemoveReq.setEnabled(true);
                this.menuItemImpawnRemoveReq.setVisible(true);
                this.menuItemLienRegister.setEnabled(true);
                this.menuItemLienRegister.setVisible(true);
            }
        }
        super.onLoad();
        this.tblMain.checkParsed();
        this.setSumColumnStyle();
        this.setTableFootStyle();
        this.tblMain.setEnabled(false);
        int colSize = this.tblMain.getColumnCount();
        if (colSize > 0) {
            for (int i = 0; i < colSize; ++i) {
                this.tblMain.getColumn(i).setMergeable(false);
            }
        }
        this.tblMain.getMergeManager().setMergeMode(0);
        this.tblMain.getSelectManager().setSelectMode(10);
        this.actionAttachment.setEnabled(false);
        this.actionImpawnRemoveReq.setEnabled(true);
        this.actionLienRegister.setEnabled(true);
        this.actionRpdCollateral.setEnabled(true);
        this.ActionSubmit.setEnabled(true);
        this.actionUnDo.setEnabled(true);
        this.actionCreateTo.setVisible(false);
        this.actionCopyTo.setVisible(false);
        this.btnLocate.setVisible(true);
        this.btnLocate.setEnabled(true);
        this.btnAttachment.setEnabled(true);
        this.MenuItemAttachment.setEnabled(true);
    }

    protected IRow appendFootRow() {
        IRow row = super.appendFootRow();
        if (row != null) {
            String colFormat = "%{0.00####}f";
            ICell cell = row.getCell("commercialDraft.draftAmount");
            if (cell != null) {
                cell.getStyleAttributes().setNumberFormat(colFormat);
            }
        }
        return row;
    }

    private void setSumColumnStyle() {
        if (this.tblMain.getColumn("commercialDraft.draftAmount") != null) {
            StyleAttributes styleAttributes = this.tblMain.getColumn("commercialDraft.draftAmount").getStyleAttributes();
            styleAttributes.setNumberFormat(numberFormat_AMT);
            styleAttributes.setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        }
    }

    public String[] getMergeColumnKeys() {
        return new String[0];
    }

    protected boolean checkFin() throws BOSException {
        boolean flag = false;
        CompanyOrgUnitInfo info = this.currentCompanyCommon;
        if (info != null) {
            EntityViewInfo env = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("relatedCompany.id", (Object)info.getId().toString(), CompareType.EQUALS));
            env.setFilter(filter);
            BankCollection col = BankFactory.getRemoteInstance().getBankCollection(env);
            BankInfo bank = null;
            if (col.size() > 0) {
                bank = col.get(0);
            }
            if (bank == null || bank != null && !bank.isIsFinanceCompany()) {
                flag = true;
            }
        }
        return flag;
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    public void actionImpawnRemoveReq_actionPerformed(ActionEvent e) throws Exception {
        super.actionImpawnRemoveReq_actionPerformed(e);
        this.checkSelected();
        ArrayList ids = this.getSelectedIdValues();
        DraftLienInfoBillFactory.getRemoteInstance().impawnRemoveReq(ids);
        MsgBox.showInfo((String)"\u8d28\u62bc\u89e3\u9664\u7533\u8bf7\u5b8c\u6210\uff01");
        this.refreshList();
    }

    @Override
    public void actionUnDo_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList ids = this.getSelectedIdValues();
        if (ids.size() > 1) {
            MsgBox.showInfo((String)"\u53ea\u652f\u6301\u5355\u5f20\u64a4\u9500\uff01");
            SysUtil.abort();
        } else if (ids.size() == 1) {
            DraftLienInfoBillFactory.getRemoteInstance().cancelApply(ids.get(0).toString(), DraftApplyTypeEnum.ZHIYAJIECHU);
            MsgBox.showInfo((String)"\u64a4\u9500\u6210\u529f\uff01");
        }
        this.refreshList();
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList ids = this.getSelectedIdValues();
        DraftLienInfoBillInfo draftLienInfoBillInfo = DraftLienInfoBillFactory.getRemoteInstance().getDraftLienInfoBillInfo("where id = '" + ids.get(0).toString() + "'");
        if (draftLienInfoBillInfo != null) {
            OperateStateEnum operateState = draftLienInfoBillInfo.getOperateState();
            if (this.isCanBeModified(operateState, ids.get(0).toString())) {
                super.actionEdit_actionPerformed(e);
            } else {
                MsgBox.showInfo((String)"\u64cd\u4f5c\u72b6\u6001\u4e3a\u4fdd\u5b58\u6216\u8005\u63d0\u4ea4\uff0c\u4e14\u65e0\u4e0b\u6e38\u5355\u636e\u7684\u8d28\u6743\u5355\u53ef\u4fee\u6539\uff01");
            }
        }
    }

    private boolean isCanBeModified(OperateStateEnum operateState, String id) throws BOSException {
        IBTPManager iBTPManager = BTPManagerFactory.getRemoteInstance();
        return (operateState == OperateStateEnum.SAVE || operateState == OperateStateEnum.SUBMIT) && !iBTPManager.ifHaveDestBills(id);
    }

    @Override
    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList ids = this.getSelectedIdValues();
        IBTPManager iBTPManager = BTPManagerFactory.getRemoteInstance();
        IDraftLienInfoBill iDraftLienInfoBill = DraftLienInfoBillFactory.getRemoteInstance();
        if (ids.size() == 1) {
            DraftLienInfoBillInfo draftLienInfoBillInfo = iDraftLienInfoBill.getDraftLienInfoBillInfo("where id = '" + ids.get(0).toString() + "'");
            if (draftLienInfoBillInfo.getDraftKind() == DraftKindEnum.PAPERDRAFT && !iBTPManager.ifHaveDestBills(ids.get(0).toString())) {
                super.actionRemove_actionPerformed(e);
            } else {
                MsgBox.showInfo((String)"\u65e0\u4e0b\u6e38\u5355\u636e\u7684\u7eb8\u8d28\u7968\u636e\u8d28\u6743\u5355\u53ef\u5220\u9664\uff01");
            }
        } else {
            iDraftLienInfoBill.remove(ids);
        }
        this.refreshList();
    }

    @Override
    public void actionLienRegister_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList ids = this.getSelectedIdValues();
        DraftLienInfoBillFactory.getRemoteInstance().lienRegister(ids);
        MsgBox.showInfo((String)"\u8d28\u6743\u767b\u8bb0\u5b8c\u6210\uff01");
        this.refreshList();
    }

    @Override
    public void actionRpdCollateral_actionPerformed(ActionEvent e) throws Exception {
        super.actionRpdCollateral_actionPerformed(e);
        this.checkSelected();
        ArrayList ids = this.getSelectedIdValues();
        DraftLienInfoBillFactory.getRemoteInstance().rpdCollateral(ids);
        MsgBox.showInfo((String)"\u8d28\u6743\u767b\u8bb0\u89e3\u9664\u5b8c\u6210\uff01");
        this.refreshList();
    }

    @Override
    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList ids = this.getSelectedIdValues();
        DraftLienInfoBillFactory.getRemoteInstance().submit(ids);
        MsgBox.showInfo((String)"\u63d0\u4ea4\u6210\u529f\uff01");
        this.refreshList();
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return DraftLienInfoBillFactory.getRemoteInstance();
    }

    @Override
    protected IObjectValue createNewData() {
        DraftLienInfoBillInfo objectValue = new DraftLienInfoBillInfo();
        return objectValue;
    }

    @Override
    public FMFilterBaseUI getFilterUI() throws Exception {
        if (this.filterUI == null) {
            this.filterUI = new DraftLienInfoBillFilterUI();
        }
        return this.filterUI;
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        super.tblMain_tableClicked(e);
        this.setTableFootStyle();
    }

    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        super.actionQuery_actionPerformed(e);
        this.setTableFootStyle();
    }

    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        super.actionRefresh_actionPerformed(e);
        this.setTableFootStyle();
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
        super.actionView_actionPerformed(e);
        this.setTableFootStyle();
    }

    private void setTableFootStyle() {
        if (this.tblMain.getRowCount() > 0) {
            StyleAttributes footStyle = this.tblMain.getFootManager().getFootRow(0).getCell("commercialDraft.draftAmount").getStyleAttributes();
            footStyle.setNumberFormat(numberFormat_AMT);
            footStyle.setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        }
    }

    protected void initListener() {
        super.initListener();
        this.tblMain.getDataRequestManager().addDataFillListener((KDTDataFillListener)this.fillListener);
    }

    private final class FillListener
    implements KDTDataFillListener {
        private FillListener() {
        }

        public void afterDataFill(KDTDataRequestEvent e) {
            if (e == null) {
                return;
            }
            IRow row = null;
            for (int i = e.getFirstRow(); i <= e.getLastRow(); ++i) {
                row = DraftLienInfoBill_CW_ListUI.this.tblMain.getRow(i);
                if (FMHelper.isEmpty((Object)row.getCell("pawneeAccount.bankAccountNumber").getValue())) {
                    row.getCell("pawneeAccount.bankAccountNumber").setValue((Object)"0");
                }
                if (!FMHelper.isEmpty((Object)row.getCell("commercialDraft.draftECDSStatus").getValue())) continue;
                row.getCell("commercialDraft.draftECDSStatus").setValue((Object)"\u65e0");
            }
        }
    }
}

