/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.edrafent.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.UIFocusTraversalPolicy;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.BankCollection;
import com.kingdee.eas.basedata.assistant.BankFactory;
import com.kingdee.eas.basedata.assistant.BankInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fm.be.BEBankFactory;
import com.kingdee.eas.fm.be.BEBankInfo;
import com.kingdee.eas.fm.common.FMBgItemProp;
import com.kingdee.eas.fm.common.FMCommonFacadeFactory;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.util.FMBillKDTableUtil;
import com.kingdee.eas.fm.edraf.util.EdrafUtil;
import com.kingdee.eas.fm.edrafent.CommercialDraftInfo;
import com.kingdee.eas.fm.edrafent.DraftPromptPaymentBillFactory;
import com.kingdee.eas.fm.edrafent.DraftPromptPaymentBillInfo;
import com.kingdee.eas.fm.edrafent.DraftStockBillFactory;
import com.kingdee.eas.fm.edrafent.DraftStockBillInfo;
import com.kingdee.eas.fm.edrafent.DraftStockBillOperateEnum;
import com.kingdee.eas.fm.edrafent.OperateStateEnum;
import com.kingdee.eas.fm.edrafent.client.AbstractDraftPromptPaymentBillEditUI1;
import com.kingdee.eas.fm.edrafent.util.EdrafentUtil;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.ma.budget.FpCashDirectionEnum;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.DateTimeUtils;
import java.awt.Component;
import java.awt.FocusTraversalPolicy;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import javax.swing.event.ChangeEvent;
import org.apache.log4j.Logger;

public class DraftPromptPaymentBillEditUI1
extends AbstractDraftPromptPaymentBillEditUI1 {
    private static final Logger logger = CoreUIObject.getLogger(DraftPromptPaymentBillEditUI1.class);
    private Set setBill = null;
    private Date dueDate = null;

    public DraftPromptPaymentBillEditUI1() throws Exception {
        this.setFocusTraversalPolicy((FocusTraversalPolicy)new UIFocusTraversalPolicy(new Component[]{this.pkpaymentBizDate, this.prmtholderName, this.prmtholderAccount, this.prmtholderBankNumber, this.chkisSeft, this.chkisFinance, this.prmtinAccountNumber, this.prmtinAccountBankNumber, this.txtphone, this.txtholderRamark, this.prmtBgItem}));
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.enableBaseActions();
        this.prmtCreatorOrgUnit.setEnabled(false);
        this.prmtCreator.setEnabled(false);
        this.pkCreatorDate.setEnabled(false);
        this.prmtholderName.setEnabled(false);
        this.prmtholderAccount.setEnabled(false);
        this.prmtholderBankNumber.setEnabled(false);
        this.chkisBring.setEnabled(false);
        this.txtphone.setRequired(true);
        this.txtphone.setValidCharacters("0123456789-");
        this.pkpaymentBizDate.setRequired(true);
        CompanyOrgUnitInfo compantyOrgUnitInfo = SysContext.getSysContext().getCurrentFIUnit();
        this.prmtholderName.setData((Object)compantyOrgUnitInfo);
        this.setOrgCode(compantyOrgUnitInfo.getId().toString());
        this.chkisSeft.setSelected(true);
        this.setBill = (Set)this.getUIContext().get("set");
        this.tblDraft.checkParsed();
        if (this.setBill != null) {
            this.loadDate(this.setBill);
        }
        UserInfo info = (UserInfo)SysContext.getSysContext().getCurrentUser();
        this.prmtCreatorOrgUnit.setData((Object)compantyOrgUnitInfo);
        this.prmtCreator.setData((Object)info);
        this.pkCreatorDate.setValue((Object)new Date());
        EntityViewInfo env = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)compantyOrgUnitInfo.getId().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("isClosed", (Object)Boolean.FALSE, CompareType.EQUALS));
        env.setFilter(filter);
        this.prmtinAccountNumber.setEntityViewInfo(env);
        this.prmtinAccountNumber.getQueryAgent().resetRuntimeEntityView();
        FpCashDirectionEnum[] fp = new FpCashDirectionEnum[]{FpCashDirectionEnum.output, FpCashDirectionEnum.other};
        FMClientHelper.initBgItemF7((KDBizPromptBox)this.prmtBgItem, (FpCashDirectionEnum[])fp, (boolean)true, (boolean)true);
        this.tblDraft.getStyleAttributes().setLocked(true);
        this.tblDraft.getColumn("payeeRamark").getStyleAttributes().setLocked(false);
    }

    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        this.beforeStoreFields(e);
        this.saveData(OperateStateEnum.SAVE);
        MsgBox.showInfo((String)"\u63d0\u793a\u4ed8\u6b3e\u5355\u4fdd\u5b58\u6210\u529f\uff01");
        this.actionExitCurrent_actionPerformed(null);
    }

    @Override
    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        this.beforeStoreFields(e);
        this.saveData(OperateStateEnum.SUBMIT);
        MsgBox.showInfo((String)"\u63d0\u793a\u4ed8\u6b3e\u5355\u63d0\u4ea4\u6210\u529f\uff01");
        this.actionExitCurrent_actionPerformed(null);
    }

    private void saveData(OperateStateEnum state) throws BOSException, EASBizException {
        DraftPromptPaymentBillInfo info = null;
        Iterator iterator = this.setBill.iterator();
        int i = 0;
        String batch = ("" + FMCommonFacadeFactory.getRemoteInstance().getServerDate()).substring(0, 10) + "__" + new Long(System.currentTimeMillis()).toString();
        while (iterator.hasNext()) {
            info = new DraftPromptPaymentBillInfo();
            DraftStockBillInfo stock = (DraftStockBillInfo)iterator.next();
            IRow row = this.tblDraft.getRow(i);
            info.setDraftStockBill(stock);
            if (row.getCell("payeeMoney").getValue() != null) {
                info.setPayAccount((BigDecimal)row.getCell("payeeMoney").getValue());
            }
            if (row.getCell("payeeRamark").getValue() != null) {
                info.setHolderRamark(row.getCell("payeeRamark").getValue().toString());
            } else {
                info.setHolderRamark(this.txtholderRamark.getText());
            }
            if (this.pkpaymentBizDate.getValue() != null) {
                info.setPayBizDate((Date)this.pkpaymentBizDate.getValue());
            }
            info.setHolderName((CompanyOrgUnitInfo)this.prmtholderName.getData());
            info.setHolderAccount((AccountBankInfo)this.prmtholderAccount.getData());
            info.setHolderBankNumber((BEBankInfo)this.prmtholderBankNumber.getData());
            if (this.prmtinAccountNumber.getData() != null) {
                info.setFinancAccount((AccountBankInfo)this.prmtinAccountNumber.getData());
            }
            if (this.prmtinAccountBankNumber.getData() != null) {
                info.setFinancBankNumber((BEBankInfo)this.prmtinAccountBankNumber.getData());
            }
            if (!FMHelper.isEmpty((String)this.txtphone.getText())) {
                info.setPhone(this.txtphone.getText());
            }
            FMClientHelper.storeFieldsBgItem((KDBizPromptBox)this.prmtBgItem, (CoreBaseInfo)info, (FMBgItemProp)info.getBgItemProps()[0]);
            info.setIsSeft(this.chkisSeft.isSelected());
            info.setIsFinace(this.chkisFinance.isSelected());
            info.setIsOnLine(this.chkisBring.isSelected());
            info.setIsLoginAccount(false);
            info.setOperateState(state);
            info.setCreateTime(new Timestamp(new Date().getTime()));
            info.setCreator((UserInfo)this.prmtCreator.getData());
            info.setCompany((CompanyOrgUnitInfo)this.prmtCreatorOrgUnit.getData());
            info.setOrgCode(this.txtOrgCode.getText());
            info.setBatchNumber(batch);
            IObjectPK pk = null;
            pk = state.equals((Object)OperateStateEnum.SAVE) ? DraftPromptPaymentBillFactory.getRemoteInstance().addnew((CoreBaseInfo)info) : DraftPromptPaymentBillFactory.getRemoteInstance().submit((CoreBaseInfo)info);
            String stockPK = stock.getId().toString();
            stock.setPresent(true);
            stock.setDraftStockOperate(DraftStockBillOperateEnum.PAYMENT);
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("present"));
            sic.add(new SelectorItemInfo("draftStockOperate"));
            DraftStockBillFactory.getRemoteInstance().updatePartial((CoreBaseInfo)stock, sic);
            EdrafentUtil.saveBotpRelation(null, (CoreBillBaseInfo)stock, (CoreBillBaseInfo)info, stockPK, pk.toString());
            ++i;
        }
    }

    protected void beforeStoreFields(ActionEvent e) throws Exception {
        Date bizDate;
        Date payDate;
        super.beforeStoreFields(e);
        if (this.pkpaymentBizDate.getValue() == null) {
            MsgBox.showWarning((String)"\u63d0\u793a\u4ed8\u6b3e\u7533\u8bf7\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            SysUtil.abort();
        }
        if (this.dueDate != null && this.pkpaymentBizDate.getValue() != null && (payDate = (Date)this.pkpaymentBizDate.getValue()).compareTo(bizDate = DateTimeUtils.truncateDate((Date)DateTimeUtils.addDay((Date)this.dueDate, (long)10L))) >= 0) {
            MsgBox.showWarning((String)"\u63d0\u793a\u4ed8\u6b3e\u7533\u8bf7\u65e5\u671f\u5e94\u5c0f\u4e8e\u7968\u636e\u5230\u671f\u65e5\u5929\u6570 \u52a010\uff01");
            SysUtil.abort();
        }
        if (!this.chkisBring.isSelected()) {
            if (this.prmtinAccountNumber.getData() == null) {
                MsgBox.showWarning((String)"\u8d44\u91d1\u5165\u8d26\u8d26\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                this.prmtinAccountNumber.requestFocus();
                SysUtil.abort();
            }
            if (this.prmtinAccountBankNumber.getData() == null) {
                MsgBox.showWarning((String)"\u8d44\u91d1\u5165\u8d26\u884c\u884c\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                this.prmtinAccountBankNumber.requestFocus();
                SysUtil.abort();
            }
            if (FMHelper.isEmpty((String)this.txtphone.getText())) {
                MsgBox.showWarning((String)"\u8054\u7cfb\u7535\u8bdd\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                this.txtphone.requestFocus();
                SysUtil.abort();
            }
            if (this.txtphone.getText().length() > 15) {
                MsgBox.showWarning((String)"\u8054\u7cfb\u7535\u8bdd\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e15\u4f4d\uff01");
                this.txtphone.requestFocus();
                SysUtil.abort();
            }
        }
        if (FMHelper.isEmpty((String)this.txtOrgCode.getText())) {
            MsgBox.showWarning((String)"\u5fc5\u987b\u63d0\u4f9b\u7ec4\u7ec7\u673a\u6784\u4ee3\u7801\uff0c\u8bf7\u5728\u7535\u5b50\u5546\u4e1a\u6c47\u7968\u7cfb\u7edf\u8d22\u52a1\u516c\u53f8\u7aef-\u7ec4\u7ec7\u673a\u6784\u4ee3\u7801\u4e0b\u5f55\u5165\uff01");
            this.txtOrgCode.requestFocus();
            SysUtil.abort();
        }
        if (FMHelper.isEmpty((String)this.txtholderRamark.getText())) {
            MsgBox.showWarning((String)"\u63d0\u793a\u4ed8\u6b3e\u4eba\u5907\u6ce8\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            this.txtholderRamark.requestFocus();
            SysUtil.abort();
        }
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return DraftPromptPaymentBillFactory.getRemoteInstance();
    }

    @Override
    protected IObjectValue createNewData() {
        DraftPromptPaymentBillInfo objectValue = new DraftPromptPaymentBillInfo();
        return objectValue;
    }

    private void loadDate(Set set) throws BOSException, EASBizException {
        Iterator iterator = set.iterator();
        DraftStockBillInfo stockInfo = (DraftStockBillInfo)iterator.next();
        this.prmtholderAccount.setData((Object)stockInfo.getHolderAccount());
        this.prmtholderBankNumber.setData((Object)stockInfo.getHolderBankNumber());
        for (DraftStockBillInfo stockBillInfo : set) {
            CommercialDraftInfo draftInfo = stockBillInfo.getCommercialDraft();
            IRow row = this.tblDraft.addRow();
            row.getCell("id").setValue((Object)draftInfo.getId());
            row.getCell("stockeId").setValue((Object)stockBillInfo.getId());
            row.getCell("draftNumber").setValue((Object)draftInfo.getDraftNumber());
            row.getCell("draftType").setValue((Object)draftInfo.getDraftType());
            row.getCell("draftAmount").setValue((Object)draftInfo.getDraftAmount());
            row.getCell("isIuDate").setValue((Object)draftInfo.getIssueDate());
            row.getCell("dueDate").setValue((Object)draftInfo.getDueDate());
            if (draftInfo.getDueDate() != null) {
                if (this.dueDate == null) {
                    this.dueDate = draftInfo.getDueDate();
                } else {
                    Date draftDate = draftInfo.getDueDate();
                    if (draftDate.before(this.dueDate)) {
                        this.dueDate = draftDate;
                    }
                }
            }
            row.getCell("drawerName").setValue((Object)draftInfo.getDrawerName());
            row.getCell("drawerAccount").setValue((Object)draftInfo.getDrawerAccountNumber());
            if (draftInfo.getDrawerBankNumber() != null) {
                String oql = "select * where number='" + draftInfo.getDrawerBankNumber() + "'";
                BEBankInfo beBank = BEBankFactory.getRemoteInstance().getBEBankInfo(oql);
                if (beBank != null) {
                    EntityViewInfo env = new EntityViewInfo();
                    FilterInfo filter = new FilterInfo();
                    filter.getFilterItems().add(new FilterItemInfo("accountBank", (Object)beBank.getId().toString(), CompareType.EQUALS));
                    env.setFilter(filter);
                    BankCollection bankCol = BankFactory.getRemoteInstance().getBankCollection(env);
                    BankInfo bank = null;
                    if (bankCol.size() > 0) {
                        bank = bankCol.get(0);
                    }
                    if (bank != null && bank.getName() != null) {
                        row.getCell("drawerBankNumber").setValue((Object)bank.getName());
                    }
                }
            }
            row.getCell("acceptorName").setValue((Object)draftInfo.getAcceptorName());
            row.getCell("acceptorAccount").setValue((Object)draftInfo.getAcceptorAccountNumber());
            row.getCell("acceptorBankNumber").setValue((Object)draftInfo.getAcceptorBankNumber());
            row.getCell("payeeRamark").setEditor(FMBillKDTableUtil.getTextCellEditor((int)255));
            row.getCell("payeeMoney").setValue((Object)draftInfo.getDraftAmount());
        }
    }

    protected void setTableToSumField() {
        super.setTableToSumField(this.tblDraft, new String[]{"draftAmount@###,##0.00", "payeeMoney@###,##0.00"});
    }

    protected IObjectValue createNewDetailData(KDTable table) {
        return null;
    }

    @Override
    protected void prmtinAccountNumber_dataChanged(DataChangeEvent e) throws Exception {
        if (this.prmtinAccountNumber.getData() != null && this.prmtinAccountNumber.getData() instanceof AccountBankInfo) {
            AccountBankInfo accountBank = (AccountBankInfo)this.prmtinAccountNumber.getData();
            String id = accountBank.getBank().getId().toString();
            BankInfo bank = BankFactory.getRemoteInstance().getBankInfo((IObjectPK)new ObjectUuidPK(id));
            if (bank.getAccountBank() != null) {
                String beId = bank.getAccountBank().getId().toString();
                BEBankInfo bbank = BEBankFactory.getRemoteInstance().getBEBankInfo((IObjectPK)new ObjectUuidPK(beId));
                this.prmtinAccountBankNumber.setData((Object)bbank);
            }
            if (this.prmtinAccountBankNumber.getData() != null && !FMHelper.isEmpty((String)this.txtphone.getText())) {
                BEBankInfo bbank = (BEBankInfo)this.prmtinAccountBankNumber.getData();
                String remark = "#" + bbank.getNumber() + "@" + accountBank.getBankAccountNumber() + "#\u7535\u8bdd      " + this.txtphone.getText();
                if (remark != null && remark.length() > 0) {
                    this.txtholderRamark.setText(remark);
                    this.txtholderRamark.requestFocus();
                }
            }
        }
    }

    @Override
    protected void prmtinAccountBankNumber_dataChanged(DataChangeEvent e) throws Exception {
        if (this.prmtinAccountNumber.getData() != null && this.prmtinAccountBankNumber.getData() != null && !FMHelper.isEmpty((String)this.txtphone.getText())) {
            BEBankInfo bbank = (BEBankInfo)this.prmtinAccountBankNumber.getData();
            AccountBankInfo accountBank = (AccountBankInfo)this.prmtinAccountNumber.getData();
            String remark = "#" + bbank.getNumber() + "@" + accountBank.getBankAccountNumber() + "#\u7535\u8bdd   " + this.txtphone.getText();
            if (remark != null && remark.length() > 0) {
                this.txtholderRamark.setText(remark);
                this.txtholderRamark.requestFocus();
            }
        }
    }

    @Override
    protected void txtphone_focusLost(FocusEvent e) throws Exception {
        if (this.prmtinAccountNumber.getData() != null && this.prmtinAccountBankNumber.getData() != null && !FMHelper.isEmpty((String)this.txtphone.getText())) {
            BEBankInfo bbank = (BEBankInfo)this.prmtinAccountBankNumber.getData();
            AccountBankInfo accountBank = (AccountBankInfo)this.prmtinAccountNumber.getData();
            String remark = "#" + bbank.getNumber() + "@" + accountBank.getBankAccountNumber() + "#\u7535\u8bdd    " + this.txtphone.getText();
            if (remark != null && remark.length() > 0) {
                this.txtholderRamark.setText(remark);
                this.txtholderRamark.requestFocus();
            }
        }
    }

    @Override
    protected void chkisFinance_stateChanged(ChangeEvent e) throws Exception {
        if (this.chkisFinance.isSelected()) {
            this.chkisSeft.setSelected(false);
        }
    }

    @Override
    protected void chkisSeft_stateChanged(ChangeEvent e) throws Exception {
        if (this.chkisSeft.isSelected()) {
            this.chkisFinance.setSelected(false);
        }
    }

    protected KDTable getDetailTable() {
        return null;
    }

    protected void enableBaseActions() {
        HashMap actionMap = this.getActionManager().getActionSet();
        actionMap.remove(new String("actionSave"));
        actionMap.remove(new String("actionSubmit"));
        ItemAction[] itemAction = new ItemAction[actionMap.size()];
        Iterator itor = actionMap.keySet().iterator();
        int i = 0;
        while (itor.hasNext()) {
            ItemAction action;
            itemAction[i] = action = this.getActionManager().getAction(itor.next().toString());
            ++i;
        }
        FMClientHelper.setActionVisible((ItemAction[])itemAction, (boolean)false);
    }

    private void setOrgCode(String compayId) throws BOSException {
        String orgCod = EdrafUtil.getOrgCodeByCompany(null, (String)compayId);
        if (orgCod != null && orgCod.length() > 0) {
            this.txtOrgCode.setText(orgCod);
        }
    }

    @Override
    protected void txtholderRamark_focusLost(FocusEvent e) throws Exception {
        if (this.txtholderRamark.getText() != null && !this.txtholderRamark.getText().trim().equals("")) {
            for (int i = 0; i < this.tblDraft.getRowCount(); ++i) {
                IRow row = this.tblDraft.getRow(i);
                row.getCell("payeeRamark").setValue((Object)this.txtholderRamark.getText());
            }
        }
    }
}

