/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.edrafent.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.AbstractUIFactory;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMFilterBaseUI;
import com.kingdee.eas.fm.edraf.util.EdrafUtil;
import com.kingdee.eas.fm.edrafent.DraftApplyTypeEnum;
import com.kingdee.eas.fm.edrafent.DraftRecourseBillFactory;
import com.kingdee.eas.fm.edrafent.DraftRecourseBillInfo;
import com.kingdee.eas.fm.edrafent.IDraftRecourseBill;
import com.kingdee.eas.fm.edrafent.OperateStateEnum;
import com.kingdee.eas.fm.edrafent.client.AbstractDraftRecourseBillListUI;
import com.kingdee.eas.fm.edrafent.client.DraftRecourseBillEditUI;
import com.kingdee.eas.fm.edrafent.client.DraftRecourseBillFilterUI;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class DraftRecourseBillListUI
extends AbstractDraftRecourseBillListUI {
    private static final long serialVersionUID = -7372253205472426103L;
    private static final Logger logger = CoreUIObject.getLogger(DraftRecourseBillListUI.class);
    private DraftRecourseBillFilterUI filterUI = null;
    private String type = "%r-[ ]0.2n";
    FillListener fillListener = new FillListener();

    public DraftRecourseBillListUI() throws Exception {
        CompanyOrgUnitInfo companyOrgUnitInfo = SysContext.getSysContext().getCurrentFIUnit();
        if (companyOrgUnitInfo != null && companyOrgUnitInfo.getId() != null) {
            IParamControl ipc = ParamControlFactory.getRemoteInstance();
            String result = ipc.getParamValue((IObjectPK)new ObjectStringPK(companyOrgUnitInfo.getId().toString()), "CS001");
            if ("0".equals(result)) {
                this.actionRegisterAccount.setEnabled(true);
                this.actionUnRegisterAccount.setEnabled(true);
            } else {
                this.actionRegisterAccount.setVisible(false);
                this.actionUnRegisterAccount.setVisible(false);
            }
        }
    }

    @Override
    public void onLoad() throws Exception {
        super.onLoad();
        if (!this.validateCompany()) {
            this.tblMain.getColumn("company.name").getStyleAttributes().setHided(true);
        }
        this.initListener();
    }

    public IUIObject getInstance(Map uiContext) {
        DraftRecourseBillInfo billInfo = null;
        if (uiContext.get("BOTPViewStatus") != null) {
            billInfo = (DraftRecourseBillInfo)uiContext.get("InitDataObject");
        } else {
            if (uiContext.get("ID") == null) {
                return super.getInstance(uiContext);
            }
            String id = null;
            id = uiContext.get("ID") instanceof BOSUuid ? ((BOSUuid)uiContext.get("ID")).toString() : (uiContext.get("ID") instanceof String ? (String)uiContext.get("ID") : uiContext.get("ID").toString());
            ObjectUuidPK pk = new ObjectUuidPK(id);
            try {
                billInfo = ((IDraftRecourseBill)this.getBizInterface()).getDraftRecourseBillInfo((IObjectPK)pk);
            }
            catch (Exception e) {
                this.handUIException(e);
            }
        }
        if (billInfo == null) {
            return super.getInstance(uiContext);
        }
        CompanyOrgUnitInfo orgUnitInfo = billInfo.getCompany();
        if (orgUnitInfo != null) {
            try {
                if (EdrafUtil.checkIsFinanceCompany(null, (String)orgUnitInfo.getId().toString())) {
                    return AbstractUIFactory.createUIObjectNoInit((String)com.kingdee.eas.fm.edraf.client.DraftRecourseBillListUI.class.getName());
                }
                if (!EdrafUtil.checkIsFinanceCompany(null, (String)orgUnitInfo.getId().toString())) {
                    return AbstractUIFactory.createUIObjectNoInit((String)DraftRecourseBillListUI.class.getName());
                }
                return super.getInstance(uiContext);
            }
            catch (UIException e) {
                this.handUIException(e);
            }
            catch (BOSException e) {
                this.handUIException(e);
            }
        }
        return super.getInstance(uiContext);
    }

    protected void initDapButtons() throws Exception {
        super.initDapButtons();
        if (this.validateCompany()) {
            this.actionVoucher.setVisible(false);
            this.actionDelVoucher.setVisible(false);
        } else {
            this.actionVoucher.setVisible(true);
            this.actionVoucher.setEnabled(true);
            this.actionDelVoucher.setVisible(true);
            this.actionDelVoucher.setEnabled(true);
        }
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.actionAddNew.setVisible(false);
        this.actionCopyTo.setVisible(false);
        this.actionCreateTo.setVisible(false);
        this.actionFinanceCompany.setEnabled(true);
        this.actionBankCorporate.setEnabled(false);
        this.actionAudit.setEnabled(true);
        this.ActionUnAudit.setEnabled(true);
        this.btnUnAudit.setEnabled(true);
        this.ActionSubmit.setEnabled(true);
        this.actionDraftCancel.setEnabled(true);
        this.actionBatchPrint.setEnabled(true);
        this.actionBatchPrintPreview.setEnabled(true);
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        super.tblMain_tableClicked(e);
    }

    protected void tblMain_tableSelectChanged(KDTSelectEvent e) throws Exception {
        super.tblMain_tableSelectChanged(e);
        String billID = this.getSelectedKeyValue();
        if (billID == null) {
            return;
        }
        ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)billID));
        SelectorItemCollection sc = new SelectorItemCollection();
        sc.add(new SelectorItemInfo("*"));
        sc.add(new SelectorItemInfo("commercialDraft.*"));
        CoreBaseInfo o = this.getBizInterface().getValue((IObjectPK)pk, sc);
        DraftRecourseBillInfo draftRecourseBillInfo = (DraftRecourseBillInfo)o;
        if (draftRecourseBillInfo == null) {
            return;
        }
        this.actionVoucher.setEnabled(!draftRecourseBillInfo.isFiVouchered());
        this.actionDelVoucher.setEnabled(draftRecourseBillInfo.isFiVouchered());
        if (draftRecourseBillInfo.getOperateState().equals((Object)OperateStateEnum.SAVE) || draftRecourseBillInfo.getOperateState().equals((Object)OperateStateEnum.SUBMIT)) {
            this.actionEdit.setEnabled(true);
            this.actionRemove.setEnabled(true);
        } else {
            this.actionEdit.setEnabled(false);
            this.actionRemove.setEnabled(false);
        }
    }

    @Override
    public void actionFinanceCompany_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        super.actionFinanceCompany_actionPerformed(e);
        ArrayList billID = this.getSelectedIdValues();
        if (billID == null) {
            return;
        }
        if (billID.size() == 1) {
            String id = this.getSelectedKeyValue();
            DraftRecourseBillInfo billInfo = (DraftRecourseBillInfo)this.getBizInterface().getValue((IObjectPK)new ObjectUuidPK(id));
            if (!billInfo.getOperateState().equals((Object)OperateStateEnum.AUDIT)) {
                MsgBox.showWarning((String)"\u5df2\u5ba1\u6279\u7684\u8bb0\u5f55\u624d\u5141\u8bb8\u63d0\u4ea4\u8d22\u52a1\u516c\u53f8\uff01");
                SysUtil.abort();
            }
            if (billInfo.getOperateState().equals((Object)OperateStateEnum.SUBMITGATEWAY)) {
                MsgBox.showWarning((String)"\u5df2\u7ecf\u63d0\u4ea4\u8fc7\u7684\u4e0d\u80fd\u518d\u6b21\u63d0\u4ea4\u8d22\u52a1\u516c\u53f8\uff01");
                SysUtil.abort();
            }
        }
        DraftRecourseBillFactory.getRemoteInstance().financeCompany(FMHelper.list2Set((List)billID));
        this.refreshList();
        FMClientHelper.showSubmitMsg((CoreUI)this, (String)"\u63d0\u4ea4\u8d22\u52a1\u516c\u53f8\u6210\u529f\uff01");
    }

    @Override
    public void actionBankCorporate_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList billID = this.getSelectedIdValues();
        if (billID == null) {
            return;
        }
        DraftRecourseBillFactory.getRemoteInstance().bankCorporate(FMHelper.list2Set((List)billID));
        this.refreshList();
    }

    @Override
    protected void enableBaseActions() {
        super.enableBaseActions();
        if (!this.validateCompany()) {
            this.actionVoucher.setVisible(true);
            this.actionDelVoucher.setVisible(true);
            this.actionDelVoucher.setEnabled(true);
            this.actionVoucher.setEnabled(true);
            this.actionWorkFlowG.setVisible(true);
        }
    }

    @Override
    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList billID = this.getSelectedIdValues();
        if (billID == null) {
            return;
        }
        if (billID.size() == 1) {
            String id = this.getSelectedKeyValue();
            DraftRecourseBillInfo billInfo = (DraftRecourseBillInfo)this.getBizInterface().getValue((IObjectPK)new ObjectUuidPK(id));
            if (!billInfo.getOperateState().equals((Object)OperateStateEnum.SAVE)) {
                MsgBox.showWarning((String)"\u4fdd\u5b58\u7684\u8bb0\u5f55\u624d\u5141\u8bb8\u63d0\u4ea4\uff01");
                SysUtil.abort();
            }
            if (billInfo.getOperateState().equals((Object)OperateStateEnum.SUBMIT)) {
                MsgBox.showWarning((String)"\u5df2\u7ecf\u63d0\u4ea4\u8fc7\u7684\u8bb0\u5f55\u4e0d\u80fd\u518d\u6b21\u63d0\u4ea4\uff01");
                SysUtil.abort();
            }
        }
        DraftRecourseBillFactory.getRemoteInstance().submit(FMHelper.list2Set((List)billID));
        MsgBox.showInfo((String)"\u63d0\u4ea4\u6210\u529f\uff01");
        this.refreshList();
    }

    @Override
    public void actionAudit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList billID = this.getSelectedIdValues();
        if (billID == null) {
            return;
        }
        this.checkBillsHasWF(billID);
        boolean hasWfInstance = FMHelper.hasWFInstance(null, (String)((String)billID.get(0)));
        if (hasWfInstance) {
            this.actionMultiapprove_actionPerformed(e);
        } else {
            DraftRecourseBillFactory.getRemoteInstance().audit(FMHelper.list2Set((List)billID));
            MsgBox.showInfo((String)"\u5ba1\u6279\u6210\u529f\uff01");
        }
        this.refreshList();
    }

    @Override
    public void actionUnAudit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList billID = this.getSelectedIdValues();
        if (billID == null) {
            return;
        }
        DraftRecourseBillFactory.getRemoteInstance().unAudit(FMHelper.list2Set((List)billID));
        MsgBox.showInfo((String)"\u53cd\u5ba1\u6279\u6210\u529f\uff01");
        this.refreshList();
    }

    @Override
    public String[] getMergeColumnKeys() {
        return new String[0];
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return DraftRecourseBillFactory.getRemoteInstance();
    }

    protected String getKeyFieldName() {
        return "id";
    }

    @Override
    public FMFilterBaseUI getFilterUI() throws Exception {
        if (this.tblMain.getColumn("company.name") != null) {
            if (this.validateCompany()) {
                this.tblMain.getColumn("company.name").getStyleAttributes().setHided(false);
            } else {
                this.tblMain.getColumn("company.name").getStyleAttributes().setHided(true);
            }
        }
        if (this.filterUI == null) {
            this.filterUI = new DraftRecourseBillFilterUI();
        }
        return this.filterUI;
    }

    @Override
    protected boolean isFootVisible() {
        return true;
    }

    @Override
    protected IObjectValue createNewData() {
        DraftRecourseBillInfo objectValue = new DraftRecourseBillInfo();
        return objectValue;
    }

    @Override
    public void actionDraftCancel_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList billID = this.getSelectedIdValues();
        if (billID == null || billID.size() > 1) {
            return;
        }
        DraftRecourseBillFactory.getRemoteInstance().cancelApply(this.getSelectedKeyValue(), DraftApplyTypeEnum.ZHUISUO);
        MsgBox.showInfo((Component)((Object)this), (String)"\u64a4\u9500\u6210\u529f");
        this.refreshList();
    }

    @Override
    protected IMetaDataPK getTDQueryPK() {
        return new MetaDataPK("com.kingdee.eas.fm.edrafent.app.DraftRecourseBillTDQuery");
    }

    @Override
    protected String getTDFileName() {
        return "/FM/EDRAFENT/DraftRecourseBill";
    }

    @Override
    protected String getMainTDName() {
        return "DraftRecourseBillTDQuery";
    }

    @Override
    public void actionRegisterAccount_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList billID = this.getSelectedIdValues();
        DraftRecourseBillFactory.getRemoteInstance().registerAccount(FMHelper.list2Set((List)billID));
        MsgBox.showInfo((String)"\u767b\u8d26\u6210\u529f\uff01");
        this.refreshList();
    }

    @Override
    public void actionUnRegisterAccount_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList billID = this.getSelectedIdValues();
        DraftRecourseBillFactory.getRemoteInstance().unRegisterAccount(FMHelper.list2Set((List)billID));
        MsgBox.showInfo((String)"\u53cd\u767b\u8d26\u6210\u529f\uff01");
        this.refreshList();
    }

    protected void initListener() {
        super.initListener();
        this.tblMain.getDataRequestManager().addDataFillListener((KDTDataFillListener)this.fillListener);
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String id = this.getSelectedKeyValue();
        UIContext ctx = new UIContext((Object)this);
        ctx.put((Object)"ID", (Object)id);
        int state = this.getBOTPViewStatus();
        ctx.put((Object)"isBotp", (Object)new Integer(state));
        this.prepareUIContext(ctx, e);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewTabFactory").create(DraftRecourseBillEditUI.class.getName(), (Map)ctx, null, OprtState.VIEW);
        uiWindow.show();
    }

    private final class FillListener
    implements KDTDataFillListener {
        private FillListener() {
        }

        public void afterDataFill(KDTDataRequestEvent e) {
            if (e == null) {
                return;
            }
            StyleAttributes styleAttributes = DraftRecourseBillListUI.this.tblMain.getColumn("commercialDraft.draftAmount").getStyleAttributes();
            styleAttributes.setNumberFormat(DraftRecourseBillListUI.this.type);
            styleAttributes.setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
            styleAttributes = DraftRecourseBillListUI.this.tblMain.getColumn("recourseAmt").getStyleAttributes();
            styleAttributes.setNumberFormat(DraftRecourseBillListUI.this.type);
            styleAttributes.setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
            if (DraftRecourseBillListUI.this.tblMain.getFootManager() != null && DraftRecourseBillListUI.this.tblMain.getFootManager().getFootRow(0) != null) {
                StyleAttributes footStyle = DraftRecourseBillListUI.this.tblMain.getFootManager().getFootRow(0).getCell("commercialDraft.draftAmount").getStyleAttributes();
                footStyle.setNumberFormat(DraftRecourseBillListUI.this.type);
                footStyle.setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
                footStyle = DraftRecourseBillListUI.this.tblMain.getFootManager().getFootRow(0).getCell("recourseAmt").getStyleAttributes();
                footStyle.setNumberFormat(DraftRecourseBillListUI.this.type);
                footStyle.setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
            }
        }
    }
}

