/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.edrafent.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.ExtendParser;
import com.kingdee.bos.ctrl.extendcontrols.IParser;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.BasicFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.CommitEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.ctrl.swing.event.PreChangeEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.UIFocusTraversalPolicy;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.BankCollection;
import com.kingdee.eas.basedata.assistant.BankFactory;
import com.kingdee.eas.basedata.assistant.BankInfo;
import com.kingdee.eas.basedata.master.cssp.SupplierCompanyBankInfo;
import com.kingdee.eas.basedata.master.cssp.SupplierCompanyInfoInfo;
import com.kingdee.eas.basedata.master.cssp.SupplierFactory;
import com.kingdee.eas.basedata.master.cssp.SupplierInfo;
import com.kingdee.eas.basedata.master.util.StringUtil;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.client.f7.NewCompanyF7;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fm.be.BEBankFactory;
import com.kingdee.eas.fm.be.BEBankInfo;
import com.kingdee.eas.fm.common.CSBankInfo;
import com.kingdee.eas.fm.common.ContextHelperFactory;
import com.kingdee.eas.fm.common.FMBgItemProp;
import com.kingdee.eas.fm.common.FMConstants;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.client.F7SelectorFactory;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMClientVerifyHelper;
import com.kingdee.eas.fm.ecore.BanEndorsementMarkEnum;
import com.kingdee.eas.fm.edrafent.CommercialDraftInfo;
import com.kingdee.eas.fm.edrafent.DrafTypeEnum;
import com.kingdee.eas.fm.edrafent.DraftApplyTypeEnum;
import com.kingdee.eas.fm.edrafent.DraftRegisterBillFactory;
import com.kingdee.eas.fm.edrafent.DraftRegisterBillInfo;
import com.kingdee.eas.fm.edrafent.FCOperateStateEnum;
import com.kingdee.eas.fm.edrafent.IDraftRegisterBill;
import com.kingdee.eas.fm.edrafent.OperateStateEnum;
import com.kingdee.eas.fm.edrafent.client.AbstractDraftRegisterBillEditUI;
import com.kingdee.eas.fm.edrafent.util.EdrafentUtil;
import com.kingdee.eas.fm.fin.ShareTypeEnum;
import com.kingdee.eas.fm.fin.util.FinHorizon;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.ma.budget.FpCashDirectionEnum;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.LocaleUtils;
import java.awt.Component;
import java.awt.FocusTraversalPolicy;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class DraftRegisterBillEditUI
extends AbstractDraftRegisterBillEditUI {
    private static final Logger logger = CoreUIObject.getLogger(DraftRegisterBillEditUI.class);
    private Map drawerMap = new HashMap();
    public boolean isCommit = false;
    private final BigDecimal rate = new BigDecimal(0.01);
    private final String typeMatch = "abcdefghijklmnopqrstuvwxyzABCDEFTGHIJKLMNOPQRSTUVWXYZ0123456789+-";

    public DraftRegisterBillEditUI() throws Exception {
        this.setFocusTraversalPolicy((FocusTraversalPolicy)new UIFocusTraversalPolicy(new Component[]{this.txtNumber, this.combDraftType, this.pkIssueDate, this.pkDueDate, this.prmtdrawerName, this.prmtdrawerAccount, this.prmtdrawerBank, this.prmtdrawerBankNumber, this.prmtpayeeName, this.prmtpayAccount, this.prmtpayeeBank, this.prmtpayeeBankNumber, this.prmtassurersName, this.prmtassurersAccount, this.prmtassurersBankNumber, this.txtassurerAddress, this.pkassurDate, this.txtdraftAmount, this.prmtaccpetorName, this.prmtaccpetorBankNumber, this.pkacceptorDate, this.prmtaccpetorAccount, this.prmtaccpetorBankName, this.txtcontractNumber, this.txtbatchNumber, this.chkisAttorn, this.txtdrawerCdtBody, this.txtDrawerCreditRate, this.pkDrawerRateDueDate, this.txtacceptorCdtBody, this.txtacceptorCreditRat, this.pkacceptorCdtDate, this.txtRemark, this.txtprocedureRate, this.txtmoneySum, this.prmtamountAccount, this.txtrecognizance, this.prmtCreditLimit, this.prmtBgItem, this.txtrecogniz}));
    }

    @Override
    public void loadFields() {
        Map listenerMap = null;
        try {
            listenerMap = FMClientHelper.removeCompListeners((CoreUI)this);
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        super.loadFields();
        FMClientHelper.loadFieldsBgItem((KDBizPromptBox)this.prmtBgItem, (CoreBaseInfo)this.editData, (FMBgItemProp)this.editData.getBgItemProps()[0]);
        CommercialDraftInfo info = this.editData.getCommercialDraft();
        if (info != null) {
            if (info.getPayeeAccountNumber() != null) {
                this.prmtpayAccount.setData((Object)info.getPayeeAccountNumber());
            }
            if (info.getPayeeBankNumber() != null) {
                this.prmtpayeeBankNumber.setData((Object)info.getPayeeBankNumber());
            }
            if (info.getAcceptorAccountNumber() != null) {
                this.prmtaccpetorAccount.setData((Object)info.getAcceptorAccountNumber());
            }
        }
        if (this.editData.getAssurersAccount() != null) {
            this.prmtassurersAccount.setData((Object)this.editData.getAssurersAccount());
        }
        if (this.editData.getAssurersBankNumber() != null) {
            this.prmtassurersBankNumber.setData((Object)this.editData.getAssurersBankNumber());
        }
        if (this.editData.getPayeeBank() != null) {
            this.prmtpayeeBank.setData((Object)this.editData.getPayeeBank());
        }
        if (this.editData.getDraftTime() != null) {
            this.txtdraftTime.setText(this.editData.getDraftTime().toString());
        }
        if (info.getDueDate() != null) {
            this.pkDueDate.setValue((Object)info.getDueDate());
        }
        if (info.getIssueDate() != null) {
            this.pkIssueDate.setValue((Object)info.getIssueDate());
        }
        try {
            this.prmtdrawerAccount_setF7Filter();
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        if (info.getDraftAmount() != null) {
            String txt = GlUtils.getChineseFormat((BigDecimal)info.getDraftAmount(), (boolean)true, (Locale)LocaleUtils.locale_L2);
            this.txtdraftAmountToUpper.setText(txt);
        }
        if (this.combDraftType.getSelectedItem().equals((Object)DrafTypeEnum.AC01)) {
            this.prmtaccpetorName.setVisible(true);
            this.txtaccpetorName.setVisible(false);
            this.prmtaccpetorAccount.setEnabled(false);
        } else {
            this.txtaccpetorName.setVisible(true);
            this.prmtaccpetorName.setVisible(false);
            this.prmtaccpetorAccount.setEnabled(true);
        }
        try {
            FMClientHelper.addCompListeners((CoreUI)this, (Map)listenerMap);
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        this.txtdraftTime.setValue((Object)this.editData.getDraftTime());
        this.txtdraftTime.setPrecision(1);
        this.initOldData((IObjectValue)this.editData);
    }

    @Override
    protected void initDataStatus() {
        super.initDataStatus();
        DraftRegisterBillInfo billInfo = (DraftRegisterBillInfo)this.getDataObject();
        this.menuItemSave.setVisible(true);
        this.actionEdit.setEnabled(false);
        this.actionRemove.setEnabled(false);
        if (billInfo.getOperateState() != null) {
            if (billInfo.getOperateState().equals((Object)OperateStateEnum.SAVE)) {
                this.actionSave.setEnabled(true);
                this.actionEdit.setEnabled(true);
                this.actionRemove.setEnabled(true);
            } else {
                this.actionSave.setEnabled(false);
            }
            if (billInfo.getOperateState().equals((Object)OperateStateEnum.SUBMIT)) {
                this.actionAudit.setEnabled(true);
                this.ActionUnAudit.setEnabled(false);
                this.actionEdit.setEnabled(true);
                this.actionRemove.setEnabled(true);
            }
            if (billInfo.getOperateState().equals((Object)OperateStateEnum.AUDIT)) {
                this.actionAudit.setEnabled(false);
                this.actionSubmit.setEnabled(false);
                this.ActionUnAudit.setEnabled(true);
            }
        }
        if ("ADDNEW".equals(this.oprtState)) {
            this.addNewStatus();
        } else if ("EDIT".equals(this.oprtState)) {
            this.editStatus();
            if (billInfo.getOperateState().equals((Object)OperateStateEnum.AUDIT)) {
                this.actionSave.setEnabled(false);
                this.actionEdit.setEnabled(false);
                this.actionRemove.setEnabled(false);
                this.lockUIForViewStatus();
            }
        } else if ("VIEW".equals(this.oprtState)) {
            this.viewStatus();
        }
        if (GlUtils.isCompanyUnion((CompanyOrgUnitInfo)this.currentCompany)) {
            this.actionAddNew.setVisible(false);
            this.actionSave.setVisible(false);
            this.actionEdit.setVisible(false);
            this.actionRemove.setVisible(false);
            this.actionAudit.setVisible(false);
            this.ActionUnAudit.setVisible(false);
            this.actionSubmit.setVisible(false);
            this.actionAuditResult.setVisible(false);
            this.actionWorkFlowG.setVisible(false);
            this.actionTraceDown.setVisible(false);
            this.actionTraceUp.setVisible(false);
            this.menuSubmitOption.setVisible(false);
        }
        if (this.getUIContext().get("company") != null) {
            this.actionAudit.setEnabled(false);
            this.ActionUnAudit.setEnabled(false);
            this.actionEdit.setEnabled(false);
            this.actionRemove.setEnabled(false);
        }
    }

    protected void hideOrShowAuditResult(boolean enabled) {
        if (GlUtils.isCompanyUnion((CompanyOrgUnitInfo)this.currentCompany)) {
            super.hideOrShowAuditResult(false);
        } else {
            super.hideOrShowAuditResult(true);
        }
    }

    protected void addNewStatus() {
        this.actionEdit.setEnabled(false);
        this.actionRemove.setEnabled(false);
        this.actionAudit.setEnabled(false);
        this.ActionUnAudit.setEnabled(false);
    }

    protected void editStatus() {
        this.actionEdit.setEnabled(false);
    }

    protected void viewStatus() {
        this.prmtaccpetorAccount.setEnabled(false);
        this.actionSave.setEnabled(false);
    }

    @Override
    protected void applyDefaultValue(IObjectValue vo) {
        vo.put("draftTime", (Object)new BigDecimal(0.0));
    }

    private void prmtdrawerAccount_setF7Filter() throws BOSException {
        CompanyOrgUnitInfo company;
        String companyId = "";
        if (this.prmtdrawerName.getValue() instanceof CompanyOrgUnitInfo && null != (company = (CompanyOrgUnitInfo)this.prmtdrawerName.getValue())) {
            companyId = company.getId().toString();
            this.setOrgCode(companyId);
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyId));
            filter.getFilterItems().add(new FilterItemInfo("isClosed", (Object)new Boolean(false)));
            filter.getFilterItems().add(new FilterItemInfo("isForEDrafOnly", (Object)new Boolean(true)));
            EntityViewInfo evi = new EntityViewInfo();
            evi.setFilter(filter);
            this.prmtdrawerAccount.setEntityViewInfo(evi);
            this.prmtdrawerAccount.getQueryAgent().resetRuntimeEntityView();
            if (this.combDraftType.getSelectedItem() != null && this.combDraftType.getSelectedItem().equals((Object)DrafTypeEnum.AC02) && this.txtaccpetorName.getData() == null) {
                this.txtaccpetorName.setData((Object)company);
            }
        }
    }

    private void setOrgCode(String compayId) throws BOSException {
        String code = EdrafentUtil.setOrgCode(null, compayId);
        if (!FMHelper.isEmpty((String)code)) {
            this.txtOrgCode.setText(code);
        }
    }

    @Override
    protected void initWorkButton() {
        super.initWorkButton();
        this.btnAddLine.setVisible(false);
        this.btnInsertLine.setVisible(false);
        this.btnRemoveLine.setVisible(false);
        this.btnCopyLine.setVisible(false);
        this.btnCopy.setVisible(false);
        this.menuTable1.setVisible(false);
        this.btnCreateTo.setVisible(false);
        this.btnAudit.setVisible(true);
        this.btnAudit.setEnabled(false);
        this.menuItemUnAudit.setEnabled(false);
        this.actionPrint.setVisible(false);
        this.actionPrintPreview.setVisible(false);
    }

    protected void initUIProp() throws Exception {
        FpCashDirectionEnum[] fp = new FpCashDirectionEnum[]{FpCashDirectionEnum.output, FpCashDirectionEnum.other};
        FMClientHelper.initBgItemF7((KDBizPromptBox)this.prmtBgItem, (FpCashDirectionEnum[])fp, (boolean)true, (boolean)true);
        super.initUIProp();
        ExtendParser parser = new ExtendParser(this.prmtpayAccount);
        this.prmtpayAccount.setCommitParser((IParser)parser);
        this.prmtpayAccount.setDisplayFormat("$bankAccount$");
        this.prmtpayAccount.setMaxLength(20);
        ExtendParser bankParser = new ExtendParser(this.prmtpayeeBank);
        this.prmtpayeeBank.setCommitParser((IParser)bankParser);
        this.prmtpayeeBank.setDisplayFormat("$name$");
        this.prmtpayeeBank.setMaxLength(80);
        ExtendParser bankParserr = new ExtendParser(this.prmtpayeeBankNumber);
        this.prmtpayeeBankNumber.setCommitParser((IParser)bankParserr);
        this.prmtpayeeBankNumber.setDisplayFormat("$number$");
        this.prmtpayeeBankNumber.setMaxLength(20);
        ExtendParser assParserr = new ExtendParser(this.prmtassurersAccount);
        this.prmtassurersAccount.setCommitParser((IParser)assParserr);
        this.prmtassurersAccount.setDisplayFormat("$bankAccount$");
        this.prmtassurersAccount.setMaxLength(20);
        ExtendParser assbankParserr = new ExtendParser(this.prmtassurersBankNumber);
        this.prmtassurersBankNumber.setCommitParser((IParser)assbankParserr);
        this.prmtassurersBankNumber.setDisplayFormat("$number$");
        this.prmtassurersBankNumber.setMaxLength(20);
        FMClientHelper.initCurrencyField((BasicFormattedTextField)this.txtdraftAmount);
        FMClientHelper.initCurrencyField((BasicFormattedTextField)this.txtprocedureRate);
        FMClientHelper.initCurrencyField((BasicFormattedTextField)this.txtrecognizance);
        FMClientHelper.initCurrencyField((BasicFormattedTextField)this.txtrecogniz);
        FMClientHelper.initCurrencyField((BasicFormattedTextField)this.txtmoneySum);
        FMClientHelper.initCurrencyField((BasicFormattedTextField)this.txtdraftTime);
        this.txtprocedureRate.setMaximumValue((Comparable)new BigDecimal(100));
        this.txtrecognizance.setMaximumValue((Comparable)new BigDecimal(100));
        this.txtdraftAmount.setMaximumValue((Comparable)new BigDecimal("1000000000"));
        this.txtdraftTime.setValue((Object)new BigDecimal("0.0"));
        this.txtdraftTime.setPrecision(1);
        this.txtdraftTime.setMinimumValue((Comparable)FMConstants.ZERO);
        this.txtDrawerCreditRate.setValidCharacters("abcdefghijklmnopqrstuvwxyzABCDEFTGHIJKLMNOPQRSTUVWXYZ0123456789+-");
        this.txtDrawerCreditRate.setDigit(true);
        this.txtDrawerCreditRate.setCharsCount(3);
        this.txtacceptorCreditRat.setValidCharacters("abcdefghijklmnopqrstuvwxyzABCDEFTGHIJKLMNOPQRSTUVWXYZ0123456789+-");
        this.txtacceptorCreditRat.setDigit(true);
        this.txtacceptorCreditRat.setCharsCount(3);
        this.txtbatchNumber.setDigit(true);
        this.txtbatchNumber.setCharsCount(10);
    }

    @Override
    public void onLoad() throws Exception {
        super.onLoad();
        this.btnAddNew.setEnabled(true);
        this.txtNumber.setRequired(true);
        this.menuItemCopy.setVisible(false);
        NewCompanyF7 selector = F7SelectorFactory.getSelectCompany((IUIObject)this, null, null, (boolean)false);
        this.prmtdrawerName.setSelector((KDPromptSelector)selector);
        this.txtaccpetorName.setSelector((KDPromptSelector)selector);
        this.txtaccpetorName.setVisible(false);
        EntityViewInfo env = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        if (this.currentCompany != null) {
            filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)this.currentCompany.getId().toString(), CompareType.EQUALS));
        }
        filter.getFilterItems().add(new FilterItemInfo("isClosed", (Object)new Boolean(false), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("bank.inGroup", (Object)new Boolean(true), CompareType.EQUALS));
        env.setFilter(filter);
        this.prmtamountAccount.setEntityViewInfo(env);
        this.prmtaccpetorAccount.setEnabled(false);
        if (this.combDraftType.getSelectedItem().equals((Object)DrafTypeEnum.AC01)) {
            this.prmtaccpetorName.setVisible(true);
            this.txtaccpetorName.setVisible(false);
            this.prmtaccpetorAccount.setEnabled(false);
        } else {
            this.txtaccpetorName.setVisible(true);
            this.prmtaccpetorName.setVisible(false);
            this.prmtaccpetorAccount.setEnabled(true);
        }
        if (this.getUIContext().get("REGISTER_INFO") != null) {
            this.initAcceptRequestUI();
        }
        this.chkisAcceptor.setEnabled(false);
        this.prmtassurersAccount.setMaxLength(32);
        this.prmtassurersBankNumber.setMaxLength(12);
        this.prmtpayAccount.setMaxLength(32);
        this.prmtpayeeBankNumber.setMaxLength(12);
        this.actionTraceDown.setVisible(false);
        this.actionTraceUp.setVisible(false);
        if (this.getUIContext().get("isBotp") != null && Integer.parseInt(this.getUIContext().get("isBotp").toString()) == 1) {
            this.actionAddNew.setEnabled(false);
        }
    }

    @Override
    public void storeFields() {
        CompanyOrgUnitInfo companyInfo;
        SupplierInfo supInfo;
        BEBankInfo beBank;
        AccountBankInfo accounBank;
        CompanyOrgUnitInfo compInfo;
        SupplierCompanyBankInfo info;
        super.storeFields();
        CommercialDraftInfo commInfo = this.editData.getCommercialDraft();
        FMClientHelper.storeFieldsBgItem((KDBizPromptBox)this.prmtBgItem, (CoreBaseInfo)this.editData, (FMBgItemProp)this.editData.getBgItemProps()[0]);
        if (this.prmtpayAccount.getData() instanceof String || this.prmtpayAccount.getText() instanceof String) {
            commInfo.setPayeeAccountNumber(this.prmtpayAccount.getText());
        }
        if (this.prmtpayAccount.getData() instanceof SupplierCompanyBankInfo && (info = (SupplierCompanyBankInfo)this.prmtpayAccount.getData()) != null && info.getBankAccount() != null) {
            commInfo.setPayeeAccountNumber(info.getBankAccount());
        }
        if (!FMHelper.isEmpty((String)this.txtdraftTime.getText())) {
            this.editData.setDraftTime(new BigDecimal(this.txtdraftTime.getText()));
        }
        if (this.pkDueDate.getValue() != null) {
            commInfo.setDueDate((Date)this.pkDueDate.getValue());
        }
        if (this.pkIssueDate.getValue() != null) {
            commInfo.setIssueDate((Date)this.pkIssueDate.getValue());
        }
        if (this.prmtpayeeBank.getData() instanceof String || this.prmtpayeeBank.getText() instanceof String) {
            this.editData.setPayeeBank(this.prmtpayeeBank.getData().toString());
        }
        if (this.prmtpayeeBank.getData() instanceof BEBankInfo) {
            info = (BEBankInfo)this.prmtpayeeBank.getData();
            this.editData.setPayeeBank(info.getName());
        }
        if (this.prmtpayeeBankNumber.getData() instanceof String || this.prmtpayeeBankNumber.getText() instanceof String) {
            commInfo.setPayeeBankNumber(this.prmtpayeeBankNumber.getData().toString());
        }
        if (this.prmtpayeeBankNumber.getData() instanceof BEBankInfo && (info = (BEBankInfo)this.prmtpayeeBankNumber.getData()) != null && info.getId() != null) {
            commInfo.setPayeeBankNumber(info.getNumber());
        }
        if (this.prmtaccpetorAccount.getData() != null && (this.prmtaccpetorAccount.getData() instanceof String || this.prmtaccpetorAccount.getText() instanceof String)) {
            commInfo.setAcceptorAccountNumber(this.prmtaccpetorAccount.getData().toString());
        }
        if (this.prmtaccpetorAccount.getData() instanceof AccountBankInfo && (info = (AccountBankInfo)this.prmtaccpetorAccount.getData()) != null && info.getId() != null) {
            commInfo.setAcceptorAccountNumber(info.getBankAccountNumber());
        }
        if (this.prmtassurersAccount.getData() != null) {
            if (this.prmtassurersAccount.getData() instanceof String || this.prmtassurersAccount.getText() instanceof String) {
                this.editData.setAssurersAccount(this.prmtassurersAccount.getData().toString());
            }
            if (this.prmtassurersAccount.getData() instanceof SupplierCompanyBankInfo && (info = (SupplierCompanyBankInfo)this.prmtassurersAccount.getData()) != null && info.getId() != null) {
                this.editData.setAssurersAccount(info.getBankAccount());
            }
        }
        if (this.prmtassurersBankNumber.getData() != null) {
            if (this.prmtassurersBankNumber.getData() instanceof String || this.prmtassurersBankNumber.getText() instanceof String) {
                this.editData.setAssurersBankNumber(this.prmtassurersBankNumber.getData().toString());
            }
            if (this.prmtassurersBankNumber.getData() instanceof BEBankInfo && (info = (BEBankInfo)this.prmtassurersBankNumber.getData()) != null && info.getId() != null) {
                this.editData.setAssurersBankNumber(info.getNumber());
            }
        }
        if (this.prmtdrawerName.getData() != null && this.prmtdrawerName.getData() instanceof CompanyOrgUnitInfo && (compInfo = (CompanyOrgUnitInfo)this.prmtdrawerName.getData()) != null && compInfo.getName() != null) {
            commInfo.setDrawerName(compInfo.getName());
        }
        if (this.prmtdrawerAccount.getData() != null && this.prmtdrawerAccount.getData() instanceof AccountBankInfo && (accounBank = (AccountBankInfo)this.prmtdrawerAccount.getData()) != null && accounBank.getBankAccountNumber() != null) {
            commInfo.setDrawerAccountNumber(accounBank.getBankAccountNumber());
        }
        if (this.prmtdrawerBankNumber.getData() != null && this.prmtdrawerBankNumber.getData() instanceof BEBankInfo && (beBank = (BEBankInfo)this.prmtdrawerBankNumber.getData()) != null && beBank.getNumber() != null) {
            commInfo.setDrawerBankNumber(beBank.getNumber());
        }
        if (this.prmtpayeeName.getData() != null && this.prmtpayeeName.getData() instanceof SupplierInfo && (supInfo = (SupplierInfo)this.prmtpayeeName.getData()) != null && supInfo.getName() != null) {
            commInfo.setPayeeName(supInfo.getName());
        }
        if (this.combDraftType.getSelectedItem().equals((Object)DrafTypeEnum.AC01)) {
            BankInfo bankInfo;
            if (this.prmtaccpetorName.getData() != null && this.prmtaccpetorName.getData() instanceof BankInfo && (bankInfo = (BankInfo)this.prmtaccpetorName.getData()) != null && bankInfo.getName() != null) {
                commInfo.setAcceptorName(bankInfo.getName());
            }
        } else if (this.txtaccpetorName.getData() != null && this.txtaccpetorName.getData() instanceof CompanyOrgUnitInfo && (companyInfo = (CompanyOrgUnitInfo)this.txtaccpetorName.getData()) != null && companyInfo.getName() != null) {
            commInfo.setAcceptorName(companyInfo.getName());
        }
        if (this.prmtaccpetorBankNumber.getData() != null && this.prmtaccpetorBankNumber.getData() instanceof BEBankInfo && (beBank = (BEBankInfo)this.prmtaccpetorBankNumber.getData()) != null && beBank.getNumber() != null) {
            commInfo.setAcceptorBankNumber(beBank.getNumber());
        }
        if (!StringUtil.isEmpty((String)this.txtRemark.getText())) {
            commInfo.setRemark(this.txtRemark.getText());
        }
        if (this.chkisAttorn.isSelected()) {
            commInfo.setBanEndorsement(BanEndorsementMarkEnum.EM00);
        } else {
            commInfo.setBanEndorsement(BanEndorsementMarkEnum.EM01);
        }
        commInfo.setIsAllowUpdate(true);
        if (!FMHelper.isEmpty((String)this.txtOrgCode.getText())) {
            commInfo.setHolderOrgCode(this.txtOrgCode.getText());
        }
        if (!FMHelper.isEmpty((String)this.txtdrawerCdtBody.getText())) {
            commInfo.setDrawerRateAgcy(this.txtdrawerCdtBody.getText());
        }
        this.editData.setCommercialDraft(commInfo);
        this.editData.setDraftTime(new BigDecimal(this.txtdraftTime.getText()));
        this.drawerMap.put("drawerName", this.prmtdrawerName.getData());
        this.drawerMap.put("drawerAccount", this.prmtdrawerAccount.getData());
        this.drawerMap.put("drawerBank", this.prmtdrawerBank.getData());
        this.drawerMap.put("drawerBankNumber", this.prmtdrawerBankNumber.getData());
    }

    public boolean useScrollPane() {
        return true;
    }

    public int getVerticalScrollPolicy() {
        return 22;
    }

    public int getHorizontalScrollPolicy() {
        return 32;
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return DraftRegisterBillFactory.getRemoteInstance();
    }

    private void initAcceptRequestUI() throws Exception {
        this.txtaccpetorName.setEnabled(false);
        this.txtNumber.setEnabled(false);
        this.combDraftType.setEnabled(false);
        this.pkassurDate.setEnabled(false);
        this.pkIssueDate.setEnabled(false);
        this.pkDueDate.setEnabled(false);
        this.txtDraftNumber.setEnabled(false);
        this.txtdraftTime.setEnabled(false);
        this.prmtdrawerName.setEnabled(false);
        this.prmtdrawerAccount.setEnabled(false);
        this.prmtdrawerBank.setEnabled(false);
        this.prmtdrawerBankNumber.setEnabled(false);
        this.prmtpayeeName.setEnabled(false);
        this.prmtpayAccount.setEnabled(false);
        this.prmtpayeeBank.setEnabled(false);
        this.prmtpayeeBankNumber.setEnabled(false);
        this.prmtassurersName.setEnabled(false);
        this.prmtassurersAccount.setEnabled(false);
        this.prmtassurersBankNumber.setEnabled(false);
        this.txtassurerAddress.setEnabled(false);
        this.txtdraftAmount.setEnabled(false);
        this.contdraftAmountToUpper.setEnabled(false);
        this.prmtaccpetorName.setEnabled(false);
        this.prmtaccpetorBankNumber.setEnabled(false);
        this.pkacceptorDate.setEnabled(false);
        this.prmtaccpetorAccount.setEnabled(false);
        this.prmtaccpetorBankName.setEnabled(false);
        this.chkisAcceptor.setEnabled(false);
        this.chkisAttorn.setEnabled(false);
        this.txtprocedureRate.setEnabled(false);
        this.txtmoneySum.setEnabled(false);
        this.prmtamountAccount.setEnabled(false);
        this.txtrecognizance.setEnabled(false);
        this.prmtCreditLimit.setEnabled(false);
        this.prmtBgItem.setEnabled(false);
        this.txtrecogniz.setEnabled(false);
        this.txtOrgCode.setEnabled(false);
        this.txtdrawerCdtBody.setEnabled(false);
        this.txtDrawerCreditRate.setEnabled(false);
        this.pkDrawerRateDueDate.setEnabled(false);
        this.txtacceptorCdtBody.setEnabled(false);
        this.txtacceptorCreditRat.setEnabled(false);
        this.pkacceptorCdtDate.setEnabled(false);
        this.btnAudit.setEnabled(false);
        this.btnRemove.setEnabled(false);
        this.btnAttachment.setEnabled(false);
        this.btnSave.setVisible(false);
        this.btnEdit.setVisible(false);
        this.btnRemove.setVisible(false);
        this.btnAttachment.setVisible(false);
        this.btnAudit.setVisible(false);
        this.btnAuditResult.setVisible(false);
        this.btnUnAudit.setVisible(false);
        this.btnFirst.setVisible(false);
        this.btnLast.setVisible(false);
        this.btnNext.setVisible(false);
        this.btnPre.setVisible(false);
        this.btnWorkFlowG.setVisible(false);
        this.txtRemark.setEnabled(true);
        this.txtcontractNumber.setEnabled(true);
        this.txtbatchNumber.setEnabled(true);
        this.setUITitle("\u63d0\u793a\u627f\u5151 - \u65b0\u589e ");
    }

    @Override
    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        if (this.getUIContext().get("REGISTER_INFO") == null) {
            super.actionSubmit_actionPerformed(e);
            if (!this.getOprtState().equals(OprtState.ADDNEW)) {
                this.btnAudit.setEnabled(true);
                this.actionAudit.setEnabled(true);
            }
        } else {
            String billId = this.getUIContext().get("REGISTER_INFO").toString();
            ArrayList<String> list = new ArrayList<String>();
            list.add(billId);
            IDraftRegisterBill iDraftRegisterBill = DraftRegisterBillFactory.getRemoteInstance();
            DraftRegisterBillInfo registerInfo = iDraftRegisterBill.getDraftRegisterBillInfo((IObjectPK)new ObjectUuidPK(billId));
            registerInfo.setReturnOpinion("");
            registerInfo.setContractNumber(this.txtcontractNumber.getText());
            registerInfo.setBatchNumber(this.txtbatchNumber.getText());
            registerInfo.setDescription(this.txtRemark.getText());
            this.actionSignature_actionPerformed(e);
            iDraftRegisterBill.update((IObjectPK)new ObjectUuidPK(billId), (CoreBaseInfo)registerInfo);
            if (iDraftRegisterBill != null) {
                iDraftRegisterBill.batchSubmitFC(FMHelper.list2Set(list), DraftApplyTypeEnum.CHENGDUI);
            }
            this.isCommit = true;
            this.actionExitCurrent_actionPerformed(null);
        }
    }

    public boolean isModify() {
        if (this.getUIContext().get("REGISTER_INFO") == null) {
            if (this.editData != null && this.editData.getId() != null) {
                if (!this.editData.getOperateState().equals((Object)OperateStateEnum.SAVE) && !this.editData.getOperateState().equals((Object)OperateStateEnum.SUBMIT)) {
                    return false;
                }
                return super.isModify();
            }
            return super.isModify();
        }
        return false;
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("creator.*"));
        sic.add(new SelectorItemInfo("company.*"));
        sic.add(new SelectorItemInfo("acceptorCompany.*"));
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("commercialDraft.dueDate"));
        return sic;
    }

    @Override
    protected IObjectValue createNewData() {
        DraftRegisterBillInfo objectValue = new DraftRegisterBillInfo();
        CompanyOrgUnitInfo compantyOrgUnitInfo = SysContext.getSysContext().getCurrentFIUnit();
        objectValue.setCompany(compantyOrgUnitInfo);
        objectValue.setCreator((UserInfo)SysContext.getSysContext().getCurrentUser());
        objectValue.setAcceptorDate(new Date());
        objectValue.setDrawerName(compantyOrgUnitInfo);
        objectValue.setDrawerName(compantyOrgUnitInfo);
        objectValue.setAssurDate(new Date());
        objectValue.setCreateTime(this.getTime());
        objectValue.setOperateState(OperateStateEnum.SAVE);
        objectValue.setMoneySum(new BigDecimal(0.0));
        objectValue.setProcedureRate(new BigDecimal(0.0));
        objectValue.setRecogniz(new BigDecimal(0.0));
        objectValue.setRecognizance(new BigDecimal(0.0));
        objectValue.setDraftTime(new BigDecimal("0.0"));
        this.txtdraftTime.setValue((Object)new BigDecimal("0.0"));
        this.txtdraftTime.setPrecision(1);
        objectValue.setCommercialDraft((CommercialDraftInfo)this.createNewDetailData(null));
        objectValue.setFinanceOperateState(FCOperateStateEnum.init_Value);
        objectValue.setIsAttorn(true);
        objectValue.setIsAcceptor(true);
        try {
            objectValue.setCurrency(EdrafentUtil.getRMBCurrency(null));
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        if (this.drawerMap != null) {
            if (this.drawerMap.get("drawerName") != null) {
                objectValue.setDrawerName((CompanyOrgUnitInfo)this.drawerMap.get("drawerName"));
                objectValue.setAcceptorCompany((CompanyOrgUnitInfo)this.drawerMap.get("drawerName"));
            }
            if (this.drawerMap.get("drawerAccount") != null) {
                objectValue.setDrawerAccount((AccountBankInfo)this.drawerMap.get("drawerAccount"));
                this.prmtaccpetorAccount.setData((Object)((AccountBankInfo)this.drawerMap.get("drawerAccount")));
            }
            if (this.drawerMap.get("drawerBank") != null) {
                objectValue.setDrawerBank((BankInfo)this.drawerMap.get("drawerBank"));
                objectValue.setAccpetorBankName((BankInfo)this.drawerMap.get("drawerBank"));
                objectValue.setAccpetorBank((BankInfo)this.drawerMap.get("drawerBank"));
            }
            if (this.drawerMap.get("drawerBankNumber") != null) {
                objectValue.setDrawerBankNumber((BEBankInfo)this.drawerMap.get("drawerBankNumber"));
                objectValue.setAccpetorBankNumber((BEBankInfo)this.drawerMap.get("drawerBankNumber"));
            }
        }
        return objectValue;
    }

    protected IObjectValue createNewDetailData(KDTable table) {
        CommercialDraftInfo info = new CommercialDraftInfo();
        info.setIssueDate(new Date());
        info.setDueDate(new Date());
        info.setDraftType(DrafTypeEnum.AC01);
        info.setDraftAmount(new BigDecimal(0.0));
        info.setAcceptorAccountNumber("0");
        return info;
    }

    @Override
    public void actionAudit_actionPerformed(ActionEvent e) throws Exception {
        if (this.getUIContext().get("ID") != null) {
            boolean hasWfInstance;
            String id = this.getUIContext().get("ID").toString();
            DraftRegisterBillInfo billInfo = ((IDraftRegisterBill)this.getBizInterface()).getDraftRegisterBillInfo((IObjectPK)new ObjectUuidPK(id));
            if (!billInfo.getOperateState().equals((Object)OperateStateEnum.SUBMIT)) {
                MsgBox.showWarning((String)"\u975e\u63d0\u4ea4\u72b6\u6001\u7684\u5355\u636e\u4e0d\u5141\u8bb8\u5ba1\u6279\uff01");
                SysUtil.abort();
            }
            if (hasWfInstance = FMHelper.hasWFInstance(null, (String)id)) {
                this.actionMultiapprove_actionPerformed(e);
                Thread.sleep(500L);
            } else {
                HashSet<String> set = new HashSet<String>();
                set.add(id);
                ((IDraftRegisterBill)this.getBizInterface()).audit(set);
                MsgBox.showInfo((String)"\u5ba1\u6279\u6210\u529f\uff01");
            }
            if (this.getOprtState().equals(OprtState.EDIT)) {
                this.storeFields();
                this.initOldData((IObjectValue)this.editData);
            }
            this.setDataObject(this.getValue((IObjectPK)new ObjectUuidPK(id)));
            this.loadFields();
        }
    }

    @Override
    public void actionUnAudit_actionPerformed(ActionEvent e) throws Exception {
        if (this.getUIContext().get("ID") != null) {
            String id = this.getUIContext().get("ID").toString();
            DraftRegisterBillInfo billInfo = ((IDraftRegisterBill)this.getBizInterface()).getDraftRegisterBillInfo((IObjectPK)new ObjectUuidPK(id));
            if (!billInfo.getOperateState().equals((Object)OperateStateEnum.AUDIT)) {
                MsgBox.showWarning((String)"\u975e\u5ba1\u6279\u72b6\u6001\u7684\u5355\u636e\u4e0d\u5141\u8bb8\u53cd\u5ba1\u6279\uff01");
                SysUtil.abort();
            }
            HashSet<String> set = new HashSet<String>();
            set.add(id);
            ((IDraftRegisterBill)this.getBizInterface()).unAudit(set);
            MsgBox.showInfo((String)"\u53cd\u5ba1\u6279\u6210\u529f\uff01");
            if ("EDIT".equals(this.oprtState)) {
                this.unLockUI();
            }
            this.ActionUnAudit.setEnabled(false);
            this.setDataObject(this.getValue((IObjectPK)new ObjectUuidPK(this.editData.getId())));
            this.loadFields();
            this.setSave(true);
            this.setSaved(true);
        }
    }

    @Override
    protected void txtdraftAmount_dataChanged(DataChangeEvent e) throws Exception {
        BigDecimal amount = this.txtdraftAmount.getBigDecimalValue();
        if (amount == null) {
            amount = FMConstants.ZERO;
            this.txtdraftAmount.setValue((Object)FMConstants.ZERO);
            this.txtmoneySum.setValue((Object)FMConstants.ZERO);
            this.txtrecogniz.setValue((Object)FMConstants.ZERO);
        } else {
            String txt = GlUtils.getChineseFormat((BigDecimal)amount, (boolean)true, (Locale)LocaleUtils.locale_L2);
            this.txtdraftAmountToUpper.setText(txt);
            if (amount.compareTo(FMConstants.ZERO) > 0) {
                BigDecimal procedureRate = this.txtprocedureRate.getBigDecimalValue();
                BigDecimal recognizance = this.txtrecognizance.getBigDecimalValue();
                if (procedureRate != null) {
                    BigDecimal moneySum = amount.multiply(procedureRate.multiply(this.rate));
                    this.txtmoneySum.setValue((Object)moneySum);
                }
                if (recognizance != null) {
                    BigDecimal rateMoney = amount.multiply(recognizance.multiply(this.rate));
                    this.txtrecogniz.setValue((Object)rateMoney);
                }
            }
        }
    }

    protected void beforeStoreFields(ActionEvent e) throws Exception {
        String assBankNumber;
        String assAccount;
        String payBankNumber;
        String payAccount;
        super.beforeStoreFields(e);
        if (this.combDraftType.getSelectedIndex() < 0) {
            MsgBox.showWarning((String)"\u7968\u636e\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            this.combDraftType.requestFocus();
            SysUtil.abort();
        }
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDDatePicker)this.pkIssueDate);
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDDatePicker)this.pkDueDate);
        Date startDate = (Date)this.pkIssueDate.getValue();
        Date endDate = (Date)this.pkDueDate.getValue();
        if (endDate.before(startDate) || startDate.compareTo(endDate) == 0) {
            MsgBox.showWarning((String)"\u6c47\u7968\u5230\u671f\u65e5\u5e94\u8be5\u5927\u4e8e\u51fa\u7968\u65e5\u671f\uff01");
            this.pkDueDate.requestFocus();
            SysUtil.abort();
        }
        if (this.prmtdrawerName.getData() == null || this.prmtdrawerAccount.getData() == null || this.prmtdrawerBank.getData() == null || this.prmtdrawerBankNumber.getData() == null) {
            MsgBox.showWarning((String)"\u51fa\u7968\u4eba\u4fe1\u606f\u90fd\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            this.prmtdrawerName.requestFocus();
            SysUtil.abort();
        }
        if (this.prmtpayeeName.getData() == null || this.prmtpayAccount.getData() == null && this.prmtpayAccount.getText().length() == 0 || this.prmtpayeeBank.getData() == null && this.prmtpayeeBank.getText().length() == 0 || this.prmtpayeeBankNumber.getData() == null && this.prmtpayeeBankNumber.getText().length() == 0) {
            MsgBox.showWarning((String)"\u6536\u6b3e\u4eba\u4fe1\u606f\u90fd\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            this.prmtpayeeName.requestFocus();
            SysUtil.abort();
        }
        if (this.txtdraftAmount.getText().toString() == null || this.txtdraftAmount.getBigDecimalValue().compareTo(FMConstants.ZERO) <= 0) {
            MsgBox.showWarning((String)"\u7968\u636e\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a\u6216\u7b49\u4e8e\u5c0f\u4e8e0\uff01");
            this.txtdraftAmount.requestFocus();
            SysUtil.abort();
        }
        if (this.combDraftType.getSelectedItem().equals((Object)DrafTypeEnum.AC01)) {
            if (this.prmtaccpetorName.getData() == null || this.prmtaccpetorBankNumber.getData() == null || this.prmtaccpetorBankName.getData() == null) {
                MsgBox.showWarning((String)"\u627f\u5151\u4eba\u5168\u79f0\uff0c\u5f00\u6237\u884c\u884c\u53f7\uff0c\u8d26\u53f7\uff0c\u5f00\u6237\u884c\u540d\u79f0\u90fd\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                this.prmtaccpetorName.requestFocus();
                SysUtil.abort();
            }
        } else if (this.txtaccpetorName.getData() == null || this.prmtaccpetorAccount.getData() == null && this.prmtaccpetorAccount.getText() == null || this.prmtaccpetorBankNumber.getData() == null || this.prmtaccpetorBankName.getData() == null) {
            MsgBox.showWarning((String)"\u627f\u5151\u4eba\u5168\u79f0\uff0c\u5f00\u6237\u884c\u884c\u53f7\uff0c\u8d26\u53f7\uff0c\u5f00\u6237\u884c\u540d\u79f0\u90fd\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            this.prmtaccpetorName.requestFocus();
            SysUtil.abort();
        }
        if (FMHelper.isEmpty((String)this.txtOrgCode.getText())) {
            MsgBox.showWarning((String)"\u5fc5\u987b\u63d0\u4f9b\u7ec4\u7ec7\u673a\u6784\u4ee3\u7801\uff0c\u8bf7\u5728\u7535\u5b50\u5546\u4e1a\u6c47\u7968\u7cfb\u7edf\u8d22\u52a1\u516c\u53f8\u7aef-\u7ec4\u7ec7\u673a\u6784\u4ee3\u7801\u4e0b\u5f55\u5165\uff01");
            SysUtil.abort();
        }
        if (this.txtdraftTime.getBigDecimalValue().compareTo(new BigDecimal("12")) > 0 && MsgBox.showConfirm2New((Component)((Object)this), (String)"\u7968\u636e\u671f\u9650\u8d85\u8fc712\u4e2a\u6708\uff0c\u662f\u5426\u4fdd\u5b58\uff1f") == 1) {
            this.abort();
        }
        AccountBankInfo accountInfo = (AccountBankInfo)this.prmtdrawerAccount.getData();
        BEBankInfo beBankInfo = (BEBankInfo)this.prmtdrawerBankNumber.getData();
        String payeeAccount = null;
        String payeeBEBank = null;
        if (this.prmtpayAccount.getData() instanceof SupplierCompanyBankInfo) {
            SupplierCompanyBankInfo supplierInfo = (SupplierCompanyBankInfo)this.prmtpayAccount.getData();
            if (supplierInfo.getBankAccount() != null) {
                payeeAccount = supplierInfo.getBankAccount();
            }
        } else {
            payeeAccount = this.prmtpayAccount.getText();
        }
        if (this.prmtpayeeBankNumber.getData() instanceof BEBankInfo) {
            BEBankInfo info = (BEBankInfo)this.prmtpayeeBankNumber.getData();
            if (info.getNumber() != null) {
                payeeBEBank = info.getNumber();
            }
        } else {
            payeeBEBank = this.prmtpayeeBankNumber.getText();
        }
        if (!FMHelper.isEmpty((String)payeeAccount) && !FMHelper.isEmpty((String)payeeBEBank) && payeeAccount.equals(accountInfo.getBankAccountNumber()) && payeeBEBank.equals(beBankInfo.getNumber())) {
            MsgBox.showWarning((String)"\u51fa\u7968\u4eba\u8d26\u53f7\u3001\u5f00\u6237\u884c\u884c\u53f7\u4e0d\u80fd\u4e0e\u6536\u6b3e\u4eba\u8d26\u53f7\u3001\u5f00\u6237\u884c\u884c\u53f7\u76f8\u540c\uff01");
            SysUtil.abort();
        }
        if (this.prmtpayAccount.getData() instanceof String && (payAccount = this.prmtpayAccount.getData().toString()).length() > 32) {
            MsgBox.showInfo((String)"\u6536\u6b3e\u4eba\u8d26\u53f7\u6700\u5927\u4e3a32\u4f4d\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\uff01");
            this.prmtpayAccount.requestFocus();
            SysUtil.abort();
        }
        if (this.prmtpayeeBankNumber.getData() instanceof String && (payBankNumber = this.prmtpayeeBankNumber.getData().toString()).length() > 12) {
            MsgBox.showInfo((String)"\u6536\u6b3e\u4eba\u5f00\u6237\u884c\u884c\u53f7\u6700\u5927\u4e3a12\u4f4d\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\uff01");
            this.prmtpayeeBankNumber.requestFocus();
            SysUtil.abort();
        }
        if (this.prmtassurersAccount.getData() instanceof String && (assAccount = this.prmtpayAccount.getData().toString()).length() > 32) {
            MsgBox.showInfo((String)"\u4fdd\u8bc1\u4eba\u8d26\u53f7\u6700\u5927\u4e3a32\u4f4d\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\uff01");
            this.prmtassurersAccount.requestFocus();
            SysUtil.abort();
        }
        if (this.prmtassurersBankNumber.getData() instanceof String && (assBankNumber = this.prmtassurersBankNumber.getData().toString()).length() > 12) {
            MsgBox.showInfo((String)"\u4fdd\u8bc1\u4eba\u5f00\u6237\u884c\u884c\u53f7\u6700\u5927\u4e3a12\u4f4d\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\uff01");
            this.prmtassurersBankNumber.requestFocus();
            SysUtil.abort();
        }
    }

    public void doFieldPermission() throws Exception {
        this.pkDueDate.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                try {
                    DraftRegisterBillEditUI.this.pkDueDate_dataChanged(e);
                }
                catch (Exception exc) {
                    DraftRegisterBillEditUI.this.handUIException(exc);
                }
            }
        });
        this.pkIssueDate.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                try {
                    DraftRegisterBillEditUI.this.pkIssueDate_dataChanged(e);
                }
                catch (Exception exc) {
                    DraftRegisterBillEditUI.this.handUIException(exc);
                }
            }
        });
        this.prmtdrawerAccount.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                try {
                    DraftRegisterBillEditUI.this.prmtdrawerAccount_dataChanged(e);
                }
                catch (Exception exc) {
                    DraftRegisterBillEditUI.this.handUIException(exc);
                }
            }
        });
    }

    @Override
    protected void prmtdrawerName_dataChanged(DataChangeEvent e) throws Exception {
        this.prmtdrawerAccount_setF7Filter();
    }

    protected void prmtdrawerAccount_dataChanged(DataChangeEvent e) throws Exception {
        AccountBankInfo accountBank;
        if (this.prmtdrawerAccount.getData() != null && this.prmtdrawerAccount.getData() instanceof AccountBankInfo && (accountBank = (AccountBankInfo)this.prmtdrawerAccount.getData()).getId() != null && accountBank.getBank() != null && accountBank.getBank().getId() != null) {
            String id = accountBank.getBank().getId().toString();
            BankInfo info = BankFactory.getRemoteInstance().getBankInfo((IObjectPK)new ObjectUuidPK(id));
            if (this.prmtdrawerBank.getData() != null) {
                BankInfo bankInfo = (BankInfo)this.prmtdrawerBank.getData();
                if (bankInfo != null && bankInfo.getId() != null && !bankInfo.getId().equals((Object)info.getId())) {
                    this.prmtdrawerBank.setData((Object)info);
                    this.prmtaccpetorBankName.setData((Object)info);
                }
            } else {
                this.prmtdrawerBank.setData((Object)info);
                this.prmtaccpetorBankName.setData((Object)info);
            }
            if (info.getAccountBank() != null && info.getAccountBank().getId() != null) {
                String ebbankId = info.getAccountBank().getId().toString();
                BEBankInfo beBank = BEBankFactory.getRemoteInstance().getBEBankInfo((IObjectPK)new ObjectUuidPK(ebbankId));
                this.prmtdrawerBankNumber.setData((Object)beBank);
                this.prmtaccpetorBankNumber.setData((Object)beBank);
            }
            if (this.combDraftType.getSelectedItem().equals((Object)DrafTypeEnum.AC01)) {
                this.prmtaccpetorAccount.setEnabled(false);
                this.prmtaccpetorAccount.setData((Object)new Integer(0));
            } else {
                this.prmtaccpetorAccount.setData((Object)accountBank);
            }
        }
    }

    @Override
    protected void prmtdrawerBank_dataChanged(DataChangeEvent e) throws Exception {
        if (this.prmtdrawerBank.getData() != null && this.prmtdrawerBank.getData() instanceof BankInfo) {
            BankInfo bank = (BankInfo)this.prmtdrawerBank.getData();
            this.prmtaccpetorBankName.setData((Object)bank);
            if (this.combDraftType.getSelectedItem().equals((Object)DrafTypeEnum.AC01)) {
                this.prmtaccpetorName.setData((Object)bank);
            }
            if (bank != null) {
                if (bank.getAccountBank() != null && bank.getAccountBank().getId() != null) {
                    String ebbankId = bank.getAccountBank().getId().toString();
                    BEBankInfo beBank = BEBankFactory.getRemoteInstance().getBEBankInfo((IObjectPK)new ObjectUuidPK(ebbankId));
                    BEBankInfo beBank1 = (BEBankInfo)this.prmtdrawerBankNumber.getData();
                    if (beBank1 == null || beBank1 != null && !beBank.getId().equals((Object)beBank1.getId())) {
                        this.prmtdrawerBankNumber.setData((Object)beBank);
                    }
                }
                this.prmtCreditLimit.setData(null);
                if (bank.getId() != null) {
                    // empty if block
                }
            }
        }
    }

    @Override
    protected void prmtdrawerBankNumber_dataChanged(DataChangeEvent e) throws Exception {
        if (this.prmtdrawerBankNumber.getData() != null && this.prmtdrawerBankNumber.getData() instanceof BEBankInfo) {
            BEBankInfo beBank = (BEBankInfo)this.prmtdrawerBankNumber.getData();
            this.prmtaccpetorBankNumber.setData((Object)beBank);
            EntityViewInfo env = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("accountBank.id", (Object)beBank.getId().toString(), CompareType.EQUALS));
            env.setFilter(filter);
            BankCollection bankCol = BankFactory.getRemoteInstance().getBankCollection(env);
            if (bankCol.size() > 0) {
                BankInfo bankInfo = bankCol.get(0);
                BankInfo bank = (BankInfo)this.prmtdrawerBank.getData();
                if (bank == null || bank != null && !bank.getId().equals((Object)bankInfo.getId())) {
                    this.prmtdrawerBank.setData((Object)bankInfo);
                }
            }
        }
    }

    @Override
    protected void prmtpayeeName_dataChanged(DataChangeEvent e) throws Exception {
        SupplierCompanyInfoInfo supplierCompany;
        SupplierInfo supplier;
        Object payee = this.prmtpayeeName.getValue();
        if (payee instanceof SupplierInfo && (supplier = (SupplierInfo)this.prmtpayeeName.getData()) != null && (supplierCompany = SupplierFactory.getRemoteInstance().getCompanyInfo((IObjectPK)new ObjectUuidPK(supplier.getId()), (IObjectPK)new ObjectUuidPK(this.currentCompany.getId()))) != null) {
            CSBankInfo bankInfo = FMHelper.getCSBankInfo(null, (Object)supplier, (String)this.currentCompany.getId().toString());
            if (!FMHelper.isEmpty((String)bankInfo.getBankAccount())) {
                this.prmtpayAccount.setData((Object)bankInfo.getBankAccount());
            }
            if (!FMHelper.isEmpty((String)bankInfo.getBank())) {
                BEBankInfo info;
                this.prmtpayeeBank.setData((Object)bankInfo.getBank());
                String bankname = bankInfo.getBank();
                String oql = "select * where name='" + bankname + "'";
                if (BEBankFactory.getRemoteInstance().exists(oql) && (info = BEBankFactory.getRemoteInstance().getBEBankInfo(oql)) != null) {
                    this.prmtpayeeBankNumber.setData((Object)info);
                }
            }
            this.prmtpayAccount.setQueryInfo("com.kingdee.eas.basedata.master.cssp.app.F7SupplierCompanyInfoBankQuery");
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("supplier.id", (Object)supplier.getId().toString(), CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("companyOrgUnit.id", (Object)this.currentCompany.getId()));
            view.setFilter(filter);
            this.prmtpayAccount.setEntityViewInfo(view);
            this.prmtpayAccount.setEditFormat("$bankAccount$");
            this.prmtpayAccount.setDisplayFormat("$bankAccount$");
            this.prmtpayAccount.getQueryAgent().resetRuntimeEntityView();
        }
    }

    @Override
    protected void prmtpayAccount_dataChanged(DataChangeEvent e) throws Exception {
        SupplierCompanyBankInfo bankInfo;
        if (this.prmtpayAccount.getData() instanceof SupplierCompanyBankInfo && (bankInfo = (SupplierCompanyBankInfo)this.prmtpayAccount.getData()) != null) {
            this.prmtpayeeBank.setData((Object)bankInfo.getBank());
            String bankname = bankInfo.getBank();
            if (bankname != null) {
                BEBankInfo info;
                String oql = "select * where name='" + bankname + "'";
                if (BEBankFactory.getRemoteInstance().exists(oql) && (info = BEBankFactory.getRemoteInstance().getBEBankInfo(oql)) != null) {
                    this.prmtpayeeBankNumber.setData((Object)info);
                }
            }
        }
    }

    @Override
    protected void prmtpayeeBank_dataChanged(DataChangeEvent e) throws Exception {
        if (this.prmtpayeeBank.getData() != null && this.prmtpayeeBank.getData() instanceof BEBankInfo) {
            BEBankInfo info = (BEBankInfo)this.prmtpayeeBank.getData();
            if (this.prmtpayeeBankNumber.getData() != null && this.prmtpayeeBankNumber.getData() instanceof BEBankInfo) {
                BEBankInfo info1 = (BEBankInfo)this.prmtpayeeBankNumber.getData();
                if (!info.getId().equals((Object)info1.getId())) {
                    this.prmtpayeeBankNumber.setData(this.prmtpayeeBank.getData());
                }
            }
        }
    }

    @Override
    protected void prmtpayeeBankNumber_dataChanged(DataChangeEvent e) throws Exception {
        if (this.prmtpayeeBankNumber.getData() != null && this.prmtpayeeBankNumber.getData() instanceof BEBankInfo) {
            BEBankInfo info = (BEBankInfo)this.prmtpayeeBankNumber.getData();
            if (this.prmtpayeeBank.getData() instanceof BEBankInfo) {
                BEBankInfo info1 = (BEBankInfo)this.prmtpayeeBank.getData();
                if (!info.getId().equals((Object)info1.getId())) {
                    this.prmtpayeeBank.setData(this.prmtpayeeBankNumber.getData());
                }
            }
        }
    }

    @Override
    protected void prmtassurersAccount_dataChanged(DataChangeEvent e) throws Exception {
        String bank;
        SupplierCompanyBankInfo bankInfo;
        super.prmtassurersAccount_dataChanged(e);
        if (this.prmtassurersAccount.getData() instanceof SupplierCompanyBankInfo && (bankInfo = (SupplierCompanyBankInfo)this.prmtassurersAccount.getData()) != null && (bank = bankInfo.getBank()) != null) {
            BEBankInfo beBank;
            String oql = "select * where name='" + bank + "'";
            if (BEBankFactory.getRemoteInstance().exists(oql) && (beBank = BEBankFactory.getRemoteInstance().getBEBankInfo(oql)) != null) {
                this.prmtassurersBankNumber.setData((Object)beBank);
            }
        }
    }

    @Override
    protected void txtaccpetorName_dataChanged(DataChangeEvent e) throws Exception {
        CompanyOrgUnitInfo company;
        super.txtaccpetorName_dataChanged(e);
        String companyId = "";
        if (this.txtaccpetorName.getValue() instanceof CompanyOrgUnitInfo && null != (company = (CompanyOrgUnitInfo)this.txtaccpetorName.getValue())) {
            companyId = company.getId().toString();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyId));
            filter.getFilterItems().add(new FilterItemInfo("isClosed", (Object)new Boolean(false)));
            filter.getFilterItems().add(new FilterItemInfo("isForEDrafOnly", (Object)new Boolean(true)));
            EntityViewInfo evi = new EntityViewInfo();
            evi.setFilter(filter);
            this.prmtaccpetorAccount.setEntityViewInfo(evi);
            this.prmtaccpetorAccount.getQueryAgent().resetRuntimeEntityView();
        }
    }

    @Override
    protected void prmtaccpetorName_dataChanged(DataChangeEvent e) throws Exception {
        if (this.prmtaccpetorName.getData() != null && this.prmtaccpetorName.getData() instanceof BankInfo) {
            BankInfo bankInfo = (BankInfo)this.prmtaccpetorName.getData();
            BankInfo bInfo = (BankInfo)this.prmtaccpetorBankName.getData();
            if (bInfo == null || bInfo != null && !bankInfo.getId().toString().equals(bInfo.getId().toString())) {
                this.prmtaccpetorBankName.setData((Object)bankInfo);
            }
            if (bankInfo.getAccountBank() != null && bankInfo.getAccountBank().getId() != null) {
                String id = bankInfo.getAccountBank().getId().toString();
                BEBankInfo info = BEBankFactory.getRemoteInstance().getBEBankInfo((IObjectPK)new ObjectUuidPK(id));
                BEBankInfo info1 = (BEBankInfo)this.prmtaccpetorBankNumber.getData();
                if (info1 == null || info1 != null && !info.getId().toString().equals(info1.getId().toString())) {
                    this.prmtaccpetorBankNumber.setData((Object)info);
                }
            }
        }
    }

    @Override
    protected void prmtaccpetorAccount_dataChanged(DataChangeEvent e) throws Exception {
        super.prmtaccpetorAccount_dataChanged(e);
        if (this.prmtaccpetorAccount.getData() != null && this.prmtaccpetorAccount.getData() instanceof AccountBankInfo) {
            AccountBankInfo accountBank = (AccountBankInfo)this.prmtaccpetorAccount.getData();
            String id = accountBank.getBank().getId().toString();
            BankInfo bank = BankFactory.getRemoteInstance().getBankInfo((IObjectPK)new ObjectUuidPK(id));
            this.prmtaccpetorBankName.setData((Object)bank);
            if (bank.getAccountBank() != null) {
                id = bank.getAccountBank().getId().toString();
                BEBankInfo info = BEBankFactory.getRemoteInstance().getBEBankInfo((IObjectPK)new ObjectUuidPK(id));
                this.prmtaccpetorBankNumber.setData((Object)info);
            }
        }
    }

    @Override
    protected void prmtassurersName_dataChanged(DataChangeEvent e) throws Exception {
        SupplierCompanyInfoInfo supplierCompany;
        SupplierInfo supplier;
        super.prmtassurersName_dataChanged(e);
        Object payee = this.prmtassurersName.getValue();
        if (payee instanceof SupplierInfo && (supplier = (SupplierInfo)this.prmtassurersName.getData()) != null && (supplierCompany = SupplierFactory.getRemoteInstance().getCompanyInfo((IObjectPK)new ObjectUuidPK(supplier.getId()), (IObjectPK)new ObjectUuidPK(this.currentCompany.getId()))) != null) {
            CSBankInfo bankInfo = FMHelper.getCSBankInfo(null, (Object)supplier, (String)this.currentCompany.getId().toString());
            this.prmtassurersAccount.setData((Object)bankInfo.getBankAccount());
            String bank = bankInfo.getBank();
            if (bank != null) {
                BEBankInfo beBank;
                String oql = "select where name='" + bank + "'";
                if (BEBankFactory.getRemoteInstance().exists(oql) && (beBank = BEBankFactory.getRemoteInstance().getBEBankInfo(oql)) != null) {
                    this.prmtassurersBankNumber.setData((Object)beBank);
                }
            }
            this.prmtassurersAccount.setQueryInfo("com.kingdee.eas.basedata.master.cssp.app.F7SupplierCompanyInfoBankQuery");
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("supplier.id", (Object)supplier.getId().toString(), CompareType.EQUALS));
            view.setFilter(filter);
            this.prmtassurersAccount.setEntityViewInfo(view);
            this.prmtassurersAccount.setEditFormat("$bankAccount$");
            this.prmtassurersAccount.setDisplayFormat("$bankAccount$");
            this.prmtassurersAccount.getQueryAgent().resetRuntimeEntityView();
        }
    }

    @Override
    protected void combDraftType_itemStateChanged(ItemEvent e) throws Exception {
        super.combDraftType_itemStateChanged(e);
        if (this.combDraftType.getSelectedItem().equals((Object)DrafTypeEnum.AC01)) {
            this.prmtaccpetorName.setVisible(true);
            this.txtaccpetorName.setData(null);
            this.txtaccpetorName.setVisible(false);
            if (this.prmtdrawerBank.getData() != null) {
                this.prmtaccpetorName.setData(this.prmtdrawerBank.getData());
            }
            this.prmtaccpetorAccount.setData((Object)new Integer(0));
            this.prmtaccpetorAccount.setEnabled(false);
        } else {
            CompanyOrgUnitInfo company;
            this.prmtaccpetorAccount.setEnabled(true);
            this.txtaccpetorName.setVisible(true);
            this.prmtaccpetorName.setData(null);
            this.prmtaccpetorName.setVisible(false);
            this.prmtaccpetorAccount.setData(null);
            this.txtaccpetorName.setData(this.prmtdrawerName.getData());
            this.prmtaccpetorAccount.setData(this.prmtdrawerAccount.getData());
            if (this.txtaccpetorName.getData() instanceof CompanyOrgUnitInfo && null != (company = (CompanyOrgUnitInfo)this.txtaccpetorName.getValue())) {
                String companyId = company.getId().toString();
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyId));
                filter.getFilterItems().add(new FilterItemInfo("isClosed", (Object)new Boolean(false)));
                filter.getFilterItems().add(new FilterItemInfo("isForEDrafOnly", (Object)new Boolean(true)));
                EntityViewInfo evi = new EntityViewInfo();
                evi.setFilter(filter);
                this.prmtaccpetorAccount.setEntityViewInfo(evi);
                this.prmtaccpetorAccount.getQueryAgent().resetRuntimeEntityView();
            }
        }
        this.prmtaccpetorBankNumber.setData(this.prmtdrawerBankNumber.getData());
        this.prmtaccpetorBankName.setData(this.prmtdrawerBank.getData());
    }

    protected void pkDueDate_dataChanged(DataChangeEvent e) throws Exception {
        this.txtdraftTime.setValue((Object)FinHorizon.getHorizon((KDDatePicker)this.pkIssueDate, (KDDatePicker)this.pkDueDate));
    }

    protected void pkIssueDate_dataChanged(DataChangeEvent e) throws Exception {
        this.txtdraftTime.setValue((Object)FinHorizon.getHorizon((KDDatePicker)this.pkIssueDate, (KDDatePicker)this.pkDueDate));
    }

    @Override
    protected void prmtdrawerName_preChange(PreChangeEvent e) throws Exception {
        this.isISBizUnitLL(e);
    }

    @Override
    protected void prmtaccpetorBankName_dataChanged(DataChangeEvent e) throws Exception {
        BankInfo bank;
        if (this.prmtaccpetorBankName.getData() != null && this.prmtaccpetorBankName.getData() instanceof BankInfo && (bank = (BankInfo)this.prmtaccpetorBankName.getData()) != null && bank.getAccountBank() != null && bank.getAccountBank().getId() != null) {
            String ebbankId = bank.getAccountBank().getId().toString();
            BEBankInfo beBank = BEBankFactory.getRemoteInstance().getBEBankInfo((IObjectPK)new ObjectUuidPK(ebbankId));
            BEBankInfo beBank1 = (BEBankInfo)this.prmtaccpetorBankNumber.getData();
            if (beBank1 == null || beBank1 != null && !beBank.getId().equals((Object)beBank1.getId())) {
                this.prmtaccpetorBankNumber.setData((Object)beBank);
            }
        }
    }

    @Override
    protected void prmtaccpetorBankNumber_dataChanged(DataChangeEvent e) throws Exception {
        if (this.prmtaccpetorBankNumber.getData() != null && this.prmtaccpetorBankNumber.getData() instanceof BEBankInfo) {
            BEBankInfo beBank = (BEBankInfo)this.prmtaccpetorBankNumber.getData();
            EntityViewInfo env = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("accountBank.id", (Object)beBank.getId().toString(), CompareType.EQUALS));
            env.setFilter(filter);
            BankCollection bankCol = BankFactory.getRemoteInstance().getBankCollection(env);
            if (bankCol.size() > 0) {
                BankInfo bankInfo = bankCol.get(0);
                BankInfo bank = (BankInfo)this.prmtaccpetorBankName.getData();
                if (bank == null || bank != null && !bank.getId().equals((Object)bankInfo.getId())) {
                    this.prmtaccpetorBankName.setData((Object)bankInfo);
                }
            }
        }
    }

    @Override
    protected void txtprocedureRate_dataChanged(DataChangeEvent e) throws Exception {
        BigDecimal value = this.txtprocedureRate.getBigDecimalValue();
        BigDecimal value1 = this.txtdraftAmount.getBigDecimalValue();
        if (value != null && value1 != null) {
            if (value.compareTo(FMConstants.ZERO) > 0 && value1.compareTo(FMConstants.ZERO) > 0) {
                BigDecimal rateMoney = value.multiply(value1.multiply(this.rate));
                this.txtmoneySum.setValue((Object)rateMoney);
            }
            if (value.compareTo(FMConstants.ZERO) == 0) {
                this.txtmoneySum.setValue((Object)FMConstants.ZERO);
            }
        }
        if (value == null) {
            this.txtprocedureRate.setValue((Object)FMConstants.ZERO);
            this.txtmoneySum.setValue((Object)FMConstants.ZERO);
        }
    }

    @Override
    protected void txtrecognizance_dataChanged(DataChangeEvent e) throws Exception {
        BigDecimal value = this.txtrecognizance.getBigDecimalValue();
        BigDecimal value1 = this.txtdraftAmount.getBigDecimalValue();
        if (value != null && value1 != null && value.compareTo(FMConstants.ZERO) > 0 && value1.compareTo(FMConstants.ZERO) > 0) {
            BigDecimal rateMoney = value.multiply(value1.multiply(this.rate));
            this.txtrecogniz.setValue((Object)rateMoney);
        }
        if (value == null) {
            this.txtrecognizance.setValue((Object)FMConstants.ZERO);
        }
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        if (this.getUIContext().get("ID") != null) {
            String id = this.getUIContext().get("ID").toString();
            DraftRegisterBillInfo info = DraftRegisterBillFactory.getRemoteInstance().getDraftRegisterBillInfo((IObjectPK)new ObjectUuidPK(id));
            if (info.getOperateState() != null && (info.getOperateState().equals((Object)OperateStateEnum.SAVE) || info.getOperateState().equals((Object)OperateStateEnum.SUBMIT))) {
                this.actionAudit.setEnabled(true);
                this.ActionUnAudit.setEnabled(false);
                if (this.getOprtState().equals(OprtState.VIEW)) {
                    this.setOprtState(OprtState.EDIT);
                }
                super.actionEdit_actionPerformed(e);
                if (this.editData.getOperateState().equals((Object)OperateStateEnum.SAVE)) {
                    this.actionSave.setEnabled(true);
                } else {
                    this.actionSave.setEnabled(false);
                }
                if (this.combDraftType.getSelectedItem().equals((Object)DrafTypeEnum.AC01)) {
                    this.prmtaccpetorAccount.setEnabled(false);
                }
                if (FMHelper.isEmpty((String)this.txtbatchNumber.getText())) {
                    this.txtbatchNumber.setText(this.editData.getBatchNumber());
                }
                if (FMHelper.isEmpty((String)this.txtacceptorCreditRat.getText())) {
                    this.txtacceptorCreditRat.setText(this.editData.getAcceptorCreditRat());
                }
                if (FMHelper.isEmpty((String)this.txtDrawerCreditRate.getText())) {
                    this.txtDrawerCreditRate.setText(this.editData.getCommercialDraft().getDrawerCreditRate());
                }
            } else {
                MsgBox.showInfo((String)"\u4fdd\u5b58\u6216\u63d0\u4ea4\u72b6\u6001\u7684\u8bb0\u5f55\u624d\u5141\u8bb8\u4fee\u6539\uff01");
            }
        }
    }

    @Override
    protected void txtmoneySum_dataChanged(DataChangeEvent e) throws Exception {
        if (FMHelper.isEmpty((String)this.txtmoneySum.getText())) {
            this.txtmoneySum.setValue((Object)FMConstants.ZERO);
        }
    }

    @Override
    protected void txtrecogniz_dataChanged(DataChangeEvent e) throws Exception {
        if (FMHelper.isEmpty((String)this.txtrecogniz.getText())) {
            this.txtrecogniz.setValue((Object)FMConstants.ZERO);
        }
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        if (this.getUIContext().get("ID") != null) {
            String id = this.getUIContext().get("ID").toString();
            DraftRegisterBillInfo info = DraftRegisterBillFactory.getRemoteInstance().getDraftRegisterBillInfo((IObjectPK)new ObjectUuidPK(id));
            if (!info.getOperateState().equals((Object)OperateStateEnum.SAVE) && !info.getOperateState().equals((Object)OperateStateEnum.SUBMIT)) {
                MsgBox.showInfo((String)"\u4fdd\u5b58\u6216\u63d0\u4ea4\u72b6\u6001\u4e14\u65e0\u4e0b\u6e38\u5355\u636e\u7684\u8bb0\u5f55\u624d\u5141\u8bb8\u5220\u9664\uff01");
                SysUtil.abort();
            } else {
                super.actionRemove_actionPerformed(e);
                this.actionExitCurrent_actionPerformed(null);
            }
        }
    }

    @Override
    protected void txtaccpetorName_preChange(PreChangeEvent e) throws Exception {
        this.isISBizUnitLL(e);
    }

    private void isISBizUnitLL(PreChangeEvent e) {
        CompanyOrgUnitInfo info;
        Object val = e.getData();
        if (val instanceof CompanyOrgUnitInfo && !(info = (CompanyOrgUnitInfo)val).isIsBizUnit()) {
            MsgBox.showInfo((String)"\u8bf7\u9009\u62e9\u5b9e\u4f53\u516c\u53f8\uff01");
            e.setResult(-1);
        }
    }

    @Override
    protected void txtNumber_focusGained(FocusEvent e) throws Exception {
        if (!this.txtNumber.isEnabled()) {
            this.combDraftType.requestFocus();
        }
    }

    public static EntityViewInfo getCreditLimitF7Filter(String bankId, String companyId) {
        EntityViewInfo eviprmtCreditLimit = new EntityViewInfo();
        eviprmtCreditLimit.setFilter(new FilterInfo());
        eviprmtCreditLimit.getFilter().getFilterItems().add(new FilterItemInfo("IsClosed", (Object)new Boolean(true), CompareType.NOTEQUALS));
        eviprmtCreditLimit.getFilter().getFilterItems().add(new FilterItemInfo("CreditInstitution.Id", (Object)bankId));
        eviprmtCreditLimit.getFilter().getFilterItems().add(new FilterItemInfo("ShareOrg.id", (Object)companyId));
        eviprmtCreditLimit.getFilter().getFilterItems().add(new FilterItemInfo("ShareType", (Object)new Integer(ShareTypeEnum.PRIVATE.getValue())));
        eviprmtCreditLimit.getFilter().getFilterItems().add(new FilterItemInfo("Balance", (Object)SysConstant.BIGZERO, CompareType.GREATER));
        eviprmtCreditLimit.getFilter().getFilterItems().add(new FilterItemInfo("ShareType", (Object)new Integer(ShareTypeEnum.SHARE.getValue())));
        eviprmtCreditLimit.getFilter().getFilterItems().add(new FilterItemInfo("Balance", (Object)SysConstant.BIGZERO, CompareType.GREATER));
        eviprmtCreditLimit.getFilter().getFilterItems().add(new FilterItemInfo("ShareType", (Object)new Integer(ShareTypeEnum.ASSIGN.getValue())));
        eviprmtCreditLimit.getFilter().getFilterItems().add(new FilterItemInfo("Balance", (Object)SysConstant.BIGZERO, CompareType.GREATER));
        boolean isMustAudit = ContextHelperFactory.getRemoteInstance().getBooleanParam("FIN014", (IObjectPK)new ObjectUuidPK(companyId));
        if (isMustAudit) {
            eviprmtCreditLimit.getFilter().getFilterItems().add(new FilterItemInfo("billStatus", (Object)new Integer(1), CompareType.EQUALS));
            eviprmtCreditLimit.getFilter().setMaskString("#0 and #1 and #2 and ((#3 and #4) or (#5 and #6)or(#7 and #8)) and #9");
        } else {
            eviprmtCreditLimit.getFilter().setMaskString("#0 and #1 and #2 and ((#3 and #4) or (#5 and #6)or(#7 and #8))");
        }
        return eviprmtCreditLimit;
    }

    @Override
    protected void prmtCreditLimit_willCommit(CommitEvent e) throws Exception {
    }

    @Override
    protected void prmtCreditLimit_willShow(SelectorEvent e) throws Exception {
        if (this.prmtdrawerBank.getData() != null) {
            BankInfo bank = (BankInfo)this.prmtdrawerBank.getData();
            String bankId = bank.getId().toString();
            this.prmtCreditLimit.setEntityViewInfo(DraftRegisterBillEditUI.getCreditLimitF7Filter(bankId, SysContext.getSysContext().getCurrentFIUnit().getId().toString()));
            this.prmtCreditLimit.getQueryAgent().resetRuntimeEntityView();
        } else {
            this.prmtCreditLimit.setEntityViewInfo(FMClientHelper.getNothingFilter());
            this.prmtCreditLimit.getQueryAgent().resetRuntimeEntityView();
        }
    }
}

