/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.edrafent.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPKFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.common.FilterParam;
import com.kingdee.eas.fm.ecore.ECDSBillStatusEnum;
import com.kingdee.eas.fm.edrafent.DrafTypeEnum;
import com.kingdee.eas.fm.edrafent.OperateStateEnum;
import com.kingdee.eas.fm.edrafent.client.IDraftRegisterRptHandler;
import com.kingdee.eas.fm.nt.PayableBillStateEnum;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;

public class DraftRegisterRptBaseHandler
implements IDraftRegisterRptHandler {
    protected FilterParam filterInfo;
    protected SorterItemCollection sorter;
    protected KDTable kdt = null;

    public DraftRegisterRptBaseHandler(FilterParam filterInfo, SorterItemCollection sorter, KDTable kdt) {
        this.filterInfo = filterInfo;
        this.sorter = sorter;
        this.kdt = kdt;
    }

    public DraftRegisterRptBaseHandler(FilterParam filterInfo, KDTable kdt) {
        this(filterInfo, new SorterItemCollection(), kdt);
    }

    @Override
    public void initHeader() {
        this.kdt.removeRows();
        this.kdt.removeHeadRows();
        this.kdt.removeColumns();
        this.kdt.getGroupManager().removeGroup();
        this.kdt.setEditable(false);
        this.kdt.getGroupManager().setGroup(true);
        this.kdt.getGroupManager().setOrientation(1);
        this.insertHeadRow();
        this.initHeadRows();
    }

    @Override
    public void filldata(IRowSet rs) throws SQLException, EASBizException, BOSException {
        this.kdt.setRefresh(false);
        while (rs.next()) {
            IRow row = this.kdt.addRow();
            row.getCell("id").setValue(rs.getObject("id"));
            row.getCell("company.name").setValue(rs.getObject("company"));
            row.getCell("number").setValue(rs.getObject("number"));
            row.getCell("banknotetStyle").setValue(rs.getObject("banknotetStyle"));
            if (rs.getString("banknotetStyle").equals("\u7535\u5b50\u7968\u636e")) {
                row.getCell("banknoteType").setValue((Object)DrafTypeEnum.getEnum(Integer.parseInt(rs.getString("banknoteType1"))));
            } else {
                row.getCell("banknoteType").setValue((Object)rs.getString("banknoteType"));
            }
            row.getCell("banknoteNumber").setValue(rs.getObject("banknoteNumber"));
            if (rs.getString("banknotetStyle").equals("\u7535\u5b50\u7968\u636e")) {
                row.getCell("operateState").setValue((Object)OperateStateEnum.getEnum(rs.getInt("operateState")));
            } else {
                row.getCell("operateState").setValue((Object)PayableBillStateEnum.getEnum((int)rs.getInt("operateState")));
            }
            row.getCell("draftECDSStatus").setValue((Object)ECDSBillStatusEnum.getEnum((String)rs.getString("draftECDSStatus")));
            row.getCell("currency").setValue(rs.getObject("currency"));
            row.getCell("banknoteAmount").setValue((Object)rs.getBigDecimal("banknoteAmount").divide(new BigDecimal(1), 2, 4));
            row.getCell("offCurrency").setValue((Object)rs.getBigDecimal("offCurrency").divide(new BigDecimal(1), 2, 4));
            row.getCell("issueDate").setValue(rs.getObject("issueDate"));
            row.getCell("dueDate").setValue(rs.getObject("dueDate"));
            BigDecimal banknoteTime = null;
            if (rs.getBigDecimal("banknoteTime") != null) {
                banknoteTime = rs.getBigDecimal("banknoteTime");
                banknoteTime = banknoteTime.setScale(1, 4);
            } else {
                banknoteTime = new BigDecimal(0.0);
            }
            row.getCell("banknoteTime").setValue((Object)banknoteTime);
            row.getCell("registerName").setValue(rs.getObject("registerName"));
            row.getCell("registerAccountNumber").setValue(rs.getObject("registerAccountNumber"));
            row.getCell("registerBank").setValue(rs.getObject("registerBank"));
            row.getCell("registerBankNumber").setValue(rs.getObject("registerBankNumber"));
            row.getCell("payeeName").setValue(rs.getObject("payeeName"));
            row.getCell("payeeAccountNumber").setValue(rs.getObject("payeeAccountNumber"));
            row.getCell("payeeBank").setValue(rs.getObject("payeeBank"));
            row.getCell("payeeBankNumber").setValue(rs.getObject("payeeBankNumber"));
            row.getCell("assurersName").setValue(rs.getObject("assurersName"));
            row.getCell("assurerAccount").setValue(rs.getObject("assurersAccount"));
            row.getCell("assurerBankNumber").setValue(rs.getObject("assurersBankNumber"));
            row.getCell("assurerAddress").setValue(rs.getObject("assurerAddress"));
            row.getCell("assurDate").setValue(rs.getObject("assurDate"));
            row.getCell("acceptorName").setValue(rs.getObject("acceptorName"));
            row.getCell("acceptorAccountNumber").setValue(rs.getObject("acceptorAccountNumber"));
            row.getCell("accpetorBankName").setValue(rs.getObject("accpetorBankName"));
            row.getCell("acceptorBankNumber").setValue(rs.getObject("acceptorBankNumber"));
            row.getCell("acceptorDate").setValue(rs.getObject("acceptorDate"));
            row.getCell("contractNumber").setValue(rs.getObject("contractNumber"));
            row.getCell("batchNumber").setValue(rs.getObject("batchNumber"));
            row.getCell("registerCdtBody").setValue(rs.getObject("registerCdtBody"));
            row.getCell("registerCreditRate").setValue(rs.getObject("registerCreditRate"));
            row.getCell("registerRateDueDate").setValue(rs.getObject("registerRateDueDate"));
            row.getCell("acceptorCdtBody").setValue(rs.getObject("acceptorCdtBody"));
            row.getCell("acceptorCreditRat").setValue(rs.getObject("acceptorCreditRat"));
            row.getCell("acceptorCdtDate").setValue(rs.getObject("acceptorCdtDate"));
            row.getCell("isAttorn").setValue(rs.getObject("isAttorn"));
            row.getCell("isAcceptor").setValue(rs.getObject("isAcceptor"));
            if (rs.getString("banknotetStyle").equals("\u7535\u5b50\u7968\u636e")) {
                row.getCell("isCancelDraft").setValue(rs.getObject("isCancelDraft"));
                row.getCell("clewAccept").setValue(rs.getObject("clewAccept"));
                row.getCell("clewDrawer").setValue(rs.getObject("clewDrawer"));
            }
            row.getCell("fiVouchered").setValue(rs.getObject("fiVouchered"));
            row.getCell("voucherTypeName").setValue(rs.getObject("voucherTypeName"));
            row.getCell("voucherTypeNumber").setValue(rs.getObject("voucherTypeNumber"));
            row.getCell("creator.name").setValue(rs.getObject("creator"));
            row.getCell("creator.createTime").setValue(rs.getObject("createTime"));
            row.setUserObject(row.getCell("id").getValue());
        }
    }

    @Override
    public void endDataFill() {
        this.kdt.setRefresh(true);
        this.kdt.repaint();
        this.kdt.getGroupManager().group();
        this.kdt.getGroupManager().setGroup(false);
    }

    @Override
    public IRowSet getRowSet() throws BOSException {
        IMetaDataPK pk = MetaDataPKFactory.getMetaDataPK((String)"com.kingdee.eas.fm.edrafent.app.DraftSummaryQuery");
        IQueryExecutor exec = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)pk);
        EntityViewInfo ev = new EntityViewInfo();
        ev.setFilter(this.filterInfo.getFilter());
        ev.getSorter().clear();
        ev.getSorter().addObjectCollection((IObjectCollection)this.sorter);
        exec.setObjectView(ev);
        return exec.executeQuery();
    }

    public void execute() throws BOSException, EASBizException, SQLException {
        this.initHeader();
        this.setTableStateRow();
        IRowSet rs = this.getRowSet();
        if (rs != null) {
            this.filldata(rs);
        }
        this.endDataFill();
    }

    @Override
    public void setTableStateRow() {
    }

    protected void initHeadRows() {
        IRow headRow = this.kdt.addHeadRow();
        headRow.getCell("id").setValue((Object)"id");
        headRow.getCell("company.name").setValue((Object)"\u516c\u53f8");
        headRow.getCell("number").setValue((Object)"\u5355\u636e\u7f16\u53f7");
        headRow.getCell("banknotetStyle").setValue((Object)"\u7968\u636e\u79cd\u7c7b");
        headRow.getCell("banknoteType").setValue((Object)"\u7968\u636e\u7c7b\u578b");
        headRow.getCell("banknoteNumber").setValue((Object)"\u7968\u636e\u53f7\u7801");
        headRow.getCell("operateState").setValue((Object)"\u64cd\u4f5c\u72b6\u6001");
        headRow.getCell("draftECDSStatus").setValue((Object)"\u7535\u7968\u72b6\u6001");
        headRow.getCell("currency").setValue((Object)"\u5e01\u522b");
        headRow.getCell("banknoteAmount").setValue((Object)"\u7968\u636e\u91d1\u989d");
        headRow.getCell("offCurrency").setValue((Object)"\u6298\u672c\u4f4d\u5e01");
        headRow.getCell("issueDate").setValue((Object)"\u51fa\u7968\u65e5\u671f");
        headRow.getCell("dueDate").setValue((Object)"\u5230\u671f\u65e5");
        headRow.getCell("banknoteTime").setValue((Object)"\u7968\u636e\u671f\u9650\u6708");
        headRow.getCell("registerName").setValue((Object)"\u51fa\u7968\u4eba");
        headRow.getCell("registerAccountNumber").setValue((Object)"\u51fa\u7968\u4eba\u8d26\u53f7");
        headRow.getCell("registerBank").setValue((Object)"\u51fa\u7968\u4eba\u5f00\u6237\u884c");
        headRow.getCell("registerBankNumber").setValue((Object)"\u51fa\u7968\u4eba\u5f00\u6237\u884c\u884c\u53f7");
        headRow.getCell("payeeName").setValue((Object)"\u6536\u6b3e\u4eba");
        headRow.getCell("payeeAccountNumber").setValue((Object)"\u6536\u6b3e\u4eba\u8d26\u53f7");
        headRow.getCell("payeeBank").setValue((Object)"\u6536\u6b3e\u4eba\u5f00\u6237\u884c");
        headRow.getCell("payeeBankNumber").setValue((Object)"\u6536\u6b3e\u4eba\u5f00\u6237\u884c\u884c\u53f7");
        headRow.getCell("assurersName").setValue((Object)"\u4fdd\u8bc1\u4eba");
        headRow.getCell("assurerAccount").setValue((Object)"\u4fdd\u8bc1\u4eba\u8d26\u53f7");
        headRow.getCell("assurerBankNumber").setValue((Object)"\u4fdd\u8bc1\u4eba\u5f00\u6237\u884c\u884c\u53f7");
        headRow.getCell("assurerAddress").setValue((Object)"\u4fdd\u8bc1\u4eba\u5730\u5740");
        headRow.getCell("assurDate").setValue((Object)"\u4fdd\u8bc1\u65e5\u671f");
        headRow.getCell("acceptorName").setValue((Object)"\u627f\u5151\u4eba");
        headRow.getCell("acceptorAccountNumber").setValue((Object)"\u627f\u5151\u4eba\u8d26\u53f7");
        headRow.getCell("accpetorBankName").setValue((Object)"\u627f\u5151\u4eba\u5f00\u6237\u884c");
        headRow.getCell("acceptorBankNumber").setValue((Object)"\u627f\u5151\u4eba\u5f00\u6237\u884c\u884c\u53f7");
        headRow.getCell("acceptorDate").setValue((Object)"\u627f\u5151\u65e5\u671f");
        headRow.getCell("contractNumber").setValue((Object)"\u4ea4\u6613\u5408\u540c\u53f7");
        headRow.getCell("batchNumber").setValue((Object)"\u6279\u6b21\u53f7");
        headRow.getCell("registerCdtBody").setValue((Object)"\u51fa\u7968\u4eba\u8bc4\u7ea7\u4e3b\u4f53");
        headRow.getCell("registerCreditRate").setValue((Object)"\u51fa\u7968\u4eba\u4fe1\u7528\u7b49\u7ea7");
        headRow.getCell("registerRateDueDate").setValue((Object)"\u51fa\u7968\u4eba\u8bc4\u7ea7\u5230\u671f\u65e5");
        headRow.getCell("acceptorCdtBody").setValue((Object)"\u627f\u5151\u4eba\u8bc4\u7ea7\u4e3b\u4f53");
        headRow.getCell("acceptorCreditRat").setValue((Object)"\u627f\u5151\u4eba\u4fe1\u7528\u7b49\u7ea7");
        headRow.getCell("acceptorCdtDate").setValue((Object)"\u627f\u5151\u4eba\u8bc4\u7ea7\u5230\u671f\u65e5");
        headRow.getCell("isAttorn").setValue((Object)"\u5141\u8bb8\u8f6c\u8ba9");
        headRow.getCell("isAcceptor").setValue((Object)"\u627f\u5151\u4eba\u627f\u8bfa\u5230\u671f\u65e0\u6761\u4ef6\u4ed8\u6b3e");
        headRow.getCell("isCancelDraft").setValue((Object)"\u64a4\u9500\u7533\u8bf7");
        headRow.getCell("clewAccept").setValue((Object)"\u63d0\u793a\u627f\u5151");
        headRow.getCell("clewDrawer").setValue((Object)"\u63d0\u793a\u6536\u7968");
        headRow.getCell("fiVouchered").setValue((Object)"\u662f\u5426\u751f\u6210\u51ed\u8bc1");
        headRow.getCell("voucherTypeName").setValue((Object)"\u51ed\u8bc1\u7c7b\u578b");
        headRow.getCell("voucherTypeNumber").setValue((Object)"\u51ed\u8bc1\u53f7");
        headRow.getCell("creator.name").setValue((Object)"\u5236\u5355\u4eba");
        headRow.getCell("creator.createTime").setValue((Object)"\u5236\u5355\u65e5\u671f");
    }

    protected void insertHeadRow() {
        IColumn col0 = this.kdt.addColumn();
        col0.setKey("id");
        col0.getStyleAttributes().setHided(true);
        IColumn col1 = this.kdt.addColumn();
        col1.setKey("company.name");
        IColumn col2 = this.kdt.addColumn();
        col2.setKey("number");
        IColumn col3 = this.kdt.addColumn();
        col3.setKey("banknotetStyle");
        IColumn col4 = this.kdt.addColumn();
        col4.setKey("banknoteType");
        IColumn col5 = this.kdt.addColumn();
        col5.setKey("banknoteNumber");
        IColumn col6 = this.kdt.addColumn();
        col6.setKey("operateState");
        IColumn col7 = this.kdt.addColumn();
        col7.setKey("draftECDSStatus");
        IColumn col8 = this.kdt.addColumn();
        col8.setKey("currency");
        IColumn col9 = this.kdt.addColumn();
        col9.setKey("banknoteAmount");
        col9.getStyleAttributes().setNumberFormat("%r{###,##0.00}f");
        col9.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        IColumn col10 = this.kdt.addColumn();
        col10.setKey("offCurrency");
        col10.getStyleAttributes().setNumberFormat("%r{###,##0.00}f");
        col10.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        IColumn col11 = this.kdt.addColumn();
        col11.setKey("issueDate");
        IColumn col12 = this.kdt.addColumn();
        col12.setKey("dueDate");
        IColumn col13 = this.kdt.addColumn();
        col13.setKey("banknoteTime");
        col13.getStyleAttributes().setNumberFormat("%r{#,##0.0}f");
        col13.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        IColumn col14 = this.kdt.addColumn();
        col14.setKey("registerName");
        col14.setWidth(150);
        IColumn col15 = this.kdt.addColumn();
        col15.setKey("registerAccountNumber");
        col15.setWidth(130);
        IColumn col16 = this.kdt.addColumn();
        col16.setKey("registerBank");
        col16.setWidth(150);
        IColumn col17 = this.kdt.addColumn();
        col17.setKey("registerBankNumber");
        col17.setWidth(110);
        IColumn col18 = this.kdt.addColumn();
        col18.setKey("payeeName");
        col18.setWidth(150);
        IColumn col19 = this.kdt.addColumn();
        col19.setKey("payeeAccountNumber");
        col19.setWidth(130);
        IColumn col20 = this.kdt.addColumn();
        col20.setKey("payeeBank");
        col20.setWidth(150);
        IColumn col21 = this.kdt.addColumn();
        col21.setKey("payeeBankNumber");
        col21.setWidth(110);
        IColumn col22 = this.kdt.addColumn();
        col22.setKey("assurersName");
        col22.setWidth(150);
        IColumn col23 = this.kdt.addColumn();
        col23.setKey("assurerAccount");
        col23.setWidth(130);
        IColumn col24 = this.kdt.addColumn();
        col24.setKey("assurerBankNumber");
        col21.setWidth(110);
        IColumn col25 = this.kdt.addColumn();
        col25.setKey("assurerAddress");
        IColumn col26 = this.kdt.addColumn();
        col26.setKey("assurDate");
        IColumn col27 = this.kdt.addColumn();
        col27.setKey("acceptorName");
        IColumn col28 = this.kdt.addColumn();
        col28.setKey("acceptorAccountNumber");
        IColumn col29 = this.kdt.addColumn();
        col29.setKey("accpetorBankName");
        IColumn col30 = this.kdt.addColumn();
        col30.setKey("acceptorBankNumber");
        IColumn col31 = this.kdt.addColumn();
        col31.setKey("acceptorDate");
        IColumn col32 = this.kdt.addColumn();
        col32.setKey("contractNumber");
        IColumn col33 = this.kdt.addColumn();
        col33.setKey("batchNumber");
        IColumn col34 = this.kdt.addColumn();
        col34.setKey("registerCdtBody");
        IColumn col35 = this.kdt.addColumn();
        col35.setKey("registerCreditRate");
        IColumn col36 = this.kdt.addColumn();
        col36.setKey("registerRateDueDate");
        IColumn col37 = this.kdt.addColumn();
        col37.setKey("acceptorCdtBody");
        IColumn col38 = this.kdt.addColumn();
        col38.setKey("acceptorCreditRat");
        IColumn col39 = this.kdt.addColumn();
        col39.setKey("acceptorCdtDate");
        IColumn col40 = this.kdt.addColumn();
        col40.setKey("isAttorn");
        IColumn col41 = this.kdt.addColumn();
        col41.setKey("isAcceptor");
        IColumn col42 = this.kdt.addColumn();
        col42.setKey("isCancelDraft");
        IColumn col43 = this.kdt.addColumn();
        col43.setKey("clewAccept");
        IColumn col44 = this.kdt.addColumn();
        col44.setKey("clewDrawer");
        IColumn col45 = this.kdt.addColumn();
        col45.setKey("fiVouchered");
        IColumn col46 = this.kdt.addColumn();
        col46.setKey("voucherTypeName");
        IColumn col47 = this.kdt.addColumn();
        col47.setKey("voucherTypeNumber");
        IColumn col48 = this.kdt.addColumn();
        col48.setKey("creator.name");
        IColumn col49 = this.kdt.addColumn();
        col49.setKey("creator.createTime");
        col49.getStyleAttributes().setNumberFormat("yyyy-MM-dd hh:mm:ss");
        col49.setWidth(130);
    }
}

