/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.edrafent.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTSortManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTPropertyChangeEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTPropertyChangeListener;
import com.kingdee.bos.ctrl.kdf.table.foot.KDTFootManager;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMFilterBaseUI;
import com.kingdee.eas.fm.edrafent.client.AbstractDraftRegisterRptUI;
import com.kingdee.eas.fm.edrafent.client.DraftRegisterFilterParam;
import com.kingdee.eas.fm.edrafent.client.DraftRegisterFilterUI;
import com.kingdee.eas.fm.edrafent.client.DraftRegisterRptBaseHandler;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import org.apache.log4j.Logger;

public class DraftRegisterRptUI
extends AbstractDraftRegisterRptUI {
    private static final Logger logger = CoreUIObject.getLogger(DraftRegisterRptUI.class);
    DraftRegisterFilterParam filterParam = null;
    DraftRegisterFilterUI filterUI = null;

    public DraftRegisterRptUI() throws Exception {
        this.kdtMainQuery.getDataRequestManager().setDataRequestMode(0);
        this.kdtMainQuery.checkParsed();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.menuItemExport.setText("\u5bfc\u51fa");
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    public void actionJoinQueryBill_actionPerformed(ActionEvent e) throws Exception {
        super.actionJoinQueryBill_actionPerformed(e);
        KDTSelectBlock selectBlock = this.kdtMainQuery.getSelectManager().get();
        if (selectBlock != null) {
            IRow row = this.kdtMainQuery.getRow(selectBlock.getTop());
            Object id = row.getUserObject();
            String billId = null;
            if (id != null) {
                billId = id.toString();
            }
            if (id != null) {
                FMClientHelper.viewDetailBill((CoreUIObject)this, (String)billId, (CompanyOrgUnitInfo)SysContext.getSysContext().getCurrentFIUnit());
            }
        }
    }

    protected void execQuery() throws BOSException {
        this.kdtMainQuery.getDataRequestManager().setDataRequestMode(0);
        this.filterParam = (DraftRegisterFilterParam)this.getFilterParam();
        DraftRegisterRptBaseHandler handler = new DraftRegisterRptBaseHandler(this.filterParam, this.kdtMainQuery);
        handler.initHeader();
        IRowSet rs = handler.getRowSet();
        this.kdtMainQuery.getSelectManager().setSelectMode(10);
        String[] fields = new String[]{"company.name", "number", "banknoteAmount", "offCurrency", "issueDate", "dueDate", "banknoteTime", "registerRateDueDate", "acceptorCdtDate", "creator.createTime"};
        KDTSortManager sortManager = new KDTSortManager(this.kdtMainQuery);
        sortManager.setSortAuto(true);
        sortManager.setClickCount(1);
        for (int i = 0; i < fields.length; ++i) {
            IColumn column = this.kdtMainQuery.getColumn(fields[i]);
            if (column != null) {
                column.setSortable(true);
                continue;
            }
            logger.info((Object)("There's not exist column " + fields[i] + ". Please check the column name."));
        }
        try {
            handler.filldata(rs);
        }
        catch (Exception e) {
            this.handUIExceptionAndAbort(e);
        }
        handler.endDataFill();
        this.kdtMainQuery.setColumnMoveable(false);
        this.addTablePropertyList(this.kdtMainQuery);
        this.apendFootRow(this.kdtMainQuery, new String[]{"banknoteAmount", "offCurrency"});
    }

    public FMFilterBaseUI getFilterUI() throws Exception {
        if (this.filterUI == null) {
            this.filterUI = new DraftRegisterFilterUI();
        }
        return this.filterUI;
    }

    protected KDTable getMainTable() {
        return this.kdtMainQuery;
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnJoinQueryBill.setIcon(EASResource.getIcon((String)"imgTbtn_sequencecheck"));
    }

    private void apendFootRow(KDTable table, String[] field) {
        int size = field.length;
        int count = table.getRowCount();
        BigDecimal invoiceAmount = new BigDecimal("0.00");
        BigDecimal unverifyamount = new BigDecimal("0.00");
        IRow footRow = null;
        KDTFootManager footManager = table.getFootManager();
        if (footManager == null) {
            footManager = new KDTFootManager(table);
            footManager.addFootView();
            table.setFootManager(footManager);
        }
        footRow = footManager.getFootRow(0);
        for (int i = 0; i < count; ++i) {
            IRow row = table.getRow(i);
            ICell cell_invoiceAmount = row.getCell("banknoteAmount");
            ICell cell_unverifyamount = row.getCell("offCurrency");
            if (cell_invoiceAmount.getValue() != null) {
                invoiceAmount = invoiceAmount.add(new BigDecimal(cell_invoiceAmount.getValue().toString()));
            }
            if (cell_unverifyamount.getValue() == null) continue;
            unverifyamount = unverifyamount.add(new BigDecimal(cell_unverifyamount.getValue().toString()));
        }
        if (footRow == null) {
            String colFormat = "%{###,##0.00}f";
            footRow = footManager.addFootRow(0);
            String total = EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_Total");
            table.getIndexColumn().setWidthAdjustMode((short)1);
            table.getIndexColumn().setWidth(30);
            footManager.addIndexText(0, total);
            footRow.getStyleAttributes().setBackground(new Color(246, 246, 191));
            for (int i = 0; i < size; ++i) {
                String colName = field[i];
                footRow.getCell(colName).getStyleAttributes().setNumberFormat(colFormat);
                footRow.getCell(colName).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
                footRow.getCell(colName).getStyleAttributes().setFontColor(Color.black);
            }
        }
        footRow.getCell("banknoteAmount").setValue((Object)invoiceAmount.toString());
        footRow.getCell("offCurrency").setValue((Object)unverifyamount.toString());
    }

    private void addTablePropertyList(final KDTable table) {
        KDTPropertyChangeListener propertyChangeListener = new KDTPropertyChangeListener(){

            public void propertyChange(KDTPropertyChangeEvent evt) {
                int columnIndex;
                String colKey;
                if (evt.getType() == 1 && evt.getPropertyName().equals("cellValue") && (colKey = table.getColumn(columnIndex = evt.getColIndex()).getKey()) != null && evt.getOldValue() != null) {
                    BigDecimal oldValue = new BigDecimal(evt.getOldValue().toString());
                    BigDecimal newValue = new BigDecimal(evt.getNewValue().toString());
                    KDTFootManager footManager = table.getFootManager();
                    IRow footRow = footManager.getFootRow(0);
                    if (footRow != null) {
                        BigDecimal totalValue = new BigDecimal(footRow.getCell(colKey).getValue().toString());
                        totalValue = totalValue.add(newValue).subtract(oldValue);
                        footRow.getCell(colKey).setValue((Object)totalValue.toString());
                    }
                }
            }
        };
        table.addKDTPropertyChangeListener(propertyChangeListener);
    }
}

