/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.edrafent.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.BasicFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.assistant.AccountBankCollection;
import com.kingdee.eas.basedata.assistant.AccountBankFactory;
import com.kingdee.eas.basedata.assistant.BankFactory;
import com.kingdee.eas.basedata.assistant.BankInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fm.common.FMConstants;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.ecore.BanEndorsementMarkEnum;
import com.kingdee.eas.fm.ecore.ECoreQueryServiceFacadeFactory;
import com.kingdee.eas.fm.edrafent.CommercialDraftBackSideEntryCollection;
import com.kingdee.eas.fm.edrafent.CommercialDraftBackSideEntryFactory;
import com.kingdee.eas.fm.edrafent.CommercialDraftBackSideEntryInfo;
import com.kingdee.eas.fm.edrafent.CommercialDraftInfo;
import com.kingdee.eas.fm.edrafent.DraftSignUpFactory;
import com.kingdee.eas.fm.edrafent.DraftSignUpInfo;
import com.kingdee.eas.fm.edrafent.StockBillAccptEntryCollection;
import com.kingdee.eas.fm.edrafent.StockBillAccptEntryFactory;
import com.kingdee.eas.fm.edrafent.StockBillAccptEntryInfo;
import com.kingdee.eas.fm.edrafent.client.AbstractDraftSignUpFrontUI;
import com.kingdee.eas.fm.fin.util.FinHorizon;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.util.LocaleUtils;
import java.math.BigDecimal;
import java.util.Locale;
import org.apache.log4j.Logger;

public class DraftSignUpFrontUI
extends AbstractDraftSignUpFrontUI {
    private static final Logger logger = CoreUIObject.getLogger(DraftSignUpFrontUI.class);

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return DraftSignUpFactory.getRemoteInstance();
    }

    @Override
    protected IObjectValue createNewData() {
        DraftSignUpInfo objectValue = new DraftSignUpInfo();
        return objectValue;
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.btnAuditResult.setVisible(false);
        this.actionTraceDown.setEnabled(false);
        this.actionTraceUp.setEnabled(false);
        this.actionPrint.setVisible(false);
        this.actionPrintPreview.setVisible(false);
        this.initData();
    }

    private void initData() throws BOSException, EASBizException {
        CommercialDraftBackSideEntryInfo backInfo;
        int i;
        CommercialDraftInfo comInfo = this.editData.getCommercialDraft();
        FMClientHelper.initCurrencyField((BasicFormattedTextField)this.txtdraftAmount);
        this.txtdraftAmount.setPrecision(2);
        this.txtdraftTime.setValue((Object)FinHorizon.getHorizon((KDDatePicker)this.pkIssueDate, (KDDatePicker)this.pkDueDate));
        FMClientHelper.initCurrencyField((BasicFormattedTextField)this.txtdraftTime);
        this.txtdraftTime.setPrecision(1);
        this.txtdraftTime.setMinimumValue((Comparable)FMConstants.ZERO);
        this.txtdraftTime.setHorizontalAlignment(4);
        this.chkisAttorn.setEnabled(false);
        this.txtdraftAmount.setHorizontalAlignment(4);
        this.kDBizPromptBox1.setText(SysContext.getSysContext().getCurrentUserInfo().getName());
        this.prmtdrawerName.setText(comInfo.getDrawerName());
        this.prmtdrawerAccount.setText(comInfo.getDrawerAccountNumber());
        BankInfo drawerBankInfo = this.findBankInfoByAccount(comInfo.getDrawerAccountNumber());
        this.prmtdrawerBank.setData((Object)drawerBankInfo);
        this.prmtdrawerBankNumber.setText(comInfo.getDrawerBankNumber());
        this.prmtpayeeName.setText(comInfo.getPayeeName());
        this.prmtpayAccount.setText(comInfo.getPayeeAccountNumber());
        BankInfo payBankInfo = this.findBankInfoByAccount(comInfo.getPayeeAccountNumber());
        this.prmtpayeeBank.setData((Object)payBankInfo);
        this.prmtpayeeBankNumber.setText(comInfo.getPayeeBankNumber());
        if (comInfo.getBanEndorsement() == BanEndorsementMarkEnum.EM00) {
            this.chkisAttorn.setSelected(true);
        }
        CommercialDraftBackSideEntryCollection cc = this.findBusinessNotiFication(comInfo.getId().toString());
        this.txtassurerAddress.setText("");
        this.pkassurDate.setValue(null);
        if (cc.size() > 0) {
            for (i = 0; i < cc.size(); ++i) {
                backInfo = cc.get(i);
                if (backInfo.getDraftBizType().getValue() != 10 || !this.prmtdrawerAccount.equals(backInfo.getFormerAccount())) continue;
                this.prmtassurersName.setText(backInfo.getLaterName());
                this.prmtassurerAccount.setText(backInfo.getLaterAccount());
                this.prmtassurerBankNumber.setText(backInfo.getLaterBank());
                this.txtassurerAddress.setText(backInfo.getGuarnteeAddress());
                this.pkassurDate.setValue((Object)backInfo.getDraftSignInDate());
                break;
            }
        }
        this.txtdraftAmountToUpper.setText(GlUtils.getChineseFormat((BigDecimal)comInfo.getDraftAmount(), (boolean)true, (Locale)LocaleUtils.locale_L2));
        this.pkacceptorDate.setValue(null);
        this.pkDrawerRateDueDate.setValue(null);
        this.pkacceptorCdtDate.setValue(null);
        this.prmtaccpetorBank.setText(comInfo.getAcceptorName());
        this.prmtaccpetorAccount.setText(comInfo.getAcceptorAccountNumber());
        this.prmtaccpetorBankNumber.setText(comInfo.getAcceptorBankNumber());
        this.prmtaccpetorBankName.setData((Object)ECoreQueryServiceFacadeFactory.getRemoteInstance().getBankNameByAcctSvcr(comInfo.getAcceptorBankNumber()));
        if (cc.size() > 0) {
            for (i = 0; i < cc.size(); ++i) {
                backInfo = cc.get(i);
                if (backInfo.getDraftBizType().getValue() != 0) continue;
                EntityViewInfo viewinfo = new EntityViewInfo();
                FilterInfo fi = new FilterInfo();
                fi.getFilterItems().add(new FilterItemInfo("parent", (Object)backInfo.getId()));
                viewinfo.setFilter(fi);
                StockBillAccptEntryCollection accptCol = StockBillAccptEntryFactory.getRemoteInstance().getStockBillAccptEntryCollection(viewinfo);
                this.pkacceptorDate.setValue((Object)backInfo.getDraftSignInDate());
                if (accptCol.size() <= 0) break;
                StockBillAccptEntryInfo accptInfo = accptCol.get(0);
                if (accptInfo.getAccptCdtRater() != null) {
                    this.txtacceptorCdtBody.setText(accptInfo.getAccptCdtRater());
                }
                if (accptInfo.getAccptCredieRate() != null) {
                    this.txtacceptorCreditRat.setText(accptInfo.getAccptCredieRate());
                }
                this.pkacceptorCdtDate.setValue((Object)accptInfo.getAccptRtDueDate());
                this.txtcontractNumber.setText(accptInfo.getContractNumber());
                break;
            }
        }
        this.txtdrawerCdtBody.setText(comInfo.getDrawerRateAgcy());
        this.txtDrawerCreditRate.setText(comInfo.getDrawerCreditRate());
        this.pkDrawerRateDueDate.setValue((Object)comInfo.getDrawerRateDueDate());
        this.txtRemark.setText(comInfo.getRemark());
        this.chkisAcceptor.setSelected(true);
    }

    private CommercialDraftBackSideEntryCollection findBusinessNotiFication(String id) throws BOSException {
        EntityViewInfo viewinfo = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("parent", (Object)id));
        SorterItemInfo sortInfo = new SorterItemInfo("seq");
        SorterItemCollection sortCol = new SorterItemCollection();
        sortInfo.setSortType(SortType.ASCEND);
        sortCol.add(sortInfo);
        viewinfo.setSorter(sortCol);
        viewinfo.setFilter(fi);
        return CommercialDraftBackSideEntryFactory.getRemoteInstance().getCommercialDraftBackSideEntryCollection(viewinfo);
    }

    private BankInfo findBankInfoByAccount(String BankAccount) throws BOSException, EASBizException {
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("bankAccountNumber", (Object)BankAccount));
        ev.setFilter(filter);
        AccountBankCollection accountBank = AccountBankFactory.getRemoteInstance().getAccountBankCollection(ev);
        if (accountBank.size() > 0) {
            String id = accountBank.get(0).getBank().getId().toString();
            BankInfo info = BankFactory.getRemoteInstance().getBankInfo((IObjectPK)new ObjectUuidPK(id));
            return info;
        }
        return null;
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add("*");
        sic.add("commercialDraft.*");
        return sic;
    }
}

