/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.edrafent.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.BasicFormattedTextField;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.ecore.DraftBizTypeEnum;
import com.kingdee.eas.fm.ecore.ECDSBillStatusEnum;
import com.kingdee.eas.fm.edrafent.CommercialDraftBackSideEntryCollection;
import com.kingdee.eas.fm.edrafent.CommercialDraftBackSideEntryInfo;
import com.kingdee.eas.fm.edrafent.CommercialDraftFactory;
import com.kingdee.eas.fm.edrafent.CommercialDraftInfo;
import com.kingdee.eas.fm.edrafent.DrafReplyTypeEnum;
import com.kingdee.eas.fm.edrafent.DraftStockBillFactory;
import com.kingdee.eas.fm.edrafent.DraftStockBillInfo;
import com.kingdee.eas.fm.edrafent.DraftStockBillOperateEnum;
import com.kingdee.eas.fm.edrafent.IDraftStockBill;
import com.kingdee.eas.fm.edrafent.StockBillAccptEntryFactory;
import com.kingdee.eas.fm.edrafent.StockBillAccptEntryInfo;
import com.kingdee.eas.fm.edrafent.client.AbstractDraftStockBillEditUI;
import com.kingdee.eas.fm.edrafent.client.DraftCollateralizationRequestEditUI;
import com.kingdee.eas.fm.edrafent.client.DraftOverdueClewPaymentBillEditUI;
import com.kingdee.eas.fm.edrafent.client.DraftPromptPaymentBillEditUI1;
import com.kingdee.eas.fm.edrafent.client.DraftRecourseBillEditUI;
import com.kingdee.eas.fm.edrafent.client.DraftStockBackSideUI;
import com.kingdee.eas.fm.edrafent.client.EndorsementTransferUI;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.LocaleUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class DraftStockBillEditUI
extends AbstractDraftStockBillEditUI {
    private static final Logger logger = CoreUIObject.getLogger(DraftStockBillEditUI.class);
    private boolean status = false;

    public DraftStockBillEditUI() throws Exception {
        this.txtdraftTime.setEnabled(true);
        this.sourceSignType.removeItem((Object)DrafReplyTypeEnum.ALL);
        FMClientHelper.initCurrencyField((BasicFormattedTextField)this.txtdraftAmount);
        FMClientHelper.initCurrencyField((BasicFormattedTextField)this.txtdraftTime);
        this.prmtSubmitter.setDisplayFormat("$name$");
    }

    @Override
    public void onLoad() throws Exception {
        super.onLoad();
        this.setPreferredSize(new Dimension(this.getWidth(), this.getHeight()));
        if (this.getUIContext().get("isBotp") != null && Integer.parseInt(this.getUIContext().get("isBotp").toString()) == 1) {
            this.toolBar.setEnabled(false);
            this.actionEndorsement.setVisible(false);
            this.actionPresent.setVisible(false);
            this.actionOverDuePresent.setVisible(false);
            this.actionRecourse.setVisible(false);
            this.actionCollateral.setVisible(false);
        }
        if (GlUtils.isCompanyUnion((CompanyOrgUnitInfo)this.currentCompany)) {
            this.actionSave.setVisible(false);
            this.actionEdit.setVisible(false);
            this.actionRemove.setVisible(false);
            this.actionAudit.setVisible(false);
            this.ActionUnAudit.setVisible(false);
            this.actionSubmit.setVisible(false);
            this.actionBackSideInfoQuery.setVisible(false);
            this.actionEndorsement.setVisible(false);
            this.actionPresent.setVisible(false);
            this.actionDiscount.setVisible(false);
            this.actionOverDuePresent.setVisible(false);
            this.actionRecourse.setVisible(false);
            this.actionCollateral.setVisible(false);
        }
    }

    public boolean collateralStatus(CommercialDraftInfo commercialDraftInfo) {
        return commercialDraftInfo.getDraftECDSStatus() == ECDSBillStatusEnum.TSSPYQS || commercialDraftInfo.getDraftECDSStatus() == ECDSBillStatusEnum.BSYQS || commercialDraftInfo.getDraftECDSStatus() == ECDSBillStatusEnum.MDSTXYQS || commercialDraftInfo.getDraftECDSStatus() == ECDSBillStatusEnum.HGSTXYYSHJZR || commercialDraftInfo.getDraftECDSStatus() == ECDSBillStatusEnum.HGSTXSHYQS || commercialDraftInfo.getDraftECDSStatus() == ECDSBillStatusEnum.MDSZHTXYQS || commercialDraftInfo.getDraftECDSStatus() == ECDSBillStatusEnum.HGSZHTXYYSHJZR || commercialDraftInfo.getDraftECDSStatus() == ECDSBillStatusEnum.HGSZHTXSHYQS || commercialDraftInfo.getDraftECDSStatus() == ECDSBillStatusEnum.MDSZTXYQS || commercialDraftInfo.getDraftECDSStatus() == ECDSBillStatusEnum.HGSZTXYYSHJZR || commercialDraftInfo.getDraftECDSStatus() == ECDSBillStatusEnum.HGSZTXSHYQS || commercialDraftInfo.getDraftECDSStatus() == ECDSBillStatusEnum.ZYJCYQS || commercialDraftInfo.getDraftECDSStatus() == ECDSBillStatusEnum.YHMPYQS;
    }

    public boolean useScrollPane() {
        return true;
    }

    public int getVerticalScrollPolicy() {
        return 22;
    }

    public int getHorizontalScrollPolicy() {
        return 32;
    }

    @Override
    public void loadFields() {
        super.loadFields();
        if (this.editData != null && this.editData.getCommercialDraft() != null && this.editData.getCommercialDraft().getDraftAmount() != null) {
            this.txtdraftAmountToUpper.setText(GlUtils.getChineseFormat((BigDecimal)this.editData.getCommercialDraft().getDraftAmount(), (boolean)true, (Locale)LocaleUtils.locale_L2));
        }
        try {
            this.actionRecourse.setEnabled(DraftStockBillFactory.getRemoteInstance().isShowRecourse((IObjectPK)new ObjectUuidPK(this.editData.getId().toString())));
            HashSet<BOSUuid> set = new HashSet<BOSUuid>();
            set.add(this.editData.getId());
            this.actionEndorsement.setEnabled(DraftStockBillFactory.getRemoteInstance().isShowEndorsement(set));
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add("*");
            sic.add("draftBackSide.*");
            CommercialDraftInfo info = CommercialDraftFactory.getRemoteInstance().getCommercialDraftInfo((IObjectPK)new ObjectStringPK(this.editData.getCommercialDraft().getId().toString()), sic);
            CommercialDraftBackSideEntryCollection backColl = info.getDraftBackSide();
            for (int i = 0; i < backColl.size(); ++i) {
                CommercialDraftBackSideEntryInfo backInfo = backColl.get(i);
                if (backInfo.getDraftBizType() == DraftBizTypeEnum.CHENGDUI) {
                    StockBillAccptEntryInfo acctEntryInfo = StockBillAccptEntryFactory.getRemoteInstance().getStockBillAccptEntryInfo("where parent = '" + backInfo.getId() + "'");
                    this.txtcontractNumber.setText(acctEntryInfo.getContractNumber());
                    this.txtacceptorCdtBody.setText(acctEntryInfo.getAccptCdtRater());
                    this.txtacceptorCreditRat.setText(acctEntryInfo.getAccptCredieRate());
                    this.pkacceptorCdtDate.setValue((Object)acctEntryInfo.getAccptRtDueDate());
                    this.pkacceptorDate.setValue((Object)backInfo.getDraftSignInDate());
                }
                if (backInfo.getDraftBizType() != DraftBizTypeEnum.BAOZHENG || !info.getDrawerName().equals(backInfo.getFormerName())) continue;
                this.prmtassurersName.setValue((Object)backInfo.getLaterName());
                this.prmtassurerAccount.setValue((Object)backInfo.getLaterAccount());
                this.prmtassurerBankNumber.setValue((Object)backInfo.getLaterBank());
                this.txtassurerAddress.setText(backInfo.getGuarnteeAddress());
                this.pkassurDate.setValue((Object)backInfo.getDraftSignInDate());
            }
            if (this.editData != null && this.editData.getId() != null) {
                if (this.checkBill(this.editData.getId().toString())) {
                    this.actionPresent.setEnabled(true);
                } else {
                    this.actionPresent.setEnabled(false);
                }
            } else {
                this.actionPresent.setEnabled(false);
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
        this.initOldData((IObjectValue)this.editData);
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    protected void initWorkButton() {
        super.initWorkButton();
        this.actionAudit.setVisible(false);
        this.ActionUnAudit.setVisible(false);
        this.btnBackSideInfoQuery.setIcon(EASResource.getIcon((String)"imgTbtn_sequencecheck"));
        this.menuItemBackQuery.setIcon(EASResource.getIcon((String)"imgTbtn_sequencecheck"));
        this.menuItemEndorsement.setIcon(EASResource.getIcon((String)"imgTbtn_nocollate"));
        this.btnEndorsement.setIcon(EASResource.getIcon((String)"imgTbtn_nocollate"));
        this.btnDiscount.setIcon(EASResource.getIcon((String)"imgTbtn_attemper"));
        this.btnPresent.setIcon(EASResource.getIcon((String)"imgTbtn_requite"));
        this.menuItemPresent.setIcon(EASResource.getIcon((String)"imgTbtn_requite"));
        this.btnOverDuePresent.setIcon(EASResource.getIcon((String)"imgTbtn_recieversetting"));
        this.menuItemOverDuePresent.setIcon(EASResource.getIcon((String)"imgTbtn_recieversetting"));
        this.btnRecourse.setIcon(EASResource.getIcon((String)"imgTbtn_move"));
        this.menuItemRecourse.setIcon(EASResource.getIcon((String)"imgTbtn_move"));
        this.btnCollateral.setIcon(EASResource.getIcon((String)"imgTbtn_archive"));
        this.menuItemCollater.setIcon(EASResource.getIcon((String)"imgTbtn_archive"));
        HashMap actionMap = this.getActionManager().getActionSet();
        actionMap.remove(new String("actionFirst"));
        actionMap.remove(new String("actionPre"));
        actionMap.remove(new String("actionNext"));
        actionMap.remove(new String("actionLast"));
        actionMap.remove(new String("actionPrint"));
        actionMap.remove(new String("actionPrintPreview"));
        actionMap.remove("actionMsgFormat");
        actionMap.remove("actionView");
        actionMap.remove("actionQuery");
        actionMap.remove("actionPrint");
        actionMap.remove("ActionKnowStore");
        actionMap.remove("ActionAnswer");
        actionMap.remove("ActionRemoteAssist");
        actionMap.remove("actionSendMessage");
        actionMap.remove("actionCalculator");
        actionMap.remove("actionExitCurrent");
        actionMap.remove("actionHelp");
        actionMap.remove("actionRegProduct");
        actionMap.remove("actionPersonalSite");
        actionMap.remove("actionProcductVal");
        actionMap.remove("actionAbout");
        actionMap.remove("actionWorkFlowG");
        actionMap.remove("actionWorkflowList");
        actionMap.remove("actionMultiapprove");
        actionMap.remove("actionNextPerson");
        actionMap.remove("actionSendingMessage");
        ItemAction[] itemAction = new ItemAction[actionMap.size()];
        Iterator itor = actionMap.keySet().iterator();
        int i = 0;
        while (itor.hasNext()) {
            ItemAction action;
            itemAction[i] = action = this.getActionManager().getAction(itor.next().toString());
            ++i;
        }
        FMClientHelper.setActionVisible((ItemAction[])itemAction, (boolean)false);
        this.btnWorkFlowG.setVisible(false);
        this.btnMultiapprove.setVisible(false);
        this.btnNextPerson.setVisible(false);
        this.actionRecourse.setEnabled(true);
        this.actionCollateral.setEnabled(true);
        this.actionOverDuePresent.setEnabled(true);
        this.actionPresent.setEnabled(true);
        this.actionDiscount.setEnabled(true);
        this.actionEndorsement.setEnabled(true);
        this.actionBackSideInfoQuery.setEnabled(true);
        if (this.getUIContext().get("company") != null) {
            this.actionRecourse.setVisible(false);
            this.actionCollateral.setVisible(false);
            this.actionOverDuePresent.setVisible(false);
            this.actionPresent.setVisible(false);
            this.actionDiscount.setVisible(false);
            this.actionEndorsement.setVisible(false);
            this.actionBackSideInfoQuery.setVisible(false);
        } else {
            this.actionRecourse.setVisible(true);
            this.actionCollateral.setVisible(true);
            this.actionOverDuePresent.setVisible(true);
            this.actionPresent.setVisible(true);
            this.actionDiscount.setVisible(false);
            this.actionEndorsement.setVisible(true);
            this.actionBackSideInfoQuery.setVisible(true);
        }
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return DraftStockBillFactory.getRemoteInstance();
    }

    @Override
    protected IObjectValue createNewData() {
        DraftStockBillInfo objectValue = new DraftStockBillInfo();
        objectValue.setCompany(SysContext.getSysContext().getCurrentFIUnit());
        objectValue.setCreator((UserInfo)SysContext.getSysContext().getCurrentUser());
        return objectValue;
    }

    @Override
    public void actionRecourse_actionPerformed(ActionEvent e) throws Exception {
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"stockBillID", (Object)this.editData.getId().toString());
        IUIWindow uiWindow = null;
        uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(DraftRecourseBillEditUI.class.getName(), (Map)uiContext, null, OprtState.ADDNEW);
        uiWindow.show();
        this.loadFields();
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sel = super.getSelectors();
        sel.add(new SelectorItemInfo("*"));
        sel.add(new SelectorItemInfo("commercialDraft.*"));
        return sel;
    }

    @Override
    public void actionBackSideInfoQuery_actionPerformed(ActionEvent e) throws Exception {
        UIContext uiContext = new UIContext((Object)this);
        DraftStockBillInfo info = (DraftStockBillInfo)this.getBizInterface().getValue((IObjectPK)new ObjectUuidPK(this.editData.getId()));
        uiContext.put((Object)"targetDraftBillID", (Object)info.getCommercialDraft().getId().toString());
        uiContext.put((Object)"ID", (Object)info.getCommercialDraft().getId().toString());
        IUIWindow uiWindow = null;
        uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(DraftStockBackSideUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
        uiWindow.show();
    }

    @Override
    public void actionEndorsement_actionPerformed(ActionEvent e) throws Exception {
        ArrayList<BOSUuid> list = new ArrayList<BOSUuid>();
        list.add(this.editData.getId());
        Set set = DraftStockBillFactory.getRemoteInstance().endorsement(FMHelper.list2Set(list));
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"set", (Object)set);
        IUIWindow uiWindow = null;
        uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(EndorsementTransferUI.class.getName(), (Map)uiContext, null, OprtState.ADDNEW);
        uiWindow.show();
        this.loadFields();
    }

    @Override
    public void actionCollateral_actionPerformed(ActionEvent e) throws Exception {
        if (this.editData.getId() == null) {
            return;
        }
        HashSet<BOSUuid> set = new HashSet<BOSUuid>();
        set.add(this.editData.getId());
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"billID", (Object)this.editData.getId());
        IUIWindow uiWindow = null;
        SelectorItemCollection sc = new SelectorItemCollection();
        sc.add(new SelectorItemInfo("*"));
        sc.add(new SelectorItemInfo("commercialDraft.*"));
        DraftStockBillInfo stockInfo = DraftStockBillFactory.getRemoteInstance().getDraftStockBillInfo((IObjectPK)new ObjectUuidPK(this.editData.getId()), sc);
        if (stockInfo.getCommercialDraft() != null) {
            this.status = this.collateralStatus(stockInfo.getCommercialDraft());
        }
        if (this.status && stockInfo.getDraftStockOperate().equals((Object)DraftStockBillOperateEnum.REGISTER) && !stockInfo.isCollateral() && !stockInfo.isRecourse() && stockInfo.isIsAttorn()) {
            uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(DraftCollateralizationRequestEditUI.class.getName(), (Map)uiContext, null, OprtState.ADDNEW);
            uiWindow.show();
        } else {
            StringBuffer message = new StringBuffer();
            message.append("1.\u7535\u7968\u72b6\u6001\u4e3a:\u63d0\u793a\u6536\u7968\u5df2\u7b7e\u6536\u3001\u8f6c\u8ba9\u80cc\u4e66\u5df2\u7b7e\u6536\u3001\u4e70\u65ad\u5f0f\u8d34\u73b0\u5df2\u7b7e\u6536\u3001\u56de\u8d2d\u5f0f\u8d34\u73b0\u5df2\u903e\u8d4e\u56de\u622a\u6b62\u65e5\u3001\u56de\u8d2d\u5f0f\u8d34\u73b0\u8d4e\u56de\u5df2\u7b7e\u6536\u3001\u4e70\u65ad\u5f0f\u8f6c\u8d34\u73b0\u5df2\u7b7e\u6536\u3001\u56de\u8d2d\u5f0f\u8f6c\u8d34\u73b0\u5df2\u903e\u8d4e\u56de\u622a\u6b62\u65e5\u3001\u56de\u8d2d\u5f0f\u8f6c\u8d34\u73b0\u8d4e\u56de\u5df2\u7b7e\u6536\u3001\u4e70\u65ad\u5f0f\u518d\u8d34\u73b0\u5df2\u7b7e\u6536\u3001\u56de\u8d2d\u5f0f\u518d\u8d34\u73b0\u5df2\u903e\u8d4e\u56de\u622a\u6b62\u65e5\u3001\u56de\u8d2d\u5f0f\u518d\u8d34\u73b0\u8d4e\u56de\u5df2\u7b7e\u6536\u3001\u8d28\u62bc\u89e3\u9664\u5df2\u7b7e\u6536\u3001\u592e\u884c\u5356\u7968\u5df2\u7b7e\u6536;").append("\r\n");
            message.append("2.\u64cd\u4f5c\u72b6\u6001=\"\u767b\u8bb0\";").append("\r\n");
            message.append("3.\u8d28\u62bc=\u5426;").append("\r\n");
            message.append("4.\u8ffd\u7d22=\u5426;").append("\r\n");
            message.append("5.\u5141\u8bb8\u8f6c\u8ba9=\u662f;").append("\r\n");
            message.append("\u540c\u65f6\u6ee1\u8db3\u4ee5\u4e0a5\u70b9\u624d\u80fd\u505a\u8d28\u62bc").append("\r\n");
            MsgBox.showDetailAndOK((Component)((Object)this), (String)"\u6b64\u5355\u4e0d\u80fd\u505a\u8d28\u62bc!", (String)message.toString(), (int)5);
        }
    }

    @Override
    public void actionPresent_actionPerformed(ActionEvent e) throws Exception {
        if (this.editData.getId() == null) {
            return;
        }
        String id = this.editData.getId().toString();
        HashSet<String> setId = new HashSet<String>();
        setId.add(id);
        Set set = DraftStockBillFactory.getRemoteInstance().toPromptPayment(setId);
        if (set != null && set.size() > 0) {
            UIContext ctx = new UIContext((Object)this);
            ctx.put((Object)"set", (Object)set);
            IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(DraftPromptPaymentBillEditUI1.class.getName(), (Map)ctx, null, OprtState.ADDNEW);
            uiWindow.show();
        } else {
            MsgBox.showWarning((String)"\u8be5\u5e93\u5b58\u7968\u636e\u4e0d\u6ee1\u8db3\u63d0\u793a\u4ed8\u6b3e\u6761\u4ef6\uff01");
            SysUtil.abort();
        }
    }

    protected void enableBaseActions() {
        if (GlUtils.isCompanyUnion((CompanyOrgUnitInfo)SysContext.getSysContext().getCurrentFIUnit())) {
            HashMap actionMap = this.getActionManager().getActionSet();
            actionMap.remove(new String("actionView"));
            actionMap.remove(new String("actionQuery"));
            actionMap.remove(new String("actionPrint"));
            actionMap.remove(new String("actionPrintPreview"));
            actionMap.remove(new String("actionNext"));
            actionMap.remove(new String("actionLast"));
            actionMap.remove(new String("actionFirst"));
            actionMap.remove(new String("actionPre"));
            ItemAction[] itemAction = new ItemAction[actionMap.size()];
            Iterator itor = actionMap.keySet().iterator();
            int i = 0;
            while (itor.hasNext()) {
                ItemAction action;
                itemAction[i] = action = this.getActionManager().getAction(itor.next().toString());
                ++i;
            }
            FMClientHelper.setActionVisible((ItemAction[])itemAction, (boolean)false);
            this.btnAudit.setVisible(false);
            this.btnUnAudit.setVisible(false);
        }
    }

    private boolean checkBill(String id) throws Exception {
        boolean flag = false;
        DraftStockBillInfo billInfo = this.getBillInfo(id);
        if (billInfo.getCommercialDraft().getDraftECDSStatus() != null && billInfo.getCommercialDraft().getDueDate() != null && billInfo.getDraftStockOperate() != null && !billInfo.isPresent()) {
            Date date = billInfo.getCommercialDraft().getDueDate();
            Date nowDate = new Date();
            int days = (int)((nowDate.getTime() - date.getTime()) / 86400000L);
            ECDSBillStatusEnum state = billInfo.getCommercialDraft().getDraftECDSStatus();
            if (days - 10 <= 0 && billInfo.getDraftStockOperate().equals((Object)DraftStockBillOperateEnum.REGISTER) && (state.equals((Object)ECDSBillStatusEnum.TSSPYQS) || state.equals((Object)ECDSBillStatusEnum.BSYQS) || state.equals((Object)ECDSBillStatusEnum.MDSTXYQS) || state.equals((Object)ECDSBillStatusEnum.HGSTXSHYQS) || state.equals((Object)ECDSBillStatusEnum.HGSTXYYSHJZR) || state.equals((Object)ECDSBillStatusEnum.MDSZHTXYQS) || state.equals((Object)ECDSBillStatusEnum.HGSZHTXSHYQS) || state.equals((Object)ECDSBillStatusEnum.HGSZHTXYYSHJZR) || state.equals((Object)ECDSBillStatusEnum.MDSZTXYQS) || state.equals((Object)ECDSBillStatusEnum.HGSZTXSHYQS) || state.equals((Object)ECDSBillStatusEnum.HGSZTXYYSHJZR) || state.equals((Object)ECDSBillStatusEnum.ZYJCYQS) || state.equals((Object)ECDSBillStatusEnum.ZYYZPJDQR) || state.equals((Object)ECDSBillStatusEnum.TSFKYJF3) || state.equals((Object)ECDSBillStatusEnum.TSFKYJF2) || state.equals((Object)ECDSBillStatusEnum.YHMPYQS))) {
                flag = true;
            }
        }
        return flag;
    }

    @Override
    public void actionOverDuePresent_actionPerformed(ActionEvent e) throws Exception {
        if (this.editData.getId() == null) {
            return;
        }
        String id = this.editData.getId().toString();
        DraftStockBillInfo billInfo = this.getBillInfo(id);
        if (!this.checkOverdueBill(billInfo)) {
            MsgBox.showWarning((String)"\u6240\u9009\u62e9\u7684\u8bb0\u5f55\u4e0d\u6ee1\u8db3\u903e\u671f\u63d0\u793a\u4ed8\u6b3e\u6761\u4ef6\uff01");
            SysUtil.abort();
        }
        UIContext ctx = new UIContext((Object)this);
        if (billInfo == null || billInfo.equals("")) {
            MsgBox.showWarning((String)"\u6240\u9009\u62e9\u7684\u8bb0\u5f55\u90fd\u4e0d\u7b26\u5408\u903e\u671f\u63d0\u793a\u4ed8\u6b3e\u6761\u4ef6\uff01");
            SysUtil.abort();
        } else {
            ctx.put((Object)"draftStockBillInfo", (Object)billInfo);
            IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(DraftOverdueClewPaymentBillEditUI.class.getName(), (Map)ctx, null, OprtState.ADDNEW);
            uiWindow.show();
        }
    }

    private boolean checkOverdueBill(DraftStockBillInfo billInfo) throws EASBizException, BOSException, Exception {
        boolean flag = false;
        if (!(billInfo.getCommercialDraft().getDraftECDSStatus() == null || billInfo.getCommercialDraft().getDueDate() == null || billInfo.getDraftStockOperate() == null || billInfo.isPresent() || billInfo.isCollateral() || billInfo.isRecourse())) {
            Date date = billInfo.getCommercialDraft().getDueDate();
            Date beforeDate = new Date(date.getTime() + 864000000L);
            Date nowDate = new Date();
            int days_time = (int)((beforeDate.getTime() - nowDate.getTime()) / 86400000L);
            ECDSBillStatusEnum state = billInfo.getCommercialDraft().getDraftECDSStatus();
            if (days_time < 0) {
                if (billInfo.getDraftStockOperate().equals((Object)DraftStockBillOperateEnum.REGISTER) && (state.equals((Object)ECDSBillStatusEnum.TSSPYQS) || state.equals((Object)ECDSBillStatusEnum.BSYQS) || state.equals((Object)ECDSBillStatusEnum.MDSTXYQS) || state.equals((Object)ECDSBillStatusEnum.HGSTXSHYQS) || state.equals((Object)ECDSBillStatusEnum.HGSTXYYSHJZR) || state.equals((Object)ECDSBillStatusEnum.MDSZHTXYQS) || state.equals((Object)ECDSBillStatusEnum.HGSZHTXSHYQS) || state.equals((Object)ECDSBillStatusEnum.HGSZHTXYYSHJZR) || state.equals((Object)ECDSBillStatusEnum.MDSZTXYQS) || state.equals((Object)ECDSBillStatusEnum.HGSZTXSHYQS) || state.equals((Object)ECDSBillStatusEnum.HGSZTXYYSHJZR) || state.equals((Object)ECDSBillStatusEnum.ZYJCYQS) || state.equals((Object)ECDSBillStatusEnum.ZYYZPJDQR) || state.equals((Object)ECDSBillStatusEnum.TSFKYJF3) || state.equals((Object)ECDSBillStatusEnum.TSFKYJF2) || state.equals((Object)ECDSBillStatusEnum.YHMPYQS) || state.equals((Object)ECDSBillStatusEnum.TSFKYJF1) || state.equals((Object)ECDSBillStatusEnum.YQTSFKYJF2) || state.equals((Object)ECDSBillStatusEnum.YQTSFKYJF1) || state.equals((Object)ECDSBillStatusEnum.YHMPYQS))) {
                    flag = true;
                }
                this.btnOverDuePresent.setEnabled(true);
            }
        }
        this.btnOverDuePresent.setEnabled(false);
        return flag;
    }

    private DraftStockBillInfo getBillInfo(String id) throws EASBizException, BOSException, Exception {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("commercialDraft.*"));
        sic.add(new SelectorItemInfo("commercialDraft.draftECDSStatus"));
        sic.add(new SelectorItemInfo("present"));
        sic.add(new SelectorItemInfo("draftStockOperate"));
        sic.add(new SelectorItemInfo("commercialDraft.dueDate"));
        sic.add(new SelectorItemInfo("holderAccount.*"));
        sic.add(new SelectorItemInfo("holderBankNumber.*"));
        sic.add(new SelectorItemInfo("CommercialDraft.AcceptorName"));
        sic.add(new SelectorItemInfo("CommercialDraft.AcceptorAccountNumber"));
        sic.add(new SelectorItemInfo("CommercialDraft.AcceptorBankNumber"));
        DraftStockBillInfo billInfo = ((IDraftStockBill)this.getBizInterface()).getDraftStockBillInfo((IObjectPK)new ObjectUuidPK(id), sic);
        return billInfo;
    }
}

