/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.edrafent.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.data.event.RequestRowSetEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.client.FMFilterBaseUI;
import com.kingdee.eas.fm.ecore.ECDSBillStatusEnum;
import com.kingdee.eas.fm.edraf.util.EdrafUtil;
import com.kingdee.eas.fm.edrafent.CommercialDraftFactory;
import com.kingdee.eas.fm.edrafent.CommercialDraftInfo;
import com.kingdee.eas.fm.edrafent.DraftStockBillFactory;
import com.kingdee.eas.fm.edrafent.DraftStockBillInfo;
import com.kingdee.eas.fm.edrafent.DraftStockBillOperateEnum;
import com.kingdee.eas.fm.edrafent.IDraftStockBill;
import com.kingdee.eas.fm.edrafent.client.AbstractDraftStockBillListUI;
import com.kingdee.eas.fm.edrafent.client.DraftCollateralizationRequestEditUI;
import com.kingdee.eas.fm.edrafent.client.DraftOverdueClewPaymentBillEditUI;
import com.kingdee.eas.fm.edrafent.client.DraftPromptPaymentBillEditUI1;
import com.kingdee.eas.fm.edrafent.client.DraftRecourseBillEditUI;
import com.kingdee.eas.fm.edrafent.client.DraftStockBackSideUI;
import com.kingdee.eas.fm.edrafent.client.DraftStockBillEditUI;
import com.kingdee.eas.fm.edrafent.client.DraftStockBillFilterUI;
import com.kingdee.eas.fm.edrafent.client.EndorsementTransferUI;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class DraftStockBillListUI
extends AbstractDraftStockBillListUI {
    private static final Logger logger = CoreUIObject.getLogger(DraftStockBillListUI.class);
    private DraftStockBillFilterUI filterUI = null;
    private String type = "%r-[ ]0.2n";
    FillListener fillListener = new FillListener();

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.actionAudit.setVisible(false);
        this.ActionUnAudit.setVisible(false);
        this.actionFinanceCompany.setVisible(false);
        this.actionBankCorporate.setVisible(false);
        this.btnBackSideInfoQuery.setIcon(EASResource.getIcon((String)"imgTbtn_sequencecheck"));
        this.menuItemBackQuery.setIcon(EASResource.getIcon((String)"imgTbtn_sequencecheck"));
        this.actionBackSideInfoQuery.setEnabled(true);
        this.actionEndorsement.setEnabled(false);
        this.btnEndorsement.setIcon(EASResource.getIcon((String)"imgTbtn_nocollate"));
        this.mentItemEndorsement.setIcon(EASResource.getIcon((String)"imgTbtn_nocollate"));
        this.actionDiscount.setEnabled(true);
        this.btnDiscount.setIcon(EASResource.getIcon((String)"imgTbtn_attemper"));
        this.actionPresent.setEnabled(true);
        this.btnPresent.setIcon(EASResource.getIcon((String)"imgTbtn_requite"));
        this.menuItemPresent.setIcon(EASResource.getIcon((String)"imgTbtn_requite"));
        this.btnOverDuePresent.setIcon(EASResource.getIcon((String)"imgTbtn_recieversetting"));
        this.menuItemOverDuePresent.setIcon(EASResource.getIcon((String)"imgTbtn_recieversetting"));
        this.btnRecourse.setIcon(EASResource.getIcon((String)"imgTbtn_move"));
        this.menuItemRecourse.setIcon(EASResource.getIcon((String)"imgTbtn_move"));
        this.actionCollateral.setEnabled(true);
        this.btnCollateral.setIcon(EASResource.getIcon((String)"imgTbtn_archive"));
        this.menuItemCollater.setIcon(EASResource.getIcon((String)"imgTbtn_archive"));
        this.actionEdit.setVisible(false);
        this.actionRemove.setVisible(false);
        this.actionAddNew.setVisible(false);
        this.ActionSubmit.setVisible(false);
        this.btnPresent.setEnabled(true);
        this.btnPresent.setIcon(EASResource.getIcon((String)"imgTbtn_payment"));
        this.menuItemPresent.setIcon(EASResource.getIcon((String)"imgTbtn_payment"));
        this.btnPresent.setVisible(true);
        this.actionPresent.setEnabled(true);
        this.btnDiscount.setVisible(false);
        this.actionDiscount.setVisible(false);
        this.actionCreateTo.setVisible(false);
        this.actionCopyTo.setVisible(false);
    }

    @Override
    public void onLoad() throws Exception {
        super.onLoad();
        this.tblMain.checkParsed();
        this.initListener();
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        super.tblMain_tableClicked(e);
        ArrayList billID = this.getSelectedIdValues();
        if (billID == null) {
            return;
        }
        boolean flag = DraftStockBillFactory.getRemoteInstance().isShowEndorsement(FMHelper.list2Set((List)billID));
        this.actionEndorsement.setEnabled(flag);
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return DraftStockBillFactory.getRemoteInstance();
    }

    protected String getKeyFieldName() {
        return "id";
    }

    @Override
    protected IObjectValue createNewData() {
        DraftStockBillInfo objectValue = new DraftStockBillInfo();
        objectValue.setCompany(SysContext.getSysContext().getCurrentFIUnit());
        return objectValue;
    }

    @Override
    public FMFilterBaseUI getFilterUI() throws Exception {
        if (null == this.filterUI) {
            this.filterUI = new DraftStockBillFilterUI();
        }
        return this.filterUI;
    }

    @Override
    protected boolean isFootVisible() {
        return true;
    }

    @Override
    protected void enableBaseActions() {
        super.enableBaseActions();
        if (!this.validateCompany()) {
            this.btnVoucher.setVisible(true);
            this.btnDelVoucher.setVisible(true);
            this.btnDelVoucher.setEnabled(true);
            this.btnVoucher.setEnabled(true);
            this.btnDelVoucher.setEnabled(true);
            this.actionWorkFlowG.setVisible(true);
            this.menuItemVoucher.setVisible(true);
            this.menuItemDelVoucher.setVisible(true);
            this.actionVoucher.setVisible(true);
            this.actionDelVoucher.setVisible(true);
            this.actionVoucher.setEnabled(true);
            this.actionDelVoucher.setEnabled(true);
        }
    }

    @Override
    public void actionBackSideInfoQuery_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList idList = this.getSelectedIdValues();
        UIContext uiContext = new UIContext((Object)this);
        DraftStockBillInfo info = (DraftStockBillInfo)this.getBizInterface().getValue((IObjectPK)new ObjectUuidPK(idList.get(0).toString()));
        uiContext.put((Object)"targetDraftBillID", (Object)info.getCommercialDraft().getId().toString());
        uiContext.put((Object)"ID", (Object)info.getCommercialDraft().getId().toString());
        IUIWindow uiWindow = null;
        uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(DraftStockBackSideUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
        uiWindow.show();
        this.refreshList();
    }

    protected void tblMain_tableSelectChanged(KDTSelectEvent e) throws Exception {
        super.tblMain_tableSelectChanged(e);
        DraftStockBillInfo billInfo = null;
        ArrayList billID = this.getSelectedIdValues();
        if (billID == null) {
            return;
        }
        boolean flag = DraftStockBillFactory.getRemoteInstance().isShowEndorsement(FMHelper.list2Set((List)billID));
        this.actionEndorsement.setEnabled(flag);
        if (billID.size() == 1) {
            ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)billID.get(0).toString()));
            SelectorItemCollection sc = new SelectorItemCollection();
            sc.add(new SelectorItemInfo("id"));
            sc.add(new SelectorItemInfo("commercialDraft"));
            sc.add(new SelectorItemInfo("commercialDraft.*"));
            sc.add(new SelectorItemInfo("*"));
            CoreBaseInfo o = this.getBizInterface().getValue((IObjectPK)pk, sc);
            billInfo = (DraftStockBillInfo)o;
            CommercialDraftInfo commercialDraftInfo = CommercialDraftFactory.getRemoteInstance().getCommercialDraftInfo((IObjectPK)new ObjectUuidPK(billInfo.getCommercialDraft().getId()));
            boolean status = this.collateralStatus(commercialDraftInfo);
            if (status && billInfo.getDraftStockOperate().equals((Object)DraftStockBillOperateEnum.REGISTER) && !billInfo.isCollateral() && !billInfo.isRecourse() && billInfo.isIsAttorn()) {
                this.btnCollateral.setEnabled(true);
                this.menuItemCollater.setEnabled(true);
            } else {
                this.btnCollateral.setEnabled(false);
                this.menuItemCollater.setEnabled(false);
            }
            this.actionRecourse.setEnabled(DraftStockBillFactory.getRemoteInstance().isShowRecourse((IObjectPK)pk));
            if (this.checkBill(billID.get(0).toString())) {
                this.actionPresent.setEnabled(true);
            } else {
                this.actionPresent.setEnabled(false);
            }
        } else {
            this.btnCollateral.setEnabled(false);
            this.menuItemCollater.setEnabled(false);
            this.actionPresent.setEnabled(true);
        }
        this.checkOverdueBill(billInfo);
    }

    private boolean checkBill(String id) throws Exception {
        boolean flag = false;
        DraftStockBillInfo billInfo = this.getBillInfo(id);
        if (billInfo.getCommercialDraft().getDraftECDSStatus() != null && billInfo.getCommercialDraft().getDueDate() != null && billInfo.getDraftStockOperate() != null && !billInfo.isPresent()) {
            Date date = billInfo.getCommercialDraft().getDueDate();
            Date nowDate = new Date();
            int days = (int)((nowDate.getTime() - date.getTime()) / 86400000L);
            ECDSBillStatusEnum state = billInfo.getCommercialDraft().getDraftECDSStatus();
            if (days - 10 <= 0 && billInfo.getDraftStockOperate().equals((Object)DraftStockBillOperateEnum.REGISTER) && (state.equals((Object)ECDSBillStatusEnum.TSSPYQS) || state.equals((Object)ECDSBillStatusEnum.BSYQS) || state.equals((Object)ECDSBillStatusEnum.MDSTXYQS) || state.equals((Object)ECDSBillStatusEnum.HGSTXSHYQS) || state.equals((Object)ECDSBillStatusEnum.HGSTXYYSHJZR) || state.equals((Object)ECDSBillStatusEnum.MDSZHTXYQS) || state.equals((Object)ECDSBillStatusEnum.HGSZHTXSHYQS) || state.equals((Object)ECDSBillStatusEnum.HGSZHTXYYSHJZR) || state.equals((Object)ECDSBillStatusEnum.MDSZTXYQS) || state.equals((Object)ECDSBillStatusEnum.HGSZTXSHYQS) || state.equals((Object)ECDSBillStatusEnum.HGSZTXYYSHJZR) || state.equals((Object)ECDSBillStatusEnum.ZYJCYQS) || state.equals((Object)ECDSBillStatusEnum.ZYYZPJDQR) || state.equals((Object)ECDSBillStatusEnum.TSFKYJF3) || state.equals((Object)ECDSBillStatusEnum.TSFKYJF2) || state.equals((Object)ECDSBillStatusEnum.YHMPYQS))) {
                flag = true;
            }
        }
        return flag;
    }

    public boolean collateralStatus(CommercialDraftInfo commercialDraftInfo) {
        return commercialDraftInfo.getDraftECDSStatus() == ECDSBillStatusEnum.TSSPYQS || commercialDraftInfo.getDraftECDSStatus() == ECDSBillStatusEnum.BSYQS || commercialDraftInfo.getDraftECDSStatus() == ECDSBillStatusEnum.MDSTXYQS || commercialDraftInfo.getDraftECDSStatus() == ECDSBillStatusEnum.HGSTXYYSHJZR || commercialDraftInfo.getDraftECDSStatus() == ECDSBillStatusEnum.HGSTXSHYQS || commercialDraftInfo.getDraftECDSStatus() == ECDSBillStatusEnum.MDSZHTXYQS || commercialDraftInfo.getDraftECDSStatus() == ECDSBillStatusEnum.HGSZHTXYYSHJZR || commercialDraftInfo.getDraftECDSStatus() == ECDSBillStatusEnum.HGSZHTXSHYQS || commercialDraftInfo.getDraftECDSStatus() == ECDSBillStatusEnum.MDSZTXYQS || commercialDraftInfo.getDraftECDSStatus() == ECDSBillStatusEnum.HGSZTXYYSHJZR || commercialDraftInfo.getDraftECDSStatus() == ECDSBillStatusEnum.HGSZTXSHYQS || commercialDraftInfo.getDraftECDSStatus() == ECDSBillStatusEnum.ZYJCYQS || commercialDraftInfo.getDraftECDSStatus() == ECDSBillStatusEnum.YHMPYQS;
    }

    @Override
    public void actionCollateral_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String billID = this.getSelectedKeyValue();
        if (billID == null) {
            return;
        }
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"billID", (Object)billID);
        IUIWindow uiWindow = null;
        uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(DraftCollateralizationRequestEditUI.class.getName(), (Map)uiContext, null, OprtState.ADDNEW);
        uiWindow.show();
        this.refreshList();
    }

    @Override
    public void actionDiscount_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
    }

    @Override
    public void actionEndorsement_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList billID = this.getSelectedIdValues();
        if (billID == null) {
            return;
        }
        Set set = DraftStockBillFactory.getRemoteInstance().endorsement(FMHelper.list2Set((List)billID));
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"set", (Object)set);
        IUIWindow uiWindow = null;
        uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(EndorsementTransferUI.class.getName(), (Map)uiContext, null, OprtState.ADDNEW);
        uiWindow.show();
        this.refreshList();
    }

    @Override
    public void actionOverduePresent_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList list = this.getSelectedIdValues();
        if (list != null && list.size() > 0) {
            if (list.size() == 1) {
                String id = this.getSelectedKeyValue();
                DraftStockBillInfo billInfo = this.getBillInfo(id);
                if (!this.checkOverdueBill(billInfo)) {
                    MsgBox.showWarning((String)"\u6240\u9009\u62e9\u7684\u8bb0\u5f55\u4e0d\u6ee1\u8db3\u63d0\u793a\u4ed8\u6b3e\u6761\u4ef6\uff01");
                    SysUtil.abort();
                }
                UIContext ctx = new UIContext((Object)this);
                Set set = DraftStockBillFactory.getRemoteInstance().overdueClewPayment(FMHelper.list2Set((List)list));
                ctx.put((Object)"draftStockBillInfo", (Object)billInfo);
                IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(DraftOverdueClewPaymentBillEditUI.class.getName(), (Map)ctx, null, OprtState.ADDNEW);
                uiWindow.show();
                this.refreshList();
            } else {
                MsgBox.showWarning((String)"\u6240\u9009\u62e9\u7684\u8bb0\u5f55\u90fd\u6ca1\u6709\u7b26\u5408\u63d0\u793a\u4ed8\u6b3e\u6761\u4ef6\uff01");
                SysUtil.abort();
            }
        }
    }

    @Override
    public void actionPresent_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList list = this.getSelectedIdValues();
        if (list != null && list.size() > 0) {
            Set set = DraftStockBillFactory.getRemoteInstance().toPromptPayment(FMHelper.list2Set((List)list));
            if (set != null && set.size() > 0) {
                UIContext ctx = new UIContext((Object)this);
                ctx.put((Object)"set", (Object)set);
                IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(DraftPromptPaymentBillEditUI1.class.getName(), (Map)ctx, null, OprtState.ADDNEW);
                uiWindow.show();
                this.refreshList();
                ctx.put((Object)"set", (Object)set);
            } else {
                MsgBox.showWarning((String)"\u6240\u9009\u62e9\u7684\u8bb0\u5f55\u4e0d\u6ee1\u8db3\u63d0\u793a\u4ed8\u6b3e\u6761\u4ef6\uff01");
                SysUtil.abort();
            }
        }
    }

    @Override
    public void actionRecourse_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList billID = this.getSelectedIdValues();
        if (billID.size() > 1) {
            MsgBox.showWarning((String)"\u4e0d\u5141\u8bb8\u6279\u91cf\u8ffd\u7d22!");
            SysUtil.abort();
        }
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"stockBillID", (Object)this.getSelectedKeyValue());
        IUIWindow uiWindow = null;
        uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(DraftRecourseBillEditUI.class.getName(), (Map)uiContext, null, OprtState.ADDNEW);
        uiWindow.show();
        this.refreshList();
    }

    public void actionDelVoucher_actionPerformed(ActionEvent e) throws Exception {
        super.actionDelVoucher_actionPerformed(e);
    }

    public void actionVoucher_actionPerformed(ActionEvent e) throws Exception {
        super.actionVoucher_actionPerformed(e);
    }

    private DraftStockBillInfo getBillInfo(String id) throws EASBizException, BOSException, Exception {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("commercialDraft.*"));
        sic.add(new SelectorItemInfo("commercialDraft.draftECDSStatus"));
        sic.add(new SelectorItemInfo("present"));
        sic.add(new SelectorItemInfo("draftStockOperate"));
        sic.add(new SelectorItemInfo("commercialDraft.dueDate"));
        sic.add(new SelectorItemInfo("holderAccount.*"));
        sic.add(new SelectorItemInfo("holderBankNumber.*"));
        sic.add(new SelectorItemInfo("CommercialDraft.AcceptorName.*"));
        sic.add(new SelectorItemInfo("CommercialDraft.AcceptorAccountNumber.*"));
        sic.add(new SelectorItemInfo("CommercialDraft.AcceptorBankNumber.*"));
        DraftStockBillInfo billInfo = ((IDraftStockBill)this.getBizInterface()).getDraftStockBillInfo((IObjectPK)new ObjectUuidPK(id), sic);
        return billInfo;
    }

    @Override
    protected boolean isVoucherVisible() {
        return true;
    }

    private boolean checkOverdueBill(DraftStockBillInfo billInfo) throws EASBizException, BOSException, Exception {
        boolean flag = false;
        if (billInfo != null) {
            if (billInfo.getCommercialDraft().getDraftECDSStatus() != null && billInfo.getCommercialDraft().getDueDate() != null && billInfo.getDraftStockOperate().equals((Object)DraftStockBillOperateEnum.REGISTER) && !billInfo.isPresent() && !billInfo.isCollateral() && !billInfo.isRecourse()) {
                Date date = billInfo.getCommercialDraft().getDueDate();
                if (date != null) {
                    Date nowDate = new Date();
                    int days = (int)((nowDate.getTime() - date.getTime()) / 86400000L);
                    ECDSBillStatusEnum state = billInfo.getCommercialDraft().getDraftECDSStatus();
                    if (days - 10 >= 0) {
                        if (billInfo.getDraftStockOperate().equals((Object)DraftStockBillOperateEnum.REGISTER) && (state.equals((Object)ECDSBillStatusEnum.TSSPYQS) || state.equals((Object)ECDSBillStatusEnum.BSYQS) || state.equals((Object)ECDSBillStatusEnum.MDSTXYQS) || state.equals((Object)ECDSBillStatusEnum.HGSTXSHYQS) || state.equals((Object)ECDSBillStatusEnum.HGSTXYYSHJZR) || state.equals((Object)ECDSBillStatusEnum.MDSZHTXYQS) || state.equals((Object)ECDSBillStatusEnum.HGSZHTXSHYQS) || state.equals((Object)ECDSBillStatusEnum.HGSZHTXYYSHJZR) || state.equals((Object)ECDSBillStatusEnum.MDSZTXYQS) || state.equals((Object)ECDSBillStatusEnum.HGSZTXSHYQS) || state.equals((Object)ECDSBillStatusEnum.HGSZTXYYSHJZR) || state.equals((Object)ECDSBillStatusEnum.ZYJCYQS) || state.equals((Object)ECDSBillStatusEnum.ZYYZPJDQR) || state.equals((Object)ECDSBillStatusEnum.TSFKYJF3) || state.equals((Object)ECDSBillStatusEnum.TSFKYJF2) || state.equals((Object)ECDSBillStatusEnum.YHMPYQS) || state.equals((Object)ECDSBillStatusEnum.TSFKYJF1) || state.equals((Object)ECDSBillStatusEnum.YQTSFKYJF2) || state.equals((Object)ECDSBillStatusEnum.YQTSFKYJF1) || state.equals((Object)ECDSBillStatusEnum.YHMPYQS))) {
                            flag = true;
                        }
                        this.btnOverDuePresent.setEnabled(true);
                    }
                }
            } else {
                this.btnOverDuePresent.setEnabled(false);
            }
        }
        return flag;
    }

    protected void tblMain_doRequestRowSet(RequestRowSetEvent e) {
        int state = this.getBOTPViewStatus();
        if (state == 0) {
            CompanyOrgUnitInfo info = this.currentCompanyCommon;
            if (info != null && info.getId() != null) {
                try {
                    if (!EdrafUtil.checkIsFinanceCompany(null, (String)info.getId().toString())) {
                        super.tblMain_doRequestRowSet(e);
                    }
                }
                catch (BOSException e1) {
                    this.handUIException(e1);
                }
            }
        } else {
            super.tblMain_doRequestRowSet(e);
        }
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("commercialDraft.*"));
        sic.add(new SelectorItemInfo("commercialDraft.dueDate"));
        return sic;
    }

    @Override
    public String[] getMergeColumnKeys() {
        return null;
    }

    protected void initListener() {
        super.initListener();
        this.tblMain.getDataRequestManager().addDataFillListener((KDTDataFillListener)this.fillListener);
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String id = this.getSelectedKeyValue();
        UIContext ctx = new UIContext((Object)this);
        ctx.put((Object)"ID", (Object)id);
        int state = this.getBOTPViewStatus();
        ctx.put((Object)"isBotp", (Object)new Integer(state));
        this.prepareUIContext(ctx, e);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewTabFactory").create(DraftStockBillEditUI.class.getName(), (Map)ctx, null, OprtState.VIEW);
        uiWindow.show();
    }

    private final class FillListener
    implements KDTDataFillListener {
        private FillListener() {
        }

        public void afterDataFill(KDTDataRequestEvent e) {
            if (e == null) {
                return;
            }
            StyleAttributes styleAttributes = DraftStockBillListUI.this.tblMain.getColumn("commercialDraft.draftAmount").getStyleAttributes();
            styleAttributes.setNumberFormat(DraftStockBillListUI.this.type);
            styleAttributes.setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
            if (DraftStockBillListUI.this.tblMain.getFootManager() != null && DraftStockBillListUI.this.tblMain.getFootManager().getFootRow(0) != null) {
                StyleAttributes footStyle = DraftStockBillListUI.this.tblMain.getFootManager().getFootRow(0).getCell("commercialDraft.draftAmount").getStyleAttributes();
                footStyle.setNumberFormat(DraftStockBillListUI.this.type);
                footStyle.setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
            }
        }
    }
}

