/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.edrafent.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.AccountBankFactory;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fm.be.BEBankFactory;
import com.kingdee.eas.fm.be.BEBankInfo;
import com.kingdee.eas.fm.edrafent.DrafTypeEnum;
import com.kingdee.eas.fm.edrafent.DraftDiscountReqBillEntryCollection;
import com.kingdee.eas.fm.edrafent.DraftDiscountReqBillEntryInfo;
import com.kingdee.eas.fm.edrafent.DraftStockBillInfo;
import com.kingdee.eas.fm.edrafent.client.AbstractDraftStockF7FilterUI;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.KDTableUtil;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.DateTimeUtils;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.log4j.Logger;

public class DraftStockF7FilterUI
extends AbstractDraftStockF7FilterUI {
    private static final Logger logger = CoreUIObject.getLogger(DraftStockF7FilterUI.class);
    private DraftDiscountReqBillEntryCollection entryCol = null;
    private boolean isCancelOP = true;
    private List listSet = null;

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
    }

    protected boolean isIgnoreCUFilter() {
        return true;
    }

    protected FilterInfo getDefaultFilterForQuery() {
        FilterInfo filter = super.getDefaultFilterForQuery();
        CompanyOrgUnitInfo company = SysContext.getSysContext().getCurrentFIUnit();
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)company.getId(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("commercialDraft.dueDate", (Object)DateTimeUtils.truncateDate((Date)new Date()), CompareType.GREATER));
        filter.getFilterItems().add(new FilterItemInfo("draftKind", (Object)new Integer(0), CompareType.EQUALS));
        return filter;
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.tblMain.getSelectManager().setSelectMode(10);
        this.btnDraftCancel.setEnabled(true);
        this.btnDraftOK.setEnabled(true);
        this.actionDraftCancel.setEnabled(true);
        this.actionDraftOK.setEnabled(true);
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
    }

    @Override
    public void actionDraftOK_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        int[] rowId = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        if (rowId.length > 0) {
            this.entryCol = new DraftDiscountReqBillEntryCollection();
            this.listSet = new ArrayList();
            String holderAccount = null;
            String holderBankNumber = null;
            if (this.getUIContext().get("accountInfo") != null) {
                AccountBankInfo accountInfo = (AccountBankInfo)this.getUIContext().get("accountInfo");
                holderAccount = accountInfo.getBankAccountNumber();
            }
            if (this.getUIContext().get("beInfo") != null) {
                String beInfo;
                holderBankNumber = beInfo = this.getUIContext().get("beInfo").toString();
            }
            if (this.getUIContext().get("accountInfo") == null || this.getUIContext().get("beInfo") == null) {
                String accountId = this.tblMain.getRow(rowId[0]).getCell("holderAccount.id").getValue().toString();
                String bankNumberId = this.tblMain.getRow(rowId[0]).getCell("holderBankNumber.id").getValue().toString();
                AccountBankInfo accoInf = AccountBankFactory.getRemoteInstance().getAccountBankInfo((IObjectPK)new ObjectUuidPK(accountId));
                BEBankInfo beInf = BEBankFactory.getRemoteInstance().getBEBankInfo((IObjectPK)new ObjectUuidPK(bankNumberId));
                this.listSet.add(accoInf);
                this.listSet.add(beInf);
            }
            int n = rowId.length;
            for (int i = 0; i < n; ++i) {
                IRow row = this.tblMain.getRow(rowId[i]);
                String account = null;
                String bankNumber = null;
                if (row.getCell("holderAccount.bankAccountNumber").getValue() != null) {
                    account = row.getCell("holderAccount.bankAccountNumber").getValue().toString();
                }
                if (row.getCell("holderBankNumber.number").getValue() != null) {
                    bankNumber = row.getCell("holderBankNumber.number").getValue().toString();
                }
                if (holderAccount == null) {
                    holderAccount = account;
                } else if (!holderAccount.equals(account)) {
                    this.entryCol = null;
                    MsgBox.showWarning((String)"\u6240\u9009\u62e9\u7684\u8bb0\u5f55\u6301\u7968\u4eba\u8d26\u53f7\u5e94\u8be5\u76f8\u540c\uff01");
                    SysUtil.abort();
                }
                if (holderBankNumber == null) {
                    holderBankNumber = bankNumber;
                } else if (!holderBankNumber.equals(bankNumber)) {
                    this.entryCol = null;
                    MsgBox.showWarning((String)"\u6240\u9009\u62e9\u7684\u8bb0\u5f55\u6301\u7968\u4eba\u5f00\u6237\u884c\u884c\u53f7\u5e94\u8be5\u76f8\u540c\uff01");
                    SysUtil.abort();
                }
                DraftDiscountReqBillEntryInfo entryInfo = new DraftDiscountReqBillEntryInfo();
                DraftStockBillInfo stockInfo = new DraftStockBillInfo();
                stockInfo.setId(BOSUuid.read((String)row.getCell("id").getValue().toString()));
                entryInfo.setDraftStockBill(stockInfo);
                entryInfo.setDraftNumber(row.getCell("commercialDraft.draftNumber").getValue().toString());
                if (row.getCell("commercialDraft.draftType").getValue() != null) {
                    if (row.getCell("commercialDraft.draftType").getValue().toString().equals(DrafTypeEnum.AC02.getAlias())) {
                        entryInfo.setDraftType(DrafTypeEnum.AC02);
                    } else if (row.getCell("commercialDraft.draftType").getValue().toString().equals(DrafTypeEnum.AC01.getAlias())) {
                        entryInfo.setDraftType(DrafTypeEnum.AC01);
                    }
                }
                entryInfo.setDraftAmount((BigDecimal)row.getCell("commercialDraft.draftAmount").getValue());
                entryInfo.setIssuDate((Date)row.getCell("commercialDraft.issueDate").getValue());
                entryInfo.setDueDate((Date)row.getCell("commercialDraft.dueDate").getValue());
                if (row.getCell("commercialDraft.drawerName").getValue() != null) {
                    entryInfo.setDrawerName(row.getCell("commercialDraft.drawerName").getValue().toString());
                }
                if (row.getCell("commercialDraft.acceptorName").getValue() != null) {
                    entryInfo.setAcceptorName(row.getCell("commercialDraft.acceptorName").getValue().toString());
                }
                this.entryCol.add(entryInfo);
            }
            if (this.entryCol.size() > 0) {
                this.isCancelOP = false;
                this.actionExitCurrent_actionPerformed(null);
            }
        }
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.tblMain.getDataRequestManager().addDataFillListener(new KDTDataFillListener(){

            public void afterDataFill(KDTDataRequestEvent e) {
                if (DraftStockF7FilterUI.this.tblMain.getRowCount() > 0) {
                    DraftStockF7FilterUI.this.tblMain.getSelectManager().select(0, 0);
                }
            }
        });
    }

    @Override
    public void actionDraftCancel_actionPerformed(ActionEvent e) throws Exception {
        this.entryCol = null;
        this.actionExitCurrent_actionPerformed(null);
    }

    protected ICoreBase getBizInterface() throws Exception {
        return null;
    }

    protected String getEditUIName() {
        return null;
    }

    public DraftDiscountReqBillEntryCollection getEntryCol() {
        return this.entryCol;
    }

    public List getHolderList() {
        return this.listSet;
    }

    public boolean isCancelOP() {
        return this.isCancelOP;
    }
}

