/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.edrafent.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTPropertyChangeEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTPropertyChangeListener;
import com.kingdee.bos.ctrl.kdf.table.foot.KDTFootManager;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.bot.BOTRelationFactory;
import com.kingdee.bos.metadata.bot.BOTRelationInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.master.cssp.SupplierCompanyBankInfo;
import com.kingdee.eas.basedata.master.cssp.SupplierCompanyInfoInfo;
import com.kingdee.eas.basedata.master.cssp.SupplierFactory;
import com.kingdee.eas.basedata.master.cssp.SupplierInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fm.be.BEBankFactory;
import com.kingdee.eas.fm.be.BEBankInfo;
import com.kingdee.eas.fm.common.CSBankInfo;
import com.kingdee.eas.fm.common.ContextHelperFactory;
import com.kingdee.eas.fm.common.FMBgItemProp;
import com.kingdee.eas.fm.common.FMCommonFacadeFactory;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMClientVerifyHelper;
import com.kingdee.eas.fm.ecore.ECDSBillStatusEnum;
import com.kingdee.eas.fm.edraf.OrgUnitCodeCollection;
import com.kingdee.eas.fm.edraf.OrgUnitCodeFactory;
import com.kingdee.eas.fm.edrafent.DraftEndorsementBillFactory;
import com.kingdee.eas.fm.edrafent.DraftEndorsementBillInfo;
import com.kingdee.eas.fm.edrafent.DraftStockBillInfo;
import com.kingdee.eas.fm.edrafent.DraftStockBillOperateEnum;
import com.kingdee.eas.fm.edrafent.OperateStateEnum;
import com.kingdee.eas.fm.edrafent.client.AbstractEndorsementTransferUI;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.ma.budget.FpCashDirectionEnum;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import org.apache.log4j.Logger;

public class EndorsementTransferUI
extends AbstractEndorsementTransferUI {
    private static final Logger logger = CoreUIObject.getLogger(EndorsementTransferUI.class);
    private Set billSet;

    public EndorsementTransferUI() throws Exception {
        FpCashDirectionEnum[] fp = new FpCashDirectionEnum[]{FpCashDirectionEnum.output, FpCashDirectionEnum.other};
        FMClientHelper.initBgItemF7((KDBizPromptBox)this.prmtbudgetItem, (FpCashDirectionEnum[])fp, (boolean)true, (boolean)true);
        this.prmtByEndorsementName.setDisplayFormat("$name$");
        this.prmtbudgetItem.setRequired(false);
        this.prmtCreator.setDisplayFormat("$name$");
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.actionAuditResult.setVisible(false);
        this.actionAttachment.setVisible(false);
        this.billSet = (Set)this.getUIContext().get("set");
        this.fillData(this.billSet);
        this.tblMain.getStyleAttributes().setLocked(true);
        this.tblMain.getColumn("remark").getStyleAttributes().setLocked(false);
        this.addTablePropertyList(this.tblMain);
        this.apendFootRow(this.tblMain, new String[]{"draftAmount"});
    }

    @Override
    public void loadFields() {
        super.loadFields();
        FMClientHelper.loadFieldsBgItem((KDBizPromptBox)this.prmtbudgetItem, (CoreBaseInfo)this.editData, (FMBgItemProp)this.editData.getBgItemProps()[0]);
        this.initOldData((IObjectValue)this.editData);
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.enableBaseActions();
        this.actionAddNew.setVisible(false);
        this.prmtEndorsementAccount.setEnabled(false);
        this.prmtEndorsementBankNum.setEnabled(false);
        this.prmtEndorsementName.setEnabled(false);
        this.prmtCreator.setEnabled(false);
        this.pkCreateDate.setEnabled(false);
        this.prmtCreateCompany.setEnabled(false);
        this.actionPre.setVisible(false);
        this.actionAuditResult.setVisible(false);
        this.actionNext.setVisible(false);
        this.actionFirst.setVisible(false);
        this.actionLast.setVisible(false);
    }

    @Override
    public void storeFields() {
        super.storeFields();
        FMClientHelper.storeFieldsBgItem((KDBizPromptBox)this.prmtbudgetItem, (CoreBaseInfo)this.editData, (FMBgItemProp)this.editData.getBgItemProps()[0]);
        this.initOldData((IObjectValue)this.editData);
    }

    protected IObjectValue createNewData() {
        return new DraftEndorsementBillInfo();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return DraftEndorsementBillFactory.getRemoteInstance();
    }

    private void setOrgCode(String compayId) throws BOSException {
        EntityViewInfo env = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)compayId));
        filter.getFilterItems().add(new FilterItemInfo("isUsing", (Object)Boolean.TRUE));
        env.getSelector().add("*");
        env.setFilter(filter);
        OrgUnitCodeCollection code = OrgUnitCodeFactory.getRemoteInstance().getOrgUnitCodeCollection(env);
        if (code.size() > 0) {
            this.txtOrgCode.setText(code.get(0).getOrgCode());
        }
    }

    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        this.verifyInput(e);
        CoreBaseCollection coll = new CoreBaseCollection();
        String batchNum = ("" + FMCommonFacadeFactory.getRemoteInstance().getServerDate()).substring(0, 10) + "__" + new Long(System.currentTimeMillis()).toString();
        Iterator itor = this.billSet.iterator();
        int i = 0;
        for (DraftStockBillInfo billInfo : this.billSet) {
            String issueDate = billInfo.getCommercialDraft().getIssueDate().toLocaleString().substring(0, 10);
            String reqDate = ((Date)this.pkReqDate.getValue()).toLocaleString().substring(0, 10);
            if ((billInfo.getCommercialDraft().getIssueDate().before((Date)this.pkReqDate.getValue()) || issueDate.equals(reqDate)) && billInfo.getCommercialDraft().getDueDate().after((Date)this.pkReqDate.getValue())) continue;
            MsgBox.showWarning((String)"\u80cc\u4e66\u7533\u8bf7\u65e5\u671f\u5927\u4e8e\u7b49\u4e8e\u7968\u636e\u51fa\u7968\u65e5\u671f\uff0c\u5c0f\u4e8e\u7968\u636e\u5230\u671f\u65e5");
            SysUtil.abort();
        }
        while (itor.hasNext()) {
            DraftStockBillInfo billInfo;
            billInfo = (DraftStockBillInfo)itor.next();
            DraftEndorsementBillInfo info = new DraftEndorsementBillInfo();
            info.setReqDate((Date)this.pkReqDate.getValue());
            info.setCommercialDraft(billInfo.getCommercialDraft());
            info.setOperateState(OperateStateEnum.SAVE);
            info.setEndorsementerName(SysContext.getSysContext().getCurrentFIUnit());
            info.setBatchNum(batchNum);
            info.setEndorsementerAccount(billInfo.getHolderAccount());
            info.setEndorsementerBankNumber(billInfo.getHolderBankNumber());
            info.setOrgCode(this.txtOrgCode.getText());
            info.setByEndorsementName((SupplierInfo)this.prmtByEndorsementName.getValue());
            info.setByEndorsementAccount((String)this.prmtByEndorsementAccount.getData());
            info.setByEndorsementBankNumber(((BEBankInfo)this.prmtByEndorsementBankNum.getValue()).getNumber());
            FMClientHelper.storeFieldsBgItem((KDBizPromptBox)this.prmtbudgetItem, (CoreBaseInfo)info, (FMBgItemProp)info.getBgItemProps()[0]);
            info.setIsAttorn(this.ckIsAttorn.isSelected());
            if (this.tblMain.getCell(i, "remark").getValue() != null) {
                info.setRemark(this.tblMain.getCell(i, "remark").getValue().toString());
            } else {
                info.setRemark(this.txtRemark.getText());
            }
            info.setCreator(SysContext.getSysContext().getCurrentUserInfo());
            info.setCreateTime(new Timestamp(new Date().getTime()));
            info.setCompany(SysContext.getSysContext().getCurrentFIUnit());
            info.setSourceBillId(billInfo.getId().toString());
            info.setId(BOSUuid.create((String)info.getBOSType().toString()));
            coll.add((CoreBaseInfo)info);
            BOTRelationInfo relateInfo = new BOTRelationInfo();
            relateInfo.setSrcEntityID(billInfo.getId().toString());
            relateInfo.setDestEntityID(BOSUuid.read((String)info.getId().toString()).getType().toString());
            relateInfo.setSrcObjectID(billInfo.getId().toString());
            relateInfo.setDestObjectID(info.getId().toString());
            relateInfo.setDate(new Date());
            relateInfo.setOperatorID("unknown");
            relateInfo.setIsEffected(true);
            relateInfo.setType(0);
            BOTRelationFactory.getRemoteInstance().addnew(relateInfo);
            ++i;
        }
        DraftEndorsementBillFactory.getRemoteInstance().addnew(coll);
        MsgBox.showInfo((String)"\u80cc\u4e66\u8f6c\u8ba9\u4fdd\u5b58\u6210\u529f");
        this.uiWindow.close();
    }

    protected void enableBaseActions() {
        HashMap actionMap = this.getActionManager().getActionSet();
        actionMap.remove(new String("actionSave"));
        actionMap.remove(new String("actionFirst"));
        actionMap.remove(new String("actionPre"));
        actionMap.remove(new String("actionNext"));
        actionMap.remove(new String("actionLast"));
        actionMap.remove(new String("actionSubmit"));
        ItemAction[] itemAction = new ItemAction[actionMap.size()];
        Iterator itor = actionMap.keySet().iterator();
        int i = 0;
        while (itor.hasNext()) {
            ItemAction action;
            itemAction[i] = action = this.getActionManager().getAction(itor.next().toString());
            ++i;
        }
        FMClientHelper.setActionVisible((ItemAction[])itemAction, (boolean)false);
    }

    private void fillData(Set set) throws Exception {
        if (set == null) {
            return;
        }
        Iterator iterator = set.iterator();
        DraftStockBillInfo info = (DraftStockBillInfo)iterator.next();
        this.pkReqDate.setValue((Object)new Date());
        this.prmtCreator.setValue(SysContext.getSysContext().getCurrentUser());
        this.pkCreateDate.setValue((Object)new Date());
        this.prmtCreateCompany.setValue((Object)SysContext.getSysContext().getCurrentFIUnit());
        this.prmtEndorsementName.setValue((Object)SysContext.getSysContext().getCurrentFIUnit());
        this.setOrgCode(SysContext.getSysContext().getCurrentFIUnit().getId().toString());
        this.prmtEndorsementAccount.setValue((Object)info.getHolderAccount());
        this.prmtEndorsementBankNum.setValue((Object)info.getHolderBankNumber());
        this.ckIsAttorn.setSelected(info.isIsAttorn());
        this.tblMain.removeRows();
        this.tblMain.checkParsed();
        for (DraftStockBillInfo billInfo : set) {
            ECDSBillStatusEnum eCDSBillStatus;
            if (billInfo.getCommercialDraft().getDraftECDSStatus() == null || !(eCDSBillStatus = billInfo.getCommercialDraft().getDraftECDSStatus()).toString().equals(ECDSBillStatusEnum.TSSPYQS.toString()) && !eCDSBillStatus.toString().equals(ECDSBillStatusEnum.BSYQS.toString()) && !eCDSBillStatus.toString().equals(ECDSBillStatusEnum.ZYJCYQS.toString()) && !eCDSBillStatus.toString().equals(ECDSBillStatusEnum.HGSTXSHYQS.toString()) || billInfo.getDraftStockOperate().getValue() != DraftStockBillOperateEnum.REGISTER.getValue() || billInfo.isCollateral() || billInfo.isRecourse() || billInfo.isPresent() || !billInfo.isIsAttorn()) continue;
            IRow row = this.tblMain.addRow();
            row.getCell("id").setValue((Object)billInfo.getCommercialDraft().getId().toString());
            row.getCell("draftNumber").setValue((Object)billInfo.getCommercialDraft().getDraftNumber().toString());
            row.getCell("draftType").setValue((Object)billInfo.getCommercialDraft().getDraftType().toString());
            row.getCell("draftAmount").setValue((Object)billInfo.getCommercialDraft().getDraftAmount().toString());
            row.getCell("draftAmount").getStyleAttributes().setNumberFormat("###,##0.00");
            row.getCell("draftAmount").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
            row.getCell("issueDate").setValue((Object)billInfo.getCommercialDraft().getIssueDate());
            row.getCell("dueDate").setValue((Object)billInfo.getCommercialDraft().getDueDate());
            row.getCell("drawer").setValue((Object)billInfo.getCommercialDraft().getDrawerName());
            row.getCell("drawerBank").setValue((Object)billInfo.getCommercialDraft().getDrawerBankNumber());
        }
    }

    protected void setTableToSumField(KDTable table, String[] columnFields) {
        super.setTableToSumField(this.tblMain, new String[]{"draftAmount@###,##0.00"});
    }

    protected void setTableToSumField() {
        super.setTableToSumField(this.tblMain, new String[]{"draftAmount@###,##0.00"});
    }

    protected IObjectValue createNewDetailData(KDTable table) {
        return null;
    }

    protected KDTable getDetailTable() {
        return null;
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        super.verifyInput(e);
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDDatePicker)this.pkReqDate);
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDBizPromptBox)this.prmtByEndorsementName);
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDBizPromptBox)this.prmtByEndorsementAccount);
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDBizPromptBox)this.prmtByEndorsementBankNum);
        if (this.txtOrgCode.getText() == null || this.txtOrgCode.getText().trim().equals("")) {
            MsgBox.showWarning((String)"\u5fc5\u987b\u63d0\u4f9b\u7ec4\u7ec7\u673a\u6784\u4ee3\u7801\uff0c\u8bf7\u5728\u8d22\u52a1\u516c\u53f8\u7aef-\u7ec4\u7ec7\u673a\u6784\u4ee3\u7801\u4e2d\u5f55\u5165\uff01");
            SysUtil.abort();
        }
    }

    @Override
    protected void txtRemark_focusLost(FocusEvent e) throws Exception {
        if (this.txtRemark.getText() != null && !this.txtRemark.getText().trim().equals("")) {
            for (int i = 0; i < this.tblMain.getRowCount(); ++i) {
                IRow row = this.tblMain.getRow(i);
                row.getCell("remark").setValue((Object)this.txtRemark.getText());
            }
        }
    }

    @Override
    protected void prmtByEndorsementAccount_dataChanged(DataChangeEvent e) throws Exception {
        String bankname;
        SupplierCompanyBankInfo bankInfo;
        if (this.prmtByEndorsementAccount.getData() instanceof SupplierCompanyBankInfo && (bankInfo = (SupplierCompanyBankInfo)this.prmtByEndorsementAccount.getData()) != null && (bankname = bankInfo.getBank()) != null) {
            String oql = "select * where name='" + bankname + "'";
            BEBankInfo info = BEBankFactory.getRemoteInstance().getBEBankInfo(oql);
            if (info != null) {
                // empty if block
            }
        }
    }

    @Override
    protected void prmtByEndorsementBankNum_dataChanged(DataChangeEvent e) throws Exception {
    }

    @Override
    protected void prmtByEndorsementName_dataChanged(DataChangeEvent e) throws Exception {
        SupplierCompanyInfoInfo supplierCompany;
        SupplierInfo supplier;
        Object payee = this.prmtByEndorsementName.getValue();
        if (payee instanceof SupplierInfo && (supplier = (SupplierInfo)this.prmtByEndorsementName.getData()) != null && (supplierCompany = SupplierFactory.getRemoteInstance().getCompanyInfo((IObjectPK)new ObjectUuidPK(supplier.getId()), (IObjectPK)new ObjectUuidPK(ContextHelperFactory.getRemoteInstance().getCurrentCompany().getId()))) != null) {
            CSBankInfo bankInfo = FMHelper.getCSBankInfo(null, (Object)supplier, (String)ContextHelperFactory.getRemoteInstance().getCurrentCompany().getId().toString());
            this.prmtByEndorsementAccount.setData((Object)bankInfo.getBankAccount());
            String bankname = bankInfo.getBank();
            if (bankname != null) {
                String oql = "select * where name='" + bankname + "'";
                BEBankInfo info = BEBankFactory.getRemoteInstance().getBEBankInfo(oql);
                if (info != null) {
                    this.prmtByEndorsementBankNum.setData((Object)info);
                }
            }
            this.prmtByEndorsementAccount.setQueryInfo("com.kingdee.eas.basedata.master.cssp.app.F7SupplierCompanyInfoBankQuery");
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("supplier.id", (Object)supplier.getId().toString(), CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("companyOrgUnit.id", (Object)ContextHelperFactory.getRemoteInstance().getCurrentCompany().getId()));
            view.setFilter(filter);
            this.prmtByEndorsementAccount.setEntityViewInfo(view);
            this.prmtByEndorsementAccount.setEditFormat("$bankAccount$");
            this.prmtByEndorsementAccount.setDisplayFormat("$bankAccount$");
            this.prmtByEndorsementAccount.getQueryAgent().resetRuntimeEntityView();
        }
    }

    private void apendFootRow(KDTable table, String[] field) {
        int size = field.length;
        int count = table.getRowCount();
        BigDecimal draftAmount = new BigDecimal("0.00");
        IRow footRow = null;
        KDTFootManager footManager = table.getFootManager();
        if (footManager == null) {
            footManager = new KDTFootManager(table);
            footManager.addFootView();
            table.setFootManager(footManager);
        }
        footRow = footManager.getFootRow(0);
        for (int i = 0; i < count; ++i) {
            IRow row = table.getRow(i);
            ICell cell_invoiceAmount = row.getCell("draftAmount");
            draftAmount = draftAmount.add(new BigDecimal(cell_invoiceAmount.getValue().toString()));
        }
        if (footRow == null) {
            String colFormat = "%{0.00}f";
            footRow = footManager.addFootRow(0);
            String total = EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_Total");
            table.getIndexColumn().setWidthAdjustMode((short)1);
            table.getIndexColumn().setWidth(30);
            footManager.addIndexText(0, total);
            footRow.getStyleAttributes().setBackground(new Color(246, 246, 191));
            for (int i = 0; i < size; ++i) {
                String colName = field[i];
                footRow.getCell(colName).getStyleAttributes().setNumberFormat(colFormat);
                footRow.getCell(colName).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
                footRow.getCell(colName).getStyleAttributes().setFontColor(Color.black);
            }
        }
        footRow.getCell("draftAmount").getStyleAttributes().setNumberFormat("###,##0.00");
        footRow.getCell("draftAmount").setValue((Object)draftAmount.toString());
    }

    private void addTablePropertyList(final KDTable table) {
        KDTPropertyChangeListener propertyChangeListener = new KDTPropertyChangeListener(){

            public void propertyChange(KDTPropertyChangeEvent evt) {
                int columnIndex;
                String colKey;
                if (evt.getType() == 1 && evt.getPropertyName().equals("cellValue") && (colKey = table.getColumn(columnIndex = evt.getColIndex()).getKey()) != null && evt.getOldValue() != null && colKey.equals("draftAmount")) {
                    BigDecimal oldValue = new BigDecimal(evt.getOldValue().toString());
                    BigDecimal newValue = new BigDecimal(evt.getNewValue().toString());
                    KDTFootManager footManager = table.getFootManager();
                    IRow footRow = footManager.getFootRow(0);
                    if (footRow != null) {
                        BigDecimal totalValue = new BigDecimal(footRow.getCell(colKey).getValue().toString());
                        totalValue = totalValue.add(newValue).subtract(oldValue);
                        footRow.getCell(colKey).setValue((Object)totalValue.toString());
                    }
                }
            }
        };
        table.addKDTPropertyChangeListener(propertyChangeListener);
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        this.verifyInput(e);
        CoreBaseCollection coll = new CoreBaseCollection();
        String batchNum = ("" + FMCommonFacadeFactory.getRemoteInstance().getServerDate()).substring(0, 10) + "__" + new Long(System.currentTimeMillis()).toString();
        Iterator itor = this.billSet.iterator();
        int i = 0;
        for (DraftStockBillInfo billInfo : this.billSet) {
            String issueDate = billInfo.getCommercialDraft().getIssueDate().toLocaleString().substring(0, 10);
            String reqDate = ((Date)this.pkReqDate.getValue()).toLocaleString().substring(0, 10);
            if ((billInfo.getCommercialDraft().getIssueDate().before((Date)this.pkReqDate.getValue()) || issueDate.equals(reqDate)) && billInfo.getCommercialDraft().getDueDate().after((Date)this.pkReqDate.getValue())) continue;
            MsgBox.showWarning((String)"\u80cc\u4e66\u7533\u8bf7\u65e5\u671f\u5927\u4e8e\u7b49\u4e8e\u7968\u636e\u51fa\u7968\u65e5\u671f\uff0c\u5c0f\u4e8e\u7968\u636e\u5230\u671f\u65e5");
            SysUtil.abort();
        }
        while (itor.hasNext()) {
            DraftStockBillInfo billInfo;
            billInfo = (DraftStockBillInfo)itor.next();
            DraftEndorsementBillInfo info = new DraftEndorsementBillInfo();
            info.setReqDate((Date)this.pkReqDate.getValue());
            info.setCommercialDraft(billInfo.getCommercialDraft());
            info.setOperateState(OperateStateEnum.SAVE);
            info.setEndorsementerName(SysContext.getSysContext().getCurrentFIUnit());
            info.setBatchNum(batchNum);
            info.setEndorsementerAccount(billInfo.getHolderAccount());
            info.setEndorsementerBankNumber(billInfo.getHolderBankNumber());
            info.setOrgCode(this.txtOrgCode.getText());
            info.setByEndorsementName((SupplierInfo)this.prmtByEndorsementName.getValue());
            info.setByEndorsementAccount((String)this.prmtByEndorsementAccount.getData());
            info.setByEndorsementBankNumber(((BEBankInfo)this.prmtByEndorsementBankNum.getValue()).getNumber());
            FMClientHelper.storeFieldsBgItem((KDBizPromptBox)this.prmtbudgetItem, (CoreBaseInfo)info, (FMBgItemProp)info.getBgItemProps()[0]);
            info.setIsAttorn(this.ckIsAttorn.isSelected());
            if (this.tblMain.getCell(i, "remark").getValue() != null) {
                info.setRemark(this.tblMain.getCell(i, "remark").getValue().toString());
            } else {
                info.setRemark(this.txtRemark.getText());
            }
            info.setCreator(SysContext.getSysContext().getCurrentUserInfo());
            info.setCreateTime(new Timestamp(new Date().getTime()));
            info.setCompany(SysContext.getSysContext().getCurrentFIUnit());
            info.setSourceBillId(billInfo.getId().toString());
            info.setId(BOSUuid.create((String)info.getBOSType().toString()));
            coll.add((CoreBaseInfo)info);
            BOTRelationInfo relateInfo = new BOTRelationInfo();
            relateInfo.setSrcEntityID(billInfo.getId().toString());
            relateInfo.setDestEntityID(BOSUuid.read((String)info.getId().toString()).getType().toString());
            relateInfo.setSrcObjectID(billInfo.getId().toString());
            relateInfo.setDestObjectID(info.getId().toString());
            relateInfo.setDate(new Date());
            relateInfo.setOperatorID("unknown");
            relateInfo.setIsEffected(true);
            relateInfo.setType(0);
            BOTRelationFactory.getRemoteInstance().addnew(relateInfo);
            ++i;
        }
        DraftEndorsementBillFactory.getRemoteInstance().submit(coll);
        MsgBox.showInfo((String)"\u80cc\u4e66\u8f6c\u8ba9\u63d0\u4ea4\u6210\u529f");
        this.uiWindow.close();
    }
}

