/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.ent.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.BizEnumValueDTO;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMFilterBaseUI;
import com.kingdee.eas.fm.ent.client.AbstractPayableBill4ElecListUI;
import com.kingdee.eas.fm.ent.client.BookBaseDataUI;
import com.kingdee.eas.fm.ent.client.PayableBill4ElecBatchInputUI;
import com.kingdee.eas.fm.ent.client.PayableBill4ElecEditUI;
import com.kingdee.eas.fm.fin.RepaymentInfo;
import com.kingdee.eas.fm.nt.BillMakeTypeEnum;
import com.kingdee.eas.fm.nt.BillSourceEnum;
import com.kingdee.eas.fm.nt.ElecBillStatusEnum;
import com.kingdee.eas.fm.nt.IPayableBill;
import com.kingdee.eas.fm.nt.NTException;
import com.kingdee.eas.fm.nt.PayableBillCollection;
import com.kingdee.eas.fm.nt.PayableBillFactory;
import com.kingdee.eas.fm.nt.PayableBillInfo;
import com.kingdee.eas.fm.nt.PayableBillStateEnum;
import com.kingdee.eas.fm.nt.PayableException;
import com.kingdee.eas.fm.nt.client.PayableBillFilterUI;
import com.kingdee.eas.fm.nt.client.RepaymentBatEditUI;
import com.kingdee.eas.fm.ntp.DraftSignInFactory;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.client.CoreBillListUI;
import com.kingdee.eas.tools.datatask.DatataskParameter;
import com.kingdee.eas.tools.datatask.client.DatataskCaller;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class PayableBill4ElecListUI
extends AbstractPayableBill4ElecListUI {
    private static final long serialVersionUID = 2276026400802694901L;
    private static final Logger logger = CoreUIObject.getLogger(PayableBill4ElecListUI.class);
    private static final String NT_AUTO_GENERATE_RESOURCE = "com.kingdee.eas.fm.nt.NTAutoGenerateResource";
    private UserInfo userinfo;
    private CompanyOrgUnitInfo currentCompany;
    FillListener fillListener = new FillListener();

    public PayableBill4ElecListUI() throws Exception {
        this.userinfo = ContextHelperFactory.getRemoteInstance().getCurrentUser();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.currentCompany = this.currentCompanyCommon;
    }

    public FMFilterBaseUI getFilterUI() throws Exception {
        if (this.filterUI == null) {
            this.filterUI = new PayableBillFilterUI(BillSourceEnum.BYECDS);
        }
        return this.filterUI;
    }

    protected String getEditUIName() {
        return PayableBill4ElecEditUI.class.getName();
    }

    public void onshows() {
        super.onshows();
        this.buttonCommitToBe.setVisible(true);
        this.actionIssueRegister.setVisible(true);
        this.actionPromptAccept.setVisible(true);
        this.actionPromptRecBill.setVisible(true);
        this.actionNoteCancle.setVisible(true);
        this.actionCancelIssue.setVisible(true);
        this.actionSynStatus.setVisible(true);
        this.actionSynForceStatus.setVisible(false);
        this.actionEditStatus.setVisible(true);
        this.actionInTransfer.setVisible(false);
        this.actionOutTransfer.setVisible(false);
        this.actionConfirmNoWF.setVisible(false);
        this.actionCancelConfirm.setVisible(false);
        this.confirm.setVisible(false);
        this.actionAbandon.setVisible(true);
        this.actionCancelAbandon.setVisible(true);
        this.actionApply.setVisible(false);
        this.actionAccept.setVisible(false);
        this.actionTranLoan.setVisible(false);
        this.actionDiscount.setVisible(false);
        this.actionCancelDiscount.setVisible(false);
        this.actionatchEdit.setVisible(false);
        this.actionBatchEdit.setVisible(false);
        this.actionPredownload.setVisible(true);
        this.actionPredownload.setEnabled(true);
        this.actionBitBack.setVisible(true);
        this.actionBookBaseData.setEnabled(!GlUtils.isCompanyUnion((CompanyOrgUnitInfo)this.companyInfo));
        this.menuItemReturnBill.setVisible(false);
        this.menuItemCancelTranLoan.setVisible(false);
        this.menuItemCancelReturnBill.setVisible(false);
        this.tblMain.getColumn("commitToBe").getStyleAttributes().setHided(false);
        this.tblMain.getColumn("elecBillStatus").getStyleAttributes().setHided(false);
        this.tblMain.getColumn("bankReturnStatus").getStyleAttributes().setHided(false);
        this.tblMain.getColumn("bankReturnInfo").getStyleAttributes().setHided(false);
        this.tblMain.getColumn("isPreBill").getStyleAttributes().setHided(false);
        this.tblMain.getColumn("cirStatus").getStyleAttributes().setHided(false);
        this.tblMain.getColumn("noteStatus").getStyleAttributes().setHided(false);
        this.tblMain.getColumn("source").getStyleAttributes().setHided(false);
        this.tblMain.getColumn("acceptType").getStyleAttributes().setHided(false);
        this.tblMain.getColumn("acceptFee").getStyleAttributes().setHided(false);
        this.tblMain.getColumn("assureAmountType").getStyleAttributes().setHided(false);
        this.tblMain.getColumn("assureAcct").getStyleAttributes().setHided(false);
    }

    protected void tblMain_tableSelectChanged(KDTSelectEvent e) throws Exception {
        ArrayList idList;
        super.tblMain_tableSelectChanged(e);
        this.actionCreateTo.setEnabled(false);
        String id = this.getSelectedKeyValue();
        PayableBillInfo payableInfo = PayableBillFactory.getRemoteInstance().getPayableBillInfo((IObjectPK)new ObjectUuidPK(id), this.getSelectors());
        if (payableInfo.getDraftNumber() != null && payableInfo.getBillState() == PayableBillStateEnum.Audit && payableInfo.getElecBillStatus() != null && payableInfo.getElecBillStatus() != ElecBillStatusEnum.NT000002) {
            this.actionCreateTo.setEnabled(true);
        }
        if ((idList = this.getSelectedIdValues()).size() == 1) {
            this.actionNvaContract.setEnabled(true);
            this.actionConfirmContract.setEnabled(true);
        } else {
            this.actionNvaContract.setEnabled(false);
            this.actionConfirmContract.setEnabled(false);
        }
    }

    public void actionCreateTo_actionPerformed(ActionEvent e) throws Exception {
        this.checkCanRepay();
        this.checkSelected();
        ArrayList idList = this.getSelectedIdValues();
        if (idList.size() == 1) {
            String ids = (String)idList.get(0);
            PayableBillInfo sourceBill = ((IPayableBill)this.getBizInterface()).getPayableBillInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)ids)));
            Date d = new Date();
            String id = this.getSelectedKeyValue();
            if (id != null) {
                if (sourceBill.getExpiredDate().compareTo(d) > 0) {
                    if (MsgBox.showConfirm2New((Component)((Object)this), (String)EASResource.getString((String)NT_AUTO_GENERATE_RESOURCE, (String)"442_NotBillDueDate")) == 0) {
                        this.requestDataObjectLock(idList);
                        FMClientHelper.generateDestBill((CoreBillListUI)this, (String)new PayableBillInfo().getBOSType().toString(), (String)RepaymentInfo.BOSTYPE.toString(), (String)id, (String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
                    }
                } else {
                    this.requestDataObjectLock(idList);
                    FMClientHelper.generateDestBill((CoreBillListUI)this, (String)new PayableBillInfo().getBOSType().toString(), (String)RepaymentInfo.BOSTYPE.toString(), (String)id, (String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
                }
            }
        } else {
            this.requestDataObjectLock(idList);
            UIContext uiContext = new UIContext((Object)this);
            uiContext.put((Object)"PayableColl", (Object)this.getAccordPayableList4Repayment(idList));
            this.checkSelected4Repayment();
            IUIWindow uiWindow = null;
            uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(RepaymentBatEditUI.class.getName(), (Map)uiContext, null, OprtState.ADDNEW);
            uiWindow.show();
            this.refreshList();
        }
    }

    private IObjectCollection getAccordPayableList(List srcList) throws Exception {
        String currencyId = "";
        HashSet<String> set = new HashSet<String>();
        for (int i = 0; i < srcList.size(); ++i) {
            String id = (String)srcList.get(i);
            set.add(id);
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("id", set, CompareType.INCLUDE));
        SelectorItemCollection selector = this.getSelectors();
        view.getSelector().addObjectCollection((IObjectCollection)selector);
        view.setFilter(fi);
        PayableBillCollection colInfo = PayableBillFactory.getRemoteInstance().getPayableBillCollection(view);
        int i = 0;
        for (PayableBillInfo selInfo : colInfo) {
            if (i == 0) {
                currencyId = selInfo.getCurrency().getId().toString();
            }
            if (!currencyId.equals(selInfo.getCurrency().getId().toString())) {
                throw new NTException(NTException.CURRENCYNOTACCORD);
            }
            ++i;
        }
        return colInfo;
    }

    private IObjectCollection getAccordPayableList4Repayment(List srcList) throws Exception {
        String applyUnitId = "";
        PayableBillCollection colInfo = (PayableBillCollection)this.getAccordPayableList(srcList);
        int i = 0;
        for (PayableBillInfo selInfo : colInfo) {
            if (i == 0 && !EmptyUtil.isEmpty((CoreBaseInfo)selInfo.getApplyUnit())) {
                applyUnitId = selInfo.getApplyUnit().getId().toString();
            }
            if (EmptyUtil.isEmpty((CoreBaseInfo)selInfo.getApplyUnit()) || !EmptyUtil.isEmpty((CoreBaseInfo)selInfo.getApplyUnit()) && !EmptyUtil.isEmpty((String)applyUnitId) && !applyUnitId.equals(selInfo.getApplyUnit().getId().toString())) {
                throw new NTException(NTException.APPUNITNOTACCORD);
            }
            if (selInfo.getBillState() == PayableBillStateEnum.CASH) {
                throw new PayableException(PayableException.HASCASH);
            }
            if (selInfo.getConfirmer() == null && selInfo.getMakeType() == BillMakeTypeEnum.SUB) {
                throw new PayableException(PayableException.NOTCASH4NOCONFIRM);
            }
            if (selInfo.getMakeType() == BillMakeTypeEnum.ENTRUST) {
                throw new PayableException(PayableException.NOTCASH4ENTRUST);
            }
            if (selInfo.getDraftSource() == BillSourceEnum.BYECDS && (selInfo.getDraftNumber() == null || selInfo.getBillState() != PayableBillStateEnum.Audit || selInfo.getElecBillStatus() == null || selInfo.getElecBillStatus() == ElecBillStatusEnum.NT000002)) {
                throw new PayableException(PayableException.EDCPAYABLENOTOCREATE);
            }
            ++i;
        }
        return colInfo;
    }

    private void checkSelected4Repayment() throws NTException {
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        for (int i = 0; i < selectRows.length; ++i) {
            IRow row = this.tblMain.getRow(selectRows[i]);
            String number = (String)row.getCell("number").getValue();
            Date expiredDate = (Date)row.getCell("ExpiredDate").getValue();
            if (expiredDate != null) {
                if (new Date().before(expiredDate)) {
                    throw new NTException(NTException.PAYABLECHECK);
                }
            } else {
                throw new NTException(NTException.PAYABLE_NOCOMMITTOBE);
            }
            BizEnumValueDTO state = (BizEnumValueDTO)row.getCell("BillState").getValue();
            if (state.getInt() == 5 || state.getInt() == 2 || state.getInt() == 3) continue;
            throw new NTException(NTException.NOTAUDIT);
        }
    }

    private void checkCanRepay() throws Exception {
        String keyValue = this.getSelectedKeyValue();
        if (keyValue == null) {
            return;
        }
        PayableBillInfo info = PayableBillFactory.getRemoteInstance().getPayableBillInfo((IObjectPK)new ObjectUuidPK(keyValue));
        if (info.getBillState() == PayableBillStateEnum.CASH) {
            throw new PayableException(PayableException.HASCASH);
        }
        if (info.getConfirmer() == null && info.getMakeType() == BillMakeTypeEnum.SUB) {
            throw new PayableException(PayableException.NOTCASH4NOCONFIRM);
        }
        if (info.getDraftSource() == BillSourceEnum.BYECDS && (info.getDraftNumber() == null || info.getBillState() != PayableBillStateEnum.Audit || info.getElecBillStatus() == null || info.getElecBillStatus() == ElecBillStatusEnum.NT000002)) {
            throw new PayableException(PayableException.EDCPAYABLENOTOCREATE);
        }
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("Amount"));
        sic.add(new SelectorItemInfo("Balance"));
        sic.add(new SelectorItemInfo("LocalCurExRate"));
        sic.add(new SelectorItemInfo("IsInCredit"));
        sic.add(new SelectorItemInfo("UsedQuota"));
        sic.add(new SelectorItemInfo("IssueDate"));
        sic.add(new SelectorItemInfo("ExpiredDate"));
        sic.add(new SelectorItemInfo("Horizon"));
        sic.add(new SelectorItemInfo("Remark"));
        sic.add(new SelectorItemInfo("Garantee"));
        sic.add(new SelectorItemInfo("bizDate"));
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("GaranteeType.name"));
        sic.add(new SelectorItemInfo("Currency.name"));
        sic.add(new SelectorItemInfo("company.name"));
        sic.add(new SelectorItemInfo("BuyerPayDisCnt"));
        sic.add(new SelectorItemInfo("DiscountRate"));
        sic.add(new SelectorItemInfo("Discount"));
        sic.add(new SelectorItemInfo("Institution.name"));
        sic.add(new SelectorItemInfo("Currency.id"));
        sic.add(new SelectorItemInfo("ApplyUnit.name"));
        sic.add(new SelectorItemInfo("billMakerName"));
        sic.add(new SelectorItemInfo("billState"));
        sic.add(new SelectorItemInfo("makeType"));
        sic.add(new SelectorItemInfo("confirmer.name"));
        sic.add(new SelectorItemInfo("payeeName"));
        sic.add(new SelectorItemInfo("assureProportion"));
        sic.add(new SelectorItemInfo("assureAmount"));
        sic.add(new SelectorItemInfo("historyBill"));
        sic.add(new SelectorItemInfo("guaranteeTypeInputMode"));
        sic.add(new SelectorItemInfo("acceptDate"));
        sic.add(new SelectorItemInfo("fpItem.name"));
        sic.add(new SelectorItemInfo("oppAccount.name"));
        sic.add(new SelectorItemInfo("transferDate"));
        sic.add(new SelectorItemInfo("billAccount.name"));
        sic.add(new SelectorItemInfo("PayeeAccountName"));
        sic.add(new SelectorItemInfo("PayeeBankName"));
        sic.add(new SelectorItemInfo("adminOrgUnit.name"));
        sic.add(new SelectorItemInfo("issueUnit"));
        sic.add(new SelectorItemInfo("digest"));
        sic.add(new SelectorItemInfo("auditor.name"));
        sic.add(new SelectorItemInfo("isTDPrinted"));
        sic.add(new SelectorItemInfo("OutBankAccount.name"));
        sic.add(new SelectorItemInfo("OutBankAccount.bankAccountNumber"));
        sic.add(new SelectorItemInfo("ntType.name"));
        sic.add(new SelectorItemInfo("paymentBill.number"));
        sic.add(new SelectorItemInfo("personName"));
        sic.add(new SelectorItemInfo("applyDate"));
        sic.add(new SelectorItemInfo("isApply"));
        sic.add(new SelectorItemInfo("applyInfo"));
        sic.add(new SelectorItemInfo("isAccept"));
        sic.add(new SelectorItemInfo("accountant.name"));
        sic.add(new SelectorItemInfo("oriAssureAmount"));
        sic.add(new SelectorItemInfo("outBgItemName"));
        sic.add(new SelectorItemInfo("project.name"));
        sic.add(new SelectorItemInfo("batchNo"));
        sic.add(new SelectorItemInfo("costCenter.name"));
        sic.add(new SelectorItemInfo("returnOption"));
        sic.add(new SelectorItemInfo("isAcceptSubmit"));
        sic.add(new SelectorItemInfo("acceptor"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("draftNumber"));
        sic.add(new SelectorItemInfo("Currency2.id"));
        sic.add(new SelectorItemInfo("billMedium"));
        sic.add(new SelectorItemInfo("isCanTransfer"));
        sic.add(new SelectorItemInfo("acceptorAccountName"));
        sic.add(new SelectorItemInfo("acceptorBankNum"));
        sic.add(new SelectorItemInfo("acceptorBank.name"));
        sic.add(new SelectorItemInfo("drawerBankNumber"));
        sic.add(new SelectorItemInfo("payeeBankNumber"));
        sic.add(new SelectorItemInfo("elecBillStatus"));
        sic.add(new SelectorItemInfo("commitToBe"));
        sic.add(new SelectorItemInfo("bankReturnStatus"));
        sic.add(new SelectorItemInfo("bankReturnInfo"));
        sic.add(new SelectorItemInfo("isPreBill"));
        sic.add(new SelectorItemInfo("isBitBack"));
        sic.add(new SelectorItemInfo("abandonDate"));
        sic.add(new SelectorItemInfo("oriAssureAmount"));
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("currency.id"));
        sic.add(new SelectorItemInfo("currency.number"));
        sic.add(new SelectorItemInfo("currency.name"));
        sic.add(new SelectorItemInfo("currency.precision"));
        sic.add(new SelectorItemInfo("oppAccount.id"));
        sic.add(new SelectorItemInfo("oppAccount.number"));
        sic.add(new SelectorItemInfo("oppAccount.name"));
        sic.add(new SelectorItemInfo("oppAccount.isBank"));
        sic.add(new SelectorItemInfo("oppAccount.isCash"));
        sic.add(new SelectorItemInfo("fpItem.*"));
        sic.add(new SelectorItemInfo("company.id"));
        sic.add(new SelectorItemInfo("company.name"));
        sic.add(new SelectorItemInfo("company.number"));
        sic.add(new SelectorItemInfo("company.cu"));
        sic.add(new SelectorItemInfo("Type.*"));
        sic.add(new SelectorItemInfo("Institution.id"));
        sic.add(new SelectorItemInfo("Institution.name"));
        sic.add(new SelectorItemInfo("Institution.number"));
        sic.add(new SelectorItemInfo("Institution.isBank"));
        sic.add(new SelectorItemInfo("ntType.id"));
        sic.add(new SelectorItemInfo("ntType.group"));
        sic.add(new SelectorItemInfo("ntType.isUsed"));
        sic.add(new SelectorItemInfo("ntType.isRecNote"));
        sic.add(new SelectorItemInfo("ntType.name"));
        sic.add(new SelectorItemInfo("ntType.number"));
        sic.add(new SelectorItemInfo("adminOrgUnit.id"));
        sic.add(new SelectorItemInfo("adminOrgUnit.number"));
        sic.add(new SelectorItemInfo("adminOrgUnit.name"));
        sic.add(new SelectorItemInfo("person.id"));
        sic.add(new SelectorItemInfo("person.name"));
        sic.add(new SelectorItemInfo("person.number"));
        sic.add(new SelectorItemInfo("person.CU"));
        sic.add(new SelectorItemInfo("CreditLimit.CreditUsage.*"));
        sic.add(new SelectorItemInfo("CreditLimit.*"));
        sic.add(new SelectorItemInfo("outBgItemId"));
        sic.add(new SelectorItemInfo("outBgItemNumber"));
        sic.add(new SelectorItemInfo("outBgItemName"));
        sic.add(new SelectorItemInfo("project.id"));
        sic.add(new SelectorItemInfo("project.number"));
        sic.add(new SelectorItemInfo("project.name"));
        sic.add(new SelectorItemInfo("Institution.*"));
        sic.add(new SelectorItemInfo("Institution.accountBank.*"));
        return sic;
    }

    public void actionPredownload_actionPerformed(ActionEvent e) throws Exception {
        String msgReceiver = this.userinfo.getName();
        Map resultMap = DraftSignInFactory.getRemoteInstance().getDraftSignDataFromBEByOnline(msgReceiver, "40", this.currentCompany.getId().toString());
        MsgBox.showInfo((String)(EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"44_PayableBill4ElecListUI") + resultMap.get("addnew") + EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"45_PayableBill4ElecListUI")));
    }

    @Override
    public void actionBookBaseData_actionPerformed(ActionEvent e) throws Exception {
        UIContext uiContext = new UIContext((Object)this);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(BookBaseDataUI.class.getName(), (Map)uiContext, null, OprtState.ADDNEW);
        uiWindow.show();
    }

    public void actionAddBatch_actionPerformed(ActionEvent e) throws Exception {
        UIContext uiContext = new UIContext((Object)this);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewTabFactory").create(PayableBill4ElecBatchInputUI.class.getName(), (Map)uiContext, null, OprtState.ADDNEW);
        uiWindow.show();
    }

    protected void initListener() {
        super.initListener();
        this.tblMain.getDataRequestManager().addDataFillListener((KDTDataFillListener)this.fillListener);
    }

    public void actionImportData2_actionPerformed(ActionEvent e) throws Exception {
        DatataskCaller task = new DatataskCaller();
        DatataskParameter param = new DatataskParameter();
        param.solutionName = "eas.fm.edrafent.payableBillEcds";
        param.alias = EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"46_PayableBill4ElecListUI");
        ArrayList<DatataskParameter> paramList = new ArrayList<DatataskParameter>();
        paramList.add(param);
        task.setParentComponent((Component)((Object)this));
        task.invoke(paramList, 0, false);
    }

    public void actionExportData_actionPerformed(ActionEvent e) throws Exception {
        DatataskCaller task = new DatataskCaller();
        DatataskParameter param = new DatataskParameter();
        param.solutionName = "eas.fm.edrafent.payableBillEcds";
        param.alias = EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"46_PayableBill4ElecListUI");
        param.putContextParam((Object)"filter", (Object)this.getMainQuery().getFilter());
        param.datataskMode = 1;
        ArrayList<DatataskParameter> paramList = new ArrayList<DatataskParameter>();
        paramList.add(param);
        task.setParentComponent((Component)((Object)this));
        task.invoke(paramList, 1, false);
    }

    private final class FillListener
    implements KDTDataFillListener {
        private FillListener() {
        }

        public void afterDataFill(KDTDataRequestEvent e) {
            this.fillTable(PayableBill4ElecListUI.this.tblMain, e);
        }

        private void fillTable(KDTable tblMain, KDTDataRequestEvent e) {
            IRow row = null;
            for (int i = e.getFirstRow(); i <= e.getLastRow(); ++i) {
                row = tblMain.getRow(i);
                if (row.getCell("elecBillStatus").getValue() != null || !"true".equals(row.getCell("isPreBill").getValue().toString())) continue;
                row.getCell("draftNumber").setValue(null);
            }
        }
    }
}

