/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.ent.client;

import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.BankInfo;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.client.FMFilterBaseUI;
import com.kingdee.eas.fm.ent.client.AbstractReceivablePledge4ElecListUI;
import com.kingdee.eas.fm.fin.FinBillStatusEnum;
import com.kingdee.eas.fm.fin.IWage;
import com.kingdee.eas.fm.fin.WageBillEntryCollection;
import com.kingdee.eas.fm.fin.WageBillEntryInfo;
import com.kingdee.eas.fm.fin.WageCollection;
import com.kingdee.eas.fm.fin.WageFactory;
import com.kingdee.eas.fm.fin.WageInfo;
import com.kingdee.eas.fm.nt.BillSourceEnum;
import com.kingdee.eas.fm.nt.ElecBillStatusEnum;
import com.kingdee.eas.fm.nt.PledgeRevokeBillFactory;
import com.kingdee.eas.fm.nt.ReceivableBillCollection;
import com.kingdee.eas.fm.nt.client.PledgeRevokeBillEditUI;
import com.kingdee.eas.fm.nt.client.ReceivablePledgeFilterUI;
import com.kingdee.eas.fm.nt.client.util.FMToolTipUtil;
import com.kingdee.eas.fm.nt.vo.FMToolTipInfo;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import org.apache.log4j.Logger;

public class ReceivablePledge4ElecListUI
extends AbstractReceivablePledge4ElecListUI {
    private static final long serialVersionUID = 8694479408585578245L;
    private static final Logger logger = CoreUIObject.getLogger(ReceivablePledge4ElecListUI.class);

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.tblMain.getColumn("isCommitToBE").getStyleAttributes().setHided(false);
        this.tblMain.getColumn("isAntiPledge").getStyleAttributes().setHided(true);
        boolean showEntry = super.isIsShowEntry();
        if (!showEntry) {
            this.tblMain.getColumn("pledgeRevoked").getStyleAttributes().setHided(true);
        }
        this.addCustomerToolTip();
    }

    protected void addCustomerToolTip() {
        FMToolTipUtil.setToolTipInfo((JComponent)this.btnDisPledge, (FMToolTipInfo)new FMToolTipInfo("btnDisPledge", EASResource.getString((String)"com.kingdee.eas.fm.nt.client.NtResource", (String)"ReceivablePledge4ElecListUI_btnDisPledge"), ""));
        FMToolTipUtil.setToolTipInfo((JComponent)this.btnRemove, (FMToolTipInfo)new FMToolTipInfo("btnRemove", EASResource.getString((String)"com.kingdee.eas.fm.nt.client.NtResource", (String)"ReceivablePledge4ElecListUI_btnRemove"), ""));
        FMToolTipUtil.setToolTipInfo((JComponent)this.btnNoteCancel, (FMToolTipInfo)new FMToolTipInfo("btnNoteCancel", EASResource.getString((String)"com.kingdee.eas.fm.nt.client.NtResource", (String)"ReceivablePledge4ElecListUI_btnNoteCancel"), ""));
        FMToolTipUtil.setToolTipInfo((JComponent)this.menuItemDisPledge, (FMToolTipInfo)new FMToolTipInfo("menuItemDisPledge", EASResource.getString((String)"com.kingdee.eas.fm.nt.client.NtResource", (String)"ReceivablePledge4ElecListUI_menuItemDisPledge"), ""));
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.actionCancelDisPledge.setVisible(false);
        this.actionExchange.setVisible(false);
        this.actionCommitToBE.setVisible(true);
        this.actionBatchCommitToBE.setVisible(true);
        this.actionSynBillStatus.setVisible(true);
        this.actionEditStatus.setVisible(true);
        this.actionReleaseFailedBill.setVisible(true);
        this.menuItemNoteCancel.setVisible(true);
        this.actionNoteCancel.setVisible(true);
    }

    public FMFilterBaseUI getFilterUI() throws Exception {
        if (this.filterUI == null) {
            this.filterUI = new ReceivablePledgeFilterUI(BillSourceEnum.BYECDS);
        }
        return this.filterUI;
    }

    public void refreshEntry() {
        super.refreshEntry();
        boolean showEntry = super.isIsShowEntry();
        if (showEntry) {
            this.tblMain.getColumn("elecBillStatus").getStyleAttributes().setHided(false);
            this.tblMain.getColumn("bankReturnStatus").getStyleAttributes().setHided(false);
            this.tblMain.getColumn("bankReturnMsg").getStyleAttributes().setHided(false);
            this.tblMain.getColumn("isNoteCancel").getStyleAttributes().setHided(false);
            this.tblMain.getColumn("isCommitCancel").getStyleAttributes().setHided(false);
        } else {
            this.tblMain.getColumn("pledgeRevoked").getStyleAttributes().setHided(true);
        }
    }

    public void actionDisPledge_actionPerformed(ActionEvent e) throws Exception {
        int i;
        ArrayList entryidList = new ArrayList();
        Set wageIDs = new HashSet();
        if (this.isShowEntry) {
            entryidList = this.getSelectedEntryIdValues();
            wageIDs.addAll(this.getSelectedIDs());
        } else {
            ArrayList billHeadidList = this.getSelectedIDs();
            EntityViewInfo evi = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            wageIDs = FMHelper.list2Set((List)billHeadidList);
            filterInfo.getFilterItems().add(new FilterItemInfo("id", wageIDs, CompareType.INCLUDE));
            evi.setFilter(filterInfo);
            evi.setSelector(this.getSelectors());
            WageCollection wageColl = WageFactory.getRemoteInstance().getWageCollection(evi);
            if (wageColl.size() > 0) {
                for (i = 0; i < wageColl.size(); ++i) {
                    WageInfo info = wageColl.get(i);
                    if (info.getBillEntrys() == null || info.getBillEntrys().size() <= 0) continue;
                    for (int j = 0; j < info.getBillEntrys().size(); ++j) {
                        entryidList.add(info.getBillEntrys().get(j).getId().toString());
                    }
                }
            }
        }
        ReceivableBillCollection receivableColl = new ReceivableBillCollection();
        WageBillEntryCollection billEntrys = this.getWageBillEntryColl(entryidList);
        WageBillEntryInfo wageEntry = billEntrys.get(0);
        BankInfo bank = wageEntry.getParent().getInstitution();
        int count = billEntrys.size();
        for (i = 0; i < count; ++i) {
            String msg;
            WageBillEntryInfo wageBillEntryInfo = billEntrys.get(i);
            receivableColl.add(wageBillEntryInfo.getReceivableBill());
            if (!wageBillEntryInfo.getParent().getInstitution().getId().toString().equals(bank.getId().toString())) {
                msg = EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"50_ReceivablePledge4ElecListUI");
                MsgBox.showInfo((String)msg);
                SysUtil.abort();
            }
            if (wageBillEntryInfo.getElecBillStatus() != ElecBillStatusEnum.NT180006) {
                msg = EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"51_ReceivablePledge4ElecListUI");
                MsgBox.showInfo((String)msg);
                SysUtil.abort();
            }
            if (wageBillEntryInfo.isPledgeRevoked()) {
                msg = EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"52_ReceivablePledge4ElecListUI");
                MsgBox.showInfo((String)msg);
                SysUtil.abort();
            }
            if (!wageBillEntryInfo.getReceivableBill().getExpiredDate().before(new Date())) continue;
            msg = EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"53_ReceivablePledge4ElecListUI");
            MsgBox.showInfo((String)msg);
            SysUtil.abort();
        }
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"receivableColl", (Object)receivableColl);
        uiContext.put((Object)"pledger", (Object)bank);
        uiContext.put((Object)"wageIDs", wageIDs);
        uiContext.put((Object)"oprState", (Object)"addnew");
        IUIWindow uiWindow = null;
        uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(PledgeRevokeBillEditUI.class.getName(), (Map)uiContext, null, OprtState.ADDNEW);
        uiWindow.show();
        Boolean succeed = ((PledgeRevokeBillEditUI)uiWindow.getUIObject()).getSuccessFlag();
        if (succeed.booleanValue()) {
            PledgeRevokeBillFactory.getRemoteInstance().updatePledgeBill(new HashSet(entryidList), true);
        }
        this.refreshList();
    }

    protected void tblMain_tableSelectChanged(KDTSelectEvent e) throws Exception {
        super.tblMain_tableSelectChanged(e);
        this.checkSelected();
        ArrayList idList = this.getSelectedIDs();
        if (idList.size() == 0) {
            return;
        }
        String id = (String)idList.get(0);
        if (BOSUuid.isValid((String)id, (boolean)true)) {
            WageInfo sourceBill = ((IWage)this.getBizInterface()).getWageInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)id)));
            boolean isAudited = sourceBill.getBillStatus() == FinBillStatusEnum.AUDITED;
            boolean isCommitedBE = sourceBill.isIsCommitToBE();
            this.actionDisPledge.setEnabled(isAudited && isCommitedBE);
        }
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("*");
        sic.add(new SelectorItemInfo("billEntrys.*"));
        sic.add(new SelectorItemInfo("billEntrys.elecBillStatus"));
        sic.add(new SelectorItemInfo("billEntrys.bankReturnStatus"));
        sic.add(new SelectorItemInfo("billEntrys.bankReturnMsg"));
        sic.add(new SelectorItemInfo("billEntrys.isNoteCancel"));
        sic.add(new SelectorItemInfo("billEntrys.receivableBill.*"));
        sic.add(new SelectorItemInfo("billEntrys.receivableBill.company.*"));
        sic.add(new SelectorItemInfo("billEntrys.receivableBill.ntType.*"));
        sic.add(new SelectorItemInfo("billEntrys.pledgeRevoked"));
        return sic;
    }
}

