/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.erec.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.extendcontrols.ext.IFilterInfoProducer;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ClientVerifyHelper;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.client.NewOrgViewF7PromptDialog;
import com.kingdee.eas.basedata.org.client.f7.NewOrgUnitFilterInfoProducer;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fm.common.AccessHelper;
import com.kingdee.eas.fm.common.FMSysDefinedEnum;
import com.kingdee.eas.fm.erec.DownLoadInnerEreceiptParam;
import com.kingdee.eas.fm.erec.client.AbstractDownLoadInnerEreceiptUI;
import com.kingdee.eas.fm.fs.InAcctFactory;
import com.kingdee.eas.fm.fs.SubsidiaryBillTypeEnum;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.enums.EnumUtils;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import org.apache.log4j.Logger;

public class DownLoadInnerEreceiptUI
extends AbstractDownLoadInnerEreceiptUI {
    private static final Logger logger = CoreUIObject.getLogger(DownLoadInnerEreceiptUI.class);
    private static final String RESOURCEPATH = "com.kingdee.eas.fm.be.FmBeEReceiptRescource";
    private static final String resourcePath = "com.kingdee.eas.fm.erec.ERecResources";
    static String flag = null;
    private DownLoadInnerEreceiptParam rstValue;
    private static final String PARAM_COMPANY = "company";
    private CompanyOrgUnitInfo companyInfo;

    public void onLoad() throws Exception {
        this.companyInfo = (CompanyOrgUnitInfo)this.getUIContext().get(PARAM_COMPANY);
        super.onLoad();
        this.initUI();
    }

    private void initBillTypeEnumItem(KDComboBox component) {
        component.removeAllItems();
        Object[] billTypeEnums = EnumUtils.getEnumList((String)"com.kingdee.eas.fm.fs.SubsidiaryBillTypeEnum").toArray();
        for (int i = 0; i < billTypeEnums.length; ++i) {
            SubsidiaryBillTypeEnum billTypeEnum = (SubsidiaryBillTypeEnum)billTypeEnums[i];
            if (!billTypeEnum.equals((Object)SubsidiaryBillTypeEnum.RECOUTSIDE) && !billTypeEnum.equals((Object)SubsidiaryBillTypeEnum.PAYOUTSIDE) && !billTypeEnum.equals((Object)SubsidiaryBillTypeEnum.RECINSIDE) && !billTypeEnum.equals((Object)SubsidiaryBillTypeEnum.PAYINSIDE) && !billTypeEnum.equals((Object)SubsidiaryBillTypeEnum.LINKPAY) && !billTypeEnum.equals((Object)SubsidiaryBillTypeEnum.RECINSIDEDIF) && !billTypeEnum.equals((Object)SubsidiaryBillTypeEnum.PAYINSIDEDIF) && !billTypeEnum.equals((Object)SubsidiaryBillTypeEnum.settleBatch) && !billTypeEnum.equals((Object)SubsidiaryBillTypeEnum.PAYOUTDIFFCUR) && !billTypeEnum.equals((Object)SubsidiaryBillTypeEnum.ACCRUALBILL) && !billTypeEnum.equals((Object)SubsidiaryBillTypeEnum.CHLOANBILL) && !billTypeEnum.equals((Object)SubsidiaryBillTypeEnum.ENTREPAYBILL) && !billTypeEnum.equals((Object)SubsidiaryBillTypeEnum.LOANINTERESTBILL) && !billTypeEnum.equals((Object)SubsidiaryBillTypeEnum.COMPDEPOSITBILL) && !billTypeEnum.equals((Object)SubsidiaryBillTypeEnum.COMPUNTIMEDEPOSITBILL) && !billTypeEnum.equals((Object)SubsidiaryBillTypeEnum.COMPUINTRECDEPOSITBILL) && !billTypeEnum.equals((Object)SubsidiaryBillTypeEnum.TransUpBill) && !billTypeEnum.equals((Object)SubsidiaryBillTypeEnum.TransDownBill) && !billTypeEnum.equals((Object)SubsidiaryBillTypeEnum.RECEIVABLEBILL) && !billTypeEnum.equals((Object)SubsidiaryBillTypeEnum.PAYABLEBILL) && !billTypeEnum.equals((Object)SubsidiaryBillTypeEnum.ENDORSEMENTBILL)) continue;
            component.addItem((Object)billTypeEnum);
        }
        component.addItem((Object)FMSysDefinedEnum.SELECT_ALL);
    }

    private void initUI() throws BOSException, EASBizException {
        this.initPrmtCompany();
        this.initBeginAndEndDate();
        this.initBillTypeEnumItem(this.comboBillType);
        this.comboBillType.setSelectedItem((Object)FMSysDefinedEnum.SELECT_ALL);
        this.prmtInnerAccount.setQueryInfo("com.kingdee.eas.fm.fs.F7InnerAccountQuery");
        this.prmtInnerAccount.setDisplayFormat("$number$ $name$");
        this.prmtInnerAccount.setEditFormat("$number$");
        this.prmtInnerAccount.setCommitFormat("$number$");
        this.prmtInnerAccount.setEditable(true);
        this.prmtInnerAccount.setRequired(true);
        this.prmtInnerAccount.setEnabledMultiSelection(true);
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        ev.setFilter(filter);
        HashSet<String> idSet = new HashSet<String>();
        if (this.prmtCompany.getData() instanceof CompanyOrgUnitInfo) {
            idSet.add(((CompanyOrgUnitInfo)this.prmtCompany.getData()).getId().toString());
        } else {
            Object[] companys = (Object[])this.prmtCompany.getData();
            if (companys != null && companys.length > 0) {
                for (int index = 0; index < companys.length; ++index) {
                    CompanyOrgUnitInfo org = (CompanyOrgUnitInfo)companys[index];
                    idSet.add(org.getId().toString());
                }
            }
        }
        if (idSet.size() > 0) {
            filter.getFilterItems().add(new FilterItemInfo("company.id", idSet, CompareType.INCLUDE));
        }
        this.prmtInnerAccount.setEntityViewInfo(ev);
    }

    private void initPrmtCompany() throws EASBizException, BOSException {
        if (flag.equals("CLEARINGHOUSE")) {
            CompanyOrgUnitCollection coll = InAcctFactory.getRemoteInstance().getInAcctApplyCompany();
            this.prmtCompany.setValue((Object)coll.toArray());
        } else {
            this.prmtCompany.setValue((Object)this.companyInfo);
        }
        NewOrgUnitFilterInfoProducer iProducer = new NewOrgUnitFilterInfoProducer(OrgType.Company);
        if ("CLEARINGHOUSE".equals(flag)) {
            iProducer.getModel().setPermissionItem(null);
        } else {
            iProducer.getModel().setPermissionItem("innerereceipt_View");
        }
        this.prmtCompany.setFilterInfoProducer((IFilterInfoProducer)iProducer);
        NewOrgViewF7PromptDialog model = iProducer.getModel();
        if (model != null) {
            this.prmtCompany.setSelector((KDPromptSelector)model);
            model.setMultiSelect(true);
        }
        this.prmtCompany.setCommitFormat("$number$;$name$");
    }

    private void initBeginAndEndDate() throws BOSException, EASBizException {
        this.dateFrom.setValue((Object)new Date());
        this.dateTo.setValue((Object)new Date());
    }

    public static DownLoadInnerEreceiptParam showDialogWindows(IUIObject ui, CompanyOrgUnitInfo companyInfo, String flagTag) throws Exception {
        flag = flagTag;
        UIContext uiContext = new UIContext((Object)ui);
        uiContext.put((Object)PARAM_COMPANY, (Object)companyInfo);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(DownLoadInnerEreceiptUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
        uiWindow.show();
        return ((DownLoadInnerEreceiptUI)uiWindow.getUIObject()).rstValue;
    }

    @Override
    public void actionConfirmDown_actionPerformed(ActionEvent e) throws Exception {
        this.verify();
        this.rstValue = this.getDownLoadInnerEreceiptParam();
        this.destroyWindow();
    }

    private void verify() throws EASBizException, BOSException {
        ClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDBizPromptBox)this.prmtCompany);
        this.verifyDate();
    }

    private void verifyDate() throws EASBizException, BOSException {
        if (this.dateFrom.getSqlDate() == null) {
            MsgBox.showWarning((String)EASResource.getString((String)RESOURCEPATH, (String)"CheckBeginDate"));
            SysUtil.abort();
        }
        if (this.dateTo.getSqlDate() == null) {
            MsgBox.showWarning((String)EASResource.getString((String)RESOURCEPATH, (String)"CheckEndDate"));
            SysUtil.abort();
        }
        if (DateTimeUtils.truncateDate((Date)this.dateTo.getSqlDate()).before(DateTimeUtils.truncateDate((Date)this.dateFrom.getSqlDate()))) {
            MsgBox.showWarning((String)EASResource.getString((String)RESOURCEPATH, (String)"ChecBeginAndEndkDate"));
            SysUtil.abort();
        }
        BigDecimal term = Constants.ZERO;
        BigDecimal time = BigDecimal.valueOf(31L);
        term = new BigDecimal(DateUtil.getDiffDays((Date)this.dateFrom.getSqlDate(), (Date)this.dateTo.getSqlDate()));
        if (term.compareTo(time) == 1) {
            MsgBox.showWarning((String)EASResource.getString((String)RESOURCEPATH, (String)"NotDownFromEReceipt"));
            SysUtil.abort();
        }
    }

    private DownLoadInnerEreceiptParam getDownLoadInnerEreceiptParam() throws BOSException {
        DownLoadInnerEreceiptParam rstValue = new DownLoadInnerEreceiptParam();
        HashSet<Object> innerAccountIdSet = null;
        Object[] accountBankIds = AccessHelper.getF7Ids((KDBizPromptBox)this.prmtInnerAccount);
        if (EmptyUtil.isEmpty((Object[])accountBankIds)) {
            MsgBox.showWarning((String)EASResource.getString((String)resourcePath, (String)"39_noInnerAccount"));
            SysUtil.abort();
        } else {
            innerAccountIdSet = new HashSet<Object>(Arrays.asList(accountBankIds));
        }
        if (this.prmtCompany.getData() instanceof CompanyOrgUnitInfo) {
            HashSet<String> idSet = new HashSet<String>();
            CompanyOrgUnitInfo org = (CompanyOrgUnitInfo)this.prmtCompany.getData();
            idSet.add(org.getId().toString());
            rstValue.setCompanyIdSet(idSet);
        } else {
            Object[] companys = (Object[])this.prmtCompany.getData();
            if (companys != null && companys.length > 0) {
                HashSet<String> idSet = new HashSet<String>();
                for (int index = 0; index < companys.length; ++index) {
                    CompanyOrgUnitInfo org = (CompanyOrgUnitInfo)companys[index];
                    idSet.add(org.getId().toString());
                }
                rstValue.setCompanyIdSet(idSet);
            }
        }
        if (this.comboBillType.getSelectedItem() == null || this.comboBillType.getSelectedItem().equals(FMSysDefinedEnum.SELECT_ALL)) {
            rstValue.setBillStatus(999);
        } else {
            rstValue.setBillStatus(((SubsidiaryBillTypeEnum)this.comboBillType.getSelectedItem()).getValue());
        }
        rstValue.setInnerAccountIdSet(innerAccountIdSet);
        rstValue.setBeginDate(this.dateFrom.getSqlDate());
        rstValue.setEndDate(this.dateTo.getSqlDate());
        return rstValue;
    }

    private EntityViewInfo getInnerAccountFilter() throws BOSException {
        HashSet<String> companyIdSet = new HashSet<String>();
        String[] companyIds = AccessHelper.getF7Ids((KDBizPromptBox)this.prmtCompany);
        int length = companyIds.length;
        for (int i = 0; i < length; ++i) {
            companyIdSet.add(companyIds[i]);
        }
        FilterInfo filterInfo = new FilterInfo();
        FilterItemCollection filterItems = filterInfo.getFilterItems();
        if (companyIdSet.size() > 0) {
            filterItems.add(new FilterItemInfo("company.id", companyIdSet, CompareType.INCLUDE));
            filterItems.add(new FilterItemInfo("closed", (Object)new Integer(0)));
            filterItems.add(new FilterItemInfo("isUsed", (Object)new Integer(1)));
        } else {
            filterItems.add(new FilterItemInfo("company.id", (Object)"000000"));
        }
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        entityViewInfo.setFilter(filterInfo);
        return entityViewInfo;
    }

    @Override
    public void actionCancelDown_actionPerformed(ActionEvent e) throws Exception {
        this.rstValue = null;
        this.destroyWindow();
    }

    @Override
    protected void prmtInnerAccount_willShow(SelectorEvent e) throws Exception {
        HashSet<String> idSet = new HashSet<String>();
        if (this.prmtCompany.getData() instanceof CompanyOrgUnitInfo) {
            idSet.add(((CompanyOrgUnitInfo)this.prmtCompany.getData()).getId().toString());
        } else {
            Object[] companys = (Object[])this.prmtCompany.getData();
            if (companys != null && companys.length > 0) {
                for (int index = 0; index < companys.length; ++index) {
                    CompanyOrgUnitInfo org = (CompanyOrgUnitInfo)companys[index];
                    idSet.add(org.getId().toString());
                }
            }
        }
        this.prmtInnerAccount.getQueryAgent().resetRuntimeEntityView();
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("applyUnit.id", idSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("closed", (Object)new Integer(0)));
        filter.getFilterItems().add(new FilterItemInfo("isUsed", (Object)new Integer(1)));
        evi.setFilter(filter);
        this.prmtInnerAccount.setEntityViewInfo(evi);
    }
}

