/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.erec.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.event.CommitEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.assistant.AccountBankCollection;
import com.kingdee.eas.basedata.assistant.AccountBankFactory;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.be.BankInterface;
import com.kingdee.eas.fm.be.EReceiptIsMatchEnum;
import com.kingdee.eas.fm.be.SharedAcctFacadeFactory;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.FMSysDefinedEnum;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.erec.ERecDetailMatchFilterParam;
import com.kingdee.eas.fm.erec.client.AbstractERecDetailFilterUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.DateTimeUtils;
import java.awt.event.ActionEvent;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.log4j.Logger;

public class ERecDetailFilterUI
extends AbstractERecDetailFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(ERecDetailFilterUI.class);
    private static final String resourcePath = "com.kingdee.eas.fm.erec.ERecResources";
    private Map bankInterMap = new HashMap();

    protected void init() throws Exception {
        super.init();
        this.startTransDate.setValue((Object)DateUtil.getDayBegin());
        this.endTransDate.setValue((Object)DateUtil.getDayBegin());
        this.initBankInterface();
        this.initIsMatch();
        this.setCompany();
        this.reSetF7BankAccountQuery();
        this.company.setEnabledMultiSelection(true);
        this.btnCompanySelect.setVisible(false);
    }

    public KDBizPromptBox getMainOrg() {
        return this.company;
    }

    private void initBankInterface() throws BOSException, EASBizException {
        this.bankInterface.removeAllItems();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setSelector(this.getSelectors());
        filter.getFilterItems().add(new FilterItemInfo("isClosed", (Object)new Integer(0)));
        filter.getFilterItems().add(new FilterItemInfo("isSetBankInterface", (Object)new Integer(1)));
        if (!FMClientHelper.isNotExistsMulBeService()) {
            CompanyOrgUnitInfo company = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
            filter.getFilterItems().add(new FilterItemInfo("company", (Object)company.getId()));
        }
        view.setFilter(filter);
        AccountBankCollection colls = AccountBankFactory.getRemoteInstance().getAccountBankCollection(view);
        int k = 0;
        this.bankInterMap.clear();
        for (int i = 0; i < colls.size(); ++i) {
            AccountBankInfo info = colls.get(i);
            BankInterface bankAcct = new BankInterface();
            if (FMHelper.isEmpty((String)info.getBankInterFaceID())) continue;
            bankAcct.setNumber(info.getBankInterFaceID());
            bankAcct.setName(info.getBankInterFace());
            if (this.bankInterMap.containsKey(bankAcct.getNumber())) continue;
            this.bankInterface.addItem((Object)bankAcct);
            this.bankInterMap.put(bankAcct.getNumber(), new Integer(k));
            ++k;
        }
        if (!this.bankInterMap.containsKey(null)) {
            BankInterface bankAcct = new BankInterface();
            bankAcct.setNumber(null);
            bankAcct.setName(EASResource.getString((String)"com.kingdee.eas.fm.be.FmbeResource", (String)"Select_All"));
            this.bankInterface.addItem((Object)bankAcct);
            this.bankInterMap.put(null, new Integer(this.bankInterMap.size() + 1));
        }
    }

    protected void initIsMatch() {
        this.isMatch.addItem((Object)EReceiptIsMatchEnum.AutoMatic);
        this.isMatch.addItem((Object)EReceiptIsMatchEnum.manual);
        this.isMatch.addItem((Object)EReceiptIsMatchEnum.UnMatch);
        this.isMatch.addItem((Object)FMSysDefinedEnum.SELECT_ALL);
        this.isMatch.setSelectedItem((Object)EReceiptIsMatchEnum.UnMatch);
    }

    public void setCompany() throws EASBizException, BOSException {
        this.company.setValue((Object)this.getCompanyOrgUnitInfoByUserPermisson());
    }

    private CompanyOrgUnitInfo getCompanyOrgUnitInfoByUserPermisson() throws EASBizException, BOSException {
        String userId = ContextHelperFactory.getRemoteInstance().getCurrentUser().getId().toString();
        boolean perm = PermissionFactory.getRemoteInstance().hasFunctionPermission((IObjectPK)new ObjectUuidPK(userId), (IObjectPK)new ObjectUuidPK(this.currentCompany.getId()), "eReceipt_Match_View");
        if (perm) {
            return this.currentCompany;
        }
        return null;
    }

    private void reSetF7BankAccountQuery() {
        BankInterface bankFace;
        this.accountBank.setData(null);
        FilterInfo filterInfo = new FilterInfo();
        FilterInfo companyFilter = new FilterInfo();
        FilterInfo agencyCompanyFilter = new FilterInfo();
        HashSet<String> idSet = new HashSet<String>();
        if (!EmptyUtil.isEmpty((AbstractObjectCollection)this.getMainOrgColl())) {
            CompanyOrgUnitCollection coll = this.getMainOrgColl();
            for (int i = 0; i < coll.size(); ++i) {
                idSet.add(coll.get(i).getId().toString());
            }
            companyFilter.getFilterItems().add(new FilterItemInfo("company.id", idSet, CompareType.INCLUDE));
            agencyCompanyFilter.getFilterItems().add(new FilterItemInfo("agencyCompany.id", idSet, CompareType.INCLUDE));
        }
        if (this.bankInterface.getSelectedItem() instanceof BankInterface && !EmptyUtil.isEmpty((String)(bankFace = (BankInterface)this.bankInterface.getSelectedItem()).getNumber())) {
            filterInfo.getFilterItems().add(new FilterItemInfo("bankInterFaceID", (Object)bankFace.getNumber()));
        }
        filterInfo.getFilterItems().add(new FilterItemInfo("isClosed", (Object)new Integer(0)));
        filterInfo.getFilterItems().add(new FilterItemInfo("isSetBankInterface", (Object)new Integer(1)));
        try {
            companyFilter.mergeFilter(agencyCompanyFilter, "or");
            filterInfo.mergeFilter(companyFilter, "and");
        }
        catch (BOSException e) {
            SysUtil.abort();
        }
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filterInfo);
        SelectorItemCollection selectors = new SelectorItemCollection();
        selectors.add("*");
        selectors.add("bank.*");
        selectors.add("account.*");
        this.accountBank.setSelectorCollection(selectors);
        this.accountBank.setEntityViewInfo(evi);
        this.accountBank.getQueryAgent().resetRuntimeEntityView();
        this.accountBank.setEnabledMultiSelection(true);
    }

    private CompanyOrgUnitCollection getMainOrgColl() {
        CompanyOrgUnitCollection coll = new CompanyOrgUnitCollection();
        Object mainBizOrgValue = this.company.getValue();
        if (mainBizOrgValue instanceof Object[]) {
            Object[] arrays = (Object[])mainBizOrgValue;
            for (int i = 0; i < arrays.length; ++i) {
                if (null == arrays[i]) continue;
                coll.add((CompanyOrgUnitInfo)arrays[i]);
            }
        } else if (mainBizOrgValue instanceof CompanyOrgUnitInfo) {
            coll.add((CompanyOrgUnitInfo)mainBizOrgValue);
        }
        return coll;
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected void chkIA_actionPerformed(ActionEvent e) throws Exception {
        super.chkIA_actionPerformed(e);
    }

    protected void btnCompanySelect_actionPerformed(ActionEvent e) throws Exception {
        super.btnCompanySelect_actionPerformed(e);
    }

    @Override
    protected void bankInterface_actionPerformed(ActionEvent e) throws Exception {
        this.reSetF7BankAccountQuery();
    }

    @Override
    protected void accountBank_willCommit(CommitEvent e) throws Exception {
        super.accountBank_willCommit(e);
    }

    @Override
    protected void accountBank_willShow(SelectorEvent e) throws Exception {
        super.accountBank_willShow(e);
    }

    @Override
    protected void company_dataChanged(DataChangeEvent e) throws Exception {
        this.reSetF7BankAccountQuery();
    }

    public Object getParam() {
        ERecDetailMatchFilterParam param = new ERecDetailMatchFilterParam();
        param.setStartTransDate(this.startTransDate.getSqlDate());
        param.setEndTransDate(this.endTransDate.getSqlDate());
        if (this.accountBank.getData() != null) {
            HashSet<String> idSet = new HashSet<String>();
            Object[] acctBank = (Object[])this.accountBank.getData();
            if (!EmptyUtil.isEmpty((Object[])acctBank)) {
                for (int i = 0; i < acctBank.length; ++i) {
                    idSet.add(((AccountBankInfo)acctBank[i]).getBankAccountNumber());
                }
                Map result = null;
                try {
                    result = SharedAcctFacadeFactory.getRemoteInstance().getSharedAcctAndCompany(idSet);
                }
                catch (EASBizException e) {
                    this.handUIException(e);
                }
                catch (BOSException e) {
                    this.handUIException(e);
                }
                AccountBankInfo[] acctBankInfoArry = (AccountBankInfo[])result.get("acctBank");
                String[] idStr = new String[acctBankInfoArry.length];
                for (int i = 0; i < acctBankInfoArry.length; ++i) {
                    idStr[i] = acctBankInfoArry[i].getId().toString();
                }
                param.setAccountBankIdArray(idStr);
                String[] companyIds = (String[])result.get("companys");
                HashSet<String> companyIdSet = new HashSet<String>();
                for (int i = 0; i < companyIds.length; ++i) {
                    companyIdSet.add(companyIds[i].toString());
                }
                param.setCompanyIdSet(companyIdSet);
            }
        } else {
            param.setAccountBankIdArray(null);
        }
        if (!EmptyUtil.isEmpty((AbstractObjectCollection)this.getMainOrgColl()) && EmptyUtil.isEmpty(param.getCompanyIdSet())) {
            CompanyOrgUnitCollection coll = this.getMainOrgColl();
            HashSet<String> idSet = new HashSet<String>();
            for (int i = 0; i < coll.size(); ++i) {
                idSet.add(coll.get(i).getId().toString());
            }
            param.setCompanyIdSet(idSet);
        }
        if (this.bankInterface.getSelectedItem() instanceof BankInterface) {
            BankInterface bankInterface = (BankInterface)this.bankInterface.getSelectedItem();
            param.setBankInterface(bankInterface.getNumber());
        } else {
            param.setBankInterface(null);
        }
        if (this.isMatch != null) {
            if (!this.isMatch.getSelectedItem().toString().equals(FMSysDefinedEnum.SELECT_ALL.toString())) {
                param.setIsMatch((EReceiptIsMatchEnum)this.isMatch.getSelectedItem());
            } else {
                param.setIsMatch(null);
            }
        }
        return param;
    }

    public void setParam(Object param) {
        if (param == null) {
            return;
        }
        if (!(param instanceof ERecDetailMatchFilterParam)) {
            return;
        }
        ERecDetailMatchFilterParam para = (ERecDetailMatchFilterParam)param;
        if (!EmptyUtil.isEmpty(para.getCompanyIdSet())) {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            view.setFilter(filter);
            filter.getFilterItems().add(new FilterItemInfo("id", para.getCompanyIdSet(), CompareType.INCLUDE));
            try {
                CompanyOrgUnitCollection coll = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitCollection(view);
                this.company.setValue((Object)coll.toArray());
            }
            catch (BOSException e) {
                this.handUIException(e);
                logger.error((Object)e);
            }
        } else {
            this.company.setValue(null);
        }
        this.startTransDate.setValue((Object)para.getStartTransDate());
        this.endTransDate.setValue((Object)para.getEndTransDate());
        if (FMHelper.isEmpty((String)para.getBankInterface())) {
            this.bankInterface.setSelectedItem(this.bankInterface.getItemAt(this.bankInterface.getItemCount() - 1));
        } else {
            int index = (Integer)this.bankInterMap.get(para.getBankInterface());
            FMClientHelper.setSelectObject((KDComboBox)this.bankInterface, (Object)this.bankInterface.getItemAt(index));
        }
        try {
            if (para.getAccountBankIdArray() != null) {
                String[] bankAcctId = para.getAccountBankIdArray();
                EntityViewInfo view = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("id", (Object)FMHelper.asSet((String[])bankAcctId), CompareType.INCLUDE));
                view.setFilter(filter);
                AccountBankCollection bankAcct = AccountBankFactory.getRemoteInstance().getAccountBankCollection(view);
                this.accountBank.setData((Object)bankAcct.toArray());
            } else {
                this.accountBank.setData(null);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (para.getIsMatch() != null) {
            this.isMatch.setSelectedItem((Object)para.getIsMatch());
        } else {
            this.isMatch.setSelectedItem((Object)FMSysDefinedEnum.SELECT_ALL);
        }
    }

    public boolean verify() {
        if (this.company.getValue() == null) {
            MsgBox.showWarning((String)EASResource.getString((String)resourcePath, (String)"19_noCompany"));
            SysUtil.abort();
        }
        if (this.startTransDate.getSqlDate() == null) {
            MsgBox.showWarning((String)EASResource.getString((String)resourcePath, (String)"20_noStartDate"));
            SysUtil.abort();
        }
        if (this.endTransDate.getSqlDate() == null) {
            MsgBox.showWarning((String)EASResource.getString((String)resourcePath, (String)"21_noEndDate"));
            SysUtil.abort();
        }
        if (DateTimeUtils.truncateDate((Date)this.endTransDate.getSqlDate()).before(DateTimeUtils.truncateDate((Date)this.startTransDate.getSqlDate()))) {
            MsgBox.showWarning((String)EASResource.getString((String)resourcePath, (String)"22_startEndDate"));
            SysUtil.abort();
        }
        if (this.accountBank.getData() == null) {
            MsgBox.showWarning((String)EASResource.getString((String)resourcePath, (String)"23_noBankNumber"));
            SysUtil.abort();
        }
        return super.verify();
    }

    protected Class getParamClass() {
        return ERecDetailMatchFilterParam.class;
    }

    public String getPermissionItem() {
        return "eReceipt_Match_View";
    }

    public boolean isSupportMultiOrgs() {
        return true;
    }

    @Override
    protected void isImport_actionPerformed(ActionEvent e) throws Exception {
        if (this.isImport.isSelected()) {
            this.bankInterface.setSelectedIndex(this.bankInterMap.size() - 1);
            this.reSetF7RpaBankAccountQuery();
        } else {
            this.initBankInterface();
            this.reSetF7BankAccountQuery();
        }
    }

    private void reSetF7RpaBankAccountQuery() {
        BankInterface bankFace;
        this.accountBank.setData(null);
        FilterInfo filterInfo = new FilterInfo();
        FilterInfo companyFilter = new FilterInfo();
        FilterInfo agencyCompanyFilter = new FilterInfo();
        HashSet<String> idSet = new HashSet<String>();
        if (!EmptyUtil.isEmpty((AbstractObjectCollection)this.getMainOrgColl())) {
            CompanyOrgUnitCollection coll = this.getMainOrgColl();
            for (int i = 0; i < coll.size(); ++i) {
                idSet.add(coll.get(i).getId().toString());
            }
            companyFilter.getFilterItems().add(new FilterItemInfo("company.id", idSet, CompareType.INCLUDE));
            agencyCompanyFilter.getFilterItems().add(new FilterItemInfo("agencyCompany.id", idSet, CompareType.INCLUDE));
        }
        if (this.bankInterface.getSelectedItem() instanceof BankInterface && !EmptyUtil.isEmpty((String)(bankFace = (BankInterface)this.bankInterface.getSelectedItem()).getNumber())) {
            filterInfo.getFilterItems().add(new FilterItemInfo("bankInterFaceID", (Object)bankFace.getNumber()));
        }
        filterInfo.getFilterItems().add(new FilterItemInfo("isClosed", (Object)new Integer(0)));
        if (!this.isImport.isSelected()) {
            filterInfo.getFilterItems().add(new FilterItemInfo("isEReceipt", (Object)new Integer(1)));
        }
        try {
            companyFilter.mergeFilter(agencyCompanyFilter, "or");
            filterInfo.mergeFilter(companyFilter, "and");
        }
        catch (BOSException e) {
            SysUtil.abort();
        }
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filterInfo);
        SelectorItemCollection selectors = new SelectorItemCollection();
        selectors.add("*");
        selectors.add("bank.*");
        selectors.add("account.*");
        this.accountBank.setSelectorCollection(selectors);
        this.accountBank.setEntityViewInfo(evi);
        this.accountBank.getQueryAgent().resetRuntimeEntityView();
        this.accountBank.setEnabledMultiSelection(true);
    }
}

