/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.erec.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fm.common.FilterParam;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMFilterBaseUI;
import com.kingdee.eas.fm.erec.EDMatchResultFactory;
import com.kingdee.eas.fm.erec.ERecDetailMatchFacadeFactory;
import com.kingdee.eas.fm.erec.ERecDetailMatchFilterParam;
import com.kingdee.eas.fm.erec.ERecDetailMatchResultFilterParam;
import com.kingdee.eas.fm.erec.IEDMatchResult;
import com.kingdee.eas.fm.erec.client.AbstractERecDetailMatchResultUI;
import com.kingdee.eas.fm.erec.client.ERecDetailMatchResultFilterUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class ERecDetailMatchResultUI
extends AbstractERecDetailMatchResultUI {
    private static final Logger logger = CoreUIObject.getLogger(ERecDetailMatchResultUI.class);
    boolean isDirectShow = false;
    private final String SELECT = "selected";
    private static final String TRANSDETAIL = "com.kingdee.eas.fm.be.app.TransDetail";
    private static final String ERECEIPT = "com.kingdee.eas.fi.be.app.EReceipt";
    private static ERecDetailMatchResultFilterUI filter = null;
    private int scale = 2;
    Set<String> idSet = new HashSet<String>();
    private static final String resourcePath = "com.kingdee.eas.fm.erec.ERecResources";
    FillListener fillListener = new FillListener();

    public void onLoad() throws Exception {
        this.tblMain.checkParsed();
        this.tblMain.getGroupManager().setGroup(true);
        this.tblMain.getMergeManager().setMergeMode(5);
        super.onLoad();
        this.actionAuditResult.setVisible(false);
        this.actionAttachment.setVisible(false);
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.actionAntiMatch.setEnabled(true);
        this.actionSelectAll.setEnabled(true);
        this.actionClearAll.setEnabled(true);
    }

    public FMFilterBaseUI getFilterUI() throws Exception {
        ERecDetailMatchFilterParam param = (ERecDetailMatchFilterParam)this.getUIContext().get("filterParam");
        ERecDetailMatchFilterParam oldParam = ERecDetailMatchResultFilterUI.getSuperParam();
        if (oldParam == null && param != null || oldParam != null && !oldParam.equals(param)) {
            ERecDetailMatchResultFilterUI.setSuperParam(param);
            filter = new ERecDetailMatchResultFilterUI();
        } else if (filter == null) {
            filter = new ERecDetailMatchResultFilterUI();
        }
        return filter;
    }

    public CommonQueryDialog getQueryDlg() throws Exception {
        CommonQueryDialog dlg = super.getQueryDlg();
        dlg.setWidth(586);
        return dlg;
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
    }

    protected boolean isCanOrderTable() {
        return false;
    }

    protected void initListener() {
        super.initListener();
        this.tblMain.getDataRequestManager().addDataFillListener((KDTDataFillListener)this.fillListener);
    }

    public static void showMatchResultUI(CoreUIObject ui, Set<String> matchResultKeys) {
        UIContext uiContext = new UIContext((Object)ui);
        uiContext.put((Object)"METADATA.PK", (Object)new MetaDataPK("com.kingdee.eas.fm.erec.client", "ERecDetailMatchResultUI"));
        if (!EmptyUtil.isEmpty(matchResultKeys)) {
            uiContext.put((Object)"matchResultKeys", matchResultKeys);
            uiContext.put((Object)"isDirectShow", (Object)true);
        }
        try {
            IUIWindow listUI = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewTabFactory").create(ERecDetailMatchResultUI.class.getName(), (Map)uiContext, null, OprtState.EDIT);
            listUI.show();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            SysUtil.abort();
        }
    }

    public static void showMatchResultUI(CoreUIObject ui, UIContext UiContext, Set<String> matchResultKeys) throws Exception {
        UIContext uiContext = new UIContext((Object)ui);
        uiContext.put((Object)"METADATA.PK", (Object)new MetaDataPK("com.kingdee.eas.fm.erec.client", "ERecDetailMatchResultUI"));
        ERecDetailMatchFilterParam param = (ERecDetailMatchFilterParam)UiContext.get((Object)"filterParam");
        uiContext.put((Object)"filterParam", (Object)param);
        IUIWindow listUI = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewTabFactory").create(ERecDetailMatchResultUI.class.getName(), (Map)uiContext, null, OprtState.EDIT);
        listUI.show();
    }

    protected boolean isDirectShow() {
        if (!EmptyUtil.isEmpty(this.getUIContext().get("isDirectShow"))) {
            this.isDirectShow = (Boolean)this.getUIContext().get("isDirectShow");
        }
        return this.isDirectShow;
    }

    protected void execQuery() {
        if (this.isDirectShow) {
            FilterInfo filter = new FilterInfo();
            if (!EmptyUtil.isEmpty(this.getUIContext().get("matchResultKeys"))) {
                filter.getFilterItems().add(new FilterItemInfo("key", this.getUIContext().get("matchResultKeys"), CompareType.INCLUDE));
            }
            try {
                if (this.mainQuery.getFilter() == null) {
                    this.mainQuery.setFilter(filter);
                } else {
                    this.mainQuery.getFilter().mergeFilter(filter, "AND");
                }
                ERecDetailMatchResultFilterParam filterParam = new ERecDetailMatchResultFilterParam();
                SorterItemCollection sort = filterParam.getSorterItems();
                this.mainQuery.setSorter(sort);
            }
            catch (BOSException e) {
                this.handUIExceptionAndAbort((Exception)((Object)e));
            }
            this.actionQuery.setVisible(false);
            this.actionRefresh.setVisible(false);
        } else {
            FilterInfo filterInfo = new FilterInfo();
            try {
                Set keySet = this.getBizInterface().getKeysByFilterInfo(this.mainQuery.getFilter(), ERECEIPT);
                if (keySet.size() > 0) {
                    filterInfo.getFilterItems().add(new FilterItemInfo("key", (Object)keySet, CompareType.INCLUDE));
                    this.mainQuery.setFilter(filterInfo);
                } else {
                    filterInfo.getFilterItems().add(new FilterItemInfo("bizObjectFullName", (Object)"ErecDetail", CompareType.EQUALS));
                    this.mainQuery.setFilter(filterInfo);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        super.execQuery();
        this.idSet.clear();
    }

    public void executeQuery(FilterParam param) throws BOSException {
        super.executeQuery(param);
        ERecDetailMatchResultFilterParam params = (ERecDetailMatchResultFilterParam)param;
        Date startDate = params.getStartDate();
        Date endDate = params.getEndDate();
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        this.txtStartDate.setText(df.format(startDate));
        this.txtEndDate.setText(df.format(endDate));
    }

    @Override
    public void actionSelectAll_actionPerformed(ActionEvent e) throws Exception {
        int rowCount = this.tblMain.getRowCount();
        if (rowCount <= 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.cas.CheckoutResource", (String)"RecordNullMsg"));
            return;
        }
        this.idSet.clear();
        for (int i = 0; i < this.tblMain.getRowCount(); ++i) {
            this.tblMain.getRow(i).getCell("selected").setValue((Object)Boolean.TRUE);
            String key = (String)this.tblMain.getRow(i).getCell("key").getValue();
            this.idSet.add(key);
        }
    }

    @Override
    public void actionClearAll_actionPerformed(ActionEvent e) throws Exception {
        this.refresh(e);
    }

    @Override
    public void actionAntiMatch_actionPerformed(ActionEvent e) throws Exception {
        Set<String> idSet = this.getResultSetSelected();
        if (idSet.size() > 0) {
            Map map = ERecDetailMatchFacadeFactory.getRemoteInstance().erecDetailAntiMatch(idSet);
            String failMsg = (String)map.get("antiMatchFail");
            if (EmptyUtil.isEmpty((String)failMsg)) {
                MsgBox.showInfo((String)EASResource.getString((String)resourcePath, (String)"24_matchSuccess"));
            } else {
                MsgBox.showWarning((Component)((Object)this), (String)failMsg);
            }
            this.refresh(e);
        } else {
            MsgBox.showWarning((String)EASResource.getString((String)resourcePath, (String)"14_antiMatchAction"));
            SysUtil.abort();
        }
    }

    @Override
    protected void tblMain_editValueChanged(KDTEditEvent e) throws Exception {
        Object value;
        int index = e.getRowIndex();
        if (e.getColIndex() == this.tblMain.getColumn("selected").getColumnIndex() && (value = e.getValue()) != null) {
            String key = (String)this.tblMain.getRow(index).getCell("key").getValue();
            if (((Boolean)value).booleanValue()) {
                this.idSet.add(key);
            } else {
                this.idSet.remove(key);
            }
        }
    }

    protected Set<String> getResultSetSelected() throws Exception {
        return this.idSet;
    }

    protected IEDMatchResult getBizInterface() throws Exception {
        return EDMatchResultFactory.getRemoteInstance();
    }

    private final class FillListener
    implements KDTDataFillListener {
        private FillListener() {
        }

        public void afterDataFill(KDTDataRequestEvent e) {
            for (int i = e.getFirstRow(); i <= e.getLastRow(); ++i) {
                IRow row = ERecDetailMatchResultUI.this.tblMain.getRow(i);
                row.getCell("selected").setValue((Object)false);
                row.getCell("selected").getStyleAttributes().setLocked(false);
                if (row.getCell("bizObjectFullName").getValue().equals(ERecDetailMatchResultUI.TRANSDETAIL)) {
                    row.getCell("bizName").setValue((Object)EASResource.getString((String)ERecDetailMatchResultUI.resourcePath, (String)"10_TransDeatil"));
                } else {
                    row.getCell("bizName").setValue((Object)EASResource.getString((String)ERecDetailMatchResultUI.resourcePath, (String)"11_EReceipt"));
                }
                ERecDetailMatchResultUI.this.tblMain.getColumn("creditAmount").getStyleAttributes().setNumberFormat(FMClientHelper.getKDTNumFormat((int)ERecDetailMatchResultUI.this.scale));
                ERecDetailMatchResultUI.this.tblMain.getColumn("creditAmount").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
                ERecDetailMatchResultUI.this.tblMain.getColumn("debitAmount").getStyleAttributes().setNumberFormat(FMClientHelper.getKDTNumFormat((int)ERecDetailMatchResultUI.this.scale));
                ERecDetailMatchResultUI.this.tblMain.getColumn("debitAmount").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
            }
        }
    }
}

