/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.erec.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.fm.be.EReceiptCollection;
import com.kingdee.eas.fm.be.EReceiptFactory;
import com.kingdee.eas.fm.be.EReceiptInfo;
import com.kingdee.eas.fm.be.EReceiptStorageSettingCollection;
import com.kingdee.eas.fm.be.EReceiptStorageSettingFactory;
import com.kingdee.eas.fm.be.EReceiptStorageSettingInfo;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMFilterBaseUI;
import com.kingdee.eas.fm.common.service.FMActionProxy;
import com.kingdee.eas.fm.erec.DownLoadInnerEreceiptParam;
import com.kingdee.eas.fm.erec.InnerEreceiptDownFacadeFactory;
import com.kingdee.eas.fm.erec.client.AbstractInnerEReceiptListUI;
import com.kingdee.eas.fm.erec.client.DownLoadInnerEreceiptUI;
import com.kingdee.eas.fm.erec.client.EReceiptInnerClientHelper;
import com.kingdee.eas.fm.erec.client.InnerEReceiptFilterUI;
import com.kingdee.eas.fm.fs.SubsidiaryLedgerCollection;
import com.kingdee.eas.fm.fs.SubsidiaryLedgerFactory;
import com.kingdee.eas.fm.fs.SubsidiaryLedgerInfo;
import com.kingdee.eas.fm.fs.TransUpDownBillHelper;
import com.kingdee.eas.fm.fs.client.FSClientHelper;
import com.kingdee.eas.framework.ContextTypeEnum;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.batchaction.ActionLevelEnum;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.framework.batchaction.ITableSelectionHelper;
import com.kingdee.eas.framework.batchaction.service.BatchActionManager;
import com.kingdee.eas.framework.client.ListUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class InnerEReceiptListUI
extends AbstractInnerEReceiptListUI {
    private static final Logger logger = CoreUIObject.getLogger(InnerEReceiptListUI.class);
    private static final String resourcePath = "com.kingdee.eas.fm.erec.ERecResources";
    private InnerEReceiptFilterUI filterUI;
    String flag = null;
    private static final String CLEARINGHOUSE_PERMISSION = "eReceipt_ViewInner";
    private static final String CAS_PERMISSION = "innerereceipt_View";
    private static final CompanyOrgUnitInfo currentCompany = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
    CompanyOrgUnitCollection coll = null;

    public void onLoad() throws Exception {
        if (this.getUIContext().get("UIClassParam") != null) {
            this.flag = (String)this.getUIContext().get("UIClassParam");
        }
        String permission = null;
        if (this.flag.equals("CLEARINGHOUSE")) {
            FSClientHelper.checkClearingHouseCompany();
            permission = CLEARINGHOUSE_PERMISSION;
        } else {
            permission = CAS_PERMISSION;
        }
        IPermission iPermission = PermissionFactory.getRemoteInstance();
        iPermission.checkFunctionPermission(this.getUserPk(), (IObjectPK)new ObjectUuidPK(currentCompany.getId().toString()), permission);
        super.onLoad();
        this.initTable();
    }

    protected void execQuery() {
        super.execQuery();
        this.setsrcBill();
        this.initTable();
    }

    public void setsrcBill() {
        List idlist = new ArrayList();
        idlist = this.getQueryPkList();
        for (int i = 0; i < idlist.size(); ++i) {
            IRow row = this.tblMain.getRow(i);
            if (((BigDecimal)row.getCell("debitAmount").getValue()).compareTo(BigDecimal.ZERO) == 0) {
                row.getCell("debitAmount").setValue(null);
            }
            if (((BigDecimal)row.getCell("creditAmount").getValue()).compareTo(BigDecimal.ZERO) != 0) continue;
            row.getCell("creditAmount").setValue(null);
        }
    }

    private void initTable() {
        if (this.flag.equals("CLEARINGHOUSE")) {
            this.tblMain.getColumn("memberUnitPrintCount").getStyleAttributes().setHided(true);
            this.tblMain.getColumn("memberUnitFirstPrintPerson").getStyleAttributes().setHided(true);
            this.tblMain.getColumn("memberUnitPrintDate").getStyleAttributes().setHided(true);
        } else {
            this.tblMain.getColumn("printCount").getStyleAttributes().setHided(true);
            this.tblMain.getColumn("firstPrintPerson").getStyleAttributes().setHided(true);
            this.tblMain.getColumn("printDate").getStyleAttributes().setHided(true);
        }
        this.setColumnFmt(this.tblMain);
    }

    protected void setColumnFmt(KDTable tblMain) {
        String strFormat = "%r-[ ]{###,###,##0.00}15.2n";
        tblMain.getColumn("debitAmount").getStyleAttributes().setNumberFormat(strFormat);
        tblMain.getColumn("debitAmount").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        tblMain.getColumn("creditAmount").getStyleAttributes().setNumberFormat(strFormat);
        tblMain.getColumn("creditAmount").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        tblMain.getColumn("amount").getStyleAttributes().setNumberFormat(strFormat);
        tblMain.getColumn("amount").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.actionAddNew.setVisible(false);
        this.actionEdit.setVisible(false);
        this.actionAttachment.setVisible(false);
        this.actionCreateTo.setVisible(false);
        this.actionTraceUp.setVisible(false);
        this.actionTraceDown.setVisible(false);
        this.actionWorkFlowG.setVisible(false);
        this.actionAuditResult.setVisible(false);
        this.actionPrintPreview.setVisible(true);
        this.menuWorkFlow.setVisible(false);
        this.menuItemCopyTo.setVisible(false);
        this.actionNavBills.setVisible(true);
        this.actionNavBills.setEnabled(true);
        this.actionNavBills.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_sequencecheck"));
        this.downLoadInnerEreceipt.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_downbill"));
    }

    protected CommonQueryDialog getQueryDlg() throws Exception {
        CommonQueryDialog dlg = super.getQueryDlg();
        dlg.setHeight(300);
        dlg.setWidth(400);
        String className = this.getMetaDataPK().getFullName();
        if (this.flag != null) {
            dlg.setParentUIClassName(className + "_" + this.flag);
        }
        return dlg;
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    public void actionNavBills_actionPerformed(ActionEvent e) throws Exception {
        String permission = null;
        permission = this.flag.equals("CLEARINGHOUSE") ? "eReceipt_InnerNavBill" : "innerereceipt_NavBill";
        IPermission iPermission = PermissionFactory.getRemoteInstance();
        iPermission.checkFunctionPermission(this.getUserPk(), (IObjectPK)new ObjectUuidPK(currentCompany.getId().toString()), permission);
        this.checkSelected();
        ArrayList idList = this.getSelectedIdValues();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("innerEReceiptId", (Object)FMHelper.list2Set((List)idList), CompareType.INCLUDE));
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("billId"));
        view.setSelector(sic);
        SubsidiaryLedgerCollection coll = SubsidiaryLedgerFactory.getRemoteInstance().getSubsidiaryLedgerCollection(view);
        if (coll.size() > 0) {
            SubsidiaryLedgerInfo info = coll.get(0);
            String billId = info.getBillId().toString();
            if (billId != null) {
                billId = TransUpDownBillHelper.changeTransBillId((String)billId);
                FMClientHelper.viewDetailBill((CoreUIObject)this, (String)billId, (CompanyOrgUnitInfo)ContextHelperFactory.getRemoteInstance().getCurrentCompany());
            }
        } else {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)resourcePath, (String)"28_innerAccount"));
            SysUtil.abort();
        }
    }

    protected ICoreBase getBizInterface() throws Exception {
        return EReceiptFactory.getRemoteInstance();
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
        EReceiptInfo info;
        this.checkSelected();
        ArrayList idList = this.getSelectedIdValues();
        EntityViewInfo View = new EntityViewInfo();
        SelectorItemCollection Sic = new SelectorItemCollection();
        Sic.add(new SelectorItemInfo("*"));
        View.setSelector(Sic);
        EReceiptStorageSettingCollection colls = EReceiptStorageSettingFactory.getRemoteInstance().getEReceiptStorageSettingCollection(View);
        EReceiptStorageSettingInfo settinginfo = colls.get(0);
        EntityViewInfo erview = new EntityViewInfo();
        FilterInfo erfilter = new FilterInfo();
        erfilter.getFilterItems().add(new FilterItemInfo("id", idList.get(0), CompareType.EQUALS));
        erview.setFilter(erfilter);
        SelectorItemCollection ersic = new SelectorItemCollection();
        ersic.add(new SelectorItemInfo("fileSource"));
        erview.setSelector(ersic);
        EReceiptCollection coll = EReceiptFactory.getRemoteInstance().getEReceiptCollection(erview);
        if (coll.size() > 0 && ((Integer.parseInt((info = coll.get(0)).getFileSource()) == 1 || Integer.parseInt(info.getFileSource()) == 2) && (settinginfo.getStorageType().getValue() == 3 || settinginfo.getStorageType().getValue() == 2) || Integer.parseInt(info.getFileSource()) == 4 && settinginfo.getStorageType().getValue() != 3)) {
            String exMsg = EASResource.getString((String)resourcePath, (String)"29_exMsg");
            MsgBox.showWarning((String)exMsg);
            SysUtil.abort();
        }
        boolean isClearingHouse = this.flag.equals("CLEARINGHOUSE");
        EReceiptInnerClientHelper.viewInnerEReceiptByIdList(idList, (Component)((Object)this), isClearingHouse);
    }

    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        boolean isClearingHouse;
        this.checkSelected();
        ArrayList idList = this.getSelectedIdValues();
        String permission = null;
        if (this.flag.equals("CLEARINGHOUSE")) {
            permission = "eReceipt_InnerPrint";
            isClearingHouse = true;
        } else {
            permission = "innerereceipt_Print";
            isClearingHouse = false;
        }
        IPermission iPermission = PermissionFactory.getRemoteInstance();
        iPermission.checkFunctionPermission(this.getUserPk(), (IObjectPK)new ObjectUuidPK(currentCompany.getId().toString()), permission);
        EReceiptInnerClientHelper.printInnerEReceiptByIdList(idList, (Component)((Object)this), isClearingHouse);
    }

    public FMFilterBaseUI getFilterUI() throws Exception {
        if (this.filterUI == null) {
            this.filterUI = new InnerEReceiptFilterUI(this.flag);
        }
        return this.filterUI;
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        String permission = null;
        IPermission iPermission = PermissionFactory.getRemoteInstance();
        if (this.flag.equals("CLEARINGHOUSE")) {
            permission = "eReceipt_InnerDelete";
            iPermission.checkFunctionPermission(this.getUserPk(), (IObjectPK)new ObjectUuidPK(ContextHelperFactory.getRemoteInstance().getCurrentCompany().getId().toString()), permission);
        } else {
            permission = "innerereceipt_Delete";
            ArrayList ids = this.getSelectedIdValues();
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)FMHelper.list2Set((List)ids), CompareType.INCLUDE));
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("innerAccount.id"));
            sic.add(new SelectorItemInfo("innerAccount.applyUnit.id"));
            view.setSelector(sic);
            view.setFilter(filter);
            EReceiptCollection eReceiptCollection = EReceiptFactory.getRemoteInstance().getEReceiptCollection(view);
            HashSet<String> companyIdSet = new HashSet<String>();
            for (int i = 0; i < eReceiptCollection.size(); ++i) {
                EReceiptInfo eReceiptInfo = eReceiptCollection.get(i);
                if (eReceiptInfo.getInnerAccount() == null || eReceiptInfo.getInnerAccount().getApplyUnit() == null) continue;
                companyIdSet.add(eReceiptInfo.getInnerAccount().getApplyUnit().getId().toString());
            }
            for (String id : companyIdSet) {
                iPermission.checkFunctionPermission(this.getUserPk(), (IObjectPK)new ObjectUuidPK(id.toString()), permission);
            }
        }
        this.checkSelected();
        BatchActionManager actionManager = new BatchActionManager((CoreUIObject)this, ContextTypeEnum.INQUERYING);
        actionManager.setTableSelectionHelper((ITableSelectionHelper)this.getTableSelectionHelper());
        actionManager.setServiceContext(this.getServiceContext());
        actionManager.setClzIBizFactory(ActionLevelEnum.HEAD, EReceiptFactory.class);
        FMActionProxy actionProxy = new FMActionProxy((ItemAction)this.actionRemove, "batchRemove", BatchActionEnum.DELETE, actionManager);
        actionProxy.actionPerformed(e);
    }

    public void initBatchActions() throws BOSException {
        this.actionManager.setClzIBizFactory(ActionLevelEnum.HEAD, EReceiptFactory.class);
        this.getTableSelectionHelper().setTableProperty((ListUI)this, this.mainQueryPK, this.tblMain, "id", null, "fileName", null, "company.id");
        Object actionProxy = null;
    }

    public boolean isSupportedBatchActions() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void downLoadInnerEreceipt_actionPerformed(ActionEvent e) throws Exception {
        String permission = null;
        permission = this.flag.equals("CLEARINGHOUSE") ? "eReceipt_InnerDown" : "innerereceipt_Down";
        IPermission iPermission = PermissionFactory.getRemoteInstance();
        iPermission.checkFunctionPermission(this.getUserPk(), (IObjectPK)new ObjectUuidPK(ContextHelperFactory.getRemoteInstance().getCurrentCompany().getId().toString()), permission);
        CompanyOrgUnitInfo companyInfo = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        DownLoadInnerEreceiptParam downParam = DownLoadInnerEreceiptUI.showDialogWindows((IUIObject)this, companyInfo, this.flag);
        if (downParam != null) {
            ArrayList<String> appliedList = new ArrayList<String>();
            Set innerAcctSet = downParam.getInnerAccountIdSet();
            ArrayList allList = new ArrayList(innerAcctSet);
            IMutexServiceControl iMutex = MutexServiceControlFactory.getRemoteInstance();
            try {
                Map requestResult = iMutex.batchRequestBizObjIDForUpdate(allList);
                boolean boolResult = false;
                for (String id : requestResult.keySet()) {
                    boolResult = (Boolean)requestResult.get(id);
                    if (!boolResult) continue;
                    appliedList.add(id);
                }
                downParam.setInnerAccountIdSet(FMHelper.list2Set(appliedList));
                int count = InnerEreceiptDownFacadeFactory.getRemoteInstance().downInnerErecByHand(downParam);
                MsgBox.showInfo((String)EASResource.getString((String)resourcePath, (String)"30_innerDownPdf", (Object[])new Object[]{count}));
            }
            finally {
                if (appliedList.size() > 0) {
                    iMutex.batchReleaseObjIDForUpdate(appliedList);
                }
            }
        }
        this.actionRefresh_actionPerformed(e);
    }
}

