/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.erec.client;

import com.kingdee.bos.BOSLocaleUtil;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.KDNoteHelper;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.util.NoteDistributionUtil;
import com.kingdee.bos.ctrl.reportone.kdrs.biz.content.IBizContent;
import com.kingdee.bos.ctrl.reportone.kdrs.exception.KDRSException;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMClientVerifyHelper;
import com.kingdee.eas.fm.erec.ErecTemplateInfo;
import com.kingdee.eas.fm.erec.InnerEReceiptBizTypeEnum;
import com.kingdee.eas.fm.erec.InnerEReceiptTemplateFactory;
import com.kingdee.eas.fm.erec.InnerEReceiptTemplateInfo;
import com.kingdee.eas.fm.erec.client.AbstractInnerEReceiptTemplateEditUI;
import com.kingdee.eas.fm.fs.SubsidiaryBillTypeEnum;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.CoreUI;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class InnerEReceiptTemplateEditUI
extends AbstractInnerEReceiptTemplateEditUI {
    private static final Logger logger = CoreUIObject.getLogger(InnerEReceiptTemplateEditUI.class);
    private Map templateMap = new HashMap();
    public static Map contentPathMap = new HashMap();
    CompanyOrgUnitInfo currentCompany;

    public void onLoad() throws Exception {
        this.currentCompany = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        InnerEReceiptTemplateEditUI.setContentPathMap();
        super.onLoad();
        this.prmtCompany.setData((Object)this.currentCompany);
        this.initBizType();
        this.initBillType();
        if (this.editData.getBillType() != null) {
            this.comboBillType.setSelectedItem((Object)this.editData.getBillType());
        }
        if (this.editData.getTemplateName() != null || this.editData.getTemplateID() != null) {
            int index = (Integer)this.templateMap.get(this.editData.getTemplateID());
            this.Template.setSelectedItem(this.Template.getItemAt(index));
        }
    }

    @Override
    public void loadFields() {
        FMClientHelper.initNumber((CoreBaseInfo)this.editData, (KDTextField)this.txtNumber, (String)this.currentCompany.getId().toString());
        if (this.editData.getTemplateID() == null) {
            this.Template.removeAllItems();
        }
        super.loadFields();
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        FMClientVerifyHelper.verifyUIControlEmpty((CoreUI)this);
    }

    @Override
    protected void comboBizType_itemStateChanged(ItemEvent e) throws Exception {
        if (e != null) {
            super.comboBizType_itemStateChanged(e);
            if (e.getStateChange() == 2) {
                return;
            }
        }
        this.initBillType();
    }

    private void initBizType() {
        this.comboBizType.removeItem((Object)InnerEReceiptBizTypeEnum.CONSIGNMENT);
    }

    private void initBillType() {
        InnerEReceiptBizTypeEnum bizTypeEnum = (InnerEReceiptBizTypeEnum)((Object)this.comboBizType.getSelectedItem());
        if (bizTypeEnum != null) {
            this.comboBillType.removeAllItems();
            switch (bizTypeEnum.getValue()) {
                case 1: {
                    this.comboBillType.addItem((Object)SubsidiaryBillTypeEnum.RECOUTSIDE);
                    this.comboBillType.addItem((Object)SubsidiaryBillTypeEnum.PAYOUTSIDE);
                    this.comboBillType.addItem((Object)SubsidiaryBillTypeEnum.RECINSIDE);
                    this.comboBillType.addItem((Object)SubsidiaryBillTypeEnum.PAYINSIDE);
                    this.comboBillType.addItem((Object)SubsidiaryBillTypeEnum.LINKPAY);
                    this.comboBillType.addItem((Object)SubsidiaryBillTypeEnum.ACCRUALBILL);
                    break;
                }
                case 2: {
                    this.comboBillType.addItem((Object)SubsidiaryBillTypeEnum.TransUpBill);
                    this.comboBillType.addItem((Object)SubsidiaryBillTypeEnum.TransDownBill);
                    break;
                }
                case 3: {
                    this.comboBillType.addItem((Object)SubsidiaryBillTypeEnum.CHLOANBILL);
                    this.comboBillType.addItem((Object)SubsidiaryBillTypeEnum.ENTREPAYBILL);
                    this.comboBillType.addItem((Object)SubsidiaryBillTypeEnum.LOANINTERESTBILL);
                    break;
                }
                case 4: {
                    this.comboBillType.addItem((Object)SubsidiaryBillTypeEnum.COMPDEPOSITBILL);
                    this.comboBillType.addItem((Object)SubsidiaryBillTypeEnum.COMPUNTIMEDEPOSITBILL);
                    this.comboBillType.addItem((Object)SubsidiaryBillTypeEnum.COMPUINTRECDEPOSITBILL);
                    break;
                }
                case 5: {
                    this.comboBillType.addItem((Object)SubsidiaryBillTypeEnum.CONSIGNLOAN);
                    this.comboBillType.addItem((Object)SubsidiaryBillTypeEnum.CONSIGNLOANREPY);
                    this.comboBillType.addItem((Object)SubsidiaryBillTypeEnum.CONSIGNLOANINT);
                    break;
                }
                case 6: {
                    this.comboBillType.addItem((Object)SubsidiaryBillTypeEnum.RECEIVABLEBILL);
                    this.comboBillType.addItem((Object)SubsidiaryBillTypeEnum.ENDORSEMENTBILL);
                    this.comboBillType.addItem((Object)SubsidiaryBillTypeEnum.PAYABLEBILL);
                    break;
                }
            }
        }
    }

    public static void setContentPathMap() {
        contentPathMap.put(1, "FM/FS/SETTLE");
        contentPathMap.put(2, "FM/FS/SETTLE");
        contentPathMap.put(3, "FM/FS/SETTLE");
        contentPathMap.put(4, "FM/FS/SETTLE");
        contentPathMap.put(5, "FM/FS/SETTLE");
        contentPathMap.put(12, "FM/IM/IM");
        contentPathMap.put(10, "FM/FS/FEE");
        contentPathMap.put(40, "FM/TR/UP");
        contentPathMap.put(41, "FM/TR/DOWN");
        contentPathMap.put(15, "FM/INVEST/IVT/CHLOAN");
        contentPathMap.put(20, "FM/INVEST/IVT/ENTREPAY");
        contentPathMap.put(25, "FM/IM/LOANINTR");
        contentPathMap.put(30, "FM/FIN/COMPDEPOSIT");
        contentPathMap.put(31, "FM/FIN/COMPUNTIMEDEPOSIT");
        contentPathMap.put(32, "FM/IM/INTRECEIVED");
        contentPathMap.put(221, "FM/INVEST/CL/CL");
        contentPathMap.put(223, "FM/INVEST/CL/CONSIGNMENTREPAY");
        contentPathMap.put(222, "FM/IM/CONSIGNMENTINT");
        contentPathMap.put(56, "FM/NT/AC");
        contentPathMap.put(54, "FM/NT/EndorsementBill");
        contentPathMap.put(57, "FM/FIN/REPAYMENT");
    }

    @Override
    protected void comboBillType_itemStateChanged(ItemEvent e) throws Exception {
        if (e != null) {
            super.comboBillType_itemStateChanged(e);
            if (e.getStateChange() == 2) {
                return;
            }
        }
        SubsidiaryBillTypeEnum billTypeEnum = (SubsidiaryBillTypeEnum)this.comboBillType.getSelectedItem();
        InnerEReceiptBizTypeEnum bizTypeEnum = (InnerEReceiptBizTypeEnum)((Object)this.comboBizType.getSelectedItem());
        String path = "/EAS_Note.kdrs/";
        String contentPath = null;
        if (billTypeEnum != null) {
            contentPath = path + contentPathMap.get(billTypeEnum.getValue());
        }
        if (contentPath != null) {
            this.Template.removeAllItems();
            this.Template.addItems(this.getTemplateList(contentPath).toArray());
        }
    }

    public List getTemplateList(String contentPath) {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("name", null);
        attrs.put("alias", null);
        attrs.put("category", null);
        attrs.put("eas_template_relation_orgs", null);
        attrs.put("FCOMPANYNUMBER", this.currentCompany.getNumber());
        HashMap vals = null;
        ArrayList<ErecTemplateInfo> items = new ArrayList<ErecTemplateInfo>();
        SubsidiaryBillTypeEnum billTypeEnum = (SubsidiaryBillTypeEnum)this.comboBillType.getSelectedItem();
        try {
            vals = KDNoteHelper.getBizContent().list(contentPath, attrs);
            if (vals != null) {
                int k = 0;
                this.templateMap.clear();
                String[] names = (String[])vals.get("name");
                String[] alias = (String[])vals.get("alias");
                String[] categories = (String[])vals.get("category");
                String[] orgss = (String[])vals.get("eas_template_relation_orgs");
                for (int i = 0; i < names.length; ++i) {
                    if (!"kdrs-form".equals(categories[i]) && !"r1-print".equals(categories[i])) continue;
                    ErecTemplateInfo tem = new ErecTemplateInfo();
                    if (!this.isCanPrint(KDNoteHelper.getBizContent(), contentPath + "/" + names[i])) continue;
                    Locale locale = this.getOriginLocale();
                    String prename = names[i].substring(0, names[i].length() - categories[i].length() - 1);
                    if (prename.endsWith("]") && !prename.endsWith("[" + locale + "]")) continue;
                    HashMap hs = new HashMap();
                    tem.setName(alias[i] == null ? names[i] : alias[i]);
                    tem.setNumber(names[i]);
                    items.add(tem);
                    this.templateMap.put(contentPathMap.get(billTypeEnum.getValue()) + "/" + tem.getNumber(), new Integer(k));
                    ++k;
                }
            }
        }
        catch (KDRSException e) {
            e.printStackTrace();
        }
        return items;
    }

    private boolean isCanPrint(IBizContent bizCtn, String absPathText) throws KDRSException {
        HashMap attrs = bizCtn.getAttributes(absPathText, new String[]{"user_enabled_users"});
        String currentUser = ContextHelperFactory.getRemoteInstance().getCurrentUser().getName();
        String users = (String)attrs.get("user_enabled_users");
        if (StringUtil.isEmptyString((String)users)) {
            return true;
        }
        Set usersSet = NoteDistributionUtil.usersStr2Set((String)users);
        return usersSet.contains(currentUser);
    }

    public Locale getOriginLocale() {
        Locale locale = SysContext.getSysContext().getOriginLocale();
        if (locale == null) {
            return null;
        }
        return BOSLocaleUtil.getOriginalLocale((Locale)locale);
    }

    @Override
    protected void Template_itemStateChanged(ItemEvent e) throws Exception {
        if (e != null) {
            super.Template_itemStateChanged(e);
            if (e.getStateChange() == 2) {
                return;
            }
        }
        SubsidiaryBillTypeEnum billTypeEnum = (SubsidiaryBillTypeEnum)this.comboBillType.getSelectedItem();
        this.txtTemplateName.setText(((ErecTemplateInfo)this.Template.getSelectedItem()).getName());
        this.txtTemplateID.setText(contentPathMap.get(billTypeEnum.getValue()) + "/" + ((ErecTemplateInfo)this.Template.getSelectedItem()).getNumber());
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.actionAddNew.setVisible(false);
        this.actionEdit.setVisible(false);
        this.actionSave.setVisible(false);
        this.actionCopy.setVisible(false);
        this.actionRemove.setVisible(false);
        this.actionPrint.setVisible(false);
        this.actionPrintPreview.setVisible(false);
        this.actionFirst.setVisible(false);
        this.actionPre.setVisible(false);
        this.actionNext.setVisible(false);
        this.actionLast.setVisible(false);
        this.actionCancelCancel.setVisible(false);
        this.actionCancel.setVisible(false);
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected IObjectValue createNewData() {
        InnerEReceiptTemplateInfo objectValue = new InnerEReceiptTemplateInfo();
        objectValue.setCompany(this.currentCompany);
        return objectValue;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return InnerEReceiptTemplateFactory.getRemoteInstance();
    }
}

