/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fd.client;

import com.kingdee.bos.ctrl.swing.KDMenuItem;
import com.kingdee.bos.ctrl.swing.KDPopupMenu;
import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.ctrl.swing.tree.KingdeeTreeModel;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgStructureInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fm.common.AccessHelper;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.fd.FdPlanOrgUnitFactory;
import com.kingdee.eas.fm.fd.FdPlanOrgUnitInfo;
import com.kingdee.eas.fm.fd.client.AbstractFdPlanOrgSetUI;
import com.kingdee.eas.fm.fs.FSHelper;
import com.kingdee.eas.fm.fs.InAcctFactory;
import com.kingdee.eas.fm.fs.client.FSClientHelper;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JMenuItem;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;

public class FdPlanOrgSetUI
extends AbstractFdPlanOrgSetUI {
    private static final Logger logger = CoreUIObject.getLogger(FdPlanOrgSetUI.class);
    private Map<String, FdPlanOrgUnitInfo> curOrgUnitMap = new LinkedHashMap<String, FdPlanOrgUnitInfo>();
    private Map<String, String> curOrgUnitNumberMap = new HashMap<String, String>();
    private Map<String, DefaultKingdeeTreeNode> nodeMap = new HashMap<String, DefaultKingdeeTreeNode>();
    private String viewId = null;

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.kDRemove.setText(null);
        this.kDRemove.setVisible(true);
        this.kDRemove.setIcon(EASResource.getIcon((String)"imgTree_delete"));
        this.kDTreeView2.getControlPane().add((Component)this.kDRemove);
        this.kDAddAll.setVisible(false);
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.init();
    }

    protected void initListener() {
        super.initListener();
        this.initPoppMenu();
    }

    public void initPoppMenu() {
        KDMenuItem menu = null;
        KDPopupMenu popMenu = new KDPopupMenu();
        this.kDTree1.addMouseListener((MouseListener)new TreePopupMenuListener(popMenu));
        menu = new KDMenuItem();
        menu.setText(EASResource.getString((String)"com.kingdee.eas.fm.fd.FDAutoGenerateResource", (String)"19_FdPlanOrgSetUI"));
        menu.addActionListener((ActionListener)new TreeMenuListener());
        popMenu.add((JMenuItem)menu);
        menu = new KDMenuItem();
        menu.setText(EASResource.getString((String)"com.kingdee.eas.fm.fd.FDAutoGenerateResource", (String)"20_FdPlanOrgSetUI"));
        menu.addActionListener((ActionListener)new AllOrgMenuListener());
        popMenu.add((JMenuItem)menu);
    }

    public void selectOrgUnit(DefaultKingdeeTreeNode root, boolean selected) {
        if (root == null) {
            return;
        }
        if (root.isCheckBoxVisible() && root.isCheckBoxEnabled()) {
            root.setChecked(selected);
        }
        DefaultKingdeeTreeNode node = null;
        int count = root.getChildCount();
        for (int index = 0; index < count; ++index) {
            node = (DefaultKingdeeTreeNode)root.getChildAt(index);
            if (node.isCheckBoxVisible() && node.isCheckBoxEnabled()) {
                node.setChecked(selected);
            }
            if (node == null || node.getChildCount() <= 0) continue;
            this.selectOrgUnit(node, selected);
        }
    }

    public void verifyBizUnit(DefaultKingdeeTreeNode root) {
        if (root == null) {
            return;
        }
        if (root.getChildCount() > 0) {
            int count = root.getChildCount();
            for (int index = 0; index < count; ++index) {
                DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)root.getChildAt(index);
                this.verifyBizUnit(node);
            }
        } else {
            FdPlanOrgUnitInfo fd = (FdPlanOrgUnitInfo)root.getUserObject();
            if (!fd.isIsBizUnit()) {
                MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.fm.fd.FDAutoGenerateResource", (String)"21_FdPlanOrgSetUI"));
                SysUtil.abort();
            }
        }
    }

    protected void init() throws Exception {
        this.viewId = SysContext.getSysContext().getCurrentOrgUnit().getId().toString();
        this.initLeftTree();
        this.initRightTree();
    }

    protected void initLeftTree() throws Exception {
        CompanyOrgUnitCollection companyCol;
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("name");
        sic.add("number");
        sic.add("longnumber");
        sic.add("isLeaf");
        sic.add("isUnion");
        sic.add("isCompanyOrgUnit");
        sic.add("accountTable.id");
        sic.add("accountTable.number");
        sic.add("parent");
        sic.add("isBizUnit");
        sic.add("code");
        sic.add("simpleName");
        sic.add("DESCRIPTION");
        CompanyOrgUnitCollection coll = InAcctFactory.getRemoteInstance().getInAcctApplyCompany();
        Set set = null;
        if (coll != null && coll.size() > 0 && (companyCol = FMClientHelper.getCompanyOrgUnitCollection((Set)FSHelper.getCompanySetByCompanyid(null, (Set)(set = AccessHelper.getIds((Object[])coll.toArray()))), (boolean)true, (SelectorItemCollection)sic)) != null && companyCol.size() != 0) {
            FSClientHelper.fillCompanyTreeByCompany((KDTree)this.kDTree1, (CompanyOrgUnitCollection)companyCol, (boolean)true);
        }
        this.kDTreeView1.setShowButton(true);
        this.kDTreeView1.updateUI();
        this.kDTree1.setShowCheckBox(true);
        this.kDTree1.setShowsRootHandles(true);
        this.kDTree1.expandOnLevel(5);
        this.kDTree1.repaint();
    }

    protected void initRightTree() throws Exception {
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("viewId", (Object)this.viewId, CompareType.EQUALS));
        ev.setFilter(filter);
        SorterItemCollection sorter = new SorterItemCollection();
        SorterItemInfo sortInfo = null;
        sortInfo = new SorterItemInfo("longNumber");
        sortInfo.setSortType(SortType.ASCEND);
        sorter.add(sortInfo);
        ev.setSorter(sorter);
        CoreBaseCollection col = FdPlanOrgUnitFactory.getRemoteInstance().getCollection(ev);
        DefaultKingdeeTreeNode node = null;
        DefaultKingdeeTreeNode parent = null;
        FdPlanOrgUnitInfo rootOrgUnit = new FdPlanOrgUnitInfo();
        rootOrgUnit.setId(BOSUuid.create((BOSObjectType)rootOrgUnit.getBOSType()));
        rootOrgUnit.setIsLeaf(true);
        DefaultKingdeeTreeNode root = new DefaultKingdeeTreeNode((Object)rootOrgUnit);
        for (int i = 0; i < col.size(); ++i) {
            FdPlanOrgUnitInfo info = (FdPlanOrgUnitInfo)col.get(i);
            node = new DefaultKingdeeTreeNode((Object)info);
            this.curOrgUnitMap.put(info.getLongNumber(), info);
            this.curOrgUnitNumberMap.put(info.getNumber(), info.getLongNumber());
            this.nodeMap.put(info.getLongNumber(), node);
            if (!info.getLongNumber().contains("!")) {
                root.add((MutableTreeNode)node);
                continue;
            }
            int last = info.getLongNumber().lastIndexOf("!");
            parent = this.nodeMap.get(info.getLongNumber().substring(0, last));
            if (parent != null) {
                parent.add((MutableTreeNode)node);
                continue;
            }
            root.add((MutableTreeNode)node);
        }
        KingdeeTreeModel n = root != null ? new KingdeeTreeModel((TreeNode)root) : null;
        this.kDTree2.setModel((TreeModel)n);
        this.kDTree2.setRootVisible(false);
        this.kDTree2.expandOnLevel(5);
        this.kDTree2.setShowsRootHandles(true);
        this.kDTree2.repaint();
    }

    @Override
    protected void kDComfirm_actionPerformed(ActionEvent e) throws Exception {
        super.kDComfirm_actionPerformed(e);
        this.verifyBizUnit((DefaultKingdeeTreeNode)this.kDTree2.getModel().getRoot());
        FdPlanOrgUnitFactory.getRemoteInstance().persistData(this.viewId, this.curOrgUnitMap);
        this.getUIWindow().close();
    }

    @Override
    protected void kDCancel_actionPerformed(ActionEvent e) throws Exception {
        super.kDCancel_actionPerformed(e);
        this.getUIWindow().close();
    }

    @Override
    protected void kDAddAll_actionPerformed(ActionEvent e) throws Exception {
        super.kDAddAll_actionPerformed(e);
    }

    @Override
    protected void kDAdd_actionPerformed(ActionEvent e) throws Exception {
        FdPlanOrgUnitInfo fd;
        int level;
        int last;
        super.kDAdd_actionPerformed(e);
        List<DefaultKingdeeTreeNode> csOrgNodeSet = this.getSelectedLeftTreeNodes((Component)((Object)this), this.kDTree1, this.viewId);
        DefaultKingdeeTreeNode bgOrgRootNode = (DefaultKingdeeTreeNode)this.kDTree2.getModel().getRoot();
        HashMap<String, String> changeNode = new HashMap<String, String>();
        if (this.kdDesignatedOrg.isSelected()) {
            for (DefaultKingdeeTreeNode node : csOrgNodeSet) {
                OrgStructureInfo orgStructureInfo = (OrgStructureInfo)node.getUserObject();
                if (this.curOrgUnitNumberMap.containsKey(orgStructureInfo.getUnit().getNumber())) continue;
                if (EmptyUtil.isEmpty((Object)this.kDTree2.getSelectionPath())) {
                    MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.fm.fd.FDAutoGenerateResource", (String)"22_FdPlanOrgSetUI"));
                    return;
                }
                DefaultKingdeeTreeNode rightSelectNode = (DefaultKingdeeTreeNode)this.kDTree2.getSelectionPath().getLastPathComponent();
                FdPlanOrgUnitInfo right = (FdPlanOrgUnitInfo)rightSelectNode.getUserObject();
                if (changeNode.containsKey(orgStructureInfo.getLongNumber())) continue;
                last = orgStructureInfo.getLongNumber().lastIndexOf("!");
                String oldNumber = orgStructureInfo.getLongNumber();
                String parentNumber = "";
                String number = orgStructureInfo.getUnit().getNumber();
                String newNumber = "";
                level = 1;
                parentNumber = last > 0 ? orgStructureInfo.getLongNumber().substring(0, last) : oldNumber;
                newNumber = changeNode.containsKey(parentNumber) ? changeNode.get(parentNumber).toString() + "!" + number : right.getLongNumber() + "!" + orgStructureInfo.getUnit().getNumber();
                level = newNumber.split("!").length;
                fd = new FdPlanOrgUnitInfo();
                fd.setLongNumber(newNumber);
                fd.setName(orgStructureInfo.getUnit().getName());
                fd.setLevel(level);
                fd.setViewId(this.viewId);
                fd.setOrgUnitId(orgStructureInfo.getId().toString());
                fd.setNumber(orgStructureInfo.getUnit().getNumber());
                fd.setCode(orgStructureInfo.getUnit().getCode());
                fd.setSimpleName(orgStructureInfo.getUnit().getSimpleName());
                fd.setIsBizUnit((Boolean)orgStructureInfo.getUnit().get("isbizunit"));
                fd.setDescription(orgStructureInfo.getUnit().getDescription());
                this.curOrgUnitMap.put(newNumber, fd);
                this.curOrgUnitNumberMap.put(number, newNumber);
                changeNode.put(oldNumber, newNumber);
            }
        } else {
            for (DefaultKingdeeTreeNode node : csOrgNodeSet) {
                OrgStructureInfo orgStructureInfo = (OrgStructureInfo)node.getUserObject();
                CompanyOrgUnitInfo company = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(orgStructureInfo.getId()));
                String key = "";
                if (this.curOrgUnitNumberMap.containsKey(company.getNumber())) {
                    key = this.curOrgUnitNumberMap.get(company.getNumber());
                }
                if (this.curOrgUnitMap.containsKey(key) || changeNode.containsKey(orgStructureInfo.getLongNumber())) continue;
                last = orgStructureInfo.getLongNumber().lastIndexOf("!");
                String number = orgStructureInfo.getUnit().getNumber();
                String fdName = orgStructureInfo.getUnit().getName();
                String newNumber = "";
                String oldNumber = orgStructureInfo.getLongNumber();
                level = 1;
                if (last > 0) {
                    String parentNumber = orgStructureInfo.getLongNumber().substring(0, last);
                    if (changeNode.containsKey(parentNumber)) {
                        newNumber = changeNode.get(parentNumber).toString() + "!" + number;
                        level = newNumber.split("!").length;
                    } else {
                        newNumber = number;
                    }
                } else {
                    newNumber = oldNumber;
                }
                fd = new FdPlanOrgUnitInfo();
                fd.setLongNumber(newNumber);
                fd.setName(fdName);
                fd.setLevel(level);
                fd.setViewId(this.viewId);
                fd.setNumber(number);
                fd.setOrgUnitId(orgStructureInfo.getId().toString());
                fd.setCode(orgStructureInfo.getUnit().getCode());
                fd.setSimpleName(orgStructureInfo.getUnit().getSimpleName());
                fd.setIsBizUnit((Boolean)orgStructureInfo.getUnit().get("isbizunit"));
                fd.setDescription(orgStructureInfo.getUnit().getDescription());
                this.curOrgUnitMap.put(newNumber, fd);
                this.curOrgUnitNumberMap.put(number, newNumber);
                changeNode.put(oldNumber, newNumber);
            }
        }
        ArrayList<Map.Entry<String, FdPlanOrgUnitInfo>> list = new ArrayList<Map.Entry<String, FdPlanOrgUnitInfo>>(this.curOrgUnitMap.entrySet());
        Collections.sort(list, new Comparator<Map.Entry<String, FdPlanOrgUnitInfo>>(){

            @Override
            public int compare(Map.Entry<String, FdPlanOrgUnitInfo> o1, Map.Entry<String, FdPlanOrgUnitInfo> o2) {
                int ret = 0;
                ret = o1.getKey().compareTo(o2.getKey());
                return ret;
            }
        });
        this.curOrgUnitMap.clear();
        for (Map.Entry entry : list) {
            this.curOrgUnitMap.put((String)entry.getKey(), (FdPlanOrgUnitInfo)entry.getValue());
        }
        this.buildRightTree();
    }

    public void buildRightTree() {
        DefaultKingdeeTreeNode node = null;
        DefaultKingdeeTreeNode parent = null;
        FdPlanOrgUnitInfo rootOrgUnit = new FdPlanOrgUnitInfo();
        rootOrgUnit.setId(BOSUuid.create((BOSObjectType)rootOrgUnit.getBOSType()));
        rootOrgUnit.setIsLeaf(true);
        DefaultKingdeeTreeNode root = new DefaultKingdeeTreeNode((Object)rootOrgUnit);
        HashMap<String, DefaultKingdeeTreeNode> newtree = new HashMap<String, DefaultKingdeeTreeNode>();
        HashMap<String, String> del = new HashMap<String, String>();
        for (String key : this.curOrgUnitMap.keySet()) {
            FdPlanOrgUnitInfo info = this.curOrgUnitMap.get(key);
            node = new DefaultKingdeeTreeNode((Object)info);
            newtree.put(info.getLongNumber(), node);
            if (!info.getLongNumber().contains("!")) {
                root.add((MutableTreeNode)node);
                continue;
            }
            int last = info.getLongNumber().lastIndexOf("!");
            parent = (DefaultKingdeeTreeNode)newtree.get(info.getLongNumber().substring(0, last));
            if (parent != null) {
                parent.add((MutableTreeNode)node);
                continue;
            }
            del.put(info.getNumber(), info.getLongNumber());
        }
        for (String key : del.keySet()) {
            this.curOrgUnitNumberMap.remove(key);
            this.curOrgUnitMap.remove(del.get(key));
        }
        KingdeeTreeModel n = root != null ? new KingdeeTreeModel((TreeNode)root) : null;
        this.kDTree2.setModel((TreeModel)n);
        this.kDTree2.setRootVisible(false);
        this.kDTree2.expandOnLevel(5);
        this.kDTree2.setShowsRootHandles(true);
        this.kDTree2.repaint();
    }

    public List<DefaultKingdeeTreeNode> getSelectedLeftTreeNodes(Component component, KDTree tree, String bgOrgViewId) throws Exception {
        boolean isNull;
        ArrayList<DefaultKingdeeTreeNode> setNode = new ArrayList<DefaultKingdeeTreeNode>();
        boolean bl = isNull = tree == null || tree.getModel() == null;
        if (isNull || tree.getModel().getRoot() == null) {
            return setNode;
        }
        DefaultKingdeeTreeNode node = null;
        Enumeration enumeration = ((DefaultKingdeeTreeNode)tree.getModel().getRoot()).breadthFirstEnumeration();
        while (enumeration.hasMoreElements()) {
            node = (DefaultKingdeeTreeNode)enumeration.nextElement();
            if (node == null || !node.isChecked() || node.getUserObject() == null) continue;
            setNode.add(node);
            node.setCheckBoxEnabled(false);
            node.setTextColor(Color.GRAY);
        }
        if (setNode.isEmpty()) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.fm.fd.FDAutoGenerateResource", (String)"23_FdPlanOrgSetUI"));
        }
        Collections.sort(setNode, new Comparator<DefaultKingdeeTreeNode>(){

            @Override
            public int compare(DefaultKingdeeTreeNode o1, DefaultKingdeeTreeNode o2) {
                int ret = 0;
                ret = ((OrgStructureInfo)o1.getUserObject()).getLongNumber().toString().compareTo(((OrgStructureInfo)o2.getUserObject()).getLongNumber().toString());
                return ret;
            }
        });
        return setNode;
    }

    @Override
    protected void kDRemove_actionPerformed(ActionEvent e) throws Exception {
        super.kDRemove_actionPerformed(e);
        if (EmptyUtil.isEmpty((Object)this.kDTree2.getSelectionPath())) {
            return;
        }
        TreePath[] paths = this.kDTree2.getSelectionPaths();
        for (int i = 0; i < paths.length; ++i) {
            DefaultKingdeeTreeNode rightSelectNode = (DefaultKingdeeTreeNode)paths[i].getLastPathComponent();
            FdPlanOrgUnitInfo info = (FdPlanOrgUnitInfo)rightSelectNode.getUserObject();
            this.curOrgUnitMap.remove(info.getLongNumber());
            this.curOrgUnitNumberMap.remove(info.getNumber());
        }
        this.buildRightTree();
    }

    @Override
    protected void kDSelectAll_actionPerformed(ActionEvent e) throws Exception {
        this.selectOrgUnit((DefaultKingdeeTreeNode)this.kDTree1.getModel().getRoot(), true);
        this.kDTree1.updateUI();
    }

    @Override
    protected void kDDeleteAll_actionPerformed(ActionEvent e) throws Exception {
        this.selectOrgUnit((DefaultKingdeeTreeNode)this.kDTree1.getModel().getRoot(), false);
        this.kDTree1.updateUI();
    }

    class AllOrgMenuListener
    implements ActionListener {
        AllOrgMenuListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DefaultKingdeeTreeNode selectNode = (DefaultKingdeeTreeNode)FdPlanOrgSetUI.this.kDTree1.getLastSelectedPathComponent();
            if (selectNode == null) {
                return;
            }
            FdPlanOrgSetUI.this.selectOrgUnit(selectNode, true);
            FdPlanOrgSetUI.this.kDTree1.updateUI();
        }
    }

    class TreeMenuListener
    implements ActionListener {
        TreeMenuListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DefaultKingdeeTreeNode selectNode = (DefaultKingdeeTreeNode)FdPlanOrgSetUI.this.kDTree1.getLastSelectedPathComponent();
            if (selectNode == null) {
                return;
            }
            if (selectNode.isCheckBoxVisible() && selectNode.isCheckBoxEnabled()) {
                selectNode.setChecked(true);
            }
            DefaultKingdeeTreeNode node = null;
            int count = selectNode.getChildCount();
            for (int index = 0; index < count; ++index) {
                node = (DefaultKingdeeTreeNode)selectNode.getChildAt(index);
                if (!node.isCheckBoxVisible() || !node.isCheckBoxEnabled()) continue;
                node.setChecked(true);
            }
            FdPlanOrgSetUI.this.kDTree1.updateUI();
        }
    }

    class TreePopupMenuListener
    extends MouseAdapter {
        KDPopupMenu popMenu = null;

        TreePopupMenuListener(KDPopupMenu popMenu) {
            this.popMenu = popMenu;
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (e.getButton() == 3) {
                this.popMenu.show((Component)FdPlanOrgSetUI.this.kDTree1, e.getX(), e.getY());
            }
        }
    }
}

