/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fd.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IBlock;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.KDTableHelper;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.cas.PaymentBillFactory;
import com.kingdee.eas.fm.common.client.FMFilterBaseUI;
import com.kingdee.eas.fm.fd.FundDispatchPlanBillFactory;
import com.kingdee.eas.fm.fd.FundDispatchPlanBillInfo;
import com.kingdee.eas.fm.fd.IFundDispatchPlanBill;
import com.kingdee.eas.fm.fd.client.AbstractFundDispatchPlanBillListUI;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.client.RealModeIDList;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import org.apache.log4j.Logger;

public class FundDispatchPlanBillListUI
extends AbstractFundDispatchPlanBillListUI {
    private static final Logger logger = CoreUIObject.getLogger(FundDispatchPlanBillListUI.class);
    private static String companyId;
    private static Set payIdSet;
    private static Set planIdSet;
    private static BigDecimal payAmount;

    public FundDispatchPlanBillListUI() throws Exception {
        this.btnConfirm.setVisible(true);
        this.btnExit.setVisible(true);
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public FMFilterBaseUI getFilterUI() throws Exception {
        return null;
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.tblMain.checkParsed();
        this.tblMain.getSelectManager().setSelectMode(10);
        this.txtPayAmt.setValue((Object)payAmount);
        this.txtPayAmt.setHorizontalAlignment(4);
        this.txtPayAmt.setPrecision(2);
    }

    public static Set showFundDispatchPlanBillListUI(CoreUIObject ui, String comId, Set paymentIdSet, Set currencyId, BigDecimal payAmt) throws ParseException, EASBizException {
        companyId = comId;
        payIdSet = paymentIdSet;
        planIdSet = new HashSet();
        payAmount = payAmt;
        try {
            UIContext uiContext = new UIContext((Object)ui);
            long current = System.currentTimeMillis();
            long zero = current / 86400000L * 86400000L - (long)TimeZone.getDefault().getRawOffset();
            Date today = new Date(zero);
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)comId));
            filter.getFilterItems().add(new FilterItemInfo("billStatus", (Object)8));
            filter.getFilterItems().add(new FilterItemInfo("payerAccountBank.bank.inGroup", (Object)1));
            filter.getFilterItems().add(new FilterItemInfo("reportType", (Object)2));
            filter.getFilterItems().add(new FilterItemInfo("expectPayStartDate", (Object)today, CompareType.LESS_EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("expectPayEndDate", (Object)today, CompareType.GREATER_EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("currency.id", (Object)currencyId, CompareType.INCLUDE));
            filter.getFilterItems().add(new FilterItemInfo("unusedAmt", (Object)0, CompareType.GREATER));
            EntityViewInfo ev = new EntityViewInfo();
            ev.setFilter(filter);
            SorterItemCollection sorter = new SorterItemCollection();
            SorterItemInfo sortInfo = new SorterItemInfo("number");
            sortInfo.setSortType(SortType.DESCEND);
            sorter.add(sortInfo);
            ev.setSorter(sorter);
            CoreBaseCollection colls = FundDispatchPlanBillFactory.getRemoteInstance().getCollection(ev);
            if (colls.size() == 1) {
                HashSet<String> planId = new HashSet<String>();
                planId.add(colls.get(0).getId().toString());
                planIdSet = planId;
                if (payIdSet.size() == 1) {
                    PaymentBillFactory.getRemoteInstance().beforeCommitSettle(payIdSet, planId, companyId);
                } else {
                    PaymentBillFactory.getRemoteInstance().updateTmpTable(planId);
                }
            } else if (colls.size() > 1) {
                RealModeIDList idList = new RealModeIDList();
                for (int i = 0; i < colls.size(); ++i) {
                    FundDispatchPlanBillInfo info = (FundDispatchPlanBillInfo)colls.get(i);
                    idList.add(info.getId().toString());
                }
                uiContext.put((Object)"IDList", (Object)idList);
                IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(FundDispatchPlanBillListUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
                uiWindow.show();
            } else {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.fd.FdResource", (String)"083_NO_CHOOSE_BILL"));
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
            SysUtil.abort();
        }
        return planIdSet;
    }

    public IFundDispatchPlanBill getBizInterface() throws BOSException {
        return FundDispatchPlanBillFactory.getRemoteInstance();
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
    }

    @Override
    public void actionConfirm_actionPerformed(ActionEvent e) throws Exception {
        if (this.tblMain.getRowCount() == 0 || this.tblMain.getSelectManager().getActiveRowIndex() == -1) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
            return;
        }
        List selectedIds = this.getSelectedRowIds();
        LinkedHashSet<String> idSet = new LinkedHashSet<String>();
        for (int i = 0; i < selectedIds.size(); ++i) {
            String id = (String)selectedIds.get(i);
            idSet.add(id);
        }
        PaymentBillFactory.getRemoteInstance().beforeCommitSettle(payIdSet, idSet, companyId);
        planIdSet = idSet;
        this.disposeUIWindow();
    }

    private List getSelectedRowIds() {
        ArrayList<String> ids = new ArrayList<String>();
        IBlock selectBlock = null;
        int size = this.tblMain.getSelectManager().size();
        for (int i = 0; i < size; ++i) {
            selectBlock = KDTSelectBlock.change((KDTable)this.tblMain, (IBlock)this.tblMain.getSelectManager().get(i));
            for (int j = selectBlock.getTop(); j <= selectBlock.getBottom(); ++j) {
                IRow row = this.tblMain.getRow(j);
                ids.add(row.getCell("id").getValue().toString());
            }
        }
        return ids;
    }

    @Override
    public void actionExit_actionPerformed(ActionEvent e) throws Exception {
        planIdSet = new HashSet();
        this.disposeUIWindow();
    }

    @Override
    public void actionSum_actionPerformed(ActionEvent e) throws Exception {
        super.actionSum_actionPerformed(e);
        String msg = this.sumList(this.tblMain);
        MsgBox.showInfo((Component)((Object)this), (String)msg.toString());
    }

    private String sumList(KDTable tblMain) {
        String colAmt = "unusedAmt";
        StringBuffer msg = new StringBuffer();
        int sumCount = KDTableHelper.getSelectedCountInColumn((KDTable)tblMain, (int)tblMain.getColumn("number").getColumnIndex());
        BigDecimal sumMoney = KDTableHelper.getSelectedSumInColumn((KDTable)tblMain, (int)tblMain.getColumn(colAmt).getColumnIndex());
        msg.append(EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"381_RecPayHandler")).append(sumMoney).append("        ").append(EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"382_RecPayHandler")).append(sumCount).append(EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"383_RecPayHandler"));
        return msg.toString();
    }
}

