/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fd.utils;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.core.util.StringUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.fd.FundDispatchPlatformWebFacadeFactory;
import com.kingdee.eas.util.EASCommonResource;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FDUtils {
    private static final String webResourcePath = "com.kingdee.eas.fm.fd.FdResource";

    public static String getResource(Context ctx, String resName, String[] args) {
        String str = EASCommonResource.getString((String)webResourcePath, (String)resName, (Locale)ctx.getLocale());
        if (args == null) {
            return str;
        }
        MessageFormat mf = new MessageFormat(str);
        return mf.format(args);
    }

    public static Set getMemberCom(Context ctx, String clearHouseCompanyId) throws BOSException, SQLException {
        String sql = "SELECT DISTINCT FAPPLYUNITID FROM T_FS_InnerAccount where FCOMPANYID ='" + clearHouseCompanyId + "'";
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
        HashSet<String> idSet = new HashSet<String>();
        while (rowSet.next()) {
            idSet.add(rowSet.getString("FAPPLYUNITID"));
        }
        return idSet;
    }

    public static Map<String, Map> getCompanyResult(Context ctx, String companyId, Map filterMap, List<Map> list) throws BOSException {
        String billStatus = "";
        StringBuffer sqlBuf = new StringBuffer("select sum(CASE  WHEN ( FBillStatus  ='8' or FBillStatus  ='3' or FBillStatus = '6' ) THEN 1 ELSE 0 END) as count , sum(CASE  WHEN (FBillStatus  ='3') THEN 1 ELSE 0 END) as reportCount,a.fcompanyid as companyId,b.FLONGNUMBER as longNumber,b.fname_l2 as companyName,  sum(CASE  WHEN ( FBillStatus  ='3' or FBillStatus = '6') THEN fapplyPayAmt ELSE 0 END) as unComfirmAmt,  sum(CASE  WHEN ( FBillStatus  ='8') THEN fapplyPayAmt ELSE 0 END) as comfirmAmt,  sum(CASE  WHEN ( FBillStatus  ='8' or  FBillStatus  ='3' or FBillStatus = '6') THEN fapplyPayAmt ELSE 0 END) as totalAmt, sum(CASE  WHEN ( FBillStatus  ='8') THEN FUsedAmt ELSE 0 END) as payAmt,  sum(CASE  WHEN ( FBillStatus  ='8' or  FBillStatus  ='3' or FBillStatus  ='6') THEN FUnusedAmt ELSE 0 END) as unPayAmt, ");
        if (!EmptyUtil.isEmpty(list)) {
            for (int i = 0; i < list.size(); ++i) {
                if (EmptyUtil.isEmpty(list.get(i).get("id"))) continue;
                sqlBuf.append(" sum(CASE  WHEN ( (FBillStatus  ='8' or  FBillStatus  ='3' or  FBillStatus  ='6') and FFeeType ='" + list.get(i).get("id") + "' ) THEN fapplyPayAmt ELSE 0 END) as " + list.get(i).get("name") + " ,");
            }
        }
        sqlBuf.append(" sum(CASE  WHEN ( (FBillStatus  ='8' or  FBillStatus  ='3' or  FBillStatus  ='6') and FFeeType is null ) THEN fapplyPayAmt ELSE 0 END) as Amtother ");
        sqlBuf.append(" from T_FD_FundDispatchPlanBill a LEFT OUTER join T_ORG_BaseUnit b on a.fcompanyid = b.fid LEFT OUTER join T_BD_AccountBanks c on a.FPayerAccountBankID = c.fid    left JOIN T_BD_Bank AS BANK ON c.FBank = BANK.FID where  a.fcompanyid = ? and FBillStatus in('3','6','8')");
        if (!EmptyUtil.isEmpty((Object)filterMap)) {
            if (filterMap.get("reportBeginDate") != null) {
                sqlBuf.append(" and freportDate >={TS " + filterMap.get("reportBeginDate") + "}");
            }
            if (filterMap.get("reportEndDate") != null) {
                sqlBuf.append(" and freportDate <{TS " + filterMap.get("reportEndDate") + "}");
            }
            if (filterMap.get("expectPayStartDate") != null) {
                sqlBuf.append(" and fexpectPayStartDate >={TS " + filterMap.get("expectPayStartDate") + "}");
            }
            if (filterMap.get("expectPayEndDate") != null) {
                sqlBuf.append(" and fexpectPayStartDate <{TS " + filterMap.get("expectPayEndDate") + "}");
            }
            if (filterMap.get("billStatus") != null) {
                billStatus = filterMap.get("billStatus").toString();
                if (!"5".equals(billStatus = billStatus.replaceAll("'", "").trim()) && !"7".equals(billStatus)) {
                    sqlBuf.append(" and FBillStatus =" + filterMap.get("billStatus"));
                }
            }
            if (filterMap.get("feeTypeId") != null) {
                sqlBuf.append(" and FFeeType in(" + filterMap.get("feeTypeId") + ")");
            }
            if (filterMap.get("feeTypeIdsNotIn") != null) {
                sqlBuf.append(" and FFeeType not in(" + filterMap.get("feeTypeIdsNotIn") + ")");
            }
            if (filterMap.get("applyPayAmt") != null) {
                sqlBuf.append(" and fapplyPayAmt " + filterMap.get("applyPayAmt"));
            }
        }
        if (!EmptyUtil.isEmpty(filterMap.get("currentCompany"))) {
            // empty if block
        }
        sqlBuf.append(" group by a.fcompanyid ,b.FLONGNUMBER,b.fname_l2");
        Object[] obj = new Object[]{companyId};
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sqlBuf.toString(), (Object[])obj);
        HashMap<String, Map> result = new HashMap<String, Map>();
        String longNumber = "";
        HashMap<String, Object> info = new HashMap<String, Object>();
        try {
            if (rowSet.next()) {
                info.put("count", rowSet.getInt("count"));
                info.put("longNumber", rowSet.getString("longNumber"));
                longNumber = rowSet.getString("longNumber");
                info.put("companyId", rowSet.getString("companyId"));
                info.put("companyName", rowSet.getString("companyName"));
                info.put("unComfirmAmt", rowSet.getBigDecimal("unComfirmAmt"));
                info.put("comfirmAmt", rowSet.getBigDecimal("comfirmAmt"));
                info.put("totalAmt", rowSet.getBigDecimal("totalAmt"));
                info.put("payAmt", rowSet.getBigDecimal("payAmt"));
                info.put("unPayAmt", rowSet.getBigDecimal("unPayAmt"));
                info.put("isLeaf", "1");
                info.put("id", UUID.randomUUID().toString().trim().replaceAll("-", ""));
                if (!EmptyUtil.isEmpty(list)) {
                    for (int i = 0; i < list.size(); ++i) {
                        info.put((String)list.get(i).get("name"), rowSet.getBigDecimal(list.get(i).get("name").toString()));
                    }
                }
                info.put("other", rowSet.getBigDecimal("amtother"));
                if (rowSet.getBigDecimal("unComfirmAmt").compareTo(BigDecimal.ZERO) == 0) {
                    info.put("status", ResourceBase.getString((String)"com.kingdee.eas.fm.fd.FDAutoGenerateResource", (String)"26_FDUtils", (Locale)ctx.getLocale()));
                } else if (rowSet.getInt("count") == rowSet.getInt("reportCount")) {
                    info.put("status", ResourceBase.getString((String)"com.kingdee.eas.fm.fd.FDAutoGenerateResource", (String)"27_FDUtils", (Locale)ctx.getLocale()));
                } else {
                    info.put("status", ResourceBase.getString((String)"com.kingdee.eas.fm.fd.FDAutoGenerateResource", (String)"28_FDUtils", (Locale)ctx.getLocale()));
                }
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        if (!EmptyUtil.isEmpty((String)longNumber)) {
            if ("5".equals(billStatus) && ResourceBase.getString((String)"com.kingdee.eas.fm.fd.FDAutoGenerateResource", (String)"28_FDUtils", (Locale)ctx.getLocale()).equals(info.get("status"))) {
                result.put(longNumber, info);
            } else if (!"5".equals(billStatus)) {
                result.put(longNumber, info);
            }
        }
        return result;
    }

    public static Map<String, Map> getFdCompanyResult(Context ctx, String companyId, Map filterMap, List<Map> list) throws BOSException {
        String billStatus = "";
        StringBuffer sqlBuf = new StringBuffer("select sum(CASE  WHEN ( FBillStatus  ='8' or FBillStatus  ='3' or FBillStatus  ='6') THEN 1 ELSE 0 END) as count , sum(CASE  WHEN (FBillStatus  ='3') THEN 1 ELSE 0 END) as reportCount,FUNDDISPATCHPLANBILL.fcompanyid as companyId,b.FLONGNUMBER as longNumber,b.fname_l2 as companyName,  sum(CASE  WHEN (FBillStatus  ='6') THEN 1 ELSE 0 END) as validateCount,  sum(CASE  WHEN ( FBillStatus  ='3' or FBillStatus = '6') THEN fapplyPayAmt ELSE 0 END) as unComfirmAmt,  sum(CASE  WHEN ( FBillStatus  ='3') THEN fapplyPayAmt ELSE 0 END) as reportAmt,  sum(CASE  WHEN ( FBillStatus  ='6') THEN fapplyPayAmt ELSE 0 END) as validateAmt,  sum(CASE  WHEN ( FBillStatus  ='8') THEN fapplyPayAmt ELSE 0 END) as comfirmAmt,  sum(CASE  WHEN ( FBillStatus  ='8' or  FBillStatus  ='3' or  FBillStatus  ='6') THEN fapplyPayAmt ELSE 0 END) as totalAmt, sum(CASE  WHEN ( FBillStatus  ='8') THEN FUsedAmt ELSE 0 END) as payAmt,  sum(CASE  WHEN ( FBillStatus  ='8' or  FBillStatus  ='3' or  FBillStatus  ='6') THEN FUnusedAmt ELSE 0 END) as unPayAmt, ");
        if (!EmptyUtil.isEmpty(list)) {
            for (int i = 0; i < list.size(); ++i) {
                if (EmptyUtil.isEmpty(list.get(i).get("id"))) continue;
                sqlBuf.append(" sum(CASE  WHEN ( (FBillStatus  ='8' or  FBillStatus  ='3' or  FBillStatus  ='6') and FFeeType ='" + list.get(i).get("id") + "' ) THEN fapplyPayAmt ELSE 0 END) as " + list.get(i).get("name") + " ,");
            }
        }
        sqlBuf.append(" sum(CASE  WHEN ( (FBillStatus  ='8' or  FBillStatus  ='3' or  FBillStatus  ='6') and FFeeType is null ) THEN fapplyPayAmt ELSE 0 END) as Amtother ");
        sqlBuf.append(" from T_FD_FundDispatchPlanBill FUNDDISPATCHPLANBILL LEFT OUTER JOIN T_BD_Currency AS CURRENCY ON FUNDDISPATCHPLANBILL.FCurrencyID = CURRENCY.FID  LEFT OUTER JOIN T_PM_User AS CREATOR ON FUNDDISPATCHPLANBILL.FCreatorID = CREATOR.FID  LEFT OUTER JOIN T_ORG_Company AS COMPANY ON FUNDDISPATCHPLANBILL.FCompanyID = COMPANY.FID  LEFT OUTER JOIN T_PM_User AS CHECKUSER ON FUNDDISPATCHPLANBILL.FCheckUserID = CHECKUSER.FID  LEFT OUTER JOIN T_PM_User AS CONFIRMUSER ON FUNDDISPATCHPLANBILL.FConfirmUserID = CONFIRMUSER.FID  LEFT OUTER JOIN T_PM_User AS REPORTUSER ON FUNDDISPATCHPLANBILL.FReportUserID = REPORTUSER.FID  LEFT OUTER JOIN T_BD_SettlementType AS SETTLEMENTTYPE ON FUNDDISPATCHPLANBILL.FSettlementTypeID = SETTLEMENTTYPE.FID  LEFT OUTER JOIN T_BD_AsstActType AS ASSTACTTYPE ON FUNDDISPATCHPLANBILL.FAsstActTypeID = ASSTACTTYPE.FID  LEFT OUTER JOIN T_PM_User AS AUDITOR ON FUNDDISPATCHPLANBILL.FAuditorID = AUDITOR.FID  inner join T_FD_FdPlanOrgUnit b on FUNDDISPATCHPLANBILL.fcompanyid = b.FOrgUnitId  inner join T_BD_AccountBanks c on FUNDDISPATCHPLANBILL.FPayerAccountBankID = c.fid   inner JOIN T_BD_Bank AS BANK ON c.FBank = BANK.FID where  FUNDDISPATCHPLANBILL.fcompanyid = ? and FBillStatus in('3','6','8')");
        if (!EmptyUtil.isEmpty((Object)filterMap)) {
            if (!EmptyUtil.isEmpty(filterMap.get("querySql"))) {
                sqlBuf.append(" and " + filterMap.get("querySql"));
            } else if (!EmptyUtil.isEmpty((Object)filterMap)) {
                if (!EmptyUtil.isEmpty(filterMap.get("reportBeginDate"))) {
                    sqlBuf.append(" and freportDate >={TS " + filterMap.get("reportBeginDate") + "}");
                }
                if (!EmptyUtil.isEmpty(filterMap.get("reportEndDate"))) {
                    sqlBuf.append(" and freportDate <{TS " + filterMap.get("reportEndDate") + "}");
                }
                if (!EmptyUtil.isEmpty(filterMap.get("expectPayStartDate"))) {
                    sqlBuf.append(" and fexpectPayStartDate >={TS " + filterMap.get("expectPayStartDate") + "}");
                }
                if (!EmptyUtil.isEmpty(filterMap.get("expectPayEndDate"))) {
                    sqlBuf.append(" and fexpectPayStartDate <{TS " + filterMap.get("expectPayEndDate") + "}");
                }
                if (!EmptyUtil.isEmpty(filterMap.get("billStatus"))) {
                    billStatus = filterMap.get("billStatus").toString();
                    if (!"5".equals(billStatus = billStatus.replaceAll("'", "").trim()) && !"7".equals(billStatus)) {
                        sqlBuf.append(" and FBillStatus =" + filterMap.get("billStatus"));
                    }
                }
                if (!EmptyUtil.isEmpty(filterMap.get("feeTypeId"))) {
                    sqlBuf.append(" and FFeeType in(" + filterMap.get("feeTypeId") + ")");
                }
                if (!EmptyUtil.isEmpty(filterMap.get("feeTypeIdsNotIn"))) {
                    sqlBuf.append(" and FFeeType not in(" + filterMap.get("feeTypeIdsNotIn") + ")");
                }
                if (!EmptyUtil.isEmpty(filterMap.get("applyPayAmt"))) {
                    sqlBuf.append(" and fapplyPayAmt " + filterMap.get("applyPayAmt"));
                }
            }
        }
        if (!EmptyUtil.isEmpty(filterMap.get("billStatus"))) {
            billStatus = filterMap.get("billStatus").toString();
            billStatus = billStatus.replaceAll("'", "").trim();
        }
        if (!EmptyUtil.isEmpty(filterMap.get("currentCompany"))) {
            sqlBuf.append(" and b.fviewid = '" + filterMap.get("currentCompany") + "'");
        }
        sqlBuf.append(" group by FUNDDISPATCHPLANBILL.fcompanyid ,b.FLONGNUMBER,b.fname_l2");
        Object[] obj = new Object[]{companyId};
        String querySql = sqlBuf.toString();
        querySql = querySql.replaceAll("AND  \"FUNDDISPATCHPLANBILL\".FBillStatus = 5", "");
        querySql = querySql.replaceAll("and  \"FUNDDISPATCHPLANBILL\".FBillStatus = 5", "");
        querySql = querySql.replaceAll("AND  \"FUNDDISPATCHPLANBILL\".FBillStatus = 7", "AND  \"FUNDDISPATCHPLANBILL\".FBillStatus in (3,6) ");
        querySql = querySql.replaceAll("and  \"FUNDDISPATCHPLANBILL\".FBillStatus = 7", "and  \"FUNDDISPATCHPLANBILL\".FBillStatus in (3,6) ");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)querySql, (Object[])obj);
        System.out.println("sqlBuf=====" + sqlBuf);
        HashMap<String, Map> result = new HashMap<String, Map>();
        String longNumber = "";
        HashMap<String, Object> info = new HashMap<String, Object>();
        try {
            if (rowSet.next()) {
                info.put("count", rowSet.getInt("count"));
                info.put("longNumber", rowSet.getString("longNumber"));
                longNumber = rowSet.getString("longNumber");
                info.put("companyId", rowSet.getString("companyId"));
                info.put("companyName", rowSet.getString("companyName"));
                info.put("unComfirmAmt", rowSet.getBigDecimal("unComfirmAmt"));
                info.put("comfirmAmt", rowSet.getBigDecimal("comfirmAmt"));
                info.put("totalAmt", rowSet.getBigDecimal("totalAmt"));
                info.put("payAmt", rowSet.getBigDecimal("payAmt"));
                info.put("unPayAmt", rowSet.getBigDecimal("unPayAmt"));
                info.put("reportAmt", rowSet.getBigDecimal("reportAmt"));
                info.put("validateAmt", rowSet.getBigDecimal("validateAmt"));
                info.put("reportCount", rowSet.getInt("reportCount"));
                info.put("validateCount", rowSet.getInt("validateCount"));
                info.put("isLeaf", "1");
                info.put("id", UUID.randomUUID().toString().trim().replaceAll("-", ""));
                if (!EmptyUtil.isEmpty(list)) {
                    for (int i = 0; i < list.size(); ++i) {
                        info.put((String)list.get(i).get("name"), rowSet.getBigDecimal(list.get(i).get("name").toString()));
                    }
                }
                info.put("other", rowSet.getBigDecimal("amtother"));
                if (rowSet.getBigDecimal("unComfirmAmt").compareTo(BigDecimal.ZERO) == 0) {
                    info.put("status", ResourceBase.getString((String)"com.kingdee.eas.fm.fd.FDAutoGenerateResource", (String)"26_FDUtils", (Locale)ctx.getLocale()));
                } else if (rowSet.getInt("count") == rowSet.getInt("reportCount")) {
                    info.put("status", ResourceBase.getString((String)"com.kingdee.eas.fm.fd.FDAutoGenerateResource", (String)"27_FDUtils", (Locale)ctx.getLocale()));
                } else if (rowSet.getInt("count") == rowSet.getInt("validateCount")) {
                    info.put("status", ResourceBase.getString((String)"com.kingdee.eas.fm.fd.FDAutoGenerateResource", (String)"29_FDUtils", (Locale)ctx.getLocale()));
                } else if (rowSet.getBigDecimal("comfirmAmt").compareTo(BigDecimal.ZERO) > 0) {
                    info.put("status", ResourceBase.getString((String)"com.kingdee.eas.fm.fd.FDAutoGenerateResource", (String)"28_FDUtils", (Locale)ctx.getLocale()));
                } else {
                    info.put("status", ResourceBase.getString((String)"com.kingdee.eas.fm.fd.FDAutoGenerateResource", (String)"30_FDUtils", (Locale)ctx.getLocale()));
                }
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        if (!EmptyUtil.isEmpty((String)longNumber)) {
            if ("5".equals(billStatus) && ResourceBase.getString((String)"com.kingdee.eas.fm.fd.FDAutoGenerateResource", (String)"28_FDUtils", (Locale)ctx.getLocale()).equals(info.get("status"))) {
                result.put(longNumber, info);
            } else if ("7".equals(billStatus) && ResourceBase.getString((String)"com.kingdee.eas.fm.fd.FDAutoGenerateResource", (String)"30_FDUtils", (Locale)ctx.getLocale()).equals(info.get("status"))) {
                result.put(longNumber, info);
            } else if (!"5".equals(billStatus) && !"7".equals(billStatus)) {
                result.put(longNumber, info);
            }
        }
        return result;
    }

    public static Map getCompany(Context ctx, String longNumber) throws BOSException {
        String sql = "select fid as companyId ,fname_l2 as companyName , FLONGNUMBER as longNumber from T_ORG_BaseUnit where FLONGNUMBER ='" + longNumber + "'";
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
        HashMap<String, String> result = new HashMap<String, String>();
        try {
            if (rowSet.next()) {
                result.put("companyId", rowSet.getString("companyId"));
                result.put("companyName", rowSet.getString("companyName"));
                result.put("longNumber", rowSet.getString("longNumber"));
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return result;
    }

    public static Map getFdCompany(Context ctx, String longNumber, String currentCompanyId) throws BOSException {
        String sql = "select FOrgUnitId as companyId ,fname_l2 as companyName , FLONGNUMBER as longNumber from T_FD_FdPlanOrgUnit where FLONGNUMBER ='" + longNumber + "' and fviewid ='" + currentCompanyId + "'";
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
        HashMap<String, String> result = new HashMap<String, String>();
        try {
            if (rowSet.next()) {
                result.put("companyId", rowSet.getString("companyId"));
                result.put("companyName", rowSet.getString("companyName"));
                result.put("longNumber", rowSet.getString("longNumber"));
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return result;
    }

    public static List<Map> getFeeType(Context ctx) throws BOSException {
        HashMap<String, String> result;
        String sql = "select fid,fname_l2,fnumber from T_CAS_FeeType where fisLeaf = 1 ";
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
        ArrayList<Map> list = new ArrayList<Map>();
        try {
            while (rowSet.next()) {
                result = new HashMap<String, String>();
                result.put("id", rowSet.getString("fid"));
                result.put("desc", rowSet.getString("fname_l2"));
                String flag = "Amt" + rowSet.getString("fid");
                flag = flag.replaceAll("[^0-9a-zA-Z]", "");
                result.put("name", flag);
                list.add(result);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        result = new HashMap();
        result.put("id", "");
        result.put("desc", ResourceBase.getString((String)"com.kingdee.eas.fm.fd.FDAutoGenerateResource", (String)"31_FDUtils", (Locale)ctx.getLocale()));
        result.put("name", "Amtother");
        list.add(result);
        return list;
    }

    public static Set getPlans(Context ctx, Set companyIds, Map map) throws BOSException {
        ArrayList idList = new ArrayList(companyIds);
        String sql = "SELECT FUNDDISPATCHPLANBILL.fid as fid from T_FD_FundDispatchPlanBill FUNDDISPATCHPLANBILL  LEFT OUTER JOIN T_BD_Currency AS CURRENCY ON FUNDDISPATCHPLANBILL.FCurrencyID = CURRENCY.FID  LEFT OUTER JOIN T_PM_User AS CREATOR ON FUNDDISPATCHPLANBILL.FCreatorID = CREATOR.FID  LEFT OUTER JOIN T_ORG_Company AS COMPANY ON FUNDDISPATCHPLANBILL.FCompanyID = COMPANY.FID  LEFT OUTER JOIN T_PM_User AS CHECKUSER ON FUNDDISPATCHPLANBILL.FCheckUserID = CHECKUSER.FID  LEFT OUTER JOIN T_PM_User AS CONFIRMUSER ON FUNDDISPATCHPLANBILL.FConfirmUserID = CONFIRMUSER.FID  LEFT OUTER JOIN T_PM_User AS REPORTUSER ON FUNDDISPATCHPLANBILL.FReportUserID = REPORTUSER.FID  LEFT OUTER JOIN T_BD_SettlementType AS SETTLEMENTTYPE ON FUNDDISPATCHPLANBILL.FSettlementTypeID = SETTLEMENTTYPE.FID  LEFT OUTER JOIN T_BD_AsstActType AS ASSTACTTYPE ON FUNDDISPATCHPLANBILL.FAsstActTypeID = ASSTACTTYPE.FID  LEFT OUTER JOIN T_PM_User AS AUDITOR ON FUNDDISPATCHPLANBILL.FAuditorID = AUDITOR.FID  LEFT OUTER join T_ORG_BaseUnit b on FUNDDISPATCHPLANBILL.fcompanyid = b.fid inner join T_BD_AccountBanks c on FUNDDISPATCHPLANBILL.FPayerAccountBankID = c.fid   inner JOIN T_BD_Bank AS BANK ON c.FBank = BANK.FID where   FBillStatus in('3','6','8') and FUNDDISPATCHPLANBILL.FCOMPANYID in (";
        for (int i = 0; i < idList.size(); ++i) {
            sql = i == idList.size() - 1 ? sql + "'" + idList.get(i) + "'" : sql + "'" + idList.get(i) + "',";
        }
        sql = sql + ")";
        if (!EmptyUtil.isEmpty(map.get("filter"))) {
            sql = sql + " and " + map.get("filter");
        }
        if (!EmptyUtil.isEmpty(map.get("querySql"))) {
            sql = sql + " and " + map.get("querySql");
        }
        if (!EmptyUtil.isEmpty((Object)map)) {
            if (!EmptyUtil.isEmpty(map.get("reportStartDate"))) {
                sql = sql + " and freportDate >={TS " + map.get("reportStartDate") + "}";
            }
            if (!EmptyUtil.isEmpty(map.get("reportEndDate"))) {
                sql = sql + " and freportDate <{TS " + map.get("reportEndDate") + "}";
            }
            if (!EmptyUtil.isEmpty(map.get("expectPayStartDate"))) {
                sql = sql + " and fexpectPayStartDate >={TS " + map.get("expectPayStartDate") + "}";
            }
            if (!EmptyUtil.isEmpty(map.get("expectPayEndDate"))) {
                sql = sql + " and fexpectPayStartDate <{TS " + map.get("expectPayEndDate") + "}";
            }
            if (!EmptyUtil.isEmpty(map.get("billStatus")) && !map.get("billStatus").toString().trim().equals("'5'")) {
                sql = map.get("billStatus").toString().trim().equals("'7'") ? sql + " and FBillStatus in (3,6)" : sql + " and FBillStatus =" + map.get("billStatus");
            }
            if (!EmptyUtil.isEmpty(map.get("feeTypeId"))) {
                sql = sql + " and FFeeType in (" + map.get("feeTypeId") + ")";
            }
            if (!EmptyUtil.isEmpty(map.get("feeTypeIdsNotIn"))) {
                sql = sql + " and FFeeType not in (" + map.get("feeTypeIdsNotIn") + ")";
            }
            if (!EmptyUtil.isEmpty(map.get("applyPayAmt"))) {
                sql = sql + " and fapplyPayAmt " + map.get("applyPayAmt");
            }
        }
        if (!EmptyUtil.isEmpty(map.get("currentCompany"))) {
            // empty if block
        }
        HashSet<String> idSet = new HashSet<String>();
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
        try {
            while (rowSet.next()) {
                idSet.add(rowSet.getString("fid"));
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return idSet;
    }

    public static Set<String> getSelectCom(Context ctx, String clearHouseCompanyId, String longNunber) throws BOSException, SQLException {
        String sql = "SELECT fid  FROM T_ORG_BaseUnit where fid in (select DISTINCT FAPPLYUNITID FROM T_FS_InnerAccount where FCOMPANYID ='" + clearHouseCompanyId + "')  and flongnumber like '" + longNunber + "%'";
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
        HashSet<String> idSet = new HashSet<String>();
        while (rowSet.next()) {
            idSet.add(rowSet.getString("fid"));
        }
        return idSet;
    }

    public static Set<String> getSelectTableCom(Context ctx, String clearHouseCompanyId, String longNunber) throws BOSException, SQLException {
        String sql = "SELECT FOrgUnitId  FROM T_FD_FdPlanOrgUnit where FOrgUnitId in (select DISTINCT FAPPLYUNITID FROM T_FS_InnerAccount where FCOMPANYID ='" + clearHouseCompanyId + "')  and fviewid ='" + clearHouseCompanyId + "' and flongnumber like '" + longNunber + "%'";
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
        HashSet<String> idSet = new HashSet<String>();
        while (rowSet.next()) {
            idSet.add(rowSet.getString("FOrgUnitId"));
        }
        return idSet;
    }

    public static List<Map<String, Object>> getCridDataEntiy(Context ctx, String currentCompanyId, String strLevel) throws BOSException, SQLException, EASBizException {
        Map format_map;
        Set idSet = new HashSet();
        idSet = FDUtils.getMemberCom(ctx, currentCompanyId);
        ArrayList<Map<String, Object>> alllist = new ArrayList<Map<String, Object>>();
        HashMap<String, Map> parentList = new HashMap<String, Map>();
        if (!EmptyUtil.isEmpty(idSet)) {
            String sql = "SELECT DISTINCT fcompanyid FROM T_FD_FundDispatchPlanBill where " + StringUtil.buildIn((String)"fcompanyid", (Object[])idSet.toArray());
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
            try {
                String filter = FDUtils.getPlatformEntry1Filter(ctx, currentCompanyId);
                while (rowSet.next()) {
                    String companyId = rowSet.getString("fcompanyid");
                    Map<String, Map> childMap = FDUtils.getFdCompanyResult(ctx, companyId, filter, currentCompanyId);
                    if (EmptyUtil.isEmpty(childMap) || childMap.size() <= 0) continue;
                    Iterator<String> iterator = childMap.keySet().iterator();
                    while (iterator.hasNext()) {
                        String s;
                        String key = s = iterator.next();
                        Map info = childMap.get(key);
                        FDUtils.initParentData(ctx, childMap, info, currentCompanyId, parentList);
                        alllist.add(childMap.get(key));
                    }
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        ArrayList<Map<String, Object>> tempList = new ArrayList<Map<String, Object>>();
        tempList.addAll(alllist);
        for (String s : parentList.keySet()) {
            Map parentMap = (Map)parentList.get(s);
            for (int i = 0; i < tempList.size(); ++i) {
                Map map = (Map)tempList.get(i);
                if (!parentMap.get("longNumber").equals(map.get("longNumber"))) continue;
                parentMap.put("count", Integer.parseInt(parentMap.get("count") + "") + Integer.parseInt(map.get("count") + ""));
                parentMap.put("unComfirmAmt", FDUtils.add(parentMap.get("unComfirmAmt") + "", map.get("unComfirmAmt") + ""));
                parentMap.put("comfirmAmt", FDUtils.add(parentMap.get("comfirmAmt") + "", map.get("comfirmAmt") + ""));
                parentMap.put("totalAmt", FDUtils.add(parentMap.get("totalAmt") + "", map.get("totalAmt") + ""));
                parentMap.put("payAmt", FDUtils.add(parentMap.get("payAmt") + "", map.get("payAmt") + ""));
                parentMap.put("unPayAmt", FDUtils.add(parentMap.get("unPayAmt") + "", map.get("unPayAmt") + ""));
                alllist.remove(map);
            }
            alllist.add(parentMap);
        }
        Collections.sort(alllist, new Comparator<Map>(){

            @Override
            public int compare(Map o1, Map o2) {
                int ret = 0;
                ret = o1.get("longNumber").toString().compareTo(o2.get("longNumber").toString());
                return ret;
            }
        });
        if (!EmptyUtil.isEmpty(alllist)) {
            NumberFormat nf = NumberFormat.getCurrencyInstance();
            for (int i = 0; i < alllist.size(); ++i) {
                format_map = (Map)alllist.get(i);
                for (Map.Entry entry : format_map.entrySet()) {
                    if (((String)entry.getKey()).indexOf("Amt") <= -1) continue;
                    entry.setValue(nf.format(entry.getValue()).replace("\uffe5", ""));
                }
            }
        }
        ArrayList<Map> tableList = new ArrayList<Map>();
        for (int i = 0; i < alllist.size(); ++i) {
            format_map = (Map)alllist.get(i);
            String longNumber = format_map.get("longNumber") + "";
            int n = 1;
            if (!EmptyUtil.isEmpty((String)strLevel)) {
                n = Integer.parseInt(strLevel);
            }
            format_map.put("number", n);
            if (n == 0 || longNumber.split("!").length != n) continue;
            tableList.add(format_map);
        }
        if (tableList != null) {
            alllist = tableList;
        }
        return alllist;
    }

    public static Map<String, Map> getFdCompanyResult(Context ctx, String companyId, String filter, String currentCompanyId) throws BOSException {
        String billStatus = "";
        StringBuffer sqlBuf = new StringBuffer("select sum(CASE  WHEN ( FBillStatus  ='8' or FBillStatus  ='3' or FBillStatus  ='6') THEN 1 ELSE 0 END) as count , sum(CASE  WHEN (FBillStatus  ='3') THEN 1 ELSE 0 END) as reportCount,FUNDDISPATCHPLANBILL.fcompanyid as companyId,b.FLONGNUMBER as longNumber,b.fname_l2 as companyName,  sum(CASE  WHEN ( FBillStatus  ='3' or FBillStatus = '6') THEN fapplyPayAmt ELSE 0 END) as unComfirmAmt,  sum(CASE  WHEN ( FBillStatus  ='8') THEN fapplyPayAmt ELSE 0 END) as comfirmAmt,  sum(CASE  WHEN ( FBillStatus  ='8' or  FBillStatus  ='3' or  FBillStatus  ='6') THEN fapplyPayAmt ELSE 0 END) as totalAmt, sum(CASE  WHEN ( FBillStatus  ='8') THEN FUsedAmt ELSE 0 END) as payAmt,  sum(CASE  WHEN ( FBillStatus  ='8' or  FBillStatus  ='3' or  FBillStatus  ='6') THEN FUnusedAmt ELSE 0 END) as unPayAmt, ");
        sqlBuf.append(" sum(CASE  WHEN ( (FBillStatus  ='8' or  FBillStatus  ='3' or  FBillStatus  ='6') and FFeeType is null ) THEN fapplyPayAmt ELSE 0 END) as Amtother ");
        sqlBuf.append(" from T_FD_FundDispatchPlanBill FUNDDISPATCHPLANBILL LEFT OUTER JOIN T_BD_Currency AS CURRENCY ON FUNDDISPATCHPLANBILL.FCurrencyID = CURRENCY.FID  LEFT OUTER JOIN T_PM_User AS CREATOR ON FUNDDISPATCHPLANBILL.FCreatorID = CREATOR.FID  LEFT OUTER JOIN T_ORG_Company AS COMPANY ON FUNDDISPATCHPLANBILL.FCompanyID = COMPANY.FID  LEFT OUTER JOIN T_PM_User AS CHECKUSER ON FUNDDISPATCHPLANBILL.FCheckUserID = CHECKUSER.FID  LEFT OUTER JOIN T_PM_User AS CONFIRMUSER ON FUNDDISPATCHPLANBILL.FConfirmUserID = CONFIRMUSER.FID  LEFT OUTER JOIN T_PM_User AS REPORTUSER ON FUNDDISPATCHPLANBILL.FReportUserID = REPORTUSER.FID  LEFT OUTER JOIN T_BD_SettlementType AS SETTLEMENTTYPE ON FUNDDISPATCHPLANBILL.FSettlementTypeID = SETTLEMENTTYPE.FID  LEFT OUTER JOIN T_BD_AsstActType AS ASSTACTTYPE ON FUNDDISPATCHPLANBILL.FAsstActTypeID = ASSTACTTYPE.FID  LEFT OUTER JOIN T_PM_User AS AUDITOR ON FUNDDISPATCHPLANBILL.FAuditorID = AUDITOR.FID  inner join T_FD_FdPlanOrgUnit b on FUNDDISPATCHPLANBILL.fcompanyid = b.FOrgUnitId  inner join T_BD_AccountBanks c on FUNDDISPATCHPLANBILL.FPayerAccountBankID = c.fid   inner JOIN T_BD_Bank AS BANK ON c.FBank = BANK.FID where  FUNDDISPATCHPLANBILL.fcompanyid = ? and FBillStatus in('3','6','8') ");
        if (!EmptyUtil.isEmpty((String)filter)) {
            sqlBuf.append(" and " + filter);
        }
        if (!EmptyUtil.isEmpty((String)currentCompanyId)) {
            sqlBuf.append(" and b.fviewid = '" + currentCompanyId + "'");
        }
        sqlBuf.append(" group by FUNDDISPATCHPLANBILL.fcompanyid ,b.FLONGNUMBER,b.fname_l2");
        Object[] obj = new Object[]{companyId};
        String querySql = sqlBuf.toString();
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)querySql, (Object[])obj);
        System.out.println("sqlBuf=====" + sqlBuf);
        HashMap<String, Map> result = new HashMap<String, Map>();
        String longNumber = "";
        HashMap<String, Object> info = new HashMap<String, Object>();
        try {
            if (rowSet.next()) {
                info.put("count", rowSet.getInt("count"));
                info.put("longNumber", rowSet.getString("longNumber"));
                longNumber = rowSet.getString("longNumber");
                info.put("companyId", rowSet.getString("companyId"));
                info.put("companyName", rowSet.getString("companyName"));
                info.put("unComfirmAmt", rowSet.getBigDecimal("unComfirmAmt"));
                info.put("comfirmAmt", rowSet.getBigDecimal("comfirmAmt"));
                info.put("totalAmt", rowSet.getBigDecimal("totalAmt"));
                info.put("payAmt", rowSet.getBigDecimal("payAmt"));
                info.put("unPayAmt", rowSet.getBigDecimal("unPayAmt"));
                info.put("isLeaf", "1");
                info.put("id", UUID.randomUUID().toString().trim().replaceAll("-", ""));
                info.put("other", rowSet.getBigDecimal("amtother"));
                if (!EmptyUtil.isEmpty((String)longNumber)) {
                    result.put(longNumber, info);
                }
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return result;
    }

    public static void initParentData(Context ctx, Map<String, Map> list, Map currentInfo, String currentCompanyId, Map<String, Map> parentList) {
        String number = currentInfo.get("longNumber") + "";
        while (!EmptyUtil.isEmpty((String)number) && number.lastIndexOf("!") > -1) {
            number = number.substring(0, number.lastIndexOf("!"));
            try {
                if (parentList.get(number) == null) {
                    Map company = FDUtils.getFdCompany(ctx, number, currentCompanyId);
                    HashMap map = new HashMap();
                    map.put("count", currentInfo.get("count"));
                    map.put("longNumber", number);
                    map.put("companyId", company.get("companyId"));
                    map.put("companyName", company.get("companyName"));
                    map.put("unComfirmAmt", currentInfo.get("unComfirmAmt"));
                    map.put("comfirmAmt", currentInfo.get("comfirmAmt"));
                    map.put("totalAmt", currentInfo.get("totalAmt"));
                    map.put("payAmt", currentInfo.get("payAmt"));
                    map.put("unPayAmt", currentInfo.get("unPayAmt"));
                    parentList.put(number, map);
                    continue;
                }
                parentList.get(number).put("count", Integer.parseInt(parentList.get(number).get("count") + "") + Integer.parseInt(currentInfo.get("count") + ""));
                parentList.get(number).put("unComfirmAmt", FDUtils.add(parentList.get(number).get("unComfirmAmt") + "", currentInfo.get("unComfirmAmt") + ""));
                parentList.get(number).put("comfirmAmt", FDUtils.add(parentList.get(number).get("comfirmAmt") + "", currentInfo.get("comfirmAmt") + ""));
                parentList.get(number).put("totalAmt", FDUtils.add(parentList.get(number).get("totalAmt") + "", currentInfo.get("totalAmt") + ""));
                parentList.get(number).put("payAmt", FDUtils.add(parentList.get(number).get("payAmt") + "", currentInfo.get("payAmt") + ""));
                parentList.get(number).put("unPayAmt", FDUtils.add(parentList.get(number).get("unPayAmt") + "", currentInfo.get("unPayAmt") + ""));
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
        }
    }

    public static String getPlatformEntry1Filter(Context ctx, String companyId) throws EASBizException, BOSException {
        String filter = FundDispatchPlatformWebFacadeFactory.getLocalInstance(ctx).getRule(companyId, "1").get("filter").toString();
        try {
            if (!EmptyUtil.isEmpty((String)filter)) {
                FilterItemInfo filterItem;
                int i;
                FilterInfo temp = new FilterInfo(filter);
                for (i = 0; i < temp.getFilterItems().size(); ++i) {
                    String newDate;
                    String date;
                    filterItem = temp.getFilterItems().get(i);
                    if (filterItem.getCompareValue().toString().indexOf("00:") > 0 && filterItem.getCompareType().equals((Object)CompareType.EQUALS)) {
                        date = filterItem.getCompareValue().toString().substring(0, 10);
                        newDate = filterItem.getPropertyName() + ">='" + filterItem.getCompareValue().toString() + "' and " + filterItem.getPropertyName() + "<='" + date + " 23:59:59'";
                        filter = filter.replace(filterItem.toString(), newDate);
                    }
                    if (filterItem.getCompareValue().toString().indexOf("00:") <= 0 || !filterItem.getCompareType().equals((Object)CompareType.NOTEQUALS)) continue;
                    date = filterItem.getCompareValue().toString().substring(0, 10);
                    newDate = filterItem.getPropertyName() + "<'" + filterItem.getCompareValue().toString() + "' or " + filterItem.getPropertyName() + ">'" + date + " 23:59:59'";
                    filter = filter.replace(filterItem.toString(), newDate);
                }
                temp = new FilterInfo(filter);
                for (i = 0; i < temp.getFilterItems().size(); ++i) {
                    filterItem = temp.getFilterItems().get(i);
                    String tempName = filterItem.getPropertyName();
                    if (tempName.equals("feeType.id")) {
                        tempName = "feeType";
                    }
                    if (tempName.contains(".")) {
                        tempName = tempName.replaceAll("\\.", "");
                    }
                    tempName = "f" + tempName;
                    filterItem.setPropertyName("FUNDDISPATCHPLANBILL." + tempName);
                }
                filter = temp.toString();
            }
        }
        catch (ParserException e1) {
            throw new BOSException((Throwable)e1);
        }
        Pattern pt = Pattern.compile("'.{4}-.{2}-.{2}.*?'");
        Matcher match = pt.matcher(filter);
        while (match.find()) {
            String time = "{ts" + match.group() + "}";
            filter = filter.replace(match.group(), time);
        }
        filter = filter.replaceAll("\\{.*?'", "{ts'");
        if ((filter = filter.replaceAll("'}+", "'}")).length() <= 2) {
            filter = " 1=1 ";
        }
        Pattern pt1 = Pattern.compile("FUNDDISPATCHPLANBILL.ffeeType.*?\\(.*?\\)");
        Matcher match1 = pt1.matcher(filter);
        while (match1.find()) {
            String time = "(" + match1.group() + " or FUNDDISPATCHPLANBILL.ffeetype is null )";
            filter = filter.replace(match1.group(), time);
        }
        filter = FDUtils.formatFExpectPayStartDate(filter);
        return filter;
    }

    public static String formatFExpectPayStartDate(String filter) {
        if (filter.contains("01day") || filter.contains("02day") || filter.contains("07day") || filter.contains("30day")) {
            Calendar cal;
            String time;
            String end;
            String start;
            SimpleDateFormat sdf;
            Matcher matchDay;
            Pattern day;
            if (filter.contains("01day")) {
                day = Pattern.compile("FUNDDISPATCHPLANBILL.fexpectPayStartDate\\s*=.*'01day'");
                matchDay = day.matcher(filter);
                while (matchDay.find()) {
                    Date today = new Date();
                    sdf = new SimpleDateFormat("yyyy-MM-dd");
                    start = sdf.format(today) + " 00:00:00";
                    end = sdf.format(today) + " 23:59:59";
                    time = " FUNDDISPATCHPLANBILL.fexpectPayStartDate >= {ts'" + start + "'} and FUNDDISPATCHPLANBILL.fexpectPayStartDate <= {ts'" + end + "'}  ";
                    filter = filter.replace(matchDay.group(), time);
                }
            }
            if (filter.contains("02day")) {
                day = Pattern.compile("FUNDDISPATCHPLANBILL.fexpectPayStartDate\\s*=.*'02day'");
                matchDay = day.matcher(filter);
                while (matchDay.find()) {
                    cal = new GregorianCalendar();
                    cal.setTime(new Date());
                    cal.add(5, 1);
                    sdf = new SimpleDateFormat("yyyy-MM-dd");
                    start = sdf.format(cal.getTime()) + " 00:00:00";
                    end = sdf.format(cal.getTime()) + " 23:59:59";
                    time = " FUNDDISPATCHPLANBILL.fexpectPayStartDate >= {ts'" + start + "'} and FUNDDISPATCHPLANBILL.fexpectPayStartDate <= {ts'" + end + "'}  ";
                    filter = filter.replace(matchDay.group(), time);
                }
            }
            if (filter.contains("07day")) {
                day = Pattern.compile("FUNDDISPATCHPLANBILL.fexpectPayStartDate\\s*=.*'07day'");
                matchDay = day.matcher(filter);
                while (matchDay.find()) {
                    cal = Calendar.getInstance();
                    cal.setTime(new Date());
                    int dayofweek = cal.get(7);
                    if (dayofweek == 1) {
                        dayofweek += 7;
                    }
                    cal.add(5, 2 - dayofweek);
                    SimpleDateFormat sdf2 = new SimpleDateFormat("yyyy-MM-dd");
                    String start2 = sdf2.format(cal.getTime()) + " 00:00:00";
                    Calendar calend = Calendar.getInstance();
                    calend.setTime(cal.getTime());
                    calend.add(7, 6);
                    String end2 = sdf2.format(calend.getTime()) + " 23:59:59";
                    String time2 = " FUNDDISPATCHPLANBILL.fexpectPayStartDate >= {ts'" + start2 + "'} and FUNDDISPATCHPLANBILL.fexpectPayStartDate <= {ts'" + end2 + "'}  ";
                    filter = filter.replace(matchDay.group(), time2);
                }
            }
            if (filter.contains("30day")) {
                day = Pattern.compile("FUNDDISPATCHPLANBILL.fexpectPayStartDate\\s*=.*'30day'");
                matchDay = day.matcher(filter);
                while (matchDay.find()) {
                    cal = Calendar.getInstance();
                    cal.add(2, 0);
                    cal.set(5, 1);
                    SimpleDateFormat sdf3 = new SimpleDateFormat("yyyy-MM-dd");
                    start = sdf3.format(cal.getTime()) + " 00:00:00";
                    Calendar calend = Calendar.getInstance();
                    calend.set(5, calend.getActualMaximum(5));
                    String end3 = sdf3.format(calend.getTime()) + " 23:59:59";
                    String time3 = " FUNDDISPATCHPLANBILL.fexpectPayStartDate >= {ts'" + start + "'} and FUNDDISPATCHPLANBILL.fexpectPayStartDate <= {ts'" + end3 + "'}  ";
                    filter = filter.replace(matchDay.group(), time3);
                }
            }
        }
        return filter;
    }

    public static BigDecimal add(String amt1, String amt2) {
        BigDecimal b1 = new BigDecimal(amt1);
        BigDecimal b2 = new BigDecimal(amt2);
        return b1.add(b2);
    }
}

