/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fin;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.vc.VerifyScopeEnum;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.BillTypeEnum;
import com.kingdee.eas.fi.cas.IBookNotifyBuilder;
import com.kingdee.eas.fi.cas.JournalCollection;
import com.kingdee.eas.fi.cas.JournalInfo;
import com.kingdee.eas.fi.cas.JournalSourceEnum;
import com.kingdee.eas.fi.cas.JournalTypeEnum;
import com.kingdee.eas.fm.fin.FeeManageFactory;
import com.kingdee.eas.fm.fin.FeeManageInfo;
import com.kingdee.eas.fm.fin.IFeeManage;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import java.util.Date;
import java.util.Iterator;
import java.util.Locale;
import java.util.Set;

public class FeeBillBookNotifyBuilder
implements IBookNotifyBuilder {
    private SelectorItemCollection getSelector() {
        SelectorItemCollection cel = new SelectorItemCollection();
        cel.add("*");
        cel.add("company.id");
        cel.add("accountview.*");
        cel.add("accountBank.*");
        return cel;
    }

    private FeeManageInfo getFeeManageInfo(Context ctx, String billId) throws BOSException, EASBizException {
        IFeeManage feeManage = FeeManageFactory.getLocalInstance(ctx);
        FeeManageInfo feeManageInfo = feeManage.getFeeManageInfo((IObjectPK)new ObjectUuidPK(billId), this.getSelector());
        return feeManageInfo;
    }

    public JournalCollection getJournalColl(Context ctx, String billId) throws BOSException, EASBizException {
        JournalCollection journalCollection = new JournalCollection();
        UserInfo userInfo = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser();
        FeeManageInfo manageInfo = this.getFeeManageInfo(ctx, billId);
        JournalInfo journalInfo = this.createJournal(ctx, manageInfo);
        journalCollection.add(journalInfo);
        FeeBillBookNotifyBuilder.insertCashier(ctx, userInfo.getId().toString(), manageInfo.getId().toString());
        return journalCollection;
    }

    private JournalInfo createJournal(Context ctx, FeeManageInfo manageInfo) throws BOSException, EASBizException {
        JournalInfo journalInfo = new JournalInfo();
        journalInfo.setCompany(manageInfo.getCompany());
        journalInfo.setSource(JournalSourceEnum.BYBILL);
        journalInfo.setBillId(manageInfo.getId().toString());
        journalInfo.setAccountBank(manageInfo.getAccountBank());
        journalInfo.setCurrency(manageInfo.getCurrency());
        CompanyOrgUnitInfo companyInfo1 = manageInfo.getCompany();
        Date bookDate = this.getBookDate(ctx, manageInfo, companyInfo1);
        journalInfo.setCreateDate(bookDate);
        journalInfo.setDebitAmount(Constants.ZERO);
        journalInfo.setCreditAmount(manageInfo.getMoneyAmount());
        journalInfo.setBillType(BillTypeEnum.letterOfCredit);
        journalInfo.setBillNumber(manageInfo.getBusinessNumber());
        journalInfo.setBizDate(manageInfo.getBizDate());
        journalInfo.setOppAccountView(manageInfo.getAccountview());
        journalInfo.setAccountView(manageInfo.getAccountBank().getAccount());
        String des = "";
        if (ctx != null) {
            des = ResourceBase.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"445_FeeBillBookNotifyBuilder", (Locale)ctx.getLocale());
        }
        journalInfo.setDescription(des);
        journalInfo.setType(JournalTypeEnum.BANK);
        PeriodInfo bookPeriodInfo = PeriodUtils.getPeriodInfo((Context)ctx, (Date)bookDate, (CompanyOrgUnitInfo)companyInfo1);
        journalInfo.setPeriod(bookPeriodInfo);
        UserInfo userInfo = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser();
        journalInfo.setCashier(userInfo);
        journalInfo.setVerifyStatus(VerifyScopeEnum.NOVA);
        return journalInfo;
    }

    private Date getBookDate(Context ctx, FeeManageInfo manageInfo, CompanyOrgUnitInfo companyInfo) throws BOSException, EASBizException {
        PeriodInfo currPeriodInfo = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.CASHMANAGEMENT, (CompanyOrgUnitInfo)companyInfo);
        if (currPeriodInfo == null) {
            throw new EASBizException(EASBizException.CHECKBLANK, new Object[]{EASResource.getString((String)"com.kingdee.eas.fm.nt.ChequeResource", (String)"currPeriod")});
        }
        Date bookDate = manageInfo.getBizDate();
        if (bookDate.before(currPeriodInfo.getBeginDate())) {
            bookDate = currPeriodInfo.getBeginDate();
        }
        return bookDate;
    }

    public static void insertCashier(Context ctx, String userId, String feeId) throws BOSException {
        String strSql = "update t_fin_feemanage set FCashierID = ";
        strSql = userId == null ? strSql + userId + " where fid = '" + feeId + "'" : strSql + "'" + userId + "' where fid = '" + feeId + "'";
        DbUtil.execute((Context)ctx, (String)strSql);
    }

    public JournalCollection getJournalColl(Context ctx, Set idSet) throws BOSException, EASBizException {
        JournalCollection journalCollection = new JournalCollection();
        if (idSet == null || idSet.size() == 0) {
            return journalCollection;
        }
        Iterator iterator = idSet.iterator();
        while (iterator.hasNext()) {
            journalCollection.addCollection(this.getJournalColl(ctx, iterator.next().toString()));
        }
        return journalCollection;
    }
}

