/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fin;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.BillDisposerAction;
import com.kingdee.eas.fi.cas.DisposerActionEnum;
import com.kingdee.eas.fi.cas.IPaymentDisposer;
import com.kingdee.eas.fi.cas.IReceivingDisposer;
import com.kingdee.eas.fi.cas.PaymentBillEntryCollection;
import com.kingdee.eas.fi.cas.PaymentBillEntryInfo;
import com.kingdee.eas.fi.cas.PaymentBillInfo;
import com.kingdee.eas.fi.cas.ReceivingBillEntryCollection;
import com.kingdee.eas.fi.cas.ReceivingBillEntryInfo;
import com.kingdee.eas.fi.cas.ReceivingBillInfo;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.fin.FinBizException;
import com.kingdee.eas.fm.fin.LoanInfo;
import com.kingdee.eas.fm.fin.RepaymentDisposer;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public abstract class FinBillDisposer
implements IReceivingDisposer,
IPaymentDisposer {
    protected BillDisposerAction billDisposerAction;
    protected String srcID;
    protected Set<String> srcIdSet = new HashSet<String>();
    protected boolean isLoanToPay = false;

    public BigDecimal getCashRebate(Date billDate, BigDecimal arAmount, String srcBillId, String srcBillEntryId) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void dispose(Context ctx, BillDisposerAction action) throws BOSException, EASBizException {
        this.billDisposerAction = action;
        if (action.getDestBill() == null) {
            return;
        }
        IMutexServiceControl iMutex = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        ArrayList appliedList = new ArrayList();
        if (action.getDestBill() instanceof PaymentBillInfo) {
            PaymentBillInfo payBillInfo = (PaymentBillInfo)action.getDestBill();
            String srcId = "";
            if (this instanceof RepaymentDisposer) {
                PaymentBillEntryCollection payEntryCol = payBillInfo.getEntries();
                PaymentBillEntryInfo entry = payEntryCol.get(0);
                if (!EmptyUtil.isEmpty((String)entry.getSourceBillId()) && !EmptyUtil.isEmpty((Collection)FMHelper.getSrcBillIdByType((Context)ctx, (String)entry.getSourceBillId(), (Object)new LoanInfo()))) {
                    this.isLoanToPay = true;
                    for (int i = 0; i < payEntryCol.size(); ++i) {
                        PaymentBillEntryInfo entryInfo = payEntryCol.get(i);
                        if (EmptyUtil.isEmpty((String)entryInfo.getSourceBillId())) continue;
                        this.srcIdSet.add(entryInfo.getSourceBillId());
                    }
                }
            } else if (!EmptyUtil.isEmpty((String)payBillInfo.getSourceBillId())) {
                srcId = payBillInfo.getSourceBillId();
            } else {
                PaymentBillEntryInfo payEntryInfo = null;
                PaymentBillEntryCollection payEntryCol = payBillInfo.getEntries();
                if (payEntryCol != null && payEntryCol.size() > 0 && !EmptyUtil.isEmpty((String)(payEntryInfo = payEntryCol.get(0)).getSourceBillId())) {
                    srcId = payEntryInfo.getSourceBillId();
                }
            }
            this.srcID = srcId;
            StringBuilder sb = new StringBuilder();
            try {
                Map keyValuseMap;
                if (!EmptyUtil.isEmpty(this.srcIdSet)) {
                    Map resultRequest = iMutex.batchRequestObjIDForUpdate(new ArrayList<String>(this.srcIdSet));
                    for (Object o : resultRequest.keySet()) {
                        Boolean b = (Boolean)resultRequest.get(o);
                        if (!b.booleanValue()) continue;
                        appliedList.add(o);
                    }
                    if (appliedList.size() < this.srcIdSet.size()) {
                        iMutex.batchReleaseObjIDForUpdate(appliedList);
                        appliedList.clear();
                        throw new FinBizException(FinBizException.COMMON, new String[]{ResourceBase.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"couldNotGetLock", (Locale)ctx.getLocale())});
                    }
                }
                if ((keyValuseMap = this.getDisposeKeyValueMap(ctx)) == null) {
                    if (action.getActionType().equals((Object)DisposerActionEnum.DELETE)) {
                        sb.append("update ").append(this.getDBTableName()).append(" set FIsGenPayBill=0 where FID=?");
                        DbUtil.execute((Context)ctx, (String)sb.toString(), (Object[])new Object[]{srcId});
                    }
                    if (!action.getActionType().equals((Object)DisposerActionEnum.SAVE) && !action.getActionType().equals((Object)DisposerActionEnum.SUBMIT)) return;
                    sb.append("update ").append(this.getDBTableName()).append(" set FIsGenPayBill=1 where FID=?");
                    DbUtil.execute((Context)ctx, (String)sb.toString(), (Object[])new Object[]{srcId});
                    return;
                }
                if (keyValuseMap.size() <= 0) return;
                if (keyValuseMap.get("isLoanToPay") != null) {
                    if (keyValuseMap.keySet().size() <= 1) return;
                    for (String srcBillId : this.srcIdSet) {
                        sb.setLength(0);
                        ArrayList values = (ArrayList)keyValuseMap.get(srcBillId);
                        sb.append("update T_fin_repayment set FIsPayCompleted = ? , FTotalPayedAmt = ? , FIsGenPayBill = ? where fid = ?");
                        DbUtil.execute((Context)ctx, (String)sb.toString(), (Object[])new Object[]{values.get(0), values.get(1), values.get(2), srcBillId});
                    }
                    return;
                }
                Iterator it = keyValuseMap.keySet().iterator();
                sb.append("update ").append(this.getDBTableName()).append(" set ");
                StringBuilder sb1 = new StringBuilder();
                while (it.hasNext()) {
                    String key = (String)it.next();
                    sb1.append(key).append(" = ").append(keyValuseMap.get(key)).append(",");
                }
                String sql = sb1.substring(0, sb1.lastIndexOf(","));
                sb.append(sql).append(" where fid = ?");
                DbUtil.execute((Context)ctx, (String)sb.toString(), (Object[])new Object[]{srcId});
                this.disposeOtherSrcBill(ctx, payBillInfo);
                return;
            }
            finally {
                if (!EmptyUtil.isEmpty(appliedList)) {
                    iMutex.batchReleaseObjIDForUpdate(appliedList);
                }
            }
        } else {
            if (!(action.getDestBill() instanceof ReceivingBillInfo)) return;
            ReceivingBillInfo recBillInfo = (ReceivingBillInfo)action.getDestBill();
            String srcId = "";
            if (!EmptyUtil.isEmpty((String)recBillInfo.getSourceBillId())) {
                srcId = recBillInfo.getSourceBillId();
            } else {
                ReceivingBillEntryInfo recEntryInfo = null;
                ReceivingBillEntryCollection recEntryCol = recBillInfo.getEntries();
                if (recEntryCol != null && recEntryCol.size() > 0 && !EmptyUtil.isEmpty((String)(recEntryInfo = recEntryCol.get(0)).getSourceBillId())) {
                    srcId = recEntryInfo.getSourceBillId();
                }
            }
            this.srcID = srcId;
            StringBuilder sb = new StringBuilder();
            Map keyValuseMap = this.getDisposeKeyValueMap(ctx);
            if (keyValuseMap == null) {
                if (action.getActionType().equals((Object)DisposerActionEnum.DELETE)) {
                    sb.append("update ").append(this.getDBTableName()).append(" set FIsGenRecBill=0 where FID=?");
                    DbUtil.execute((Context)ctx, (String)sb.toString(), (Object[])new Object[]{srcId});
                }
                if (!action.getActionType().equals((Object)DisposerActionEnum.SAVE) && !action.getActionType().equals((Object)DisposerActionEnum.SUBMIT)) return;
                sb.append("update ").append(this.getDBTableName()).append(" set FIsGenRecBill=1 where FID=?");
                DbUtil.execute((Context)ctx, (String)sb.toString(), (Object[])new Object[]{srcId});
                return;
            } else {
                if (keyValuseMap.size() <= 0) return;
                Iterator it = keyValuseMap.keySet().iterator();
                sb.append("update ").append(this.getDBTableName()).append(" set ");
                StringBuilder sb1 = new StringBuilder();
                while (it.hasNext()) {
                    String key = (String)it.next();
                    sb1.append(key).append(" = ").append(keyValuseMap.get(key)).append(",");
                }
                sb1.substring(sb1.lastIndexOf(","));
                sb.append((CharSequence)sb1).append(" where fid = ?");
                DbUtil.execute((Context)ctx, (String)sb.toString(), (Object[])new Object[]{srcId});
            }
        }
    }

    protected abstract String getDBTableName();

    protected String getDisposeKeyName() {
        return null;
    }

    protected Map getDisposeKeyValueMap(Context ctx) throws EASBizException, BOSException {
        return null;
    }

    protected void disposeOtherSrcBill(Context ctx, PaymentBillInfo payBillInfo) throws EASBizException, BOSException {
    }
}

