/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fin;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.extendcontrols.ext.IFilterInfoProducer;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.BasicFormattedTextField;
import com.kingdee.bos.ctrl.swing.IKDTextComponent;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDLabelContainer;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.KDRadioButton;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.DynamicObjectFactory;
import com.kingdee.bos.metadata.bot.BOTRelationFactory;
import com.kingdee.bos.metadata.bot.BOTRelationInfo;
import com.kingdee.bos.metadata.bot.IBOTRelation;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.basedata.assistant.BankInfo;
import com.kingdee.eas.basedata.assistant.ConvertModeEnum;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ExchangeRateFactory;
import com.kingdee.eas.basedata.assistant.ExchangeRateInfo;
import com.kingdee.eas.basedata.assistant.ExchangeTableFactory;
import com.kingdee.eas.basedata.assistant.ExchangeTableInfo;
import com.kingdee.eas.basedata.assistant.IExchangeRate;
import com.kingdee.eas.basedata.assistant.client.BankF7Selector;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.client.f7.NewOrgUnitFilterInfoProducer;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fm.common.AccessHelper;
import com.kingdee.eas.fm.common.EJBAccessFactory;
import com.kingdee.eas.fm.common.FMException;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.IEJBAccess;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMClientVerifyHelper;
import com.kingdee.eas.fm.ctl.BankFactorInfo;
import com.kingdee.eas.fm.ctl.LetterOfGuaranteeFactory;
import com.kingdee.eas.fm.ctl.LetterOfGuaranteeInfo;
import com.kingdee.eas.fm.fin.CreditLimitEntryCollection;
import com.kingdee.eas.fm.fin.CreditLimitEntryFactory;
import com.kingdee.eas.fm.fin.CreditLimitEntryInfo;
import com.kingdee.eas.fm.fin.CreditLimitFactory;
import com.kingdee.eas.fm.fin.CreditLimitInfo;
import com.kingdee.eas.fm.fin.CreditLimitManagerFactory;
import com.kingdee.eas.fm.fin.CreditLimitStatusEnum;
import com.kingdee.eas.fm.fin.CreditLimitUsedCollection;
import com.kingdee.eas.fm.fin.CreditLimitUsedFactory;
import com.kingdee.eas.fm.fin.CreditLimitUsedInfo;
import com.kingdee.eas.fm.fin.DeferReturnCLEntryFactory;
import com.kingdee.eas.fm.fin.FinBizException;
import com.kingdee.eas.fm.fin.FinancingBillInfo;
import com.kingdee.eas.fm.fin.FinancingBillTypeEnum;
import com.kingdee.eas.fm.fin.FinancingProductsCollection;
import com.kingdee.eas.fm.fin.FinancingProductsFactory;
import com.kingdee.eas.fm.fin.FinancingProductsInfo;
import com.kingdee.eas.fm.fin.ICreditLimitEntry;
import com.kingdee.eas.fm.fin.LetterOfCreditFactory;
import com.kingdee.eas.fm.fin.LetterOfCreditInfo;
import com.kingdee.eas.fm.fin.LimitPropertyEnum;
import com.kingdee.eas.fm.fin.LimitTypeEnum;
import com.kingdee.eas.fm.fin.LoanFactory;
import com.kingdee.eas.fm.fin.LoanInfo;
import com.kingdee.eas.fm.fin.RepaymentCollection;
import com.kingdee.eas.fm.fin.RepaymentFactory;
import com.kingdee.eas.fm.fin.RepaymentInfo;
import com.kingdee.eas.fm.fin.RepaymentTypeEnum;
import com.kingdee.eas.fm.fin.ShareTypeEnum;
import com.kingdee.eas.fm.ivt.ReturnWayEnum;
import com.kingdee.eas.fm.nt.AssureAmountCollection;
import com.kingdee.eas.fm.nt.AssureAmountFactory;
import com.kingdee.eas.fm.nt.AssureAmountInfo;
import com.kingdee.eas.fm.nt.LetterOfCreditApplyInfo;
import com.kingdee.eas.fm.nt.LetterOfCreditReachInfo;
import com.kingdee.eas.fm.nt.PayableBillFactory;
import com.kingdee.eas.fm.nt.PayableBillInfo;
import com.kingdee.eas.framework.BillBaseInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.framework.ObjectBaseInfo;
import com.kingdee.eas.util.EASCommonResource;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionListener;
import java.awt.event.ComponentListener;
import java.awt.event.ItemListener;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.MessageFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Set;
import javax.swing.JComponent;
import org.apache.log4j.Logger;

public class FinUtils {
    private static final String RESOURCE = "com.kingdee.eas.fm.fin.FinResource";
    private static final Logger logger = CoreUIObject.getLogger(FinUtils.class);
    public static final BOSObjectType type_payableBill = new PayableBillInfo().getBOSType();
    public static final BOSObjectType type_loan = LoanInfo.BOSTYPE;
    public static final BOSObjectType type_letterOfCredit = LetterOfCreditInfo.BOSTYPE;
    public static final BOSObjectType type_letterOfCreditApply = new LetterOfCreditApplyInfo().getBOSType();
    public static final BOSObjectType type_letterOfCreditReach = new LetterOfCreditReachInfo().getBOSType();
    public static final BOSObjectType type_letterOfGuartee = new LetterOfGuaranteeInfo().getBOSType();
    public static final BOSObjectType type_bankFactor = new BankFactorInfo().getBOSType();

    public static void initExchangeRate(BasicFormattedTextField txtExchangeRate, CompanyOrgUnitInfo companyOrgUnitInfo, CurrencyInfo sourceCurr, CurrencyInfo destCurr, Date date) throws EASBizException, BOSException {
        if (sourceCurr == null || destCurr == null) {
            return;
        }
        BigDecimal rate = null;
        int precision = 5;
        if (sourceCurr.getId().equals((Object)destCurr.getId())) {
            rate = Constants.ONE;
            txtExchangeRate.setValue((Object)rate);
            txtExchangeRate.setEditable(false);
            return;
        }
        ExchangeRateInfo exchangeRateInfo = FinUtils.getCurrencyExRateInfo(companyOrgUnitInfo, sourceCurr, destCurr, date);
        if (exchangeRateInfo == null) {
            rate = Constants.ONE;
        } else {
            rate = exchangeRateInfo.getConvertRate();
            precision = exchangeRateInfo.getPrecision();
        }
        txtExchangeRate.setEditable(true);
        if (txtExchangeRate instanceof KDFormattedTextField) {
            ((KDFormattedTextField)txtExchangeRate).setPrecision(precision);
        }
        txtExchangeRate.setValue((Object)rate);
    }

    public static ExchangeRateInfo getCurrencyExRateInfo(CompanyOrgUnitInfo companyOrgUnitInfo, CurrencyInfo sourceCurr, CurrencyInfo destCurr, Date date) throws FinBizException, BOSException, EASBizException {
        return FMHelper.getExRateInfo((CurrencyInfo)sourceCurr, (CurrencyInfo)destCurr, (CompanyOrgUnitInfo)companyOrgUnitInfo, (Date)date);
    }

    public static void initExchangeRate(Context ctx, BasicFormattedTextField txtExchangeRate, CompanyOrgUnitInfo companyOrgUnitInfo, CurrencyInfo sourceCurr, CurrencyInfo destCurr, Date date, ExchangeRateInfo rateInfo) throws EASBizException, BOSException {
        boolean isSameCur;
        if (sourceCurr == null || destCurr == null) {
            return;
        }
        BigDecimal rate = null;
        int precision = 10;
        if (sourceCurr.getId().equals((Object)destCurr.getId())) {
            rate = Constants.ONE;
            txtExchangeRate.setValue((Object)rate);
            txtExchangeRate.setEditable(false);
            if (txtExchangeRate instanceof KDFormattedTextField) {
                ((KDFormattedTextField)txtExchangeRate).setPrecision(5);
            }
            return;
        }
        ExchangeRateInfo exchangeRateInfo = null;
        exchangeRateInfo = rateInfo == null ? FinUtils.getCurrencyExRateInfo(ctx, companyOrgUnitInfo, sourceCurr, destCurr, date) : rateInfo;
        if (exchangeRateInfo == null) {
            String sourceCurrName = sourceCurr.getName();
            if (sourceCurrName == null) {
                sourceCurrName = CurrencyFactory.getRemoteInstance().getCurrencyInfo((IObjectPK)new ObjectUuidPK(sourceCurr.getId())).getName();
            }
            throw new FinBizException(FinBizException.EXRATENULLFORNAME, new String[]{sourceCurr.getName() == null ? "" : sourceCurr.getName()});
        }
        rate = exchangeRateInfo.getConvertRate();
        precision = exchangeRateInfo.getPrecision();
        txtExchangeRate.setValue((Object)rate);
        txtExchangeRate.setEditable(true);
        if (txtExchangeRate instanceof KDFormattedTextField) {
            ((KDFormattedTextField)txtExchangeRate).setPrecision(precision);
        }
        txtExchangeRate.setEnabled(!(isSameCur = sourceCurr.getId().equals((Object)destCurr.getId())));
    }

    public static void initExchangeRatePrecision(Context ctx, BasicFormattedTextField txtExchangeRate, CompanyOrgUnitInfo companyOrgUnitInfo, CurrencyInfo sourceCurr, CurrencyInfo destCurr, Date date, ExchangeRateInfo rateInfo) throws EASBizException, BOSException {
        boolean isSameCur;
        if (sourceCurr == null || destCurr == null) {
            return;
        }
        BigDecimal rate = null;
        int precision = 10;
        if (sourceCurr.getId().equals((Object)destCurr.getId())) {
            rate = Constants.ONE;
            txtExchangeRate.setValue((Object)rate);
            txtExchangeRate.setEditable(false);
            if (txtExchangeRate instanceof KDFormattedTextField) {
                ((KDFormattedTextField)txtExchangeRate).setPrecision(5);
            }
            return;
        }
        ExchangeRateInfo exchangeRateInfo = null;
        exchangeRateInfo = rateInfo == null ? FinUtils.getCurrencyExRateInfo(ctx, companyOrgUnitInfo, sourceCurr, destCurr, date) : rateInfo;
        if (exchangeRateInfo == null) {
            String sourceCurrName = sourceCurr.getName();
            if (sourceCurrName == null) {
                sourceCurrName = CurrencyFactory.getRemoteInstance().getCurrencyInfo((IObjectPK)new ObjectUuidPK(sourceCurr.getId())).getName();
            }
            throw new FinBizException(FinBizException.EXRATENULLFORNAME, new String[]{sourceCurr.getName() == null ? "" : sourceCurr.getName()});
        }
        rate = exchangeRateInfo.getConvertRate();
        precision = exchangeRateInfo.getPrecision();
        txtExchangeRate.setEditable(true);
        if (txtExchangeRate instanceof KDFormattedTextField) {
            ((KDFormattedTextField)txtExchangeRate).setPrecision(precision);
        }
        txtExchangeRate.setEnabled(!(isSameCur = sourceCurr.getId().equals((Object)destCurr.getId())));
    }

    public static void initExchangeRateForLoan(Context ctx, BasicFormattedTextField txtExchangeRate, CompanyOrgUnitInfo companyOrgUnitInfo, CurrencyInfo sourceCurr, CurrencyInfo destCurr, Date date, ExchangeRateInfo rateInfo) throws EASBizException, BOSException {
        boolean isSameCur;
        if (sourceCurr == null || destCurr == null) {
            return;
        }
        BigDecimal rate = null;
        int precision = 10;
        if (sourceCurr.getId().equals((Object)destCurr.getId())) {
            rate = Constants.ONE;
            txtExchangeRate.setValue((Object)rate);
            txtExchangeRate.setEditable(false);
            if (txtExchangeRate instanceof KDFormattedTextField) {
                ((KDFormattedTextField)txtExchangeRate).setPrecision(5);
            }
            return;
        }
        ExchangeRateInfo exchangeRateInfo = null;
        exchangeRateInfo = rateInfo == null ? FinUtils.getCurrencyExRateInfo(ctx, companyOrgUnitInfo, sourceCurr, destCurr, date) : rateInfo;
        if (exchangeRateInfo == null) {
            rate = Constants.ZERO;
        } else {
            rate = exchangeRateInfo.getConvertRate();
            precision = exchangeRateInfo.getPrecision();
        }
        txtExchangeRate.setValue((Object)rate);
        txtExchangeRate.setEditable(true);
        if (txtExchangeRate instanceof KDFormattedTextField) {
            ((KDFormattedTextField)txtExchangeRate).setPrecision(precision);
        }
        txtExchangeRate.setEnabled(!(isSameCur = sourceCurr.getId().equals((Object)destCurr.getId())));
    }

    public static void initExchangeRate(Context ctx, ICell txtExchangeRate, CompanyOrgUnitInfo companyOrgUnitInfo, CurrencyInfo sourceCurr, CurrencyInfo destCurr, Date date, ExchangeRateInfo rateInfo) throws EASBizException, BOSException {
        txtExchangeRate.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        if (sourceCurr == null || destCurr == null) {
            return;
        }
        BigDecimal rate = null;
        int precision = 2;
        if (sourceCurr.getId().equals((Object)destCurr.getId())) {
            rate = Constants.ONE;
            txtExchangeRate.setValue((Object)rate);
            ((KDFormattedTextField)txtExchangeRate.getEditor().getComponent()).setEnabled(false);
            if (txtExchangeRate instanceof ICell) {
                txtExchangeRate.getStyleAttributes().setNumberFormat(FMClientHelper.getNumberFtm((int)2));
            }
            return;
        }
        ExchangeRateInfo exchangeRateInfo = null;
        exchangeRateInfo = rateInfo == null ? FinUtils.getCurrencyExRateInfo(ctx, companyOrgUnitInfo, sourceCurr, destCurr, date) : rateInfo;
        if (exchangeRateInfo == null) {
            rate = Constants.ONE;
        } else {
            rate = exchangeRateInfo.getConvertRate();
            precision = exchangeRateInfo.getPrecision();
        }
        txtExchangeRate.getStyleAttributes().setNumberFormat(FMClientHelper.getNumberFtm((int)precision));
        txtExchangeRate.setValue((Object)rate);
        ((KDFormattedTextField)txtExchangeRate.getEditor().getComponent()).setEnabled(true);
        if (txtExchangeRate instanceof KDFormattedTextField) {
            ((KDFormattedTextField)txtExchangeRate).setPrecision(precision);
        }
        boolean isSameCur = sourceCurr.getId().equals((Object)destCurr.getId());
        ((KDFormattedTextField)txtExchangeRate.getEditor().getComponent()).setEnabled(!isSameCur);
    }

    public static void initCompanyTree(IUIObject filterUI, KDBizPromptBox prmtCompany, Boolean isGroup) throws Exception {
        if (prmtCompany != null) {
            NewOrgUnitFilterInfoProducer iProducer = null;
            iProducer = new NewOrgUnitFilterInfoProducer(OrgType.Company);
            if (iProducer != null) {
                prmtCompany.setFilterInfoProducer((IFilterInfoProducer)iProducer);
                if (iProducer.getModel() != null) {
                    iProducer.getModel().setNeedAddOrgRange(false);
                    prmtCompany.setSelector((KDPromptSelector)iProducer.getModel());
                    iProducer.getModel().setMultiSelect(false);
                }
            }
            prmtCompany.setCommitFormat("$number$;$code$");
            prmtCompany.setEditFormat("$number$");
            prmtCompany.setDisplayFormat("$name$");
            prmtCompany.setEnabledMultiSelection(false);
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("isGroup", (Object)isGroup));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        prmtCompany.setQueryInfo("com.kingdee.eas.basedata.org.app.CompanyOrgUnitQuery");
        prmtCompany.setEntityViewInfo(evi);
    }

    public static ExchangeRateInfo getCurrencyExRateInfo(Context ctx, CompanyOrgUnitInfo companyOrgUnitInfo, CurrencyInfo sourceCurr, CurrencyInfo destCurr, Date date) throws FinBizException, BOSException, EASBizException {
        if (ctx == null) {
            return FMHelper.getExRateInfo((CurrencyInfo)sourceCurr, (CurrencyInfo)destCurr, (CompanyOrgUnitInfo)companyOrgUnitInfo, (Date)date);
        }
        return FMHelper.getExRateInfo((Context)ctx, (CurrencyInfo)sourceCurr, (CurrencyInfo)destCurr, (CompanyOrgUnitInfo)companyOrgUnitInfo, (Date)date);
    }

    public static BigDecimal getCurrencyExRate(Context ctx, BOSUuid companyOrgUnitId, BOSUuid sourceCurrId, BOSUuid destCurrId, Date date) throws FinBizException, BOSException, EASBizException {
        CompanyOrgUnitInfo companyOrgUnitInfo = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyOrgUnitId));
        CurrencyInfo sourceCurr = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyInfo((IObjectPK)new ObjectUuidPK(sourceCurrId));
        CurrencyInfo destCurr = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyInfo((IObjectPK)new ObjectUuidPK(destCurrId));
        if (sourceCurr.getId().equals((Object)destCurr.getId())) {
            return Constants.ONE;
        }
        ExchangeTableInfo exchangeTableInfo = companyOrgUnitInfo.getBaseExchangeTable();
        ObjectUuidPK excTablepk = null;
        if (exchangeTableInfo == null) {
            throw new FinBizException(FinBizException.EXRATETABLENULL);
        }
        exchangeTableInfo = ExchangeTableFactory.getLocalInstance((Context)ctx).getExchangeTableInfo((IObjectPK)new ObjectUuidPK(exchangeTableInfo.getId()));
        excTablepk = new ObjectUuidPK(exchangeTableInfo.getId());
        ObjectUuidPK sourceCurrPK = new ObjectUuidPK(sourceCurr.getId());
        ObjectUuidPK destCurrPK = new ObjectUuidPK(destCurr.getId());
        IExchangeRate iexchangRate = ExchangeRateFactory.getLocalInstance((Context)ctx);
        ExchangeRateInfo exchangeRateInfo = null;
        exchangeRateInfo = iexchangRate.getExchangeRate((IObjectPK)excTablepk, (IObjectPK)sourceCurrPK, (IObjectPK)destCurrPK, date);
        if (exchangeRateInfo == null && exchangeTableInfo.isIsReversible()) {
            ExchangeRateInfo tempExRateInfo = iexchangRate.getExchangeRate((IObjectPK)excTablepk, (IObjectPK)destCurrPK, (IObjectPK)sourceCurrPK, date);
            if (tempExRateInfo != null && tempExRateInfo.getConvertRate() != null && tempExRateInfo.getConvertRate().signum() != 0 && tempExRateInfo.getConvertMode().equals((Object)ConvertModeEnum.INDIRECTEXCHANGERATE)) {
                return new BigDecimal(String.valueOf(1)).divide(tempExRateInfo.getConvertRate(), 10, 4);
            }
        } else if (exchangeRateInfo == null && !exchangeTableInfo.isIsReversible()) {
            return Constants.ONE;
        }
        return null == exchangeRateInfo ? Constants.ONE : exchangeRateInfo.getConvertRate();
    }

    public static void initExRateTxtFieldStatus(KDFormattedTextField txtExchangeRate, CompanyOrgUnitInfo companyOrgUnitInfo, CurrencyInfo sourceCurr, CurrencyInfo destCurr) throws EASBizException, BOSException {
        if (sourceCurr == null || destCurr == null) {
            return;
        }
        txtExchangeRate.setEditable(true);
        if (sourceCurr.getId().equals((Object)destCurr.getId())) {
            txtExchangeRate.setEditable(false);
            return;
        }
    }

    private static SelectorItemCollection getFinBillSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("Source.*"));
        sic.add(new SelectorItemInfo("Type.*"));
        sic.add(new SelectorItemInfo("Currency.*"));
        sic.add(new SelectorItemInfo("CreditCurrency.*"));
        sic.add(new SelectorItemInfo("GaranteeType.*"));
        sic.add(new SelectorItemInfo("CreditLimit.*"));
        sic.add(new SelectorItemInfo("Institution.*"));
        sic.add(new SelectorItemInfo("CreditLimit.CreditUsage.*"));
        sic.add(new SelectorItemInfo("CreditLimit.*"));
        sic.add(new SelectorItemInfo("guaranteeEntrys.*"));
        return sic;
    }

    public static FinancingBillInfo getFinBillRemote(String id) throws BOSException, EASBizException {
        BOSUuid pk = BOSUuid.read((String)id);
        IObjectValue ov = DynamicObjectFactory.getRemoteInstance().getValue(pk.getType(), (IObjectPK)new ObjectUuidPK(pk), FinUtils.getFinBillSelector());
        return (FinancingBillInfo)ov;
    }

    public static FinancingBillInfo getFinBillLocal(Context ctx, String id) throws BOSException, EASBizException {
        BOSUuid pk = BOSUuid.read((String)id);
        Object vo = null;
        if (type_payableBill.equals((Object)pk.getType())) {
            vo = PayableBillFactory.getLocalInstance((Context)ctx).getPayableBillInfo((IObjectPK)new ObjectUuidPK(pk), FinUtils.getFinBillSelector());
        } else if (type_loan.equals((Object)pk.getType())) {
            vo = LoanFactory.getLocalInstance(ctx).getLoanInfo((IObjectPK)new ObjectUuidPK(pk), FinUtils.getFinBillSelector());
        } else if (type_letterOfCredit.equals((Object)pk.getType())) {
            vo = LetterOfCreditFactory.getLocalInstance(ctx).getLetterOfCreditInfo((IObjectPK)new ObjectUuidPK(pk), FinUtils.getFinBillSelector());
        } else if (type_letterOfCreditReach.equals((Object)pk.getType())) {
            String did = (String)FMHelper.set2List((Set)FMHelper.getSrcBillIdSet((Context)ctx, (String)pk.toString())).get(0);
            vo = LetterOfCreditFactory.getLocalInstance(ctx).getLetterOfCreditInfo((IObjectPK)new ObjectUuidPK(did), FinUtils.getFinBillSelector());
        } else {
            vo = type_letterOfGuartee.equals((Object)pk.getType()) ? LetterOfGuaranteeFactory.getLocalInstance((Context)ctx).getLetterOfGuaranteeInfo((IObjectPK)new ObjectUuidPK(pk), FinUtils.getFinBillSelector()) : (type_bankFactor.equals((Object)pk.getType()) ? null : DynamicObjectFactory.getLocalInstance((Context)ctx).getValue(pk.getType(), (IObjectPK)new ObjectUuidPK(pk), FinUtils.getFinBillSelector()));
        }
        return (FinancingBillInfo)vo;
    }

    public static FinancingBillInfo getFinBillLocalOld(Context ctx, String id) throws BOSException, EASBizException {
        BOSUuid pk = BOSUuid.read((String)id);
        IObjectValue vo = DynamicObjectFactory.getLocalInstance((Context)ctx).getValue(pk.getType(), (IObjectPK)new ObjectUuidPK(pk), FinUtils.getFinBillSelector());
        return vo instanceof FinancingBillInfo ? (FinancingBillInfo)vo : null;
    }

    public static void initCurrencyComboBox(KDComboBox comboCurrency) throws EASBizException, BOSException {
        FinUtils.initCurrencyComboBox(comboCurrency, false, null);
    }

    public static void initCurrencyComboBox(KDComboBox comboBoxCurrency, CurrencyCollection currencyColl) throws EASBizException, BOSException {
        FinUtils.initCurrencyComboBox(comboBoxCurrency, currencyColl, false, null);
    }

    public static void initCurrencyComboBox(KDComboBox comboCurrency, String oprtState) throws EASBizException, BOSException {
        FinUtils.initCurrencyComboBox(comboCurrency, false, oprtState);
    }

    public static void initCurrencyComboBox(KDComboBox comboBoxCurrency, CurrencyCollection currencyColl, String oprtState) throws EASBizException, BOSException {
        FinUtils.initCurrencyComboBox(comboBoxCurrency, currencyColl, false);
    }

    public static void initCurrencyComboBox(KDComboBox comboCurrency, CurrencyCollection currencyColl, boolean isSelBaseCurr, String oprtState) throws EASBizException, BOSException {
        int i;
        ActionListener[] l = comboCurrency.getActionListeners();
        int n = l.length;
        for (int i2 = 0; i2 < n; ++i2) {
            comboCurrency.removeActionListener(l[i2]);
        }
        ItemListener[] itemListener = comboCurrency.getItemListeners();
        int n2 = itemListener.length;
        for (i = 0; i < n2; ++i) {
            comboCurrency.removeItemListener(itemListener[i]);
        }
        FMClientHelper.initComboCurrency((KDComboBox)comboCurrency, (CurrencyCollection)currencyColl, (boolean)isSelBaseCurr, (String)oprtState);
        n2 = l.length;
        for (i = 0; i < n2; ++i) {
            comboCurrency.addActionListener(l[i]);
            comboCurrency.addItemListener(itemListener[i]);
        }
        n2 = itemListener.length;
        for (i = 0; i < n2; ++i) {
            comboCurrency.addItemListener(itemListener[i]);
        }
    }

    public static void initCurrencyComboBox(KDComboBox comboCurrency, boolean isSelBaseCurr, String oprtState) throws EASBizException, BOSException {
        int i;
        ActionListener[] l = comboCurrency.getActionListeners();
        int n = l.length;
        for (int i2 = 0; i2 < n; ++i2) {
            comboCurrency.removeActionListener(l[i2]);
        }
        ItemListener[] itemListener = comboCurrency.getItemListeners();
        int n2 = itemListener.length;
        for (i = 0; i < n2; ++i) {
            comboCurrency.removeItemListener(itemListener[i]);
        }
        FMClientHelper.initComboCurrency((KDComboBox)comboCurrency, (boolean)isSelBaseCurr, (String)oprtState);
        n2 = l.length;
        for (i = 0; i < n2; ++i) {
            comboCurrency.addActionListener(l[i]);
            comboCurrency.addItemListener(itemListener[i]);
        }
        n2 = itemListener.length;
        for (i = 0; i < n2; ++i) {
            comboCurrency.addItemListener(itemListener[i]);
        }
    }

    public static void initCurrencyComboBox(KDComboBox comboCurrency, CurrencyCollection currencyColl, boolean isSelBaseCurr) throws EASBizException, BOSException {
        int i;
        ActionListener[] l = comboCurrency.getActionListeners();
        int n = l.length;
        for (int i2 = 0; i2 < n; ++i2) {
            comboCurrency.removeActionListener(l[i2]);
        }
        ItemListener[] itemListener = comboCurrency.getItemListeners();
        int n2 = itemListener.length;
        for (i = 0; i < n2; ++i) {
            comboCurrency.removeItemListener(itemListener[i]);
        }
        FMClientHelper.initComboCurrency((KDComboBox)comboCurrency, (CurrencyCollection)currencyColl, (boolean)isSelBaseCurr);
        n2 = l.length;
        for (i = 0; i < n2; ++i) {
            comboCurrency.addActionListener(l[i]);
            comboCurrency.addItemListener(itemListener[i]);
        }
        n2 = itemListener.length;
        for (i = 0; i < n2; ++i) {
            comboCurrency.addItemListener(itemListener[i]);
        }
    }

    public static void initCurrencyComboBox(KDComboBox comboCurrency, boolean isSelBaseCurr) throws EASBizException, BOSException {
        int i;
        ActionListener[] l = comboCurrency.getActionListeners();
        int n = l.length;
        for (int i2 = 0; i2 < n; ++i2) {
            comboCurrency.removeActionListener(l[i2]);
        }
        ItemListener[] itemListener = comboCurrency.getItemListeners();
        int n2 = itemListener.length;
        for (i = 0; i < n2; ++i) {
            comboCurrency.removeItemListener(itemListener[i]);
        }
        FMClientHelper.initComboCurrency((KDComboBox)comboCurrency, (boolean)isSelBaseCurr);
        n2 = l.length;
        for (i = 0; i < n2; ++i) {
            comboCurrency.addActionListener(l[i]);
            comboCurrency.addItemListener(itemListener[i]);
        }
        n2 = itemListener.length;
        for (i = 0; i < n2; ++i) {
            comboCurrency.addItemListener(itemListener[i]);
        }
    }

    public static void initFinProductComboBox(KDComboBox comboBox, FinancingBillTypeEnum finBillType) throws BOSException {
        int i;
        EntityViewInfo evi = new EntityViewInfo();
        evi.getSelector().add(new SelectorItemInfo("*"));
        evi.getSelector().add(new SelectorItemInfo("FinancingSource.id"));
        evi.getSelector().add(new SelectorItemInfo("FinancingSource.number"));
        evi.getSelector().add(new SelectorItemInfo("FinancingSource.name"));
        evi.getSelector().add(new SelectorItemInfo("NoteType.id"));
        evi.getSelector().add(new SelectorItemInfo("NoteType.number"));
        evi.getSelector().add(new SelectorItemInfo("NoteType.name"));
        evi.setFilter(new FilterInfo());
        evi.getFilter().getFilterItems().add(new FilterItemInfo("BillType", (Object)finBillType));
        FinancingProductsCollection finProCollection = FinancingProductsFactory.getRemoteInstance().getFinancingProductsCollection(evi);
        ActionListener[] l = comboBox.getActionListeners();
        int n = l.length;
        for (int i2 = 0; i2 < n; ++i2) {
            comboBox.removeActionListener(l[i2]);
        }
        ItemListener[] itemListener = comboBox.getItemListeners();
        int n2 = itemListener.length;
        for (i = 0; i < n2; ++i) {
            comboBox.removeItemListener(itemListener[i]);
        }
        comboBox.removeAllItems();
        comboBox.addItems(finProCollection.toArray());
        n2 = l.length;
        for (i = 0; i < n2; ++i) {
            comboBox.addActionListener(l[i]);
        }
        n2 = itemListener.length;
        for (i = 0; i < n2; ++i) {
            comboBox.addItemListener(itemListener[i]);
        }
    }

    public static EntityViewInfo getInstitutionF7Filter(boolean isBank) {
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(new FilterInfo());
        evi.getFilter().getFilterItems().add(new FilterItemInfo("isBank", (Object)(isBank ? Constants.TRUE : Constants.FALSE)));
        return evi;
    }

    public static void initBankTree(IUIObject filterUI, KDBizPromptBox bank, Boolean isBank) throws Exception {
        FinUtils.initBankTree(filterUI, bank, isBank, false);
    }

    public static void initBankTree(IUIObject filterUI, KDBizPromptBox bank, Boolean isBank, boolean isOnlyIncludeUsed) throws Exception {
        FilterInfo filter = new FilterInfo();
        if (isBank != null) {
            filter.getFilterItems().add(new FilterItemInfo("isBank", (Object)isBank));
        }
        filter.getFilterItems().add(new FilterItemInfo("isLeaf", (Object)Boolean.TRUE));
        if (isOnlyIncludeUsed) {
            filter.getFilterItems().add(new FilterItemInfo("deletedStatus", (Object)new Integer(1)));
        }
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        bank.setEntityViewInfo(evi);
        bank.setDisplayFormat("$number$ $name$");
        bank.setCommitFormat("$number$");
        bank.setEditFormat("$number$");
        bank.setEditable(true);
        bank.setQueryInfo("com.kingdee.eas.basedata.assistant.app.F7BankQuery");
        BankF7Selector arg0 = new BankF7Selector(filterUI, bank);
        if (isBank != null) {
            arg0.setBank(isBank);
        }
        bank.setSelector((KDPromptSelector)arg0);
    }

    public static void initOppAccountView(KDBizPromptBox f7OppAccountView, CompanyOrgUnitInfo curCompany) throws Exception {
        f7OppAccountView.setQueryInfo("com.kingdee.eas.basedata.master.account.app.F7AccountViewQuery");
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        String controlUnitId = curCompany.getCU().getId().toString();
        filterInfo.getFilterItems().add(new FilterItemInfo("accountTableID.id", (Object)curCompany.getAccountTable().getId().toString()));
        filterInfo.getFilterItems().add(new FilterItemInfo("CompanyID.id", (Object)controlUnitId));
        f7OppAccountView.setDisplayFormat("$number$ $name$");
        f7OppAccountView.setCommitFormat("$number$");
        f7OppAccountView.setEditFormat("$number$");
        evi.setFilter(filterInfo);
        f7OppAccountView.setEntityViewInfo(evi);
    }

    public static EntityViewInfo getPrmtGroupF7Filter() {
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(new FilterInfo());
        evi.getFilter().getFilterItems().add(new FilterItemInfo("isLeaf", (Object)new Boolean(true)));
        return evi;
    }

    public static EntityViewInfo getBizUnitCompanyFilter() {
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(new FilterInfo());
        view.getFilter().appendFilterItem("isBizUnit", (Object)Boolean.TRUE);
        return view;
    }

    public static EntityViewInfo getCreditLimitF7FilterZsd(Object creditor, String companyId, boolean isRelBank, String proFinID) throws EASBizException, BOSException {
        EntityViewInfo eviprmtCreditLimit = new EntityViewInfo();
        eviprmtCreditLimit.setFilter(new FilterInfo());
        eviprmtCreditLimit.getFilter().getFilterItems().add(new FilterItemInfo("IsClosed", (Object)Boolean.TRUE, CompareType.NOTEQUALS));
        if (creditor instanceof BankInfo) {
            if (isRelBank) {
                eviprmtCreditLimit.getFilter().getFilterItems().add(new FilterItemInfo("CreditInstitution.Id", (Object)AccessHelper.getId((Object)creditor)));
            }
            eviprmtCreditLimit.getFilter().getFilterItems().add(new FilterItemInfo("creditCompany.Id", null));
        } else {
            eviprmtCreditLimit.getFilter().getFilterItems().add(new FilterItemInfo("creditCompany.Id", (Object)AccessHelper.getId((Object)creditor)));
            eviprmtCreditLimit.getFilter().getFilterItems().add(new FilterItemInfo("CreditInstitution.Id", null));
        }
        Set companySet = CreditLimitFactory.getRemoteInstance().getPerCompanyIdSet(companyId);
        eviprmtCreditLimit.getFilter().getFilterItems().add(new FilterItemInfo("entrys.ShareOrg.id", (Object)companySet, CompareType.INCLUDE));
        eviprmtCreditLimit.getFilter().getFilterItems().add(new FilterItemInfo("ShareType", (Object)new Integer(1)));
        eviprmtCreditLimit.getFilter().getFilterItems().add(new FilterItemInfo("entrys.ShareOrg.id", (Object)companyId));
        eviprmtCreditLimit.getFilter().getFilterItems().add(new FilterItemInfo("ShareType", (Object)new Integer(ShareTypeEnum.PRIVATE.getValue())));
        eviprmtCreditLimit.getFilter().getFilterItems().add(new FilterItemInfo("Balance", (Object)SysConstant.BIGZERO, CompareType.GREATER));
        eviprmtCreditLimit.getFilter().getFilterItems().add(new FilterItemInfo("ShareType", (Object)new Integer(ShareTypeEnum.SHARE.getValue())));
        eviprmtCreditLimit.getFilter().getFilterItems().add(new FilterItemInfo("Balance", (Object)SysConstant.BIGZERO, CompareType.GREATER));
        eviprmtCreditLimit.getFilter().getFilterItems().add(new FilterItemInfo("ShareType", (Object)new Integer(ShareTypeEnum.ASSIGN.getValue())));
        eviprmtCreditLimit.getFilter().getFilterItems().add(new FilterItemInfo("Balance", (Object)SysConstant.BIGZERO, CompareType.GREATER));
        String mask = "";
        if (proFinID == null) {
            mask = isRelBank ? "#0 and #1 and #2 and ((#3 and #4) or #5) and ((#6 and #7) or (#8 and #9)or(#10 and #11))" : "#0 and #1 and ((#2 and #3) or #4) and ((#5 and #6) or (#7 and #8)or(#9 and #10))";
        } else {
            eviprmtCreditLimit.getFilter().getFilterItems().add(new FilterItemInfo("CreditUsage.finacingProduct.id", (Object)proFinID));
            eviprmtCreditLimit.getFilter().getFilterItems().add(new FilterItemInfo("CreditUsage.finacingProduct.id", null));
            eviprmtCreditLimit.getFilter().getFilterItems().add(new FilterItemInfo("CreditUsage.colligateCredit", (Object)Boolean.TRUE));
            mask = isRelBank ? "#0 and #1 and #2 and ((#3 and #4) or #5) and ((#6 and #7) or (#8 and #9)or(#10 and #11)) and (#12 or #13 or #14)" : "#0 and #1 and ((#2 and #3) or #4) and ((#5 and #6) or (#7 and #8)or(#9 and #10)) and (#11 or #12 or #13)";
        }
        boolean isMustAudit = ContextHelperFactory.getRemoteInstance().getBooleanParam("FIN014", (IObjectPK)new ObjectUuidPK(companyId));
        if (isMustAudit) {
            FilterInfo extFilterInfo = new FilterInfo();
            extFilterInfo.getFilterItems().add(new FilterItemInfo("billStatus", (Object)new Integer(1), CompareType.EQUALS));
            try {
                eviprmtCreditLimit.getFilter().mergeFilter(extFilterInfo, "AND");
                int maskNumberForBillStatus = proFinID == null ? 11 : 14;
                mask = mask + " and #" + (maskNumberForBillStatus += isRelBank ? 1 : 0);
            }
            catch (BOSException e) {
                logger.error((Object)e);
            }
        }
        eviprmtCreditLimit.getFilter().setMaskString(mask);
        return eviprmtCreditLimit;
    }

    public static EntityViewInfo getCreditLimitF7Filter(BankInfo bank, CompanyOrgUnitInfo company) throws BOSException, EASBizException {
        String bankId = bank.getId().toString();
        String companyId = company.getId().toString();
        return FinUtils.getCreditLimitF7Filter(bankId, companyId);
    }

    public static EntityViewInfo getCreditLimitF7FilterOld(Object creditor, String companyId, boolean isRelBank, String proFinID) throws EASBizException, BOSException {
        EntityViewInfo eviprmtCreditLimit = new EntityViewInfo();
        eviprmtCreditLimit.setFilter(new FilterInfo());
        eviprmtCreditLimit.getFilter().getFilterItems().add(new FilterItemInfo("IsClosed", (Object)Boolean.TRUE, CompareType.NOTEQUALS));
        if (creditor instanceof BankInfo) {
            if (isRelBank) {
                eviprmtCreditLimit.getFilter().getFilterItems().add(new FilterItemInfo("CreditInstitution.Id", (Object)AccessHelper.getId((Object)creditor)));
            }
            eviprmtCreditLimit.getFilter().getFilterItems().add(new FilterItemInfo("creditCompany.Id", null));
        } else {
            eviprmtCreditLimit.getFilter().getFilterItems().add(new FilterItemInfo("creditCompany.Id", (Object)AccessHelper.getId((Object)creditor)));
            eviprmtCreditLimit.getFilter().getFilterItems().add(new FilterItemInfo("CreditInstitution.Id", null));
        }
        Set companySet = CreditLimitFactory.getRemoteInstance().getPerCompanyIdSet(companyId);
        eviprmtCreditLimit.getFilter().getFilterItems().add(new FilterItemInfo("entrys.ShareOrg.id", (Object)companySet, CompareType.INCLUDE));
        eviprmtCreditLimit.getFilter().getFilterItems().add(new FilterItemInfo("ShareType", (Object)new Integer(1)));
        eviprmtCreditLimit.getFilter().getFilterItems().add(new FilterItemInfo("entrys.ShareOrg.id", (Object)companyId));
        eviprmtCreditLimit.getFilter().getFilterItems().add(new FilterItemInfo("ShareType", (Object)new Integer(ShareTypeEnum.PRIVATE.getValue())));
        eviprmtCreditLimit.getFilter().getFilterItems().add(new FilterItemInfo("Balance", (Object)SysConstant.BIGZERO, CompareType.GREATER));
        eviprmtCreditLimit.getFilter().getFilterItems().add(new FilterItemInfo("ShareType", (Object)new Integer(ShareTypeEnum.SHARE.getValue())));
        eviprmtCreditLimit.getFilter().getFilterItems().add(new FilterItemInfo("Balance", (Object)SysConstant.BIGZERO, CompareType.GREATER));
        eviprmtCreditLimit.getFilter().getFilterItems().add(new FilterItemInfo("ShareType", (Object)new Integer(ShareTypeEnum.ASSIGN.getValue())));
        eviprmtCreditLimit.getFilter().getFilterItems().add(new FilterItemInfo("Balance", (Object)SysConstant.BIGZERO, CompareType.GREATER));
        String mask = "";
        if (proFinID == null) {
            mask = isRelBank ? "#0 and #1 and #2 and ((#3 and #4) or #5) and ((#6 and #7) or (#8 and #9)or(#10 and #11))" : "#0 and #1 and ((#2 and #3) or #4) and ((#5 and #6) or (#7 and #8)or(#9 and #10))";
        } else {
            eviprmtCreditLimit.getFilter().getFilterItems().add(new FilterItemInfo("entrys.finPro.id", (Object)proFinID));
            eviprmtCreditLimit.getFilter().getFilterItems().add(new FilterItemInfo("entrys.finPro.id", null));
            eviprmtCreditLimit.getFilter().getFilterItems().add(new FilterItemInfo("CreditUsage.colligateCredit", (Object)Boolean.TRUE));
            mask = isRelBank ? "#0 and #1 and #2 and ((#3 and #4) or #5) and ((#6 and #7) or (#8 and #9)or(#10 and #11)) and (#12 or #13 or #14)" : "#0 and #1 and ((#2 and #3) or #4) and ((#5 and #6) or (#7 and #8) or (#9 and #10)) and (#11 or #12 or #13)";
        }
        boolean isMustAudit = ContextHelperFactory.getRemoteInstance().getBooleanParam("FIN014", (IObjectPK)new ObjectUuidPK(companyId));
        if (isMustAudit) {
            FilterInfo extFilterInfo = new FilterInfo();
            extFilterInfo.getFilterItems().add(new FilterItemInfo("billStatus", (Object)new Integer(1), CompareType.EQUALS));
            try {
                eviprmtCreditLimit.getFilter().mergeFilter(extFilterInfo, "AND");
                int maskNumberForBillStatus = proFinID == null ? 11 : 14;
                mask = mask + " and #" + (maskNumberForBillStatus += isRelBank ? 1 : 0);
            }
            catch (BOSException e) {
                logger.error((Object)e);
            }
        }
        eviprmtCreditLimit.getFilter().setMaskString(mask);
        return eviprmtCreditLimit;
    }

    public static EntityViewInfo getCreditLimitF7Filter(Object creditor, String companyId, boolean isRelBank, String proFinID) throws EASBizException, BOSException {
        int i;
        StringBuffer oql = new StringBuffer("where ");
        oql.append("IsClosed <> 1 ");
        if (((BankInfo)creditor).getRelatedCompany() == null) {
            oql.append(" and ((IsBankCredit = 1 or IsBankCredit =0)");
            if (isRelBank) {
                oql.append(" and CreditInstitution.Id = '" + AccessHelper.getId((Object)creditor) + "' ");
            }
            oql.append(" and creditCompany.Id is null)");
        } else {
            oql.append(" and (IsBankCredit = 2 and CreditInstitution.Id is null ");
            oql.append("and creditCompany.Id = '" + ((BankInfo)creditor).getRelatedCompany().getId().toString() + "')");
        }
        oql.append("and ((ShareType = 3 and CreditUsage.colligateCredit = 1 and balance > 0 and entrys.ShareOrg.id = '" + companyId + "') ");
        oql.append("or (ShareType = 3 and CreditUsage.finacingProduct.id = '" + proFinID + "' and balance > 0 and entrys.ShareOrg.id = '" + companyId + "') ");
        Set companySet = FinUtils.getPerCompanyIdSet(companyId);
        Object[] companyIds = companySet.toArray();
        oql.append("or (ShareType = 1 and CreditUsage.colligateCredit = 1 and balance > 0 and entrys.ShareOrg.id in (");
        for (i = 0; i < companyIds.length; ++i) {
            oql.append("'" + companyIds[i] + "',");
        }
        oql.deleteCharAt(oql.length() - 1);
        oql.append(")) ");
        oql.append("or (ShareType = 1 and CreditUsage.finacingProduct.id = '" + proFinID + "' and balance > 0 and entrys.ShareOrg.id in (");
        for (i = 0; i < companyIds.length; ++i) {
            oql.append("'" + companyIds[i] + "',");
        }
        oql.deleteCharAt(oql.length() - 1);
        oql.append(")) ");
        oql.append("or (ShareType = 2 and CreditUsage.colligateCredit = 1 and entrys.banlance > 0 and entrys.ShareOrg.id = '" + companyId + "' ");
        oql.append("and entrys.controlWay = 1) ");
        oql.append("or (ShareType = 2 and CreditUsage.colligateCredit = 1 and entrys.banlance > 0 and entrys.ShareOrg.id = '" + companyId + "' ");
        oql.append("and entrys.controlWay = 0 and entrys.finPro.id = '" + proFinID + "') ");
        oql.append("or (ShareType = 2 and CreditUsage.finacingProduct.id = '" + proFinID + "' and entrys.banlance > 0 and entrys.ShareOrg.id = '" + companyId + "')) ");
        boolean isMustAudit = ContextHelperFactory.getRemoteInstance().getBooleanParam("FIN014", (IObjectPK)new ObjectUuidPK(companyId));
        if (isMustAudit) {
            oql.append("and billStatus = 1");
        }
        try {
            return new EntityViewInfo(oql.toString());
        }
        catch (Exception e) {
            logger.debug((Object)e);
            return new EntityViewInfo();
        }
    }

    private static Set getPerCompanyIdSet(String companyId) throws BOSException, EASBizException {
        CompanyOrgUnitInfo info = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyId));
        String[] tmpLongNumbers = info.getLongNumber().split("!");
        HashSet<String> longNumbers = new HashSet<String>();
        StringBuffer strBuf = new StringBuffer();
        for (int i = 0; i < tmpLongNumbers.length; ++i) {
            if (i == 0) {
                strBuf.append(tmpLongNumbers[i]);
            } else {
                strBuf.append("!" + tmpLongNumbers[i]);
            }
            longNumbers.add(strBuf.toString());
        }
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        view.setSelector(selector);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("longnumber", longNumbers, CompareType.INCLUDE));
        view.setFilter(filter);
        CompanyOrgUnitCollection coll = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitCollection(view);
        HashSet<String> resultSet = new HashSet<String>();
        for (int i = 0; i < coll.size(); ++i) {
            resultSet.add(coll.get(i).getId().toString());
        }
        return resultSet;
    }

    public static EntityViewInfo getCreditLimitF7Filter(String bankId, String companyId) throws EASBizException, BOSException {
        EntityViewInfo eviprmtCreditLimit = new EntityViewInfo();
        eviprmtCreditLimit.setFilter(new FilterInfo());
        eviprmtCreditLimit.getFilter().getFilterItems().add(new FilterItemInfo("IsClosed", (Object)new Boolean(true), CompareType.NOTEQUALS));
        eviprmtCreditLimit.getFilter().getFilterItems().add(new FilterItemInfo("CreditInstitution.Id", (Object)bankId));
        Set companySet = CreditLimitFactory.getRemoteInstance().getPerCompanyIdSet(companyId);
        eviprmtCreditLimit.getFilter().getFilterItems().add(new FilterItemInfo("ShareOrg.id", (Object)companySet, CompareType.INCLUDE));
        eviprmtCreditLimit.getFilter().getFilterItems().add(new FilterItemInfo("ShareType", (Object)new Integer(1)));
        eviprmtCreditLimit.getFilter().getFilterItems().add(new FilterItemInfo("ShareOrg.id", (Object)companyId));
        eviprmtCreditLimit.getFilter().getFilterItems().add(new FilterItemInfo("ShareType", (Object)new Integer(ShareTypeEnum.PRIVATE.getValue())));
        eviprmtCreditLimit.getFilter().getFilterItems().add(new FilterItemInfo("Balance", (Object)SysConstant.BIGZERO, CompareType.GREATER));
        eviprmtCreditLimit.getFilter().getFilterItems().add(new FilterItemInfo("ShareType", (Object)new Integer(ShareTypeEnum.SHARE.getValue())));
        eviprmtCreditLimit.getFilter().getFilterItems().add(new FilterItemInfo("Balance", (Object)SysConstant.BIGZERO, CompareType.GREATER));
        eviprmtCreditLimit.getFilter().getFilterItems().add(new FilterItemInfo("ShareType", (Object)new Integer(ShareTypeEnum.ASSIGN.getValue())));
        eviprmtCreditLimit.getFilter().getFilterItems().add(new FilterItemInfo("Balance", (Object)SysConstant.BIGZERO, CompareType.GREATER));
        eviprmtCreditLimit.getFilter().setMaskString("#0 and #1 and ((#2 and #3) or #4) and ((#5 and #6) or (#7 and #8)or(#9 and #10))");
        return eviprmtCreditLimit;
    }

    public static EntityViewInfo getCreditLimitF7Filter(Object creditor, String companyId) throws EASBizException, BOSException {
        EntityViewInfo eviprmtCreditLimit = new EntityViewInfo();
        eviprmtCreditLimit.setFilter(new FilterInfo());
        eviprmtCreditLimit.getFilter().getFilterItems().add(new FilterItemInfo("IsClosed", (Object)new Boolean(true), CompareType.NOTEQUALS));
        if (creditor instanceof BankInfo) {
            eviprmtCreditLimit.getFilter().getFilterItems().add(new FilterItemInfo("CreditInstitution.Id", (Object)AccessHelper.getId((Object)creditor)));
            eviprmtCreditLimit.getFilter().getFilterItems().add(new FilterItemInfo("creditCompany.Id", null));
        } else {
            eviprmtCreditLimit.getFilter().getFilterItems().add(new FilterItemInfo("creditCompany.Id", (Object)AccessHelper.getId((Object)creditor)));
            eviprmtCreditLimit.getFilter().getFilterItems().add(new FilterItemInfo("CreditInstitution.Id", null));
        }
        Set companySet = CreditLimitFactory.getRemoteInstance().getPerCompanyIdSet(companyId);
        eviprmtCreditLimit.getFilter().getFilterItems().add(new FilterItemInfo("entrys.ShareOrg.id", (Object)companySet, CompareType.INCLUDE));
        eviprmtCreditLimit.getFilter().getFilterItems().add(new FilterItemInfo("ShareType", (Object)new Integer(1)));
        eviprmtCreditLimit.getFilter().getFilterItems().add(new FilterItemInfo("entrys.ShareOrg.id", (Object)companyId));
        eviprmtCreditLimit.getFilter().getFilterItems().add(new FilterItemInfo("ShareType", (Object)new Integer(ShareTypeEnum.PRIVATE.getValue())));
        eviprmtCreditLimit.getFilter().getFilterItems().add(new FilterItemInfo("Balance", (Object)SysConstant.BIGZERO, CompareType.GREATER));
        eviprmtCreditLimit.getFilter().getFilterItems().add(new FilterItemInfo("ShareType", (Object)new Integer(ShareTypeEnum.SHARE.getValue())));
        eviprmtCreditLimit.getFilter().getFilterItems().add(new FilterItemInfo("Balance", (Object)SysConstant.BIGZERO, CompareType.GREATER));
        eviprmtCreditLimit.getFilter().getFilterItems().add(new FilterItemInfo("ShareType", (Object)new Integer(ShareTypeEnum.ASSIGN.getValue())));
        eviprmtCreditLimit.getFilter().getFilterItems().add(new FilterItemInfo("Balance", (Object)SysConstant.BIGZERO, CompareType.GREATER));
        eviprmtCreditLimit.getFilter().setMaskString("#0 and #1 and #2 and ((#3 and #4) or #5) and ((#6 and #7) or (#8 and #9)or(#10 and #11))");
        return eviprmtCreditLimit;
    }

    public static EntityViewInfo getCreditLimitNoBankF7Filter(String companyId) throws EASBizException, BOSException {
        EntityViewInfo eviprmtCreditLimit = new EntityViewInfo();
        eviprmtCreditLimit.setFilter(new FilterInfo());
        eviprmtCreditLimit.getFilter().getFilterItems().add(new FilterItemInfo("IsClosed", (Object)new Boolean(true), CompareType.NOTEQUALS));
        Set companySet = CreditLimitFactory.getRemoteInstance().getPerCompanyIdSet(companyId);
        eviprmtCreditLimit.getFilter().getFilterItems().add(new FilterItemInfo("entrys.ShareOrg.id", (Object)companySet, CompareType.INCLUDE));
        eviprmtCreditLimit.getFilter().getFilterItems().add(new FilterItemInfo("ShareType", (Object)new Integer(1)));
        eviprmtCreditLimit.getFilter().getFilterItems().add(new FilterItemInfo("entrys.ShareOrg.id", (Object)companyId));
        eviprmtCreditLimit.getFilter().getFilterItems().add(new FilterItemInfo("ShareType", (Object)new Integer(ShareTypeEnum.PRIVATE.getValue())));
        eviprmtCreditLimit.getFilter().getFilterItems().add(new FilterItemInfo("Balance", (Object)SysConstant.BIGZERO, CompareType.GREATER));
        eviprmtCreditLimit.getFilter().getFilterItems().add(new FilterItemInfo("ShareType", (Object)new Integer(ShareTypeEnum.SHARE.getValue())));
        eviprmtCreditLimit.getFilter().getFilterItems().add(new FilterItemInfo("Balance", (Object)SysConstant.BIGZERO, CompareType.GREATER));
        eviprmtCreditLimit.getFilter().getFilterItems().add(new FilterItemInfo("ShareType", (Object)new Integer(ShareTypeEnum.ASSIGN.getValue())));
        eviprmtCreditLimit.getFilter().getFilterItems().add(new FilterItemInfo("Balance", (Object)SysConstant.BIGZERO, CompareType.GREATER));
        eviprmtCreditLimit.getFilter().setMaskString("#0 and ((#1 and #2) or #3) and ((#4 and #5) or (#6 and #7) or (#8 and #9))");
        return eviprmtCreditLimit;
    }

    public static EntityViewInfo getCreditLimitEntityView() {
        EntityViewInfo eviprmtCreditLimit = new EntityViewInfo();
        eviprmtCreditLimit.getSelector().add(new SelectorItemInfo("*"));
        eviprmtCreditLimit.getSelector().add(new SelectorItemInfo("CreditUsage.*"));
        eviprmtCreditLimit.getSelector().add(new SelectorItemInfo("Currency.*"));
        eviprmtCreditLimit.getSelector().add(new SelectorItemInfo("GuaranteeType.*"));
        eviprmtCreditLimit.getSelector().add(new SelectorItemInfo("CreditInstitution.*"));
        eviprmtCreditLimit.getSelector().add(new SelectorItemInfo("entrys.*"));
        eviprmtCreditLimit.getSelector().add(new SelectorItemInfo("entrys.ShareOrg.*"));
        eviprmtCreditLimit.getSelector().add(new SelectorItemInfo("entrys.finPro.*"));
        return eviprmtCreditLimit;
    }

    public static void setEditable(JComponent[] components, boolean editable) {
        int n = components.length;
        for (int i = 0; i < n; ++i) {
            FMClientHelper.setEditable((JComponent)components[i], (boolean)editable);
        }
    }

    public static CreditLimitEntryInfo getOrgFinanciongProductEntry(Context ctx, CreditLimitInfo creditLimit, BOSUuid companyId, FinancingBillInfo financingBillInfo) throws BOSException {
        EntityViewInfo evi = new EntityViewInfo();
        evi.getSelector().add("*");
        evi.getSelector().add("ShareOrg.*");
        evi.setFilter(new FilterInfo());
        evi.getFilter().getFilterItems().add(new FilterItemInfo("Parent.id", (Object)creditLimit.getId()));
        evi.getFilter().getFilterItems().add(new FilterItemInfo("finPro.id", (Object)financingBillInfo.getType()));
        evi.getFilter().getFilterItems().add(new FilterItemInfo("finPro.id", null));
        evi.getFilter().getFilterItems().add(new FilterItemInfo("ShareOrg.id", (Object)companyId));
        String mask = "#0 and (#1 or #2) and #3 ";
        evi.getFilter().setMaskString(mask);
        CreditLimitEntryCollection cleCollection = CreditLimitEntryFactory.getLocalInstance(ctx).getCreditLimitEntryCollection(evi);
        CreditLimitEntryInfo enyInfo = null;
        int size = cleCollection.size();
        if (size > 0) {
            for (int i = 0; !(i >= size || (enyInfo = cleCollection.get(i)).getFinPro() != null && enyInfo.getFinPro().getId().equals((Object)financingBillInfo.getType().getId())); ++i) {
            }
        } else if (size == 1) {
            enyInfo = cleCollection.get(0);
        }
        throw new BOSException("cannot find shareorgentry of" + companyId);
    }

    public static CreditLimitEntryInfo getOrgEntry(CreditLimitInfo creditLimit, BOSUuid companyId) throws BOSException {
        EntityViewInfo evi = new EntityViewInfo();
        evi.getSelector().add("*");
        evi.getSelector().add("ShareOrg.*");
        evi.setFilter(new FilterInfo());
        evi.getFilter().getFilterItems().add(new FilterItemInfo("Parent.id", (Object)creditLimit.getId()));
        CreditLimitEntryCollection cleCollection = CreditLimitEntryFactory.getRemoteInstance().getCreditLimitEntryCollection(evi);
        int n = cleCollection.size();
        for (int i = 0; i < n; ++i) {
            if (!cleCollection.get(i).getShareOrg().getId().equals((Object)companyId)) continue;
            return cleCollection.get(i);
        }
        throw new BOSException("cannot find shareorgentry of" + companyId);
    }

    public static CreditLimitEntryInfo getOrgEntry(Context ctx, CreditLimitInfo creditLimit, BOSUuid companyId) throws BOSException {
        EntityViewInfo evi = new EntityViewInfo();
        evi.getSelector().add("*");
        evi.getSelector().add("ShareOrg.*");
        evi.setFilter(new FilterInfo());
        evi.getFilter().getFilterItems().add(new FilterItemInfo("Parent.id", (Object)creditLimit.getId()));
        CreditLimitEntryCollection cleCollection = CreditLimitEntryFactory.getLocalInstance(ctx).getCreditLimitEntryCollection(evi);
        int n = cleCollection.size();
        for (int i = 0; i < n; ++i) {
            if (!cleCollection.get(i).getShareOrg().getId().equals((Object)companyId)) continue;
            return cleCollection.get(i);
        }
        return null;
    }

    public static BigDecimal getCreditRemainAmount(Context ctx, CreditLimitInfo creditLimitInfo, CompanyOrgUnitInfo company) throws BOSException {
        if (!EmptyUtil.isEmpty((Object)((Object)creditLimitInfo.getShareType())) && (creditLimitInfo.getShareType().equals((Object)ShareTypeEnum.SHARE) || creditLimitInfo.getShareType().equals((Object)ShareTypeEnum.PRIVATE))) {
            return creditLimitInfo.getBalance();
        }
        CreditLimitEntryCollection entrys = FinUtils.getOrgEntryByCompany(ctx, creditLimitInfo, company.getId());
        BigDecimal amt = new BigDecimal("0");
        int n = entrys.size();
        for (int i = 0; i < n; ++i) {
            CreditLimitEntryInfo entry = entrys.get(i);
            amt = amt.add(entry.getBanlance());
        }
        return amt;
    }

    public static CreditLimitEntryCollection getOrgEntryByCompany(Context ctx, CreditLimitInfo creditLimit, BOSUuid companyId) throws BOSException {
        EntityViewInfo evi = new EntityViewInfo();
        evi.getSelector().add("*");
        evi.getSelector().add("ShareOrg.*");
        evi.setFilter(new FilterInfo());
        evi.getFilter().getFilterItems().add(new FilterItemInfo("Parent.id", (Object)creditLimit.getId()));
        ICreditLimitEntry ile = null;
        ile = ctx != null ? CreditLimitEntryFactory.getLocalInstance(ctx) : CreditLimitEntryFactory.getRemoteInstance();
        CreditLimitEntryCollection cleCollection = ile.getCreditLimitEntryCollection(evi);
        CreditLimitEntryCollection ret = new CreditLimitEntryCollection();
        int n = cleCollection.size();
        for (int i = 0; i < n; ++i) {
            if (!cleCollection.get(i).getShareOrg().getId().equals((Object)companyId)) continue;
            ret.add(cleCollection.get(i));
        }
        return ret;
    }

    public static void initNewFinBill(FinancingBillInfo objectValue, KDTextField txtNumber) {
        if (!(objectValue instanceof PayableBillInfo)) {
            objectValue.setId(BOSUuid.create((BOSObjectType)objectValue.getBOSType()));
        }
        objectValue.setCreator(SysContext.getSysContext().getCurrentUserInfo());
        objectValue.setBizDate(DateUtil.getDayBegin());
        objectValue.setCompany(SysContext.getSysContext().getCurrentFIUnit());
        objectValue.setCurrency(SysContext.getSysContext().getCurrentFIUnit().getBaseCurrency());
        objectValue.setIssueDate(DateUtil.getDayBegin());
        objectValue.setExpiredDate(DateUtil.getDayBegin());
        objectValue.setHorizon(SysConstant.BIGZERO);
        objectValue.setLocalCurExRate(Constants.ONE);
        objectValue.setCreditCurExRate(Constants.ZERO);
        objectValue.setUseAssureBill(false);
    }

    public static BigDecimal getHorizon(Date beginDate, Date endDate) {
        Calendar c1 = Calendar.getInstance();
        c1.setTime(beginDate);
        BigDecimal year1 = new BigDecimal(String.valueOf(c1.get(1)));
        BigDecimal month1 = new BigDecimal(String.valueOf(c1.get(2)));
        BigDecimal day1 = new BigDecimal(String.valueOf(c1.get(5)));
        Calendar c2 = Calendar.getInstance();
        c2.setTime(endDate);
        BigDecimal year2 = new BigDecimal(String.valueOf(c2.get(1)));
        BigDecimal month2 = new BigDecimal(String.valueOf(c2.get(2)));
        BigDecimal day2 = new BigDecimal(String.valueOf(c2.get(5)));
        BigDecimal horizon = new BigDecimal(String.valueOf(0.0));
        if (year2.compareTo(year1) == 1) {
            if (month2.compareTo(month1) == 1) {
                horizon = day2.compareTo(day1) == 1 || day2.compareTo(day1) == 0 ? year2.subtract(year1).multiply(new BigDecimal(String.valueOf(12))).add(month2).subtract(month1).add(day2.subtract(day1).divide(new BigDecimal(String.valueOf(30.0)), 1, 2)) : year2.subtract(year1).multiply(new BigDecimal(String.valueOf(12))).add(month2).subtract(month1);
            }
            if (month2.compareTo(month1) == 0) {
                horizon = day2.compareTo(day1) == 1 || day2.compareTo(day1) == 0 ? year2.subtract(year1).multiply(new BigDecimal(String.valueOf(12))).add(month2).subtract(month1).add(day2.subtract(day1).divide(new BigDecimal(String.valueOf(30.0)), 1, 2)) : year2.subtract(year1).multiply(new BigDecimal(String.valueOf(12))).add(month2).subtract(month1).subtract(new BigDecimal(String.valueOf(1)));
            }
            if (month2.compareTo(month1) == -1) {
                horizon = year2.subtract(year1).multiply(new BigDecimal(String.valueOf(12))).add(month2).subtract(month1);
            }
        }
        if (year2.compareTo(year1) == 0) {
            if (month2.compareTo(month1) == 1) {
                horizon = day2.compareTo(day1) == 1 || day2.compareTo(day1) == 0 ? month2.subtract(month1).add(day2.subtract(day1).divide(new BigDecimal(String.valueOf(30.0)), 1, 2)) : month2.subtract(month1);
            }
            if (month2.compareTo(month1) == 0) {
                horizon = day2.compareTo(day1) == 1 || day2.compareTo(day1) == 0 ? (month2.compareTo(new BigDecimal(String.valueOf(1))) == 0 ? (DateTimeUtils.isLeap((int)month2.intValue()) ? month2.subtract(month1).add(day2.subtract(day1).divide(new BigDecimal(String.valueOf(29.0)), 1, 2)) : month2.subtract(month1).add(day2.subtract(day1).divide(new BigDecimal(String.valueOf(28.0)), 1, 2))) : month2.subtract(month1).add(day2.subtract(day1).divide(new BigDecimal(String.valueOf(30.0)), 1, 2))) : day2.subtract(day1).divide(new BigDecimal(String.valueOf(30.0)), 1, 2);
            }
            if (month2.compareTo(month1) == -1) {
                horizon = new BigDecimal(String.valueOf(0.0));
            }
        }
        if (year2.compareTo(year1) == -1) {
            horizon = new BigDecimal(String.valueOf(0.0));
        }
        return horizon;
    }

    public static BigDecimal getHorizon(KDDatePicker dpBegin, KDDatePicker dpEnd) {
        Date beginDate = DateTimeUtils.truncateDate((Date)dpBegin.getSqlDate());
        Date endDate = DateTimeUtils.truncateDate((Date)dpEnd.getSqlDate());
        return FinUtils.getHorizon(beginDate, endDate);
    }

    public static String[] f7DataToIdArray(Object data) {
        if (data == null) {
            return new String[0];
        }
        if (data instanceof DataBaseInfo) {
            DataBaseInfo dbInfo = (DataBaseInfo)data;
            return new String[]{dbInfo.getId().toString()};
        }
        Object[] objs = (Object[])data;
        String[] rets = new String[objs.length];
        int n = objs.length;
        for (int i = 0; i < n; ++i) {
            DataBaseInfo dbInfo = (DataBaseInfo)objs[i];
            rets[i] = dbInfo.getId().toString();
        }
        return rets;
    }

    public static FinancingProductsInfo getAllNeedFinProductField(BOSUuid finProductId) throws BOSException, EASBizException {
        SelectorItemCollection selectors = new SelectorItemCollection();
        selectors.add(new SelectorItemInfo("*"));
        selectors.add(new SelectorItemInfo("FinancingSource.*"));
        FinancingProductsInfo info = null;
        if (finProductId != null) {
            info = FinancingProductsFactory.getRemoteInstance().getFinancingProductsInfo((IObjectPK)new ObjectUuidPK(finProductId), selectors);
        }
        return info;
    }

    public static void setSysCU(IObjectValue ov) {
        ObjectBaseInfo info = (ObjectBaseInfo)ov;
        CtrlUnitInfo cu = new CtrlUnitInfo();
        cu.setId(BOSUuid.read((String)"11111111-1111-1111-1111-111111111111CCE7AED4"));
        info.setCU(cu);
    }

    public static void setFinProductF7(KDBizPromptBox bizBox, FinancingBillTypeEnum billType) {
        bizBox.setEnabledMultiSelection(true);
        EntityViewInfo evi = bizBox.getEntityViewInfo();
        if (evi == null) {
            evi = new EntityViewInfo();
        }
        evi.getSelector().add(new SelectorItemInfo("id"));
        evi.getSelector().add(new SelectorItemInfo("number"));
        evi.getSelector().add(new SelectorItemInfo("name"));
        evi.getSelector().add(new SelectorItemInfo("FinancingSource.id"));
        evi.getSelector().add(new SelectorItemInfo("FinancingSource.name"));
        evi.getSelector().add(new SelectorItemInfo("FinancingSource.number"));
        evi.getSelector().add(new SelectorItemInfo("NoteType.id"));
        evi.getSelector().add(new SelectorItemInfo("NoteType.name"));
        evi.getSelector().add(new SelectorItemInfo("NoteType.number"));
        evi.getSelector().add(new SelectorItemInfo("BillType"));
        evi.setFilter(new FilterInfo());
        evi.getFilter().getFilterItems().add(new FilterItemInfo("BillType", (Object)new Integer(billType.getValue())));
        bizBox.setEntityViewInfo(evi);
    }

    public static BigDecimal getApplyAmount(Context ctx, FinancingBillInfo finBill) throws FinBizException, EASBizException, BOSException {
        CurrencyInfo creditLimitCurrency = finBill.getCreditLimit().getCurrency();
        if (creditLimitCurrency == null) {
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("Currency.id"));
            ObjectUuidPK creditPK = new ObjectUuidPK(finBill.getCreditLimit().getId());
            CreditLimitInfo creditLimit = CreditLimitFactory.getLocalInstance(ctx).getCreditLimitInfo((IObjectPK)creditPK, sic);
            creditLimitCurrency = creditLimit.getCurrency();
        }
        BigDecimal exRate = Constants.ONE;
        if (finBill.getCurrency().getId().equals((Object)creditLimitCurrency.getId())) {
            exRate = Constants.ONE;
        } else {
            ExchangeRateInfo exRateInfo = FinUtils.getCurrencyExRateInfo(ctx, ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany(), finBill.getCurrency(), creditLimitCurrency, finBill.getBizDate());
            if (exRateInfo == null) {
                return new BigDecimal(String.valueOf(1));
            }
            exRate = exRateInfo.getConvertMode().equals((Object)ConvertModeEnum.INDIRECTEXCHANGERATE) ? Constants.ONE.divide(exRateInfo.getConvertRate(), exRateInfo.getPrecision(), 4) : exRateInfo.getConvertRate();
        }
        if (exRate == null || exRate.signum() <= 0) {
            throw new FinBizException(FinBizException.EXCHANGERATENULLORBAD);
        }
        return finBill.getCreditCurExRate().multiply(finBill.getBalance());
    }

    public static void addBotRelation(Context ctx, String srcBillId, String destBillId) throws BOSException {
        IBOTRelation botRelation = null;
        botRelation = ctx == null ? BOTRelationFactory.getRemoteInstance() : BOTRelationFactory.getLocalInstance((Context)ctx);
        BOTRelationInfo botInfo = new BOTRelationInfo();
        botInfo.setSrcObjectID(srcBillId);
        botInfo.setDestObjectID(destBillId);
        botInfo.setSrcEntityID(BOSUuid.read((String)srcBillId).getType().toString());
        botInfo.setDestEntityID(BOSUuid.read((String)destBillId).getType().toString());
        botInfo.setOperatorID("unkown");
        botInfo.setIsEffected(true);
        botInfo.setType(0);
        botInfo.setDate(new Date());
        botRelation.addnew(botInfo);
    }

    public static FilterInfo getAssureBillFilter4FinBillEditUI() {
        CompanyOrgUnitInfo company = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        return FinUtils.getAssureBillFilter4FinBillEditUI(company);
    }

    public static FilterInfo getAssureBillFilter4FinBillEditUI(CompanyOrgUnitInfo company) {
        String companyName_l1 = company.getName(new Locale("L1"));
        String companyName_l2 = company.getName(new Locale("L2"));
        String companyName_l3 = company.getName(new Locale("L3"));
        FilterInfo filterInfo = new FilterInfo();
        FilterItemCollection filterItems = filterInfo.getFilterItems();
        filterItems.add(new FilterItemInfo("canceled", (Object)new Integer(0)));
        filterItems.add(new FilterItemInfo("state", (Object)new Integer(2)));
        filterItems.add(new FilterItemInfo("assuredCompany", (Object)companyName_l1));
        filterItems.add(new FilterItemInfo("assuredCompany", (Object)companyName_l2));
        filterItems.add(new FilterItemInfo("assuredCompany", (Object)companyName_l3));
        filterInfo.setMaskString("#0 and #1 and(#2 or #3 or #4)");
        return filterInfo;
    }

    public static FilterInfo getAssureBillFilter4LoanEditUI(CompanyOrgUnitInfo company) {
        String companyName_l1 = company.getName(new Locale("L1"));
        String companyName_l2 = company.getName(new Locale("L2"));
        String companyName_l3 = company.getName(new Locale("L3"));
        FilterInfo filterInfo = new FilterInfo();
        FilterItemCollection filterItems = filterInfo.getFilterItems();
        filterItems.add(new FilterItemInfo("canceled", (Object)new Integer(0)));
        filterItems.add(new FilterItemInfo("state", (Object)new Integer(2)));
        filterItems.add(new FilterItemInfo("assuredCompany", (Object)companyName_l1));
        filterItems.add(new FilterItemInfo("assuredCompany", (Object)companyName_l2));
        filterItems.add(new FilterItemInfo("assuredCompany", (Object)companyName_l3));
        filterItems.add(new FilterItemInfo("assureType.CREDITASSURE", (Object)0));
        filterInfo.setMaskString("#0 and #1 and(#2 or #3 or #4) and #5");
        return filterInfo;
    }

    public static FilterInfo getCreditlimitAssureBillFilter4FinBillEditUI() {
        CompanyOrgUnitInfo company = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        return FinUtils.getCreditlimitAssureBillFilter4FinBillEditUI(company);
    }

    public static FilterInfo getCreditlimitAssureBillFilter4FinBillEditUI(CompanyOrgUnitInfo company) {
        String companyName_l1 = company.getName(new Locale("L1"));
        String companyName_l2 = company.getName(new Locale("L2"));
        String companyName_l3 = company.getName(new Locale("L3"));
        FilterInfo filterInfo = new FilterInfo();
        FilterItemCollection filterItems = filterInfo.getFilterItems();
        filterItems.add(new FilterItemInfo("canceled", (Object)new Integer(0)));
        filterItems.add(new FilterItemInfo("assuredCompany", (Object)companyName_l1));
        filterItems.add(new FilterItemInfo("assuredCompany", (Object)companyName_l2));
        filterItems.add(new FilterItemInfo("assuredCompany", (Object)companyName_l3));
        filterItems.add(new FilterItemInfo("assureType.creditAssure", (Object)new Integer(1)));
        filterItems.add(new FilterItemInfo("billstate", (Object)new Integer(2)));
        filterInfo.setMaskString("#0 and(#1 or #2 or #3) and #4 and #5");
        return filterInfo;
    }

    public static String getInfoName(DataBaseInfo info) {
        DataBaseInfo newInfo;
        if (info == null) {
            return null;
        }
        if (!StringUtils.isEmpty((String)info.getName())) {
            return info.getName();
        }
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("name");
        try {
            IEJBAccess ejbAccesser = EJBAccessFactory.createRemoteInstance();
            String id = info.getId().toString();
            newInfo = (DataBaseInfo)ejbAccesser.getEntityInfo(id, sic);
        }
        catch (EASBizException e) {
            throw new RuntimeException(e);
        }
        catch (BOSException e) {
            throw new RuntimeException(e);
        }
        return newInfo.getName();
    }

    public static DataBaseInfo getInfoAllProp(DataBaseInfo info) {
        if (info == null) {
            return null;
        }
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("*");
        DataBaseInfo newInfo = null;
        try {
            IEJBAccess ejbAccesser = EJBAccessFactory.createRemoteInstance();
            String id = info.getId().toString();
            newInfo = (DataBaseInfo)ejbAccesser.getEntityInfo(id, sic);
        }
        catch (EASBizException e) {
            throw new RuntimeException(e);
        }
        catch (BOSException e) {
            throw new RuntimeException(e);
        }
        return newInfo;
    }

    public static void initExchangeRateRelAss(Context ctx, BasicFormattedTextField txtExchangeRate, CompanyOrgUnitInfo companyOrgUnitInfo, CurrencyInfo sourceCurr, CurrencyInfo destCurr, Date date) throws EASBizException, BOSException {
        if (sourceCurr == null || destCurr == null) {
            return;
        }
        BigDecimal rate = null;
        if (sourceCurr.getId().equals((Object)destCurr.getId())) {
            rate = Constants.ONE;
            txtExchangeRate.setValue((Object)rate);
            txtExchangeRate.setEditable(false);
            return;
        }
        ExchangeRateInfo exchangeRateInfo = FinUtils.getCurrencyExRateInfo(ctx, companyOrgUnitInfo, sourceCurr, destCurr, date);
        if (exchangeRateInfo == null) {
            throw new FinBizException(FinBizException.EXRATENULL);
        }
        rate = exchangeRateInfo.getConvertRate();
        if (exchangeRateInfo.getConvertMode().equals((Object)ConvertModeEnum.INDIRECTEXCHANGERATE)) {
            rate = new BigDecimal(String.valueOf(1)).divide(rate, 4);
        }
        txtExchangeRate.setValue((Object)rate);
        txtExchangeRate.setEditable(true);
    }

    public static void initExchangeRateRelAss(Context ctx, ICell cell, CompanyOrgUnitInfo companyOrgUnitInfo, CurrencyInfo sourceCurr, CurrencyInfo destCurr, Date date) throws EASBizException, BOSException {
        if (sourceCurr == null || destCurr == null) {
            return;
        }
        BigDecimal rate = null;
        if (sourceCurr.getId().equals((Object)destCurr.getId())) {
            rate = Constants.ONE;
            cell.setValue((Object)rate);
            cell.getStyleAttributes().setLocked(true);
            return;
        }
        ExchangeRateInfo exchangeRateInfo = FinUtils.getCurrencyExRateInfo(ctx, companyOrgUnitInfo, sourceCurr, destCurr, date);
        if (exchangeRateInfo == null) {
            cell.getStyleAttributes().setLocked(false);
            throw new FinBizException(FinBizException.EXRATENULL);
        }
        rate = exchangeRateInfo.getConvertRate();
        if (exchangeRateInfo.getConvertMode().equals((Object)ConvertModeEnum.INDIRECTEXCHANGERATE)) {
            rate = new BigDecimal(String.valueOf(1)).divide(rate, 4);
        }
        cell.setValue((Object)rate);
        cell.getStyleAttributes().setLocked(false);
    }

    public static void setComboConvertCurrency(KDComboBox comb) throws BOSException {
        CurrencyInfo reportCurrency;
        CompanyOrgUnitInfo company = SysContext.getSysContext().getCurrentFIUnit();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("baseCurrency.*"));
        sic.add(new SelectorItemInfo("baseCurrency.id"));
        sic.add(new SelectorItemInfo("baseCurrency.name"));
        sic.add(new SelectorItemInfo("reportCurrency.*"));
        sic.add(new SelectorItemInfo("reportCurrency.id"));
        sic.add(new SelectorItemInfo("reportCurrency.name"));
        try {
            company = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(company.getId()), sic);
        }
        catch (EASBizException e) {
            logger.error((Object)e);
        }
        catch (BOSException e) {
            logger.error((Object)e);
        }
        CurrencyInfo baseCurrency = company.getBaseCurrency();
        if (baseCurrency == null) {
            SysUtil.abort();
        }
        if ((reportCurrency = company.getReportCurrency()) == null) {
            comb.addItem((Object)baseCurrency);
            comb.setSelectedItem((Object)baseCurrency);
            comb.setEditable(false);
        } else if (baseCurrency.getId().toString().equals(reportCurrency.getId().toString())) {
            comb.addItem((Object)baseCurrency);
            comb.setSelectedItem((Object)baseCurrency);
            comb.setEditable(false);
        } else {
            comb.addItem((Object)baseCurrency);
            comb.addItem((Object)reportCurrency);
            comb.setSelectedItem((Object)baseCurrency);
            comb.setEditable(true);
        }
    }

    public static void noActionOnSetDefault(KDComboBox comboBox, Object anObject) {
        int i;
        ActionListener[] l = comboBox.getActionListeners();
        int n = l.length;
        for (int i2 = 0; i2 < n; ++i2) {
            comboBox.removeActionListener(l[i2]);
        }
        ItemListener[] itemListener = comboBox.getItemListeners();
        int n2 = itemListener.length;
        for (int i3 = 0; i3 < n2; ++i3) {
            comboBox.removeItemListener(itemListener[i3]);
        }
        if (CoreBaseInfo.class.isInstance(anObject)) {
            CoreBaseInfo newObject = (CoreBaseInfo)anObject;
            for (int i4 = 0; i4 < comboBox.getItemCount(); ++i4) {
                Object obj = comboBox.getItemAt(i4);
                if (!(obj instanceof CoreBaseInfo)) continue;
                CoreBaseInfo info = (CoreBaseInfo)comboBox.getItemAt(i4);
                if (obj == null || !newObject.getId().equals((Object)info.getId())) continue;
                comboBox.setSelectedIndex(i4);
                break;
            }
        } else {
            comboBox.setSelectedItem(anObject);
        }
        n2 = l.length;
        for (i = 0; i < n2; ++i) {
            comboBox.addActionListener(l[i]);
        }
        n2 = itemListener.length;
        for (i = 0; i < n2; ++i) {
            comboBox.addItemListener(itemListener[i]);
        }
    }

    public static void noActionOnSetDefault(KDFormattedTextField txt, Object object) {
        int i;
        ActionListener[] l = txt.getActionListeners();
        int n = l.length;
        for (int i2 = 0; i2 < n; ++i2) {
            txt.removeActionListener(l[i2]);
        }
        ComponentListener[] c = txt.getComponentListeners();
        int n2 = c.length;
        for (i = 0; i < n2; ++i) {
            txt.removeComponentListener(c[i]);
        }
        txt.setValue(object);
        n2 = l.length;
        for (i = 0; i < n2; ++i) {
            txt.addActionListener(l[i]);
        }
        n2 = c.length;
        for (i = 0; i < n2; ++i) {
            txt.addComponentListener(c[i]);
        }
    }

    public static void verifyBetweenZeroHundred(CoreUIObject ui, KDFormattedTextField txt) {
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)ui, (KDFormattedTextField)txt);
        String text = "";
        if (txt.getParent() instanceof KDLabelContainer) {
            text = ((KDLabelContainer)txt.getParent()).getBoundLabelText();
        }
        if (txt.getBigDecimalValue().compareTo(new BigDecimal(String.valueOf(0))) == -1 || txt.getBigDecimalValue().compareTo(new BigDecimal(String.valueOf(100))) == 1) {
            text = text + EASResource.getString((String)"com.kingdee.eas.fm.fin.client.FinClientResource", (String)"MustBetweenZeroHundred");
            txt.requestFocus();
            MsgBox.showWarning((Component)ui, (String)text);
            SysUtil.abort();
        }
    }

    public static RepaymentTypeEnum transfromRepaymentTypeEnum(ReturnWayEnum aEnum) {
        if (aEnum.equals((Object)ReturnWayEnum.AT_TERM_WITH_ORI_AMT)) {
            return RepaymentTypeEnum.BY_LUMP_SUM;
        }
        if (aEnum.equals((Object)ReturnWayEnum.RETURN_BY_STAGES)) {
            return RepaymentTypeEnum.SERIAL;
        }
        if (aEnum.equals((Object)ReturnWayEnum.OTHER_WAY)) {
            return RepaymentTypeEnum.OTHER;
        }
        return RepaymentTypeEnum.BY_LUMP_SUM;
    }

    public static ReturnWayEnum transfromRepaymentTypeEnum(RepaymentTypeEnum aEnum) {
        if (aEnum.equals((Object)RepaymentTypeEnum.BY_LUMP_SUM)) {
            return ReturnWayEnum.AT_TERM_WITH_ORI_AMT;
        }
        if (aEnum.equals((Object)RepaymentTypeEnum.SERIAL)) {
            return ReturnWayEnum.RETURN_BY_STAGES;
        }
        if (aEnum.equals((Object)RepaymentTypeEnum.OTHER)) {
            return ReturnWayEnum.OTHER_WAY;
        }
        return ReturnWayEnum.AT_TERM_WITH_ORI_AMT;
    }

    public static boolean isBaseCurrency(CurrencyInfo currencyInfo, CompanyOrgUnitInfo currentCompany) {
        CompanyOrgUnitInfo company = null;
        company = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        return currencyInfo.getId().toString().equals(company.getBaseCurrency().getId().toString());
    }

    public static boolean dayBeforeEquals(Date dt, Date dt1) {
        Calendar c = Calendar.getInstance();
        c.setTime(dt);
        int year = c.get(1);
        int date = c.get(6);
        c.setTime(dt1);
        int year1 = c.get(1);
        int date1 = c.get(6);
        return year < year1 || year == year1 && date <= date1;
    }

    public static boolean dayAfterEquals(Date dt, Date dt1) {
        Calendar c = Calendar.getInstance();
        c.setTime(dt);
        int year = c.get(1);
        int date = c.get(6);
        c.setTime(dt1);
        int year1 = c.get(1);
        int date1 = c.get(6);
        return year > year1 || year == year1 && date >= date1;
    }

    public static void throwFMCommonException(String info) throws FMException {
        throw new FMException(FMException.COMMMONEXCEPTION, (Object[])new String[]{info});
    }

    public static void returnQuota(Context ctx, RepaymentInfo repaymentInfo, FinancingBillInfo finBillInfo, boolean isReturnQuota) throws EASBizException, BOSException {
        if (finBillInfo.isIsInCredit() && finBillInfo.getCreditLimit() != null && finBillInfo.getCreditLimit().getProperty().equals((Object)LimitPropertyEnum.REVOLVING_AMOUNT) && repaymentInfo.getAmount().compareTo(SysConstant.BIGZERO) == 1) {
            if (FinUtils.isNeedReturnQuota(isReturnQuota, finBillInfo)) {
                BigDecimal repaymentAmount = repaymentInfo.getReturnedQuota();
                CreditLimitInfo creditLimitInfo = CreditLimitFactory.getLocalInstance(ctx).getCreditLimitInfo((IObjectPK)new ObjectUuidPK(repaymentInfo.getCreditLimit().getId()));
                FinUtils.checkCreditLimitAmount(ctx, repaymentAmount, creditLimitInfo, finBillInfo);
                BOSUuid companyid = repaymentInfo.getCompany().getId();
                if (finBillInfo instanceof PayableBillInfo) {
                    companyid = ((PayableBillInfo)finBillInfo).getApplyUnit().getId();
                }
                if (finBillInfo.getCreditLimit().getCreditUsage().isColligateCredit() && finBillInfo.getCreditLimit().getShareType() == ShareTypeEnum.ASSIGN && !LimitTypeEnum.BILLPOOL_LIMIT.equals((Object)finBillInfo.getCreditLimit().getLimitType())) {
                    CreditLimitManagerFactory.getLocalInstance(ctx).useLimitByFinancingProduct(repaymentInfo.getCreditLimit().getId(), repaymentAmount.negate(), companyid, repaymentInfo.getId(), true, finBillInfo);
                } else {
                    CreditLimitManagerFactory.getLocalInstance(ctx).useLimit(repaymentInfo.getCreditLimit().getId(), repaymentAmount.negate(), companyid, repaymentInfo.getId(), true);
                }
            } else {
                DeferReturnCLEntryFactory.getLocalInstance(ctx).recordOneDeferReturnCL(repaymentInfo.getId().toString(), finBillInfo.getId().toString());
            }
        }
    }

    public static void checkAmount(Context ctx, String creditLimitID, String finBillID, BigDecimal amount) throws EASBizException, BOSException {
        FinancingBillInfo finBillInfo = FinUtils.getFinancingBillInfo(ctx, finBillID);
        if (amount == null) {
            amount = finBillInfo.getCreditLocalAmt();
        }
        CreditLimitInfo creditLimitInfo = CreditLimitFactory.getLocalInstance(ctx).getCreditLimitInfo((IObjectPK)new ObjectUuidPK(creditLimitID));
        ShareTypeEnum shareType = creditLimitInfo.getShareType();
        BigDecimal banlance = Constants.ZERO;
        banlance = !shareType.equals((Object)ShareTypeEnum.ASSIGN) ? creditLimitInfo.getBalance() : FinUtils.getCreditLimitBalance(ctx, creditLimitInfo, finBillInfo);
        if (banlance.compareTo(Constants.ZERO) < 0 || amount.compareTo(banlance) > 0) {
            throw new FinBizException(FinBizException.CREDITLIMITAMOUNTFULLFILL);
        }
    }

    public static FinancingBillInfo getFinancingBillInfo(Context ctx, String finBillId) throws EASBizException, BOSException {
        FinancingBillInfo finBillInfo = null;
        BillBaseInfo billInfo = (BillBaseInfo)EJBAccessFactory.createLocalInstance((Context)ctx).getEntityInfo(finBillId);
        if (billInfo instanceof RepaymentInfo) {
            finBillInfo = FinUtils.getFinBillLocalOld(ctx, billInfo.getSourceBillId());
            BigDecimal returnedQuota = ((RepaymentInfo)billInfo).getReturnedQuota();
            finBillInfo.setCreditLocalAmt(returnedQuota);
        } else {
            finBillInfo = (FinancingBillInfo)billInfo;
        }
        return finBillInfo;
    }

    public static BigDecimal getCreditLimitBalance(Context ctx, CreditLimitInfo creditLimitInfo, FinancingBillInfo finBillInfo) throws EASBizException, BOSException {
        if (creditLimitInfo == null || finBillInfo == null) {
            return Constants.ZERO;
        }
        BigDecimal sumEntryBalance = Constants.ZERO;
        EntityViewInfo view = new EntityViewInfo();
        view.getSelector().add(new SelectorItemInfo("Banlance"));
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("ShareOrg", (Object)finBillInfo.getCompany().getId(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("controlWay", (Object)new Integer(1), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("controlWay", (Object)new Integer(0), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("finPro", (Object)finBillInfo.getType().getId(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("Parent", (Object)creditLimitInfo.getId(), CompareType.EQUALS));
        filter.setMaskString("#0 and (#1 or ((#2 and #3))) and #4");
        CreditLimitEntryCollection colls = CreditLimitEntryFactory.getLocalInstance(ctx).getCreditLimitEntryCollection(view);
        Iterator it = colls.iterator();
        while (it.hasNext()) {
            CreditLimitEntryInfo entryInfo = (CreditLimitEntryInfo)it.next();
            BigDecimal entryBalance = entryInfo.getBanlance() == null ? Constants.ZERO : entryInfo.getBanlance();
            sumEntryBalance = sumEntryBalance.add(entryBalance);
        }
        return sumEntryBalance;
    }

    public static boolean isNeedReturnQuota(boolean isReturnQuota, FinancingBillInfo finBillInfo) {
        boolean isNeedReturnQuota = false;
        if (isReturnQuota) {
            isNeedReturnQuota = true;
        } else if (!finBillInfo.getBOSType().equals((Object)LetterOfCreditInfo.BOSTYPE)) {
            isNeedReturnQuota = true;
        } else {
            LetterOfCreditInfo locInfo = (LetterOfCreditInfo)finBillInfo;
            if (locInfo.getDeferReturnCreditLimitDays() == 0) {
                isNeedReturnQuota = true;
            }
        }
        return isNeedReturnQuota;
    }

    private static void checkCreditLimitAmount(Context ctx, BigDecimal amount, CreditLimitInfo creditLimitInfo, FinancingBillInfo finBillInfo) throws EASBizException, BOSException {
        CurrencyInfo currency = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyInfo((IObjectPK)new ObjectUuidPK(creditLimitInfo.getCurrency().getId().toString()));
        BigDecimal totalQuota = finBillInfo.getCreditLocalAmt().divide(Constants.ONE, currency.getPrecision(), 4);
        if (totalQuota == null || totalQuota.compareTo(Constants.ZERO) == 0) {
            return;
        }
        BigDecimal repayQuota = FinUtils.calRepayQuota(ctx, finBillInfo);
        if (finBillInfo.getCreditLocalAmt().compareTo(repayQuota.add(amount)) < 0) {
            String msgStr = "";
            DecimalFormat format = (DecimalFormat)FMHelper.getNantionalDateMap((Context)ctx).get("numberFormat");
            String returnQuota = format.format(totalQuota.subtract(repayQuota));
            msgStr = ctx != null ? MessageFormat.format(EASCommonResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"522_FinUtils", (Locale)ctx.getLocale()), returnQuota) : MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"522_FinUtils"), returnQuota);
            FinUtils.throwFMCommonException(msgStr);
        }
    }

    private static BigDecimal calRepayQuota(Context ctx, FinancingBillInfo finBillInfo) throws BOSException {
        Set billIDSet = new HashSet();
        BigDecimal repayQuota = Constants.ZERO;
        billIDSet = FinUtils.buildIDSet(ctx, finBillInfo, billIDSet);
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(new FilterInfo());
        view.getSelector().add(new SelectorItemInfo("UsedQuota"));
        view.getFilter().getFilterItems().add(new FilterItemInfo("BillId", billIDSet, CompareType.INCLUDE));
        view.getFilter().getFilterItems().add(new FilterItemInfo("UsedQuota", (Object)Constants.ZERO, CompareType.LESS_EQUALS));
        view.getFilter().getFilterItems().add(new FilterItemInfo("IsUnioned", (Object)"0"));
        CreditLimitUsedCollection colls = CreditLimitUsedFactory.getLocalInstance(ctx).getCreditLimitUsedCollection(view);
        Iterator it = colls.iterator();
        while (it.hasNext()) {
            CreditLimitUsedInfo creditLimitUsedInfo = (CreditLimitUsedInfo)it.next();
            repayQuota = repayQuota.add(creditLimitUsedInfo.getUsedQuota().negate());
        }
        return repayQuota;
    }

    private static Set buildIDSet(Context ctx, FinancingBillInfo finBillInfo, Set billIDSet) throws BOSException {
        if (finBillInfo instanceof PayableBillInfo) {
            EntityViewInfo view = new EntityViewInfo();
            view.setFilter(new FilterInfo());
            view.getSelector().add(new SelectorItemInfo("id"));
            view.getFilter().getFilterItems().add(new FilterItemInfo("sourceBillId", (Object)finBillInfo.getId().toString()));
            AssureAmountCollection assureColls = AssureAmountFactory.getLocalInstance((Context)ctx).getAssureAmountCollection(view);
            for (AssureAmountInfo assureAmountInfo : assureColls) {
                billIDSet.add(assureAmountInfo.getId().toString());
            }
        }
        EntityViewInfo viewRepay = new EntityViewInfo();
        viewRepay.setFilter(new FilterInfo());
        viewRepay.getSelector().add(new SelectorItemInfo("id"));
        viewRepay.getFilter().getFilterItems().add(new FilterItemInfo("sourceBillId", (Object)finBillInfo.getId().toString()));
        RepaymentCollection repayColls = RepaymentFactory.getLocalInstance(ctx).getRepaymentCollection(viewRepay);
        Iterator it = repayColls.iterator();
        while (it.hasNext()) {
            RepaymentInfo repayInfo = (RepaymentInfo)it.next();
            billIDSet.add(repayInfo.getId().toString());
        }
        return billIDSet;
    }

    public static CreditLimitStatusEnum calcCreditStatus(Context ctx, String id) throws BOSException, EASBizException {
        CreditLimitInfo clInfo = CreditLimitFactory.getLocalInstance(ctx).getCreditLimitInfo((IObjectPK)new ObjectUuidPK(id));
        BigDecimal bdAmount = clInfo.getQuotaAmount();
        BigDecimal bdBalance = clInfo.getBalance();
        CreditLimitStatusEnum state = null;
        if (bdBalance.compareTo(bdAmount) == 0 && !clInfo.isIsClosed()) {
            state = CreditLimitStatusEnum.INEFFECTIVE;
        } else if (bdBalance.compareTo(SysConstant.BIGZERO) > 0 && bdBalance.compareTo(bdAmount) != 0 && !clInfo.isIsClosed() || bdBalance.compareTo(SysConstant.BIGZERO) < 0 && bdBalance.compareTo(bdAmount) != 0 && !clInfo.isIsClosed() && clInfo.isIsUnion()) {
            state = CreditLimitStatusEnum.EFFECTIVE;
        } else if (bdBalance.compareTo(SysConstant.BIGZERO) == 0 || clInfo.isIsClosed()) {
            state = CreditLimitStatusEnum.EXPIRED;
        } else {
            throw new FinBizException(FinBizException.CREDITLIMITAMOUNTFULLFILL);
        }
        return state;
    }

    public static boolean isIndirectExRate(Context ctx, CompanyOrgUnitInfo companyOrgUnitInfo, CurrencyInfo sourceCurr, CurrencyInfo destCurr, Date date, ExchangeRateInfo rateInfo) throws EASBizException, BOSException {
        if (sourceCurr == null || destCurr == null) {
            return false;
        }
        if (sourceCurr.getId().toString().equals(destCurr.getId().toString())) {
            return false;
        }
        ExchangeRateInfo exchangeRateInfo = null;
        exchangeRateInfo = rateInfo == null ? FinUtils.getCurrencyExRateInfo(ctx, companyOrgUnitInfo, sourceCurr, destCurr, date) : rateInfo;
        if (exchangeRateInfo == null) {
            return false;
        }
        return ConvertModeEnum.INDIRECTEXCHANGERATE.equals((Object)exchangeRateInfo.getConvertMode());
    }

    public static void setEditableNew(Component[] components, boolean editable) {
        for (Component component : components) {
            KDComboBox cbx;
            if (component instanceof KDBizPromptBox) {
                KDBizPromptBox bizBox = (KDBizPromptBox)component;
                bizBox.setEditable(editable);
                bizBox.setEnabled(editable);
                continue;
            }
            if (component instanceof KDComboBox) {
                cbx = (KDComboBox)component;
                cbx.setEnabled(editable);
                continue;
            }
            if (component instanceof KDDatePicker) {
                cbx = (KDDatePicker)component;
                cbx.setEditable(editable);
                cbx.setEnabled(editable);
                continue;
            }
            if (component instanceof KDCheckBox) {
                KDCheckBox cb = (KDCheckBox)component;
                cb.setEnabled(editable);
                continue;
            }
            if (component instanceof IKDTextComponent && !(component instanceof KDComboBox)) {
                ((IKDTextComponent)component).setEditable(editable);
                continue;
            }
            if (component instanceof KDRadioButton) {
                ((KDRadioButton)component).setEnabled(editable);
                continue;
            }
            if (!(component instanceof KDWorkButton)) continue;
            ((KDWorkButton)component).setEnabled(editable);
        }
    }
}

