/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fin;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.vc.VerifyScopeEnum;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.BillTypeEnum;
import com.kingdee.eas.fi.cas.DefaultBookNotifyBuilder;
import com.kingdee.eas.fi.cas.JournalCollection;
import com.kingdee.eas.fi.cas.JournalInfo;
import com.kingdee.eas.fi.cas.JournalSourceEnum;
import com.kingdee.eas.fi.cas.JournalTypeEnum;
import com.kingdee.eas.fm.fin.LoanFactory;
import com.kingdee.eas.fm.fin.LoanInfo;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.client.EASResource;
import java.util.Locale;

public class LoanBookNotifyBuilder
extends DefaultBookNotifyBuilder {
    public JournalCollection getJournalColl(Context ctx, String billId) throws BOSException, EASBizException {
        LoanInfo loanInfo = this.getLoanInfo(ctx, billId);
        JournalCollection journalColl = new JournalCollection();
        JournalInfo journalInfo = this.createJournalInfoAmt(ctx, loanInfo);
        journalColl.add(journalInfo);
        if (loanInfo.getCautionAcctBank() != null) {
            journalColl.add(this.createJournalCautionAmt(ctx, loanInfo));
        }
        return journalColl;
    }

    private JournalInfo createJournalCautionAmt(Context ctx, LoanInfo loanInfo) {
        JournalInfo journalInfoAutionAmt = new JournalInfo();
        journalInfoAutionAmt.setType(JournalTypeEnum.BANK);
        journalInfoAutionAmt.setAccountBank(loanInfo.getCautionAcctBank());
        journalInfoAutionAmt.setCurrency(loanInfo.getCurrency());
        journalInfoAutionAmt.setCreateDate(loanInfo.getBizDate());
        journalInfoAutionAmt.setDebitAmount(loanInfo.getCautionAmt());
        journalInfoAutionAmt.setIsDebit(true);
        journalInfoAutionAmt.setCreditAmount(Constants.ZERO);
        journalInfoAutionAmt.setBizDate(loanInfo.getIssueDate());
        journalInfoAutionAmt.setAccountView(loanInfo.getSettlementAcct());
        journalInfoAutionAmt.setOppAccountView(loanInfo.getLoanAcct());
        journalInfoAutionAmt.setBillType(BillTypeEnum.caution);
        journalInfoAutionAmt.setBillId(loanInfo.getId().toString());
        journalInfoAutionAmt.setBillNumber(loanInfo.getNumber());
        String des = "";
        des = ctx != null ? ResourceBase.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"448_LetterOfCreditBookNotifyBuilder", (Locale)ctx.getLocale()) : EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"448_LetterOfCreditBookNotifyBuilder");
        journalInfoAutionAmt.setDescription(des);
        journalInfoAutionAmt.setCompany(loanInfo.getCompany());
        journalInfoAutionAmt.setVerifyStatus(VerifyScopeEnum.NOVA);
        journalInfoAutionAmt.setSource(JournalSourceEnum.BYBILL);
        return journalInfoAutionAmt;
    }

    private JournalInfo createJournalInfoAmt(Context ctx, LoanInfo loanInfo) {
        JournalInfo journalInfo = new JournalInfo();
        journalInfo.setType(JournalTypeEnum.BANK);
        journalInfo.setAccountBank(loanInfo.getBankAcct());
        journalInfo.setCurrency(loanInfo.getCurrency());
        journalInfo.setCreateDate(loanInfo.getBizDate());
        journalInfo.setDebitAmount(loanInfo.getAmount().subtract(loanInfo.getCautionAmt()));
        journalInfo.setIsDebit(true);
        journalInfo.setCreditAmount(Constants.ZERO);
        journalInfo.setBizDate(loanInfo.getIssueDate());
        journalInfo.setAccountView(loanInfo.getSettlementAcct());
        journalInfo.setOppAccountView(loanInfo.getLoanAcct());
        journalInfo.setBillId(loanInfo.getId().toString());
        journalInfo.setBillNumber(loanInfo.getNumber());
        if (loanInfo.isIsBonds()) {
            journalInfo.setBillType(BillTypeEnum.bondsBill);
            journalInfo.setDescription(EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"393_LoanBookNotifyBuilder"));
        } else {
            journalInfo.setBillType(BillTypeEnum.loanBill);
            String des = "";
            des = ctx != null ? ResourceBase.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"448_LetterOfCreditBookNotifyBuilder", (Locale)ctx.getLocale()) : EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"448_LetterOfCreditBookNotifyBuilder");
            journalInfo.setDescription(des);
        }
        journalInfo.setCompany(loanInfo.getCompany());
        journalInfo.setVerifyStatus(VerifyScopeEnum.NOVA);
        journalInfo.setSource(JournalSourceEnum.BYBILL);
        return journalInfo;
    }

    private LoanInfo getLoanInfo(Context ctx, String billId) throws EASBizException, BOSException {
        LoanInfo info = LoanFactory.getLocalInstance(ctx).getLoanInfo((IObjectPK)new ObjectUuidPK(billId), this.getSelector());
        return info;
    }

    private SelectorItemCollection getSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("*");
        return sic;
    }
}

