/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fin;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.bot.BOTRelationCollection;
import com.kingdee.bos.metadata.bot.BOTRelationFactory;
import com.kingdee.bos.metadata.bot.BOTRelationInfo;
import com.kingdee.bos.metadata.bot.IBOTRelation;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.btp.BTPException;
import com.kingdee.eas.base.btp.BTPManagerFactory;
import com.kingdee.eas.base.btp.IBTPManager;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.basedata.assistant.ExchangeRateInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.BillStatusEnum;
import com.kingdee.eas.fi.cas.DisposerActionEnum;
import com.kingdee.eas.fi.cas.IPaymentBillEntry;
import com.kingdee.eas.fi.cas.PaymentBillCollection;
import com.kingdee.eas.fi.cas.PaymentBillEntryCollection;
import com.kingdee.eas.fi.cas.PaymentBillEntryFactory;
import com.kingdee.eas.fi.cas.PaymentBillEntryInfo;
import com.kingdee.eas.fi.cas.PaymentBillFactory;
import com.kingdee.eas.fi.cas.PaymentBillInfo;
import com.kingdee.eas.fm.ctl.LetterOfGuaranteeInfo;
import com.kingdee.eas.fm.fin.FinBillDisposer;
import com.kingdee.eas.fm.fin.FinBizException;
import com.kingdee.eas.fm.fin.FinUtils;
import com.kingdee.eas.fm.fin.GenPayRecordCollection;
import com.kingdee.eas.fm.fin.GenPayRecordFactory;
import com.kingdee.eas.fm.fin.GenPayRecordInfo;
import com.kingdee.eas.fm.fin.IGenPayRecord;
import com.kingdee.eas.fm.fin.IRepayment;
import com.kingdee.eas.fm.fin.LetterOfCreditInfo;
import com.kingdee.eas.fm.fin.LoanInterestInfo;
import com.kingdee.eas.fm.fin.RepaymentFactory;
import com.kingdee.eas.fm.fin.RepaymentInfo;
import com.kingdee.eas.fm.nt.PayableBillInfo;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class RepaymentDisposer
extends FinBillDisposer {
    private List otherBotRelationList;
    private boolean isCreateFromLoanBill;

    @Override
    protected String getDBTableName() {
        return "t_fin_repayment";
    }

    @Override
    protected Map getDisposeKeyValueMap(Context ctx) throws EASBizException, BOSException {
        String srcBosType = null;
        BOTRelationCollection botRelCol = BTPManagerFactory.getLocalInstance((Context)ctx).getRelationCollection(this.srcID);
        for (int i = 0; i < botRelCol.size(); ++i) {
            srcBosType = botRelCol.get(i).getSrcEntityID();
            if (!new PayableBillInfo().getBOSType().toString().equals(srcBosType) && !new LetterOfCreditInfo().getBOSType().toString().equals(srcBosType) && !new LetterOfGuaranteeInfo().getBOSType().toString().equals(srcBosType)) continue;
            this.isCreateFromLoanBill = true;
        }
        HashMap<String, Object> map = null;
        if (this.isCreateFromLoanBill) {
            map = new HashMap<String, Object>();
            RepaymentInfo repaymentInfo = RepaymentFactory.getLocalInstance(ctx).getRepaymentInfo("select id,amount,interest,cautionAmt,isGenPayBill,isPayCompleted,totalPayedAmt,BankAcct,Currency.id,company.id,bizDate,isBondsRepayment where id = '" + this.srcID + "'");
            IGenPayRecord iGenPayRec = GenPayRecordFactory.getLocalInstance(ctx);
            PaymentBillInfo paymentbillInfo = (PaymentBillInfo)this.billDisposerAction.getDestBill();
            GenPayRecordCollection genPayRecordColl = iGenPayRec.getGenPayRecordCollection("select payedAmount where repayment.id = '" + this.srcID + "' and paymentBillId = '" + paymentbillInfo.getId().toString() + "'");
            BigDecimal amount = repaymentInfo.getAmount();
            BigDecimal restAmt = this.isCreateFromLoanBill ? (repaymentInfo.getInterest() == null ? BigDecimal.ZERO : repaymentInfo.getInterest()) : repaymentInfo.getCautionAmt();
            BigDecimal totalPayedAmt = repaymentInfo.getTotalPayedAmt() == null ? new BigDecimal(0) : repaymentInfo.getTotalPayedAmt();
            BigDecimal actPayAmt = paymentbillInfo.getActPayAmt();
            ExchangeRateInfo exRateInfo = FinUtils.getCurrencyExRateInfo(ctx, paymentbillInfo.getCompany(), paymentbillInfo.getCurrency(), repaymentInfo.getCurrency(), repaymentInfo.getBizDate());
            if (exRateInfo != null) {
                actPayAmt = actPayAmt.multiply(exRateInfo.getConvertRate());
            }
            BigDecimal lastPayAmt = null;
            GenPayRecordInfo genPayRecordInfo = null;
            if (genPayRecordColl.size() == 1) {
                genPayRecordInfo = genPayRecordColl.get(0);
                lastPayAmt = genPayRecordInfo.getPayedAmount();
            }
            if (this.billDisposerAction.getActionType().equals((Object)DisposerActionEnum.DELETE) && this.isHasSrcBotpRelations(ctx, paymentbillInfo.getId().toString(), repaymentInfo)) {
                BigDecimal zero = BigDecimal.ZERO;
                map.put("FIsPayCompleted", 0);
                if (!this.isHasOtherRelation()) {
                    totalPayedAmt = totalPayedAmt.compareTo(zero) <= 0 ? zero : totalPayedAmt.subtract(actPayAmt);
                    map.put("FTotalPayedAmt", totalPayedAmt);
                    if (totalPayedAmt.compareTo(zero) == 0) {
                        map.put("FIsGenPayBill", 0);
                    }
                    iGenPayRec.delete("where repayment.id = '" + this.srcID + "' and paymentBillId = '" + paymentbillInfo.getId().toString() + "'");
                } else {
                    List allDestBill = this.getAllDestBotpRelBill(ctx, this.srcID, paymentbillInfo.getBOSType().toString());
                    EntityViewInfo view = new EntityViewInfo();
                    SelectorItemCollection sel = new SelectorItemCollection();
                    sel.add("id");
                    sel.add("billStatus");
                    FilterInfo filter = new FilterInfo();
                    filter.getFilterItems().add(new FilterItemInfo("id", new HashSet(allDestBill), CompareType.INCLUDE));
                    view.setSelector(sel);
                    view.setFilter(filter);
                    PaymentBillCollection payCol = PaymentBillFactory.getLocalInstance((Context)ctx).getPaymentBillCollection(view);
                    PaymentBillInfo payBillInfo = null;
                    String anotherDestBillId = null;
                    List destBillNext = null;
                    String id = null;
                    for (int i = 0; i < payCol.size(); ++i) {
                        payBillInfo = payCol.get(i);
                        if (payBillInfo.getBillStatus().equals((Object)BillStatusEnum.AUDITED)) {
                            throw new FinBizException(FinBizException.COMMON, new String[]{ResourceBase.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"526_RepaymentDisposer", (Locale)ctx.getLocale())});
                        }
                        if (payBillInfo.getBillStatus().equals((Object)BillStatusEnum.APPROVED)) {
                            throw new FinBizException(FinBizException.COMMON, new String[]{ResourceBase.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"527_RepaymentDisposer", (Locale)ctx.getLocale())});
                        }
                        if (payBillInfo.getBillStatus().equals((Object)BillStatusEnum.PAYED)) {
                            throw new FinBizException(FinBizException.COMMON, new String[]{ResourceBase.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"528_RepaymentDisposer", (Locale)ctx.getLocale())});
                        }
                        id = payBillInfo.getId().toString();
                        if (!paymentbillInfo.getId().toString().equals(id)) {
                            anotherDestBillId = id;
                        }
                        if ((destBillNext = this.getAllDestBotpRelBill(ctx, id, null)).size() <= 0) continue;
                        throw new FinBizException(FinBizException.COMMON, new String[]{ResourceBase.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"525_RepaymentDisposer", (Locale)ctx.getLocale())});
                    }
                    map.put("FIsGenPayBill", 0);
                    map.put("FTotalPayedAmt", 0.0);
                    this.deleteAnotherPayBill(ctx, anotherDestBillId);
                }
            }
            if (this.billDisposerAction.getActionType().equals((Object)DisposerActionEnum.SAVE) || this.billDisposerAction.getActionType().equals((Object)DisposerActionEnum.SUBMIT)) {
                if (this.isMultiRepay2Payment(ctx, paymentbillInfo.getId().toString(), repaymentInfo) && this.isHasOtherRelation()) {
                    map.put("FIsPayCompleted", 1);
                    map.put("FIsGenPayBill", 1);
                    map.put("FTotalPayedAmt", " FAmount + " + (this.isCreateFromLoanBill ? "FInterest " : "FCautionAmt "));
                } else {
                    BigDecimal newTotalPayedAmt = lastPayAmt == null ? totalPayedAmt.add(actPayAmt) : totalPayedAmt.subtract(lastPayAmt).add(actPayAmt);
                    BigDecimal sumAmt = amount.add(restAmt);
                    if (!this.isCreateFromLoanBill && sumAmt.compareTo(actPayAmt) < 0) {
                        if (repaymentInfo.isIsBondsRepayment()) {
                            throw new FinBizException(FinBizException.COMMON, new String[]{ResourceBase.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"523_BondsRepaymentDisposer", (Locale)ctx.getLocale())});
                        }
                        throw new FinBizException(FinBizException.COMMON, new String[]{ResourceBase.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"523_RepaymentDisposer", (Locale)ctx.getLocale())});
                    }
                    if (this.isCreateFromLoanBill && sumAmt.compareTo(actPayAmt) < 0) {
                        throw new FinBizException(FinBizException.COMMON, new String[]{ResourceBase.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"523_RepaymentDisposer", (Locale)ctx.getLocale())});
                    }
                    if (!this.isCreateFromLoanBill && sumAmt.compareTo(newTotalPayedAmt) < 0) {
                        throw new FinBizException(FinBizException.COMMON, new String[]{ResourceBase.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"516_RepaymentDisposer", (Locale)ctx.getLocale())});
                    }
                    if (this.isCreateFromLoanBill && sumAmt.compareTo(newTotalPayedAmt) < 0) {
                        if (repaymentInfo.isIsBondsRepayment()) {
                            throw new FinBizException(FinBizException.COMMON, new String[]{ResourceBase.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"524_BondsRepaymentDisposer", (Locale)ctx.getLocale())});
                        }
                        throw new FinBizException(FinBizException.COMMON, new String[]{ResourceBase.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"524_RepaymentDisposer", (Locale)ctx.getLocale())});
                    }
                    if (genPayRecordInfo != null) {
                        genPayRecordInfo.setPayedAmount(actPayAmt);
                        iGenPayRec.update((IObjectPK)new ObjectUuidPK(genPayRecordInfo.getId().toString()), genPayRecordInfo);
                    } else {
                        genPayRecordInfo = new GenPayRecordInfo();
                        genPayRecordInfo.setRepayment(repaymentInfo);
                        genPayRecordInfo.setPaymentBillId(paymentbillInfo.getId());
                        genPayRecordInfo.setPayedAmount(actPayAmt);
                        iGenPayRec.addnew(genPayRecordInfo);
                    }
                    if (sumAmt.compareTo(newTotalPayedAmt) == 0) {
                        map.put("FIsPayCompleted", 1);
                    } else {
                        map.put("FIsPayCompleted", 0);
                    }
                    map.put("FIsGenPayBill", 1);
                    map.put("FTotalPayedAmt", newTotalPayedAmt);
                }
            }
        }
        if (this.isLoanToPay) {
            IPaymentBillEntry iPE = PaymentBillEntryFactory.getLocalInstance((Context)ctx);
            IRepayment iRe = RepaymentFactory.getLocalInstance(ctx);
            IGenPayRecord iGenPayRec = GenPayRecordFactory.getLocalInstance(ctx);
            map = new HashMap();
            map.put("isLoanToPay", 1);
            if (this.billDisposerAction.getActionType().equals((Object)DisposerActionEnum.SAVE) || this.billDisposerAction.getActionType().equals((Object)DisposerActionEnum.SUBMIT)) {
                GenPayRecordCollection genPayColl = this.getPaymentRecords(ctx, this.billDisposerAction.getDestBill().getId().toString(), iGenPayRec);
                HashSet<String> deletedSrcIdSet = new HashSet<String>();
                for (int i = 0; i < genPayColl.size(); ++i) {
                    if (this.srcIdSet.contains(genPayColl.get(i).getRepayment().getId().toString())) continue;
                    deletedSrcIdSet.add(genPayColl.get(i).getRepayment().getId().toString());
                }
                this.process4AddnewOrSubmit(ctx, map, iPE, iRe, this.srcIdSet);
                if (EmptyUtil.isEmpty((AbstractObjectCollection)genPayColl)) {
                    this.addGenpayColl(iGenPayRec, this.srcIdSet);
                }
                this.process4Delete(ctx, map, iPE, iRe, deletedSrcIdSet);
                if (!EmptyUtil.isEmpty(deletedSrcIdSet)) {
                    this.deleteGenPayRecord(iGenPayRec, deletedSrcIdSet);
                    this.srcIdSet.addAll(deletedSrcIdSet);
                }
            } else if (this.billDisposerAction.getActionType().equals((Object)DisposerActionEnum.DELETE)) {
                this.process4Delete(ctx, map, iPE, iRe, this.srcIdSet);
                this.deleteGenPayRecord(iGenPayRec, this.srcIdSet);
            }
        }
        return map;
    }

    private void deleteGenPayRecord(IGenPayRecord iGenPayRec, Set<String> deletedSrcIdSet) throws BOSException, EASBizException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("repayment", deletedSrcIdSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("paymentBillId", (Object)this.billDisposerAction.getDestBill().getId().toString(), CompareType.EQUALS));
        iGenPayRec.delete(filter);
    }

    private void addGenpayColl(IGenPayRecord iGenPayRec, Set<String> srcIdSet) throws BOSException, EASBizException {
        CoreBaseCollection cbColl = new CoreBaseCollection();
        BOSUuid paymentbillId = this.billDisposerAction.getDestBill().getId();
        for (String srcBill : srcIdSet) {
            GenPayRecordInfo genPayInfo = new GenPayRecordInfo();
            RepaymentInfo repayment = new RepaymentInfo();
            repayment.setId(BOSUuid.read((String)srcBill));
            genPayInfo.setRepayment(repayment);
            genPayInfo.setPaymentBillId(paymentbillId);
            cbColl.add((CoreBaseInfo)genPayInfo);
        }
        if (!EmptyUtil.isEmpty((AbstractObjectCollection)cbColl)) {
            iGenPayRec.addnew(cbColl);
        }
    }

    private void process4AddnewOrSubmit(Context ctx, Map map, IPaymentBillEntry iPE, IRepayment iRe, Set<String> addSet) throws BOSException, EASBizException {
        for (String sourceBillId : addSet) {
            PaymentBillEntryCollection entryColl = this.getDestPayEntrys(iPE, sourceBillId, false);
            RepaymentInfo repaymentInfo = iRe.getRepaymentInfo("select id,amount,interest,isGenPayBill,isPayCompleted,totalPayedAmt,Currency.id where id = '" + sourceBillId + "'");
            List<BigDecimal> disposeValues = this.getDisposeValues4AddNew(ctx, entryColl, repaymentInfo);
            map.put(sourceBillId, disposeValues);
        }
    }

    private void process4Delete(Context ctx, Map map, IPaymentBillEntry iPE, IRepayment iRe, Set<String> delSet) throws BOSException, EASBizException {
        for (String sourceBillId : delSet) {
            PaymentBillEntryCollection entryColl = this.getDestPayEntrys(iPE, sourceBillId, true);
            RepaymentInfo repaymentInfo = iRe.getRepaymentInfo("select id,amount,interest,isGenPayBill,isPayCompleted,totalPayedAmt,Currency.id where id = '" + sourceBillId + "'");
            List<BigDecimal> disposeValues = this.getDisposeValues4Delete(ctx, entryColl, repaymentInfo);
            map.put(sourceBillId, disposeValues);
        }
    }

    private GenPayRecordCollection getPaymentRecords(Context ctx, String paymentbillId, IGenPayRecord iGenPayRec) throws BOSException {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("paymentBillId", (Object)paymentbillId, CompareType.EQUALS));
        evi.setFilter(filter);
        evi.getSelector().add("*");
        evi.getSelector().add("repayment.*");
        return iGenPayRec.getGenPayRecordCollection(evi);
    }

    private PaymentBillEntryCollection getDestPayEntrys(IPaymentBillEntry iPE, String SourceBillId, boolean is4Del) throws BOSException {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("sourceBillId", (Object)SourceBillId, CompareType.EQUALS));
        if (is4Del) {
            filter.getFilterItems().add(new FilterItemInfo("paymentBill", (Object)this.billDisposerAction.getDestBill().getId().toString(), CompareType.NOTEQUALS));
        }
        evi.setFilter(filter);
        evi.getSelector().add("*");
        return iPE.getPaymentBillEntryCollection(evi);
    }

    private List<BigDecimal> getDisposeValues4AddNew(Context ctx, PaymentBillEntryCollection payEntry, RepaymentInfo repayment) throws FinBizException {
        ArrayList<BigDecimal> list = new ArrayList<BigDecimal>();
        BigDecimal totalPayed = BigDecimal.ZERO;
        BigDecimal sourceAmt = repayment.getAmount().add(repayment.getInterest());
        for (PaymentBillEntryInfo entryInfo : payEntry) {
            totalPayed = totalPayed.add(entryInfo.getActualAmt());
        }
        if (sourceAmt.compareTo(totalPayed) > 0) {
            list.add(BigDecimal.ZERO);
            list.add(totalPayed);
        } else if (sourceAmt.compareTo(totalPayed) == 0) {
            list.add(BigDecimal.ONE);
            list.add(totalPayed);
        } else {
            throw new FinBizException(FinBizException.COMMON, new String[]{ResourceBase.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"523_RepaymentDisposer", (Locale)ctx.getLocale())});
        }
        list.add(BigDecimal.ONE);
        return list;
    }

    private List<BigDecimal> getDisposeValues4Delete(Context ctx, PaymentBillEntryCollection payEntry, RepaymentInfo repayment) {
        ArrayList<BigDecimal> list = new ArrayList<BigDecimal>();
        BigDecimal totalPayed = BigDecimal.ZERO;
        BigDecimal sourceAmt = repayment.getAmount().add(repayment.getInterest());
        for (PaymentBillEntryInfo entryInfo : payEntry) {
            totalPayed = totalPayed.add(entryInfo.getActualAmt());
        }
        if (sourceAmt.compareTo(totalPayed) > 0) {
            list.add(BigDecimal.ZERO);
        } else if (sourceAmt.compareTo(totalPayed) == 0) {
            list.add(BigDecimal.ONE);
        }
        list.add(totalPayed);
        if (!EmptyUtil.isEmpty((AbstractObjectCollection)payEntry)) {
            list.add(BigDecimal.ONE);
        } else {
            list.add(BigDecimal.ZERO);
        }
        return list;
    }

    private void deleteAnotherPayBill(Context ctx, String anotherDestBillId) throws BOSException, BTPException {
        if (anotherDestBillId != null) {
            String sql = "delete from t_cas_paymentbill where fid = ? ";
            DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{anotherDestBillId});
            IBTPManager iBTPManager = BTPManagerFactory.getLocalInstance((Context)ctx);
            PaymentBillInfo info = new PaymentBillInfo();
            info.setId(BOSUuid.read((String)anotherDestBillId));
            iBTPManager.removeAllRelation((CoreBillBaseInfo)info);
        }
    }

    private boolean isHasOtherRelation() {
        return this.otherBotRelationList != null && this.otherBotRelationList.size() > 0;
    }

    private List getAllDestBotpRelBill(Context ctx, String srcId, String bosType) throws BTPException, BOSException {
        IBTPManager iBTPManager = BTPManagerFactory.getLocalInstance((Context)ctx);
        BOTRelationCollection relationCol = iBTPManager.getDestRelation(srcId);
        String id = null;
        ArrayList<String> list = new ArrayList<String>();
        if (relationCol.size() == 0) {
            return list;
        }
        for (int i = 0; i < relationCol.size(); ++i) {
            id = relationCol.get(i).getDestObjectID();
            if (bosType != null) {
                if (!bosType.equals(BOSUuid.read((String)id).getType().toString())) continue;
                list.add(id);
                continue;
            }
            list.add(id);
        }
        return list;
    }

    private boolean isHasSrcBotpRelations(Context ctx, String destBillID, RepaymentInfo repaymentInfo) throws BTPException, BOSException {
        IBTPManager iBTPManager = BTPManagerFactory.getLocalInstance((Context)ctx);
        BOTRelationCollection botRelCol = iBTPManager.getRelationCollection(destBillID);
        String repaymentBosType = repaymentInfo.getBOSType().toString();
        if (botRelCol.size() == 0) {
            return false;
        }
        this.otherBotRelationList = new ArrayList();
        for (int i = 0; i < botRelCol.size(); ++i) {
            if (this.srcID.equals(botRelCol.get(i).getSrcObjectID()) || !repaymentBosType.equals(BOSUuid.read((String)botRelCol.get(i).getSrcObjectID()).getType().toString())) continue;
            this.otherBotRelationList.add(botRelCol.get(i).getSrcObjectID());
        }
        return true;
    }

    private boolean isMultiRepay2Payment(Context ctx, String destBillID, RepaymentInfo repaymentInfo) throws BTPException, BOSException {
        IBTPManager iBTPManager = BTPManagerFactory.getLocalInstance((Context)ctx);
        BOTRelationCollection botRelCol = iBTPManager.getRelationCollection(destBillID);
        String repaymentBosType = repaymentInfo.getBOSType().toString();
        if (botRelCol.size() == 0) {
            return false;
        }
        this.otherBotRelationList = new ArrayList();
        for (int i = 0; i < botRelCol.size(); ++i) {
            if (this.srcID.equals(botRelCol.get(i).getSrcObjectID()) || !repaymentBosType.equals(BOSUuid.read((String)botRelCol.get(i).getSrcObjectID()).getType().toString())) continue;
            this.otherBotRelationList.add(botRelCol.get(i).getSrcObjectID());
        }
        return true;
    }

    @Override
    protected void disposeOtherSrcBill(Context ctx, PaymentBillInfo paymentBillInfo) throws EASBizException, BOSException {
        if (this.isHasOtherRelation()) {
            StringBuffer sb;
            String srcId;
            int i;
            if (this.billDisposerAction.getActionType().equals((Object)DisposerActionEnum.DELETE)) {
                for (i = 0; i < this.otherBotRelationList.size(); ++i) {
                    srcId = this.otherBotRelationList.get(i).toString();
                    sb = new StringBuffer();
                    sb.append("update ").append(this.getDBTableName()).append(" set FIsPayCompleted = 0, FIsGenPayBill = 0, FTotalPayedAmt = 0.00");
                    sb.append(" where fid = ?");
                    DbUtil.execute((Context)ctx, (String)sb.toString(), (Object[])new Object[]{srcId});
                }
            } else if (this.billDisposerAction.getActionType().equals((Object)DisposerActionEnum.SAVE) || this.billDisposerAction.getActionType().equals((Object)DisposerActionEnum.SUBMIT)) {
                for (i = 0; i < this.otherBotRelationList.size(); ++i) {
                    srcId = this.otherBotRelationList.get(i).toString();
                    sb = new StringBuffer();
                    sb.append("update ").append(this.getDBTableName()).append(" set FIsGenPayBill = 1,FIsPayCompleted = 1, FTotalPayedAmt = FAmount ").append(this.isCreateFromLoanBill ? "+ FInterest " : "+ FCautionAmt ").append(" where fid = ?");
                    DbUtil.execute((Context)ctx, (String)sb.toString(), (Object[])new Object[]{srcId});
                }
            }
        }
        IBOTRelation iBotRelation = BOTRelationFactory.getLocalInstance((Context)ctx);
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("destObjectId", (Object)paymentBillInfo.getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("srcENTITYID", (Object)new LoanInterestInfo().getBOSType().toString()));
        evi.setFilter(filter);
        BOTRelationCollection botCol = iBotRelation.getCollection(evi);
        String interestSql = "update T_FIN_LoanInterest set FIsGenPayBill=0 where fid=?";
        for (int i = 0; i < botCol.size(); ++i) {
            BOTRelationInfo botInfo = botCol.get(i);
            DbUtil.execute((Context)ctx, (String)interestSql, (Object[])new Object[]{botInfo.getSrcObjectID()});
            iBotRelation.delete((IObjectPK)new ObjectUuidPK(botInfo.getId()));
        }
    }
}

