/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fin;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.bot.BOTRelationCollection;
import com.kingdee.bos.metadata.bot.BOTRelationFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.util.MetaDataLoader;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.fm.common.EJBAccessFactory;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.ctl.BankFactorFactory;
import com.kingdee.eas.fm.ctl.BankFactorInfo;
import com.kingdee.eas.fm.ctl.IBankFactor;
import com.kingdee.eas.fm.fin.CreditLimitEntryCollection;
import com.kingdee.eas.fm.fin.CreditLimitEntryInfo;
import com.kingdee.eas.fm.fin.CreditLimitFactory;
import com.kingdee.eas.fm.fin.CreditLimitInfo;
import com.kingdee.eas.fm.fin.CreditLimitStatusEnum;
import com.kingdee.eas.fm.fin.CreditLimitUsedCollection;
import com.kingdee.eas.fm.fin.CreditLimitUsedInfo;
import com.kingdee.eas.fm.fin.DeferReturnCLEntryCollection;
import com.kingdee.eas.fm.fin.DeferReturnCLEntryInfo;
import com.kingdee.eas.fm.fin.FinBizException;
import com.kingdee.eas.fm.fin.FinUtils;
import com.kingdee.eas.fm.fin.FinancingBillInfo;
import com.kingdee.eas.fm.fin.GuaranteeDetailInfo;
import com.kingdee.eas.fm.fin.GuaranteeTypePropertyEnum;
import com.kingdee.eas.fm.fin.LetterOfCreditFactory;
import com.kingdee.eas.fm.fin.LetterOfCreditInfo;
import com.kingdee.eas.fm.fin.LimitPropertyEnum;
import com.kingdee.eas.fm.fin.LimitTypeEnum;
import com.kingdee.eas.fm.fin.LoanFactory;
import com.kingdee.eas.fm.fin.LoanInfo;
import com.kingdee.eas.fm.fin.MortgageTypeEnum;
import com.kingdee.eas.fm.fin.RepaymentCollection;
import com.kingdee.eas.fm.fin.RepaymentFactory;
import com.kingdee.eas.fm.fin.RepaymentInfo;
import com.kingdee.eas.fm.fin.ShareTypeEnum;
import com.kingdee.eas.fm.fin.app.CreditLimitManagerByFinancingProduct;
import com.kingdee.eas.fm.fin.app.CreditLimitManagerHelper;
import com.kingdee.eas.fm.nt.PayableBillInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class ReverseBill {
    public static int Action_AddNew = 0;
    public static int Action_Remove = 2;
    private static ReverseBill reverseBill = null;

    public static ReverseBill newInstance() {
        if (reverseBill == null) {
            return new ReverseBill();
        }
        return reverseBill;
    }

    public static ReverseBill getInstance() {
        return new ReverseBill();
    }

    public static ReverseBill getInstance(BOSUuid sourceBillId) {
        return new ReverseBill();
    }

    public void updateReturnedQuota(Context ctx, FinancingBillInfo finBillInfo, boolean isReturned) throws BOSException, EASBizException {
        if (finBillInfo.getCreditLimit() == null || LimitPropertyEnum.FIXED_AMOUNT.equals((Object)finBillInfo.getCreditLimit().getProperty())) {
            return;
        }
        BigDecimal Quotas = this.getQuotasByRepayment(ctx, finBillInfo);
        BigDecimal returnQuota = finBillInfo.getCreditLocalAmt().subtract(Quotas);
        if (returnQuota.compareTo(Constants.ZERO) == 0) {
            return;
        }
        if (!isReturned) {
            this.checkAmount(ctx, finBillInfo, returnQuota);
            returnQuota = returnQuota.negate();
        }
        if (finBillInfo.getCreditLimit().getCreditUsage().isColligateCredit() && finBillInfo.getCreditLimit().getShareType() == ShareTypeEnum.ASSIGN && !LimitTypeEnum.BILLPOOL_LIMIT.equals((Object)finBillInfo.getCreditLimit().getLimitType())) {
            CreditLimitManagerByFinancingProduct manager = new CreditLimitManagerByFinancingProduct();
            manager.updateLimitByFinancingProduct(ctx, finBillInfo, null, returnQuota, isReturned, false);
            if (!isReturned && Quotas.compareTo(Constants.ZERO) > 0) {
                RepaymentCollection repaymentCol = this.getRepaymentCol(ctx, finBillInfo);
                int size = repaymentCol.size();
                for (int i = 0; i < size; ++i) {
                    if (!this.isReturnedQuota(finBillInfo, repaymentCol.get(i))) continue;
                    manager.updateLimitByFinancingProduct(ctx, finBillInfo, repaymentCol.get(i), returnQuota, isReturned, true);
                }
            }
        } else {
            this.updateCreditLimitInfo(ctx, finBillInfo, returnQuota);
            this.updateCreditLimitUsed(ctx, finBillInfo, returnQuota);
        }
    }

    private boolean isReturnedQuota(FinancingBillInfo finBillInfo, RepaymentInfo repaymentInfo) {
        Set<String> idSet = this.getRepaymentIdsFromLetterOfCredit(finBillInfo);
        return repaymentInfo.getReturnedQuota().compareTo(Constants.ZERO) > 0 && !idSet.contains(repaymentInfo.getId().toString());
    }

    private void checkAmount(Context ctx, FinancingBillInfo finBillInfo, BigDecimal amount) throws EASBizException, BOSException {
        CreditLimitEntryCollection shareEntry = FinUtils.getOrgEntryByCompany(ctx, finBillInfo.getCreditLimit(), finBillInfo.getCompany().getId());
        if (EmptyUtil.isEmpty((AbstractObjectCollection)shareEntry)) {
            return;
        }
        ShareTypeEnum shareType = finBillInfo.getCreditLimit().getShareType();
        BigDecimal balance = Constants.ZERO;
        if (shareType.equals((Object)ShareTypeEnum.ASSIGN)) {
            balance = shareEntry.get(0).getBanlance();
            if (finBillInfo.getCreditLimit().getCreditUsage().isColligateCredit()) {
                balance = this.getEntryBalances(shareEntry, finBillInfo.getCompany().getId().toString());
            }
        } else {
            balance = finBillInfo.getCreditLimit().getBalance();
        }
        if (balance.compareTo(Constants.ZERO) < 0 || amount.compareTo(balance) > 0) {
            throw new FinBizException(FinBizException.CREDITLIMITAMOUNTFULLFILL);
        }
    }

    private BigDecimal getEntryBalances(CreditLimitEntryCollection entryColl, String companyId) throws EASBizException {
        CreditLimitEntryInfo entryInfo = null;
        BigDecimal balances = Constants.ZERO;
        int size = entryColl.size();
        for (int i = 0; i < size; ++i) {
            entryInfo = entryColl.get(i);
            if (!this.isSameCompany(entryInfo, companyId)) continue;
            balances = balances.add(entryInfo.getBanlance());
        }
        return balances;
    }

    private boolean isSameCompany(CreditLimitEntryInfo entryInfo, String companyId) {
        return companyId.equals(entryInfo.getShareOrg().getId().toString());
    }

    protected BigDecimal getQuotasByRepayment(Context ctx, FinancingBillInfo finBillInfo) throws BOSException, EASBizException {
        Set<String> set = this.getRepaymentIdsFromLetterOfCredit(finBillInfo);
        BigDecimal sumReturnedQuota = Constants.ZERO;
        RepaymentCollection repayCol = this.getRepaymentCol(ctx, finBillInfo);
        RepaymentInfo repayInfo = null;
        int size = repayCol.size();
        for (int i = 0; i < size; ++i) {
            repayInfo = repayCol.get(i);
            if (set.contains(repayInfo.getId().toString())) continue;
            sumReturnedQuota = sumReturnedQuota.add(repayInfo.getReturnedQuota());
        }
        return sumReturnedQuota;
    }

    private Set<String> getRepaymentIdsFromLetterOfCredit(FinancingBillInfo finBillInfo) {
        LetterOfCreditInfo locInfo;
        HashSet<String> idSet = new HashSet<String>();
        if (finBillInfo instanceof LetterOfCreditInfo && (locInfo = (LetterOfCreditInfo)finBillInfo).getDeferReturnCreditLimitDays() != 0) {
            DeferReturnCLEntryInfo entryInfo = null;
            DeferReturnCLEntryCollection deferCol = locInfo.getDeferReturnCLEntrys();
            int size = deferCol.size();
            for (int i = 0; i < size; ++i) {
                entryInfo = deferCol.get(i);
                if (entryInfo.isIsReturnedCL()) continue;
                idSet.add(entryInfo.getRepayment().getId().toString());
            }
        }
        return idSet;
    }

    protected RepaymentCollection getRepaymentCol(Context ctx, FinancingBillInfo finBillInfo) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.appendFilterItem("sourceBillId", (Object)finBillInfo.getId().toString());
        view.setFilter(filter);
        RepaymentCollection repayCol = RepaymentFactory.getLocalInstance(ctx).getRepaymentCollection(view);
        return repayCol;
    }

    private void updateCreditLimitInfo(Context ctx, FinancingBillInfo finBillInfo, BigDecimal amount) throws BOSException, EASBizException {
        String hsql = "UPDATE T_FIN_CreditLimit SET FBalance=FBalance+?, FUsedAmount=FUsedAmount-? WHERE FID = ?";
        DbUtil.execute((Context)ctx, (String)hsql, (Object[])new Object[]{amount, amount, finBillInfo.getCreditLimit().getId().toString()});
        CreditLimitEntryInfo shareEntry = FinUtils.getOrgEntry(ctx, finBillInfo.getCreditLimit(), finBillInfo.getCompany().getId());
        String dsql = "UPDATE T_FIN_CreditLimitEntry SET FBanlance=FBanlance+? WHERE FID = ?";
        DbUtil.execute((Context)ctx, (String)dsql, (Object[])new Object[]{amount, shareEntry.getId().toString()});
        CreditLimitStatusEnum creditStatus = CreditLimitManagerHelper.getCreditLimitStatus((Context)ctx, (String)finBillInfo.getCreditLimit().getId().toString());
        String ssql = "UPDATE T_FIN_CreditLimit SET FCreditLimitStat = ? WHERE FID = ?";
        DbUtil.execute((Context)ctx, (String)ssql, (Object[])new Object[]{new Integer(creditStatus.getValue()), finBillInfo.getCreditLimit().getId().toString()});
    }

    private void updateCreditLimitUsed(Context ctx, FinancingBillInfo finBillInfo, BigDecimal amount) throws BOSException {
        String sql = "update T_FIN_CreditLimitUsed set FReturnedQuota= FReturnedQuota+? where FBillId=?";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{amount, finBillInfo.getId().toString()});
    }

    public void updateReturnedQuota(Context ctx, int actiontype, RepaymentInfo repaymentInfo, FinancingBillInfo finBillInfo, CreditLimitUsedCollection usedCollection) throws BOSException, EASBizException {
        if (actiontype == Action_AddNew) {
            if (repaymentInfo.getCreditLimit() != null && repaymentInfo.getAmount().compareTo(SysConstant.BIGZERO) == 1) {
                this.updateReturnedQuota(ctx, finBillInfo, repaymentInfo.getReturnedQuota(), repaymentInfo, actiontype, usedCollection);
            }
        } else {
            BigDecimal marginRepay;
            if (repaymentInfo.getCreditLimit() != null) {
                this.updateReturnedQuota(ctx, finBillInfo, repaymentInfo.getReturnedQuota().negate(), repaymentInfo, actiontype, usedCollection);
            }
            if (finBillInfo.getId().getType().equals((Object)LetterOfCreditInfo.BOSTYPE) && (marginRepay = repaymentInfo.getCautionAmt()) != null) {
                String sq = "update T_FIN_LetterOfCredit set FMarginBalance=FMarginBalance+? where fid=?";
                DbUtil.execute((Context)ctx, (String)sq, (Object[])new Object[]{marginRepay, finBillInfo.getId().toString()});
            }
        }
    }

    private void updateReturnedQuota(Context ctx, FinancingBillInfo finBillInfo, BigDecimal orgAmount, RepaymentInfo repaymentInfo, int actiontype, CreditLimitUsedCollection usedCol2) throws BOSException, EASBizException {
        CreditLimitInfo creditLimitInfo = this.getCreditLimitInfo(ctx, finBillInfo.getId());
        if (creditLimitInfo != null && creditLimitInfo.getProperty().equals((Object)LimitPropertyEnum.REVOLVING_AMOUNT)) {
            if (finBillInfo.getCreditLimit().getCreditUsage().isColligateCredit() && finBillInfo.getCreditLimit().getShareType() == ShareTypeEnum.ASSIGN) {
                CreditLimitUsedCollection usedCollection = this.getUsedCollection(ctx, finBillInfo, repaymentInfo, actiontype, usedCol2);
                String sql = "update T_FIN_CreditLimitUsed set FReturnedQuota= FReturnedQuota+? where FBillId=? and  FFinProID = ? and FCompanyID = ? and fcreditlimitid = ?";
                if (usedCollection != null) {
                    for (int i = 0; i < usedCollection.size(); ++i) {
                        CreditLimitUsedInfo usedInfo = usedCollection.get(i);
                        BigDecimal returnedQuota = usedInfo.getUsedQuota();
                        if (actiontype == Action_AddNew) {
                            returnedQuota = returnedQuota.negate();
                        }
                        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{returnedQuota, finBillInfo.getId().toString(), usedInfo.getFinPro().getId().toString(), usedInfo.getCompany().getId().toString(), creditLimitInfo.getId().toString()});
                    }
                }
            } else {
                String sql = "update T_FIN_CreditLimitUsed set FReturnedQuota= FReturnedQuota+? where FBillId=?";
                DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{orgAmount, finBillInfo.getId().toString()});
            }
        }
    }

    private CreditLimitInfo getCreditLimitInfo(Context ctx, BOSUuid finBillId) throws BOSException, EASBizException {
        String clId = this.getCreditLimitId(ctx, finBillId);
        if (clId == null) {
            return null;
        }
        return CreditLimitFactory.getLocalInstance(ctx).getCreditLimitInfo((IObjectPK)new ObjectUuidPK(clId));
    }

    private String getCreditLimitId(Context ctx, BOSUuid finBillId) throws BOSException {
        String tableName = EJBAccessFactory.createLocalInstance((Context)ctx).getEntityTableName(finBillId.getType());
        StringBuffer sb = new StringBuffer();
        sb.append("select FCreditLimitId from ").append(tableName).append("\n");
        sb.append("where FID=?");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString(), (Object[])new Object[]{finBillId.toString()});
        try {
            if (rs.next()) {
                return rs.getString("FCreditLimitId");
            }
            return null;
        }
        catch (SQLException e) {
            throw FMHelper.toBOSException((Throwable)e);
        }
    }

    private CreditLimitUsedCollection getUsedCollection(Context ctx, FinancingBillInfo finBillInfo, RepaymentInfo repaymentInfo, int actiontype, CreditLimitUsedCollection usedCol2) throws EASBizException, BOSException {
        CreditLimitUsedCollection usedCollection = null;
        usedCollection = actiontype == Action_AddNew ? CreditLimitManagerHelper.getUsedCol((Context)ctx, (BOSUuid)repaymentInfo.getId(), (CreditLimitInfo)finBillInfo.getCreditLimit()) : usedCol2;
        return usedCollection;
    }

    public void updateSrcBalance(Context ctx, int actiontype, RepaymentInfo repaymentInfo, FinancingBillInfo finBillInfo) throws BOSException, EASBizException {
        if (actiontype == Action_AddNew) {
            this.updateSrcBillBalance(ctx, finBillInfo.getId(), repaymentInfo);
        } else {
            BOSUuid sourceBill = BOSUuid.read((String)repaymentInfo.getSourceBillId());
            this.updateBanalce4Remove(ctx, sourceBill, repaymentInfo);
        }
    }

    private void updateSrcBillBalance(Context ctx, BOSUuid finBillId, RepaymentInfo repaymentInfo) throws BOSException, EASBizException {
        String finTableName = MetaDataLoader.getEntity((Context)ctx, (BOSObjectType)finBillId.getType()).getTable().getName();
        BigDecimal repaymentAmount = repaymentInfo.getAmount();
        if (finBillId.getType().equals((Object)new PayableBillInfo().getBOSType())) {
            String sql1 = "update " + finTableName + " set FBillLastState= fbillstate,FLastTransferDate=FTransferDate,fbalance= fbalance-?,FTransferDate=?,fbillstate=1 ,FRepaymentDate = ?  where fid=?";
            DbUtil.execute((Context)ctx, (String)sql1, (Object[])new Object[]{repaymentAmount, repaymentInfo.getBizDate(), repaymentInfo.getBizDate(), finBillId.toString()});
            String sql2 = "update t_fin_guaranteedetail set fbalance= 0 where FParentBillId=? and fbilltype=?";
            DbUtil.execute((Context)ctx, (String)sql2, (Object[])new Object[]{finBillId.toString(), new Integer(2)});
        } else if (finBillId.getType().equals((Object)LoanInfo.BOSTYPE)) {
            String sql = "update " + finTableName + " set fbalance= fbalance-?,fcautionAmtRepay = fcautionAmtRepay+? where fid=?";
            DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{repaymentAmount, repaymentInfo.getCautionAmt(), finBillId.toString()});
            String sql4BF = "update T_CTL_BankFactor set FLoanBalance=FLoanBalance - ? where FID = ?";
            String sqlUpdataIsMortgage = "update T_CTL_BankFactor set FIsCancel=1 where FID = ? and FLoanBalance = 0";
            String sqlUpdateAssureAmount = "update T_NT_AssureAmount set FAssureState=2 where FSourceBillID = (select FID from T_CTL_BankFactor where FID = ? and FLoanBalance = 0)";
            LoanInfo info = LoanFactory.getLocalInstance(ctx).getLoanInfo((IObjectPK)new ObjectUuidPK(finBillId));
            IBankFactor localInstance = BankFactorFactory.getLocalInstance((Context)ctx);
            Iterator iter = info.getGuaranteeEntrys().iterator();
            while (iter.hasNext()) {
                BankFactorInfo backFactor;
                GuaranteeDetailInfo element = (GuaranteeDetailInfo)iter.next();
                if (!element.getGuaranteeTypeProperty().equals((Object)GuaranteeTypePropertyEnum.pledge) || !MortgageTypeEnum.Receivable.equals((Object)element.getMortgageType()) || element.getBillId() == null || (backFactor = localInstance.getBankFactorInfo((IObjectPK)new ObjectUuidPK(element.getBillId()))) == null) continue;
                DbUtil.execute((Context)ctx, (String)sql4BF, (Object[])new Object[]{repaymentAmount, backFactor.getId().toString()});
                DbUtil.execute((Context)ctx, (String)sqlUpdataIsMortgage, (Object[])new Object[]{backFactor.getId().toString()});
                DbUtil.execute((Context)ctx, (String)sqlUpdateAssureAmount, (Object[])new Object[]{backFactor.getId().toString()});
            }
        } else if (finBillId.getType().equals((Object)LetterOfCreditInfo.BOSTYPE)) {
            BigDecimal marginRepay = repaymentInfo.getCautionAmt();
            LetterOfCreditInfo tempInfo = (LetterOfCreditInfo)LetterOfCreditFactory.getLocalInstance(ctx).getBillBaseInfo((IObjectPK)new ObjectUuidPK(finBillId.toString()), this.getLetterOfCreditSelectors());
            BigDecimal tmpValue = Constants.ZERO;
            if (FMHelper.subtract((BigDecimal)tempInfo.getMarginBalance(), (BigDecimal)marginRepay).compareTo(Constants.ZERO) >= 0) {
                tmpValue = FMHelper.subtract((BigDecimal)tempInfo.getMarginBalance(), (BigDecimal)marginRepay);
            }
            if (marginRepay != null) {
                String sql1 = "update " + finTableName + " set FMarginBalance=? where fid=?";
                DbUtil.execute((Context)ctx, (String)sql1, (Object[])new Object[]{tmpValue, finBillId.toString()});
            }
            tmpValue = Constants.ZERO;
            if (FMHelper.subtract((BigDecimal)tempInfo.getBalance(), (BigDecimal)repaymentAmount).compareTo(Constants.ZERO) >= 0) {
                tmpValue = FMHelper.subtract((BigDecimal)tempInfo.getBalance(), (BigDecimal)repaymentAmount);
            }
            String sql2 = "update " + finTableName + " set fbalance= ? where fid=?";
            DbUtil.execute((Context)ctx, (String)sql2, (Object[])new Object[]{tmpValue, finBillId.toString()});
        } else {
            String sql = "update " + finTableName + " set fbalance= fbalance-? where fid=?";
            DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{repaymentAmount, finBillId.toString()});
        }
    }

    private SelectorItemCollection getLetterOfCreditSelectors() {
        SelectorItemCollection selectors = new SelectorItemCollection();
        selectors.add(new SelectorItemInfo("ID"));
        selectors.add(new SelectorItemInfo("IsDYZ"));
        selectors.add(new SelectorItemInfo("MarginBalance"));
        selectors.add(new SelectorItemInfo("balance"));
        return selectors;
    }

    private void updateBanalce4Remove(Context ctx, BOSUuid finBillId, RepaymentInfo repaymentInfo) throws BOSException, EASBizException {
        BigDecimal amount = repaymentInfo.getAmount();
        BigDecimal cautionAmt = repaymentInfo.getCautionAmt();
        String tableName = MetaDataLoader.getEntity((Context)ctx, (BOSObjectType)finBillId.getType()).getTable().getName();
        if (finBillId.getType().equals((Object)new PayableBillInfo().getBOSType())) {
            String sql = "update " + tableName + " set fbalance= fbalance+?,fbillstate=FBillLastState,FTransferDate=FLastTransferDate ,FRepaymentDate =null where fid=?";
            DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{amount, finBillId.toString()});
        } else if (finBillId.getType().equals((Object)LoanInfo.BOSTYPE)) {
            String sql1 = "update " + tableName + " set fbalance= fbalance+?, fcautionAmtRepay = fcautionAmtRepay-? where fid=?";
            DbUtil.execute((Context)ctx, (String)sql1, (Object[])new Object[]{amount, repaymentInfo.getCautionAmt(), finBillId.toString()});
            LoanInfo loanInfo = LoanFactory.getLocalInstance(ctx).getLoanInfo((IObjectPK)new ObjectUuidPK(finBillId));
            IBankFactor iBankFactor = BankFactorFactory.getLocalInstance((Context)ctx);
            String sql2 = "update T_CTL_BankFactor set FLoanBalance=FLoanBalance + ? where FID = ?";
            Iterator iter = loanInfo.getGuaranteeEntrys().iterator();
            while (iter.hasNext()) {
                BankFactorInfo bankFactorInfo;
                GuaranteeDetailInfo guaranteeDetailInfo = (GuaranteeDetailInfo)iter.next();
                if (!guaranteeDetailInfo.getGuaranteeTypeProperty().equals((Object)GuaranteeTypePropertyEnum.pledge) || !MortgageTypeEnum.Receivable.equals((Object)guaranteeDetailInfo.getMortgageType()) || guaranteeDetailInfo.getBillId() == null || (bankFactorInfo = iBankFactor.getBankFactorInfo((IObjectPK)new ObjectUuidPK(guaranteeDetailInfo.getBillId()))) == null) continue;
                DbUtil.execute((Context)ctx, (String)sql2, (Object[])new Object[]{amount, bankFactorInfo.getId().toString()});
            }
        } else if (finBillId.getType().equals((Object)new LetterOfCreditInfo().getBOSType())) {
            LetterOfCreditInfo letterOfCreditInfo = LetterOfCreditFactory.getLocalInstance(ctx).getLetterOfCreditInfo((IObjectPK)new ObjectUuidPK(finBillId));
            if (letterOfCreditInfo.isIsDYZ()) {
                String sql;
                BOTRelationCollection bot = this.getBOTRelationCollection(ctx, finBillId);
                HashSet<String> repaymentIds = new HashSet<String>();
                for (int i = 0; i < bot.size(); ++i) {
                    if (bot.get(i).getDestObjectID().equals(repaymentInfo.getId().toString())) continue;
                    repaymentIds.add(bot.get(i).getDestObjectID());
                }
                BigDecimal total = new BigDecimal("0.0");
                for (String repaymentId : repaymentIds) {
                    RepaymentInfo repaymentinfo = RepaymentFactory.getLocalInstance(ctx).getRepaymentInfo((IObjectPK)new ObjectUuidPK(repaymentId));
                    total = total.add(repaymentinfo.getAmount());
                }
                if (total.add(repaymentInfo.getAmount()).compareTo(letterOfCreditInfo.getAmount()) >= 0) {
                    sql = "update " + tableName + " set fbalance= ?, fmarginBalance = fmarginBalance + ?  where fid=?";
                    if (total.compareTo(letterOfCreditInfo.getAmount()) >= 0) {
                        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{BigDecimal.ZERO, cautionAmt, finBillId.toString()});
                    } else {
                        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{letterOfCreditInfo.getAmount().subtract(total), cautionAmt, finBillId.toString()});
                    }
                } else {
                    sql = "update " + tableName + " set fbalance= fbalance+?, fmarginBalance = fmarginBalance + ?  where fid=?";
                    DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{amount, cautionAmt, finBillId.toString()});
                }
            } else {
                String sql = "update " + tableName + " set fbalance = fbalance + ?, FMarginBalance = FMarginBalance + ? where fid=?";
                DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{amount, cautionAmt, finBillId.toString()});
            }
        } else {
            String sql = "update " + tableName + " set fbalance= fbalance+? where fid=?";
            DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{amount, finBillId.toString()});
        }
    }

    private BOTRelationCollection getBOTRelationCollection(Context ctx, BOSUuid sourceBillId) throws BOSException {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("srcentityid", (Object)new LetterOfCreditInfo().getBOSType().toString()));
        filterInfo.getFilterItems().add(new FilterItemInfo("destentityid", (Object)new RepaymentInfo().getBOSType().toString()));
        filterInfo.getFilterItems().add(new FilterItemInfo("srcobjectid", (Object)sourceBillId.toString()));
        evi.setFilter(filterInfo);
        BOTRelationCollection relationCollection = BOTRelationFactory.getLocalInstance((Context)ctx).getCollection(evi);
        return relationCollection;
    }
}

