/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fin.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.common.client.FMFilterBaseUI;
import com.kingdee.eas.fm.fin.IsOrNoEnum;
import com.kingdee.eas.fm.fin.LoanAdjustInterestFactory;
import com.kingdee.eas.fm.fin.LoanAdjustInterestInfo;
import com.kingdee.eas.fm.fin.client.AbstractBondAdjustInterestListUI;
import com.kingdee.eas.fm.fin.client.BondAdjusitInterestFilterUI;
import com.kingdee.eas.fm.fin.client.BondAdjustInterestEditUI;
import com.kingdee.eas.fm.fin.client.BondAdjustInterestUI;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.client.service.LicenseService;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class BondAdjustInterestListUI
extends AbstractBondAdjustInterestListUI {
    private static final Logger logger = CoreUIObject.getLogger(BondAdjustInterestListUI.class);
    private CompanyOrgUnitInfo currentCompany;
    private BondAdjusitInterestFilterUI filterUI = null;
    private LicenseService licenseService = new LicenseService((IUIObject)this);
    private Set setIDs;
    private Map hm = null;

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String keyValue = this.getSelectedKeyValue();
        if (keyValue == null) {
            return;
        }
        LoanAdjustInterestInfo info = LoanAdjustInterestFactory.getRemoteInstance().getLoanAdjustInterestInfo((IObjectPK)new ObjectUuidPK(keyValue));
        if (info.getIsUsed().equals((Object)IsOrNoEnum.IS)) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"265_LoanAdjustInterestListUI"));
            this.abort();
        }
        super.actionEdit_actionPerformed(e);
    }

    protected void tblMain_tableSelectChanged(KDTSelectEvent e) throws Exception {
        super.tblMain_tableSelectChanged(e);
        ArrayList idList = this.getSelectedIdValues();
        if (idList.size() == 0 || idList == null) {
            return;
        }
        if (idList.size() > 1) {
            this.actionRemove.setEnabled(false);
        } else {
            this.actionRemove.setEnabled(true);
        }
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String keyValue = this.getSelectedKeyValue();
        if (keyValue == null) {
            return;
        }
        LoanAdjustInterestInfo info = LoanAdjustInterestFactory.getRemoteInstance().getLoanAdjustInterestInfo((IObjectPK)new ObjectUuidPK(keyValue));
        if (info.getIsUsed().equals((Object)IsOrNoEnum.IS)) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"266_LoanAdjustInterestListUI"));
            this.abort();
        }
        Integer maxSeq = LoanAdjustInterestFactory.getRemoteInstance().getMaxSeq((IObjectPK)new ObjectUuidPK(info.getLoan().getId().toString()));
        if (info.getAdjustSeq() + 1 != maxSeq) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"267_LoanAdjustInterestListUI"));
            this.abort();
        }
        super.actionRemove_actionPerformed(e);
    }

    public BondAdjustInterestListUI() throws Exception {
        this.currentCompany = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        this.tblMain.getDataRequestManager().addDataFillListener((KDTDataFillListener)new FillListener());
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public FMFilterBaseUI getFilterUI() throws Exception {
        if (this.filterUI == null) {
            this.filterUI = new BondAdjusitInterestFilterUI();
        }
        return this.filterUI;
    }

    public void onLoad() throws Exception {
        String uiParam = (String)this.getUIContext().get("UIClassParam");
        if (this.getBOTPViewStatus() != 1) {
            this.licenseService.checkLicence();
            if (uiParam.equals("ADJUSTINTERESTUI")) {
                this.hm = BondAdjustInterestUI.showBondAdjustInterestUI((CoreUI)this);
                this.setIDs = (Set)this.hm.get("createdIdSet");
                this.getUIContext().put("BTPCreateMode", "1");
                if (EmptyUtil.isEmpty((Collection)this.setIDs)) {
                    SysUtil.abort();
                }
            }
        }
        super.onLoad();
        this.CheckBizUnit();
        IColumn adjustSeqColumn = this.tblMain.getColumn("adjustSeq");
        adjustSeqColumn.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        IColumn yearDaysColumn = this.tblMain.getColumn("yearDays");
        yearDaysColumn.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        IColumn adjustAfterRateColumn = this.tblMain.getColumn("adjustAfterRate");
        adjustAfterRateColumn.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.actionAuditResult.setEnabled(false);
        this.actionAuditResult.setVisible(false);
        this.tblMain.getColumn("adjustDate").getStyleAttributes().setNumberFormat(this.dformat);
    }

    protected void CheckBizUnit() throws EASBizException, BOSException {
        if (ContextHelperFactory.getRemoteInstance().isOnlyUnion(this.currentCompany)) {
            this.actionAddNew.setVisible(false);
            this.actionEdit.setVisible(false);
            this.actionRemove.setVisible(false);
            this.actionAdjust.setVisible(false);
        }
    }

    protected String getEditUIName() {
        return BondAdjustInterestEditUI.class.getName();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return LoanAdjustInterestFactory.getRemoteInstance();
    }

    protected void execQuery() {
        if (this.setIDs != null) {
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)this.setIDs, CompareType.INCLUDE));
            this.mainQuery.setFilter(filter);
        }
        super.execQuery();
        this.setIDs = null;
    }

    protected FilterInfo getDefaultFilterForQuery() {
        FilterInfo filter = null;
        if (this.setIDs == null) {
            filter = super.getDefaultFilterForQuery();
        } else {
            filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)this.setIDs, CompareType.INCLUDE));
        }
        return filter;
    }

    @Override
    public void actionAdjust_actionPerformed(ActionEvent e) throws Exception {
        this.hm = BondAdjustInterestUI.showBondAdjustInterestUI((CoreUI)this);
        this.setIDs = (Set)this.hm.get("createdIdSet");
        if (this.setIDs != null) {
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)this.setIDs, CompareType.INCLUDE));
            this.mainQuery.setFilter(filter);
            this.refresh(e);
        }
    }

    public void setListUITable(KDTable tblMain, KDTDataRequestEvent e) {
        IRow row = null;
        if (e == null) {
            return;
        }
        for (int i = e.getFirstRow(); i <= e.getLastRow(); ++i) {
            String rateExpression;
            row = tblMain.getRow(i);
            if (row.getCell("intRateTypeExpression").getValue() == null || (rateExpression = row.getCell("intRateTypeExpression").getValue().toString()) == null) continue;
            if (rateExpression.equals(EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"480_CompDepositAccountBillListUI"))) {
                row.getCell("adjustAfterRate").getStyleAttributes().setNumberFormat("###,##0.00000000\\%");
                continue;
            }
            row.getCell("adjustAfterRate").getStyleAttributes().setNumberFormat("###,##0.00000000\\\u2030");
        }
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.actionAdjust.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_budgetadjust"));
    }

    public boolean destroyWindow() {
        try {
            this.licenseService.releaseLicense();
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return super.destroyWindow();
    }

    private final class FillListener
    implements KDTDataFillListener {
        private FillListener() {
        }

        public void afterDataFill(KDTDataRequestEvent e) {
            BondAdjustInterestListUI.this.setListUITable(BondAdjustInterestListUI.this.tblMain, e);
        }
    }
}

