/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fin.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.KDNoteHelper;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.base.btp.BTPException;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.BOTPUtil;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fm.common.AccessHelper;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.SumBillEnum;
import com.kingdee.eas.fm.common.SumFiledsInfo;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMFilterBaseUI;
import com.kingdee.eas.fm.fin.BondApplyBillFacaedFactory;
import com.kingdee.eas.fm.fin.FinancingResultEnum;
import com.kingdee.eas.fm.fin.ILoanApplyBill;
import com.kingdee.eas.fm.fin.LoanApplyBillCollection;
import com.kingdee.eas.fm.fin.LoanApplyBillFacadeFactory;
import com.kingdee.eas.fm.fin.LoanApplyBillFactory;
import com.kingdee.eas.fm.fin.LoanApplyBillInfo;
import com.kingdee.eas.fm.fin.LoanApplyBillStatusEnum;
import com.kingdee.eas.fm.fin.LoanContractInfo;
import com.kingdee.eas.fm.fin.LoanInfo;
import com.kingdee.eas.fm.fin.client.AbstractBondApplyBillListUI;
import com.kingdee.eas.fm.fin.client.BondApplyBillDataProvider;
import com.kingdee.eas.fm.fin.client.BondApplyBillEditUI;
import com.kingdee.eas.fm.fin.client.BondApplyBillFilterParam;
import com.kingdee.eas.fm.fin.client.BondApplyBillFilterUI;
import com.kingdee.eas.fm.fin.client.BondClientHelper;
import com.kingdee.eas.fm.fin.client.ChangeFinResultUI;
import com.kingdee.eas.framework.CoreBillBaseCollection;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.CoreBillListUI;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.util.AbortException;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class BondApplyBillListUI
extends AbstractBondApplyBillListUI {
    private static final Logger logger = CoreUIObject.getLogger(BondApplyBillListUI.class);
    private static final String RESOURCE_PATH = "com.kingdee.eas.fm.fin.client.LoanApplyClientResource";
    private BondApplyBillFilterUI filterUI;
    private static boolean FIN022 = false;
    FillListener fillListener = new FillListener();
    private static final String tdTemplateFile = "/FM/FIN/LOANAPPLYBILL";

    public boolean isNeedShowBOTPRule() {
        return true;
    }

    public void onLoad() throws Exception {
        FIN022 = ContextHelperFactory.getRemoteInstance().getBooleanParam("FIN022", (IObjectPK)new ObjectUuidPK(SysContext.getSysContext().getCurrentCtrlUnit().getId()));
        super.onLoad();
        this.actionViewBdgBalance.setVisible(true);
        this.actionViewBdgBalance.setEnabled(true);
        this.actionCreateTo.setEnabled(false);
        this.actionCopyTo.setVisible(false);
        this.btnTDPrint.setEnabled(true);
        this.btnTDPrintPreview.setEnabled(true);
        this.menuItemTDPrint.setEnabled(true);
        this.menuItemTDPrintPreview.setEnabled(true);
        this.tblMain.getColumn("applyDate").getStyleAttributes().setNumberFormat(this.dformat);
        this.tblMain.getColumn("effectiveDate").getStyleAttributes().setNumberFormat(this.dformat);
        this.tblMain.getColumn("maturityDate").getStyleAttributes().setNumberFormat(this.dformat);
    }

    public FilterInfo getFilterInfo() {
        CompanyOrgUnitInfo currentCompany = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("isBond", (Object)1));
        filter.getFilterItems().add(new FilterItemInfo("status", (Object)3));
        filter.getFilterItems().add(new FilterItemInfo("financingResult", (Object)0, CompareType.NOTEQUALS));
        filter.getFilterItems().add(new FilterItemInfo("isGenLoanBill", (Object)new Boolean(false)));
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)currentCompany.getId().toString()));
        return filter;
    }

    public SelectorItemCollection getSelectorsForViewBdgBalance() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("creator.*"));
        sic.add(new SelectorItemInfo("auditor.*"));
        sic.add(new SelectorItemInfo("usePayableCo.*"));
        sic.add(new SelectorItemInfo("provideCoAccount.*"));
        sic.add(new SelectorItemInfo("payBank.*"));
        sic.add(new SelectorItemInfo("receiverSp.*"));
        sic.add(new SelectorItemInfo("receiveCoAccount.*"));
        sic.add(new SelectorItemInfo("applayCompany.*"));
        sic.add(new SelectorItemInfo("noteType.*"));
        sic.add(new SelectorItemInfo("provideCo.*"));
        sic.add(new SelectorItemInfo("currency.*"));
        sic.add(new SelectorItemInfo("receiverCp.*"));
        sic.add(new SelectorItemInfo("receiveCoBank.*"));
        sic.add(new SelectorItemInfo("project.*"));
        sic.add(new SelectorItemInfo("fundFlowItem.*"));
        return sic;
    }

    public void actionViewBdgBalance_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String id = this.getSelectedKeyValue();
        LoanApplyBillInfo info = (LoanApplyBillInfo)((ILoanApplyBill)this.getBizInterface()).getValue((IObjectPK)new ObjectUuidPK(id), this.getSelectorsForViewBdgBalance());
        CompanyOrgUnitInfo company = SysContext.getSysContext().getCurrentFIUnit();
        info.setCompany(company);
        FMClientHelper.viewBgBalance((Component)((Object)this), (String)"com.kingdee.eas.fm.fin.app.LoanApplyBill", null, (IObjectValue)info);
    }

    protected void tblMain_tableSelectChanged(KDTSelectEvent e) throws Exception {
        super.tblMain_tableSelectChanged(e);
        this.changeBtnCreateToStatus();
    }

    private void changeBtnCreateToStatus() throws Exception {
        this.checkSelected();
        String id = this.getSelectedKeyValue();
        LoanApplyBillInfo info = (LoanApplyBillInfo)((ILoanApplyBill)this.getBizInterface()).getValue((IObjectPK)new ObjectUuidPK(id));
        if (info != null && !info.isIsGenLoanBill() && LoanApplyBillStatusEnum.AUDITED == info.getStatus() && 0 != info.getFinancingResult().getValue()) {
            this.actionCreateTo.setEnabled(true);
        } else {
            this.actionCreateTo.setEnabled(false);
        }
    }

    public IUIObject getInstance(Map uiContext) {
        try {
            return (IUIObject)Class.forName("com.kingdee.eas.fm.fin.client.BondApplyBillListUI").newInstance();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        return null;
    }

    public void actionCreateTo_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        LoanApplyBillInfo info = this.getSelectedInfo();
        if (info.isIsGenLoanOrgBill()) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"592_LoanApply"));
            this.abort();
        }
        String id = this.getSelectedKeyValue();
        IMutexServiceControl iMutex = MutexServiceControlFactory.getRemoteInstance();
        boolean resultRequest = iMutex.requestBizObjIDForUpdate(id);
        if (!resultRequest) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"512_BillLocked"));
            this.abort();
        }
        try {
            CtrlUnitInfo orgUnitInfo = SysContext.getSysContext().getCurrentCtrlUnit();
            if (FIN022) {
                BondClientHelper.generateDestBillWithCU(orgUnitInfo, (CoreBillListUI)this, LoanApplyBillInfo.BOSTYPE.toString(), LoanContractInfo.BOSTYPE.toString(), id);
            } else {
                BondClientHelper.generateDestBillWithCU(orgUnitInfo, (CoreBillListUI)this, LoanApplyBillInfo.BOSTYPE.toString(), LoanInfo.BOSTYPE.toString(), id);
            }
        }
        catch (Exception ex) {
            iMutex.releaseObjIDForUpdate(id);
            throw ex;
        }
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.actionAudit.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_audit"));
        this.actionAntiAudit.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_unaudit"));
        this.actionBatchSubmit.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_submit"));
        this.actionChangeResult.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_submit"));
        this.actionTDPrint.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_credenceprint"));
        this.actionTDPrintPreview.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_preview"));
    }

    protected String getEditUIName() {
        return BondApplyBillEditUI.class.getName();
    }

    protected String getEditUIModal() {
        return super.getEditUIModal();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return LoanApplyBillFactory.getRemoteInstance();
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        this.editCheck();
        super.actionEdit_actionPerformed(e);
    }

    private void editCheck() throws Exception {
        LoanApplyBillInfo info = this.getSelectedInfo();
        if (info.isIsGenLoanBill()) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"207_BondApplyBillListUI"));
            SysUtil.abort();
        }
        if (info.getStatus() == LoanApplyBillStatusEnum.AUDITED) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"204_BondApplyBillEditUI"));
            SysUtil.abort();
        }
    }

    private LoanApplyBillInfo getSelectedInfo() throws Exception {
        this.checkSelected();
        return LoanApplyBillFactory.getRemoteInstance().getLoanApplyBillInfo((IObjectPK)new ObjectUuidPK(this.getSelectedKeyValue()));
    }

    @Override
    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        HashSet IDs = new HashSet(this.getSelectedIdValues());
        List returnMsg = BondApplyBillFacaedFactory.getRemoteInstance().batchDelete(IDs);
        this.showMsg(returnMsg);
        this.refreshList();
    }

    public FMFilterBaseUI getFilterUI() throws Exception {
        if (this.filterUI == null) {
            this.filterUI = new BondApplyBillFilterUI();
        }
        return this.filterUI;
    }

    protected void initListener() {
        super.initListener();
        this.tblMain.getDataRequestManager().addDataFillListener((KDTDataFillListener)this.fillListener);
    }

    @Override
    public void actionAudit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        HashSet IDs = new HashSet(this.getSelectedIdValues());
        boolean idsInProcess = FMHelper.hasWFInstance(null, (List)this.getSelectedIdValues());
        if (idsInProcess) {
            this.actionMultiapprove_actionPerformed(e);
            return;
        }
        List returnMsg = BondApplyBillFacaedFactory.getRemoteInstance().batchAudit(IDs);
        this.showMsg(returnMsg);
        this.refreshList();
    }

    @Override
    public void actionAntiAudit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        HashSet IDs = new HashSet(this.getSelectedIdValues());
        this.checkCanAntiAduit(IDs);
        List returnMsg = BondApplyBillFacaedFactory.getRemoteInstance().batchAntiAudit(IDs);
        this.showMsg(returnMsg);
        this.refreshList();
    }

    private void checkCanAntiAduit(Set IDs) throws BTPException, BOSException {
        if (null != IDs && IDs.size() > 0) {
            for (Object id : IDs) {
                String idString = (String)id;
                Set destId = BOTPUtil.getDestBillIdSet(null, (String)idString);
                if (destId.size() <= 0) continue;
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.fin.client.FinClientResource", (String)"canAntiAudit"));
                this.abort();
            }
        }
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("customer.number"));
        sic.add(new SelectorItemInfo("financingOrg.number"));
        sic.add(new SelectorItemInfo("bank.bankAreaType"));
        sic.add(new SelectorItemInfo("bank.number"));
        sic.add(new SelectorItemInfo("accountBank.account.id"));
        sic.add(new SelectorItemInfo("accountBank.account.number"));
        sic.add(new SelectorItemInfo("accountBank.account.name"));
        sic.add(new SelectorItemInfo("accountBank.id"));
        sic.add(new SelectorItemInfo("accountBank.number"));
        sic.add(new SelectorItemInfo("accountBank.name"));
        sic.add(new SelectorItemInfo("finProduct.id"));
        sic.add(new SelectorItemInfo("finProduct.number"));
        sic.add(new SelectorItemInfo("finProduct.name"));
        sic.add(new SelectorItemInfo("finProduct.FinancingSource"));
        sic.add("bgItemID");
        sic.add("bgItemNumber");
        sic.add("bgItemName");
        return sic;
    }

    @Override
    public void actionBatchSubmit_actionPerformed(ActionEvent e) throws Exception {
        List returnMsg = new ArrayList();
        try {
            this.checkSelected();
            returnMsg = BondApplyBillFacaedFactory.getRemoteInstance().batchSubmit(new HashSet(this.getSelectedIdValues()));
        }
        catch (Exception ex) {
            if (!(ex instanceof AbortException)) {
                MsgBox.showWarning((Component)((Object)this), (String)ex.getMessage());
            }
            SysUtil.abort((Throwable)ex);
        }
        this.showMsg(returnMsg);
        this.refreshList();
    }

    @Override
    public void actionChangeResult_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList idList = this.getSelectedIdValues();
        Object row = null;
        HashSet<String> ids = new HashSet<String>();
        Boolean isGenLoanBill = null;
        int billstatus = 0;
        int finResult = 0;
        HashSet<Integer> results = new HashSet<Integer>();
        LoanApplyBillCollection loanApplyColl = LoanApplyBillFactory.getRemoteInstance().getLoanApplyBillCollection("select isGenLoanBill, status, financingResult where id in " + FMHelper.setTran2String(new HashSet(idList)));
        for (int i = 0; i < loanApplyColl.size(); ++i) {
            LoanApplyBillInfo loanApplyBillInfo = loanApplyColl.get(i);
            isGenLoanBill = loanApplyBillInfo.getBoolean("isGenLoanBill");
            billstatus = (Integer)loanApplyBillInfo.get("status");
            finResult = (Integer)loanApplyBillInfo.get("financingResult");
            if (isGenLoanBill.booleanValue() || 3 != billstatus) continue;
            ids.add(loanApplyBillInfo.get("id").toString());
            results.add(finResult);
        }
        if (results.size() > 1) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCE_PATH, (String)"msg001"));
            SysUtil.abort();
        } else if (results.size() == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"208_BondApplyBillListUI"));
            SysUtil.abort();
        } else {
            Map uiContext = this.getUIContext();
            uiContext.put("oldValue", FinancingResultEnum.getEnum(finResult));
            if (idList.size() == ids.size()) {
                FinancingResultEnum en = ChangeFinResultUI.showChangeFinResultUI((CoreUI)this, uiContext);
                if (en != null) {
                    LoanApplyBillFacadeFactory.getRemoteInstance().changeFinResult(ids, en);
                    this.refreshList();
                }
            } else {
                int result = MsgBox.showConfirm2New((Component)((Object)this), (String)EASResource.getString((String)RESOURCE_PATH, (String)"msg003"));
                if (result == 0) {
                    uiContext.put("oldValue", FinancingResultEnum.getEnum((Integer)results.toArray()[0]));
                    FinancingResultEnum en = ChangeFinResultUI.showChangeFinResultUI((CoreUI)this, uiContext);
                    if (en != null) {
                        LoanApplyBillFacadeFactory.getRemoteInstance().changeFinResult(ids, en);
                        this.refreshList();
                    }
                }
            }
        }
    }

    private void showMsg(List returnMsg) {
        String msg = this.getMsgFromList(returnMsg);
        MsgBox.showInfo((Component)((Object)this), (String)msg);
    }

    private String getMsgFromList(List returnMsg) {
        if (returnMsg.size() == 0) {
            return EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"209_BondApplyBillListUI");
        }
        StringBuffer sb = new StringBuffer("");
        for (int i = 0; i < returnMsg.size(); ++i) {
            sb.append(returnMsg.get(i).toString()).append("\n");
        }
        return sb.toString();
    }

    protected void execQuery() {
        super.execQuery();
        this.formatFootRow();
    }

    protected IRow appendFootRow() {
        IRow sumRow = super.appendFootRow();
        this.formatFootRow();
        return sumRow;
    }

    protected boolean isFootVisible() {
        return true;
    }

    protected void refresh(ActionEvent e) throws Exception {
        super.refresh(e);
        this.formatFootRow();
    }

    private void formatFootRow() {
        CompanyOrgUnitInfo company = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        try {
            BondApplyBillFilterParam param = (BondApplyBillFilterParam)this.getFilterUI().getParam();
            IRow row = this.tblMain.getFootManager().getFootRow(0);
            String curID = null;
            curID = param.getCurrencyInfo() == null ? company.getBaseCurrency().getId().toString() : AccessHelper.getId((Object)param.getCurrencyInfo());
            String[] columns = new SumFiledsInfo(SumBillEnum.LoanApply).getSumFileds();
            for (int i = 0; i < columns.length; ++i) {
                FMClientHelper.setNumberFormat((IRow)row, (String)columns[i], (String)curID);
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void actionTDPrint_actionPerformed(ActionEvent e) throws Exception {
        this.tdPrint(false);
    }

    @Override
    public void actionTDPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        this.tdPrint(true);
    }

    private void tdPrint(boolean isPreview) {
        this.checkSelected();
        ArrayList idList = super.getSelectedIdValues();
        if (idList == null || idList.size() == 0) {
            return;
        }
        BondApplyBillDataProvider data = new BondApplyBillDataProvider(idList, this.getTDQueryPK());
        KDNoteHelper appHlp = new KDNoteHelper();
        if (isPreview) {
            appHlp.printPreview(tdTemplateFile, (Object)data, (Component)SwingUtilities.getWindowAncestor((Component)((Object)this)));
        } else {
            appHlp.print(tdTemplateFile, (Object)data, (Component)SwingUtilities.getWindowAncestor((Component)((Object)this)));
        }
    }

    protected IMetaDataPK getTDQueryPK() {
        return new MetaDataPK("com.kingdee.eas.fm.fin.app.BondApplyBillQuery");
    }

    protected boolean isIgnoreBizUnit() {
        return false;
    }

    public List getDestBosTypeForBotp(CoreBillBaseCollection srcBillInfos, List destBosTypeList) {
        destBosTypeList.clear();
        LoanInfo info = new LoanInfo();
        String addBosType = info.getBOSType().toString();
        destBosTypeList.add(addBosType);
        return destBosTypeList;
    }

    private final class FillListener
    implements KDTDataFillListener {
        private FillListener() {
        }

        public void afterDataFill(KDTDataRequestEvent e) {
            this.fillTable(BondApplyBillListUI.this.tblMain, e);
        }

        private void fillTable(KDTable tblMain, KDTDataRequestEvent e) {
            IRow row = null;
            for (int i = e.getFirstRow(); i <= e.getLastRow(); ++i) {
                row = tblMain.getRow(i);
                Integer precesion = (Integer)row.getCell("currency.precision").getValue();
                this.setAmtCellNumberFormat(row, FMClientHelper.getNumberFtm((int)precesion));
                row.getCell("horizon").getStyleAttributes().setNumberFormat("%r{#,##0.0}f");
                row.getCell("horizon").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
                row.getCell("yearDays").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
                ICell yrc = row.getCell("yieldRate");
                yrc.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
            }
        }

        private void setAmtCellNumberFormat(IRow row, String format) {
            this.setNumberFormat(row, "applyLoanAmt", format);
        }

        private void setNumberFormat(IRow row, String columnKey, String format) {
            this.setNumberFormat(row, columnKey, format, true);
        }

        private void setNumberFormat(IRow row, String columnKey, String format, boolean doFormat) {
            StyleAttributes styleAttributes = row.getCell(columnKey).getStyleAttributes();
            if (doFormat) {
                styleAttributes.setNumberFormat(format);
            } else {
                String formatRate = FMClientHelper.getNumberFtm((int)5);
                styleAttributes.setNumberFormat(formatRate);
            }
            styleAttributes.setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        }
    }
}

