/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fin.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.DefaultNoteDataProvider;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.KDNoteHelper;
import com.kingdee.bos.ctrl.reportone.r1.print.data.R1PrintDataParameter;
import com.kingdee.bos.ctrl.swing.BasicFormattedTextField;
import com.kingdee.bos.ctrl.swing.IKDComponent;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDLabelContainer;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.event.CommitEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPKFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.master.account.client.AccountPromptBox;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.client.f7.NewCostCenterF7;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.cas.CashHelper;
import com.kingdee.eas.fi.cas.FundFlowDirection;
import com.kingdee.eas.fi.cas.client.CasRecPayHandler;
import com.kingdee.eas.fm.common.AccessHelper;
import com.kingdee.eas.fm.common.FMBgItemProp;
import com.kingdee.eas.fm.common.FMBudgetFacadeFactory;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.client.F7SelectorFactory;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMClientVerifyHelper;
import com.kingdee.eas.fm.fin.IntRateTypeExpressionEnum;
import com.kingdee.eas.fm.fin.LoanInfo;
import com.kingdee.eas.fm.fin.LoanInterestEntryInfo;
import com.kingdee.eas.fm.fin.LoanInterestFactory;
import com.kingdee.eas.fm.fin.LoanInterestInfo;
import com.kingdee.eas.fm.fin.RepaymentInfo;
import com.kingdee.eas.fm.fin.client.AbstractBondInterestEditUI;
import com.kingdee.eas.fm.fin.util.FinHelper;
import com.kingdee.eas.fm.im.IntCalTypeEnum;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.ma.budget.FpCashDirectionEnum;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class BondInterestEditUI
extends AbstractBondInterestEditUI {
    private static final Logger logger = CoreUIObject.getLogger(BondInterestEditUI.class);
    private boolean successFlag = false;
    private RepaymentInfo repaymentInfo;
    private LoanInfo loanInfo;
    private CompanyOrgUnitInfo CURRENT_COMPANY = null;
    private boolean isFpItemControl = false;
    IObjectPK pk1;
    public static final String LOANINTEREST_FILENAME = "/FM/IM/LOANINTEREST";

    public void onLoad() throws Exception {
        this.actionAddNew.setVisible(false);
        this.repaymentInfo = (RepaymentInfo)this.getUIContext().get("repaymentid");
        if (this.repaymentInfo != null) {
            this.CURRENT_COMPANY = this.repaymentInfo.getCompany();
        }
        this.prmtAccount.setDisplayFormat("$name$");
        this.prmtAccount.setQueryInfo("com.kingdee.eas.basedata.assistant.app.F7AccountBankQuery");
        super.onLoad();
        this.kdtEntrys.setEnabled(false);
        IColumn amountColumn = this.kdtEntrys.getColumn("amount");
        amountColumn.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        amountColumn.getStyleAttributes().setNumberFormat("%r{#,##0.00}f");
        IColumn intRateColumn = this.kdtEntrys.getColumn("intRate");
        intRateColumn.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        intRateColumn.getStyleAttributes().setNumberFormat("%r{#,##0.0000000000}f");
        IColumn beginDateColumn = this.kdtEntrys.getColumn("beginDate");
        beginDateColumn.getStyleAttributes().setNumberFormat(FMHelper.getDateFormatString());
        IColumn endDateColumn = this.kdtEntrys.getColumn("endDate");
        endDateColumn.getStyleAttributes().setNumberFormat(FMHelper.getDateFormatString());
        this.txtDays.setHorizontalAlignment(4);
        FMClientHelper.initCurrencyField((BasicFormattedTextField)this.txtIntRate);
        this.txtIntRate.setPrecision(5);
        FMClientHelper.initCurrencyField((BasicFormattedTextField)this.txtExchange);
        this.txtExchange.setPrecision(4);
        FMClientHelper.initCurrencyField((BasicFormattedTextField)this.txtAmount);
        FMClientHelper.initCurrencyField((BasicFormattedTextField)this.txtInterest);
        FMClientHelper.initCurrencyField((BasicFormattedTextField)this.txtRealInterest);
        FMClientHelper.initCurrencyField((BasicFormattedTextField)this.txtStrikeAmount);
        if (this.editData.getInterestType() != IntCalTypeEnum.PRE_INT) {
            this.isFpItemControl = ContextHelperFactory.getRemoteInstance().getBooleanParam("FIN003", (IObjectPK)new ObjectUuidPK(this.CURRENT_COMPANY.getId()));
            if (this.isFpItemControl) {
                this.prmtBgItem.setRequired(true);
            } else {
                this.prmtBgItem.setRequired(false);
            }
        }
        F7SelectorFactory.initProject((IUIObject)this, (KDBizPromptBox)this.prmtProject);
        FMClientHelper.initBgItemF7((KDBizPromptBox)this.prmtBgItem, (FpCashDirectionEnum[])new FpCashDirectionEnum[]{FpCashDirectionEnum.output, FpCashDirectionEnum.other}, (boolean)true, (boolean)true);
        FMClientHelper.initFundFlowItemF7((IUIObject)this, (KDLabelContainer)this.contBgItem, (KDLabelContainer)this.contFundFlowItem, (FundFlowDirection)FundFlowDirection.OUT);
        this.txtIntCurrencyRate.setRemoveingZeroInDispaly(false);
        this.txtIntCurrencyAmt.setRemoveingZeroInDispaly(false);
        this.txtIntCurrencyRate.setHorizontalAlignment(4);
        this.txtIntCurrencyAmt.setHorizontalAlignment(4);
        this.setCostCenter();
        this.setCreateFromInterestEnable();
        this.txtExchange.setEnabled(true);
        this.txtIntCurrencyRate.setEnabled(true);
        this.actionTDPrint.setVisible(true);
        this.actionTDPrintPreview.setVisible(true);
        this.btnTDPrint.setEnabled(true);
        this.btnTDPrintPreview.setEnabled(true);
        this.actionTDPrint.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_print"));
        this.actionTDPrintPreview.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_preview"));
    }

    private void setCostCenter() {
        NewCostCenterF7 costCenterF7 = new NewCostCenterF7((IUIObject)this);
        costCenterF7.setNeedAddOrgRange(false);
        costCenterF7.setIsCUFilter(true);
        costCenterF7.setMultiSelect(false);
        costCenterF7.setContainSealUp(false);
        costCenterF7.setCurrentCUID(this.currentCompany.getCU().getId().toString());
        int FIN018 = ContextHelperFactory.getRemoteInstance().getIntParam("FIN018", (IObjectPK)new ObjectUuidPK(this.CURRENT_COMPANY.getId()));
        if (FIN018 == 1) {
            costCenterF7.showCheckBoxOfShowingAllOUs();
            costCenterF7.setIsCUFilter(false);
        }
        this.prmtCostCenter.setSelector((KDPromptSelector)costCenterF7);
    }

    private void setCreateFromInterestEnable() throws Exception {
        if (this.editData == null || this.editData.getId() == null) {
            return;
        }
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("loanInterestBill");
        sic.add("consignLoanIntBill");
        sic.add("fundTransferIntBill");
        LoanInterestInfo info = LoanInterestFactory.getRemoteInstance().getLoanInterestInfo((IObjectPK)new ObjectUuidPK(this.editData.getId()), sic);
        if (info.getLoanInterestBill() != null || info.getConsignLoanIntBill() != null || info.getFundTransferIntBill() != null) {
            IKDComponent[] comps = new IKDComponent[]{this.pkBizDate, this.txtRealInterest, this.prmtProject, this.prmtIntCurrency, this.txtIntCurrencyRate, this.txtIntCurrencyAmt};
            FMClientHelper.setCompEnable((IKDComponent[])comps, (boolean)false);
        }
    }

    protected IObjectValue createNewDetailData(KDTable table) {
        return new LoanInterestEntryInfo();
    }

    @Override
    public void storeFields() {
        FMClientHelper.storeFieldsBgItem((KDBizPromptBox)this.prmtBgItem, (CoreBaseInfo)this.editData, (FMBgItemProp)this.editData.getBgItemProps()[0]);
        super.storeFields();
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        super.verifyInput(e);
        if (this.isFpItemControl) {
            FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDBizPromptBox)this.prmtBgItem);
        }
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDBizPromptBox)this.prmtIntCurrency);
        FMClientVerifyHelper.verifyGreaterThan((CoreUIObject)this, (KDFormattedTextField)this.txtIntCurrencyRate, (BigDecimal)Constants.ZERO);
    }

    @Override
    protected IObjectValue createNewData() {
        this.loanInfo = FinHelper.getInstance().getLoanPassByRepayment(this.repaymentInfo);
        Date startDate = this.getStartDate();
        Date endDate = this.getEndDate();
        LoanInterestInfo objectValue = null;
        try {
            objectValue = LoanInterestFactory.getRemoteInstance().calInt(startDate, endDate, this.repaymentInfo);
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        FMClientHelper.initNumber((CoreBaseInfo)objectValue, (KDTextField)this.txtNumber, (String)objectValue.getCompany().getId().toString());
        return objectValue;
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return LoanInterestFactory.getRemoteInstance();
    }

    public boolean getSuccessFlag() {
        return this.successFlag;
    }

    private Date getEndDate() {
        Calendar c = Calendar.getInstance();
        c.setTime(this.repaymentInfo.getBizDate());
        c.add(6, -1);
        return c.getTime();
    }

    private Date getStartDate() {
        Date loanStartDate = this.loanInfo.getIssueDate();
        Date lastIntDate = this.loanInfo.getLastIntDate();
        if (lastIntDate == null) {
            return loanStartDate;
        }
        return this.maxDate(loanStartDate, lastIntDate);
    }

    private Date maxDate(Date date1, Date date2) {
        int i = date1.compareTo(date2);
        switch (i) {
            case 1: {
                return date1;
            }
            case -1: {
                return date2;
            }
            case 0: {
                return date1;
            }
        }
        return date1;
    }

    @Override
    public void loadFields() {
        if (this.CURRENT_COMPANY == null) {
            this.CURRENT_COMPANY = this.editData.getCompany();
        }
        for (int i = 0; i < this.comboIntRateTypeExpression.getItemCount(); ++i) {
            if (!((IntRateTypeExpressionEnum)((Object)this.comboIntRateTypeExpression.getItemAt(i))).getValue().equals(this.editData.getIntRateTypeExpression().getValue())) continue;
            this.comboIntRateTypeExpression.setSelectedIndex(i);
            break;
        }
        Map listeners = null;
        try {
            listeners = FMClientHelper.removeCompListeners((CoreUI)this);
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
        super.loadFields();
        FMClientHelper.loadFieldsBgItem((KDBizPromptBox)this.prmtBgItem, (CoreBaseInfo)this.editData, (FMBgItemProp)this.editData.getBgItemProps()[0]);
        this.txtStrikeAmount.setValue((Object)this.editData.getStrikeAmount());
        this.kDBizPromptBox1.setValue((Object)this.editData.getAccountant());
        this.fillTable();
        try {
            FMClientHelper.addCompListeners((CoreUI)this, (Map)listeners);
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
        if (this.editData.getIntCurrency() == null) {
            this.prmtIntCurrency.setData((Object)this.editData.getCurrency());
        }
        try {
            this.setAmtPrecision();
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
        FMClientHelper.setCutValue((KDFormattedTextField)this.txtRealInterest, (Number)this.editData.getRealInterest());
    }

    protected KDTable getDetailTable() {
        return this.kdtEntrys;
    }

    private void fillTable() {
        IRow row = null;
        String currencyId = null;
        CompanyOrgUnitInfo companyInfo = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        String rateDisplay = "";
        String penaRateDisplay = "";
        currencyId = this.editData.getCurrency().getId().toString();
        for (int i = 0; i < this.kdtEntrys.getRowCount(); ++i) {
            row = this.kdtEntrys.getRow(i);
            this.setRow(row, rateDisplay, penaRateDisplay);
            if (currencyId == null) continue;
            this.setAmtCellNumberFormat(row, currencyId);
        }
    }

    private void setRow(IRow row, String rateDisplay, String penaRateDisplay) {
        BigDecimal rate = ((BigDecimal)row.getCell("intRate").getValue()).setScale(10);
        com.kingdee.eas.fm.im.IntRateTypeExpressionEnum rateExpression = (com.kingdee.eas.fm.im.IntRateTypeExpressionEnum)row.getCell("rateExpression").getValue();
        if (rateExpression == null) {
            rateExpression = this.editData.getIntRateTypeExpression();
        }
        if (com.kingdee.eas.fm.im.IntRateTypeExpressionEnum.YEAR == rateExpression) {
            row.getCell("intRateDis").getStyleAttributes().setNumberFormat("#,##0.0000000000\\%");
        } else {
            row.getCell("intRateDis").getStyleAttributes().setNumberFormat("#,##0.0000000000\\\u2030");
        }
        row.getCell("intRateDis").setValue((Object)rate);
    }

    private void setAmtCellNumberFormat(IRow row, String currencyId) {
        FMClientHelper.setNumberFormat((IRow)row, (String)"amount", (String)currencyId);
        FMClientHelper.setNumberFormat((IRow)row, (String)"interest", (String)currencyId);
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        this.checkFinalCheckout();
        this.pk1 = null;
        if (this.repaymentInfo != null) {
            this.editData.setRepaymentInfo(this.repaymentInfo);
            this.editData.setInterestType(IntCalTypeEnum.REPAY_INT);
            super.actionSubmit_actionPerformed(e);
            this.disposeUIWindow();
        } else {
            super.actionSubmit_actionPerformed(e);
        }
        if (this.pk1 != null) {
            String billId = this.pk1.toString();
            String Msg = FMBudgetFacadeFactory.getRemoteInstance().getMsgFromID(billId);
            if (Msg != null && !"".equals(Msg)) {
                MsgBox.showConfirm2((String)Msg);
            }
        }
    }

    public IObjectPK runSubmit() throws Exception {
        this.pk1 = super.runSubmit();
        return this.pk1;
    }

    protected boolean isSubmitLoad() {
        return false;
    }

    @Override
    protected void prmtIntCurrency_dataChanged(DataChangeEvent e) throws Exception {
        super.prmtIntCurrency_dataChanged(e);
        try {
            this.setAmtPrecision();
            FMClientHelper.setCutValue((KDFormattedTextField)this.txtIntCurrencyRate, (Number)this.getExRate());
            this.setTxtIntCurrencyAmt();
        }
        catch (Exception ex) {
            this.txtIntCurrencyRate.setValue((Object)Constants.ONE);
        }
    }

    private BigDecimal getExRate() throws EASBizException, BOSException {
        CurrencyInfo currencyInfo = (CurrencyInfo)this.prmtCurrency.getData();
        CurrencyInfo intCurrencyInfo = (CurrencyInfo)this.prmtIntCurrency.getData();
        if (currencyInfo == null || intCurrencyInfo == null) {
            return Constants.ONE;
        }
        if (currencyInfo.equalsPK((IObjectValue)intCurrencyInfo)) {
            return Constants.ONE;
        }
        return CashHelper.getExchange((CompanyOrgUnitInfo)this.currentCompany, (CurrencyInfo)currencyInfo, (CurrencyInfo)intCurrencyInfo);
    }

    private void setTxtIntCurrencyAmt() throws EASBizException, BOSException {
        BigDecimal rate = this.txtIntCurrencyRate.getBigDecimalValue();
        BigDecimal realInt = this.txtRealInterest.getBigDecimalValue();
        if (realInt == null) {
            return;
        }
        BigDecimal intAmt = rate.multiply(realInt);
        FMClientHelper.setCutValue((KDFormattedTextField)this.txtIntCurrencyAmt, (Number)intAmt);
    }

    private int getCurrencyPrecision(CurrencyInfo currencyInfo) throws EASBizException, BOSException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("precision"));
        CurrencyInfo newInfo = CurrencyFactory.getRemoteInstance().getCurrencyInfo((IObjectPK)new ObjectUuidPK(currencyInfo.getId()), sic);
        return newInfo.getPrecision();
    }

    @Override
    protected void txtIntCurrencyRate_dataChanged(DataChangeEvent e) throws Exception {
        super.txtIntCurrencyRate_dataChanged(e);
        this.setTxtIntCurrencyAmt();
    }

    @Override
    protected void txtRealInterest_dataChanged(DataChangeEvent e) throws Exception {
        super.txtRealInterest_dataChanged(e);
        this.setTxtIntCurrencyAmt();
    }

    private void setAmtPrecision() throws EASBizException, BOSException {
        CurrencyInfo currencyInfo = (CurrencyInfo)this.prmtCurrency.getData();
        if (currencyInfo == null) {
            return;
        }
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("precision"));
        currencyInfo = CurrencyFactory.getRemoteInstance().getCurrencyInfo((IObjectPK)new ObjectUuidPK(currencyInfo.getId()), sic);
        int precision = currencyInfo.getPrecision();
        this.txtAmount.setPrecision(precision);
        this.txtStrikeAmount.setPrecision(precision);
        this.txtInterest.setPrecision(precision);
        this.txtRealInterest.setPrecision(precision);
        CurrencyInfo intCurrencyInfo = (CurrencyInfo)this.prmtIntCurrency.getData();
        if (intCurrencyInfo == null) {
            return;
        }
        int ratePre = FMClientHelper.getExchangeRatePrec((String)currencyInfo.getId().toString(), (String)intCurrencyInfo.getId().toString());
        this.txtIntCurrencyRate.setPrecision(ratePre);
        this.txtIntCurrencyAmt.setPrecision(this.getCurrencyPrecision(intCurrencyInfo));
        boolean isSame = currencyInfo.equalsPK((IObjectValue)intCurrencyInfo);
        this.txtIntCurrencyRate.setEnabled(!isSame);
    }

    @Override
    protected void prmtCurrency_dataChanged(DataChangeEvent e) throws Exception {
        super.prmtCurrency_dataChanged(e);
        this.setAmtPrecision();
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("repayment.*"));
        sic.add(new SelectorItemInfo("repayment.id"));
        sic.add(new SelectorItemInfo("fpItem.id"));
        sic.add(new SelectorItemInfo("currency.number"));
        sic.add(new SelectorItemInfo("statusExtEnum"));
        sic.add(new SelectorItemInfo("fpItem.id"));
        sic.add(new SelectorItemInfo("fpItem.number"));
        sic.add(new SelectorItemInfo("fpItem.name"));
        sic.add(new SelectorItemInfo("currency.number"));
        sic.add(new SelectorItemInfo("intFeeAcctView.id"));
        sic.add(new SelectorItemInfo("intFeeAcctView.name"));
        sic.add(new SelectorItemInfo("intFeeAcctView.number"));
        sic.add(new SelectorItemInfo("cashier.id"));
        sic.add(new SelectorItemInfo("cashier.name"));
        sic.add(new SelectorItemInfo("cashier.number"));
        sic.add(new SelectorItemInfo("accountant.id"));
        sic.add(new SelectorItemInfo("accountant.name"));
        sic.add(new SelectorItemInfo("accountant.number"));
        sic.add(new SelectorItemInfo("project.id"));
        sic.add(new SelectorItemInfo("project.name"));
        sic.add(new SelectorItemInfo("project.number"));
        sic.add(new SelectorItemInfo("outBgItemId"));
        sic.add(new SelectorItemInfo("outBgItemName"));
        sic.add(new SelectorItemInfo("outBgItemNumber"));
        sic.add(new SelectorItemInfo("fundFlowItem.*"));
        return sic;
    }

    @Override
    public void actionViewBgBalance_actionPerformed(ActionEvent e) throws Exception {
        this.storeFields();
        LoanInterestInfo info = this.editData;
        FMClientHelper.viewBgBalance((Component)((Object)this), (String)"com.kingdee.eas.fm.fin.app.LoanInterest", null, (IObjectValue)info);
    }

    protected boolean isModifySave() {
        return false;
    }

    protected void prmtintFeeAcctView_dataChanged(DataChangeEvent e) throws Exception {
    }

    @Override
    protected void prmtintFeeAcctView_willCommit(CommitEvent e) throws Exception {
        this.setPrmtIntFeeAccountViewFilter(this.prmtintFeeAcctView);
    }

    @Override
    protected void prmtintFeeAcctView_willShow(SelectorEvent e) throws Exception {
        this.setPrmtIntFeeAccountViewFilter(this.prmtintFeeAcctView);
    }

    private void setPrmtIntFeeAccountViewFilter(KDBizPromptBox prmtintFeeAcctView) throws Exception {
        String cuId = this.CURRENT_COMPANY.getCU().getId().toString();
        String currencyId = AccessHelper.getId((Object)this.prmtCurrency.getValue());
        EntityViewInfo treeevi = CasRecPayHandler.getAccountViewEvi((String)cuId, (String)this.CURRENT_COMPANY.getId().toString(), (String)currencyId, (boolean)false);
        AccountPromptBox opseelect = new AccountPromptBox((IUIObject)this, this.CURRENT_COMPANY, treeevi.getFilter(), false, true);
        prmtintFeeAcctView.setSelector((KDPromptSelector)opseelect);
        EntityViewInfo evi = CasRecPayHandler.getAccountViewEvi((String)cuId, (String)this.CURRENT_COMPANY.getId().toString(), (String)currencyId, (boolean)true);
        prmtintFeeAcctView.setEntityViewInfo(evi);
        prmtintFeeAcctView.getQueryAgent().resetRuntimeEntityView();
    }

    protected void initAddNewStatus() {
        this.prmtAccount.setEditable(true);
        this.prmtAccount.setEnabled(true);
    }

    protected void initEditStatus() {
        this.prmtAccount.setEditable(true);
        this.prmtAccount.setEnabled(true);
    }

    @Override
    protected void prmtAccount_willCommit(CommitEvent e) throws Exception {
        this.setBankAcctFilter(this.prmtAccount);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("currency.id", (Object)AccessHelper.getId((Object)this.prmtCurrency.getValue())));
        filter.getFilterItems().add(new FilterItemInfo("currency.id", null));
        filter.getFilterItems().add(new FilterItemInfo("currency.id", (Object)AccessHelper.getId((Object)this.prmtIntCurrency.getValue())));
        filter.setMaskString("(#0 or #1 or #2)");
        this.prmtAccount.getEntityViewInfo().getFilter().mergeFilter(filter, "AND");
        this.prmtAccount.getQueryAgent().resetRuntimeEntityView();
    }

    @Override
    protected void prmtAccount_willShow(SelectorEvent e) throws Exception {
        this.setBankAcctFilter(this.prmtAccount);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("currency.id", null));
        filter.getFilterItems().add(new FilterItemInfo("currency.id", (Object)AccessHelper.getId((Object)this.prmtIntCurrency.getValue())));
        filter.setMaskString("(#0 or #1)");
        this.prmtAccount.getEntityViewInfo().getFilter().mergeFilter(filter, "AND");
        this.prmtAccount.getQueryAgent().resetRuntimeEntityView();
    }

    protected void setBankAcctFilter(KDBizPromptBox prmt) throws BOSException, EASBizException {
        prmt.getQueryAgent().resetRuntimeEntityView();
        EntityViewInfo eviprmtBankAcct = new EntityViewInfo();
        FilterInfo filterprmtBankAcct = new FilterInfo();
        if (this.CURRENT_COMPANY != null) {
            filterprmtBankAcct.getFilterItems().add(new FilterItemInfo("company.id", (Object)this.CURRENT_COMPANY.getId().toString()));
        }
        filterprmtBankAcct.getFilterItems().add(new FilterItemInfo("isClosed", (Object)Boolean.FALSE));
        eviprmtBankAcct.setFilter(filterprmtBankAcct);
        prmt.setEntityViewInfo(eviprmtBankAcct);
    }

    private void checkFinalCheckout() throws EASBizException, BOSException {
        CompanyOrgUnitInfo companyInfo = (CompanyOrgUnitInfo)SysContext.getSysContext().getCurrentCompany();
        Calendar cl = Calendar.getInstance();
        cl.setTime(this.editData.getEndDate());
        cl.add(5, 1);
        boolean canOp = FMClientHelper.checkFinalCheckout((SystemEnum)SystemEnum.IVT_MANAGE, (String)companyInfo.getId().toString(), (Date)cl.getTime());
        if (!canOp) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.recon.FmSettleResource", (String)"36_SETTLED"));
            SysUtil.abort();
        }
    }

    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        this.checkFinalCheckout();
        super.actionSave_actionPerformed(e);
    }

    @Override
    public void actionTDPrint_actionPerformed(ActionEvent e) throws Exception {
        this.loanInterestTDPrintMode(false);
    }

    protected String getClassAlise() {
        return EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"211_BondInterestEditUI");
    }

    @Override
    public void actionTDPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        this.loanInterestTDPrintMode(true);
    }

    private void loanInterestTDPrintMode(boolean isPreview) {
        this.checkSelected();
        ArrayList<String> idList = new ArrayList<String>();
        idList.add(this.editData.getId().toString());
        if (idList == null || idList.size() == 0) {
            return;
        }
        Set idSet = FMHelper.list2Set(idList);
        IMetaDataPK headPK = MetaDataPKFactory.getMetaDataPK((String)"com.kingdee.eas.fm.fin.LoanInterestHeaderTDQuery");
        DefaultNoteDataProvider dataProvider = new DefaultNoteDataProvider(idSet, headPK);
        String mainDsName = "LoanInterestHeaderTDQuery";
        dataProvider.addMetaDataPK(mainDsName, headPK);
        dataProvider.addCustomFilterMaker(mainDsName, (DefaultNoteDataProvider.ICustomFilterMaker)new DefaultNoteDataProvider.DefaultIdFilterMaker(idSet));
        String entryDsName = "LoanInterestEntryTDQuery";
        IMetaDataPK entryPK = MetaDataPKFactory.getMetaDataPK((String)"com.kingdee.eas.fm.fin.LoanInterestEntryTDQuery");
        dataProvider.addMetaDataPK(entryDsName, entryPK);
        dataProvider.addForeignKey((Object)entryDsName, "parentId");
        dataProvider.addCustomFilterMaker(entryDsName, new DefaultNoteDataProvider.ICustomFilterMaker(){

            public void customize(FilterInfo filter, R1PrintDataParameter[] params) {
            }
        });
        dataProvider.setBatchSupported(true);
        dataProvider.setNumberOfEachBatch(100);
        KDNoteHelper helper = new KDNoteHelper();
        if (isPreview) {
            helper.printPreview(LOANINTEREST_FILENAME, (Object)dataProvider, (Component)((Object)this));
        } else {
            helper.print(LOANINTEREST_FILENAME, (Object)dataProvider, (Component)((Object)this));
        }
    }
}

